#ifndef _math_defs_h_
#define _math_defs_h_

#include "math_consts.h"

#ifdef MAX
#undef MAX
#endif

#ifdef MIN
#undef MIN
#endif

#ifdef ODD
#undef ODD
#endif

#ifdef ABS
#undef ABS
#endif

#ifdef SGN
#undef SGN
#endif

/* some useful macros... */
#define MAX(a,b)      ((a) > (b) ? (a) : (b))
#define MIN(a,b)      ((a) > (b) ? (b) : (a))
#define ODD(a)        ((a) &1)
#define ABS(a)        (((a) < 0) ? (-(a)) : (a))
#define SGN(a)        (((a) < 0) ? (-1) : ((a) != 0))

#define iszero(a) 		(a == ZERO)
#define isnonzero(a)	(a != ZERO)
#define isnegative(a) (a < ZERO)
#define ispositive(a)	(a > ZERO)

/* DEG to RAD and viceversa */
#define RAD(x) ((x * PI) / 180.0)
#define DEG(x) ((x * 180.0) / PI)

// EXPERIMENTAL (ver. 1.3.5)
typedef enum
{
  ANGLE_DEG,
  ANGLE_RAD,
  ANGLE_GRAD
}
angle_t;

struct number
{
  double value;
  angle_t angle;
};

#endif /* _math_defs_h_ */
