// TODO: anything less than EPSILON is considered zero
// TODO: functions that compares double vars
// TODO: correct bugs :)
#include <math.h>
#include "defines.h"
#include "math_defs.h"
#include "math_consts.h"
#include "math_library.h"
#include "errors.h"


double
M_deg (double x)
{
  /* to degree ... */
  return DEG (x);
}

double
M_rad (double x)
{
  /* to radiants ... */
  return RAD (x);
}


double
M_sqrn (double x, double y)
{
  /* x^(1/y) */
  if (iszero (x))
    return ZERO;

  if (((int) y % 2) == 0)
    {
      if (isnegative (x))
	parser_throw_error (ERROR_NEGARG, "");
      else
	return (exp (M_inv (y) * log (x)));
    }

  if (ispositive (x))
    return (exp (M_inv (y) * log (x)));
  else
    return -(exp (M_inv (y) * log (-x)));
}

double
M_log (double x)
{

  if (isnegative (x))
    parser_throw_error (ERROR_NEGARG, "");

  if (iszero (x))
    parser_throw_error (ERROR_NULLARG, "");

  return (log (x));
}

double
M_log10 (double x)
{

  if (isnegative (x))
    parser_throw_error (ERROR_NEGARG, "");

  if (iszero (x))
    parser_throw_error (ERROR_NULLARG, "");

  return (log10 (x));
}

double
M_arcsin (double x)
{

  if ((x > 1) || (x < -1))
    parser_throw_error (ERROR_DOMAIN, "");

  return asin (RAD (x));
}

double
M_arccos (double x)
{

  if ((x > 1) || (x < -1))
    parser_throw_error (ERROR_DOMAIN, "");

  return acos (RAD (x));
}

double
M_arctan (double x)
{
  return atan (RAD (x));
}

double
M_sin (double x)
{
  return sin (RAD (x));
}

double
M_cos (double x)
{

  return cos (RAD (x));
}

double
M_tan (double x)
{
// if ((fabs (x - 0.0001)) > EPSILON)
//    parser_throw_error (ERROR_DOMAIN, "");

  return tan (x);
}

double
M_sinh (double x)
{
  return sinh (x);
}

double
M_cosh (double x)
{
  return cosh (x);
}

double
M_tanh (double x)
{
  return tanh (x);
}

double
M_asinh (double x)
{
  return asinh (x);
}

double
M_acosh (double x)
{
  if (x < 1)
    parser_throw_error (ERROR_DOMAIN, "");

  return acosh (x);
}

double
M_atanh (double x)
{
  if (M_abs (x) > 1)
    parser_throw_error (ERROR_DOMAIN, "");

  return atanh (x);
}


double
M_exp (double x)
{
  if (iszero (x))
    return 1.0;
  else
    return (exp (x));
}

double
M_expn (double x, double n)
{
  return exp (x * M_log (n));
}

double
M_floor (double x)
{
  if (iszero (x))
    return ZERO;
  else
    return floor (x);
}

double
M_ceil (double x)
{
  if (iszero (x))
    return ZERO;
  else
    return ceil (x);
}

double
M_abs (double x)
{
  if (iszero (x))
    return ZERO;
  else
    return fabs (x);
}

double
M_nfat (double x)
{
  /* calculate n! (iterative version) */
  register double f = 1.0;
  register int i;

  if (x <= 1.0)
    return 1.0;
  else
    {
      for (i = 1; i <= x; i++)
	f = f * (double) i;

      return f;
    }
}

double
M_sum (double x)
{
  /* sums firsts x numbers with Gauss formula */
  if (x < 1)
    parser_throw_error (ERROR_NEGARG, "");

  return ((x + 1) * (x / 2));
}

double
M_max (double a, double b)
{
  if (fabs (a - b) < EPSILON)
    return b;
  else
    return a;
}

double
M_min (double a, double b)
{
  if (fabs (a - b) < EPSILON)
    return a;
  else
    return b;
}

double
M_inv (double x)
{
  /* perform 1/x */
  if (iszero (x))
    parser_throw_error (ERROR_DIVZERO, "");

  return (1 / x);
}

double
M_hypot (double x, double y)
{
  /* return the hypotenuse of the triangle with x, y as catet */
  return (hypot (x, y));
}


double
M_log2 (double x)
{

  if (isnegative (x))
    parser_throw_error (ERROR_NEGARG, "");

  if (iszero (x))
    parser_throw_error (ERROR_NULLARG, "");

  return (log (x) / LN2);
}


double
M_sign (double x)
{
/* defined as :
     1    				if x > 0
     sgn(x) = 0   if x = 0
     -1   				if x < 0
*/

  if (isnegative (x))
    return -1.0;
  else if (ispositive (x))
    return 1.0;
  else
    return ZERO;
}

double
M_mcd (double x, double y)
{
  double rem;

  while (isnonzero (y))
    {
      rem = drem (x, y);
      x = y;
      y = rem;
    }

  return x;
}
