// TODO: a configuration file with the absolute modules path
#include <dlfcn.h>
#include "defines.h"
#include "writer.h"
#include "module.h"
#include "module_management.h"

#define MODULE_PREFIX_DIR	"/usr"
#define SAMPLE_MODULE		"./spar_sample_module.so"

int 
module_run (const char *filename)
{
  module_function_t get_module;
  void *handle;

  if ((handle = dlopen (filename, RTLD_NOW)) == NULL) {
        writeln (HEADER_ERROR "failed to load module: %s.", dlerror());
        return 1;
  }

  dlerror();

  if ((get_module = dlsym (handle, "get_module")) == NULL) {
        writeln (HEADER_ERROR "failed to module structure: %s.", dlerror());
        return 1;
  }
  else {
    struct module *m = get_module ();
    module_management_init ();

    module_management_add_module (m);
    module_management_module_info (m);
	
    return m->__module_main();
  }
}

int
main (void)
{
  return module_run (SAMPLE_MODULE);
}
