// TODO: create a function that init the parser (token init, error init...)
// TODO: to avoid memory seg faults use this
//              if (strlen(iden) > MAX_IDEN_LEN)
//                      progname[MAX_IDEN_LEN] = '\0';
#include <math.h>
#include <setjmp.h>
#include <string.h>
#include "defines.h"
#include "writer.h"
#include "vartable.h"
#include "funcs.h"
#include "errors.h"
#include "math_consts.h"
#include "math_defs.h"
#include "util.h"
#include "chartypes.h"

typedef enum
{
  TOKEN_TYPE_ALPHA,		/* token is a function or variable name */
  TOKEN_TYPE_DELIM,		/* token is a delimitator               */
  TOKEN_TYPE_NUMBER		/* token is a number                    */
}
token_type;

// TODO: convert to struct
static int type;
static identifier (token);

char *expression;
extern jmp_buf jb;

/* internal functions */
static void parser_next_token (void);
static int parser_is_a_identifier (const char[]);
static int parser_level0 (const char[], double *, int *);
static int parser_level1 (double *);
static void parser_level2 (double *);
static void parser_level3 (double *);
static void parser_level4 (double *);
static void parser_level5 (double *);
static void parser_level6 (double *);

int
parser_evaluate (const char str[])
{
  int rc, assign;
  double result;

  assert (str);

  memset (token, 0, IDENTIFIER_LENGHT);
  rc = parser_level0 (str, &result, &assign);

  switch (rc)
    {
    case NO_ERROR:
      if (!assign)
	writeln ("%s = %g", str, result);
      return FUNCTION_SUCCESS;

    case ERROR_COUNT:
    default:
      return ERROR_COUNT;
    }

}

double
parser_evaluate_to_double (const char str[])
{
  int assign;
  double result;

  assert (str);
  memset (token, 0, IDENTIFIER_LENGHT);
  (void) parser_level0 (str, &result, &assign);

  return result;
}

static int
parser_level0 (const char ete[], double *result, int *assg)
{
  /* if any parser error occurcs jump here */
  if (setjmp (jb))
    return ERROR_COUNT;

  expression = (char *) ete;
  *result = 0.0;

  /* gets the first token */
  parser_next_token ();

  if ((strlen (token)) > 0)
    *assg = parser_level1 (result);

  return NO_ERROR;
}

static int
parser_level1 (double *r)
{
  identifier (t);

  if (type == TOKEN_TYPE_ALPHA)
    if (*expression == '=')
      {
	strcpy (t, token);
	parser_next_token ();
	parser_next_token ();

	parser_level2 (r);
	parser_set_value (t, *r);

	return 1;
      }

  parser_level2 (r);

  return 0;
}


static void
parser_level2 (double *r)
{
  double t = ZERO;
  char o;

  parser_level3 (r);

  while ((o = *token) == '+' || o == '-')
    {
      parser_next_token ();
      parser_level3 (&t);

      switch (o)
	{
	case '+':
	  *r = *r + t;
	  break;

	case '-':
	  *r = *r - t;
	  break;
	}
    }

  return;
}

static void
parser_level3 (double *r)
{
  double t = ZERO;
  char o;

  parser_level4 (r);

  while ((o = *token) == '*' || o == '/' || o == '%')
    {
      parser_next_token ();
      parser_level4 (&t);

      switch (o)
	{
	case '*':
	  *r = *r * t;
	  break;

	case '/':
	  if (iszero (t))
	    parser_throw_error (ERROR_DIVZERO, token);

	  *r = *r / t;
	  break;

	case '%':
	  {
	    if (iszero (t))
	      parser_throw_error (ERROR_DIVZERO, token);

	    *r = drem (*r, t);

	    break;
	  }
	}
    }

  return;
}


static void
parser_level4 (double *r)
{
  double t = ZERO;

  parser_level5 (r);

  if (*token == '^')
    {
      parser_next_token ();
      parser_level5 (&t);
      *r = pow (*r, t);
    }

  return;
}


static void
parser_level5 (double *r)
{
  static char o = '0';

  if (*token == '+' || *token == '-')
    {
      o = *token;
      parser_next_token ();
    }

  parser_level6 (r);

  if (o == '-')
    *r = -*r;

  return;
}


static void
parser_level6 (double *r)
{
  if (*token == '(')
    {
      parser_next_token ();

      if (*token == ')')
	parser_throw_error (ERROR_NOARG, token);

      parser_level1 (r);

      if (*token != ')')
	parser_throw_error (ERROR_UNBALAN, token);

      parser_next_token ();
    }
  else
    {
      // TODO: use a switch and test
      if (type == TOKEN_TYPE_NUMBER)
	{
	  parser_todouble (token, r);
	  parser_next_token ();
	}
      else if (type == TOKEN_TYPE_ALPHA)
	{
	  if (*expression == '(')
	    {
	      int fnc_code = parser_check_function (token);

	      if (fnc_code != SYMBOL_NOT_FOUND)
		{
		  function_args_t n = 0;
		  double arg[3] = { ZERO, ZERO, ZERO };

		  parser_next_token ();

		  do
		    {
		      parser_next_token ();

		      switch (*token)
			{
			case ')':
			  arg[n] = 0;
			  break;

			case ',':
			  arg[n] = 0;
			  break;

			default:
			  break;
			}

		      if (*token == ')' || *token == ',')
			arg[n] = 0;
		      parser_level1 (&arg[n]);
		      n++;
		    }

		  while (n < 3 && *token == ',');

		  while ((*token) != ')')
		    {
		      if (*token == '(')
			parser_throw_error (ERROR_UNBALAN, token);

		      parser_next_token ();

		      if (*token != ')')
			parser_throw_error (ERROR_UNBALAN, token);
		    }

		  if (n != (parser_get_function_argc (fnc_code)))

		    {
		      strcpy (token, (parser_get_function_name (fnc_code)));
		      parser_throw_error (ERROR_NUMARGS, token);
		    }

		  *r = parser_run_function (fnc_code, arg);
		  return;
		}
	      else
		parser_throw_error (ERROR_BADFUNC, token);
	    }
	  else
	    {
	      double t;

	      if (parser_get_value (token, &t))
		parser_throw_error (ERROR_UNKNOWN, token);
	      else
		*r = t;

	      return;
	    }
	}
      else
	parser_throw_error (ERROR_SYNTAX, token);
    }
  return;
}


// TODO: return the token
static void
parser_next_token (void)
{
  char *t;
  register int iden_len = 0;	/* identifier length */

  /* token init */
  type = 0;
  t = token;

  while (isblank (*expression) == 1)
    expression++;

  if (isdelim (*expression) == 1)
    {
      type = TOKEN_TYPE_DELIM;

      *t++ = *expression++;
    }
  else if (isnumber (*expression) == 1)
    {
      type = TOKEN_TYPE_NUMBER;

      while (isnumber (*expression))
	{
	  *t++ = *expression++;
	  if (isalpha (*expression) == 1)
	    parser_throw_error (ERROR_SYNTAX, expression);
	}
    }
  else if (isalpha (*expression) == 1)
    {
      type = TOKEN_TYPE_ALPHA;

      while (isalpha (*expression) == 1 || isnumber (*expression) == 1)
	{
	  iden_len += 1;

	  if (iden_len >= IDENTIFIER_LENGHT)
	    parser_throw_error (ERROR_IDENF, token);

	  *t++ = *expression++;
	}
      if (parser_is_a_identifier (t) == 0)
	parser_throw_error (ERROR_SYNTAX, t);
    }
  else if (*expression != '\0')
    {
      *t++ = *expression++;
      *t = '\0';
      parser_throw_error (ERROR_SYNTAX, token);
    }

  *t = '\0';
  while (isblank (*expression) == 1)
    expression++;

  return;
}

int
parser_is_a_identifier (const char iden[])
{
  return !(isnumber (iden[0]));
}
