#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <math.h>

#ifdef HAVE_STRERROR
#include <string.h>
#endif

#include "math_consts.h"
#include "math_defs.h"
#include "errors.h"
#include "vartable.h"

char *
parser_strerror (int errnum)
{
#ifdef HAVE_STRERROR
  return strerror (errnum);
#else
  static char buf[64];
  snprintf (buf, sizeof (buf),
	    "error %d (compiled without strerror)", errnum);
  return buf;
#endif
}


void
parser_todouble (char *token, double *r)
{
#ifdef HAVE_STRTOD
  register double dval = ZERO;
  char *ep;
#endif
  /* set to zero errno */
  errno = 0;

  /* string to number (double representation) convertion */
#ifdef HAVE_STRTOD
  dval = strtod (token, &ep);

  /* check for any errors... */
  if (dval == ZERO)
    {
      /* check errno */
      if (errno == ERANGE)
	parser_throw_error (ERROR_RANGE, token);
      else
	{
	  /* no errors... */
	  *r = ZERO;
	  return;
	}
    }
  else if (dval == +HUGE_VAL)
    {
      /* check errno */
      if (errno == ERANGE)
	parser_throw_error (ERROR_RANGE, token);
      else
	{
	  /* no errors... */
	  *r = +HUGE_VAL;
	  return;
	}
    }
  else if (dval == -HUGE_VAL)
    {
      /* check errno */
      if (errno == ERANGE)
	parser_throw_error (ERROR_RANGE, token);
      else
	{
	  /* no errors... */
	  *r = -HUGE_VAL;
	  return;
	}
    }
  else
    {
      /* set *r to dval (that is correct) */
      *r = dval;

      return;
    }
#else
  *r = atof (token);
#endif

  return;
}

void
parser_clean_memory (void)
{
  parser_clear_vars_table ();
//  module_clean_tree ();
}

int
parser_get_random_int (double top)
{
  return (1 + (int) (top * rand () / (RAND_MAX + 1.0)));
}
