// TODO: change the functions name
// write may conflicts with unistd.h!
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <assert.h>

static void writer_internal (const char *, va_list, const char *);

void
write (const char *fmt, ...)
{
  va_list ap;

  assert (fmt);
  va_start (ap, fmt);
  writer_internal (fmt, ap, NULL);
  va_end (ap);
}

void
writeln (const char *fmt, ...)
{
  va_list ap;

  assert (fmt);
  va_start (ap, fmt);
  writer_internal (fmt, ap, NULL);
  va_end (ap);
  puts ("");
}

void
writef (const char *file, const char *fmt, ...)
{
  va_list ap;

  assert (fmt);
  assert (file);

  va_start (ap, fmt);
  writer_internal (fmt, ap, file);
  va_end (ap);
}

void
writefln (const char *file, const char *fmt, ...)
{
  va_list ap;

  assert (fmt);
  assert (file);

  va_start (ap, fmt);
  writer_internal (fmt, ap, file);
  va_end (ap);
  puts ("");
}

/* 64k, should be enough for anyone :)) */
#define VSN_BUF_SIZE (1024)

static void
writer_internal (const char *fmt, va_list ap, const char *filename)
{
  char buffer[VSN_BUF_SIZE];

  int c = vsnprintf (buffer, VSN_BUF_SIZE, fmt, ap);
  buffer[c] = '\0';

  if (filename != NULL)
    {
      FILE *file;

      if ((file = fopen (filename, "w")) != NULL)
	{
	  fputs (buffer, file);
	  fclose (file);
	}
      else
	fputs ("Failed to open log file.", stderr);
    }
  else
    fputs (buffer, stderr);

  // flush everything
  fflush (NULL);
  return;

}

static struct precision
{
  int integer;
  int decimal;
}
precision;

void
writer_set_precision (int d, int i)
{
  if (d < 0)
    d = -d;

  if (i < 0)
    i = -i;

  precision.decimal = d;
  precision.integer = i;
}

void
precision_fmt (char *buf)
{
  char _buf[30];

  sprintf (_buf, "-%d.%dg", precision.integer, precision.decimal);

  strcpy (buf, "%");
  strcat (buf, _buf);
}

void
write_number (double n)
{
  char buf[40];
  char prec[40];

  precision_fmt (prec);
  sprintf (buf, prec, n);
  puts (buf);
}
