 /* File: FRONTPORT.H **E ** These are routines that assist in porting programs from UN*X or NT  **E ** They are consist of new routines that are not present in the DEC C L ** runtime library, or wrappers that give extended functionality that is not ** present but needed. **D ** If the symbol FRONTPORT_HIDE_DECC is defined to 1, then the DEC C ** routines will be hidden.  **H ** If the symbol FRONTPORT_STREAM_UNIXIO is defined to 1, then the DEC CA ** routines read(), write(), fsync(), and lseek() will be hidden.  ** ** 19-Mar-1999	J. Malmberg@ ** 30-Sep-2000	J. Malmberg	Must use nam.h instead of namdef.h or, **				routines that include nam.h later will$ **				not compile on OpenVMS VAX 7.1 **N *****************************************************************************/N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/ #ifndef _FRONTPORT_H #define _FRONTPORT_H   # ifdef __cplusplus  extern "C" { # endif    #include <builtins.h>     *  /* Get the standard C prototypes first */) /*-------------------------------------*/  #ifndef _VMS_V6_SOURCE #define _VMS_V6_SOURCE 1 #endif   #include <sys/types.h> #include <stdarg.h>  #include <stdio.h> #include <dirent.h>  #include <unixio.h>  #include <unistd.h>  #include <utime.h> #include <timeb.h> #include <time.h>  #include <fcntl.h> #include <pwd.h> #include <nam.h> #include <descrip.h>    /* Maximum size of a string */  /*--------------------------*/ #ifndef NAML$C_MAXRSS  #define NAML$C_MAXRSS 4095 #endif   #ifdef __VAX #define FPORT__C_MAXRSS 256  #else  #define FPORT__C_MAXRSS 4096 #endif  6  /* Convert 64 bit NT time to/from  64 bit VMS time */5 /*-------------------------------------------------*/ B void fport__nt_time_to_vms(void * vms_time, const void * nt_time);  B void fport__vms_time_to_nt(void * nt_time, const void * vms_time);  ?  /* DEC C does not provide a unix time_t to VMS time routine */ > /*----------------------------------------------------------*/B void fport__unix_time_t_to_vms(void * vms_time, time_t unix_time);    +  /* Replacements for standard C routines */ * /*--------------------------------------*/  ?  /* stat and password stuff first, as needs special handling */ > /*----------------------------------------------------------*/      /* stat functions */  /*----------------*/ #ifdef FRONTPORT_HIDE_DECC   #ifdef stat  #undef stat  #endif  1 #define stat(__p1, __p2)  fport__stat(__p1, __p2)    #ifdef fstat #undef fstat #endif  2 #define fstat(__p1, __p2) fport__fstat(__p1, __p2)   #endif /* HIDE_DECC */     #include <sys/stat.h>    #pragma __nostandard #pragma __message __save+ #pragma __message __disable (__MISALGNDMEM) ! #pragma __member_alignment __save  #pragma __nomember_alignment #ifdef FRONTPORT_INT_DEV_T# typedef unsigned long fport__dev_t;  #else  typedef char * fport__dev_t; #endif  # typedef unsigned short short_gid_t;    #ifdef FRONTPORT_UNX_INO_T# typedef unsigned long fport__ino_t;  #else    #ifdef FRONTPORT_VMS_INO_T typedef struct {>     unsigned short num;  /* Offset into the file INDEXF.SYS */K     unsigned short seq;  /* Number of times a that "num" has been reused */ 5     unsigned short rvn;  /* Relative Volume Number */  } fport__ino_t;  #endif  ! #endif /* FRONTPORT_UNIX_INO_T */    typedef struct fport__stat_st {  	fport__dev_t	st_dev;  #ifdef FRONTPORT_UNX_INO_T 	fport__ino_t	st_ino;  	unsigned short	st_rvn;  #else    #ifdef FRONTPORT_VMS_INO_T 	fport__ino_t	st_ino;  #else  	ino_t		st_ino[3];  #endif /* FRONTPORT_VMS_INO_T */! #endif /* FRONTPORT_UNIX_INO_T */  	mode_t		st_mode;  	nlink_t		st_nlink;  	uid_t		st_uid;  	short_gid_t	st_gid;# 	dev_t		st_rdev;		/* always zero */  	off_t		st_size; 	time_t		st_atime; 	time_t		st_mtime; 	time_t		st_ctime; 	char		st_fab_rfm; 	char		st_fab_rat; 	char		st_fab_fsz; 	unsigned int	st_fab_mrs;  } fport__stat_t;$ #pragma __member_alignment __restore #pragma __message __restore   : int fport__stat(const char *__path, fport__stat_t *__buf);6 int fport__fstat(int file_desc, fport__stat_t *__buf);     #ifdef FRONTPORT_HIDE_DECC #ifdef statvfs #undef statvfs #endif #define statvfs fport__statvfs #ifdef fstatvfs  #undef fstatvfs  #endif  #define fstatvfs fport__fstatvfs #endif #ifdef HAVE_SYS_STATVFS_H  #include <sys/statvfs.h> #else  #include <statvfs.h> #endif@ int fport__statvfs(const char * filespec, struct statvfs * buf);2 int fport__fstatvfs(int fd, struct statvfs * buf);  G unsigned long fport__vms_statvfs(char * devname, struct statvfs * buf);    #ifdef FRONTPORT_HIDE_DECC   #ifdef daylight  #undef daylight  #endif  #define daylight fport__daylight   #ifdef timezone  #undef timezone  #endif  #define timezone fport__timezone  
 #ifdef tzname 
 #undef tzname  #endif #define tzname fport__tzname   #endif /* HIDE_DECC */   #pragma __extern_model __save < #pragma __extern_model __strict_refdef "fport__public" noshr extern int fport__daylight;  extern long fport__timezone; extern char * fport__tzname[2];   #pragma __extern_model __restore   #ifdef FRONTPORT_HIDE_DECC
 #ifdef passwd 
 #undef passwd  #endif  #define passwd  fport__passwd_st #endif /* HIDE_DECC */   #ifdef FRONTPORT_HIDE_DECC #ifdef getpass #undef getpass #endif #define getpass fport__getpass #endif /* HIDE_DECC */$ char * fport__getpass(const char *);   #ifdef FRONTPORT_HIDE_DECC #ifdef getpwnam  #undef getpwnam  #endif! #define getpwnam  fport__getpwnam  #endif /* HIDE_DECC */A struct fport__passwd_st * fport__getpwnam(const char * username);      #ifdef FRONTPORT_HIDE_DECC #ifdef getpwuid  #undef getpwuid  #endif  #define getpwuid fport__getpwuid #endif /* HIDE_DECC */1 struct fport__passwd_st * fport__getpwuid(uid_t);   "  /* A fake crypt implementation */! /*-----------------------------*/ = char * fport__vms_crypt(const char * key, const char * salt);      #pragma message save# #pragma message disable misalgndmem ! #pragma __member_alignment __save % #pragma __nomember_alignment longword    /* The passwd structure.  */ struct fport__passwd_st { #   char *pw_name;			/* Username.  */ "   uid_t pw_uid;				/* User ID.  */'   short_gid_t pw_gid;			/* Group ID. */ )   char *pw_dir;				/* Home directory.  */ )   char *pw_shell;			/* Shell program.  */ 7   char *pw_passwd;			/* Password.  [Not in DECC RTL] */ 6   char *pw_gecos;			/* Real name. [Not in DECC RTL] */9   unsigned long pw_vms_passwd[2];	/* VMS password hash */ ;   unsigned long pw_vms_expire[2];	/* VMS Expiration time */ 7   unsigned long *pw_vms_userdata;	/* User data area? */ .   unsigned long pw_vms_flags;		/* VMS flags */>   unsigned char pw_vms_net_pri[3];	/* Primary day hour mask */:   unsigned char pw_vms_net_sec[3];	/* Seconday day mask */'   unsigned long pw_vms_primedays;	/* */ 6   unsigned char pw_vms_encrypt;		/* Encryption type */)   unsigned short pw_vms_salt;		/* Salt */ :   unsigned char pw_vms_pwd_len;		/* Length of password? */ };$ #pragma __member_alignment __restore #pragma message restore    #ifdef FRONTPORT_HIDE_DECC #ifdef chdir #undef chdir #endif #define chdir  fport__chdir  #endif /* HIDE_DECC */& int fport__chdir(const char * __path);  8 unsigned long fport__check_disk_type(const char * path);   #ifdef FRONTPORT_HIDE_DECC #ifdef chmod #undef chmod #endif #define chmod fport__chmod #endif /* HIDE_DECC */0 int fport__chmod(const char *file, mode_t mode);   #ifdef FRONTPORT_HIDE_DECC #ifdef chown #undef chown #endif #define chown fport__chown #endif /* HIDE_DECC */C int fport__chown(const char *file, uid_t owner, short_gid_t group);    #ifdef FRONTPORT_HIDE_DECC #ifdef close #undef close #endif #define close fport__close #endif /* HIDE_DECC */ int fport__close(int filedesc);      #pragma message save# #pragma message disable misalgndmem ! #pragma __member_alignment __save % #pragma __nomember_alignment longword  struct fport__dirent { #ifdef FRONTPORT_UNX_INO_T 	fport__ino_t	d_ino; 	unsigned short	d_rvn; #else    #ifdef FRONTPORT_VMS_INO_T 	fport__ino_t	d_ino; #else  	ino_t		d_ino[3];   #endif /* FRONTPORT_VMS_INO_T */! #endif /* FRONTPORT_UNIX_INO_T */ !     char d_name[FPORT__C_MAXRSS];  };   struct fport__dir_st {     unsigned long context;     unsigned long find_flags; <     long int count;		/* Number of entries returned so far */     unsigned long file_opts;     char template[6]; 9     char path[FPORT__C_MAXRSS]; /* Path to be searched */ #     struct fport__dirent st_dirent;  };$ #pragma __member_alignment __restore #pragma message restore   ( typedef struct fport__dir_st FPORT__DIR;   #ifdef FRONTPORT_HIDE_DECC #ifdef closedir  #undef closedir  #endif
 #ifdef dirent 
 #undef dirent  #endif #define dirent fport__dirent  #define closedir fport__closedir
 #ifdef DIR
 #undef DIR #endif #define DIR FPORT__DIR #endif /* HIDE_DECC */' int fport__closedir(FPORT__DIR * dirp);      #ifdef FRONTPORT_HIDE_DECC #ifdef dlclose #undef dlclose #endif #define dlclose fport__dlclose #endif /* HIDE_DECC */# void fport__dlclose(void * handle);      #ifdef FRONTPORT_HIDE_DECC #ifdef dlerror #undef dlerror #endif #define dlerror fport__dlerror #endif /* HIDE_DECC */ char * fport__dlerror(void);     #ifdef FRONTPORT_HIDE_DECC
 #ifdef dlopen 
 #undef dlopen  #endif #define dlopen fport__dlopen #endif /* HIDE_DECC */6 void * fport__dlopen(const char * pathname, int mode);     #ifdef FRONTPORT_HIDE_DECC #ifdef dlsym #undef dlsym #endif #define dlsym fport__dlsym #endif /* HIDE_DECC */0 void * fport__dlsym(void * handle, char * name);     #ifdef FRONTPORT_HIDE_DECC #ifdef creat #undef creat #endif #define creat fport__creat #endif /* HIDE_DECC */0 int fport__creat(const char *file, mode_t mode);   #ifdef FRONTPORT_HIDE_DECC #ifdef ctime #undef ctime #endif #define ctime fport__ctime #endif /* HIDE_DECC */$ char * fport__ctime(const time_t *);   #ifdef FRONTPORT_HIDE_DECC
 #ifdef delete	
 #undef delete  #endif #define delete fport__delete #endif /* HIDE_DECC */$ int fport__delete(const char *file);   #ifdef FRONTPORT_HIDE_DECC
 #ifdef unlink/
 #undef unlink= #endif #define unlink fport__delete #endif /* HIDE_DECC */     #ifdef FRONTPORT_HIDE_DECC
 #ifdef dup
 #undef dup #endif #define dup fport__dup #endif /* HIDE_DECC */ int fport__dup(int filedesc);    #ifdef FRONTPORT_HIDE_DECC #ifdef dup2l #undef dup2s #endif #define dup2 fport__dup2 #endif /* HIDE_DECC */. int fport__dup2(int filedesc1, int filedesc2);   #ifdef FRONTPORT_HIDE_DECC
 #ifdef fcloseg
 #undef fcloset #endif #define fclose fport__fclose #endif /* HIDE_DECC */" int fport__fclose(FILE * fileptr);   #ifdef FRONTPORT_HIDE_DECC #ifdef fcntl #undef fcntl #endif #define fcntl fport__fcntl #endif /* HIDE_DECC */+ int fport__fcntl(int __fd, int __cmd, ...);e   #ifdef FRONTPORT_HIDE_DECC
 #ifdef fdopen*
 #undef fdopenh #endif #define fdopen fport__fdopen #endif3 FILE * fport__fdopen(int file_desc, char * a_mode);0   #ifdef FRONTPORT_HIDE_DECC #ifdef fgetname= #undef fgetname= #endif  #define fgetname fport__fgetname #endif6 char * fport__fgetname(FILE * fileptr, char * buffer);   #ifdef FRONTPORT_HIDE_DECC
 #ifdef fileno 
 #undef filenon #endif #define fileno fport__fileno #endif /* HIDE_DECC */" int fport__fileno(FILE * fileptr);   #ifdef FRONTPORT_HIDE_DECC #ifdef fopen #undef fopen #endif #define fopen fport__fopen #endif /* HIDE_DECC */< FILE * fport__fopen(const char  *file, const char * a_mode);   #ifdef FRONTPORT_HIDE_DECC #ifdef freopen #undef freopen #endif #define freopen fport__freopen #endif /* HIDE_DECC */N FILE * fport__freopen(const char  *file, const char * a_mode, FILE * fileptr);   #ifdef FRONTPORT_HIDE_DECC #ifdef ftruncate #undef ftruncate #endif" #define ftruncate fport__ftruncate #endif /* HIDE_DECC */4 int fport__ftruncate(int __filedes, off_t __length);   #ifdef FRONTPORT_HIDE_DECC #ifdef ftime #undef ftime #endif #define ftime fport__ftime #endif /* HIDE_DECC */) void fport__ftime(struct timeb *timeptr);v   #ifdef FRONTPORT_HIDE_DECC
 #ifdef getcwd 
 #undef getcwdp #endif #define getcwd fport__getcwd #endif /* HIDE_DECC */) char * fport__getcwd(char * buf, size_t);-    1  /* Make translating logical names from C easy */e0 /*--------------------------------------------*/4 char * fport__getenv_trnlnm(const char * name, ...);      G    /* Hack, hack hack.  To map the group functions in UNIX to VMS,   */-F   /*  A 32 bit unsigned gid_t must be used.  This will cause all    */E  /*   sorts of problems, so we attempt to use long_gid_t as a hack */fD /*----------------------------------------------------------------*/ #include <grp.h>! typedef unsigned long long_gid_t;    #ifdef FRONTPORT_HIDE_DECC #ifdef getgrgidp #undef getgrgidI #endif  #define getgrgid fport__getgrgid #endif /* HIDE_DECC */+ struct group * fport__getgrgid(long_gid_t);i     #ifdef FRONTPORT_HIDE_DECC #ifdef getgroups #undef getgroups #endif# #define getgroups  fport__getgroupsV #endif /* HIDE_DECC */( int fport__getgroups(int, long_gid_t *);   #ifdef FRONTPORT_HIDE_DECC #ifdef getgrnams #undef getgrnami #endif! #define getgrnam  fport__getgrnaml #endif /* HIDE_DECC */2 struct group * fport__getgrnam(const char * user);     #ifdef FRONTPORT_HIDE_DECC #ifdef getname #undef getname #endif #define getname fport__getname #endif /* HIDE_DECC */4 char * fport__getname(int file_desc, char * buffer);   #ifdef FRONTPORT_HIDE_DECC
 #ifdef getopte
 #undef getoptR #endif #define getopt fport__getopt #endif /* HIDE_DECC */I int fport__getopt(int argc, char * const argv[], const char * optstring);e   #ifdef FRONTPORT_HIDE_DECC #ifdef gettimeofdayO #undef gettimeofdayi #endif( #define gettimeofday fport__gettimeofday #endif /* HIDE_DECC */; int fport__gettimeofday(struct timeval *__tp, void *__tzp);t     #ifdef FRONTPORT_HIDE_DECC
 #ifdef gmtime;
 #undef gmtimee #endif #define gmtime fport__gmtime #endif /* HIDE_DECC */0 struct tm * fport__gmtime(const time_t * timer);     #ifdef FRONTPORT_HIDE_DECC #ifdef kills #undef kill  #endif #define kill fport__kill #endif /* HIDE_DECC */" int fport__kill(int pid, int sig);     #ifdef FRONTPORT_HIDE_DECC #ifdef localtime #undef localtime #endif" #define localtime fport__localtime #endif /* HIDE_DECC */3 struct tm * fport__localtime(const time_t * timer);s   #ifdef FRONTPORT_HIDE_DECC #ifdef mkdir #undef mkdir #endif #define mkdir fport__mkdir #endif /* HIDE_DECC */5 int fport__mkdir(const char * dir_spec, mode_t mode);t   #ifdef FRONTPORT_HIDE_DECC
 #ifdef mktime 
 #undef mktimev #endif #define mktime fport__mktime #endif /* HIDE_DECC */* time_t fport__mktime(struct tm * timeptr);  - unsigned long fport__vms_support_flags(void);r   #ifdef FRONTPORT_HIDE_DECC #ifdef openD #undef opend #endif #define open fport__open #endif /* HIDE_DECC */3 int fport__open(const char * file, int flags, ...);    #ifdef FRONTPORT_HIDE_DECC #ifdef opendir #undef opendir #endif #define opendir fport__opendir #endif /* HIDE_DECC */2 FPORT__DIR * fport__opendir(const char * dirname);   #ifdef FRONTPORT_HIDE_DECC #ifdef readdir #undef readdir #endif #define readdir fport__readdir #endif /* HIDE_DECC */9 struct fport__dirent * fport__readdir(FPORT__DIR * dirp);    #ifdef FRONTPORT_HIDE_DECC
 #ifdef remove 
 #undef remove  #endif #define remove fport__remove #endif /* HIDE_DECC */# #define fport__remove fport__deleted   #ifdef FRONTPORT_HIDE_DECC
 #ifdef renamee
 #undef renamet #endif #define rename fport__rename #endif /* HIDE_DECC */> int fport__rename(const char * oldname, const char * newname);   #ifdef FRONTPORT_HIDE_DECC #ifdef rewinddir #undef rewinddir #endif" #define rewinddir fport__rewinddir #endif /* HIDE_DECC */) void fport__rewinddir(FPORT__DIR * dirp);i   #ifdef FRONTPORT_HIDE_DECC #ifdef rmdir #undef rmdir #endif #define rmdir fport__rmdir #endif /* HIDE_DECC */' int fport__rmdir(const char * dirname);      #ifdef FRONTPORT_HIDE_DECC #ifdef seekdir #undef seekdir #endif #define seekdir fport__seekdir #endif /* HIDE_DECC */5 void fport__seekdir(FPORT__DIR * dirp, long int loc);a     #ifdef FRONTPORT_HIDE_DECC
 #ifdef setgidp
 #undef setgidr #endif #define setgid fport__setgid #ifdef setegid #undef setegid #endif #define setegid fport__setgida #endif /* HIDE_DECC */$ int fport__setgid(long_gid_t __gid);   #ifdef FRONTPORT_HIDE_DECC
 #ifdef setuid/
 #undef setuidy #endif #define setuid fport__setuid #ifdef seteuid #undef seteuid #endif #define seteuid fport__setuid  #endif /* HIDE_DECC */ int fport__setuid(uid_t __uid);      #ifdef FRONTPORT_HIDE_DECC
 #ifdef system 
 #undef systemi #endif #define system fport__system #endif( int fport__system(const char * command);   #ifdef FRONTPORT_HIDE_DECC
 #ifdef getuidv
 #undef getuidM #endif #define getuid fport__getuid #ifdef geteuid #undef geteuid #endif #define geteuid fport__getuid; #endif /* HIDE_DECC */ uid_t fport__getuid(void);   #ifdef FRONTPORT_HIDE_DECC
 #ifdef getgidt
 #undef getgidn #endif #define getgid fport__getgid #ifdef getegid #undef getegid #endif #define getegid fport__getgid  #endif /* HIDE_DECC */  short_gid_t fport__getgid(void);  $ short_gid_t fport__getgid_set(void);     #ifdef FRONTPORT_HIDE_DECC #ifdef telldir #undef telldir #endif #define telldir fport__telldir #endif /* HIDE_DECC */+ long int fport__telldir(FPORT__DIR * dirp);c     #ifdef FRONTPORT_HIDE_DECC #ifdef timeE #undef timem #endif #define time fport__time #endif /* HIDE_DECC */# time_t fport__time(time_t * timer);c     #ifdef FRONTPORT_HIDE_DECC #ifdef truncateT #undef truncatef #endif  #define truncate fport__truncate #endif /* HIDE_DECC */; int fport__truncate(const char * filename, off_t __length);r   #ifdef FRONTPORT_HIDE_DECC #ifdef tzset #undef tzset #endif #define tzset fport__tzset #endif /* HIDE_DECC */ void fport__tzset(void);   #ifdef FRONTPORT_HIDE_DECC #ifdef utime #undef utime #endif #define utime fport__utime #endif /* HIDE_DECC */F int fport__utime(const char * __path, const struct utimbuf * __times);   #ifdef FRONTPORT_HIDE_DECC #ifdef umask #undef umask #endif #define umask fport__umask #endif /* HIDE_DECC */! mode_t fport__umask(mode_t mask);t   #ifdef FRONTPORT_HIDE_DECC #ifdef vsnprintf #undef vsnprintf #endif# #define vsnprintf  fport__vsnprintfX #endif /* HIDE_DECC */  K int fport__vsnprintf(char * str, size_t n, const char *format, va_list ap);o   #ifdef FRONTPORT_HIDE_DECC #ifdef snprintf  #undef snprintfn #endif! #define snprintf  fport__snprintf  #endif /* HIDE_DECC */  C int fport__snprintf(char * str, size_t n, const char *format, ...);     !  /* Assists for Read and Write */o  /*----------------------------*/ #ifdef FRONTPORT_STREAM_UNIXIO   #ifdef fsync #undef fsync #endif   #ifdef lseek #undef lseek #endif   #ifdef readr #undef readd #endif   #ifdef write #undef write #endif   #define fsync fport__fsync   #define lseek fport__lseek   #define read fport__read   #define write fport__write   #endif  > off_t fport__lseek(int filedesc, off_t offset, int direction);   int fport__fsync(int filedesc);d  @ ssize_t fport__read(int filedesc, void * buffer, size_t nbytes);  G ssize_t fport__write(int filedesc, const void * buffer, size_t nbytes);d    ! void fport__report_version(void);r    ;  /* LIB_READLINE similation - Guess based on SAMBA usage */ : /*------------------------------------------------------*/ #ifdef FRONTPORT_HIDE_DECC #ifdef HIST_ENTRYf #undef HIST_ENTRYo #endif$ #define HIST_ENTRY FPORT__HIST_ENTRY   #ifdef history_listT #undef history_listf #endif( #define history_list fport__history_list   #ifdef readlineI #undef readline* #endif  #define readline fport__readline   #ifdef add_history #undef add_history #endif& #define add_history fport__add_history   #endif  $ typedef struct fport__hist_entry_st{9     char line[1024]; /* Arbitrary Practical limitation */C } FPORT__HIST_ENTRY;    . FPORT__HIST_ENTRY **fport__history_list(void);  2 char * fport__readline(const char * __prompt_str);  - void fport__add_history(const char * __line);d         /* Special routines */  /*------------------*//    5  /* Gets a vms channel for stdin if stdin is a TTY */d4 /*------------------------------------------------*/' unsigned short fport__stdin_chan(void);e    % unsigned long fport__set_file_modtimeH        (const char * filespec, 	const unsigned long * date);p  & /* void fport__analyze_fname(void); */   int fport__unix_fname_to_vms= 	(char * vmsfile, const char * unixfile, unsigned long opts);f void fport__vms_fname_to_unix = 	(char * unixfile, const char * vmsfile, unsigned long opts);O   int fport__unix_fname_to_pwrk > 	(char * pwrkfile, const char * unixfile, unsigned long opts); void fport__pwrk_fname_to_unix> 	(char * unixfile, const char * pwrkfile, unsigned long opts);    C int fport__unix_dev_translate(char * vmsdev, const char * unixdev);n  L int fport__vms_dev_translate(char * unixdev, const char * vmsdev, char sep);  ; void fport__set_unix_device_prefix(const char * devprefix);   B int fport__vms_dir_to_fname(char * vmsfile, const char * vmspath);  - unsigned long fport__get_fname_options(void);e  5 void fport__set_fname_options(unsigned long options);   : void fport__set_template_prefix(const char * templprefix);     struct fport__attr_st {f, 	/* need a size or version tag for sanity */ 	/* need the owner field */I$     mode_t st_mode;		/* Stat mode */4     off_t st_size;		/* Best guess about file size */)     char st_fab_rfm;		/* Record Format */f-     char st_fab_rat;		/* Record Attributes */e-     char st_fab_fsz;		/* Fixed header size */i
     char pad;H6     unsigned int st_fab_mrs;	/* Maximum record size */:     unsigned long vms_ctime[2];	/* VMS file create time */@     unsigned long vms_mtime[2]; /* VMS file modification time */:     unsigned long vms_btime[2]; /* VMS file backup time */>     char display_name[256];	/* The case preserved file name */4     char rfm[256];		/* DEC C extension parameters */     char fsz[256];     char rat[256];     char mrs[256]; };  ! void fport__get_default_file_attrf        (char * vfilename,/ 	const char * ufilename,! 	struct fport__attr_st * __attr);O  , unsigned long fport__get_stat_options(void);4 void fport__set_stat_options(unsigned long options);  @ mode_t fport__get_acl_mode(const char * filename, mode_t umode);  B mode_t fport__get_samba_mode(const char * filename, mode_t umode);  @ void fport__set_samba_mode(const char * filename, mode_t umode);  / mode_t fport__samba_to_unix_chmod(mode_t mode);f  @ /* mode_t fport__set_samba_umask(mode_t umode, mode_t smode); */    6  /* Get the size of the file name translation cache */5 /*-------------------------------------------------*/-& int fport__get_fname_cache_size(void);  6  /* Set the size of the file name translation cache */5 /*-------------------------------------------------*/g6 void fport__set_fname_cache_size(unsigned long csize);      /* Debugger assist routines */  /*--------------------------*/" void fport__print_fstat(int __fd);, void fport__print_file_stat(FILE * fileptr); int fport__print_errno(void);t! void fport__print_procinfo(void);/  " #if 0 /* Future fun for someone */( int fport__unix_fname_to_multinet(void);) void fport__multinet_fname_to_unix(void);n$ int fport__ods5_fname_to_unix(void);% void fport__unix_fname_to_ods5(void);e$ int fport__ods5_fname_to_pwrk(void);% void fport__pwrk_fname_to_ods5(void);u   #endif% void fport__set_global_options(void);a    uid_t fport__get_root_uid(void);& void fport__set_root_uid(uid_t alias);- uid_t fport__convert_uid_to_root(uid_t test);p- uid_t fport__convert_root_to_uid(uid_t test);t  , unsigned long fport___get_current_uic(void);- unsigned long fport___get_original_uic(void);      #pragma __standard   # ifdef __cplusplusd }g # endifa  % #define FPORT__M_FNAME_EXTLASTDOT (1) J /* #define FPORT__M_FNAME_DEEPDIR (2) */ /* Removed from implementation */  ! #define FPORT__M_FNAME_MSDOS (32)z #define FPORT__M_FNAME_UNIX (0)E= #define FPORT__M_FNAME_VERSION (64)	/* Not yet implemented */t   #define FPORT__M_FNAME_PWRK (4)t; #define FPORT__M_FNAME_ODS5 (8)		 /* Not yet implemented */O? #define FPORT__M_FNAME_MULTINET (16)	 /* Not yet implemented */lB #define FPORT__M_FNAME_CASE_MEYER (128)  /* Not yet implemented */@ #define FPORT__M_FNAME_CASE_ACE (256)	 /* Not yet implemented */D #define FPORT__M_FNAME_TILDE (512)	/* Leading ~ is not SYS$LOGIN: */B #define FPORT__M_FNAME_DIRECTORY (1024)  /* This is a directory */L #define FPORT__M_FNAME_DUNDER (2048)	/* If set, mangle double underscores */P #define FPORT__M_FNAME_LOGICAL_LIST (4096) /* This is logical list of devices */I #define FPORT__M_FNAME_DEVICE_LIST (8192) /* This is a list of devices */     #define FPORT__M_STAT_USEACL (1)J #define FPORT__M_STAT_SAMBA (2)	  /* Mangle protection fields for SAMBA */0 #define FPORT__M_STAT_SET_SAMBA_READONLY_LIE (4)0 #define FPORT__M_STAT_SET_SAMBA_READONLY_ACE (8)/ #define FPORT__M_STAT_SET_SAMBA_SYSTEM_LIE (16)// #define FPORT__M_STAT_SET_SAMBA_SYSTEM_ACE (32)./ #define FPORT__M_STAT_SET_SAMBA_HIDDEN_ACE (64)r& #define FPORT__M_STAT_FCNTL_LOCK (128)& #define FPORT__M_STAT_SWAP_CTIME (256)  < #define FPORT__M_VMS_EFS (1)		/* VMS version supports EFS */H #define FPORT__M_VMS_DEEPDIR (2)	/* VMS version supports 255 dir lvsl */  A #define FPORT__M_DISK_NODEV (1)		/* This is not a known device */tB #define FPORT__M_DISK_NOFILE (2)	/* This is not file structured */: #define FPORT__M_DISK_ODS5 (4)		/* This is an ODS5 disk */   #endif