 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */  /*-  * Copyright (c) 1990, 1993, 1994, 1995, 1996 &  *	Keith Bostic.  All rights reserved.  */  /*'  * Copyright (c) 1990, 1993, 1994, 1995 E  *	The Regents of the University of California.  All rights reserved.   *@  * This code is derived from software contributed to Berkeley by  * Mike Olson.  *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   */    #include "config.h"    #ifndef lintJ static const char sccsid[] = "@(#)bt_compare.c	10.14 (Sleepycat) 10/9/98"; #endif /* not lint */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <string.h>  #endif   #include "db_int.h"  #include "db_page.h" #include "btree.h"   /*  * __bam_cmp -- #  *	Compare a key to a given record.   *0  * PUBLIC: int __bam_cmp __P((DB *, const DBT *,E  * PUBLIC:    PAGE *, u_int32_t, int (*)(const DBT *, const DBT *)));   */  int " __bam_cmp(dbp, dbt, h, indx, func)	 	DB *dbp;  	const DBT *dbt;	 	PAGE *h;  	u_int32_t indx;, 	int (*func)__P((const DBT *, const DBT *)); {  	BINTERNAL *bi;  	BKEYDATA *bk; 	BOVERFLOW *bo;  	DBT pg_dbt;	 	int ret;    	/*  	 * Returns: 	 *	< 0 if dbt is < page record  	 *	= 0 if dbt is = page record  	 *	> 0 if dbt is > page record  	 *  	 * !!! E 	 * We do not clear the pg_dbt DBT even though it's likely to contain C 	 * random bits.  That should be okay, because the app's comparison E 	 * routine had better not be looking at fields other than data/size. D 	 * We don't clear it because we go through this path a lot and it's 	 * expensive. 	 */5 	if (TYPE(h) == P_LBTREE || TYPE(h) == P_DUPLICATE) {  		bk = GET_BKEYDATA(h, indx); % 		if (B_TYPE(bk->type) == B_OVERFLOW)  			bo = (BOVERFLOW *)bk; 		else { 			pg_dbt.data = bk->data; 			pg_dbt.size = bk->len;  			return (func(dbt, &pg_dbt));  		} 	 	} else {  		/*? 		 * The following code guarantees that the left-most key on an = 		 * internal page at any level of the btree is less than any A 		 * user specified key.  This saves us from having to update the A 		 * leftmost key on an internal page when the user inserts a new = 		 * key in the tree smaller than anything we've seen before.  		 */ 0 		if (indx == 0 && h->prev_pgno == PGNO_INVALID) 			return (1);   		bi = GET_BINTERNAL(h, indx);% 		if (B_TYPE(bi->type) == B_OVERFLOW)   			bo = (BOVERFLOW *)(bi->data); 		else { 			pg_dbt.data = bi->data; 			pg_dbt.size = bi->len;  			return (func(dbt, &pg_dbt));  		}  	}   	/* 
 	 * Overflow.  	 *  	 * XXX E 	 * We ignore __db_moff() errors, because we have no way of returning 	 	 * them.  	 */ 	(void) __db_moff(dbp,H 	    dbt, bo->pgno, bo->tlen, func == __bam_defcmp ? NULL : func, &ret); 	return (ret); }    /*  * __bam_defcmp --  *	Default comparison routine.  *<  * PUBLIC: int __bam_defcmp __P((const DBT *, const DBT *));  */  int  __bam_defcmp(a, b) 	const DBT *a, *b; {  	size_t len; 	u_int8_t *p1, *p2;    	/*  	 * Returns: 	 *	< 0 if a is < b  	 *	= 0 if a is = b  	 *	> 0 if a is > b  	 *  	 * XXX E 	 * If a size_t doesn't fit into a long, or if the difference between F 	 * any two characters doesn't fit into an int, this routine can lose.E 	 * What we need is a signed integral type that's guaranteed to be at ; 	 * least as large as a size_t, and there is no such thing.  	 */- 	len = a->size > b->size ? b->size : a->size; 4 	for (p1 = a->data, p2 = b->data; len--; ++p1, ++p2) 		if (*p1 != *p2) " 			return ((long)*p1 - (long)*p2);( 	return ((long)a->size - (long)b->size); }    /*  * __bam_defpfx --  *	Default prefix routine.  *?  * PUBLIC: size_t __bam_defpfx __P((const DBT *, const DBT *));   */  size_t __bam_defpfx(a, b) 	const DBT *a, *b; {  	size_t cnt, len;  	u_int8_t *p1, *p2;   	 	cnt = 1; - 	len = a->size > b->size ? b->size : a->size; ; 	for (p1 = a->data, p2 = b->data; len--; ++p1, ++p2, ++cnt)  		if (*p1 != *p2)  			return (cnt);   	/* @ 	 * We know that a->size must be <= b->size, or they wouldn't be 	 * in this order. 	 */4 	return (a->size < b->size ? a->size + 1 : a->size); }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       