 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */  /*-  * Copyright (c) 1990, 1993, 1994, 1995, 1996 &  *	Keith Bostic.  All rights reserved.  */  /*'  * Copyright (c) 1990, 1993, 1994, 1995 E  *	The Regents of the University of California.  All rights reserved.   *@  * This code is derived from software contributed to Berkeley by  * Mike Olson.  *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   */    #include "config.h"    #ifndef lintI static const char sccsid[] = "@(#)bt_delete.c	10.43 (Sleepycat) 12/7/98";  #endif /* not lint */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <string.h>  #endif   #include "db_int.h"  #include "db_page.h" #include "btree.h"   /*  * __bam_delete --(  *	Delete the items referenced by a key.  *D  * PUBLIC: int __bam_delete __P((DB *, DB_TXN *, DBT *, u_int32_t));  */  int " __bam_delete(dbp, txn, key, flags)	 	DB *dbp; 
 	DB_TXN *txn; 
 	DBT *key; 	u_int32_t flags;  {  	BOVERFLOW *bo;  	CURSOR *cp;
 	DBC *dbc; 	DBT dkey, ddata; 	 	PAGE *h;  	db_indx_t cnt, i, indx;% 	int dpage, exact, ret, stack, t_ret;    	DB_PANIC_CHECK(dbp);    	/* Check for invalid flags. */  	if ((ret = D 	    __db_delchk(dbp, key, flags, F_ISSET(dbp, DB_AM_RDONLY))) != 0) 		return (ret);    	/* Allocate a cursor. */ < 	if ((ret = dbp->cursor(dbp, txn, &dbc, DB_WRITELOCK)) != 0) 		return (ret); 8 	DEBUG_LWRITE(dbc, txn, "bam_delete", key, NULL, flags);   	cp = dbc->internal; 	stack = 0;   F 	/* Search the tree for the key; delete only deletes exact matches. */D 	if ((ret = __bam_search(dbc, key, S_DELETE, 1, NULL, &exact)) != 0) 		goto err;  	stack = 1;  	h = cp->csp->page;  	indx = cp->csp->indx;   	/* F 	 * Delete the key/data pair, including any on-or-off page duplicates.F 	 * If this isn't an off-page duplicate set, or there are currently noE 	 * cursors walking through the off-page duplicates, we do the delete F 	 * here without further work.  Alternatively, we have to walk throughD 	 * the off-page duplicates, marking/deleting each item.  The latterD 	 * is infinitely slower, and could be a performance problem at some
 	 * point. 	 */& 	bo = GET_BOVERFLOW(h, indx + O_INDX);' 	if (B_TYPE(bo->type) == B_DUPLICATE && 3 	    __bam_ca_delete(dbp, h->pgno, indx, 1) != 0) { A 		/* Set the cursor to reference the first off-page duplicate. */  		cp->pgno = h->pgno;  		cp->indx = indx; 		cp->dpgno = bo->pgno;  		cp->dindx = 0;   		/*> 		 * We're going to walk a cursor through the duplicate chain,? 		 * deleting as we go.  Set DB_DBT_USERMEM, as this might be a ? 		 * threaded application and the flags checking will catch us. @ 		 * We don't want the actual keys or data, so request a partial 		 * of length 0.  		 */ ! 		memset(&dkey, 0, sizeof(dkey)); 0 		F_SET(&dkey, DB_DBT_USERMEM | DB_DBT_PARTIAL);# 		memset(&ddata, 0, sizeof(ddata)); 1 		F_SET(&ddata, DB_DBT_USERMEM | DB_DBT_PARTIAL);    		/* Delete duplicates... */ 		for (;;) {' 			if ((ret = dbc->c_del(dbc, 0)) != 0) 
 				goto err; 
 			if ((ret = 9 			    dbc->c_get(dbc, &dkey, &ddata, DB_NEXT_DUP)) != 0)  				if (ret == DB_NOTFOUND) { 
 					ret = 0;  					break; 
 				} else 					goto err; 		}    		dpage = 0;	 	} else { 7 		/* Find out how many on-page duplicates there are. */ # 		for (cnt = 1, i = indx;; ++cnt) {  			i += P_INDX; 4 			if (i >= NUM_ENT(h) || h->inp[i] != h->inp[indx])
 				break; 		}    		/* Delete them. */ 		for (; cnt > 0; --cnt) { 			/* 	 			 * XXX 8 			 * Delete the key item first, otherwise the duplicate) 			 * checks in __bam_ditem() won't work!  			 */. 			if ((ret = __bam_ditem(dbc, h, indx)) != 0)
 				goto err; . 			if ((ret = __bam_ditem(dbc, h, indx)) != 0)
 				goto err;  		}   , 		/* If the page is now empty, delete it. */2 		dpage = NUM_ENT(h) == 0 && h->pgno != PGNO_ROOT; 	}  I 	/* If we're using record numbers, update internal page record counts. */ F 	if (F_ISSET(dbp, DB_BT_RECNUM) && (ret = __bam_adjust(dbc, -1)) != 0) 		goto err;    	/* E 	 * Release the stack (we may need to acquire another one during page 
 	 * deletion.  	 */ 	__bam_stkrel(dbc, 0); 	stack = 0;   ) 	ret = dpage ? __bam_dpage(dbc, key) : 0;    err:	if (stack)  		__bam_stkrel(dbc, 0);    	/* Discard the cursor. */2 	if ((t_ret = dbc->c_close(dbc)) != 0 && ret == 0) 		ret = t_ret;   	return (ret); }    /*  * __bam_ditem -- *  *	Delete one or more entries from a page.  *;  * PUBLIC: int __bam_ditem __P((DBC *, PAGE *, u_int32_t));   */  int  __bam_ditem(dbc, h, indx) 
 	DBC *dbc;	 	PAGE *h;  	u_int32_t indx; {  	BINTERNAL *bi;  	BKEYDATA *bk; 	BOVERFLOW *bo; 	 	DB *dbp;  	u_int32_t nbytes;	 	int ret;    	dbp = dbc->dbp;   	switch (TYPE(h)) {  	case P_IBTREE:  		bi = GET_BINTERNAL(h, indx); 		switch (B_TYPE(bi->type)) {  		case B_DUPLICATE:  		case B_OVERFLOW:$ 			nbytes = BINTERNAL_SIZE(bi->len); 			bo = (BOVERFLOW *)bi->data; 			goto offpage; 		case B_KEYDATA: $ 			nbytes = BINTERNAL_SIZE(bi->len);	 			break; 
 		default:% 			return (__db_pgfmt(dbp, h->pgno));  		}  		break; 	case P_IRECNO:  		nbytes = RINTERNAL_SIZE; 		break; 	case P_LBTREE:  		/*? 		 * If it's a duplicate key, discard the index and don't touch  		 * the actual page item. 		 * 		 * XXX? 		 * This works because no data item can have an index matching A 		 * any other index so even if the data item is in a key "slot", $ 		 * it won't match any other index. 		 */  		if ((indx % 2) == 0) { 			/* 8 			 * Check for a duplicate after us on the page.  NOTE:8 			 * we have to delete the key item before deleting the: 			 * data item, otherwise the "indx + P_INDX" calculation 			 * won't work!  			 *// 			if (indx + P_INDX < (u_int32_t)NUM_ENT(h) && - 			    h->inp[indx] == h->inp[indx + P_INDX])  				return (__bam_adjindx(dbc,$ 				    h, indx, indx + O_INDX, 0)); 			/* 6 			 * Check for a duplicate before us on the page.  It8 			 * doesn't matter if we delete the key item before or7 			 * after the data item for the purposes of this one.  			 */9 			if (indx > 0 && h->inp[indx] == h->inp[indx - P_INDX])  				return (__bam_adjindx(dbc,$ 				    h, indx, indx - P_INDX, 0)); 		}  		/* FALLTHROUGH */  	case P_LRECNO:  		bk = GET_BKEYDATA(h, indx);  		switch (B_TYPE(bk->type)) {  		case B_DUPLICATE:  		case B_OVERFLOW: 			nbytes = BOVERFLOW_SIZE;  			bo = GET_BOVERFLOW(h, indx);   0 offpage:		/* Delete duplicate/offpage chains. */) 			if (B_TYPE(bo->type) == B_DUPLICATE) {t 				if ((ret =3 				    __db_ddup(dbc, bo->pgno, __bam_free)) != 0)  					return (ret);	 			} else, 				if ((ret =3 				    __db_doff(dbc, bo->pgno, __bam_free)) != 0)  					return (ret);	 			break;9 		case B_KEYDATA:T# 			nbytes = BKEYDATA_SIZE(bk->len);o	 			break;r
 		default:% 			return (__db_pgfmt(dbp, h->pgno));s 		}r 		break;	 	default:e$ 		return (__db_pgfmt(dbp, h->pgno)); 	}   	/* Delete the item. */i3 	if ((ret = __db_ditem(dbc, h, indx, nbytes)) != 0)r 		return (ret);h   	/* Mark the page dirty. */*1 	return (memp_fset(dbp->mpf, h, DB_MPOOL_DIRTY));s }e   /*  * __bam_adjindx --*  *	Adjust an index on the page.n  *M  * PUBLIC: int __bam_adjindx __P((DBC *, PAGE *, u_int32_t, u_int32_t, int));c  */  int 1 __bam_adjindx(dbc, h, indx, indx_copy, is_insert)n
 	DBC *dbc;	 	PAGE *h;m 	u_int32_t indx, indx_copy;o 	int is_insert;t {a	 	DB *dbp;  	db_indx_t copy;	 	int ret;    	dbp = dbc->dbp;   	/* Log the change. */ 	if (DB_LOGGING(dbc) && A 	    (ret = __bam_adj_log(dbp->dbenv->lg_info, dbc->txn, &LSN(h), ; 	    0, dbp->log_fileid, PGNO(h), &LSN(h), indx, indx_copy,i! 	    (u_int32_t)is_insert)) != 0)  		return (ret);    	if (is_insert) {y 		copy = h->inp[indx_copy];u 		if (indx != NUM_ENT(h))e1 			memmove(&h->inp[indx + O_INDX], &h->inp[indx],r0 			    sizeof(db_indx_t) * (NUM_ENT(h) - indx)); 		h->inp[indx] = copy; 		++NUM_ENT(h);H	 	} else {N 		--NUM_ENT(h);A 		if (indx != NUM_ENT(h))O1 			memmove(&h->inp[indx], &h->inp[indx + O_INDX],,0 			    sizeof(db_indx_t) * (NUM_ENT(h) - indx)); 	}   	/* Mark the page dirty. */ . 	ret = memp_fset(dbp->mpf, h, DB_MPOOL_DIRTY);   	/* Adjust the cursors. */5 	__bam_ca_di(dbp, h->pgno, indx, is_insert ? 1 : -1);L 	return (0); }T   /*  * __bam_dpage --N  *	Delete a page from the tree.T  *5  * PUBLIC: int __bam_dpage __P((DBC *, const DBT *));   */T int  __bam_dpage(dbc, key) 
 	DBC *dbc; 	const DBT *key; {R 	CURSOR *cp;	 	DB *dbp;N 	DB_LOCK lock;	 	PAGE *h;I 	db_pgno_t pgno;: 	int level;		/* !!!: has to hold number of tree levels. */ 	int exact, ret;   	dbp = dbc->dbp; 	cp = dbc->internal;	 	ret = 0;S   	/*AE 	 * The locking protocol is that we acquire locks by walking down thec) 	 * tree, to avoid the obvious deadlocks.  	 *9E 	 * Call __bam_search to reacquire the empty leaf page, but this timeyE 	 * get both the leaf page and it's parent, locked.  Walk back up thecE 	 * tree, until we have the top pair of pages that we want to delete.tE 	 * Once we have the top page that we want to delete locked, lock theDD 	 * underlying pages and check to make sure they're still empty.  If 	 * they are, delete them. 	 */$ 	for (level = LEAFLEVEL;; ++level) {. 		/* Acquire a page and its parent, locked. */ 		if ((ret =B 		    __bam_search(dbc, key, S_WRPAIR, level, NULL, &exact)) != 0) 			return (ret);   		/*= 		 * If we reach the root or the page isn't going to be empty % 		 * when we delete one record, quit._ 		 */b 		h = cp->csp[-1].page; . 		if (h->pgno == PGNO_ROOT || NUM_ENT(h) != 1)	 			break;   % 		/* Release the two locked pages. */)1 		(void)memp_fput(dbp->mpf, cp->csp[-1].page, 0);b* 		(void)__BT_TLPUT(dbc, cp->csp[-1].lock);0 		(void)memp_fput(dbp->mpf, cp->csp[0].page, 0);) 		(void)__BT_TLPUT(dbc, cp->csp[0].lock);s 	}   	/*(E 	 * Leave the stack pointer one after the last entry, we may be aboute$ 	 * to push more items on the stack. 	 */ 	++cp->csp;-   	/* F 	 * cp->csp[-2].page is the top page, which we're not going to delete,B 	 * and cp->csp[-1].page is the first page we are going to delete. 	 *lD 	 * Walk down the chain, acquiring the rest of the pages until we'veD 	 * retrieved the leaf page.  If we find any pages that aren't goingF 	 * to be emptied by the delete, someone else added something while we9 	 * were walking the tree, and we discontinue the delete.e 	 */ 	for (h = cp->csp[-1].page;;) {  		if (ISLEAF(h)) { 			if (NUM_ENT(h) != 0)P 				goto release;P	 			break;  		} else 			if (NUM_ENT(h) != 1)i 				goto release;	   		/*A 		 * Get the next page, write lock it and push it onto the stack.o@ 		 * We know it's index 0, because it can only have one element. 		 */  		pgno = TYPE(h) == P_IBTREE ?< 		    GET_BINTERNAL(h, 0)->pgno : GET_RINTERNAL(h, 0)->pgno;  B 		if ((ret = __bam_lget(dbc, 0, pgno, DB_LOCK_WRITE, &lock)) != 0) 			goto release;5 		if ((ret = memp_fget(dbp->mpf, &pgno, 0, &h)) != 0)  			goto release;# 		BT_STK_PUSH(cp, h, 0, lock, ret);  	}  ; 	/* Adjust back to reference the last page on the stack. */S 	BT_STK_POP(cp);   	/* Delete the pages. */ 	return (__bam_dpages(dbc));   release:; 	/* Adjust back to reference the last page on the stack. */	 	BT_STK_POP(cp);  + 	/* Discard any locked pages and return. */r 	__bam_stkrel(dbc, 0);   	return (ret); }k   /*  * __bam_dpages --   *	Delete a set of locked pages.  *)  * PUBLIC: int __bam_dpages __P((DBC *));   */g intr __bam_dpages(dbc) 
 	DBC *dbc; {  	CURSOR *cp;	 	DB *dbp;o
 	DBT a, b; 	DB_LOCK c_lock, p_lock;
 	EPG *epg; 	PAGE *child, *parent; 	db_indx_t nitems; 	db_pgno_t pgno; 	db_recno_t rcnt;> 	int done, ret;r   	dbp = dbc->dbp; 	cp = dbc->internal; 	epg = cp->sp;   	/*	 	 * !!! G 	 * There is an interesting deadlock situation here.  We have to relinkhE 	 * the leaf page chain around the leaf page being deleted.  ConsiderbG 	 * a cursor walking through the leaf pages, that has the previous pagexE 	 * read-locked and is waiting on a lock for the page we're deleting. H 	 * It will deadlock here.  This is a problem, because if our process isD 	 * selected to resolve the deadlock, we'll leave an empty leaf pageH 	 * that we can never again access by walking down the tree.  So, before9 	 * we unlink the subtree, we relink the leaf page chain.u 	 */H 	if ((ret = __db_relink(dbc, DB_REM_PAGE, cp->csp->page, NULL, 1)) != 0) 		goto release;=   	/*?7 	 * We have the entire stack of deletable pages locked._ 	 *lE 	 * Delete the highest page in the tree's reference to the underlyingcE 	 * stack of pages.  Then, release that page, letting the rest of theb 	 * tree get back to business. 	 */; 	if ((ret = __bam_ditem(dbc, epg->page, epg->indx)) != 0) {,$ release:	(void)__bam_stkrel(dbc, 0); 		return (ret);  	}   	pgno = epg->page->pgno; 	nitems = NUM_ENT(epg->page);L  ) 	(void)memp_fput(dbp->mpf, epg->page, 0); " 	(void)__BT_TLPUT(dbc, epg->lock);   	/*d( 	 * Free the rest of the stack of pages. 	 *_ 	 * !!! F 	 * Don't bother checking for errors.  We've unlinked the subtree fromE 	 * the tree, and there's no possibility of recovery outside of doing  	 * TXN rollback.* 	 */ 	while (++epg <= cp->csp) {e 		/*< 		 * Delete page entries so they will be restored as part of 		 * recovery. 		 */_ 		if (NUM_ENT(epg->page) != 0)0 			(void)__bam_ditem(dbc, epg->page, epg->indx);  # 		(void)__bam_free(dbc, epg->page);	# 		(void)__BT_TLPUT(dbc, epg->lock);h 	} 	BT_STK_CLR(cp);   	/**@ 	 * Try and collapse the tree a level -- this is only applicableA 	 * if we've deleted the next-to-last element from the root page.n 	 *h/ 	 * There are two cases when collapsing a tree.a 	 *nG 	 * If we've just deleted the last item from the root page, there is no F 	 * further work to be done.  The code above has emptied the root page! 	 * and freed all pages below it.a 	 */& 	if (pgno != PGNO_ROOT || nitems != 1)
 		return (0);'   	/* D 	 * If we just deleted the next-to-last item from the root page, theE 	 * tree can collapse one or more levels.  While there remains only a	E 	 * single item on the root page, write lock the last page referenced G 	 * by the root page and copy it over the root page.  If we can't get amG 	 * write lock, that's okay, the tree just stays deeper than we'd like.  	 */ 	for (done = 0; !done;) {x 		/* Initialize. */I 		parent = child = NULL;! 		p_lock = c_lock = LOCK_INVALID;    		/* Lock the root. */ 		pgno = PGNO_ROOT;s 		if ((ret == 		    __bam_lget(dbc, 0, pgno, DB_LOCK_WRITE, &p_lock)) != 0) 
 			goto stop;A: 		if ((ret = memp_fget(dbp->mpf, &pgno, 0, &parent)) != 0)
 			goto stop;O   		if (NUM_ENT(parent) != 1 ||t= 		    (TYPE(parent) != P_IBTREE && TYPE(parent) != P_IRECNO))P
 			goto stop;	  # 		pgno = TYPE(parent) == P_IBTREE ?p& 		    GET_BINTERNAL(parent, 0)->pgno :% 		    GET_RINTERNAL(parent, 0)->pgno;    		/* Lock the child page. */ 		if ((ret == 		    __bam_lget(dbc, 0, pgno, DB_LOCK_WRITE, &c_lock)) != 0) 
 			goto stop;(9 		if ((ret = memp_fget(dbp->mpf, &pgno, 0, &child)) != 0)b
 			goto stop;    		/* Log the change. */  		if (DB_LOGGING(dbc)) { 			memset(&a, 0, sizeof(a)); 			a.data = child; 			a.size = dbp->pgsize; 			memset(&b, 0, sizeof(b)); 			b.data = P_ENTRY(parent, 0);t7 			b.size = BINTERNAL_SIZE(((BINTERNAL *)b.data)->len);s2 			__bam_rsplit_log(dbp->dbenv->lg_info, dbc->txn,7 			   &child->lsn, 0, dbp->log_fileid, child->pgno, &a, ) 			   RE_NREC(parent), &b, &parent->lsn);* 		}n   		/* 		 * Make the switch.  		 *> 		 * One fixup -- if the tree has record numbers and we're not= 		 * converting to a leaf page, we have to preserve the totaltB 		 * record count.  Note that we are about to overwrite everything< 		 * on the parent, including its LSN.  This is actually OK,@ 		 * because the above log message, which describes this update,@ 		 * stores its LSN on the child page.  When the child is copied; 		 * to the parent, the correct LSN is going to copied inton 		 * place in the parent.o 		 */i 		COMPQUIET(rcnt, 0);i  		if (TYPE(child) == P_IRECNO ||> 		    (TYPE(child) == P_IBTREE && F_ISSET(dbp, DB_BT_RECNUM))) 			rcnt = RE_NREC(parent);% 		memcpy(parent, child, dbp->pgsize);m 		parent->pgno = PGNO_ROOT;[  		if (TYPE(child) == P_IRECNO ||> 		    (TYPE(child) == P_IBTREE && F_ISSET(dbp, DB_BT_RECNUM))) 			RE_NREC_SET(parent, rcnt);,   		/* Mark the pages dirty. */t. 		memp_fset(dbp->mpf, parent, DB_MPOOL_DIRTY);- 		memp_fset(dbp->mpf, child, DB_MPOOL_DIRTY);*   		/* Adjust the cursors. */ / 		__bam_ca_rsplit(dbp, child->pgno, PGNO_ROOT);d   		/*< 		 * Free the page copied onto the root page and discard its< 		 * lock.  (The call to __bam_free() discards our reference 		 * to the page.) 		 */d 		(void)__bam_free(dbc, child);! 		child = NULL;m  
 		if (0) { stop:			done = 1;t 		}; 		if (p_lock != LOCK_INVALID)-! 			(void)__BT_TLPUT(dbc, p_lock);  		if (parent != NULL) " 			memp_fput(dbp->mpf, parent, 0); 		if (c_lock != LOCK_INVALID)o! 			(void)__BT_TLPUT(dbc, c_lock);_ 		if (child != NULL)! 			memp_fput(dbp->mpf, child, 0);m 	}   	return (0); }apage and it's parent, locked.  Walk back up thecE 	 * tree, until we have the top pair of pages that we want to delete                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                