 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */    #include "config.h"    #ifndef lintF static const char sccsid[] = "@(#)bt_rec.c	10.28 (Sleepycat) 9/27/98"; #endif /* not lint */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <string.h>  #endif   #include "db_int.h"  #include "db_page.h" #include "shqueue.h" #include "hash.h"  #include "btree.h" #include "log.h" #include "common_ext.h"    /*  * __bam_pg_alloc_recover --"  *	Recovery function for pg_alloc.  *%  * PUBLIC: int __bam_pg_alloc_recover ;  * PUBLIC:   __P((DB_LOG *, DBT *, DB_LSN *, int, void *));   */  int 4 __bam_pg_alloc_recover(logp, dbtp, lsnp, redo, info) 	DB_LOG *logp; 	DBT *dbtp;  	DB_LSN *lsnp;
 	int redo; 	void *info; {  	__bam_pg_alloc_args *argp;  	BTMETA *meta; 	DB_MPOOLFILE *mpf; 
 	PAGE *pagep;  	DB *file_dbp;
 	DBC *dbc; 	db_pgno_t pgno;! 	int cmp_n, cmp_p, modified, ret;   ! 	REC_PRINT(__bam_pg_alloc_print);   	REC_INTRO(__bam_pg_alloc_read);   	/* G 	 * Fix up the allocated page.  If we're redoing the operation, we have E 	 * to get the page (creating it if it doesn't exist), and update its E 	 * LSN.  If we're undoing the operation, we have to reset the page's $ 	 * LSN and put it on the free list. 	 * F 	 * Fix up the metadata page.  If we're redoing the operation, we haveE 	 * to get the metadata page and update its LSN and its free pointer. H 	 * If we're undoing the operation and the page was ever created, we put 	 * it on the freelist.  	 */ 	pgno = PGNO_METADATA;4 	if ((ret = memp_fget(mpf, &pgno, 0, &meta)) != 0) {, 		/* The metadata page must always exist. */# 		(void)__db_pgerr(file_dbp, pgno);  		goto out;  	}I 	if ((ret = memp_fget(mpf, &argp->pgno, DB_MPOOL_CREATE, &pagep)) != 0) {  		/*= 		 * We specify creation and check for it later, because this ; 		 * operation was supposed to create the page, and even in = 		 * the undo case it's going to get linked onto the freelist   		 * which we're also fixing up. 		 */ ) 		(void)__db_pgerr(file_dbp, argp->pgno);   		(void)memp_fput(mpf, meta, 0); 		goto out;  	}  ! 	/* Fix up the allocated page. */  	modified = 0;( 	cmp_n = log_compare(lsnp, &LSN(pagep));3 	cmp_p = log_compare(&LSN(pagep), &argp->page_lsn);  	if (cmp_p == 0 && redo) {& 		/* Need to redo update described. */! 		P_INIT(pagep, file_dbp->pgsize, > 		    argp->pgno, PGNO_INVALID, PGNO_INVALID, 0, argp->ptype);   		pagep->lsn = *lsnp;  		modified = 1; " 	} else if (cmp_n == 0 && !redo) {& 		/* Need to undo update described. */! 		P_INIT(pagep, file_dbp->pgsize, : 		    argp->pgno, PGNO_INVALID, meta->free, 0, P_INVALID);   		pagep->lsn = argp->page_lsn; 		modified = 1;  	}I 	if ((ret = memp_fput(mpf, pagep, modified ? DB_MPOOL_DIRTY : 0)) != 0) {   		(void)memp_fput(mpf, meta, 0); 		goto out;  	}    	/* Fix up the metadata page. */ 	modified = 0;' 	cmp_n = log_compare(lsnp, &LSN(meta)); 2 	cmp_p = log_compare(&LSN(meta), &argp->meta_lsn); 	if (cmp_p == 0 && redo) {& 		/* Need to redo update described. */ 		meta->lsn = *lsnp; 		meta->free = argp->next; 		modified = 1; " 	} else if (cmp_n == 0 && !redo) {& 		/* Need to undo update described. */ 		meta->lsn = argp->meta_lsn;  		meta->free = argp->pgno; 		modified = 1;  	}F 	if ((ret = memp_fput(mpf, meta, modified ? DB_MPOOL_DIRTY : 0)) != 0) 		goto out;    done:	*lsnp = argp->prev_lsn; 	 	ret = 0;    out:	REC_CLOSE;  }    /*  * __bam_pg_free_recover -- !  *	Recovery function for pg_free.   *$  * PUBLIC: int __bam_pg_free_recover;  * PUBLIC:   __P((DB_LOG *, DBT *, DB_LSN *, int, void *));   */  int 3 __bam_pg_free_recover(logp, dbtp, lsnp, redo, info)  	DB_LOG *logp; 	DBT *dbtp;  	DB_LSN *lsnp;
 	int redo; 	void *info; {  	__bam_pg_free_args *argp; 	BTMETA *meta; 	DB *file_dbp;
 	DBC *dbc; 	DB_MPOOLFILE *mpf; 
 	PAGE *pagep;  	db_pgno_t pgno;! 	int cmp_n, cmp_p, modified, ret;     	REC_PRINT(__bam_pg_free_print); 	REC_INTRO(__bam_pg_free_read);    	/* E 	 * Fix up the freed page.  If we're redoing the operation we get the F 	 * page and explicitly discard its contents, then update its LSN.  IfH 	 * we're undoing the operation, we get the page and restore its header. 	 */; 	if ((ret = memp_fget(mpf, &argp->pgno, 0, &pagep)) != 0) {  		/*> 		 * We don't automatically create the page.  The only way the= 		 * page might not exist is if the alloc never happened, and > 		 * the only way the alloc might never have happened is if we? 		 * are undoing, in which case there's no reason to create the 
 		 * page. 		 */  		if (!redo)
 			goto done; ) 		(void)__db_pgerr(file_dbp, argp->pgno);  		goto out;  	} 	modified = 0;( 	cmp_n = log_compare(lsnp, &LSN(pagep));; 	cmp_p = log_compare(&LSN(pagep), &LSN(argp->header.data));  	if (cmp_p == 0 && redo) {& 		/* Need to redo update described. */! 		P_INIT(pagep, file_dbp->pgsize, ; 		    pagep->pgno, PGNO_INVALID, argp->next, 0, P_INVALID);  		pagep->lsn = *lsnp;    		modified = 1; " 	} else if (cmp_n == 0 && !redo) {& 		/* Need to undo update described. */6 		memcpy(pagep, argp->header.data, argp->header.size);   		modified = 1;  	}G 	if ((ret = memp_fput(mpf, pagep, modified ? DB_MPOOL_DIRTY : 0)) != 0)  		goto out;    	/* H 	 * Fix up the metadata page.  If we're redoing or undoing the operation8 	 * we get the page and update its LSN and free pointer. 	 */ 	pgno = PGNO_METADATA;4 	if ((ret = memp_fget(mpf, &pgno, 0, &meta)) != 0) {, 		/* The metadata page must always exist. */# 		(void)__db_pgerr(file_dbp, pgno);  		goto out;  	}   	modified = 0;' 	cmp_n = log_compare(lsnp, &LSN(meta)); 2 	cmp_p = log_compare(&LSN(meta), &argp->meta_lsn); 	if (cmp_p == 0 && redo) {& 		/* Need to redo update described. */ 		meta->free = argp->pgno;   		meta->lsn = *lsnp; 		modified = 1; " 	} else if (cmp_n == 0 && !redo) {& 		/* Need to undo update described. */ 		meta->free = argp->next;   		meta->lsn = argp->meta_lsn;  		modified = 1;  	}F 	if ((ret = memp_fput(mpf, meta, modified ? DB_MPOOL_DIRTY : 0)) != 0) 		goto out;    done:	*lsnp = argp->prev_lsn; 	 	ret = 0;    out:	REC_CLOSE;  }    /*  * __bam_split_recover --   *	Recovery function for split.   *"  * PUBLIC: int __bam_split_recover;  * PUBLIC:   __P((DB_LOG *, DBT *, DB_LSN *, int, void *));   */  int 1 __bam_split_recover(logp, dbtp, lsnp, redo, info)  	DB_LOG *logp; 	DBT *dbtp;  	DB_LSN *lsnp;
 	int redo; 	void *info; {  	__bam_split_args *argp; 	DB *file_dbp;
 	DBC *dbc; 	DB_MPOOLFILE *mpf; * 	PAGE *_lp, *lp, *np, *pp, *_rp, *rp, *sp; 	db_pgno_t pgno;9 	int l_update, p_update, r_update, ret, rootsplit, t_ret;    	REC_PRINT(__bam_split_print);   	mpf = NULL;& 	_lp = lp = np = pp = _rp = rp = NULL;   	REC_INTRO(__bam_split_read);    	/* D 	 * There are two kinds of splits that we have to recover from.  TheC 	 * first is a root-page split, where the root page is split from a G 	 * leaf page into an internal page and two new leaf pages are created. E 	 * The second is where a page is split into two pages, and a new key % 	 * is inserted into the parent page.  	 */ 	sp = argp->pg.data; 	pgno = PGNO(sp);  	rootsplit = pgno == PGNO_ROOT; . 	if (memp_fget(mpf, &argp->left, 0, &lp) != 0) 		lp = NULL;/ 	if (memp_fget(mpf, &argp->right, 0, &rp) != 0)  		rp = NULL;   	if (redo) {% 		l_update = r_update = p_update = 0;  		/*+ 		 * Decide if we need to resplit the page.  		 *> 		 * If this is a root split, then the root has to exist, it's? 		 * the page we're splitting and it gets modified.  If this is ? 		 * not a root split, then the left page has to exist, for the  		 * same reason.  		 */  		if (rootsplit) {4 			if ((ret = memp_fget(mpf, &pgno, 0, &pp)) != 0) {% 				(void)__db_pgerr(file_dbp, pgno);  				pp = NULL;
 				goto out;  			}
 			p_update = 7 			    log_compare(&LSN(pp), &LSN(argp->pg.data)) == 0;  		} else 			if (lp == NULL) {+ 				(void)__db_pgerr(file_dbp, argp->left); 
 				goto out;  			}< 		if (lp == NULL || log_compare(&LSN(lp), &argp->llsn) == 0) 			l_update = 1;< 		if (rp == NULL || log_compare(&LSN(rp), &argp->rlsn) == 0) 			r_update = 1;* 		if (!p_update && !l_update && !r_update)
 			goto done;)  ; 		/* Allocate and initialize new left/right child pages. */.? 		if ((ret = __os_malloc(file_dbp->pgsize, NULL, &_lp)) != 0 || = 		    (ret = __os_malloc(file_dbp->pgsize, NULL, &_rp)) != 0)  			goto out; 		if (rootsplit) {, 			P_INIT(_lp, file_dbp->pgsize, argp->left, 			    PGNO_INVALID,3 			    ISINTERNAL(sp) ? PGNO_INVALID : argp->right,b 			    LEVEL(sp), TYPE(sp));- 			P_INIT(_rp, file_dbp->pgsize, argp->right,u3 			    ISINTERNAL(sp) ?  PGNO_INVALID : argp->left,p* 			    PGNO_INVALID, LEVEL(sp), TYPE(sp));
 		} else {* 			P_INIT(_lp, file_dbp->pgsize, PGNO(sp),5 			    ISINTERNAL(sp) ? PGNO_INVALID : PREV_PGNO(sp),*3 			    ISINTERNAL(sp) ? PGNO_INVALID : argp->right,l 			    LEVEL(sp), TYPE(sp));- 			P_INIT(_rp, file_dbp->pgsize, argp->right,v0 			    ISINTERNAL(sp) ? PGNO_INVALID : sp->pgno,5 			    ISINTERNAL(sp) ? PGNO_INVALID : NEXT_PGNO(sp),f 			    LEVEL(sp), TYPE(sp)); 		}n   		/* Split the page. */fB 		if ((ret = __bam_copy(file_dbp, sp, _lp, 0, argp->indx)) != 0 ||6 		    (ret = __bam_copy(file_dbp, sp, _rp, argp->indx, 		    NUM_ENT(sp))) != 0)i 			goto out;  . 		/* If the left child is wrong, update it. */ 		if (lp == NULL && (ret =@ 		    memp_fget(mpf, &argp->left, DB_MPOOL_CREATE, &lp)) != 0) {* 			(void)__db_pgerr(file_dbp, argp->left);
 			lp = NULL;m 			goto out; 		}e 		if (l_update) {r% 			memcpy(lp, _lp, file_dbp->pgsize);  			lp->lsn = *lsnp;S7 			if ((ret = memp_fput(mpf, lp, DB_MPOOL_DIRTY)) != 0)i
 				goto out; 
 			lp = NULL;d 		}p  / 		/* If the right child is wrong, update it. */T) 		if (rp == NULL && (ret = memp_fget(mpf,,2 		    &argp->right, DB_MPOOL_CREATE, &rp)) != 0) {+ 			(void)__db_pgerr(file_dbp, argp->right);)
 			rp = NULL;  			goto out; 		}e 		if (r_update) {>% 			memcpy(rp, _rp, file_dbp->pgsize);  			rp->lsn = *lsnp;f7 			if ((ret = memp_fput(mpf, rp, DB_MPOOL_DIRTY)) != 0)e
 				goto out;o
 			rp = NULL;h 		}e   		/*A 		 * If the parent page is wrong, update it.  This is of interestsA 		 * only if it was a root split, since root splits create parentlA 		 * pages.  All other splits modify a parent page, but those are % 		 * separately logged and recovered.* 		 */d 		if (rootsplit && p_update) {" 			if (file_dbp->type == DB_BTREE)  				P_INIT(pp, file_dbp->pgsize,. 				    PGNO_ROOT, PGNO_INVALID, PGNO_INVALID," 				    _lp->level + 1, P_IBTREE); 			elsee  				P_INIT(pp, file_dbp->pgsize,. 				    PGNO_ROOT, PGNO_INVALID, PGNO_INVALID," 				    _lp->level + 1, P_IRECNO); 			RE_NREC_SET(pp,$ 			    file_dbp->type == DB_RECNO ||( 			    F_ISSET(file_dbp, DB_BT_RECNUM) ?0 			    __bam_total(_lp) + __bam_total(_rp) : 0); 			pp->lsn = *lsnp;L7 			if ((ret = memp_fput(mpf, pp, DB_MPOOL_DIRTY)) != 0) 
 				goto out; 
 			pp = NULL;p 		}    		/*? 		 * Finally, redo the next-page link if necessary.  This is of;? 		 * interest only if it wasn't a root split -- inserting a new ? 		 * page in the tree requires that any following page have itsa= 		 * previous-page pointer updated to our new page.  The next	9 		 * page must exist because we're redoing the operation.  		 */>/ 		if (!rootsplit && !IS_ZERO_LSN(argp->nlsn)) {(; 			if ((ret = memp_fget(mpf, &argp->npgno, 0, &np)) != 0) {/, 				(void)__db_pgerr(file_dbp, argp->npgno); 				np = NULL;
 				goto out;  			}1 			if (log_compare(&LSN(np), &argp->nlsn) == 0) {L  				PREV_PGNO(np) = argp->right; 				np->lsn = *lsnp; 				if ((ret =1 				    memp_fput(mpf, np, DB_MPOOL_DIRTY)) != 0)r 					goto out; 				np = NULL; 			} 		}_	 	} else {  		/*> 		 * If the split page is wrong, replace its contents with the? 		 * logged page contents.  If the page doesn't exist, it meanso? 		 * that the create of the page never happened, nor did any ofS> 		 * the adds onto the page that caused the split, and there's# 		 * really no undo-ing to be done.D 		 */;3 		if ((ret = memp_fget(mpf, &pgno, 0, &pp)) != 0) {n
 			pp = NULL;  			goto lrundo;r 		} ) 		if (log_compare(lsnp, &LSN(pp)) == 0) {T, 			memcpy(pp, argp->pg.data, argp->pg.size);7 			if ((ret = memp_fput(mpf, pp, DB_MPOOL_DIRTY)) != 0) 
 				goto out;e
 			pp = NULL;r 		}    		/*A 		 * If it's a root split and the left child ever existed, update @ 		 * its LSN.  (If it's not a root split, we've updated the left= 		 * page already -- it's the same as the split page.) If theiA 		 * right child ever existed, root split or not, update its LSN. @ 		 * The undo of the page allocation(s) will restore them to the 		 * free list.h 		 */ 7 lrundo:		if ((rootsplit && lp != NULL) || rp != NULL) {o! 			if (rootsplit && lp != NULL && * 			    log_compare(lsnp, &LSN(lp)) == 0) { 				lp->lsn = argp->llsn;) 				if ((ret =1 				    memp_fput(mpf, lp, DB_MPOOL_DIRTY)) != 0)S 					goto out; 				lp = NULL; 			} 			if (rp != NULL &&* 			    log_compare(lsnp, &LSN(rp)) == 0) { 				rp->lsn = argp->rlsn;r 				if ((ret =1 				    memp_fput(mpf, rp, DB_MPOOL_DIRTY)) != 0)N 					goto out; 				rp = NULL; 			} 		}a   		/*? 		 * Finally, undo the next-page link if necessary.  This is of{? 		 * interest only if it wasn't a root split -- inserting a newe? 		 * page in the tree requires that any following page have its ? 		 * previous-page pointer updated to our new page.  Since it's	? 		 * possible that the next-page never existed, we ignore it asn  		 * if there's nothing to undo. 		 */e/ 		if (!rootsplit && !IS_ZERO_LSN(argp->nlsn)) { ; 			if ((ret = memp_fget(mpf, &argp->npgno, 0, &np)) != 0) {& 				np = NULL; 				goto done; 			}* 			if (log_compare(lsnp, &LSN(np)) == 0) { 				PREV_PGNO(np) = argp->left;} 				np->lsn = argp->nlsn;=+ 				if (memp_fput(mpf, np, DB_MPOOL_DIRTY))g 					goto out; 				np = NULL; 			} 		}  	}   done:	*lsnp = argp->prev_lsn;r	 	ret = 0;d  / out:	/* Free any pages that weren't dirtied. */>D 	if (pp != NULL && (t_ret = memp_fput(mpf, pp, 0)) != 0 && ret == 0) 		ret = t_ret;D 	if (lp != NULL && (t_ret = memp_fput(mpf, lp, 0)) != 0 && ret == 0) 		ret = t_ret;D 	if (np != NULL && (t_ret = memp_fput(mpf, np, 0)) != 0 && ret == 0) 		ret = t_ret;D 	if (rp != NULL && (t_ret = memp_fput(mpf, rp, 0)) != 0 && ret == 0) 		ret = t_ret;    	/* Free any allocated space. */ 	if (_lp != NULL)i# 		__os_free(_lp, file_dbp->pgsize);b 	if (_rp != NULL)*# 		__os_free(_rp, file_dbp->pgsize);S   	REC_CLOSE;* }    /*  * __bam_rsplit_recover --)  *	Recovery function for a reverse split.g  *#  * PUBLIC: int __bam_rsplit_recoverd;  * PUBLIC:   __P((DB_LOG *, DBT *, DB_LSN *, int, void *));;  */C int;2 __bam_rsplit_recover(logp, dbtp, lsnp, redo, info) 	DB_LOG *logp; 	DBT *dbtp;n 	DB_LSN *lsnp;
 	int redo; 	void *info; {o 	__bam_rsplit_args *argp;I 	DB *file_dbp;
 	DBC *dbc; 	DB_MPOOLFILE *mpf; 
 	PAGE *pagep;  	db_pgno_t pgno;! 	int cmp_n, cmp_p, modified, ret;    	REC_PRINT(__bam_rsplit_print);  	REC_INTRO(__bam_rsplit_read);   	/* Fix the root page. */s 	pgno = PGNO_ROOT;5 	if ((ret = memp_fget(mpf, &pgno, 0, &pagep)) != 0) {p( 		/* The root page must always exist. */ 		__db_pgerr(file_dbp, pgno);i 		goto out;t 	} 	modified = 0;( 	cmp_n = log_compare(lsnp, &LSN(pagep));2 	cmp_p = log_compare(&LSN(pagep), &argp->rootlsn); 	if (cmp_p == 0 && redo) {& 		/* Need to redo update described. */4 		memcpy(pagep, argp->pgdbt.data, argp->pgdbt.size); 		pagep->pgno = PGNO_ROOT; 		pagep->lsn = *lsnp;{ 		modified = 1;u" 	} else if (cmp_n == 0 && !redo) {& 		/* Need to undo update described. */, 		P_INIT(pagep, file_dbp->pgsize, PGNO_ROOT,1 		    argp->nrec, PGNO_INVALID, pagep->level + 1,n8 		    file_dbp->type == DB_BTREE ? P_IBTREE : P_IRECNO);& 		if ((ret = __db_pitem(dbc, pagep, 0,6 		    argp->rootent.size, &argp->rootent, NULL)) != 0) 			goto out; 		pagep->lsn = argp->rootlsn;  		modified = 1;_ 	}G 	if ((ret = memp_fput(mpf, pagep, modified ? DB_MPOOL_DIRTY : 0)) != 0)  		goto out;g   	/*eC 	 * Fix the page copied over the root page.  It's possible that the{A 	 * page never made it to disk, so if we're undo-ing and the page}? 	 * doesn't exist, it's okay and there's nothing further to do.	 	 */; 	if ((ret = memp_fget(mpf, &argp->pgno, 0, &pagep)) != 0) {s 		if (!redo)
 			goto done;	) 		(void)__db_pgerr(file_dbp, argp->pgno);	 		goto out;  	} 	modified = 0;( 	cmp_n = log_compare(lsnp, &LSN(pagep));: 	cmp_p = log_compare(&LSN(pagep), &LSN(argp->pgdbt.data)); 	if (cmp_p == 0 && redo) {& 		/* Need to redo update described. */ 		pagep->lsn = *lsnp;( 		modified = 1;P" 	} else if (cmp_n == 0 && !redo) {& 		/* Need to undo update described. */4 		memcpy(pagep, argp->pgdbt.data, argp->pgdbt.size); 		modified = 1;  	}G 	if ((ret = memp_fput(mpf, pagep, modified ? DB_MPOOL_DIRTY : 0)) != 0)_ 		goto out;p   done:	*lsnp = argp->prev_lsn;V	 	ret = 0;E   out:	REC_CLOSE;  }P   /*  * __bam_adj_recover --N  *	Recovery function for adj.   *   * PUBLIC: int __bam_adj_recover;  * PUBLIC:   __P((DB_LOG *, DBT *, DB_LSN *, int, void *));s  */Y int)/ __bam_adj_recover(logp, dbtp, lsnp, redo, info)v 	DB_LOG *logp; 	DBT *dbtp;O 	DB_LSN *lsnp;
 	int redo; 	void *info; {  	__bam_adj_args *argp; 	DB *file_dbp;
 	DBC *dbc; 	DB_MPOOLFILE *mpf;*
 	PAGE *pagep;.! 	int cmp_n, cmp_p, modified, ret;d   	REC_PRINT(__bam_adj_print); 	REC_INTRO(__bam_adj_read);(  G 	/* Get the page; if it never existed and we're undoing, we're done. */ ; 	if ((ret = memp_fget(mpf, &argp->pgno, 0, &pagep)) != 0) {U 		if (!redo)
 			goto done;() 		(void)__db_pgerr(file_dbp, argp->pgno);  		goto out;d 	}   	modified = 0;( 	cmp_n = log_compare(lsnp, &LSN(pagep));. 	cmp_p = log_compare(&LSN(pagep), &argp->lsn); 	if (cmp_p == 0 && redo) {& 		/* Need to redo update described. */ 		if ((ret = __bam_adjindx(dbc,	A 		    pagep, argp->indx, argp->indx_copy, argp->is_insert)) != 0)o 			goto err;   		LSN(pagep) = *lsnp;  		modified = 1;m" 	} else if (cmp_n == 0 && !redo) {& 		/* Need to undo update described. */ 		if ((ret = __bam_adjindx(dbc, B 		    pagep, argp->indx, argp->indx_copy, !argp->is_insert)) != 0) 			goto err;   		LSN(pagep) = argp->lsn;  		modified = 1;p 	}G 	if ((ret = memp_fput(mpf, pagep, modified ? DB_MPOOL_DIRTY : 0)) != 0)  		goto out;I   done:	*lsnp = argp->prev_lsn;e	 	ret = 0;i  	 	if (0) {s% err:		(void)memp_fput(mpf, pagep, 0);c 	} out:	REC_CLOSE;p }n   /*  * __bam_cadjust_recover --oD  *	Recovery function for the adjust of a count change in an internal  *	page.  *$  * PUBLIC: int __bam_cadjust_recover;  * PUBLIC:   __P((DB_LOG *, DBT *, DB_LSN *, int, void *));,  */	 intG3 __bam_cadjust_recover(logp, dbtp, lsnp, redo, info)v 	DB_LOG *logp; 	DBT *dbtp;  	DB_LSN *lsnp;
 	int redo; 	void *info; {O 	__bam_cadjust_args *argp; 	DB *file_dbp;
 	DBC *dbc; 	DB_MPOOLFILE *mpf;_
 	PAGE *pagep;	! 	int cmp_n, cmp_p, modified, ret;     	REC_PRINT(__bam_cadjust_print); 	REC_INTRO(__bam_cadjust_read);_  G 	/* Get the page; if it never existed and we're undoing, we're done. */,; 	if ((ret = memp_fget(mpf, &argp->pgno, 0, &pagep)) != 0) {  		if (!redo)
 			goto done;t) 		(void)__db_pgerr(file_dbp, argp->pgno);; 		goto out;s 	}   	modified = 0;( 	cmp_n = log_compare(lsnp, &LSN(pagep));. 	cmp_p = log_compare(&LSN(pagep), &argp->lsn); 	if (cmp_p == 0 && redo) {& 		/* Need to redo update described. */# 		if (file_dbp->type == DB_BTREE &&e( 		    F_ISSET(file_dbp, DB_BT_RECNUM)) {; 			GET_BINTERNAL(pagep, argp->indx)->nrecs += argp->adjust;f/ 			if (argp->total && PGNO(pagep) == PGNO_ROOT)i% 				RE_NREC_ADJ(pagep, argp->adjust);	 		}=# 		if (file_dbp->type == DB_RECNO) {l; 			GET_RINTERNAL(pagep, argp->indx)->nrecs += argp->adjust; / 			if (argp->total && PGNO(pagep) == PGNO_ROOT)t% 				RE_NREC_ADJ(pagep, argp->adjust);_ 		})   		LSN(pagep) = *lsnp;  		modified = 1;	" 	} else if (cmp_n == 0 && !redo) {& 		/* Need to undo update described. */# 		if (file_dbp->type == DB_BTREE &&e( 		    F_ISSET(file_dbp, DB_BT_RECNUM)) {; 			GET_BINTERNAL(pagep, argp->indx)->nrecs -= argp->adjust;y/ 			if (argp->total && PGNO(pagep) == PGNO_ROOT) % 				RE_NREC_ADJ(pagep, argp->adjust);- 		}o# 		if (file_dbp->type == DB_RECNO) {_; 			GET_RINTERNAL(pagep, argp->indx)->nrecs -= argp->adjust;r/ 			if (argp->total && PGNO(pagep) == PGNO_ROOT)=( 				RE_NREC_ADJ(pagep, -(argp->adjust)); 		}i 		LSN(pagep) = argp->lsn;u 		modified = 1;O 	}G 	if ((ret = memp_fput(mpf, pagep, modified ? DB_MPOOL_DIRTY : 0)) != 0)a 		goto out;n   done:	*lsnp = argp->prev_lsn;d	 	ret = 0;i   out:	REC_CLOSE;o }    /*  * __bam_cdel_recover --A  *	Recovery function for the intent-to-delete of a cursor record.   *!  * PUBLIC: int __bam_cdel_recoveri;  * PUBLIC:   __P((DB_LOG *, DBT *, DB_LSN *, int, void *));i  */  intr0 __bam_cdel_recover(logp, dbtp, lsnp, redo, info) 	DB_LOG *logp; 	DBT *dbtp;N 	DB_LSN *lsnp;
 	int redo; 	void *info; {p 	__bam_cdel_args *argp;c 	DB *file_dbp;
 	DBC *dbc; 	DB_MPOOLFILE *mpf;p
 	PAGE *pagep;f! 	int cmp_n, cmp_p, modified, ret;,   	REC_PRINT(__bam_cdel_print);t 	REC_INTRO(__bam_cdel_read);  G 	/* Get the page; if it never existed and we're undoing, we're done. */s; 	if ((ret = memp_fget(mpf, &argp->pgno, 0, &pagep)) != 0) {D 		if (!redo)
 			goto done;g) 		(void)__db_pgerr(file_dbp, argp->pgno);* 		goto out;y 	}   	modified = 0;( 	cmp_n = log_compare(lsnp, &LSN(pagep));. 	cmp_p = log_compare(&LSN(pagep), &argp->lsn); 	if (cmp_p == 0 && redo) {& 		/* Need to redo update described. */! 		if (pagep->type == P_DUPLICATE)d1 			B_DSET(GET_BKEYDATA(pagep, argp->indx)->type);h 		else: 			B_DSET(GET_BKEYDATA(pagep, argp->indx + O_INDX)->type);   		LSN(pagep) = *lsnp;	 		modified = 1; " 	} else if (cmp_n == 0 && !redo) {& 		/* Need to undo update described. */! 		if (pagep->type == P_DUPLICATE)	1 			B_DCLR(GET_BKEYDATA(pagep, argp->indx)->type);) 		else: 			B_DCLR(GET_BKEYDATA(pagep, argp->indx + O_INDX)->type);   		LSN(pagep) = argp->lsn;, 		modified = 1;g 	}G 	if ((ret = memp_fput(mpf, pagep, modified ? DB_MPOOL_DIRTY : 0)) != 0)l 		goto out;0   done:	*lsnp = argp->prev_lsn; 	 	ret = 0;t   out:	REC_CLOSE;= }L   /*  * __bam_repl_recover --/  *	Recovery function for page item replacement.=  *!  * PUBLIC: int __bam_repl_recover);  * PUBLIC:   __P((DB_LOG *, DBT *, DB_LSN *, int, void *));   */p int(0 __bam_repl_recover(logp, dbtp, lsnp, redo, info) 	DB_LOG *logp; 	DBT *dbtp;p 	DB_LSN *lsnp;
 	int redo; 	void *info; {  	__bam_repl_args *argp;l 	BKEYDATA *bk; 	DB *file_dbp;
 	DBC *dbc;	 	DBT dbt;f 	DB_MPOOLFILE *mpf;i
 	PAGE *pagep;*! 	int cmp_n, cmp_p, modified, ret;)
 	u_int8_t *p;E   	REC_PRINT(__bam_repl_print);o 	REC_INTRO(__bam_repl_read);  G 	/* Get the page; if it never existed and we're undoing, we're done. */ ; 	if ((ret = memp_fget(mpf, &argp->pgno, 0, &pagep)) != 0) {  		if (!redo)
 			goto done;t) 		(void)__db_pgerr(file_dbp, argp->pgno);* 		goto out;S 	}& 	bk = GET_BKEYDATA(pagep, argp->indx);   	modified = 0;( 	cmp_n = log_compare(lsnp, &LSN(pagep));. 	cmp_p = log_compare(&LSN(pagep), &argp->lsn); 	if (cmp_p == 0 && redo) { 		/*# 		 * Need to redo update described.  		 *# 		 * Re-build the replacement item.h 		 */p 		memset(&dbt, 0, sizeof(dbt)); ; 		dbt.size = argp->prefix + argp->suffix + argp->repl.size;r: 		if ((ret = __os_malloc(dbt.size, NULL, &dbt.data)) != 0) 			goto err; 		p = dbt.data; $ 		memcpy(p, bk->data, argp->prefix); 		p += argp->prefix;. 		memcpy(p, argp->repl.data, argp->repl.size); 		p += argp->repl.size;N? 		memcpy(p, bk->data + (bk->len - argp->suffix), argp->suffix);a  2 		ret = __bam_ritem(dbc, pagep, argp->indx, &dbt);  		__os_free(dbt.data, dbt.size); 		if (ret != 0)m 			goto err;   		LSN(pagep) = *lsnp;  		modified = 1; " 	} else if (cmp_n == 0 && !redo) { 		/*# 		 * Need to undo update described.D 		 *  		 * Re-build the original item. 		 */B 		memset(&dbt, 0, sizeof(dbt));	; 		dbt.size = argp->prefix + argp->suffix + argp->orig.size;e: 		if ((ret = __os_malloc(dbt.size, NULL, &dbt.data)) != 0) 			goto err; 		p = dbt.data;1$ 		memcpy(p, bk->data, argp->prefix); 		p += argp->prefix;. 		memcpy(p, argp->orig.data, argp->orig.size); 		p += argp->orig.size;t? 		memcpy(p, bk->data + (bk->len - argp->suffix), argp->suffix);   2 		ret = __bam_ritem(dbc, pagep, argp->indx, &dbt);  		__os_free(dbt.data, dbt.size); 		if (ret != 0)	 			goto err;  - 		/* Reset the deleted flag, if necessary. */0 		if (argp->isdeleted)1 			B_DSET(GET_BKEYDATA(pagep, argp->indx)->type);)   		LSN(pagep) = argp->lsn;e 		modified = 1;l 	}G 	if ((ret = memp_fput(mpf, pagep, modified ? DB_MPOOL_DIRTY : 0)) != 0)p 		goto out;    done:	*lsnp = argp->prev_lsn;N	 	ret = 0;   	 	if (0) {b% err:		(void)memp_fput(mpf, pagep, 0);i 	} out:	REC_CLOSE;( }_== 0 && !redo) {& 		/* Need to undo update described. */4 		memcpy(pagep, argp->pgdbt.data, argp->pgdbt.size); 		modified = 1;  	}G 	if ((ret = memp_fput(mpf, pagep, modi                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                