 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */  /*-  * Copyright (c) 1990, 1993, 1994, 1995, 1996 &  *	Keith Bostic.  All rights reserved.  */  /*  * Copyright (c) 1990, 1993 E  *	The Regents of the University of California.  All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   */    #include "config.h"    #ifndef lintJ static const char sccsid[] = "@(#)bt_rsearch.c	10.21 (Sleepycat) 12/2/98"; #endif /* not lint */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h> #endif   #include "db_int.h"  #include "db_page.h" #include "btree.h"   /*  * __bam_rsearch -- &  *	Search a btree for a record number.  *O  * PUBLIC: int __bam_rsearch __P((DBC *, db_recno_t *, u_int32_t, int, int *));   */  int / __bam_rsearch(dbc, recnop, flags, stop, exactp) 
 	DBC *dbc; 	db_recno_t *recnop; 	u_int32_t flags;  	int stop, *exactp;  {  	BINTERNAL *bi;  	CURSOR *cp;	 	DB *dbp;  	DB_LOCK lock;	 	PAGE *h;  	RINTERNAL *ri;  	db_indx_t indx, top;  	db_pgno_t pg; 	db_recno_t i, recno, total; 	int ret, stack;   	dbp = dbc->dbp; 	cp = dbc->internal;   	BT_STK_CLR(cp);   	/* F 	 * There are several ways we search a btree tree.  The flags argumentB 	 * specifies if we're acquiring read or write locks and if we areE 	 * locking pairs of pages.  In addition, if we're adding or deleting F 	 * an item, we have to lock the entire tree, regardless.  See btree.h 	 * for more details.  	 * G 	 * If write-locking pages, we need to know whether or not to acquire a H 	 * write lock on a page before getting it.  This depends on how deep itH 	 * is in tree, which we don't know until we acquire the root page.  So,E 	 * if we need to lock the root page we may have to upgrade it later, 4 	 * because we won't get the correct lock initially. 	 *  	 * Retrieve the root page.  	 */ 	pg = PGNO_ROOT; 	stack = LF_ISSET(S_STACK);  	if ((ret = __bam_lget(dbc, ? 	    0, pg, stack ? DB_LOCK_WRITE : DB_LOCK_READ, &lock)) != 0)  		return (ret); 4 	if ((ret = memp_fget(dbp->mpf, &pg, 0, &h)) != 0) { 		(void)__BT_LPUT(dbc, lock);  		return (ret);  	}   	/* A 	 * Decide if we need to save this page; if we do, write lock it. @ 	 * We deliberately don't lock-couple on this call.  If the tree@ 	 * is tiny, i.e., one page, and two threads are busily updating? 	 * the root page, we're almost guaranteed deadlocks galore, as A 	 * each one gets a read lock and then blocks the other's attempt  	 * for a write lock.  	 */ 	if (!stack &&A 	    ((LF_ISSET(S_PARENT) && (u_int8_t)(stop + 1) >= h->level) || 5 	    (LF_ISSET(S_WRITE) && h->level == LEAFLEVEL))) { " 		(void)memp_fput(dbp->mpf, h, 0); 		(void)__BT_LPUT(dbc, lock); @ 		if ((ret = __bam_lget(dbc, 0, pg, DB_LOCK_WRITE, &lock)) != 0) 			return (ret);5 		if ((ret = memp_fget(dbp->mpf, &pg, 0, &h)) != 0) {  			(void)__BT_LPUT(dbc, lock); 			return (ret); 		}  		stack = 1; 	}   	/* F 	 * If appending to the tree, set the record number now -- we have the 	 * root page locked.  	 * G 	 * Delete only deletes exact matches, read only returns exact matches. H 	 * Note, this is different from __bam_search(), which returns non-exact 	 * matches for read.  	 * F 	 * The record may not exist.  We can only return the correct locationG 	 * for the record immediately after the last record in the tree, so do  	 * a fast check now.  	 */ 	total = RE_NREC(h); 	if (LF_ISSET(S_APPEND)) { 		*exactp = 0; 		*recnop = recno = total + 1;	 	} else {  		recno = *recnop; 		if (recno <= total)  			*exactp = 1;  		else { 			*exactp = 0; 4 			if (!LF_ISSET(S_PAST_EOF) || recno > total + 1) {$ 				(void)memp_fput(dbp->mpf, h, 0); 				(void)__BT_LPUT(dbc, lock);  				return (DB_NOTFOUND);  			} 		}  	}   	/*  	 * !!! < 	 * Record numbers in the tree are 0-based, but the recno is= 	 * 1-based.  All of the calculations below have to take this  	 * into account.  	 */ 	for (total = 0;;) { 		switch (TYPE(h)) { 		case P_LBTREE: 			recno -= total;   			/* 9 			 * There may be logically deleted records on the page, 8 			 * walk the page correcting for them.  The record may: 			 * not exist if there are enough deleted records in the 			 * page.  			 */0 			if (recno <= (db_recno_t)NUM_ENT(h) / P_INDX) 				for (i = recno - 1;; --i) { ! 					if (B_DISSET(GET_BKEYDATA(h, % 					    i * P_INDX + O_INDX)->type))  						++recno; 					if (i == 0) 						break; 				} 1 			if (recno > (db_recno_t)NUM_ENT(h) / P_INDX) {  				*exactp = 0;( 				if (!LF_ISSET(S_PAST_EOF) || recno >0 				    (db_recno_t)(NUM_ENT(h) / P_INDX + 1)) { 					ret = DB_NOTFOUND;  					goto err; 				}    			}  ; 			/* Correct from 1-based to 0-based for a page offset. */  			--recno; 2 			BT_STK_ENTER(cp, h, recno * P_INDX, lock, ret); 			return (ret); 		case P_IBTREE:' 			for (indx = 0, top = NUM_ENT(h);;) {   				bi = GET_BINTERNAL(h, indx);4 				if (++indx == top || total + bi->nrecs >= recno) 					break;  				total += bi->nrecs;  			} 			pg = bi->pgno; 	 			break;  		case P_LRECNO: 			recno -= total;  ; 			/* Correct from 1-based to 0-based for a page offset. */  			--recno; ) 			BT_STK_ENTER(cp, h, recno, lock, ret);  			return (ret); 		case P_IRECNO:' 			for (indx = 0, top = NUM_ENT(h);;) {   				ri = GET_RINTERNAL(h, indx);4 				if (++indx == top || total + ri->nrecs >= recno) 					break;  				total += ri->nrecs;  			} 			pg = ri->pgno; 	 			break; 
 		default:% 			return (__db_pgfmt(dbp, h->pgno));  		} 	 		--indx;    		if (stack) {2 			/* Return if this is the lowest page wanted. */0 			if (LF_ISSET(S_PARENT) && stop == h->level) {) 				BT_STK_ENTER(cp, h, indx, lock, ret);  				return (ret);  			}' 			BT_STK_PUSH(cp, h, indx, lock, ret);  			if (ret != 0)
 				goto err;   
 			if ((ret = : 			    __bam_lget(dbc, 0, pg, DB_LOCK_WRITE, &lock)) != 0)
 				goto err; 
 		} else { 			/* 7 			 * Decide if we want to return a pointer to the next 5 			 * page in the stack.  If we do, write lock it and  			 * never unlock it. 			 */ 			if ((LF_ISSET(S_PARENT) && ; 			    (u_int8_t)(stop + 1) >= (u_int8_t)(h->level - 1)) || # 			    (h->level - 1) == LEAFLEVEL)  				stack = 1;  # 			(void)memp_fput(dbp->mpf, h, 0);   
 			if ((ret = : 			    __bam_lget(dbc, 1, pg, stack && LF_ISSET(S_WRITE) ?2 			    DB_LOCK_WRITE : DB_LOCK_READ, &lock)) != 0)
 				goto err;  		}   3 		if ((ret = memp_fget(dbp->mpf, &pg, 0, &h)) != 0)I 			goto err; 	} 	/* NOTREACHED */    err:	BT_STK_POP(cp); 	__bam_stkrel(dbc, 0); 	return (ret); }l   /*  * __bam_adjust --5  *	Adjust the tree after adding or deleting a record.K  *2  * PUBLIC: int __bam_adjust __P((DBC *, int32_t));  */) int, __bam_adjust(dbc, adjust)h
 	DBC *dbc; 	int32_t adjust; {r 	CURSOR *cp;	 	DB *dbp;R
 	EPG *epg;	 	PAGE *h;n	 	int ret;    	dbp = dbc->dbp; 	cp = dbc->internal;  - 	/* Update the record counts for the tree. */c, 	for (epg = cp->sp; epg <= cp->csp; ++epg) { 		h = epg->page;3 		if (TYPE(h) == P_IBTREE || TYPE(h) == P_IRECNO) {s 			if (DB_LOGGING(dbc) &&l4 			    (ret = __bam_cadjust_log(dbp->dbenv->lg_info,- 			    dbc->txn, &LSN(h), 0, dbp->log_fileid,o. 			    PGNO(h), &LSN(h), (u_int32_t)epg->indx, 			    adjust, 1)) != 0) 				return (ret);r   			if (TYPE(h) == P_IBTREE)t1 				GET_BINTERNAL(h, epg->indx)->nrecs += adjust;e 			elsef1 				GET_RINTERNAL(h, epg->indx)->nrecs += adjust;y   			if (PGNO(h) == PGNO_ROOT) 				RE_NREC_ADJ(h, adjust);f  ; 			if ((ret = memp_fset(dbp->mpf, h, DB_MPOOL_DIRTY)) != 0)n 				return (ret);  		}4 	} 	return (0); }    /*  * __bam_nrecs --m,  *	Return the number of records in the tree.  *6  * PUBLIC: int __bam_nrecs __P((DBC *, db_recno_t *));  */h intp __bam_nrecs(dbc, rep)r
 	DBC *dbc; 	db_recno_t *rep;I {R	 	DB *dbp;H 	DB_LOCK lock;	 	PAGE *h;` 	db_pgno_t pgno;	 	int ret;O   	dbp = dbc->dbp;   	pgno = PGNO_ROOT;@ 	if ((ret = __bam_lget(dbc, 0, pgno, DB_LOCK_READ, &lock)) != 0) 		return (ret);A4 	if ((ret = memp_fget(dbp->mpf, &pgno, 0, &h)) != 0) 		return (ret);B   	*rep = RE_NREC(h);R  ! 	(void)memp_fput(dbp->mpf, h, 0);E 	(void)__BT_TLPUT(dbc, lock);A   	return (0); }L   /*  * __bam_total --,-  *	Return the number of records below a page.S  *0  * PUBLIC: db_recno_t __bam_total __P((PAGE *));  */ 
 db_recno_t __bam_total(h)	 	PAGE *h;L {I 	db_recno_t nrecs; 	db_indx_t indx, top;I   	nrecs = 0;I 	top = NUM_ENT(h);   	switch (TYPE(h)) {N 	case P_LBTREE:O, 		/* Check for logically deleted records. */, 		for (indx = 0; indx < top; indx += P_INDX)7 			if (!B_DISSET(GET_BKEYDATA(h, indx + O_INDX)->type))  				++nrecs; 		break; 	case P_IBTREE:y, 		for (indx = 0; indx < top; indx += O_INDX)* 			nrecs += GET_BINTERNAL(h, indx)->nrecs; 		break; 	case P_LRECNO:i 		nrecs = NUM_ENT(h);g 		break; 	case P_IRECNO: , 		for (indx = 0; indx < top; indx += O_INDX)* 			nrecs += GET_RINTERNAL(h, indx)->nrecs; 		break; 	}   	return (nrecs); }i32_t, int, int *));                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  