7 /* DO NOT EDIT: automatically built by dist/distrib. */  /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  *)  *	@(#)db_int.h	10.76 (Sleepycat) 12/2/98   */    #ifndef _DB_INTERNAL_H_  #define	_DB_INTERNAL_H_   2 #include "db.h"				/* Standard DB include file. */ #include "queue.h"  8 /*******************************************************(  * General purpose constants and macros.9  *******************************************************/ > #define	UINT16_T_MAX	    0xffff	/* Maximum 16 bit unsigned. */> #define	UINT32_T_MAX	0xffffffff	/* Maximum 32 bit unsigned. */  7 #define	DB_MIN_PGSIZE	0x000200	/* Minimum page size. */ 7 #define	DB_MAX_PGSIZE	0x010000	/* Maximum page size. */   2 #define	DB_MINCACHE	10		/* Minimum cached pages */   #define	MEGABYTE	1048576   /*J  * If we are unable to determine the underlying filesystem block size, useK  * 8K on the grounds that most OS's use less than 8K as their VM page size.   */   #define	DB_DEF_IOSIZE	(8 * 1024)   /*I  * Aligning items to particular sizes or in pages or memory.  ALIGNP is a I  * separate macro, as we've had to cast the pointer to different integral $  * types on different architectures.  *J  * We cast pointers into unsigned longs when manipulating them because C89M  * guarantees that u_long is the largest available integral type and further, K  * to never generate overflows.  However, neither C89 or C9X  requires that K  * any integer type be large enough to hold a pointer, although C9X created J  * the intptr_t type, which is guaranteed to hold a pointer but may or mayK  * not exist.  At some point in the future, we should test for intptr_t and   * use it where available.  */  #undef	ALIGNTYPE #define	ALIGNTYPE		u_long 
 #undef	ALIGNP ; #define	ALIGNP(value, bound)	ALIGN((ALIGNTYPE)value, bound)  #undef	ALIGNF #define	ALIGN(value, bound)	(((value) + (bound) - 1) & ~((bound) - 1))   /*M  * There are several on-page structures that are declared to have a number of K  * fields followed by a variable length array of items.  The structure size M  * without including the variable length array or the address of the first of )  * those elements can be found using SSZ.   *M  * This macro can also be used to find the offset of a structure element in a M  * structure.  This is used in various places to copy structure elements from B  * unaligned memory references, e.g., pointers into a packed page.  *M  * There are two versions because compilers object if you take the address of   * an array.  */ 
 #undef	SSZ5 #define SSZ(name, field)	((int)&(((name *)0)->field))    #undef	SSZA 9 #define SSZA(name, field)	((int)&(((name *)0)->field[0]))   L /* Macros to return per-process address, offsets based on shared regions. */L #define	R_ADDR(base, offset)	((void *)((u_int8_t *)((base)->addr) + offset))F #define	R_OFFSET(base, p)	((u_int8_t *)(p) - (u_int8_t *)(base)->addr)  8 #define	DB_DEFAULT	0x000000	/* No flag was specified. */  * /* Structure used to print flag values. */ typedef struct __fn { $ 	u_int32_t mask;			/* Flag value. */$ 	const char *name;		/* Flag name. */ } FN;     /* Set, clear and test flags. */% #define	F_SET(p, f)	(p)->flags |= (f) & #define	F_CLR(p, f)	(p)->flags &= ~(f)( #define	F_ISSET(p, f)	((p)->flags & (f))  #define	LF_SET(f)	(flags |= (f))! #define	LF_CLR(f)	(flags &= ~(f)) ! #define	LF_ISSET(f)	(flags & (f))    /*  * Panic check: F  * All interfaces check the panic flag, if it's set, the tree is dead.  */ $ #define	DB_PANIC_CHECK(dbp) {						\; 	if ((dbp)->dbenv != NULL && (dbp)->dbenv->db_panic != 0)	\  		return (DB_RUNRECOVERY);				\  }    /* Display separator string. */  #undef	DB_LINEC #define	DB_LINE "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-="   H /* Unused, or not-used-yet variable.  "Shut that bloody compiler up!" */! #define	COMPQUIET(n, v)	(n) = (v)    /*L  * Purify and similar run-time tools complain about unitialized reads/writes6  * for structure fields whose only purpose is padding.  */  #define	UMRW(v)		(v) = 0   /*I  * Win16 needs specific syntax on callback functions.  Nobody else cares.   */  #ifndef	DB_CALLBACK " #define	DB_CALLBACK	/* Nothing. */ #endif  8 /*******************************************************	  * Files. 9  *******************************************************/   /* M   * We use 1024 as the maximum path length.  It's too hard to figure out what M   * the real path length is, as it was traditionally stored in <sys/param.h>, )   * and that file isn't always available.    */ #undef	MAXPATHLEN  #define	MAXPATHLEN	1024   5 #define	PATH_DOT	"."	/* Current working directory. */ : #define	PATH_SEPARATOR	"/"	/* Path separator character. */  8 /*******************************************************  * Mutex support. 9  *******************************************************/  #include <sys/mman.h>  typedef unsigned char tsl_t;   /*  * !!!L  * Various systems require different alignments for mutexes (the worst we'veM  * seen so far is 16-bytes on some HP architectures).  The mutex (tsl_t) must J  * be first in the db_mutex_t structure, which must itself be first in theN  * region.  This ensures the alignment is as returned by mmap(2), which shouldN  * be sufficient.  All other mutex users must ensure proper alignment locally.  */ , #define	MUTEX_ALIGNMENT	sizeof(unsigned int)   /*#  * The offset of a mutex in memory.   *  * !!!H  * Not an off_t, so backing file offsets MUST be less than 4Gb.  See the'  * off field of the db_mutex_t as well.   */ L #define	MUTEX_LOCK_OFFSET(a, b)	((u_int32_t)((u_int8_t *)b - (u_int8_t *)a))   typedef struct _db_mutex_t { #ifdef HAVE_SPINLOCKS 4 	tsl_t	  tsl_resource;		/* Resource test and set. */ #ifdef DIAGNOSTIC 6 	u_int32_t pid;			/* Lock holder: 0 or process pid. */ #endif #else , 	u_int32_t off;			/* Backing file offset. */6 	u_int32_t pid;			/* Lock holder: 0 or process pid. */ #endif, 	u_int32_t spins;		/* Spins before block. */4 	u_int32_t mutex_set_wait;	/* Granted after wait. */; 	u_int32_t mutex_set_nowait;	/* Granted without waiting. */ 
 } db_mutex_t;    #include "mutex_ext.h"  8 /*******************************************************  * Access methods.9  *******************************************************/  /* Lock/unlock a DB thread. */" #define	DB_THREAD_LOCK(dbp)						\& 	if (F_ISSET(dbp, DB_AM_THREAD))					\< 	    (void)__db_mutex_lock((db_mutex_t *)(dbp)->mutexp, -1);$ #define	DB_THREAD_UNLOCK(dbp)						\& 	if (F_ISSET(dbp, DB_AM_THREAD))					\> 	    (void)__db_mutex_unlock((db_mutex_t *)(dbp)->mutexp, -1);  8 /*******************************************************  * Environment. 9  *******************************************************/ $ /* Type passed to __db_appname(). */ typedef enum {) 	DB_APP_NONE=0,			/* No type (region). */   	DB_APP_DATA,			/* Data file. */ 	DB_APP_LOG,			/* Log file. */# 	DB_APP_TMP			/* Temporary file. */ 
 } APPNAME;  8 /*******************************************************  * Shared memory regions. 9  *******************************************************/  /*K  * The shared memory regions share an initial structure so that the general J  * region code can handle races between the region being deleted and other)  * processes waiting on the region mutex.   *  * !!!L  * Note, the mutex must be the first entry in the region; see comment above.  */  typedef struct _rlayout { & 	db_mutex_t lock;		/* Region mutex. */ #define	DB_REGIONMAGIC	0x120897 - 	u_int32_t  valid;		/* Valid magic number. */ 2 	u_int32_t  refcnt;		/* Region reference count. */& 	size_t	   size;		/* Region length. */, 	int	   majver;		/* Major version number. */, 	int	   minver;		/* Minor version number. */+ 	int	   patch;		/* Patch version number. */ % 	int	   panic;		/* Region is dead. */  #define	INVALID_SEGID	-18 	int	   segid;		/* shmget(2) ID, or Win16 segment ID. */  D #define	REGION_ANONYMOUS	0x01	/* Region is/should be in anon mem. */ 	u_int32_t  flags;
 } RLAYOUT;   /*I  * DB creates all regions on 4K boundaries out of sheer paranoia, so that +  * we don't make the underlying VM unhappy.   */*  #define	DB_VMPAGESIZE	(4 * 1024)& #define	DB_ROUNDOFF(n, round) {						\ 	(n) += (round) - 1;						\n 	(n) -= (n) % (round);						\t })   /*K  * The interface to region attach is nasty, there is a lot of complex stuff.L  * going on, which has to be retained between create/attach and detach.  The'  * REGINFO structure keeps track of it.a  */ 9 struct __db_reginfo;	typedef struct __db_reginfo REGINFO;* struct __db_reginfo {* 					/* Arguments. */l- 	DB_ENV	   *dbenv;		/* Region naming info. */*0 	APPNAME	    appname;		/* Region naming info. */* 	char	   *path;		/* Region naming info. */- 	const char *file;		/* Region naming info. */*- 	int	    mode;		/* Region mode, if a file. */P% 	size_t	    size;		/* Region size. */ ? 	u_int32_t   dbflags;		/* Region file open flags, if a file. */f   					/* Results. */M# 	char	   *name;		/* Region name. */A& 	void	   *addr;		/* Region address. */3 	int	    fd;			/* Fcntl(2) locking file descriptor.e+ 					   NB: this is only valid if a regulars* 					   file is backing the shared region,+ 					   and mmap(2) is being used to map itn" 					   into our address space. */9 	int	    segid;		/* shmget(2) ID, or Win16 segment ID. */a+ 	void	   *wnt_handle;		/* Win/NT HANDLE. */    					/* Shared flags. */3 /*				0x0001	COMMON MASK with RLAYOUT structure. */ . #define	REGION_CANGROW		0x0002	/* Can grow. */- #define	REGION_CREATED		0x0004	/* Created. */ @ #define	REGION_HOLDINGSYS	0x0008	/* Holding system resources. */= #define	REGION_LASTDETACH	0x0010	/* Delete on last detach. */o? #define	REGION_MALLOC		0x0020	/* Created in malloc'd memory. */e? #define	REGION_PRIVATE		0x0040	/* Private to thread/process. */i5 #define	REGION_REMOVED		0x0080	/* Already deleted. */tG #define	REGION_SIZEDEF		0x0100	/* Use default region size if exists. */L 	u_int32_t   flags;d };  8 /*******************************************************	  * Mpool.u9  *******************************************************/  /*J  * File types for DB access methods.  Negative numbers are reserved to DB.  */e' #define	DB_FTYPE_BTREE		-1	/* Btree. */d% #define	DB_FTYPE_HASH		-2	/* Hash. */T  3 /* Structure used as the DB pgin/pgout pgcookie. */e typedef struct __dbpginfo {t1 	size_t	db_pagesize;		/* Underlying page size. */S+ 	int	needswap;		/* If swapping required. */i } DB_PGINFO;  8 /*******************************************************  * Log.p9  *******************************************************/ " /* Initialize an LSN to 'zero'. */ #define	ZERO_LSN(LSN) {							\v 	(LSN).file = 0;							\ 	(LSN).offset = 0;						\e }o  : /* Return 1 if LSN is a 'zero' lsn, otherwise return 0. */* #define	IS_ZERO_LSN(LSN)	((LSN).file == 0)  & /* Test if we need to log a change. */ #define	DB_LOGGING(dbc)							\oC 	(F_ISSET((dbc)->dbp, DB_AM_LOGGING) && !F_ISSET(dbc, DBC_RECOVER))f   #ifdef DIAGNOSTICe /*%  * Debugging macro to log operations.fD  *	If DEBUG_WOP is defined, log operations that modify the database.B  *	If DEBUG_ROP is defined, log operations that read the database.  *  * D dbp  * T txn  * O operation (string)y  * K key	  * A data 
  * F flags  */	( #define	LOG_OP(C, T, O, K, A, F) {					\ 	DB_LSN _lsn;							\  	DBT _op;							\  	if (DB_LOGGING((C))) {						\$ 		memset(&_op, 0, sizeof(_op));				\ 		_op.data = O;						\  		_op.size = strlen(O) + 1;				\3 		(void)__db_debug_log((C)->dbp->dbenv->lg_info,		\F: 		    T, &_lsn, 0, &_op, (C)->dbp->log_fileid, K, A, F);	\ 	}								\n }c #ifdef DEBUG_ROP> #define	DEBUG_LREAD(C, T, O, K, A, F)	LOG_OP(C, T, O, K, A, F) #elsef% #define	DEBUG_LREAD(C, T, O, K, A, F)( #endif #ifdef DEBUG_WOP? #define	DEBUG_LWRITE(C, T, O, K, A, F)	LOG_OP(C, T, O, K, A, F)  #elseD& #define	DEBUG_LWRITE(C, T, O, K, A, F) #endif #elseB% #define	DEBUG_LREAD(C, T, O, K, A, F)=& #define	DEBUG_LWRITE(C, T, O, K, A, F) #endif /* DIAGNOSTIC */   8 /*******************************************************  * Transactions and recovery.a9  *******************************************************/* /*N  * Out of band value for a lock.  The locks are returned to callers as offsetsM  * into the lock regions.  Since the RLAYOUT structure begins all regions, ans4  * offset of 0 is guaranteed not to be a valid lock.  */i #define	LOCK_INVALID	0  4 /* The structure allocated for every transaction. */ struct __db_txn {*8 	DB_TXNMGR	*mgrp;		/* Pointer to transaction manager. */8 	DB_TXN		*parent;	/* Pointer to transaction's parent. *// 	DB_LSN		last_lsn;	/* Lsn of last log write. */ / 	u_int32_t	txnid;		/* Unique transaction id. */ 4 	size_t		off;		/* Detail structure within region. */ 	TAILQ_ENTRY(__db_txn) links;N  A #define	TXN_MALLOC	0x01		/* Structure allocated by TXN system. */f 	u_int32_t	flags;" };  8 /*******************************************************  * Global variables.9  *******************************************************/* /*  * !!!H  * Initialized in os/os_config.c, don't change this unless you change it  * as well.*  */o typedef struct __db_globals {i( 	int db_mutexlocks;		/* DB_MUTEXLOCKS */& 	int db_pageyield;		/* DB_PAGEYIELD */: 	int db_region_anon;		/* DB_REGION_ANON, DB_REGION_NAME */* 	int db_region_init;		/* DB_REGION_INIT */& 	int db_tsl_spins;		/* DB_TSL_SPINS */+ 					/* XA: list of opened environments. */d) 	TAILQ_HEAD(__db_envq, __db_env) db_envq;m
 } DB_GLOBALS;e  % extern	DB_GLOBALS	__db_global_values;_) #define	DB_GLOBAL(v)	__db_global_values.ve   #include "os.h"i #include "os_ext.h"!   #endif /* !_DB_INTERNAL_H_ */effsets MUST be less than 4Gb.  See the'  * off field of the db_mutex_t as well.   */ L #define	MUTEX_LOCK_O                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                