 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */    #include "config.h"    #ifndef lintJ static const char sccsid[] = "@(#)db_appinit.c	10.66 (Sleepycat) 12/7/98"; #endif /* not lint */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <ctype.h> #include <errno.h> #include <stdlib.h>  #include <string.h>  #include <unistd.h>  #endif   #include "db_int.h"  #include "shqueue.h" #include "db_page.h" #include "btree.h" #include "hash.h"  #include "log.h" #include "txn.h" #include "clib_ext.h"  #include "common_ext.h"   > static int __db_home __P((DB_ENV *, const char *, u_int32_t));. static int __db_parse __P((DB_ENV *, char *));C static int __db_tmp_open __P((DB_ENV *, u_int32_t, char *, int *));    /*B  * This conflict array is used for concurrent db access (cdb).  ItB  * uses the same locks as the db_rw_conflict array, but adds an IW%  * mode to be used for write cursors.   */ , static u_int8_t const db_cdb_conflicts[] = { 	/*		N   R   W  IW */  	/*    N */	0,  0,  0,  0, 	/*    R */	0,  0,  1,  0, 	/*    W */	0,  1,  1,  1, 	/*   IW */	0,  0,  1,  1  };   /*  * db_version --  *	Return version information.  */  char *$ db_version(majverp, minverp, patchp)! 	int *majverp, *minverp, *patchp;  {  	if (majverp != NULL)  		*majverp = DB_VERSION_MAJOR; 	if (minverp != NULL)  		*minverp = DB_VERSION_MINOR; 	if (patchp != NULL) 		*patchp = DB_VERSION_PATCH; $ 	return ((char *)DB_VERSION_STRING); }    /*  * db_appinit --*  *	Initialize the application environment.  */  int , db_appinit(db_home, db_config, dbenv, flags) 	const char *db_home;  	char * const *db_config;  	DB_ENV *dbenv;  	u_int32_t flags;  { 
 	FILE *fp; 	int mode, ret;  	char * const *p;  	char *lp, buf[MAXPATHLEN * 2];    	fp = NULL;    	/* Validate arguments. */ 	if (dbenv == NULL)  		return (EINVAL);   #ifdef HAVE_SPINLOCKS  #define	OKFLAGS								\>     (DB_CREATE | DB_INIT_CDB | DB_INIT_LOCK | DB_INIT_LOG |		\B     DB_INIT_MPOOL | DB_INIT_TXN | DB_MPOOL_PRIVATE | DB_NOMMAP |	\B     DB_RECOVER | DB_RECOVER_FATAL | DB_THREAD | DB_TXN_NOSYNC |		\)     DB_USE_ENVIRON | DB_USE_ENVIRON_ROOT)  #else  #define	OKFLAGS								\>     (DB_CREATE | DB_INIT_CDB | DB_INIT_LOCK | DB_INIT_LOG |		\B     DB_INIT_MPOOL | DB_INIT_TXN | DB_MPOOL_PRIVATE | DB_NOMMAP |	\7     DB_RECOVER | DB_RECOVER_FATAL | DB_TXN_NOSYNC |			\ )     DB_USE_ENVIRON | DB_USE_ENVIRON_ROOT)  #endifA 	if ((ret = __db_fchk(dbenv, "db_appinit", flags, OKFLAGS)) != 0)  		return (ret);   " 	/* Transactions imply logging. */ 	if (LF_ISSET(DB_INIT_TXN))  		LF_SET(DB_INIT_LOG);  ' 	/* Convert the db_appinit(3) flags. */  	if (LF_ISSET(DB_THREAD))  		F_SET(dbenv, DB_ENV_THREAD);   	/* Set the database home. */ 3 	if ((ret = __db_home(dbenv, db_home, flags)) != 0)  		goto err;    	/* Parse the config array. */2 	for (p = db_config; p != NULL && *p != NULL; ++p)) 		if ((ret = __db_parse(dbenv, *p)) != 0)  			goto err;   	/*  	 * Parse the config file. 	 *  	 * XXX D 	 * Don't use sprintf(3)/snprintf(3) -- the former is dangerous, andD 	 * the latter isn't standard, and we're manipulating strings handed 	 * us by the application. 	 */ 	if (dbenv->db_home != NULL) {  #define	CONFIG_NAME	"/DB_CONFIG" 		if (strlen(dbenv->db_home) +. 		    strlen(CONFIG_NAME) + 1 > sizeof(buf)) { 			ret = ENAMETOOLONG; 			goto err; 		} $ 		(void)strcpy(buf, dbenv->db_home);! 		(void)strcat(buf, CONFIG_NAME); ' 		if ((fp = fopen(buf, "r")) != NULL) { 0 			while (fgets(buf, sizeof(buf), fp) != NULL) {+ 				if ((lp = strchr(buf, '\n')) == NULL) {  					__db_err(dbenv,+ 					    "%s: line too long", CONFIG_NAME);  					ret = EINVAL; 					goto err; 				}  				*lp = '\0';  				if (buf[0] == '\0' || ) 				    buf[0] == '#' || isspace(buf[0]))  					continue;  , 				if ((ret = __db_parse(dbenv, buf)) != 0) 					goto err; 			} 			(void)fclose(fp);
 			fp = NULL;  		}  	}  % 	/* Set up the tmp directory path. */ I 	if (dbenv->db_tmp_dir == NULL && (ret = __os_tmpdir(dbenv, flags)) != 0)  		goto err;    	/* D 	 * Flag that the structure has been initialized by the application.C 	 * Note, this must be set before calling into the subsystems as it ) 	 * is used when we're doing file naming.  	 */ 	F_SET(dbenv, DB_ENV_APPINIT);   	/* > 	 * If we are doing recovery, remove all the old shared memory 	 * regions. 	 *// 	if (LF_ISSET(DB_RECOVER | DB_RECOVER_FATAL)) { . 		if ((ret = log_unlink(NULL, 1, dbenv)) != 0) 			goto err;/ 		if ((ret = memp_unlink(NULL, 1, dbenv)) != 0)  			goto err;/ 		if ((ret = lock_unlink(NULL, 1, dbenv)) != 0)  			goto err;. 		if ((ret = txn_unlink(NULL, 1, dbenv)) != 0) 			goto err; 	}   	/* " 	 * Create the new shared regions. 	 * @ 	 * Default permissions are read-write for both owner and group. 	 */ 	mode = __db_omode("rwrw--");  	if (LF_ISSET(DB_INIT_CDB)) { ; 		if (LF_ISSET(DB_INIT_LOCK | DB_INIT_LOG | DB_INIT_TXN)) {  			ret = EINVAL; 			goto err; 		}  		F_SET(dbenv, DB_ENV_CDB); ) 		dbenv->lk_conflicts = db_cdb_conflicts; % 		dbenv->lk_modes = DB_LOCK_RW_N + 1; = 		if ((ret = lock_open(NULL, LF_ISSET(DB_CREATE | DB_THREAD), * 		    mode, dbenv, &dbenv->lk_info)) != 0) 			goto err; 	}5 	if (LF_ISSET(DB_INIT_LOCK) && (ret = lock_open(NULL, % 	    LF_ISSET(DB_CREATE | DB_THREAD), ) 	    mode, dbenv, &dbenv->lk_info)) != 0)  		goto err; 3 	if (LF_ISSET(DB_INIT_LOG) && (ret = log_open(NULL, % 	    LF_ISSET(DB_CREATE | DB_THREAD), ) 	    mode, dbenv, &dbenv->lg_info)) != 0)  		goto err; 6 	if (LF_ISSET(DB_INIT_MPOOL) && (ret = memp_open(NULL,D 	    LF_ISSET(DB_CREATE | DB_MPOOL_PRIVATE | DB_NOMMAP | DB_THREAD),) 	    mode, dbenv, &dbenv->mp_info)) != 0)  		goto err; 3 	if (LF_ISSET(DB_INIT_TXN) && (ret = txn_open(NULL, 5 	    LF_ISSET(DB_CREATE | DB_THREAD | DB_TXN_NOSYNC), ) 	    mode, dbenv, &dbenv->tx_info)) != 0)  		goto err;    	/* C 	 * If the application is running with transactions, initialize the D 	 * function tables.  Once that's done, do recovery for any previous 	 * run. 	 */ 	if (LF_ISSET(DB_INIT_TXN)) { - 		if ((ret = __bam_init_recover(dbenv)) != 0)  			goto err;, 		if ((ret = __db_init_recover(dbenv)) != 0) 			goto err;- 		if ((ret = __ham_init_recover(dbenv)) != 0)  			goto err;- 		if ((ret = __log_init_recover(dbenv)) != 0)  			goto err;- 		if ((ret = __txn_init_recover(dbenv)) != 0)  			goto err;  0 		if (LF_ISSET(DB_RECOVER | DB_RECOVER_FATAL) && 		    (ret = __db_apprec(dbenv, 5 		    LF_ISSET(DB_RECOVER | DB_RECOVER_FATAL))) != 0)  			goto err; 	}   	return (ret);   err:	if (fp != NULL) 		(void)fclose(fp);    	(void)db_appexit(dbenv);  	return (ret); }    /*  * db_appexit --2  *	Close down the default application environment.  */  int  db_appexit(dbenv)  	DB_ENV *dbenv;  {  	int ret, t_ret;
 	char **p;  	 	ret = 0;    	/* Close subsystems. */@ 	if (dbenv->tx_info && (t_ret = txn_close(dbenv->tx_info)) != 0) 		if (ret == 0)  			ret = t_ret; A 	if (dbenv->mp_info && (t_ret = memp_close(dbenv->mp_info)) != 0)  		if (ret == 0)  			ret = t_ret; @ 	if (dbenv->lg_info && (t_ret = log_close(dbenv->lg_info)) != 0) 		if (ret == 0)  			ret = t_ret; A 	if (dbenv->lk_info && (t_ret = lock_close(dbenv->lk_info)) != 0)  		if (ret == 0)  			ret = t_ret;   D 	/* Clear initialized flag (after subsystems, it affects naming). */ 	F_CLR(dbenv, DB_ENV_APPINIT);   	/* Free allocated memory. */  	if (dbenv->db_home != NULL) 		__os_freestr(dbenv->db_home); ( 	if ((p = dbenv->db_data_dir) != NULL) { 		for (; *p != NULL; ++p)  			__os_freestr(*p); 		__os_free(dbenv->db_data_dir, ) 		    dbenv->data_cnt * sizeof(char **));  	} 	if (dbenv->db_log_dir != NULL) " 		__os_freestr(dbenv->db_log_dir); 	if (dbenv->db_tmp_dir != NULL) " 		__os_freestr(dbenv->db_tmp_dir);   	return (ret); }    #define	DB_ADDSTR(str) {						\  	if ((str) != NULL) {						\) 		/* If leading slash, start over. */			\  		if (__os_abspath(str)) {				\  			p = start;					\  			slash = 0;					\  		}							\ ) 		/* Append to the current string. */			\  		len = strlen(str);					\ 		if (slash)						\   			*p++ = PATH_SEPARATOR[0];			\ 		memcpy(p, str, len);					\ 		p += len;						\3 		slash = strchr(PATH_SEPARATOR, p[-1]) == NULL;		\r 	}								\  }c   /*  * __db_appname --E  *	Given an optional DB environment, directory and file name and type)E  *	of call, build a path based on the db_appinit(3) rules, and returnu  *	it in allocated space.e  **  * PUBLIC: int __db_appname __P((DB_ENV *,O  * PUBLIC:    APPNAME, const char *, const char *, u_int32_t, int *, char **));   */u inth? __db_appname(dbenv, appname, dir, file, tmp_oflags, fdp, namep)h 	DB_ENV *dbenv;o 	APPNAME appname;. 	const char *dir, *file; 	u_int32_t tmp_oflags;
 	int *fdp; 	char **namep; {(
 	DB_ENV etmp;  	size_t len;2 	int data_entry, ret, slash, tmp_create, tmp_free; 	const char *a, *b, *c;p 	char *p, *start;_   	a = b = c = NULL; 	data_entry = -1;  	tmp_create = tmp_free = 0;n   	/* E 	 * We don't return a name when creating temporary files, just an fd.y 	 * Default to error now.o 	 */ 	if (fdp != NULL)s 		*fdp = -1; 	if (namep != NULL)c 		*namep = NULL;   	/*NG 	 * Absolute path names are never modified.  If the file is an absolute F 	 * path, we're done.  If the directory is, simply append the file and 	 * return.* 	 */( 	if (file != NULL && __os_abspath(file))$ 		return (__os_strdup(file, namep));( 	if (dir != NULL && __os_abspath(dir)) {
 		a = dir; 		goto done; 	}   	/*S$ 	 * DB_ENV  DIR	   APPNAME	   RESULT/ 	 * -------------------------------------------)' 	 * null	   null	   none		   <tmp>/file $ 	 * null	   set	   none		   DIR/file( 	 * set	   null	   none		   DB_HOME/file+ 	 * set	   set	   none		   DB_HOME/DIR/filed 	 *e% 	 * DB_ENV  FILE	   APPNAME	   RESULT / 	 * -------------------------------------------d1 	 * null	   null	   DB_APP_DATA	   <tmp>/<create>d( 	 * null	   set	   DB_APP_DATA	   ./file0 	 * set	   null	   DB_APP_DATA	   <tmp>/<create>9 	 * set	   set	   DB_APP_DATA	   DB_HOME/DB_DATA_DIR/file  	 *d$ 	 * DB_ENV  DIR	   APPNAME	   RESULT/ 	 * -------------------------------------------C, 	 * null	   null	   DB_APP_LOG	   <tmp>/file) 	 * null	   set	   DB_APP_LOG	   DIR/file 8 	 * set	   null	   DB_APP_LOG	   DB_HOME/DB_LOG_DIR/file; 	 * set	   set	   DB_APP_LOG	   DB_HOME/DB_LOG_DIR/DIR/file  	 *n 	 * DB_ENV	   APPNAME	   RESULTE/ 	 * ------------------------------------------- * 	 * null		   DB_APP_TMP*	   <tmp>/<create>6 	 * set		   DB_APP_TMP*	   DB_HOME/DB_TMP_DIR/<create> 	 */ retry:	switch (appname) {U 	case DB_APP_NONE:9 		if (dbenv == NULL || !F_ISSET(dbenv, DB_ENV_APPINIT)) {p 			if (dir == NULL))
 				goto tmp;u 			a = dir; 
 		} else { 			a = dbenv->db_home; 			b = dir;( 		}I 		break; 	case DB_APP_DATA: 		if (dir != NULL) { 			__db_err(dbenv,7 			    "DB_APP_DATA: illegal directory specification");H 			return (EINVAL);  		}a   		if (file == NULL) {  			tmp_create = 1; 			goto tmp; 		} 7 		if (dbenv == NULL || !F_ISSET(dbenv, DB_ENV_APPINIT))  			a = PATH_DOT; 		else { 			a = dbenv->db_home;$ 			if (dbenv->db_data_dir != NULL &&8 			    (b = dbenv->db_data_dir[++data_entry]) == NULL) { 				data_entry = -1; 				b = dbenv->db_data_dir[0]; 			} 		}r 		break; 	case DB_APP_LOG:t9 		if (dbenv == NULL || !F_ISSET(dbenv, DB_ENV_APPINIT)) {  			if (dir == NULL)/
 				goto tmp;b 			a = dir;)
 		} else { 			a = dbenv->db_home; 			b = dbenv->db_log_dir;m 			c = dir;t 		}C 		break; 	case DB_APP_TMP:)$ 		if (dir != NULL || file != NULL) { 			__db_err(dbenv,= 		    "DB_APP_TMP: illegal directory or file specification");  			return (EINVAL);, 		})   		tmp_create = 1;e7 		if (dbenv == NULL || !F_ISSET(dbenv, DB_ENV_APPINIT))t 			goto tmp; 		else { 			a = dbenv->db_home; 			b = dbenv->db_tmp_dir;l 		}  		break; 	}  A 	/* Reference a file from the appropriate temporary directory. */f	 	if (0) { = tmp:		if (dbenv == NULL || !F_ISSET(dbenv, DB_ENV_APPINIT)) {i" 			memset(&etmp, 0, sizeof(etmp));7 			if ((ret = __os_tmpdir(&etmp, DB_USE_ENVIRON)) != 0)p 				return (ret);  			tmp_free = 1; 			a = etmp.db_tmp_dir;t 		} else 			a = dbenv->db_tmp_dir;L 	}   done:	len =d& 	    (a == NULL ? 0 : strlen(a) + 1) +& 	    (b == NULL ? 0 : strlen(b) + 1) +& 	    (c == NULL ? 0 : strlen(c) + 1) ++ 	    (file == NULL ? 0 : strlen(file) + 1);t   	/*yG 	 * Allocate space to hold the current path information, as well as anyeG 	 * temporary space that we're going to need to create a temporary filee	 	 * name.  	 */ #define	DB_TRAIL	"XXXXXX"L 	if ((ret =CD 	    __os_malloc(len + sizeof(DB_TRAIL) + 10, NULL, &start)) != 0) { 		if (tmp_free)r! 			__os_freestr(etmp.db_tmp_dir);1 		return (ret);  	}   	slash = 0;( 	p = start;n 	DB_ADDSTR(a); 	DB_ADDSTR(b); 	DB_ADDSTR(file);r 	*p = '\0';n  > 	/* Discard any space allocated to find the temp directory. */ 	if (tmp_free) {  		__os_freestr(etmp.db_tmp_dir); 		tmp_free = 0;r 	}   	/* @ 	 * If we're opening a data file, see if it exists.  If it does,; 	 * return it, otherwise, try and find another one to open.B 	 */9 	if (data_entry != -1 && __os_exists(start, NULL) != 0) {n 		__os_freestr(start); 		a = b = c = NULL;c
 		goto retry;  	}  ' 	/* Create the file if so requested. */r 	if (tmp_create &&A 	    (ret = __db_tmp_open(dbenv, tmp_oflags, start, fdp)) != 0) {n 		__os_freestr(start); 		return (ret);E 	}   	if (namep == NULL)o 		__os_freestr(start); 	elseB 		*namep = start;) 	return (0); }e   /*  * __db_home --=  *	Find the database home.  */(
 static int  __db_home(dbenv, db_home, flags) 	DB_ENV *dbenv;  	const char *db_home;d 	u_int32_t flags;g {f 	const char *p;o  
 	p = db_home;S  = 	/* Use the environment if it's permitted and initialized. */E #ifdef HAVE_GETUID  	if (LF_ISSET(DB_USE_ENVIRON) ||8 	    (LF_ISSET(DB_USE_ENVIRON_ROOT) && getuid() == 0)) { #elseE  	if (LF_ISSET(DB_USE_ENVIRON)) { #endif& 		if ((p = getenv("DB_HOME")) == NULL) 			p = db_home;  		else if (p[0] == '\0') { 			__db_err(dbenv,/ 			    "illegal DB_HOME environment variable");  			return (EINVAL);i 		}z 	}   	if (p == NULL)b
 		return (0);'  * 	return (__os_strdup(p, &dbenv->db_home)); }    /*  * __db_parse --"  *	Parse a single NAME VALUE pair.  */e
 static int __db_parse(dbenv, s) 	DB_ENV *dbenv;n	 	char *s;d {v	 	int ret;	( 	char *local_s, *name, *value, **p, *tp;   	/*)? 	 * We need to strdup the argument in case the caller passed us= 	 * static data. 	 */+ 	if ((ret = __os_strdup(s, &local_s)) != 0)	 		return (ret);f   	/*SE 	 * Name/value pairs are parsed as two white-space separated strings. C 	 * Leading and trailing white-space is trimmed from the value, but E 	 * it may contain embedded white-space.  Note: we use the isspace(3)(E 	 * macro because it's more portable, but that means that you can use*6 	 * characters like form-feed to separate the strings. 	 */ 	name = local_s;4 	for (tp = name; *tp != '\0' && !isspace(*tp); ++tp) 		;t 	if (*tp == '\0' || tp == name)/ 		goto illegal;i 	*tp = '\0'; 	for (++tp; isspace(*tp); ++tp)) 		;f 	if (*tp == '\0')t 		goto illegal;d 	value = tp; 	for (++tp; *tp != '\0'; ++tp) 		;) 	for (--tp; isspace(*tp); --tp)t 		;r 	if (tp == value) {i illegal:	ret = EINVAL;4 		__db_err(dbenv, "illegal name-value pair: %s", s); 		goto err;d 	} 	*++tp = '\0';  : #define	DATA_INIT_CNT	20			/* Start with 20 data slots. */$ 	if (!strcmp(name, "DB_DATA_DIR")) {# 		if (dbenv->db_data_dir == NULL) {n( 			if ((ret = __os_calloc(DATA_INIT_CNT,3 			    sizeof(char **), &dbenv->db_data_dir)) != 0)m
 				goto err;_# 			dbenv->data_cnt = DATA_INIT_CNT; 7 		} else if (dbenv->data_next == dbenv->data_cnt - 1) {p 			dbenv->data_cnt *= 2;/ 			if ((ret = __os_realloc(&dbenv->db_data_dir,t0 			    dbenv->data_cnt * sizeof(char **))) != 0)
 				goto err;  		}s. 		p = &dbenv->db_data_dir[dbenv->data_next++];* 	} else if (!strcmp(name, "DB_LOG_DIR")) {  		if (dbenv->db_log_dir != NULL)# 			__os_freestr(dbenv->db_log_dir);( 		p = &dbenv->db_log_dir;** 	} else if (!strcmp(name, "DB_TMP_DIR")) {  		if (dbenv->db_tmp_dir != NULL)# 			__os_freestr(dbenv->db_tmp_dir);  		p = &dbenv->db_tmp_dir;  	} elser 		goto err;*   	ret = __os_strdup(value, p);\   err:	__os_freestr(local_s);  	return (ret); };   /*  * __db_tmp_open --;  *	Create a temporary file.	  */ 
 static int& __db_tmp_open(dbenv, flags, path, fdp) 	DB_ENV *dbenv;  	u_int32_t flags;  	char *path;
 	int *fdp; {o 	u_long pid; 	int mode, isdir, ret; 	const char *p;u 	char *trv;s   	/*hB 	 * Check the target directory; if you have six X's and it doesn't, 	 * exist, this runs for a *very* long time. 	 */. 	if ((ret = __os_exists(path, &isdir)) != 0) {1 		__db_err(dbenv, "%s: %s", path, strerror(ret));d 		return (ret);r 	} 	if (!isdir) {4 		__db_err(dbenv, "%s: %s", path, strerror(EINVAL)); 		return (EINVAL); 	}   	/* Build the path. */& 	for (trv = path; *trv != '\0'; ++trv) 		;  	*trv = PATH_SEPARATOR[0];/ 	for (p = DB_TRAIL; (*++trv = *p) != '\0'; ++p)  		;b   	/* @ 	 * Replace the X's with the process ID.  Pid should be a pid_t,- 	 * but we use unsigned long for portability.r 	 *// 	for (pid = getpid(); *--trv == 'X'; pid /= 10)y 		switch (pid % 10) {n 		case 0: *trv = '0'; break; 		case 1: *trv = '1'; break; 		case 2: *trv = '2'; break; 		case 3: *trv = '3'; break; 		case 4: *trv = '4'; break; 		case 5: *trv = '5'; break; 		case 6: *trv = '6'; break; 		case 7: *trv = '7'; break; 		case 8: *trv = '8'; break; 		case 9: *trv = '9'; break; 		}e 	++trv;s  " 	/* Set up open flags and mode. */ 	LF_SET(DB_CREATE | DB_EXCL);  	mode = __db_omode("rw----");S  # 	/* Loop, trying to open a file. */  	for (;;) {-< 		if ((ret = __db_open(path, flags, flags, mode, fdp)) == 0) 			return (0);   		/*	 		 * XXX:n< 		 * If we don't get an EEXIST error, then there's something; 		 * seriously wrong.  Unfortunately, if the implementation < 		 * doesn't return EEXIST for O_CREAT and O_EXCL regardless* 		 * of other possible errors, we've lost. 		 */< 		if (ret != EEXIST) { 			__db_err(dbenv,0 			    "tmp_open: %s: %s", path, strerror(ret)); 			return (ret); 		}    		/*8 		 * Tricky little algorithm for backward compatibility.9 		 * Assumes the ASCII ordering of lower-case characters.- 		 */- 		for (;;) { 			if (*trv == '\0') 				return (EINVAL); 			if (*trv == 'z')P 				*trv++ = 'a'; 	 			else {n 				if (isdigit(*trv)) 					*trv = 'a'; 				else 					++*trv;
 				break; 			} 		}L 	} 	/* NOTREACHED */  } _ENV	   APPNAME	   RESULTE/ 	 * ------------------------------------------- * 	 * null		   DB_APP_TMP*	   <tmp>/<create>6 	 * set		   DB_APP_TMP*	   DB_HOME/DB_TMP_DIR/<create> 	 */ retry:	switch (appname) {U 	case DB_APP_NONE:9 		if (dbenv == NULL || !F_ISSET(dbenv, DB_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                