 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */    #include "config.h"    #ifndef lintF static const char sccsid[] = "@(#)db_dup.c	10.35 (Sleepycat) 12/2/98"; #endif /* not lint */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <string.h>  #endif   #include "db_int.h"  #include "db_page.h" #include "btree.h" #include "db_am.h"  # static int __db_addpage __P((DBC *, ?     PAGE **, db_indx_t *, int (*)(DBC *, u_int32_t, PAGE **))); " static int __db_dsplit __P((DBC *,J     PAGE **, db_indx_t *, u_int32_t, int (*)(DBC *, u_int32_t, PAGE **)));   /*  * __db_dput -- A  *	Put a duplicate item onto a duplicate page at the given index.   *+  * PUBLIC: int __db_dput __P((DBC *, DBT *, I  * PUBLIC:    PAGE **, db_indx_t *, int (*)(DBC *, u_int32_t, PAGE **)));   */  int ' __db_dput(dbc, dbt, pp, indxp, newfunc) 
 	DBC *dbc;
 	DBT *dbt; 	PAGE **pp;  	db_indx_t *indxp;1 	int (*newfunc) __P((DBC *, u_int32_t, PAGE **));  {  	BOVERFLOW bo;$ 	DBT *data_dbtp, hdr_dbt, *hdr_dbtp;
 	PAGE *pagep;  	db_indx_t size, isize;  	db_pgno_t pgno;	 	int ret;    	/* D 	 * We need some access method independent threshold for when we put+ 	 * a duplicate item onto an overflow page.  	 */+ 	if (dbt->size > 0.25 * dbc->dbp->pgsize) { 7 		if ((ret = __db_poff(dbc, dbt, &pgno, newfunc)) != 0)  			return (ret); 		UMRW(bo.unused1); ! 		B_TSET(bo.type, B_OVERFLOW, 0);  		UMRW(bo.unused2);  		bo.tlen = dbt->size; 		bo.pgno = pgno;  		hdr_dbt.data = &bo; ( 		hdr_dbt.size = isize = BOVERFLOW_SIZE; 		hdr_dbtp = &hdr_dbt; 		size = BOVERFLOW_PSIZE;  		data_dbtp = NULL; 	 	} else { # 		size = BKEYDATA_PSIZE(dbt->size); # 		isize = BKEYDATA_SIZE(dbt->size);  		hdr_dbtp = NULL; 		data_dbtp = dbt; 	}  
 	pagep = *pp; ! 	if (size > P_FREESPACE(pagep)) { ? 		if (*indxp == NUM_ENT(*pp) && NEXT_PGNO(*pp) == PGNO_INVALID) / 			ret = __db_addpage(dbc, pp, indxp, newfunc);  		else5 			ret = __db_dsplit(dbc, pp, indxp, isize, newfunc);  		if (ret != 0)  			/* 	 			 * XXX & 			 * Pages not returned to free list. 			 */ 			return (ret); 		pagep = *pp; 	}   	/* E 	 * Now, pagep references the page on which to insert and indx is the  	 * the location to insert.  	 */ 	if ((ret = __db_pitem(dbc, A 	    pagep, (u_int32_t)*indxp, isize, hdr_dbtp, data_dbtp)) != 0)  		return (ret);   7 	(void)memp_fset(dbc->dbp->mpf, pagep, DB_MPOOL_DIRTY);  	return (0); }    /*  * __db_drem -- ;  *	Remove a duplicate at the given index on the given page.   *$  * PUBLIC: int __db_drem __P((DBC *,;  * PUBLIC:    PAGE **, u_int32_t, int (*)(DBC *, PAGE *)));   */  int " __db_drem(dbc, pp, indx, freefunc)
 	DBC *dbc; 	PAGE **pp;  	u_int32_t indx;& 	int (*freefunc) __P((DBC *, PAGE *)); { 
 	PAGE *pagep; 	 	int ret;   
 	pagep = *pp;   * 	/* Check if we are freeing a big item. */= 	if (B_TYPE(GET_BKEYDATA(pagep, indx)->type) == B_OVERFLOW) {  		if ((ret = __db_doff(dbc, 8 		    GET_BOVERFLOW(pagep, indx)->pgno, freefunc)) != 0) 			return (ret);5 		ret = __db_ditem(dbc, pagep, indx, BOVERFLOW_SIZE);  	} else $ 		ret = __db_ditem(dbc, pagep, indx,5 		    BKEYDATA_SIZE(GET_BKEYDATA(pagep, indx)->len));  	if (ret != 0) 		return (ret);    	if (NUM_ENT(pagep) == 0) {  		/*> 		 * If the page is emptied, then the page is freed and the pp? 		 * parameter is set to reference the next, locked page in the @ 		 * duplicate chain, if one exists.  If there was no such page, 		 * then it is set to NULL. 		 * 		 * !!!/ 		 * __db_relink will set the dirty bit for us.  		 */ ? 		if ((ret = __db_relink(dbc, DB_REM_PAGE, pagep, pp, 0)) != 0)  			return (ret);( 		if ((ret = freefunc(dbc, pagep)) != 0) 			return (ret); 	} else 8 		(void)memp_fset(dbc->dbp->mpf, pagep, DB_MPOOL_DIRTY);   	return (0); }    /*  * __db_dend -- 5  *	Find the last page in a set of offpage duplicates.   *:  * PUBLIC: int __db_dend __P((DBC *, db_pgno_t, PAGE **));  */  int  __db_dend(dbc, pgno, pp)
 	DBC *dbc; 	db_pgno_t pgno; 	PAGE **pp;  { 	 	DB *dbp; 	 	PAGE *h; 	 	int ret;    	dbp = dbc->dbp;   	/* F 	 * This implements DB_KEYLAST.  The last page is returned in pp; pgnoG 	 * should be the page number of the first page of the duplicate chain.  	 * 8 	 * *pp may be non-NULL -- if given a valid page use it. 	 */ 	if (*pp != NULL)  		goto started;  	for (;;) { 7 		if ((ret = memp_fget(dbp->mpf, &pgno, 0, pp)) != 0) {  			(void)__db_pgerr(dbp, pgno);  			return (ret); 		}  started:	h = *pp;   , 		if ((pgno = NEXT_PGNO(h)) == PGNO_INVALID)	 			break;   - 		if ((ret = memp_fput(dbp->mpf, h, 0)) != 0)  			return (ret); 	} 	return (0); }    /*  * __db_dsplit -- @  *	Split a page of duplicates, calculating the split point based8  *	on an element of size "size" being added at "*indxp".E  *	On entry hp contains a pointer to the page-pointer of the original G  *	page.  On exit, it returns a pointer to the page containing "*indxp" E  *	and "indxp" has been modified to reflect the index on the new page @  *	where the element should be added.  The function returns with;  *	the page on which the insert should happen, not yet put.   */ 
 static int* __db_dsplit(dbc, hp, indxp, size, newfunc)
 	DBC *dbc; 	PAGE **hp;  	db_indx_t *indxp; 	u_int32_t size;1 	int (*newfunc) __P((DBC *, u_int32_t, PAGE **));  {  	PAGE *h, *np, *tp;  	BKEYDATA *bk; 	DBT page_dbt;	 	DB *dbp;  	size_t pgsize; ? 	db_indx_t halfbytes, i, indx, lastsum, nindex, oindex, s, sum;  	int did_indx, ret, t_ret;  	 	h = *hp;  	indx = *indxp; 	 	ret = 0;  	dbp = dbc->dbp; 	pgsize = dbp->pgsize;  5 	/* Create a temporary page to do compaction onto. */ 1 	if ((ret = __os_malloc(pgsize, NULL, &tp)) != 0)  		return (ret);   % 	/* Create new page for the split. */ 3 	if ((ret = newfunc(dbc, P_DUPLICATE, &np)) != 0) {  		__os_free(tp, pgsize); 		return (ret);  	}  7 	P_INIT(np, pgsize, PGNO(np), PGNO(h), NEXT_PGNO(h), 0,  	    P_DUPLICATE);7 	P_INIT(tp, pgsize, PGNO(h), PREV_PGNO(h), PGNO(np), 0,  	    P_DUPLICATE);  ! 	/* Figure out the split point */ ' 	halfbytes = (pgsize - HOFFSET(h)) / 2;  	did_indx = 0;9 	for (sum = 0, lastsum = 0, i = 0; i < NUM_ENT(h); i++) {  		if (i == indx) { 			sum += size;  			did_indx = 1;1 			if (lastsum < halfbytes && sum >= halfbytes) { * 				/* We've crossed the halfway point. */* 				if ((db_indx_t)(halfbytes - lastsum) <' 				    (db_indx_t)(sum - halfbytes)) {  					*hp = np; 					*indxp = 0;
 				} else 					*indxp = i;
 				break; 			} 			*indxp = i; 			lastsum = sum;  		} 4 		if (B_TYPE(GET_BKEYDATA(h, i)->type) == B_KEYDATA)1 			sum += BKEYDATA_SIZE(GET_BKEYDATA(h, i)->len);  		else 			sum += BOVERFLOW_SIZE;   0 		if (lastsum < halfbytes && sum >= halfbytes) {) 			/* We've crossed the halfway point. */ % 			if ((db_indx_t)(sum - halfbytes) < ( 			    (db_indx_t)(halfbytes - lastsum)) 				i++;	 			break;  		}  	} 	/* C 	 * Check if we have set the return values of the index pointer and  	 * page pointer.  	 */ 	if (!did_indx) {  		*hp = np;  		*indxp = indx - i; 	}   	if (DB_LOGGING(dbc)) {  		page_dbt.size = dbp->pgsize; 		page_dbt.data = h;0 		if ((ret = __db_split_log(dbp->dbenv->lg_info,9 		    dbc->txn, &LSN(h), 0, DB_SPLITOLD, dbp->log_fileid, + 		    PGNO(h), &page_dbt, &LSN(h))) != 0) {  			__os_free(tp, pgsize);  			return (ret); 		}  		LSN(tp) = LSN(h);  	}   	/* ( 	 * If it's a btree, adjust the cursors. 	 * B 	 * i is the index of the first element to move onto the new page. 	 */ 	if (dbp->type == DB_BTREE) 8 		__bam_ca_split(dbp, PGNO(h), PGNO(h), PGNO(np), i, 0);  > 	for (nindex = 0, oindex = i; oindex < NUM_ENT(h); oindex++) { 		bk = GET_BKEYDATA(h, oindex); $ 		if (B_TYPE(bk->type) == B_KEYDATA) 			s = BKEYDATA_SIZE(bk->len); 		else 			s = BOVERFLOW_SIZE;  ' 		np->inp[nindex++] = HOFFSET(np) -= s; . 		memcpy((u_int8_t *)np + HOFFSET(np), bk, s); 		NUM_ENT(np)++; 	}   	/* B 	 * Now do data compaction by copying the remaining stuff onto the= 	 * temporary page and then copying it back to the real page.  	 */5 	for (nindex = 0, oindex = 0; oindex < i; oindex++) {  		bk = GET_BKEYDATA(h, oindex);E$ 		if (B_TYPE(bk->type) == B_KEYDATA) 			s = BKEYDATA_SIZE(bk->len); 		else 			s = BOVERFLOW_SIZE;  ' 		tp->inp[nindex++] = HOFFSET(tp) -= s;f. 		memcpy((u_int8_t *)tp + HOFFSET(tp), bk, s); 		NUM_ENT(tp)++; 	}   	/*eD 	 * This page (the temporary) should be only half full, so we do twoC 	 * memcpy's, one for the top of the page and one for the bottom of C 	 * the page.  This way we avoid copying the middle which should be. 	 * about half a page. 	 */ 	memcpy(h, tp, LOFFSET(tp));$ 	memcpy((u_int8_t *)h + HOFFSET(tp),9 	    (u_int8_t *)tp + HOFFSET(tp), pgsize - HOFFSET(tp));( 	__os_free(tp, pgsize);n   	if (DB_LOGGING(dbc)) {D 		/* 		 * XXX; 		 * If either of these fails, are we leaving pages pinned? 7 		 * Yes, but it seems like this happens in error case.: 		 */d 		page_dbt.size = pgsize;  		page_dbt.data = h;0 		if ((ret = __db_split_log(dbp->dbenv->lg_info,9 		    dbc->txn, &LSN(h), 0, DB_SPLITNEW, dbp->log_fileid,D) 		    PGNO(h), &page_dbt, &LSN(h))) != 0)x 			return (ret);   		page_dbt.size = pgsize;_ 		page_dbt.data = np;V0 		if ((ret = __db_split_log(dbp->dbenv->lg_info,: 		    dbc->txn, &LSN(np), 0, DB_SPLITNEW, dbp->log_fileid,, 		    PGNO(np),  &page_dbt, &LSN(np))) != 0) 			return (ret); 	}   	/*r: 	 * Finally, if there was a next page after the page being  	 * split, fix its prev pointer. 	 */# 	if (np->next_pgno != PGNO_INVALID)c6 	    ret = __db_relink(dbc, DB_ADD_PAGE, np, NULL, 1);   	/*s@ 	 * Figure out if the location we're interested in is on the new@ 	 * page, and if so, reset the callers' pointer.  Push the other 	 * page back to the store.V 	 */ 	if (*hp == h)2 		t_ret = memp_fput(dbp->mpf, np, DB_MPOOL_DIRTY); 	elseU1 		t_ret = memp_fput(dbp->mpf, h, DB_MPOOL_DIRTY);)  ! 	return (ret != 0 ? ret : t_ret);) }    /*  * __db_ditem --  *	Remove an item from a page.  *F  * PUBLIC:  int __db_ditem __P((DBC *, PAGE *, u_int32_t, u_int32_t));  */N int)$ __db_ditem(dbc, pagep, indx, nbytes)
 	DBC *dbc;
 	PAGE *pagep;) 	u_int32_t indx, nbytes; {l	 	DB *dbp; 
 	DBT ldbt; 	db_indx_t cnt, offset;=	 	int ret;  	u_int8_t *from;   	dbp = dbc->dbp; 	if (DB_LOGGING(dbc)) {	# 		ldbt.data = P_ENTRY(pagep, indx);  		ldbt.size = nbytes;f; 		if ((ret = __db_addrem_log(dbp->dbenv->lg_info, dbc->txn, ? 		    &LSN(pagep), 0, DB_REM_DUP, dbp->log_fileid, PGNO(pagep),g? 		    (u_int32_t)indx, nbytes, &ldbt, NULL, &LSN(pagep))) != 0)u 			return (ret); 	}   	/*t? 	 * If there's only a single item on the page, we don't have to  	 * work hard. 	 */ 	if (NUM_ENT(pagep) == 1) {n 		NUM_ENT(pagep) = 0;e 		HOFFSET(pagep) = dbp->pgsize;_
 		return (0);P 	}   	/*AB 	 * Pack the remaining key/data items at the end of the page.  Use( 	 * memmove(3), the regions may overlap. 	 */+ 	from = (u_int8_t *)pagep + HOFFSET(pagep);BA 	memmove(from + nbytes, from, pagep->inp[indx] - HOFFSET(pagep));  	HOFFSET(pagep) += nbytes;  # 	/* Adjust the indices' offsets. */A 	offset = pagep->inp[indx];R+ 	for (cnt = 0; cnt < NUM_ENT(pagep); ++cnt)  		if (pagep->inp[cnt] < offset)  			pagep->inp[cnt] += nbytes;t   	/* Shift the indices down. */ 	--NUM_ENT(pagep); 	if (indx != NUM_ENT(pagep))3 		memmove(&pagep->inp[indx], &pagep->inp[indx + 1],A3 		    sizeof(db_indx_t) * (NUM_ENT(pagep) - indx));e  + 	/* If it's a btree, adjust the cursors. */* 	if (dbp->type == DB_BTREE) * 		__bam_ca_di(dbp, PGNO(pagep), indx, -1);   	return (0); }e   /*  * __db_pitem --  *	Put an item on a page.n  *  * PUBLIC: int __db_pitemnH  * PUBLIC:     __P((DBC *, PAGE *, u_int32_t, u_int32_t, DBT *, DBT *));  */l int / __db_pitem(dbc, pagep, indx, nbytes, hdr, data)_
 	DBC *dbc;
 	PAGE *pagep;g 	u_int32_t indx; 	u_int32_t nbytes; 	DBT *hdr, *data;n {b	 	DB *dbp;!
 	BKEYDATA bk; 
 	DBT thdr;	 	int ret;i
 	u_int8_t *p;-   	/*pC 	 * Put a single item onto a page.  The logic figuring out where to C 	 * insert and whether it fits is handled in the caller.  All we doIE 	 * here is manage the page shuffling.  We cheat a little bit in thatnC 	 * we don't want to copy the dbt on a normal put twice.  If hdr is E 	 * NULL, we create a BKEYDATA structure on the page, otherwise, justp0 	 * copy the caller's information onto the page. 	 *gD 	 * This routine is also used to put entries onto the page where theE 	 * entry is pre-built, e.g., during recovery.  In this case, the hdr @ 	 * will point to the entry, and the data argument will be NULL. 	 *m 	 * !!!dD 	 * There's a tremendous potential for off-by-one errors here, sinceC 	 * the passed in header sizes must be adjusted for the structure's)< 	 * placeholder for the trailing variable-length data field. 	 */ 	dbp = dbc->dbp; 	if (DB_LOGGING(dbc))r; 		if ((ret = __db_addrem_log(dbp->dbenv->lg_info, dbc->txn,i? 		    &LSN(pagep), 0, DB_ADD_DUP, dbp->log_fileid, PGNO(pagep),e= 		    (u_int32_t)indx, nbytes, hdr, data, &LSN(pagep))) != 0)n 			return (ret);   	if (hdr == NULL) {   		B_TSET(bk.type, B_KEYDATA, 0);) 		bk.len = data == NULL ? 0 : data->size;a   		thdr.data = &bk;# 		thdr.size = SSZA(BKEYDATA, data);w 		hdr = &thdr; 	}  = 	/* Adjust the index table, then put the item on the page. */  	if (indx != NUM_ENT(pagep))3 		memmove(&pagep->inp[indx + 1], &pagep->inp[indx],,3 		    sizeof(db_indx_t) * (NUM_ENT(pagep) - indx));  	HOFFSET(pagep) -= nbytes;# 	pagep->inp[indx] = HOFFSET(pagep);  	++NUM_ENT(pagep);   	p = P_ENTRY(pagep, indx);! 	memcpy(p, hdr->data, hdr->size);  	if (data != NULL)0 		memcpy(p + hdr->size, data->data, data->size);  + 	/* If it's a btree, adjust the cursors. */; 	if (dbp->type == DB_BTREE)p) 		__bam_ca_di(dbp, PGNO(pagep), indx, 1);    	return (0); }    /*  * __db_relink --o   *	Relink around a deleted page.  *I  * PUBLIC: int __db_relink __P((DBC *, u_int32_t, PAGE *, PAGE **, int));p  */o int 4 __db_relink(dbc, add_rem, pagep, new_next, needlock)
 	DBC *dbc; 	u_int32_t add_rem;e 	PAGE *pagep, **new_next;  	int needlock; { 	 	DB *dbp;G 	PAGE *np, *pp;h 	DB_LOCK npl, ppl; 	DB_LSN *nlsnp, *plsnp;e	 	int ret;P  	 	ret = 0;P 	np = pp = NULL; 	npl = ppl = LOCK_INVALID; 	nlsnp = plsnp = NULL; 	dbp = dbc->dbp;   	/*HC 	 * Retrieve and lock the one/two pages.  For a remove, we may neediC 	 * two pages (the before and after).  For an add, we only need onei- 	 * because, the split took care of the prev.h 	 */( 	if (pagep->next_pgno != PGNO_INVALID) {( 		if (needlock && (ret = __bam_lget(dbc,6 		    0, pagep->next_pgno, DB_LOCK_WRITE, &npl)) != 0) 			goto err;  		if ((ret = memp_fget(dbp->mpf,) 		    &pagep->next_pgno, 0, &np)) != 0) { + 			(void)__db_pgerr(dbp, pagep->next_pgno);T 			goto err; 		}p 		nlsnp = &np->lsn;s 	}B 	if (add_rem == DB_REM_PAGE && pagep->prev_pgno != PGNO_INVALID) {( 		if (needlock && (ret = __bam_lget(dbc,6 		    0, pagep->prev_pgno, DB_LOCK_WRITE, &ppl)) != 0) 			goto err;  		if ((ret = memp_fget(dbp->mpf,) 		    &pagep->prev_pgno, 0, &pp)) != 0) { + 			(void)__db_pgerr(dbp, pagep->next_pgno);c 			goto err; 		}e 		plsnp = &pp->lsn;  	}   	/* Log the change. */ 	if (DB_LOGGING(dbc)) {_; 		if ((ret = __db_relink_log(dbp->dbenv->lg_info, dbc->txn,O/ 		    &pagep->lsn, 0, add_rem, dbp->log_fileid,	 		    pagep->pgno, &pagep->lsn,_> 		    pagep->prev_pgno, plsnp, pagep->next_pgno, nlsnp)) != 0) 			goto err; 		if (np != NULL)	 			np->lsn = pagep->lsn; 		if (pp != NULL)	 			pp->lsn = pagep->lsn; 	}   	/*r% 	 * Modify and release the two pages.  	 *  	 * !!!'E 	 * The parameter new_next gets set to the page following the page welD 	 * are removing.  If there is no following page, then new_next gets 	 * set to NULL. 	 */ 	if (np != NULL) { 		if (add_rem == DB_ADD_PAGE)0 			np->prev_pgno = pagep->pgno;; 		else$ 			np->prev_pgno = pagep->prev_pgno; 		if (new_next == NULL)=1 			ret = memp_fput(dbp->mpf, np, DB_MPOOL_DIRTY);e 		else { 			*new_next = np;1 			ret = memp_fset(dbp->mpf, np, DB_MPOOL_DIRTY);_ 		}t 		if (ret != 0)p 			goto err; 		if (needlock)} 			(void)__bam_lput(dbc, npl); 	} else if (new_next != NULL)t 		*new_next = NULL;p   	if (pp != NULL) {# 		pp->next_pgno = pagep->next_pgno;/; 		if ((ret = memp_fput(dbp->mpf, pp, DB_MPOOL_DIRTY)) != 0)k 			goto err; 		if (needlock)	 			(void)__bam_lput(dbc, ppl); 	} 	return (0);   err:	if (np != NULL)# 		(void)memp_fput(dbp->mpf, np, 0);[% 	if (needlock && npl != LOCK_INVALID)y 		(void)__bam_lput(dbc, npl);b 	if (pp != NULL)# 		(void)memp_fput(dbp->mpf, pp, 0);e% 	if (needlock && ppl != LOCK_INVALID)o 		(void)__bam_lput(dbc, ppl);o 	return (ret); }g   /*  * __db_ddup --m)  *	Delete an offpage chain of duplicates.i  *I  * PUBLIC: int __db_ddup __P((DBC *, db_pgno_t, int (*)(DBC *, PAGE *)));F  */t int  __db_ddup(dbc, pgno, freefunc)
 	DBC *dbc; 	db_pgno_t pgno;& 	int (*freefunc) __P((DBC *, PAGE *)); {r	 	DB *dbp;z
 	PAGE *pagep;_
 	DBT tmp_dbt;D	 	int ret;*   	dbp = dbc->dbp; 	do {s; 		if ((ret = memp_fget(dbp->mpf, &pgno, 0, &pagep)) != 0) {s 			(void)__db_pgerr(dbp, pgno);: 			return (ret); 		}z   		if (DB_LOGGING(dbc)) { 			tmp_dbt.data = pagep; 			tmp_dbt.size = dbp->pgsize;1 			if ((ret = __db_split_log(dbp->dbenv->lg_info,i- 			    dbc->txn, &LSN(pagep), 0, DB_SPLITOLD,0. 			    dbp->log_fileid, PGNO(pagep), &tmp_dbt, 			    &LSN(pagep))) != 0) 				return (ret);p 		}o 		pgno = pagep->next_pgno;( 		if ((ret = freefunc(dbc, pagep)) != 0) 			return (ret);  	} while (pgno != PGNO_INVALID);   	return (0); }r   /*  * __db_addpage --@  *	Create a new page and link it onto the next_pgno field of the  *	current page.  *//
 static int% __db_addpage(dbc, hp, indxp, newfunc)_
 	DBC *dbc; 	PAGE **hp;G 	db_indx_t *indxp;1 	int (*newfunc) __P((DBC *, u_int32_t, PAGE **));e {n	 	DB *dbp;n 	PAGE *newpage; 	 	int ret;t   	dbp = dbc->dbp;6 	if ((ret = newfunc(dbc, P_DUPLICATE, &newpage)) != 0) 		return (ret);	   	if (DB_LOGGING(dbc)) { 2 		if ((ret = __db_addpage_log(dbp->dbenv->lg_info,. 		    dbc->txn, &LSN(*hp), 0, dbp->log_fileid,B 		    PGNO(*hp), &LSN(*hp), PGNO(newpage), &LSN(newpage))) != 0) { 			return (ret); 		}I 		LSN(newpage) = LSN(*hp); 	}    	PREV_PGNO(newpage) = PGNO(*hp);  	NEXT_PGNO(*hp) = PGNO(newpage);  ; 	if ((ret = memp_fput(dbp->mpf, *hp, DB_MPOOL_DIRTY)) != 0); 		return (ret);  	*hp = newpage;n 	*indxp = 0; 	return (0); }    /*  * __db_dsearch --J  *	Search a set of duplicates for the proper position for a new duplicate.  *E  *	+ pgno is the page number of the page on which to begin searching.bI  * 	  Since we can continue duplicate searches, it might not be the first   * 	  page.2  *F  * 	+ If we are continuing a search, then *pp may be non-NULL in which/  * 	  case we do not have to retrieve the page.g  *B  *	+ If we are continuing a search, then *indxp contains the first2  * 	  on pgno of where we should begin the search.  *@  * 	NOTE: if there is no comparison function, then continuing isA  * 	meaningless, and *pp should always be NULL and *indxp will bev  *	ignored.   *  *	3 return values::  *E  *	+ pp is the returned page pointer of where this element should go.T-  *	+ indxp is the returned index on that paged2  *	+ cmpp is the returned final comparison result.  *'  * PUBLIC: int __db_dsearch __P((DBC *,;D  * PUBLIC:     int, DBT *, db_pgno_t, db_indx_t *, PAGE **, int *));  */  int 8 __db_dsearch(dbc, is_insert, dbt, pgno, indxp, pp, cmpp)
 	DBC *dbc; 	int is_insert, *cmpp;
 	DBT *dbt; 	db_pgno_t pgno; 	db_indx_t *indxp; 	PAGE **pp;  {M	 	DB *dbp; 	 	PAGE *h; & 	db_indx_t base, indx, lim, save_indx; 	db_pgno_t save_pgno;=	 	int ret;    	dbp = dbc->dbp;    	if (dbp->dup_compare == NULL) { 		/*; 		 * We may have been given a valid page, but we may not be*< 		 * able to use it.  The problem is that the application is: 		 * doing a join and we're trying to continue the search,: 		 * but since the items aren't sorted, we can't.  Discard; 		 * the page if it's not the one we're going to start witha 		 * anyway. 		 */B+ 		if (*pp != NULL && (*pp)->pgno != pgno) {_0 			if ((ret = memp_fput(dbp->mpf, *pp, 0)) != 0) 				return (ret);g 			*pp = NULL; 		}n   		/*> 		 * If no duplicate function is specified, just go to the end 		 * of the duplicate set. 		 */c 		if (is_insert) {- 			if ((ret = __db_dend(dbc, pgno, pp)) != 0)n 				return (ret);f 			*indxp = NUM_ENT(*pp);t 			return (0); 		}e   		/*< 		 * We are looking for a specific duplicate, so do a linear 		 * search. 		 */  		if (*pp != NULL) 			goto nocmp_started; 		for (;;) {6 			if ((ret = memp_fget(dbp->mpf, &pgno, 0, pp)) != 0) 				goto pg_err; nocmp_started:		h = *pp;  4 			for (*indxp = 0; *indxp < NUM_ENT(h); ++*indxp) { 				if ((*cmpp = __bam_cmp(dbp,t, 				    dbt, h, *indxp, __bam_defcmp)) != 0) 					continue; 				/*3 				 * The duplicate may have already been deleted,l2 				 * if it's a btree page, in which case we skip
 				 * it. 				 */   				if (dbp->type == DB_BTREE &&0 				    B_DISSET(GET_BKEYDATA(h, *indxp)->type)) 					continue;   				return (0);  			}  - 			if ((pgno = h->next_pgno) == PGNO_INVALID)n
 				break;  . 			if ((ret = memp_fput(dbp->mpf, h, 0)) != 0) 				return (ret);  		}S) 		*cmpp = 1;			/* We didn't succeed... */ 
 		return (0);a 	}   	/* B 	 * We have a comparison routine, i.e., the duplicates are sorted.A 	 * Walk through the chain of duplicates, checking the last entryp> 	 * on each page to decide if it's the page we want to search. 	 *1C 	 * *pp may be non-NULL -- if we were given a valid page (e.g., aren/ 	 * in mid-search), then use the provided page.n 	 */ 	if (*pp != NULL)+ 		goto cmp_started;p 	for (;;) {g5 		if ((ret = memp_fget(dbp->mpf, &pgno, 0, pp)) != 0)t 			goto pg_err;c cmp_started:	h = *pp;>  = 		if ((pgno = h->next_pgno) == PGNO_INVALID || __bam_cmp(dbp,;5 		    dbt, h, h->entries - 1, dbp->dup_compare) <= 0)(	 			break;x 		/*; 		 * Even when continuing a search, make sure we don't skipu 		 * entries on a new page 		 */i
 		*indxp = 0;_  - 		if ((ret = memp_fput(dbp->mpf, h, 0)) != 0)* 			return (ret); 	}  , 	/* Next, do a binary search on the page. */0 	base = F_ISSET(dbc, DBC_CONTINUE) ? *indxp : 0;5 	for (lim = NUM_ENT(h) - base; lim != 0; lim >>= 1) {  		indx = base + (lim >> 1);n 		if ((*cmpp = __bam_cmp(dbp,r. 		    dbt, h, indx, dbp->dup_compare)) == 0) { 			*indxp = indx;s   			if (dbp->type != DB_BTREE ||H0 			    !B_DISSET(GET_BKEYDATA(h, *indxp)->type)) 				return (0);e 			goto check_delete;b 		}  		if (*cmpp > 0) { 			base = indx + 1;i	 			lim--;s 		}e 	}   	/* E 	 * Base references the smallest index larger than the supplied DBT'sf. 	 * data item, potentially both 0 and NUM_ENT. 	 */ 	*indxp = base;K 	return (0);  
 check_delete:r 	/*	F 	 * The duplicate may have already been deleted, if it's a btree page,G 	 * in which case we wander around, hoping to find an entry that hasn'tl: 	 * been deleted.  First, wander in a forwardly direction. 	 */ 	save_pgno = (*pp)->pgno;f 	save_indx = *indxp; 	for (++*indxp;;) { ) 		for (; *indxp < NUM_ENT(h); ++*indxp) {! 			if ((*cmpp = __bam_cmp(dbp,/ 			    dbt, h, *indxp, dbp->dup_compare)) != 0)  				goto check_delete_rev;  0 			if (!B_DISSET(GET_BKEYDATA(h, *indxp)->type)) 				return (0);l 		} , 		if ((pgno = h->next_pgno) == PGNO_INVALID)	 			break;	  - 		if ((ret = memp_fput(dbp->mpf, h, 0)) != 0)b 			return (ret);  5 		if ((ret = memp_fget(dbp->mpf, &pgno, 0, pp)) != 0)n 			goto pg_err; 
 		h = *pp;  
 		*indxp = 0;, 	}   check_delete_rev:)I 	/* Go back to where we started, and wander in a backwardly direction. */p 	if (h->pgno != save_pgno) {- 		if ((ret = memp_fput(dbp->mpf, h, 0)) != 0)t 			return (ret);: 		if ((ret = memp_fget(dbp->mpf, &save_pgno, 0, pp)) != 0) 			goto pg_err;w
 		h = *pp; 	}   	for (;;) {  		while (*indxp > 0) { 			--*indxp; 			if ((*cmpp = __bam_cmp(dbp,/ 			    dbt, h, *indxp, dbp->dup_compare)) != 0)	 				goto check_delete_fail;;  0 			if (!B_DISSET(GET_BKEYDATA(h, *indxp)->type)) 				return (0);L 		}	, 		if ((pgno = h->prev_pgno) == PGNO_INVALID)	 			break;{  - 		if ((ret = memp_fput(dbp->mpf, h, 0)) != 0), 			return (ret);  5 		if ((ret = memp_fget(dbp->mpf, &pgno, 0, pp)) != 0)k 			goto pg_err;m
 		h = *pp;   		*indxp = NUM_ENT(h); 	}   check_delete_fail:( 	*cmpp = 1;			/* We didn't succeed... */ 	return (0);   pg_err:	__db_pgerr(dbp, pgno); 	return (ret); }PL_DIRTY)) != 0)k                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                