 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */    #include "config.h"    #ifndef lint static const char copyright[] = ' "@(#) Copyright (c) 1996, 1997, 1998\n\ 2 	Sleepycat Software Inc.  All rights reserved.\n";F static const char sccsid[] = "@(#)db_stat.c	8.41 (Sleepycat) 10/3/98"; #endif   #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <ctype.h> #include <errno.h> #include <signal.h>  #include <stdlib.h>  #include <string.h>  #include <time.h>  #include <unistd.h>  #endif   #include "db_int.h"  #include "shqueue.h" #include "db_shash.h"  #include "lock.h"  #include "mp.h"  #include "clib_ext.h"   F typedef enum { T_NOTSET, T_DB, T_LOCK, T_LOG, T_MPOOL, T_TXN } test_t;  ) int	argcheck __P((char *, const char *));  void	btree_stats __P((DB *)); & DB_ENV *db_init __P((char *, test_t));$ void	dl __P((const char *, u_long)); void	hash_stats __P((DB *)); int	lock_ok __P((char *));  void	lock_stats __P((DB_ENV *)); void	log_stats __P((DB_ENV *));  int	main __P((int, char *[])); int	mpool_ok __P((char *)); ! void	mpool_stats __P((DB_ENV *));  void	nosig __P((void)); * void	prflags __P((u_int32_t, const FN *));2 int	txn_compare __P((const void *, const void *)); void	txn_stats __P((DB_ENV *));  void	usage __P((void));    char	*internal; 
 const char. 	*progname = "db_stat";				/* Program name. */   int  main(argc, argv)
 	int argc; 	char *argv[]; {  	extern char *optarg;  	extern int optind; 	 	DB *dbp;  	DB_ENV *dbenv;  	test_t ttype; 	int ch; 	char *db, *home;    	ttype = T_NOTSET; 	db = home = NULL;: 	while ((ch = getopt(argc, argv, "C:cd:h:lM:mNt")) != EOF) 		switch (ch) {  		case 'C':  			ttype = T_LOCK;. 			if (!argcheck(internal = optarg, "Acflmo")) 				usage();	 			break;  		case 'c':  			ttype = T_LOCK;	 			break;  		case 'd':  			db = optarg;  			ttype = T_DB;	 			break;  		case 'h':  			home = optarg; 	 			break;  		case 'l':  			ttype = T_LOG; 	 			break;  		case 'M':  			ttype = T_MPOOL; , 			if (!argcheck(internal = optarg, "Ahlm")) 				usage();	 			break;  		case 'm':  			ttype = T_MPOOL; 	 			break;  		case 'N': ( 			(void)db_value_set(0, DB_MUTEXLOCKS);	 			break;  		case 't':  			ttype = T_TXN; 	 			break;  		case '?': 
 		default: 			usage();  		}  	argc -= optind; 	argv += optind;  $ 	if (argc != 0 || ttype == T_NOTSET)
 		usage();   	/* C 	 * Ignore signals -- we don't want to be interrupted because we're / 	 * spending all of our time in the DB library.  	 */	 	nosig();  	dbenv = db_init(home, ttype);   	switch (ttype) {  	case T_DB: & 		if ((errno = db_open(db, DB_UNKNOWN,/ 		    DB_RDONLY, 0, dbenv, NULL, &dbp)) != 0) {  			warn("%s", db); 			return (1); 		}  		switch (dbp->type) { 		case DB_BTREE: 		case DB_RECNO: 			btree_stats(dbp);	 			break;  		case DB_HASH:  			hash_stats(dbp); 	 			break;  		case DB_UNKNOWN: 			abort();		/* Impossible. */ 			/* NOTREACHED */  		}  		(void)dbp->close(dbp, 0);  		break;
 	case T_LOCK:  		lock_stats(dbenv); 		break; 	case T_LOG: 		log_stats(dbenv);  		break; 	case T_MPOOL: 		mpool_stats(dbenv);  		break; 	case T_TXN: 		txn_stats(dbenv);  		break; 	case T_NOTSET:  		abort();			/* Impossible. */ 		/* NOTREACHED */ 	}  ( 	if ((errno = db_appexit(dbenv)) != 0) {
 		warn(NULL); 
 		return (1);  	} 	return (0); }    /*  * btree_stats -- "  *	Display btree/recno statistics.  */  void btree_stats(dbp)	 	DB *dbp;  {  	static const FN fn[] = {  		{ DB_DUP,	"DB_DUP" }, ! 		{ DB_FIXEDLEN,	"DB_FIXEDLEN" },  		{ DB_RECNUM,	"DB_RECNUM" }, ! 		{ DB_RENUMBER,	"DB_RENUMBER" },  		{ 0 }  	};  	DB_BTREE_STAT *sp;   " 	if (dbp->stat(dbp, &sp, NULL, 0)) 		err(1, "dbp->stat");   #define	PCT(f, t)							\      (t == 0 ? 0 :							\ J     (((double)((t * sp->bt_pagesize) - f) / (t * sp->bt_pagesize)) * 100))  = 	printf("%#lx\tBtree magic number.\n", (u_long)sp->bt_magic); @ 	printf("%lu\tBtree version number.\n", (u_long)sp->bt_version); 	prflags(sp->bt_flags, fn);  	if (dbp->type == DB_BTREE) {  #ifdef NOT_IMPLEMENTED8 		dl("Maximum keys per-page.\n", (u_long)sp->bt_maxkey); #endif8 		dl("Minimum keys per-page.\n", (u_long)sp->bt_minkey); 	} 	if (dbp->type == DB_RECNO) { ; 		dl("Fixed-length record size.\n", (u_long)sp->bt_re_len);  		if (isprint(sp->bt_re_pad)) + 			printf("%c\tFixed-length record pad.\n",  			    (int)sp->bt_re_pad);  		else- 			printf("0x%x\tFixed-length record pad.\n",  			    (int)sp->bt_re_pad);  	}= 	dl("Underlying tree page size.\n", (u_long)sp->bt_pagesize); > 	dl("Number of levels in the tree.\n", (u_long)sp->bt_levels);; 	dl("Number of keys in the tree.\n", (u_long)sp->bt_nrecs); ? 	dl("Number of tree internal pages.\n", (u_long)sp->bt_int_pg); < 	dl("Number of tree leaf pages.\n", (u_long)sp->bt_leaf_pg);@ 	dl("Number of tree duplicate pages.\n", (u_long)sp->bt_dup_pg);@ 	dl("Number of tree overflow pages.\n", (u_long)sp->bt_over_pg);@ 	dl("Number of pages on the free list.\n", (u_long)sp->bt_free);2 	dl("Number of bytes free in tree internal pages",  	    (u_long)sp->bt_int_pgfree);B 	printf(" (%.0f%% ff).\n", PCT(sp->bt_int_pgfree, sp->bt_int_pg));. 	dl("Number of bytes free in tree leaf pages",! 	    (u_long)sp->bt_leaf_pgfree); D 	printf(" (%.0f%% ff).\n", PCT(sp->bt_leaf_pgfree, sp->bt_leaf_pg));3 	dl("Number of bytes free in tree duplicate pages",   	    (u_long)sp->bt_dup_pgfree);B 	printf(" (%.0f%% ff).\n", PCT(sp->bt_dup_pgfree, sp->bt_dup_pg));2 	dl("Number of bytes free in tree overflow pages",! 	    (u_long)sp->bt_over_pgfree); D 	printf(" (%.0f%% ff).\n", PCT(sp->bt_over_pgfree, sp->bt_over_pg)); }    /*  * hash_stats --  *	Display hash statistics.   */  void hash_stats(dbp) 	 	DB *dbp;  {  	COMPQUIET(dbp, NULL);  6 	printf("Hash statistics not currently available.\n"); 	return; }    /*  * lock_stats --  *	Display lock statistics.   */  void lock_stats(dbenv)  	DB_ENV *dbenv;  {  	DB_LOCK_STAT *sp;   	if (internal != NULL) {7 		__lock_dump_region(dbenv->lk_info, internal, stdout); 	 		return;  	}  * 	if (lock_stat(dbenv->lk_info, &sp, NULL)) 		err(1, NULL);   < 	printf("%#lx\tLock magic number.\n", (u_long)sp->st_magic);? 	printf("%lu\tLock version number.\n", (u_long)sp->st_version); = 	dl("Lock region reference count.\n", (u_long)sp->st_refcnt); 3 	dl("Lock region size.\n", (u_long)sp->st_regsize); ; 	dl("Maximum number of locks.\n", (u_long)sp->st_maxlocks); 6 	dl("Number of lock modes.\n", (u_long)sp->st_nmodes);9 	dl("Number of lock objects.\n", (u_long)sp->st_numobjs); 5 	dl("Number of lockers.\n", (u_long)sp->st_nlockers); > 	dl("Number of lock conflicts.\n", (u_long)sp->st_nconflicts);< 	dl("Number of lock requests.\n", (u_long)sp->st_nrequests);< 	dl("Number of lock releases.\n", (u_long)sp->st_nreleases);9 	dl("Number of deadlocks.\n", (u_long)sp->st_ndeadlocks); < 	dl("The number of region locks granted without waiting.\n",# 	    (u_long)sp->st_region_nowait); : 	dl("The number of region locks granted after waiting.\n",! 	    (u_long)sp->st_region_wait);  }    /*  * log_stats --   *	Display log statistics.  */  void log_stats(dbenv) 	DB_ENV *dbenv;  {  	DB_LOG_STAT *sp;   ) 	if (log_stat(dbenv->lg_info, &sp, NULL))  		err(1, NULL);   ; 	printf("%#lx\tLog magic number.\n", (u_long)sp->st_magic); > 	printf("%lu\tLog version number.\n", (u_long)sp->st_version);< 	dl("Log region reference count.\n", (u_long)sp->st_refcnt);2 	dl("Log region size.\n", (u_long)sp->st_regsize);. 	printf("%#o\tLog file mode.\n", sp->st_mode);# 	if (sp->st_lg_max % MEGABYTE == 0) # 		printf("%luMb\tLog file size.\n", ( 		    (u_long)sp->st_lg_max / MEGABYTE);$ 	else if (sp->st_lg_max % 1024 == 0)B 		printf("%luKb\tLog file size.\n", (u_long)sp->st_lg_max / 1024); 	else 9 		printf("%lu\tLog file size.\n", (u_long)sp->st_lg_max); 3 	printf("%luMb\tLog bytes written (+%lu bytes).\n", 6 	    (u_long)sp->st_w_mbytes, (u_long)sp->st_w_bytes);I 	printf("%luMb\tLog bytes written since last checkpoint (+%lu bytes).\n", 8 	    (u_long)sp->st_wc_mbytes, (u_long)sp->st_wc_bytes);7 	dl("Total log file writes.\n", (u_long)sp->st_wcount);S8 	dl("Total log file flushes.\n", (u_long)sp->st_scount);D 	printf("%lu\tCurrent log file number.\n", (u_long)sp->st_cur_file);F 	printf("%lu\tCurrent log file offset.\n", (u_long)sp->st_cur_offset);< 	dl("The number of region locks granted without waiting.\n",# 	    (u_long)sp->st_region_nowait);t: 	dl("The number of region locks granted after waiting.\n",! 	    (u_long)sp->st_region_wait);_ }L   /*  * mpool_stats --.  *	Display mpool statistics.  */< void mpool_stats(dbenv) 	DB_ENV *dbenv;t {b 	DB_MPOOL_FSTAT **fsp; 	DB_MPOOL_STAT *gsp;   	if (internal != NULL) {7 		__memp_dump_region(dbenv->mp_info, internal, stdout);e	 		return;h 	}  1 	if (memp_stat(dbenv->mp_info, &gsp, &fsp, NULL))e 		err(1, NULL);   > 	dl("Pool region reference count.\n", (u_long)gsp->st_refcnt);4 	dl("Pool region size.\n", (u_long)gsp->st_regsize);- 	dl("Cache size", (u_long)gsp->st_cachesize); 8 	printf(" (%luK).\n", (u_long)gsp->st_cachesize / 1024);E 	dl("Requested pages found in the cache", (u_long)gsp->st_cache_hit);(1 	if (gsp->st_cache_hit + gsp->st_cache_miss != 0)	2 		printf(" (%.0f%%)", ((double)gsp->st_cache_hit /7 		    (gsp->st_cache_hit + gsp->st_cache_miss)) * 100);( 	printf(".\n");f@ 	dl("Requested pages mapped into the process' address space.\n", 	    (u_long)gsp->st_map);0 	dl("Requested pages not found in the cache.\n",! 	    (u_long)gsp->st_cache_miss); B 	dl("Pages created in the cache.\n", (u_long)gsp->st_page_create);= 	dl("Pages read into the cache.\n", (u_long)gsp->st_page_in);e: 	dl("Pages written from the cache to the backing file.\n", 	    (u_long)gsp->st_page_out); + 	dl("Clean pages forced from the cache.\n",w 	    (u_long)gsp->st_ro_evict);:+ 	dl("Dirty pages forced from the cache.\n",a 	    (u_long)gsp->st_rw_evict);i6 	dl("Dirty buffers written by trickle-sync thread.\n",# 	    (u_long)gsp->st_page_trickle);=$ 	dl("Current clean buffer count.\n",! 	    (u_long)gsp->st_page_clean);	$ 	dl("Current dirty buffer count.\n",! 	    (u_long)gsp->st_page_dirty);t7 	dl("Number of hash buckets used for page location.\n",O# 	    (u_long)gsp->st_hash_buckets);a? 	dl("Total number of times hash chains searched for a page.\n",T$ 	    (u_long)gsp->st_hash_searches);4 	dl("The longest hash chain searched for a page.\n",# 	    (u_long)gsp->st_hash_longest);eA 	dl("Total number of hash buckets examined for page location.\n",;$ 	    (u_long)gsp->st_hash_examined);< 	dl("The number of region locks granted without waiting.\n",$ 	    (u_long)gsp->st_region_nowait);: 	dl("The number of region locks granted after waiting.\n"," 	    (u_long)gsp->st_region_wait);  - 	for (; fsp != NULL && *fsp != NULL; ++fsp) {  		printf("%s\n", DB_LINE);$ 		printf("%s\n", (*fsp)->file_name);2 		dl("Page size.\n", (u_long)(*fsp)->st_pagesize);* 		dl("Requested pages found in the cache",$ 		    (u_long)(*fsp)->st_cache_hit);8 		if ((*fsp)->st_cache_hit + (*fsp)->st_cache_miss != 0)6 			printf(" (%.0f%%)", ((double)(*fsp)->st_cache_hit /8 			    ((*fsp)->st_cache_hit + (*fsp)->st_cache_miss)) * 			    100); 		printf(".\n");A 		dl("Requested pages mapped into the process' address space.\n",t 		    (u_long)(*fsp)->st_map);1 		dl("Requested pages not found in the cache.\n",:% 		    (u_long)(*fsp)->st_cache_miss); % 		dl("Pages created in the cache.\n", & 		    (u_long)(*fsp)->st_page_create);$ 		dl("Pages read into the cache.\n"," 		    (u_long)(*fsp)->st_page_in);; 		dl("Pages written from the cache to the backing file.\n",s# 		    (u_long)(*fsp)->st_page_out);b 	} }    /*  * txn_stats --s"  *	Display transaction statistics.  */  void txn_stats(dbenv) 	DB_ENV *dbenv;B {C 	DB_TXN_STAT *sp; 
 	u_int32_t i;E 	const char *p;}  ) 	if (txn_stat(dbenv->tx_info, &sp, NULL))i 		err(1, NULL);   < 	dl("Txn region reference count.\n", (u_long)sp->st_refcnt);2 	dl("Txn region size.\n", (u_long)sp->st_regsize);  	p = sp->st_last_ckp.file == 0 ?C 	    "No checkpoint LSN." : "File/offset for last checkpoint LSN.";o 	printf("%lu/%lu\t%s\n",F 	    (u_long)sp->st_last_ckp.file, (u_long)sp->st_last_ckp.offset, p);# 	p = sp->st_pending_ckp.file == 0 ?B# 	    "No pending checkpoint LSN." :	4 	    "File/offset for last pending checkpoint LSN."; 	printf("%lu/%lu\t%s\n",% 	    (u_long)sp->st_pending_ckp.file,;+ 	    (u_long)sp->st_pending_ckp.offset, p);i 	if (sp->st_time_ckp == 0)* 		printf("0\tNo checkpoint timestamp.\n"); 	elsea* 		printf("%.24s\tCheckpoint timestamp.\n", 		    ctime(&sp->st_time_ckp));)0 	printf("%lx\tLast transaction ID allocated.\n",  	    (u_long)sp->st_last_txnid);H 	dl("Maximum number of active transactions.\n", (u_long)sp->st_maxtxns);? 	dl("Number of transactions begun.\n", (u_long)sp->st_nbegins);dA 	dl("Number of transactions aborted.\n", (u_long)sp->st_naborts);mD 	dl("Number of transactions committed.\n", (u_long)sp->st_ncommits);< 	dl("The number of region locks granted without waiting.\n",# 	    (u_long)sp->st_region_nowait);s: 	dl("The number of region locks granted after waiting.\n",! 	    (u_long)sp->st_region_wait);f6 	dl("Active transactions.\n", (u_long)sp->st_nactive); 	qsort(sp->st_txnarray,t> 	    sp->st_nactive, sizeof(sp->st_txnarray[0]), txn_compare);% 	for (i = 0; i < sp->st_nactive; ++i)e8 		printf("\tid: %lx; initial LSN file/offest %lu/%lu\n",' 		    (u_long)sp->st_txnarray[i].txnid,)* 		    (u_long)sp->st_txnarray[i].lsn.file,- 		    (u_long)sp->st_txnarray[i].lsn.offset);t }f   intt txn_compare(a1, b1)  	const void *a1, *b1;u {g 	const DB_TXN_ACTIVE *a, *b;   	a = a1; 	b = b1;   	if (a->txnid > b->txnid)N
 		return (1);f 	if (a->txnid < b->txnid), 		return (-1); 	return (0); })   /*  * dl --  *	Display a big value._  */p void dl(msg, value) 	const char *msg;s 	u_long value; {l 	/*sC 	 * Two formats: if less than 10 million, display as the number, ifI, 	 * greater than 10 million display as ###M. 	 */ 	if (value < 10000000)  		printf("%lu\t%s", value, msg); 	elses+ 		printf("%luM\t%s", value / 1000000, msg);s }e   /*
  * prflags --   *	Print out flag values.   */i void prflags(flags, fnp)k 	u_int32_t flags;> 	const FN *fnp;, {d 	const char *sep;    	sep = " ";_ 	printf("Flags:"); 	for (; fnp->mask != 0; ++fnp) 		if (fnp->mask & flags) {" 			printf("%s%s", sep, fnp->name); 			sep = ", "; 		}r 	printf("\n"); }_   /*
  * db_init --   *	Initialize the environment.  */" DB_ENV * db_init(home, ttype) 	char *home; 	test_t ttype; {- 	DB_ENV *dbenv;d 	u_int32_t flags;f  : 	if ((dbenv = (DB_ENV *)malloc(sizeof(DB_ENV))) == NULL) { 		errno = ENOMEM;- 		err(1, NULL);( 	}   	/*lC 	 * Try and use the shared regions when reporting statistics on the"B 	 * DB databases, so our information is as up-to-date as possible,C 	 * even if the mpool cache hasn't been flushed.  If that fails, wep2 	 * turn off the DB_INIT_MPOOL flag and try again. 	 */ 	flags = DB_USE_ENVIRON; 	switch (ttype) {s 	case T_DB:) 	case T_MPOOL: 		LF_SET(DB_INIT_MPOOL); 		break;
 	case T_LOCK:u 		LF_SET(DB_INIT_LOCK);o 		break; 	case T_LOG: 		LF_SET(DB_INIT_LOG); 		break; 	case T_TXN: 		LF_SET(DB_INIT_TXN); 		break; 	case T_NOTSET: 
 		abort(); 		/* NOTREACHED */ 	}   	/*sB 	 * If it works, we're done.  Set the error output options so that) 	 * future errors are correctly reported.n 	 */" 	memset(dbenv, 0, sizeof(*dbenv));; 	if ((errno = db_appinit(home, NULL, dbenv, flags)) == 0) {i 		dbenv->db_errfile = stderr;" 		dbenv->db_errpfx = progname; 		return (dbenv);c 	}  : 	/* Turn off the DB_INIT_MPOOL flag if it's a database. */ 	if (ttype == T_DB); 		LF_CLR(DB_INIT_MPOOL);  C 	/* Set the error output options -- this time we want a message. */"" 	memset(dbenv, 0, sizeof(*dbenv)); 	dbenv->db_errfile = stderr; 	dbenv->db_errpfx = progname;0  , 	/* Try again, and it's fatal if we fail. */9 	if ((errno = db_appinit(home, NULL, dbenv, flags)) != 0)l 		err(1, "db_appinit");t   	return (dbenv); }u   /*  * argcheck --%  *	Return if argument flags are okay._  */t intu argcheck(arg, ok_args) 	char *arg;b 	const char *ok_args;c {a 	for (; *arg != '\0'; ++arg)$ 		if (strchr(ok_args, *arg) == NULL) 			return (0); 	return (1); }l   /*  * nosig --"#  *	We don't want to be interrupted.l  */f void nosig(), {_
 #ifdef SIGHUPu 	(void)signal(SIGHUP, SIG_IGN);i #endif 	(void)signal(SIGINT, SIG_IGN);   	(void)signal(SIGTERM, SIG_IGN); }.   void usage()s {u 	fprintf(stderr,K     "usage: db_stat [-clmNt] [-C Acflmo] [-d file] [-h home] [-M Ahlm]\n");e
 	exit (1); } l("The number of region locks granted after waiting.\n",! 	    (u_long)sp->st_region_wait);_ }L   /*  * mpool_stats --.  *	Display mpool statistics.  */< void mpool_stats(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                