 #!/bin/sh -  # 6 # See the file LICENSE for redistribution information. #   # Copyright (c) 1996, 1997, 1998+ #	Sleepycat Software.  All rights reserved.  # ) #	@(#)db_gen.sh	10.20 (Sleepycat) 12/7/98  #   H # This script generates all the log, print, and read routines for the dbB # package logging. It also generates the template for the recoveryH # functions (these must be hand-written, but are highly stylized so thatH # the initial template gets you a fair way along the path).  For a givenH # file prefix.src, we generate a file prefix_auto.c.  This file containsG # PUBLIC declarations that will help us generate the appropriate extern D # declarations.  It also creates a file prefix_auto.h that contains:; # 	defines for the physical record types (logical types are & #		defined in eacy subsystem manually); #	structures to contain the data unmarshalled from the log.  PROG=db_gen.sh if [ $# -ne 2 ]; then ' 	echo "Usage: db_gen.sh <name>.src dir"  	exit 1  fi   ifile=$1 dir=$2 dname=`basename $ifile .src`  hfile=../include/$dname"_auto.h" cfile=$dir/$dname"_auto.c" rfile=template/"rec_"$dname   3 # Create the files as automagically generated files & echo "Building $hfile, $cfile, $rfile"? msg="/* Do not edit: automatically built by dist/db_gen.sh. */" & echo "$msg" > $hfile; chmod 444 $hfile& echo "$msg" > $cfile; chmod 444 $cfile& echo "$msg" > $rfile; chmod 444 $rfile  ! # Start processing the input file  awk  ' /^[ 	]*PREFIX/ { 	prefix = $2   	# Write Cfile headers  - 	printf("#include \"config.h\"\n\n") >> CFILE 0 	printf("#ifndef NO_SYSTEM_INCLUDES\n") >> CFILE( 	printf("#include <ctype.h>\n") >> CFILE( 	printf("#include <errno.h>\n") >> CFILE) 	printf("#include <stddef.h>\n") >> CFILE ) 	printf("#include <stdlib.h>\n") >> CFILE ) 	printf("#include <string.h>\n") >> CFILE  	printf("#endif\n\n") >> CFILE+ 	printf("#include \"db_int.h\"\n") >> CFILE , 	printf("#include \"shqueue.h\"\n") >> CFILE, 	printf("#include \"db_page.h\"\n") >> CFILE0 	printf("#include \"db_dispatch.h\"\n") >> CFILE 	if (prefix != "db")- 		printf("#include \"%s.h\"\n", DIR) >> CFILE / 	printf("#include \"db_am.h\"\n", DIR) >> CFILE    	# Write Recover file headers % 	cmd = sprintf("sed -e s/PREF/%s/ < \ . 	    template/rec_htemp > %s", prefix, RFILE);
 	system(cmd);    	num_funcs = 0; C 	printf("#ifndef %s_AUTO_H\n#define %s_AUTO_H\n", prefix, prefix) \  	    >> HFILE; }  /^[ 	]*BEGIN/ {  	if (in_begin) {/ 		print "Invalid format: missing END statement" 
 		error++; 	} 	in_begin = 1; 	is_sync = $3; 	structs++; 	 	nvars=0; ' 	funcname=sprintf("%s_%s", prefix, $2);  	thisfunc = $2;  	funcs[num_funcs] = funcname; 
 	num_funcs++;  	is_dbt = 0; }  /^[ 	]*(ARG|DBT|POINTER)/ {  	vars[nvars] = $2; 	types[nvars] = $3;  	atypes[nvars] = $1; 	modes[nvars] = $1;  	formats[nvars] = $NF; 	for (i = 4; i < NF; i++) 4 		types[nvars] = sprintf("%s %s", types[nvars], $i);   	if ($1 == "ARG") + 		sizes[nvars] = sprintf("sizeof(%s)", $2);  	else if ($1 == "POINTER"), 		sizes[nvars] = sprintf("sizeof(*%s)", $2);
 	else { # DBT  		sizes[nvars] = \B 		    sprintf("sizeof(u_int32_t) + (%s == NULL ? 0 : %s->size)", \ 		    $2, $2);
 		is_dbt = 1;  	}	 	nvars++;  } 
 /^[ 	]*END/ {  	if (!in_begin) { 1 		print "Invalid format: missing BEGIN statement"  		next;  	}  % 	# Make the entire H file conditional ' 	# Define the record type in the H file 5 	printf("\n#define\tDB_%s\t(DB_%s_BEGIN + %d)\n\n", \ ( 	    funcname, prefix, structs) >> HFILE   	# structure declarations 9 	printf("typedef struct _%s_args {\n", funcname) >> HFILE   3 	# Here are the required fields for every structure 9 	printf("\tu_int32_t type;\n\tDB_TXN *txnid;\n") >> HFILE ' 	printf("\tDB_LSN prev_lsn;\n") >>HFILE   ! 	# Here are the specified fields.  	for (i = 0; i < nvars; i++) { 		t = types[i];  		if (modes[i] == "POINTER") { 			ndx = index(t, "*"); $ 			t = substr(types[i], 0, ndx - 1); 		} , 		printf("\t%s\t%s;\n", t, vars[i]) >> HFILE 	}. 	printf("} __%s_args;\n\n", funcname) >> HFILE  - # Now write the log function out to the cfile  	# PUBLIC declaration $ 	printf("/*\n * PUBLIC: ") >> CFILE;A 	printf("int __%s_log\n * PUBLIC:     __P((", funcname) >> CFILE; < 	printf("DB_LOG *, DB_TXN *, DB_LSN *, u_int32_t") >> CFILE; 	for (i = 0; i < nvars; i++) { 		printf(",") >> CFILE;  		if ((i % 4) == 0) ( 			printf("\n * PUBLIC:     ") >> CFILE; 		else 			printf(" ") >> CFILE; 		if (modes[i] == "DBT") 			printf("const ") >> CFILE; " 		printf("%s", types[i]) >> CFILE; 		if (modes[i] == "DBT") 			printf(" *") >> CFILE;  	} 	printf("));\n */\n") >> CFILE;    	# Function declaration H 	printf("int __%s_log(logp, txnid, ret_lsnp, flags", funcname) >> CFILE; 	for (i = 0; i < nvars; i++) { 		printf(",") >> CFILE;  		if ((i % 6) == 0)  			printf("\n\t") >> CFILE;  		else 			printf(" ") >> CFILE;! 		printf("%s", vars[i]) >> CFILE;  	} 	printf(")\n") >> CFILE;   	# Now print the parameters & 	printf("\tDB_LOG *logp;\n") >> CFILE;< 	printf("\tDB_TXN *txnid;\n\tDB_LSN *ret_lsnp;\n") >> CFILE;) 	printf("\tu_int32_t flags;\n") >> CFILE;  	for (i = 0; i < nvars; i++) { 		if (modes[i] == "DBT"); 			printf("\tconst %s *%s;\n", types[i], vars[i]) >> CFILE;  		else4 			printf("\t%s %s;\n", types[i], vars[i]) >> CFILE; 	}    	# Function body and local decls 	printf("{\n") >> CFILE;$ 	printf("\tDBT logrec;\n") >> CFILE;0 	printf("\tDB_LSN *lsnp, null_lsn;\n") >> CFILE; 	if (is_dbt == 1) ) 		printf("\tu_int32_t zero;\n") >> CFILE; 4 	printf("\tu_int32_t rectype, txn_num;\n") >> CFILE;! 	printf("\tint ret;\n") >> CFILE; ( 	printf("\tu_int8_t *bp;\n\n") >> CFILE;   	# Initialization 3 	printf("\trectype = DB_%s;\n", funcname) >> CFILE; D 	printf("\ttxn_num = txnid == NULL ? 0 : txnid->txnid;\n") >> CFILE;- 	printf("\tif (txnid == NULL) {\n") >> CFILE; . 	printf("\t\tZERO_LSN(null_lsn);\n") >> CFILE;, 	printf("\t\tlsnp = &null_lsn;\n") >> CFILE;= 	printf("\t} else\n\t\tlsnp = &txnid->last_lsn;\n") >> CFILE;   	 	# MALLOC 7 	printf("\tlogrec.size = sizeof(rectype) + ") >> CFILE; 5 	printf("sizeof(txn_num) + sizeof(DB_LSN)") >> CFILE;  	for (i = 0; i < nvars; i++), 		printf("\n\t    + %s", sizes[i]) >> CFILE;% 	printf(";\n\tif ((ret = ") >> CFILE; B 	printf("__os_malloc(logrec.size, NULL, &logrec.data)) != 0)\n") \ 	    >> CFILE;* 	printf("\t\treturn (ret);\n\n") >> CFILE;   	# Copy args into buffer  * 	printf("\tbp = logrec.data;\n") >> CFILE;? 	printf("\tmemcpy(bp, &rectype, sizeof(rectype));\n") >> CFILE; / 	printf("\tbp += sizeof(rectype);\n") >> CFILE; ? 	printf("\tmemcpy(bp, &txn_num, sizeof(txn_num));\n") >> CFILE; / 	printf("\tbp += sizeof(txn_num);\n") >> CFILE; : 	printf("\tmemcpy(bp, lsnp, sizeof(DB_LSN));\n") >> CFILE;. 	printf("\tbp += sizeof(DB_LSN);\n") >> CFILE;   	for (i = 0; i < nvars; i ++) {  		if (modes[i] == "ARG") {' 			printf("\tmemcpy(bp, &%s, %s);\n", \ # 			    vars[i], sizes[i]) >> CFILE; . 			printf("\tbp += %s;\n", sizes[i]) >> CFILE;! 		} else if (modes[i] == "DBT") { 5 			printf("\tif (%s == NULL) {\n", vars[i]) >> CFILE; & 			printf("\t\tzero = 0;\n") >> CFILE;: 			printf("\t\tmemcpy(bp, &zero, sizeof(u_int32_t));\n") \
 				>> CFILE; 5 			printf("\t\tbp += sizeof(u_int32_t);\n") >> CFILE; # 			printf("\t} else {\n") >> CFILE; : 			printf("\t\tmemcpy(bp, &%s->size, ", vars[i]) >> CFILE;4 			printf("sizeof(%s->size));\n", vars[i]) >> CFILE;5 			printf("\t\tbp += sizeof(%s->size);\n", vars[i]) \  			    >> CFILE;4 			printf("\t\tmemcpy(bp, %s->data, %s->size);\n", \" 			    vars[i], vars[i]) >> CFILE;: 			printf("\t\tbp += %s->size;\n\t}\n", vars[i]) >> CFILE; 		} else { # POINTER3 			printf("\tif (%s != NULL)\n", vars[i]) >> CFILE; 1 			printf("\t\tmemcpy(bp, %s, %s);\n", vars[i], \  			    sizes[i]) >> CFILE; 			printf("\telse\n") >> CFILE; 9 			printf("\t\tmemset(bp, 0, %s);\n", sizes[i]) >> CFILE; . 			printf("\tbp += %s;\n", sizes[i]) >> CFILE; 		}  	}   	# Error checking ( 	printf("#ifdef DIAGNOSTIC\n") >> CFILE;T 	printf("\tif ((u_int32_t)(bp - (u_int8_t *)logrec.data) != logrec.size)") >> CFILE;- 	printf("\n\t\tfprintf(stderr, \"%s\");\n", \ , 	    "Error in log record length") >> CFILE; 	printf("#endif\n") >> CFILE;b   	# Issue log callh< 	# The logging system cannot call the public log_put routine6 	# due to mutual exclusion constraints.  So, if we are: 	# generating code for the log subsystem, use the internal
 	# __log_put.s 	if (prefix == "log") 9 		printf("\tret = __log_put\(logp, ret_lsnp, ") >> CFILE;. 	elseo6 		printf("\tret = log_put(logp, ret_lsnp, ") >> CFILE;. 	printf("(DBT *)&logrec, flags);\n") >> CFILE;  # 	# Update the transactions last_lsn + 	printf("\tif (txnid != NULL)\n") >> CFILE; 7 	printf("\t\ttxnid->last_lsn = *ret_lsnp;\n") >> CFILE;s   	# Free and return3 	printf("\t__os_free(logrec.data, 0);\n") >> CFILE;r+ 	printf("\treturn (ret);\n}\n\n") >> CFILE;s   # Write the print function 	# PUBLIC declarationtH 	printf("/*\n * PUBLIC: int __%s_print\n * PUBLIC:", funcname) >> CFILE;I 	printf("    __P((DB_LOG *, DBT *, DB_LSN *, int, void *));\n") >> CFILE;R 	printf(" */\n") >> CFILE;   	# Function declarationg9 	printf("int\n__%s_print(notused1, ", funcname) >> CFILE;n6 	printf("dbtp, lsnp, notused2, notused3)\n") >> CFILE;8 	printf("\tDB_LOG *notused1;\n\tDBT *dbtp;\n") >> CFILE;& 	printf("\tDB_LSN *lsnp;\n") >> CFILE;< 	printf("\tint notused2;\n\tvoid *notused3;\n{\n") >> CFILE;  	 	# Localst3 	printf("\t__%s_args *argp;\n", funcname) >> CFILE;c@ 	printf("\tu_int32_t i;\n\tu_int ch;\n\tint ret;\n\n") >> CFILE;  1 	# Get rid of complaints about unused parameters. * 	printf("\ti = 0;\n\tch = 0;\n") >> CFILE;) 	printf("\tnotused1 = NULL;\n") >> CFILE;C< 	printf("\tnotused2 = 0;\n\tnotused3 = NULL;\n\n") >> CFILE;  , 	# Call read routine to initialize structure? 	printf("\tif ((ret = __%s_read(dbtp->data, &argp)) != 0)\n", \e 	    funcname) >> CFILE;( 	printf("\t\treturn (ret);\n") >> CFILE;   	# Print values in every recordF: 	printf("\tprintf(\"[%%lu][%%lu]%s: ", funcname) >> CFILE;* 	printf("rec: %%lu txnid %%lx ") >> CFILE;1 	printf("prevlsn [%%lu][%%lu]\\n\",\n") >> CFILE;.0 	printf("\t    (u_long)lsnp->file,\n") >> CFILE;2 	printf("\t    (u_long)lsnp->offset,\n") >> CFILE;0 	printf("\t    (u_long)argp->type,\n") >> CFILE;8 	printf("\t    (u_long)argp->txnid->txnid,\n") >> CFILE;9 	printf("\t    (u_long)argp->prev_lsn.file,\n") >> CFILE;c< 	printf("\t    (u_long)argp->prev_lsn.offset);\n") >> CFILE;   	# Now print fields of argp( 	for (i = 0; i < nvars; i ++) {t1 		printf("\tprintf(\"\\t%s: ", vars[i]) >> CFILE;    		if (modes[i] == "DBT") { 			printf("\");\n") >> CFILE;i) 			printf("\tfor (i = 0; i < ") >> CFILE;s7 			printf("argp->%s.size; i++) {\n", vars[i]) >> CFILE;;9 			printf("\t\tch = ((u_int8_t *)argp->%s.data)[i];\n", \i 			    vars[i]) >> CFILE; : 			printf("\t\tif (isprint(ch) || ch == 0xa)\n") >> CFILE;+ 			printf("\t\t\tputchar(ch);\n") >> CFILE;r! 			printf("\t\telse\n") >> CFILE;y5 			printf("\t\t\tprintf(\"%%#x \", ch);\n") >> CFILE; 0 			printf("\t}\n\tprintf(\"\\n\");\n") >> CFILE;& 		} else if (types[i] == "DB_LSN *") {# 			printf("[%%%s][%%%s]\\n\",\n", \=( 			    formats[i], formats[i]) >> CFILE;+ 			printf("\t    (u_long)argp->%s.file,", \e 			    vars[i]) >> CFILE;B+ 			printf(" (u_long)argp->%s.offset);\n", \( 			    vars[i]) >> CFILE;0
 		} else { 			if (formats[i] == "lx") 				printf("0x") >> CFILE;. 			printf("%%%s\\n\", ", formats[i]) >> CFILE;0 			if (formats[i] == "lx" || formats[i] == "lu")  				printf("(u_long)") >> CFILE; 			if (formats[i] == "ld") 				printf("(long)") >> CFILE;, 			printf("argp->%s);\n", vars[i]) >> CFILE; 		}  	}) 	printf("\tprintf(\"\\n\");\n") >> CFILE;s, 	printf("\t__os_free(argp, 0);\n") >> CFILE;$ 	printf("\treturn (0);\n") >> CFILE; 	printf("}\n\n") >> CFILE;  . # Now write the read function out to the cfileI 	printf("/*\n * PUBLIC: int __%s_read __P((void *, ", funcname) >> CFILE;L5 	printf("__%s_args **));\n */\n", funcname) >> CFILE;i   	# Function declaratione> 	printf("int\n__%s_read(recbuf, argpp)\n", funcname) >> CFILE;   	# Now print the parametersx& 	printf("\tvoid *recbuf;\n") >> CFILE;5 	printf("\t__%s_args **argpp;\n", funcname) >> CFILE;c    	# Function body and local decls6 	printf("{\n\t__%s_args *argp;\n", funcname) >> CFILE;& 	printf("\tu_int8_t *bp;\n") >> CFILE;! 	printf("\tint ret;\n") >> CFILE;_  2 	printf("\n\tret = __os_malloc(sizeof(") >> CFILE;@ 	printf("__%s_args) +\n\t    sizeof(DB_TXN), NULL, &argp);\n", \ 	    funcname) >> CFILE;9 	printf("\tif (ret != 0)\n\t\treturn (ret);\n") >> CFILE;F  4 	# Set up the pointers to the txnid and the prev lsn: 	printf("\targp->txnid = (DB_TXN *)&argp[1];\n") >> CFILE;  9 	# First get the record type, prev_lsn, and txnid fields.>  % 	printf("\tbp = recbuf;\n") >> CFILE;IE 	printf("\tmemcpy(&argp->type, bp, sizeof(argp->type));\n") >> CFILE;t2 	printf("\tbp += sizeof(argp->type);\n") >> CFILE;8 	printf("\tmemcpy(&argp->txnid->txnid,  bp, ") >> CFILE;3 	printf("sizeof(argp->txnid->txnid));\n") >> CFILE;(: 	printf("\tbp += sizeof(argp->txnid->txnid);\n") >> CFILE;E 	printf("\tmemcpy(&argp->prev_lsn, bp, sizeof(DB_LSN));\n") >> CFILE; . 	printf("\tbp += sizeof(DB_LSN);\n") >> CFILE;   	# Now get rest of data.   	for (i = 0; i < nvars; i ++) {\ 		if (modes[i] == "DBT") {9 			printf("\tmemcpy(&argp->%s.size, ", vars[i]) >> CFILE;c0 			printf("bp, sizeof(u_int32_t));\n") >> CFILE;3 			printf("\tbp += sizeof(u_int32_t);\n") >> CFILE;F7 			printf("\targp->%s.data = bp;\n", vars[i]) >> CFILE;n8 			printf("\tbp += argp->%s.size;\n", vars[i]) >> CFILE;! 		} else if (modes[i] == "ARG") { 0 			printf("\tmemcpy(&argp->%s, bp, %s%s));\n", \3 			    vars[i], "sizeof(argp->", vars[i]) >> CFILE;x; 			printf("\tbp += sizeof(argp->%s);\n", vars[i]) >> CFILE;i 		} else { # POINTER8 			printf("\tmemcpy(&argp->%s, bp, ", vars[i]) >> CFILE;5 			printf(" sizeof(argp->%s));\n", vars[i]) >> CFILE;t; 			printf("\tbp += sizeof(argp->%s);\n", vars[i]) >> CFILE;  		}d 	}   	# Free and return' 	printf("\t*argpp = argp;\n") >> CFILE; ) 	printf("\treturn (0);\n}\n\n") >> CFILE;>   # Recovery templatee  3 	cmd = sprintf("sed -e s/PREF/%s/ -e s/FUNC/%s/ < \M8 	    template/rec_ctemp >> %s", prefix, thisfunc, RFILE)
 	system(cmd);(  * 	# Done writing stuff, reset and continue. 	in_begin = 0; }n END {+ 	if (error || in_begin)s 		print "Unsuccessful"   # Print initialization routine 	# Write PUBLIC declarationg$ 	printf("/*\n * PUBLIC: ") >> CFILE;C 	printf("int __%s_init_print __P((DB_ENV *));\n", prefix) >> CFILE;# 	printf(" */\n") >> CFILE;  ; 	# Create the routine to call db_add_recovery(print_fn, id) : 	printf("int\n__%s_init_print(dbenv)\n", prefix) >> CFILE;8 	printf("\tDB_ENV *dbenv;\n{\n\tint ret;\n\n") >> CFILE;" 	for (i = 0; i < num_funcs; i++) {= 		printf("\tif ((ret = __db_add_recovery(dbenv,\n") >> CFILE;(/ 		printf("\t    __%s_print, DB_%s)) != 0)\n", \;# 		    funcs[i], funcs[i]) >> CFILE;)) 		printf("\t\treturn (ret);\n") >> CFILE;  	}) 	printf("\treturn (0);\n}\n\n") >> CFILE;m    # Recover initialization routine$ 	printf("/*\n * PUBLIC: ") >> CFILE;E 	printf("int __%s_init_recover __P((DB_ENV *));\n", prefix) >> CFILE;  	printf(" */\n") >> CFILE;  7 	# Create the routine to call db_add_recovery(func, id)>< 	printf("int\n__%s_init_recover(dbenv)\n", prefix) >> CFILE;8 	printf("\tDB_ENV *dbenv;\n{\n\tint ret;\n\n") >> CFILE;" 	for (i = 0; i < num_funcs; i++) {= 		printf("\tif ((ret = __db_add_recovery(dbenv,\n") >> CFILE; 1 		printf("\t    __%s_recover, DB_%s)) != 0)\n", \"# 		    funcs[i], funcs[i]) >> CFILE;b) 		printf("\t\treturn (ret);\n") >> CFILE;  	}) 	printf("\treturn (0);\n}\n\n") >> CFILE;a  $ 	# End the conditional for the HFILE 	printf("#endif\n") >> HFILE;b   }%< ' CFILE=$cfile DIR=$dname HFILE=$hfile RFILE=$rfile < $ifilerintf("\tif (%s != NULL)\n", vars[i])                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 