 /*- 7  * See the file LICENSE for redistribution information.   *  * Copyright (c) 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  *+  *	@(#)ex_thread.c	10.6 (Sleepycat) 5/31/98   */    #include "config.h"    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <pthread.h> #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <time.h>  #include <unistd.h>  #endif   #include <db.h>    /*D  * NB: This application is written using POSIX 1003.1b-1993 pthreads8  * interfaces, which may not be portable to your system.  */ = extern int sched_yield(void);			/* Pthread yield function. */    DB_ENV *db_init(char *); void   *deadlock(void *);  void	fatal(char *, int); int	main __P((int, char *[])); int	reader(int); void	stats(void);  void   *trickle(void *); void   *tstart(void *);  void	usage(void);  void	word(void); int	writer(int);   struct _statistics { 	int aborted;				/* Write. */ ! 	int aborts;				/* Read/write. */  	int adds;				/* Write. */ 	int deletes;				/* Write. */  	int txns;				/* Write. */ 	int found;				/* Read. */ 	int notfound;				/* Read. */  } *perf;  
 const char. 	*progname = "ex_thread";		/* Program name. */  2 #define	DATABASE	"access.db"		/* Database name. */  5 #define	WORDLIST	"../test/wordlist"	/* Dictionary. */    /*E  * We can seriously increase the number of collisions and transaction E  * aborts by yielding the scheduler after every DB call.  Specify the   * -p option to do this.  */  int	punish;					/* -p */ int	nlist;					/* -n */  int	nreaders;				/* -r */  int	verbose;				/* -v */ int	nwriters;				/* -w */   ' DB     *dbp;					/* Database handle. */ . DB_ENV *dbenv;					/* Database environment. */% int	nthreads;				/* Total threads. */ " char  **list;					/* Word list. */   /*  * ex_thread -- C  *	Run a simple threaded application of some numbers of readers and (  *	writers competing for a set of words.  *1  * Example UNIX shell script to run this program:   *	% rm -rf TESTDIR   *	% mkdir TESTDIR  *	% ex_thread -h TESTDIR   */  int  main(argc, argv)
 	int argc; 	char *argv[]; {  	extern char *optarg;  	extern int errno, optind; 	DB_INFO dbinfo; 	pthread_t *tids;  	int ch, i;  	char *home; 	void *retp;   	home = "TESTDIR"; 	nlist = 1000; 	nreaders = nwriters = 4; 7 	while ((ch = getopt(argc, argv, "h:pn:r:vw:")) != EOF)  		switch (ch) {  		case 'h':  			home = optarg; 	 			break;  		case 'p':  			punish = 1;	 			break;  		case 'n':  			nlist = atoi(optarg);	 			break;  		case 'r':  			nreaders = atoi(optarg); 	 			break;  		case 'v':  			verbose = 1; 	 			break;  		case 'w':  			nwriters = atoi(optarg); 	 			break;  		case '?': 
 		default: 			usage();  		}  	argc -= optind; 	argv += optind;  . 	/* Initialize the random number generator. */ 	srand(getpid() | time(NULL));   	/* Build the key list. */ 	word();  $ 	/* Remove the previous database. */ 	(void)unlink(DATABASE);  + 	/* Initialize the database environment. */  	dbenv = db_init(home);    	/* Initialize the database. */ $ 	memset(&dbinfo, 0, sizeof(dbinfo));1 	dbinfo.db_pagesize = 1024;		/* Page size: 1K. */   ) 	if ((errno = db_open(DATABASE, DB_BTREE, @ 	    DB_CREATE | DB_THREAD, 0664, dbenv, &dbinfo, &dbp)) != 0) { 		fprintf(stderr, ; 		    "%s: %s: %s\n", progname, DATABASE, strerror(errno));  		exit (1);  	}  $ 	nthreads = nreaders + nwriters + 2;A 	printf("Running: readers %d, writers %d\n", nreaders, nwriters);  	fflush(stdout);  1 	/* Create statistics structures, offset by 1. */ E 	if ((perf = calloc(nreaders + nwriters + 1, sizeof(*perf))) == NULL)  		fatal(NULL, 1);   # 	/* Create thread ID structures. */ ; 	if ((tids = malloc(nthreads * sizeof(pthread_t))) == NULL)  		fatal(NULL, 1);   $ 	/* Create reader/writer threads. */* 	for (i = 0; i < nreaders + nwriters; ++i)1 		if (pthread_create(&tids[i], NULL, tstart, &i))  			fatal("pthread_create", 1);  ) 	/* Create buffer pool trickle thread. */ 1 	if (pthread_create(&tids[i], NULL, trickle, &i))  		fatal("pthread_create", 1);   ' 	/* Create deadlock detector thread. */ 2 	if (pthread_create(&tids[i], NULL, deadlock, &i)) 		fatal("pthread_create", 1);    	/* Wait for the threads. */ 	for (i = 0; i < nthreads; ++i) % 		(void)pthread_join(tids[i], &retp);    	(void)dbp->close(dbp, 0);   	return (db_appexit(dbenv)); }    int 
 reader(id) 	int id; {  	DBT key, data;  	int n;  	char buf[64];   	/* C 	 * DBT's must use local memory or malloc'd memory if the DB handle & 	 * is accessed in a threaded fashion. 	 */ 	memset(&key, 0, sizeof(DBT)); 	memset(&data, 0, sizeof(DBT));  	data.flags = DB_DBT_MALLOC;   	/* C 	 * Read-only threads do not require transaction protection, unless ( 	 * there's a need for repeatable reads. 	 */ 	for (;;) {  		/*7 		 * Randomly yield the scheduler 20% of the time.  Not 7 		 * normal for an application, but useful here to stir  		 * things up.  		 */  		if (rand() % 5 == 0) 			sched_yield();   - 		/* Pick a key at random, and look it up. */  		n = rand() % nlist;  		key.data = list[n];  		key.size = strlen(key.data);   		if (verbose) {6 			sprintf(buf, "reader: %d: list entry %d\n", id, n);* 			write(STDOUT_FILENO, buf, strlen(buf)); 		}   8 		switch (errno = dbp->get(dbp, NULL, &key, &data, 0)) {  		case EAGAIN:			/* Deadlock. */ 			++perf[id].aborts; 	 			break;  		case 0:				/* Success. */  			++perf[id].found; 			free(data.data); 	 			break; % 		case DB_NOTFOUND:		/* Not found. */  			++perf[id].notfound; 	 			break; 
 		default: 			sprintf(buf, 8 			    "reader %d: dbp->get: %s", id, (char *)key.data); 			fatal(buf, 0);  		}  	} 	return (0); }    int 
 writer(id) 	int id; {  	DBT key, data;  	DB_TXNMGR *txnp; 
 	DB_TXN *tid;  	time_t now, then; 	int n;  	char buf[256], dbuf[10000];   	time(&now); 	then = now; 	txnp = dbenv->tx_info;    	/* C 	 * DBT's must use local memory or malloc'd memory if the DB handle & 	 * is accessed in a threaded fashion. 	 */ 	memset(&key, 0, sizeof(DBT)); 	memset(&data, 0, sizeof(DBT));  	data.data = dbuf; 	data.ulen = sizeof(dbuf); 	data.flags = DB_DBT_USERMEM;    	for (;;) {  		/*7 		 * Randomly yield the scheduler 20% of the time.  Not 7 		 * normal for an application, but useful here to stir  		 * things up.  		 */  		if (rand() % 5 == 0) 			sched_yield();    		/* Pick a random key. */ 		n = rand() % nlist;  		key.data = list[n];  		key.size = strlen(key.data);   		if (verbose) {6 			sprintf(buf, "writer: %d: list entry %d\n", id, n);* 			write(STDOUT_FILENO, buf, strlen(buf)); 		}    		/* Abort and retry. */
 		if (0) { retry:			if (txn_abort(tid)) 				fatal("txn_abort", 1); 			++perf[id].aborts;  			++perf[id].aborted; 		}   8 		/* Thread #1 prints out the stats every 20 seconds. */ 		if (id == 1) { 			time(&now); 			if (now - then >= 20) { 				stats(); 				then = now;  			} 		}    		/* Begin the transaction. */1 		if ((errno = txn_begin(txnp, NULL, &tid)) != 0)  			fatal("txn_begin", 1);   , 		if (punish)			/* See -p option comment. */ 			sched_yield();    		/*; 		 * Get the key.  If it doesn't exist, add it.  If it does  		 * exist, delete it. 		 */ 7 		switch (errno = dbp->get(dbp, tid, &key, &data, 0)) {  		case EAGAIN: 			goto retry;	 		case 0:  			goto delete;  		case DB_NOTFOUND:  			goto add; 		}   + 		sprintf(buf, "writer: %d: dbp->get", id);  		fatal(buf, 1); 		/* NOTREACHED */  3 delete:		if (punish)			/* See -p option comment. */  			sched_yield();    		/* Delete the key. */ 0 		switch (errno = dbp->del(dbp, tid, &key, 0)) { 		case EAGAIN: 			goto retry;	 		case 0:  			++perf[id].deletes; 			goto commit;  		}   + 		sprintf(buf, "writer: %d: dbp->del", id);  		fatal(buf, 1); 		/* NOTREACHED */  0 add:		if (punish)			/* See -p option comment. */ 			sched_yield();   < 		/* Add the key.  1 data item in 30 is an overflow item. */  		data.size = 20 + rand() % 128; 		if (rand() % 30 == 0)  			data.size += 8192;   7 		switch (errno = dbp->put(dbp, tid, &key, &data, 0)) {  		case EAGAIN: 			goto retry;	 		case 0:  			++perf[id].adds;  			goto commit; 
 		default:, 			sprintf(buf, "writer: %d: dbp->put", id); 			fatal(buf, 1);n 		}*  3 commit:		if (punish)			/* See -p option comment. */  			sched_yield();.  , 		/* The transaction finished, commit it. */% 		if ((errno = txn_commit(tid)) != 0)n 			fatal("txn_commit", 1);   		/*: 		 * Every time the thread completes 20 transactions, show 		 * our progress. 		 */t" 		if (++perf[id].txns % 20 == 0) { 			sprintf(buf,iA "writer: %2d: adds: %4d: deletes: %4d: aborts: %4d: txns: %4d\n",p+ 			    id, perf[id].adds, perf[id].deletes, ' 			    perf[id].aborts, perf[id].txns); * 			write(STDOUT_FILENO, buf, strlen(buf)); 		}y   		/*8 		 * If this thread was aborted more than 5 times before( 		 * the transaction finished, complain. 		 */a 		if (perf[id].aborted > 5) {c 			sprintf(buf,eO "writer: %2d: adds: %4d: deletes: %4d: aborts: %4d: txns: %4d: ABORTED: %2d\n", + 			    id, perf[id].adds, perf[id].deletes,r9 			    perf[id].aborts, perf[id].txns, perf[id].aborted);t* 			write(STDOUT_FILENO, buf, strlen(buf)); 		}a 		perf[id].aborted = 0;t 	} 	return (0); }.   /*  * stats --	F  *	Display reader/writer thread statistics.  To display the statistics=  *	for the mpool trickle or deadlock threads, use db_stat(1).   */  void stats()A {A 	int id; 	char *p, buf[8192];  + 	p = buf + sprintf(buf, "-------------\n");D( 	for (id = 0; id < nreaders + nwriters;) 		if (id++ < nwriters) 			p += sprintf(p,B 	"writer: %2d: adds: %4d: deletes: %4d: aborts: %4d: txns: %4d\n", 			    id, perf[id].adds, 9 			    perf[id].deletes, perf[id].aborts, perf[id].txns);  		else 			p += sprintf(p,9 	"reader: %2d: found: %5d: notfound: %5d: aborts: %4d\n",  			    id, perf[id].found,+ 			    perf[id].notfound, perf[id].aborts);a$ 	p += sprintf(p, "-------------\n");  $ 	write(STDOUT_FILENO, buf, p - buf); }W   /*
  * db_init --*  *	Initialize the environment.  */d DB_ENV *
 db_init(home)m 	char *home; {n 	DB_ENV *dbenv;m  % 	/* Define our own yield function. */e) 	db_jump_set(sched_yield, DB_FUNC_YIELD);*  2 	/* Rely on calloc to initialize the structure. */= 	if ((dbenv = (DB_ENV *)calloc(sizeof(DB_ENV), 1)) == NULL) {a: 		fprintf(stderr, "%s: %s\n", progname, strerror(ENOMEM)); 		exit (1);d 	} 	dbenv->lg_max = 200000; 	dbenv->db_errfile = stderr; 	dbenv->db_errpfx = progname; 5 	dbenv->mp_size = 100 * 1024;		/* Cachesize: 100K. */   + 	if ((errno = db_appinit(home, NULL, dbenv,	- 	    DB_CREATE | DB_INIT_LOCK | DB_INIT_LOG | 6 	    DB_INIT_MPOOL | DB_INIT_TXN | DB_THREAD)) != 0) { 		fprintf(stderr,i9 		    "%s: db_appinit: %s\n", progname, strerror(errno));  		exit (1);  	} 	return (dbenv); }    /*  * tstart --1  *	Thread start function for readers and writers.)  */	 void * tstart(arg)  	void *arg;  {u 	pthread_t tid;a 	int id;   	id = *(int *)arg + 1;   	tid = pthread_self();   	if (id <= nwriters) {B 		printf("write thread %d starting: tid: %lu\n", id, (u_long)tid); 		fflush(stdout);e
 		writer(id); 	 	} else {uA 		printf("read thread %d starting: tid: %lu\n", id, (u_long)tid);d 		fflush(stdout);)
 		reader(id);a 	}   	/* NOTREACHED */m 	return (NULL);  }e   /*  * deadlock --+  *	Thread start function for lock_detect().   */( void *
 deadlock(arg)E 	void *arg;  {  	struct timeval t; 	pthread_t tid;&  / 	arg = arg;				/* XXX: shut the compiler up. */% 	tid = pthread_self();  = 	printf("deadlock thread starting: tid: %lu\n", (u_long)tid);a 	fflush(stdout);   	t.tv_sec = 0; 	t.tv_usec = 100000; 	for (;;) {d# 		(void)lock_detect(dbenv->lk_info, ) 		    DB_LOCK_CONFLICT, DB_LOCK_DEFAULT);    		/* Check every 100ms. */( 		(void)select(0, NULL, NULL, NULL, &t); 	}   	/* NOTREACHED */  	return (NULL);r }    /*
  * trickle --i,  *	Thread start function for memp_trickle().  */  void * trickle(arg) 	void *arg;r {e 	pthread_t tid;r 	int wrote;r 	char buf[64];  / 	arg = arg;				/* XXX: shut the compiler up. */i 	tid = pthread_self();  < 	printf("trickle thread starting: tid: %lu\n", (u_long)tid); 	fflush(stdout);   	for (;;) {(1 		(void)memp_trickle(dbenv->mp_info, 10, &wrote);e 		if (verbose) {. 			sprintf(buf, "trickle: wrote %d\n", wrote);* 			write(STDOUT_FILENO, buf, strlen(buf)); 		}( 		if (wrote == 0) {  			sleep(1); 			sched_yield();  		}( 	}   	/* NOTREACHED */  	return (NULL);_ }n   /*
  * word --"  *	Build the dictionary word list.  */  void word() {)
 	FILE *fp;	 	int cnt;i 	char buf[256];   ) 	if ((fp = fopen(WORDLIST, "r")) == NULL)  		fatal(WORDLIST, 1);e  5 	if ((list = malloc(nlist * sizeof(char *))) == NULL)s 		fatal(NULL, 1);a  $ 	for (cnt = 0; cnt < nlist; ++cnt) {* 		if (fgets(buf, sizeof(buf), fp) == NULL)	 			break;g( 		if ((list[cnt] = strdup(buf)) == NULL) 			fatal(NULL, 1); 	}< 	nlist = cnt;		/* In case nlist was larger than possible. */ }    /*  * fatal --(!  *	Report a fatal error and quit.h  */e void fatal(msg, syserr) 	char *msg;a 	int syserr; {i# 	fprintf(stderr, "%s: ", progname);i 	if (msg != NULL) {f 		fprintf(stderr, "%s", msg);e
 		if (syserr)P 			fprintf(stderr, ": ");o 	} 	if (syserr)) 		fprintf(stderr, "%s", strerror(errno));  	fprintf(stderr, "\n");a
 	exit (1);   	/* NOTREACHED */n }b   /*  * usage --s  *	Usage message.n  */	 void usage()I {O 	(void)fprintf(stderr,G     "usage: %s [-pv] [-h home] [-n words] [-r readers] [-w writers]\n",G 	    progname);k	 	exit(1);p }[].aborts; 	 			break;  		case 0:				/* Success. */  			++perf[id].found; 			free(data.data); 	 			break; % 		case DB_NOTFOUND:		/* Not found. */  			++perf[id].notfound; 	 			break; 
 		default: 			sprintf(buf, 8 			    "reader %d: dbp->                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                