 /*- 7  * See the file LICENSE for redistribution information.   *  * Copyright (c) 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  *+  *	@(#)ex_tpcb.c	10.26 (Sleepycat) 11/22/98   */    #include "config.h"    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <stdlib.h>  #include <string.h>  #include <time.h>  #include <unistd.h>  #endif  
 #ifdef _WIN32  #include <sys/types.h> #include <sys/timeb.h> #endif     #include <db.h>   / typedef enum { ACCOUNT, BRANCH, TELLER } FTYPE;   ( DB_ENV	 *db_init(char *, int, int, int);? void	  hpopulate(DB *, u_int, u_int32_t, u_int32_t, u_int32_t);  void	  invarg(int, char *);   int	  main __P((int, char *[]));; void	  populate(DB *, u_int32_t, u_int32_t, u_int, char *); < u_int32_t random_id(FTYPE, u_int32_t, u_int32_t, u_int32_t);+ u_int32_t random_int(u_int32_t, u_int32_t); 1 void	  tp_populate(DB_ENV *, int, int, int, int); , void	  tp_run(DB_ENV *, int, int, int, int);A int	  tp_txn(DB_TXNMGR *, DB *, DB *, DB *, DB *, int, int, int);  void	  usage(void);    int verbose;
 const char. 	*progname = "ex_tpcb";				/* Program name. */   /*G  * This program implements a basic TPC/B driver program.  To create the F  * TPC/B database, run with the -i (init) flag.  The number of recordsI  * with which to populate the account, history, branch, and teller tables I  * is specified by the a, s, b, and t flags respectively.  To run a TPC/B I  * test, use the n flag to indicate a number of transactions to run (note E  * that you can run many of these processes in parallel to simulate a   * multiuser test run).   */  #define	TELLERS_PER_BRANCH	10 ! #define	ACCOUNTS_PER_TELLER	10000 " #define	HISTORY_PER_BRANCH	2592000   /*H  * The default configuration that adheres to TPCB scaling rules requiresI  * nearly 3 GB of space.  To avoid requiring that much space for testing, G  * we set the parameters much lower.  If you want to run a valid 10 TPS '  * configuration, define VALID_SCALING.   */  #ifdef VALID_SCALING #define	ACCOUNTS	 1000000  #define	BRANCHES	      10  #define	TELLERS		     100  #define HISTORY		25920000  #else  #define	ACCOUNTS	  100000  #define	BRANCHES	      10  #define	TELLERS		     100  #define HISTORY		  259200  #endif   #define HISTORY_LEN	    100  #define	RECLEN		    100  #define	BEGID		1000000   typedef struct _defrec { 	u_int32_t	id; 	u_int32_t	balance; > 	u_int8_t	pad[RECLEN - sizeof(u_int32_t) - sizeof(u_int32_t)];	 } defrec;    typedef struct _histrec {  	u_int32_t	aid;  	u_int32_t	bid;  	u_int32_t	tid;  	u_int32_t	amount;. 	u_int8_t	pad[RECLEN - 4 * sizeof(u_int32_t)];
 } histrec;  
 #ifdef _WIN32 ) /* Simulation of UNIX gettimeofday(2). */  struct timeval {
 	long tv_sec;  	long tv_usec; };   struct timezone {  	int tz_minuteswest; 	int tz_dsttime; };   int  gettimeofday(tp, tzp)  	struct timeval *tp; 	struct timezone *tzp; {  	struct _timeb tb;  
 	_ftime(&tb);  	if (tp != 0) {  		tp->tv_sec = tb.time; " 		tp->tv_usec = tb.millitm * 1000; 	} 	if (tzp != 0) {$ 		tzp->tz_minuteswest = tb.timezone; 		tzp->tz_dsttime = tb.dstflag;  	} 	return (0); }  #endif   int  main(argc, argv)
 	int argc; 	char *argv[]; {  	extern char *optarg;  	extern int optind;  	DB_ENV *dbenv; 
 	u_long seed; * 	int accounts, branches, tellers, history;* 	int ch, iflag, mpool, ntxns, txn_no_sync; 	char *home, *endarg;   
 	home = NULL; - 	accounts = branches = history = tellers = 0;  	txn_no_sync = 0;  	mpool = ntxns = 0; 
 	verbose = 0;  	iflag = 0;  	seed = (u_long)getpid(); @ 	while ((ch = getopt(argc, argv, "a:b:fh:im:n:S:s:t:v")) != EOF) 		switch (ch) { - 		case 'a':			/* Number of account records */ & 			if ((accounts = atoi(optarg)) <= 0) 				invarg(ch, optarg); 	 			break; , 		case 'b':			/* Number of branch records */& 			if ((branches = atoi(optarg)) <= 0) 				invarg(ch, optarg); 	 			break; & 		case 'c':			/* Cachesize in bytes */# 			if ((mpool = atoi(optarg)) <= 0)  				invarg(ch, optarg); 	 			break; + 		case 'f':			/* Fast mode: no txn sync. */  			txn_no_sync = 1; 	 			break;  		case 'h':			/* DB  home. */  			home = optarg; 	 			break; ( 		case 'i':			/* Initialize the test. */
 			iflag = 1; 	 			break; * 		case 'n':			/* Number of transactions */# 			if ((ntxns = atoi(optarg)) <= 0)  				invarg(ch, optarg); 	 			break; ' 		case 'S':			/* Random number seed. */ & 			seed = strtoul(optarg, &endarg, 0); 			if (*endarg != '\0')  				invarg(ch, optarg); 	 			break; - 		case 's':			/* Number of history records */ % 			if ((history = atoi(optarg)) <= 0)  				invarg(ch, optarg); 	 			break; , 		case 't':			/* Number of teller records */% 			if ((tellers = atoi(optarg)) <= 0)  				invarg(ch, optarg); 	 			break; # 		case 'v':			/* Verbose option. */  			verbose = 1; 	 			break;  		case '?': 
 		default: 			usage();  		}  	argc -= optind; 	argv += optind;   	srand((u_int)seed);  + 	/* Initialize the database environment. */ F 	dbenv = db_init(home, mpool, iflag, txn_no_sync ? DB_TXN_NOSYNC : 0);  0 	accounts = accounts == 0 ? ACCOUNTS : accounts;0 	branches = branches == 0 ? BRANCHES : branches;, 	tellers = tellers == 0 ? TELLERS : tellers;, 	history = history == 0 ? HISTORY : history;  
 	if (verbose) B 		printf("%ld Accounts, %ld Branches, %ld Tellers, %ld History\n",% 		    (long)accounts, (long)branches, $ 		    (long)tellers, (long)history);  
 	if (iflag) {  		if (ntxns != 0)  			usage(); ; 		tp_populate(dbenv, accounts, branches, history, tellers); 	 	} else {  		if (ntxns == 0)  			usage(); 4 		tp_run(dbenv, ntxns, accounts, branches, tellers); 	}  ( 	if ((errno = db_appexit(dbenv)) != 0) {9 		fprintf(stderr, "%s: %s\n", progname, strerror(errno));  		exit (1);  	}   	return (0); }    /*
  * db_init --   *	Initialize the environment.  */  DB_ENV *+ db_init(home, mp_size, initializing, flags)  	char *home;
 	int mp_size;  	int initializing; 	int flags;  {  	DB_ENV *dbenv;  	u_int32_t local_flags;   2 	/* Rely on calloc to initialize the structure. */= 	if ((dbenv = (DB_ENV *)calloc(sizeof(DB_ENV), 1)) == NULL) { $ 		fprintf(stderr, "%s: ", progname); 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);  	}   	dbenv->db_errfile = stderr; 	dbenv->db_errpfx = progname; C 	dbenv->mp_size = mp_size == 0 ? 4 * 1024 * 1024 : (size_t)mp_size;   B 	local_flags = flags | DB_CREATE | (initializing ? DB_INIT_MPOOL :? 	    DB_INIT_TXN | DB_INIT_LOCK | DB_INIT_LOG | DB_INIT_MPOOL); A 	if ((errno = db_appinit(home, NULL, dbenv, local_flags)) != 0) { 0 		fprintf(stderr, "%s: db_appinit: ", progname); 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);  	}   	return (dbenv); }    void invarg(arg, str)	 	int arg;  	char *str;  {  	(void)fprintf(stderr,? 	    "%s: invalid argument for -%c: %s\n", progname, arg, str); 
 	exit (1); }    void usage()  {  	char *a1, *a2;   5 	a1 = "[-v] [-a accounts] [-b branches] [-h home]\n"; F 	a2 = "          [-m mpool_size] [-S seed] [-s history] [-t tellers]";A 	(void)fprintf(stderr, "usage: %s -i %s %s\n", progname, a1, a2);  	(void)fprintf(stderr,< 	    "       %s -n transactions %s %s\n", progname, a1, a2);	 	exit(1);  }    /*I  * Initialize the database to the specified number of accounts, branches,    * history records, and tellers.  */  void, tp_populate(env, num_a, num_b, num_h, num_t)
 	DB_ENV *env;   	int num_a, num_b, num_h, num_t; { 	 	DB *dbp; 
 	DB_INFO dbi;  	u_int32_t balance, idnum;( 	u_int32_t end_anum, end_bnum, end_tnum;. 	u_int32_t start_anum, start_bnum, start_tnum;   	idnum = BEGID;  	balance = 500000;   	memset(&dbi, 0, sizeof(dbi));   	dbi.h_nelem = (u_int)num_a;  	if ((errno = db_open("account",F 	    DB_HASH, DB_CREATE | DB_TRUNCATE, 0644, env, &dbi, &dbp)) != 0) {> 		fprintf(stderr, "%s: Account file open failed: ", progname); 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);  	}   	start_anum = idnum;7 	populate(dbp, idnum, balance, dbi.h_nelem, "account");i 	idnum += dbi.h_nelem; 	end_anum = idnum - 1;) 	if ((errno = dbp->close(dbp, 0)) != 0) {r? 		fprintf(stderr, "%s: Account file close failed: ", progname);  		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);g 	}
 	if (verbose)e+ 		printf("Populated accounts: %ld - %ld\n",_( 		    (long)start_anum, (long)end_anum);     	/*.C 	 * Since the number of branches is very small, we want to use veryED 	 * small pages and only 1 key per page.  This is the poor-man's way3 	 * of getting key locking instead of page locking.  	 */ 	dbi.h_nelem = (u_int)num_b; 	dbi.h_ffactor = 1;  	dbi.db_pagesize = 512;B 	if ((errno = db_open("branch",cF 	    DB_HASH, DB_CREATE | DB_TRUNCATE, 0644, env, &dbi, &dbp)) != 0) {? 		fprintf(stderr, "%s: Branch file create failed: ", progname);D 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);  	} 	start_bnum = idnum;6 	populate(dbp, idnum, balance, dbi.h_nelem, "branch"); 	idnum += dbi.h_nelem; 	end_bnum = idnum - 1;) 	if ((errno = dbp->close(dbp, 0)) != 0) {cA 		fprintf(stderr, "%s: Close of branch file failed: ", progname);m 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);e 	}  
 	if (verbose) + 		printf("Populated branches: %ld - %ld\n", ( 		    (long)start_bnum, (long)end_bnum);     	/*aC 	 * In the case of tellers, we also want small pages, but we'll letr. 	 * the fill factor dynamically adjust itself. 	 */ 	dbi.h_nelem = (u_int)num_t; 	dbi.h_ffactor = 0;E 	dbi.db_pagesize = 512;* 	if ((errno = db_open("teller",dF 	    DB_HASH, DB_CREATE | DB_TRUNCATE, 0644, env, &dbi, &dbp)) != 0) {? 		fprintf(stderr, "%s: Teller file create failed: ", progname);s 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);  	}   	start_tnum = idnum;6 	populate(dbp, idnum, balance, dbi.h_nelem, "teller"); 	idnum += dbi.h_nelem; 	end_tnum = idnum - 1;) 	if ((errno = dbp->close(dbp, 0)) != 0) { > 		fprintf(stderr, "%s: Teller file close failed: ", progname); 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);_ 	}
 	if (verbose)o* 		printf("Populated tellers: %ld - %ld\n",( 		    (long)start_tnum, (long)end_tnum);   	memset(&dbi, 0, sizeof(dbi)); 	dbi.re_len = HISTORY_LEN; 	dbi.flags = DB_FIXEDLEN;4  	if ((errno = db_open("history",G 	    DB_RECNO, DB_CREATE | DB_TRUNCATE, 0644, env, &dbi, &dbp)) != 0) {m@ 		fprintf(stderr, "%s: History file create failed: ", progname); 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);m 	}  , 	hpopulate(dbp, num_h, num_a, num_b, num_t);) 	if ((errno = dbp->close(dbp, 0)) != 0) {m? 		fprintf(stderr, "%s: History file close failed: ", progname);n 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);r 	} }g   void, populate(dbp, start_id, balance, nrecs, msg)	 	DB *dbp;a 	u_int32_t start_id, balance;t
 	u_int nrecs;i 	char *msg;n {s 	DBT kdbt, ddbt;
 	defrec drec;a	 	u_int i;m   	kdbt.flags = 0; 	kdbt.data = &drec.id; 	kdbt.size = sizeof(u_int32_t);  	ddbt.flags = 0; 	ddbt.data = &drec;  	ddbt.size = sizeof(drec);+ 	memset(&drec.pad[0], 1, sizeof(drec.pad));,   	for (i = 0; i < nrecs; i++) {$ 		drec.id = start_id + (u_int32_t)i; 		drec.balance = balance;  		if ((errno =B 		    (dbp->put)(dbp, NULL, &kdbt, &ddbt, DB_NOOVERWRITE)) != 0) {8 			fprintf(stderr, "%s: Failure initializing %s file\n", 			    progname, msg); 			exit (1); 		}) 	} }b   void' hpopulate(dbp, nrecs, anum, bnum, tnum)		 	DB *dbp; 
 	u_int nrecs;  	u_int32_t anum, bnum, tnum; {  	DBT kdbt, ddbt; 	histrec hrec; 	db_recno_t key;
 	u_int32_t i;_    	memset(&kdbt, 0, sizeof(kdbt));  	memset(&ddbt, 0, sizeof(ddbt)); 	ddbt.data = &hrec;a 	ddbt.size = sizeof(hrec); 	kdbt.data = &key; 	kdbt.size = sizeof(key);'+ 	memset(&hrec.pad[0], 1, sizeof(hrec.pad));n 	hrec.amount = 10;   	for (i = 1; i <= nrecs; i++) {b2 		hrec.aid = random_id(ACCOUNT, anum, bnum, tnum);1 		hrec.bid = random_id(BRANCH, anum, bnum, tnum);g1 		hrec.tid = random_id(TELLER, anum, bnum, tnum);	 		if ((errno =; 		    dbp->put(dbp, NULL, &kdbt, &ddbt, DB_APPEND)) != 0) {  			fprintf(stderr,1 			    "%s: Failure initializing history file: ",f 			    progname);  			if (errno < 0)t3 				fprintf(stderr, "returned %ld\n", (long)errno);k 			elsee- 				fprintf(stderr, "%s\n", strerror(errno));  			exit (1); 		}e 	} }   	 u_int32_t	 random_int(lo, hi) 	u_int32_t lo, hi; {= 	u_int32_t ret;d 	int t;e   	t = rand();; 	ret = (u_int32_t)(((double)t / ((double)(RAND_MAX) + 1)) *m 	    (hi - lo + 1)); 	ret += lo;O 	return (ret); }u  	 u_int32_ts, random_id(type, accounts, branches, tellers) 	FTYPE type;' 	u_int32_t accounts, branches, tellers;  {  	u_int32_t min, max, num;y   	max = min = BEGID;R 	num = accounts; 	switch(type) {r
 	case TELLER:n 		min += branches; 		num = tellers; 		/* FALLTHROUGH */)
 	case BRANCH:) 		if (type == BRANCH)) 			num = branches; 		min += accounts; 		/* FALLTHROUGH */  	case ACCOUNT: 		max = min + num - 1; 	} 	return (random_int(min, max));  }e   void- tp_run(dbenv, n, accounts, branches, tellers)v 	DB_ENV *dbenv;,$ 	int n, accounts, branches, tellers; {  	DB *adb, *bdb, *hdb, *tdb;	 	double gtps, itps;%* 	int failed, ifailed, ret, txns, gus, ius;- 	struct timeval starttime, curtime, lasttime;- #ifndef _WIN32 	pid_t pid;m   	pid = getpid(); #elsei	 	int pid;s  	 	pid = 0;z #endif   	/*c 	 * Open the database files. 	 */
 	if ((errno =tE 	    db_open("account", DB_UNKNOWN, 0, 0, dbenv, NULL, &adb)) != 0) { A 		fprintf(stderr, "%s: Open of account file failed: ", progname);l 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);r 	}
 	if ((errno =rD 	    db_open("branch", DB_UNKNOWN, 0, 0, dbenv, NULL, &bdb)) != 0) {@ 		fprintf(stderr, "%s: Open of branch file failed: ", progname); 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);T 	}
 	if ((errno = D 	    db_open("teller", DB_UNKNOWN, 0, 0, dbenv, NULL, &tdb)) != 0) {@ 		fprintf(stderr, "%s: Open of teller file failed: ", progname); 		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);; 	}
 	if ((errno = E 	    db_open("history", DB_UNKNOWN, 0, 0, dbenv, NULL, &hdb)) != 0) {rA 		fprintf(stderr, "%s: Open of history file failed: ", progname);  		if (errno < 0)2 			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);\ 	}   	txns = failed = ifailed = 0;]& 	(void)gettimeofday(&starttime, NULL); 	lasttime = starttime; 	while (n-- >= 0) {,	 		txns++;a 		ret = tp_txn(dbenv->tx_info,7 		    adb, bdb, tdb, hdb, accounts, branches, tellers);  		if (ret != 0) {  			failed++;
 			ifailed++;a 		}t 		if (n % 1000 == 0) {& 			(void)gettimeofday(&curtime, NULL);/ 			gus = curtime.tv_usec >= starttime.tv_usec ?m, 			    curtime.tv_usec - starttime.tv_usec +6 			    1000000 * (curtime.tv_sec - starttime.tv_sec) :6 			    1000000 + curtime.tv_usec - starttime.tv_usec +9 			    1000000 * (curtime.tv_sec - starttime.tv_sec - 1);t. 			ius = curtime.tv_usec >= lasttime.tv_usec ?+ 			    curtime.tv_usec - lasttime.tv_usec +l5 			    1000000 * (curtime.tv_sec - lasttime.tv_sec) : 5 			    1000000 + curtime.tv_usec - lasttime.tv_usec +d8 			    1000000 * (curtime.tv_sec - lasttime.tv_sec - 1);# 			gtps = (double)(txns - failed) /  			    ((double)gus / 1000000);n$ 			itps = (double)(1000 - ifailed) / 			    ((double)ius / 1000000); . 			printf("[%d] %d txns %d failed ", (int)pid, 			    txns, failed);,5 			printf("%6.2f TPS (gross) %6.2f TPS (interval)\n",d 			   gtps, itps); 			lasttime = curtime; 			ifailed = 0;r 		}p 	}   	(void)adb->close(adb, 0); 	(void)bdb->close(bdb, 0); 	(void)tdb->close(tdb, 0); 	(void)hdb->close(hdb, 0);  I 	printf("%ld transactions begun %ld failed\n", (long)txns, (long)failed);) }    /*6  * XXX Figure out the appropriate way to pick out IDs.  */	 intl3 tp_txn(txmgr, adb, bdb, tdb, hdb, anum, bnum, tnum)  	DB_TXNMGR *txmgr; 	DB *adb, *bdb, *tdb, *hdb;u 	int anum, bnum, tnum; {n 	DBC *acurs, *bcurs, *tcurs;( 	DBT d_dbt, d_histdbt, k_dbt, k_histdbt; 	DB_TXN *t;d 	db_recno_t key; 	defrec rec; 	histrec hrec; 	int account, branch, teller;d  
 	t = NULL; 	acurs = bcurs = tcurs = NULL;   	/*"@ 	 * XXX We could move a lot of this into the driver to make this 	 * faster.p 	 */0 	account = random_id(ACCOUNT, anum, bnum, tnum);. 	branch = random_id(BRANCH, anum, bnum, tnum);. 	teller = random_id(TELLER, anum, bnum, tnum);  * 	memset(&d_histdbt, 0, sizeof(d_histdbt));  * 	memset(&k_histdbt, 0, sizeof(k_histdbt)); 	k_histdbt.data = &key;  	k_histdbt.size = sizeof(key);  " 	memset(&k_dbt, 0, sizeof(k_dbt)); 	k_dbt.size = sizeof(int);  " 	memset(&d_dbt, 0, sizeof(d_dbt)); 	d_dbt.flags = DB_DBT_USERMEM; 	d_dbt.data = &rec;  	d_dbt.ulen = sizeof(rec);   	hrec.aid = account; 	hrec.bid = branch;d 	hrec.tid = teller;( 	hrec.amount = 10;4 	/* Request 0 bytes since we're just positioning. */" 	d_histdbt.flags = DB_DBT_PARTIAL;   	/* START TIMING */ % 	if (txn_begin(txmgr, NULL, &t) != 0)e 		goto err;a  + 	if (adb->cursor(adb, t, &acurs, 0) != 0 ||y+ 	    bdb->cursor(bdb, t, &bcurs, 0) != 0 ||=) 	    tdb->cursor(tdb, t, &tcurs, 0) != 0)d 		goto err;5   	/* Account record */e 	k_dbt.data = &account;H6 	if (acurs->c_get(acurs, &k_dbt, &d_dbt, DB_SET) != 0) 		goto err;( 	rec.balance += 10;i: 	if (acurs->c_put(acurs, &k_dbt, &d_dbt, DB_CURRENT) != 0) 		goto err;e   	/* Branch record */ 	k_dbt.data = &branch;6 	if (bcurs->c_get(bcurs, &k_dbt, &d_dbt, DB_SET) != 0) 		goto err;  	rec.balance += 10;,: 	if (bcurs->c_put(bcurs, &k_dbt, &d_dbt, DB_CURRENT) != 0) 		goto err;u   	/* Teller record */ 	k_dbt.data = &teller;6 	if (tcurs->c_get(tcurs, &k_dbt, &d_dbt, DB_SET) != 0) 		goto err;a 	rec.balance += 10;): 	if (tcurs->c_put(tcurs, &k_dbt, &d_dbt, DB_CURRENT) != 0) 		goto err;s   	/* History record */r 	d_histdbt.flags = 0;} 	d_histdbt.data = &hrec; 	d_histdbt.ulen = sizeof(hrec);,> 	if (hdb->put(hdb, t, &k_histdbt, &d_histdbt, DB_APPEND) != 0) 		goto err;   @ 	if (acurs->c_close(acurs) != 0 || bcurs->c_close(bcurs) != 0 ||  	    tcurs->c_close(tcurs) != 0) 		goto err;|   	if (txn_commit(t) != 0) 		goto err;0   	/* END TIMING */r 	return (0);   err:	if (acurs != NULL)g 		(void)acurs->c_close(acurs); 	if (bcurs != NULL)d 		(void)bcurs->c_close(bcurs); 	if (tcurs != NULL)s 		(void)tcurs->c_close(tcurs); 	if (t != NULL)u 		(void)txn_abort(t);   
 	if (verbose)i2 		printf("Transaction A=%ld B=%ld T=%ld failed\n",1 		    (long)account, (long)branch, (long)teller);)
 	return (-1);  })			fprintf(stderr, "returned %ld\n", (long)errno); 		else, 			fprintf(stderr, "%s\n", strerror(errno)); 		exit (1);r 	} }g   void, populate(dbp, start_id, balance, nrecs, msg)	 	DB *dbp;a 	u_int32_t start_id, balance;t
 	u_int nrecs;i 	char *msg;n {s 	DBT kdbt, ddbt;
 	defrec drec;a	 	u_int i;m   	kdbt.flags = 0; 	kdbt.data = &drec.id; 	kdbt.size = sizeof(u_int32_t);  	ddbt.flags = 0; 	ddbt.data = &drec;  	ddbt.size = sizeof(drec);+ 	memse                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                