 /*- 7  * See the file LICENSE for redistribution information.   *  * Copyright (c) 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  *0  *	@(#)TpcbExample.cpp	10.11 (Sleepycat) 12/7/98  */    #include "config.h"    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <iostream.h>  #include <stdlib.h>  #include <string.h>  #include <unistd.h>  #endif  
 #ifdef _WIN32  #include <sys/types.h> #include <sys/timeb.h> #endif   #include <db_cxx.h>   / typedef enum { ACCOUNT, BRANCH, TELLER } FTYPE;   C void errExit(int err, const char *);  // show err as errno and exit    void	  invarg(int, char *); < u_int32_t random_id(FTYPE, u_int32_t, u_int32_t, u_int32_t);+ u_int32_t random_int(u_int32_t, u_int32_t);  static void	  usage(void);   int verbose;K char *progname = "TpcbExample";                            // Program name.   
 #ifdef _WIN32   /* Simulation of gettimeofday */   struct timeval {     long tv_sec;     long tv_usec;  };   struct timezone {      int tz_minuteswest;      int tz_dsttime;  };  : int gettimeofday(struct timeval *tp, struct timezone *tzp) {      struct _timeb tb;        _ftime(&tb);     if (tp != 0) {         tp->tv_sec = tb.time; (         tp->tv_usec = tb.millitm * 1000;     }      if (tzp != 0) { *         tzp->tz_minuteswest = tb.timezone;%         tzp->tz_dsttime = tb.dstflag;      } 
     return 0;  }    #endif    class TpcbExample : public DbEnv {  public: &     void populate(int, int, int, int);!     void run(int, int, int, int);      int txn(DbTxnMgr *, #             Db *, Db *, Db *, Db *,              int, int, int); 7     void populateHistory(Db *, unsigned int, u_int32_t, /                          u_int32_t, u_int32_t); I     void populateTable(Db *, u_int32_t, u_int32_t, unsigned int, char *);   B     // Note: the constructor uses the default DbEnv() constructor,A     // which means that appinit() can be called after all options "     // have been set in the DbEnv.     //     TpcbExample() : DbEnv() {}   private:!     static const char FileName[];   &     // no need for copy and assignment%     TpcbExample(const TpcbExample &); %     operator = (const TpcbExample &);  };   //G // This program implements a basic TPC/B driver program.  To create the F // TPC/B database, run with the -i (init) flag.  The number of recordsI // with which to populate the account, history, branch, and teller tables I // is specified by the a, s, b, and t flags respectively.  To run a TPC/B I // test, use the n flag to indicate a number of transactions to run (note E // that you can run many of these processes in parallel to simulate a  // multiuser test run).  //2 // XXX Margo, check these ratios and record sizes. //# #define TELLERS_PER_BRANCH      100 $ #define ACCOUNTS_PER_TELLER     1000   #define ACCOUNTS 1000000 #define	BRANCHES 10  #define TELLERS 1000 #define HISTORY 1000000  #define HISTORY_LEN 100  #define RECLEN 100 #define BEGID   1000000    struct Defrec {      u_int32_t   id;      u_int32_t   balance;D     u_int8_t    pad[RECLEN - sizeof(u_int32_t) - sizeof(u_int32_t)]; };   struct Histrec {     u_int32_t   aid;     u_int32_t   bid;     u_int32_t   tid;     u_int32_t   amount; 4     u_int8_t    pad[RECLEN - 4 * sizeof(u_int32_t)]; };   int  main(int argc, char *argv[]) {      unsigned long seed; -     int accounts, branches, tellers, history;      int iflag, mpool, ntxns;     char *home, *endarg;       home = NULL;0     accounts = branches = history = tellers = 0;     mpool = ntxns = 0;     verbose = 0;     iflag = 0;#     seed = (unsigned long)getpid();   "     for (int i = 1; i < argc; ++i)     {   )         if (strcmp(argv[i], "-a") == 0) { (             // Number of account records2             if ((accounts = atoi(argv[++i])) <= 0)%                 invarg('a', argv[i]); 	         } .         else if (strcmp(argv[i], "-b") == 0) {'             // Number of branch records 2             if ((branches = atoi(argv[++i])) <= 0)%                 invarg('b', argv[i]); 	         } .         else if (strcmp(argv[i], "-h") == 0) {             // DB  home.             home = argv[++i]; 	         } .         else if (strcmp(argv[i], "-i") == 0) {#             // Initialize the test.              iflag = 1;	         } .         else if (strcmp(argv[i], "-m") == 0) {#             // Bytes in buffer pool /             if ((mpool = atoi(argv[++i])) <= 0) %                 invarg('m', argv[i]); 	         } .         else if (strcmp(argv[i], "-n") == 0) {%             // Number of transactions /             if ((ntxns = atoi(argv[++i])) <= 0) %                 invarg('n', argv[i]); 	         } .         else if (strcmp(argv[i], "-S") == 0) {"             // Random number seed.2             seed = strtoul(argv[++i], &endarg, 0);              if (*endarg != '\0')%                 invarg('S', argv[i]); 	         } .         else if (strcmp(argv[i], "-s") == 0) {(             // Number of history records1             if ((history = atoi(argv[++i])) <= 0) %                 invarg('s', argv[i]); 	         } .         else if (strcmp(argv[i], "-t") == 0) {'             // Number of teller records 1             if ((tellers = atoi(argv[++i])) <= 0) %                 invarg('t', argv[i]); 	         } .         else if (strcmp(argv[i], "-v") == 0) {             // Verbose option.             verbose = 1;	         }          else	         {              usage();	         }      }        srand((unsigned int)seed);  3     accounts = accounts == 0 ? ACCOUNTS : accounts; 3     branches = branches == 0 ? BRANCHES : branches; /     tellers = tellers == 0 ? TELLERS : tellers; /     history = history == 0 ? HISTORY : history;        if (verbose).         cout << (long)accounts << " Accounts ".              << (long)branches << " Branches ",              << (long)tellers << " Tellers ".              << (long)history << " History\n";  2     // Declaring and setting options does not need2     // to be done in a try block, as it will never     // raise an exception.     //     TpcbExample app;0     u_int32_t flags = DB_CREATE | DB_INIT_MPOOL;        app.set_error_stream(&cerr);"     app.set_errpfx("TpcbExample");       if (mpool == 0) {           mpool = 4 * 1024 * 1024;     }      app.set_mp_size(mpool);        if (!iflag) { :         flags |= DB_INIT_TXN | DB_INIT_LOCK | DB_INIT_LOG;     }   	     try { /         // Initialize the database environment. 9         // Must be done in within a try block, unless you 1         // change the error model in the options. 
         //'         app.appinit(home, NULL, flags);   "         if (iflag && ntxns != 0) {6             cerr << "specify only one of -i and -n\n";             exit(1);	         }          if (iflag)?             app.populate(accounts, branches, history, tellers);          if (ntxns != 0) 8             app.run(ntxns, accounts, branches, tellers);           return 0;      }      catch (DbException &dbe)     { 6         cerr << "TpcbExample: " << dbe.what() << "\n";         return 1;      }  }    void invarg(int arg, char *str) { 1     cerr << "TpcbExample: invalid argument for -" -          << (char)arg << ": " << str << "\n";      exit(1); }    static void  usage()  { !     cerr << "usage: TpcbExample " J          << "[-iv] [-a accounts] [-b branches] [-h home] [-m mpool_size] "H          << "[-n transactions ] [-S seed] [-s history] [-t tellers] \n";     exit(1); }    //I // Initialize the database to the specified number of accounts, branches,   // history records, and tellers. //< // Note: num_h was unused in the original ex_tpcb.c example. // voidA TpcbExample::populate(int num_a, int num_b, int num_h, int num_t)  {      Db *dbp;       int err;     u_int32_t balance, idnum; +     u_int32_t end_anum, end_bnum, end_tnum; 1     u_int32_t start_anum, start_bnum, start_tnum;      u_int32_t h_nelem;       idnum = BEGID;     balance = 500000;        DbInfo dbi;   "     h_nelem = (unsigned int)num_a;     dbi.set_h_nelem(h_nelem);   "     if ((err = Db::open("account",K          DB_HASH, DB_CREATE | DB_TRUNCATE, 0644, this, &dbi, &dbp)) != 0) {e4         errExit(err, "Open of account file failed");     }p       start_anum = idnum;S;     populateTable(dbp, idnum, balance, h_nelem, "account");p     idnum += h_nelem;)     end_anum = idnum - 1;"%     if ((err = dbp->close(0)) != 0) {S2         errExit(err, "Account file close failed");     }o     if (verbose)&         cout << "Populated accounts: "D              << (long)start_anum << " - " << (long)end_anum << "\n";       //F     // Since the number of branches is very small, we want to use veryG     // small pages and only 1 key per page.  This is the poor-man's way 6     // of getting key locking instead of page locking.     //"     h_nelem = (unsigned int)num_b;     dbi.set_h_nelem(h_nelem);d     dbi.set_h_ffactor(1);)     dbi.set_pagesize(512);  !     if ((err = Db::open("branch","E 	  DB_HASH, DB_CREATE | DB_TRUNCATE, 0644, this, &dbi, &dbp)) != 0) {I2         errExit(err, "Branch file create failed");     }      start_bnum = idnum;g:     populateTable(dbp, idnum, balance, h_nelem, "branch");     idnum += h_nelem;      end_bnum = idnum - 1;r%     if ((err = dbp->close(0)) != 0) { 4         errExit(err, "Close of branch file failed");     }        if (verbose)&         cout << "Populated branches: "D              << (long)start_bnum << " - " << (long)end_bnum << "\n";       //F     // In the case of tellers, we also want small pages, but we'll let1     // the fill factor dynamically adjust itself.E     //"     h_nelem = (unsigned int)num_t;     dbi.set_h_nelem(h_nelem);      dbi.set_h_ffactor(0);x     dbi.set_pagesize(512);  !     if ((err = Db::open("teller", K          DB_HASH, DB_CREATE | DB_TRUNCATE, 0644, this, &dbi, &dbp)) != 0) { 2         errExit(err, "Teller file create failed");     }p       start_tnum = idnum; :     populateTable(dbp, idnum, balance, h_nelem, "teller");     idnum += h_nelem;      end_tnum = idnum - 1;/%     if ((err = dbp->close(0)) != 0) {e4         errExit(err, "Close of teller file failed");     }      if (verbose)%         cout << "Populated tellers: "cD              << (long)start_tnum << " - " << (long)end_tnum << "\n";        // start with a fresh DbInfo     //     DbInfo histDbi;x  $     histDbi.set_re_len(HISTORY_LEN);1     histDbi.set_flags(DB_FIXEDLEN | DB_RENUMBER);hK     if ((err = Db::open("history", DB_RECNO, DB_CREATE | DB_TRUNCATE, 0644,/'          this, &histDbi, &dbp)) != 0) {o6         errExit(err, "Create of history file failed");     }   5     populateHistory(dbp, num_h, num_a, num_b, num_t);t%     if ((err = dbp->close(0)) != 0) {a5         errExit(err, "Close of history file failed");      }e }n   void# TpcbExample::populateTable(Db *dbp,uA                            u_int32_t start_id, u_int32_t balance,d9                            unsigned int nrecs, char *msg)L {      Defrec drec;.     memset(&drec.pad[0], 1, sizeof(drec.pad));  *     Dbt kdbt(&drec.id, sizeof(u_int32_t));"     Dbt ddbt(&drec, sizeof(drec));  .     for (unsigned int i = 0; i < nrecs; i++) {*         drec.id = start_id + (u_int32_t)i;         drec.balance = balance;-         int err;         if ((err =B              dbp->put(NULL, &kdbt, &ddbt, DB_NOOVERWRITE)) != 0) {?             cerr << "Failure initializing " << msg << " file: " *                  << strerror(err) << "\n";             exit(1);	         }[     }  }    void9 TpcbExample::populateHistory(Db *dbp, unsigned int nrecs, L                              u_int32_t anum, u_int32_t bnum, u_int32_t tnum) {      Histrec hrec; .     memset(&hrec.pad[0], 1, sizeof(hrec.pad));     hrec.amount = 10;        u_int32_t i;$     Dbt kdbt(&i, sizeof(u_int32_t));"     Dbt ddbt(&hrec, sizeof(hrec));  "     for (i = 1; i <= nrecs; i++) {8         hrec.aid = random_id(ACCOUNT, anum, bnum, tnum);7         hrec.bid = random_id(BRANCH, anum, bnum, tnum); 7         hrec.tid = random_id(TELLER, anum, bnum, tnum);s           int err;C         if ((err = dbp->put(NULL, &kdbt, &ddbt, DB_APPEND)) != 0) {b>             errExit(err, "Failure initializing history file"); 	}     }  }   	 u_int32_t & random_int(u_int32_t lo, u_int32_t hi) {      u_int32_t ret;
     int t;       t = rand(); >     ret = (u_int32_t)(((double)t / ((double)(RAND_MAX) + 1)) *%                       (hi - lo + 1));      ret += lo;     return (ret);  }   	 u_int32_tmP random_id(FTYPE type, u_int32_t accounts, u_int32_t branches, u_int32_t tellers) {l     u_int32_t min, max, num;       max = min = BEGID;     num = accounts;      switch(type) {     case TELLER:         min += branches;         num = tellers;         // Fallthrough     case BRANCH:         if (type == BRANCH)a             num = branches;          min += accounts;         // Fallthrough     case ACCOUNT:o         max = min + num - 1;     }r"     return (random_int(min, max)); }    void@ TpcbExample::run(int n, int accounts, int branches, int tellers) {      Db *adb, *bdb, *hdb, *tdb;     double gtps, itps;-     int failed, ifailed, ret, txns, gus, ius;(0     struct timeval starttime, curtime, lasttime;       //     // Open the database files.      //     int err;M     if ((err = Db::open("account", DB_UNKNOWN, 0, 0, this, NULL, &adb)) != 0)t4         errExit(err, "Open of account file failed");  L     if ((err = Db::open("branch", DB_UNKNOWN, 0, 0, this, NULL, &bdb)) != 0)3         errExit(err, "Open of branch file failed");   L     if ((err = Db::open("teller", DB_UNKNOWN, 0, 0, this, NULL, &tdb)) != 0)3         errExit(err, "Open of teller file failed");=  M     if ((err = Db::open("history", DB_UNKNOWN, 0, 0, this, NULL, &hdb)) != 0) 4         errExit(err, "Open of history file failed");        txns = failed = ifailed = 0;)     (void)gettimeofday(&starttime, NULL);      lasttime = starttime;s     while (n-- >= 0) {         txns++;r)         DbTxnMgr *txnmgr = get_tx_info();nK         ret = txn(txnmgr, adb, bdb, tdb, hdb, accounts, branches, tellers);          if (ret != 0) {g             failed++;              ifailed++;	         }s         if (n % 1000 == 0) {/             (void)gettimeofday(&curtime, NULL);_8             gus = curtime.tv_usec >= starttime.tv_usec ?5                 curtime.tv_usec - starttime.tv_usec +;?                 1000000 * (curtime.tv_sec - starttime.tv_sec) : ?                 1000000 + curtime.tv_usec - starttime.tv_usec +lB                 1000000 * (curtime.tv_sec - starttime.tv_sec - 1);7             ius = curtime.tv_usec >= lasttime.tv_usec ? 4                 curtime.tv_usec - lasttime.tv_usec +>                 1000000 * (curtime.tv_sec - lasttime.tv_sec) :>                 1000000 + curtime.tv_usec - lasttime.tv_usec +A                 1000000 * (curtime.tv_sec - lasttime.tv_sec - 1);n,             gtps = (double)(txns - failed) /(                 ((double)gus / 1000000);-             itps = (double)(1000 - ifailed) /f(                 ((double)ius / 1000000);7             printf("%d txns %d failed ", txns, failed); >             printf("%6.2f TPS (gross) %6.2f TPS (interval)\n",                    gtps, itps);              lasttime = curtime;              ifailed = 0;	         }      }r       (void)adb->close(0);     (void)bdb->close(0);     (void)tdb->close(0);     (void)hdb->close(0);  0     cout << (long)txns << " transactions begun "(          << (long)failed << " failed\n"; }u   //6 // XXX Figure out the appropriate way to pick out IDs. // intc! TpcbExample::txn(DbTxnMgr *txmgr,t4                  Db *adb, Db *bdb, Db *tdb, Db *hdb,.                  int anum, int bnum, int tnum) {n     Dbc *acurs = NULL;     Dbc *bcurs = NULL;     Dbc *hcurs = NULL;     Dbc *tcurs = NULL;     DbTxn *t = NULL;       Defrec rec;t     Histrec hrec;m      int account, branch, teller;       Dbt d_dbt;     Dbt d_histdbt;     Dbt k_dbt;     Dbt k_histdbt;       //C     // XXX We could move a lot of this into the driver to make thism     // faster.     //3     account = random_id(ACCOUNT, anum, bnum, tnum); 1     branch = random_id(BRANCH, anum, bnum, tnum);;1     teller = random_id(TELLER, anum, bnum, tnum);D        k_dbt.set_size(sizeof(int));  $     d_dbt.set_flags(DB_DBT_USERMEM);     d_dbt.set_data(&rec);       d_dbt.set_ulen(sizeof(rec));       hrec.aid = account;      hrec.bid = branch;     hrec.tid = teller;     hrec.amount = 10;a4     // Request 0 bytes since we're just positioning.(     d_histdbt.set_flags(DB_DBT_PARTIAL);       // START TIMING($     if (txmgr->begin(NULL, &t) != 0)         goto err;s  )     if (adb->cursor(t, &acurs, 0) != 0 || )         bdb->cursor(t, &bcurs, 0) != 0 ||()         tdb->cursor(t, &tcurs, 0) != 0 ||n'         hdb->cursor(t, &hcurs, 0) != 0)w         goto err;        // Account recordl     k_dbt.set_data(&account);p0     if (acurs->get(&k_dbt, &d_dbt, DB_SET) != 0)         goto err;.     rec.balance += 10;4     if (acurs->put(&k_dbt, &d_dbt, DB_CURRENT) != 0)         goto err;o       // Branch record     k_dbt.set_data(&branch);0     if (bcurs->get(&k_dbt, &d_dbt, DB_SET) != 0)         goto err;&     rec.balance += 10;4     if (bcurs->put(&k_dbt, &d_dbt, DB_CURRENT) != 0)         goto err;=       // Teller record     k_dbt.set_data(&teller);0     if (tcurs->get(&k_dbt, &d_dbt, DB_SET) != 0)         goto err;      rec.balance += 10;4     if (tcurs->put(&k_dbt, &d_dbt, DB_CURRENT) != 0)         goto err;        // History record 9     if (hcurs->get(&k_histdbt, &d_histdbt, DB_LAST) != 0)t         goto err;<     d_histdbt.set_flags(0);      d_histdbt.set_data(&hrec);%     d_histdbt.set_ulen(sizeof(hrec));l:     if (hcurs->put(&k_histdbt, &d_histdbt, DB_AFTER) != 0)         goto err;   5     if (acurs->close() != 0 || bcurs->close() != 0 || 3         tcurs->close() != 0 || hcurs->close() != 0)          goto err;o       if (t->commit() != 0)A         goto err;T       // END TIMING&     return (0);      err:     if (acurs != NULL)         (void)acurs->close();      if (bcurs != NULL)         (void)bcurs->close();      if (tcurs != NULL)         (void)tcurs->close();      if (hcurs != NULL)         (void)hcurs->close();      if (t != NULL)         (void)t->abort();        if (verbose)1         cout << "Transaction A=" << (long)accountl%              << " B=" << (long)branchn5              << " T=" << (long)teller << " failed\n";w     return (-1); }   $ void errExit(int err, const char *s) {e     cerr << progname << ": ";t     if (s != NULL) {         cerr << s << ": ";     }="     cerr << strerror(err) << "\n";     exit(1); }E0644,/'          this, &histDbi, &dbp)) != 0) {o6         errExit(err, "Create of history file failed");     }   5     populateHistory(dbp, num_h, num_a, num_b, num_t);t%     if ((err = d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                