 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */  /*!  * Copyright (c) 1990, 1993, 1994 '  *	Margo Seltzer.  All rights reserved.   */  /*!  * Copyright (c) 1990, 1993, 1994 E  *	The Regents of the University of California.  All rights reserved.   *@  * This code is derived from software contributed to Berkeley by  * Margo Seltzer.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   */    #include "config.h"    #ifndef lintE static const char sccsid[] = "@(#)hash.c	10.63 (Sleepycat) 12/11/98";  #endif /* not lint */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <stdlib.h>  #include <string.h>  #endif   #include "db_int.h"  #include "shqueue.h" #include "db_page.h" #include "db_am.h" #include "db_ext.h"  #include "hash.h"  #include "btree.h" #include "log.h" #include "db_shash.h"  #include "lock.h"  #include "lock_ext.h"   ' static int  __ham_c_close __P((DBC *)); 0 static int  __ham_c_del __P((DBC *, u_int32_t));) static int  __ham_c_destroy __P((DBC *)); > static int  __ham_c_get __P((DBC *, DBT *, DBT *, u_int32_t));> static int  __ham_c_put __P((DBC *, DBT *, DBT *, u_int32_t));A static int  __ham_delete __P((DB *, DB_TXN *, DBT *, u_int32_t)); < static int  __ham_dup_return __P((DBC *, DBT *, u_int32_t));, static int  __ham_expand_table __P((DBC *));? static void __ham_init_htab __P((DBC *, u_int32_t, u_int32_t)); M static int  __ham_lookup __P((DBC *, const DBT *, u_int32_t, db_lockmode_t)); 0 static int  __ham_overwrite __P((DBC *, DBT *));  K /************************** INTERFACE ROUTINES ***************************/  /* OPEN/CLOSE */   /*  * __ham_open --  *1  * PUBLIC: int __ham_open __P((DB *, DB_INFO *));   */  int  __ham_open(dbp, dbinfo) 	 	DB *dbp;  	DB_INFO *dbinfo;  {  	DB_ENV *dbenv; 
 	DBC *dbc; 	HASH_CURSOR *hcp; 	int file_existed, ret;    	dbc = NULL; 	dbenv = dbp->dbenv;  6 	/* Set the hash function if specified by the user. */. 	if (dbinfo != NULL && dbinfo->h_hash != NULL) 		dbp->h_hash = dbinfo->h_hash;    	/* B 	 * Initialize the remaining fields of the dbp.  The only function6 	 * that differs from the default set is __ham_stat(). 	 */ 	dbp->internal = NULL; 	dbp->am_close = __ham_close;  	dbp->del = __ham_delete;  	dbp->stat = __ham_stat;  = 	/* Get a cursor we can use for the rest of this function. */ 2 	if ((ret = dbp->cursor(dbp, NULL, &dbc, 0)) != 0) 		goto out;   $ 	hcp = (HASH_CURSOR *)dbc->internal; 	GET_META(dbp, hcp, ret);  	if (ret != 0) 		goto out;    	/* @ 	 * If this is a new file, initialize it, and put it back dirty. 	 */  # 	/* Initialize the hdr structure */ ' 	if (hcp->hdr->magic == DB_HASHMAGIC) {  		file_existed = 1; 3 		/* File exists, verify the data in the header. */  		if (dbp->h_hash == NULL) 			dbp->h_hash =9 			    hcp->hdr->version < 5 ? __ham_func4 : __ham_func5; . 		if (dbp->h_hash(CHARKEY, sizeof(CHARKEY)) != 		    hcp->hdr->h_charkey) {< 			__db_err(dbp->dbenv, "hash: incompatible hash function"); 			ret = EINVAL; 			goto out; 		} % 		if (F_ISSET(hcp->hdr, DB_HASH_DUP))  			F_SET(dbp, DB_AM_DUP); 	 	} else {  		/*< 		 * File does not exist, we must initialize the header.  If> 		 * locking is enabled that means getting a write lock first. 		 */  		file_existed = 0; $ 		if (F_ISSET(dbp, DB_AM_LOCKING) &&; 		    ((ret = lock_put(dbenv->lk_info, hcp->hlock)) != 0 || 5 		    (ret = lock_get(dbenv->lk_info, dbc->locker, 0, ? 		        &dbc->lock_dbt, DB_LOCK_WRITE, &hcp->hlock)) != 0)) {  			if (ret < 0)  				ret = EAGAIN;  			goto out; 		}   < 		__ham_init_htab(dbc, dbinfo != NULL ? dbinfo->h_nelem : 0,. 		    dbinfo != NULL ? dbinfo->h_ffactor : 0); 		if (F_ISSET(dbp, DB_AM_DUP))  			F_SET(hcp->hdr, DB_HASH_DUP);; 		if ((ret = __ham_dirty_page(dbp, (PAGE *)hcp->hdr)) != 0)  			goto out; 	}  ! 	/* Release the meta data page */  	RELEASE_META(dbp, hcp);% 	if ((ret  = dbc->c_close(dbc)) != 0)  		goto out;   E 	/* Sync the file so that we know that the meta data goes to disk. */ 5 	if (!file_existed && (ret = dbp->sync(dbp, 0)) != 0)  		goto out;  	return (0);   out:	(void)__ham_close(dbp); 	return (ret); }    /*'  * PUBLIC: int __ham_close __P((DB *));   */  int  __ham_close(dbp)	 	DB *dbp;  {  	COMPQUIET(dbp, NULL); 	return (0); }   K /************************** LOCAL CREATION ROUTINES **********************/  /*  * Returns 0 on No Error  */  static void $ __ham_init_htab(dbc, nelem, ffactor)
 	DBC *dbc; 	u_int32_t nelem, ffactor; { 	 	DB *dbp;  	HASH_CURSOR *hcp; 	int32_t l2, nbuckets;  $ 	hcp = (HASH_CURSOR *)dbc->internal; 	dbp = dbc->dbp;& 	memset(hcp->hdr, 0, sizeof(HASHHDR)); 	hcp->hdr->ffactor = ffactor; " 	hcp->hdr->pagesize = dbp->pgsize; 	ZERO_LSN(hcp->hdr->lsn);   	hcp->hdr->magic = DB_HASHMAGIC;$ 	hcp->hdr->version = DB_HASHVERSION;   	if (dbp->h_hash == NULL) B 		dbp->h_hash = hcp->hdr->version < 5 ? __ham_func4 : __ham_func5;= 	hcp->hdr->h_charkey = dbp->h_hash(CHARKEY, sizeof(CHARKEY)); , 	if (nelem != 0 && hcp->hdr->ffactor != 0) {. 		nelem = (nelem - 1) / hcp->hdr->ffactor + 1;( 		l2 = __db_log2(nelem > 2 ? nelem : 2); 	} else 	 		l2 = 2;    	nbuckets = 1 << l2;   	hcp->hdr->ovfl_point = l2; % 	hcp->hdr->last_freed = PGNO_INVALID;   ; 	hcp->hdr->max_bucket = hcp->hdr->high_mask = nbuckets - 1; * 	hcp->hdr->low_mask = (nbuckets >> 1) - 1;4 	memcpy(hcp->hdr->uid, dbp->fileid, DB_FILE_ID_LEN); }   
 static int" __ham_delete(dbp, txn, key, flags)	 	DB *dbp; 
 	DB_TXN *txn; 
 	DBT *key; 	u_int32_t flags;  { 
 	DBC *dbc; 	HASH_CURSOR *hcp; 	int ret, tret;    	DB_PANIC_CHECK(dbp);    	if ((ret = D 	    __db_delchk(dbp, key, flags, F_ISSET(dbp, DB_AM_RDONLY))) != 0) 		return (ret);   < 	if ((ret = dbp->cursor(dbp, txn, &dbc, DB_WRITELOCK)) != 0) 		return (ret);   8 	DEBUG_LWRITE(dbc, txn, "ham_delete", key, NULL, flags);  $ 	hcp = (HASH_CURSOR *)dbc->internal; 	GET_META(dbp, hcp, ret);  	if (ret != 0) 		goto out;    	hcp->stats.hash_deleted++; ; 	if ((ret = __ham_lookup(dbc, key, 0, DB_LOCK_WRITE)) == 0)  		if (F_ISSET(hcp, H_OK))   			ret = __ham_del_pair(dbc, 1); 		else 			ret = DB_NOTFOUND;    	RELEASE_META(dbp, hcp);5 out:	if ((tret = dbc->c_close(dbc)) != 0 && ret == 0) 
 		ret = tret;  	return (ret); }   C /* ****************** CURSORS ********************************** */  /*  * __ham_c_init --4  *	Initialize the hash-specific portion of a cursor.  *)  * PUBLIC: int __ham_c_init __P((DBC *));C  */g int) __ham_c_init(dbc) 
 	DBC *dbc;   {w 	HASH_CURSOR *new_curs;.	 	int ret;   E 	if ((ret = __os_calloc(1, sizeof(struct cursor_t), &new_curs)) != 0)d 		return (ret);C 	if ((ret =1G 	    __os_malloc(dbc->dbp->pgsize, NULL, &new_curs->split_buf)) != 0) {g) 		__os_free(new_curs, sizeof(*new_curs));  		return (ret);t 	}   	new_curs->dbc = dbc;r   	dbc->internal = new_curs;! 	dbc->c_am_close = __ham_c_close;f% 	dbc->c_am_destroy = __ham_c_destroy;, 	dbc->c_del = __ham_c_del; 	dbc->c_get = __ham_c_get; 	dbc->c_put = __ham_c_put;   	__ham_item_init(new_curs);a   	return (0); }g   /*  * __ham_c_close -- +  *	Close down the cursor from a single use.   */ 
 static int __ham_c_close(dbc)
 	DBC *dbc; {h	 	int ret;y  * 	if ((ret = __ham_item_done(dbc, 0)) != 0) 		return (ret);   / 	__ham_item_init((HASH_CURSOR *)dbc->internal);r 	return (0); }e   /*  * __ham_c_destroy --36  *	Cleanup the access method private part of a cursor.  */s
 static int __ham_c_destroy(dbc)
 	DBC *dbc; {o 	HASH_CURSOR *hcp;  $ 	hcp = (HASH_CURSOR *)dbc->internal; 	if (hcp->split_buf != NULL). 		__os_free(hcp->split_buf, dbc->dbp->pgsize);% 	__os_free(hcp, sizeof(HASH_CURSOR));n   	return (0); }u  
 static int __ham_c_del(dbc, flags)r
 	DBC *dbc; 	u_int32_t flags;s {f	 	DB *dbp; 
 	DBT repldbt;f 	HASH_CURSOR *hcp; 	HASH_CURSOR save_curs;T 	db_pgno_t ppgno, chg_pgno;T 	int ret, t_ret;  = 	DEBUG_LWRITE(dbc, dbc->txn, "ham_c_del", NULL, NULL, flags);B 	dbp = dbc->dbp; 	DB_PANIC_CHECK(dbp);T$ 	hcp = (HASH_CURSOR *)dbc->internal;  ) 	if ((ret = __db_cdelchk(dbc->dbp, flags,N; 	    F_ISSET(dbc->dbp, DB_AM_RDONLY), IS_VALID(hcp))) != 0)R 		return (ret);R   	if (F_ISSET(hcp, H_DELETED))R 		return (DB_NOTFOUND);D   	/*(: 	 * If we are in the concurrent DB product and this cursor8 	 * is not a write cursor, then this request is invalid.? 	 * If it is a simple write cursor, then we need to upgrade itsI	 	 * lock.  	 */ 	if (F_ISSET(dbp, DB_AM_CDB)) {T- 		/* Make sure it's a valid update cursor. */ * 		if (!F_ISSET(dbc, DBC_RMW | DBC_WRITER)) 			return (EINVAL);F   		if (F_ISSET(dbc, DBC_RMW) &&7 		    (ret = lock_get(dbp->dbenv->lk_info, dbc->locker,c5 		    DB_LOCK_UPGRADE, &dbc->lock_dbt, DB_LOCK_WRITE,/ 		    &dbc->mylock)) != 0) 			return (EAGAIN);S 	}   	GET_META(dbp, hcp, ret);. 	if (ret != 0) 		return (ret);e   	SAVE_CURSOR(hcp, &save_curs); 	hcp->stats.hash_deleted++;h  6 	if ((ret = __ham_get_cpage(dbc, DB_LOCK_WRITE)) != 0) 		goto out;c; 	if (F_ISSET(hcp, H_ISDUP) && hcp->dpgno != PGNO_INVALID) {c 		/*5 		 * We are about to remove a duplicate from offpage.c 		 * 		 * There are 4 cases.t< 		 * 1. We will remove an item on a page, but there are more 		 *    items on that page.t> 		 * 2. We will remove the last item on a page, but there is a% 		 *    following page of duplicates.cA 		 * 3. We will remove the last item on a page, this page was thet@ 		 *    last page in a duplicate set, but there were dups before 		 *    it._A 		 * 4. We will remove the last item on a page, removing the lastb 		 *    duplicate.( 		 * In case 1 hcp->dpagep is unchanged.> 		 * In case 2 hcp->dpagep comes back pointing to the next dup 		 *     page.+ 		 * In case 3 hcp->dpagep comes back NULL.r+ 		 * In case 4 hcp->dpagep comes back NULL.* 		 *= 		 * Case 4 results in deleting the pair off the master page.L; 		 * The normal code for doing this knows how to delete the @ 		 * duplicates, so we will handle this case in the normal code. 		 */ ! 		ppgno = PREV_PGNO(hcp->dpagep);d 		if (ppgno == PGNO_INVALID &&/ 		    NEXT_PGNO(hcp->dpagep) == PGNO_INVALID &&   		    NUM_ENT(hcp->dpagep) == 1) 			goto normal;f  ( 		/* Remove item from duplicate page. */ 		chg_pgno = hcp->dpgno; 		if ((ret = __db_drem(dbc,>5 		    &hcp->dpagep, hcp->dndx, __ham_del_page)) != 0)f 			goto out;   		if (hcp->dpagep == NULL) {- 			if (ppgno != PGNO_INVALID) {		/* Case 3 */d 				hcp->dpgno = ppgno;p# 				if ((ret = __ham_get_cpage(dbc,  				    DB_LOCK_READ)) != 0) 					goto out;% 				hcp->dndx = NUM_ENT(hcp->dpagep);t 				F_SET(hcp, H_DELETED); 			} else {				/* Case 4 */,! 				ret = __ham_del_pair(dbc, 1);h 				hcp->dpgno = PGNO_INVALID; 				/*. 				 * Delpair updated the cursor queue, so we" 				 * don't have to do that here. 				 */i 				chg_pgno = PGNO_INVALID; 			}/ 		} else if (PGNO(hcp->dpagep) != hcp->dpgno) {h! 			hcp->dndx = 0;				/* Case 2 */ " 			hcp->dpgno = PGNO(hcp->dpagep); 			if (ppgno == PGNO_INVALID)e+ 				memcpy(HOFFDUP_PGNO(P_ENTRY(hcp->pagep,_! 				    H_DATAINDEX(hcp->bndx))),5( 				    &hcp->dpgno, sizeof(db_pgno_t)); 			/*(2 			 * We need to put the master page here, because3 			 * although we have a duplicate page, the mastera3 			 * page is dirty, and ham_item_done assumes that 5 			 * if you have a duplicate page, it's the only oneB 			 * that can be dirty. 			 */, 			ret = __ham_put_page(dbp, hcp->pagep, 1); 			hcp->pagep = NULL;g 			F_SET(hcp, H_DELETED);i 		} else						/* Case 1 */ 			F_SET(hcp, H_DELETED);	 		if (chg_pgno != PGNO_INVALID)&* 			__ham_c_update(hcp, chg_pgno, 0, 0, 1);4 	} else if (F_ISSET(hcp, H_ISDUP)) {			/* on page */4 		if (hcp->dup_off == 0 && DUP_SIZE(hcp->dup_len) ==; 		    LEN_HDATA(hcp->pagep, hcp->hdr->pagesize, hcp->bndx))   			ret = __ham_del_pair(dbc, 1); 		else { 			repldbt.flags = 0;L# 			F_SET(&repldbt, DB_DBT_PARTIAL);o 			repldbt.doff = hcp->dup_off;;) 			repldbt.dlen = DUP_SIZE(hcp->dup_len);h 			repldbt.size = 0; 			repldbt.data =m8 			    HKEYDATA_DATA(H_PAIRDATA(hcp->pagep, hcp->bndx));* 			ret = __ham_replpair(dbc, &repldbt, 0);+ 			hcp->dup_tlen -= DUP_SIZE(hcp->dup_len);l 			F_SET(hcp, H_DELETED);t! 			__ham_c_update(hcp, hcp->pgno,k% 			    DUP_SIZE(hcp->dup_len), 0, 1);  		}    	} elset 		/* Not a duplicate */p& normal:		ret = __ham_del_pair(dbc, 1);  C out:	if ((t_ret = __ham_item_done(dbc, ret == 0)) != 0 && ret == 0)i 		ret = t_ret; 	RELEASE_META(dbp, hcp);+ 	RESTORE_CURSOR(dbp, hcp, &save_curs, ret);d6 	if (F_ISSET(dbp, DB_AM_CDB) && F_ISSET(dbc, DBC_RMW)): 		(void)__lock_downgrade(dbp->dbenv->lk_info, dbc->mylock, 		    DB_LOCK_IWRITE, 0);  	return (ret); }a  
 static int" __ham_c_get(dbc, key, data, flags)
 	DBC *dbc;
 	DBT *key; 	DBT *data;  	u_int32_t flags;; {i	 	DB *dbp;n 	HASH_CURSOR *hcp, save_curs;  	db_lockmode_t lock_type;c 	int get_key, ret, t_ret;,  ( 	DEBUG_LREAD(dbc, dbc->txn, "ham_c_get",; 	    flags == DB_SET || flags == DB_SET_RANGE ? key : NULL,r 	    NULL, flags);  $ 	hcp = (HASH_CURSOR *)dbc->internal; 	dbp = dbc->dbp; 	DB_PANIC_CHECK(dbp);= 	SAVE_CURSOR(hcp, &save_curs); 	if ((ret = > 	    __db_cgetchk(dbp, key, data, flags, IS_VALID(hcp))) != 0) 		return (ret);f  G 	/* Clear OR'd in additional bits so we can check for flag equality. */m 	if (LF_ISSET(DB_RMW)) { 		lock_type = DB_LOCK_WRITE; 		LF_CLR(DB_RMW);} 	} else	 		lock_type = DB_LOCK_READ;l   	GET_META(dbp, hcp, ret);  	if (ret != 0) 		return (ret);O 	hcp->stats.hash_get++;m 	hcp->seek_size = 0;  	 	ret = 0;b
 	get_key = 1;h 	switch (flags) {  	case DB_PREV:& 		if (hcp->bucket != BUCKET_INVALID) {) 			ret = __ham_item_prev(dbc, lock_type);_	 			break;  		}k 		/* FALLTHROUGH */  	case DB_LAST:( 		ret = __ham_item_last(dbc, lock_type); 		break; 	case DB_FIRST: ) 		ret = __ham_item_first(dbc, lock_type);  		break; 	case DB_NEXT_DUP:$ 		if (hcp->bucket == BUCKET_INVALID) 			ret = EINVAL; 		else { 			F_SET(hcp, H_DUPONLY);c) 			ret = __ham_item_next(dbc, lock_type);  		}u 		break; 	case DB_NEXT:$ 		if (hcp->bucket == BUCKET_INVALID) 			hcp->bucket = 0;H( 		ret = __ham_item_next(dbc, lock_type); 		break;
 	case DB_SET:) 	case DB_SET_RANGE:p 	case DB_GET_BOTH:# 		if (F_ISSET(dbc, DBC_CONTINUE)) {e 			F_SET(hcp, H_DUPONLY); ) 			ret = __ham_item_next(dbc, lock_type);m& 		} else if (F_ISSET(dbc, DBC_KEYSET))$ 			ret = __ham_item(dbc, lock_type); 		else. 			ret = __ham_lookup(dbc, key, 0, lock_type); 		get_key = 0; 		break; 	case DB_CURRENT:*  		if (F_ISSET(hcp, H_DELETED)) { 			ret = DB_KEYEMPTY;* 			goto out; 		}c  # 		ret = __ham_item(dbc, lock_type);i 		break; 	}   	/*.8 	 * Must always enter this loop to do error handling and  	 * check for big key/data pair. 	 */ 	while (1) {% 		if (ret != 0 && ret != DB_NOTFOUND) 
 			goto out1;s  		else if (F_ISSET(hcp, H_OK)) { 			/* Get the key. */)2 			if (get_key && (ret = __db_ret(dbp, hcp->pagep,3 			    H_KEYINDEX(hcp->bndx), key, &dbc->rkey.data,e 			    &dbc->rkey.size)) != 0) 				goto out1;  , 			ret = __ham_dup_return(dbc, data, flags);	 			break; ' 		} else if (!F_ISSET(hcp, H_NOMORE)) {> 			abort();=	 			break;s 		},   		/*4 		 * Ran out of entries in a bucket; change buckets. 		 */  		switch (flags) { 			case DB_LAST: 			case DB_PREV:" 				ret = __ham_item_done(dbc, 0); 				if (hcp->bucket == 0) {f 					ret = DB_NOTFOUND;  					goto out1;_ 				}( 				hcp->bucket--; 				hcp->bndx = NDX_INVALID; 				if (ret == 0)0+ 					ret = __ham_item_prev(dbc, lock_type);t
 				break; 			case DB_FIRST:r 			case DB_NEXT:" 				ret = __ham_item_done(dbc, 0); 				hcp->bndx = NDX_INVALID; 				hcp->bucket++; 				hcp->pgno = PGNO_INVALID;t 				hcp->pagep = NULL;- 				if (hcp->bucket > hcp->hdr->max_bucket) {b 					ret = DB_NOTFOUND;p 					goto out1;  				}f 				if (ret == 0) + 					ret = __ham_item_next(dbc, lock_type);S
 				break; 			case DB_GET_BOTH: 			case DB_NEXT_DUP: 			case DB_SET:  			case DB_SET_RANGE:f 				/* Key not found. */ 				ret = DB_NOTFOUND; 				goto out1; 		}R 	}= out1:	if ((t_ret = __ham_item_done(dbc, 0)) != 0 && ret == 0)B 		ret = t_ret; out:	RELEASE_META(dbp, hcp);+ 	RESTORE_CURSOR(dbp, hcp, &save_curs, ret);C 	return (ret); }A  
 static int" __ham_c_put(dbc, key, data, flags)
 	DBC *dbc;
 	DBT *key; 	DBT *data;d 	u_int32_t flags;L { 	 	DB *dbp;p 	DBT tmp_val, *myval;e 	HASH_CURSOR *hcp, save_curs;E 	u_int32_t nbytes; 	int ret, t_ret;   	dbp = dbc->dbp; 	DB_PANIC_CHECK(dbp);u) 	DEBUG_LWRITE(dbc, dbc->txn, "ham_c_put",o> 	    flags == DB_KEYFIRST || flags == DB_KEYLAST ? key : NULL, 	    data, flags);$ 	hcp = (HASH_CURSOR *)dbc->internal;  / 	if ((ret = __db_cputchk(dbp, key, data, flags, 6 	    F_ISSET(dbp, DB_AM_RDONLY), IS_VALID(hcp))) != 0) 		return (ret);r   	if (F_ISSET(hcp, H_DELETED) &&b1 	    flags != DB_KEYFIRST && flags != DB_KEYLAST)k 		return (DB_NOTFOUND);    	/*C: 	 * If we are in the concurrent DB product and this cursor8 	 * is not a write cursor, then this request is invalid.? 	 * If it is a simple write cursor, then we need to upgrade itss	 	 * lock.  	 */ 	if (F_ISSET(dbp, DB_AM_CDB)) {e- 		/* Make sure it's a valid update cursor. */ * 		if (!F_ISSET(dbc, DBC_RMW | DBC_WRITER)) 			return (EINVAL);V   		if (F_ISSET(dbc, DBC_RMW) &&7 		    (ret = lock_get(dbp->dbenv->lk_info, dbc->locker,e5 		    DB_LOCK_UPGRADE, &dbc->lock_dbt, DB_LOCK_WRITE,u 		    &dbc->mylock)) != 0) 			return (EAGAIN);	 	}   	GET_META(dbp, hcp, ret);m 	if (ret != 0) 		return (ret);    	SAVE_CURSOR(hcp, &save_curs); 	hcp->stats.hash_put++;e   	switch (flags) {  	case DB_KEYLAST:  	case DB_KEYFIRST:4 		nbytes = (ISBIG(hcp, key->size) ? HOFFPAGE_PSIZE :" 		    HKEYDATA_PSIZE(key->size)) +0 		    (ISBIG(hcp, data->size) ? HOFFPAGE_PSIZE :" 		    HKEYDATA_PSIZE(data->size)); 		if ((ret = __ham_lookup(dbc,4 		    key, nbytes, DB_LOCK_WRITE)) == DB_NOTFOUND) { 			ret = 0;I. 			if (hcp->seek_found_page != PGNO_INVALID &&+ 			    hcp->seek_found_page != hcp->pgno) {	- 				if ((ret = __ham_item_done(dbc, 0)) != 0)m 					goto out;% 				hcp->pgno = hcp->seek_found_page;  				hcp->bndx = NDX_INVALID; 			}  : 			if (F_ISSET(data, DB_DBT_PARTIAL) && data->doff != 0) { 				/*0 				 * A partial put, but the key does not exist/ 				 * and we are not beginning the write at 0.D3 				 * We must create a data item padded up to doffl2 				 * and then write the new bytes represented by 				 * val.> 				 */	' 				if ((ret = __ham_init_dbt(&tmp_val,p  				    data->size + data->doff,4 				    &dbc->rdata.data, &dbc->rdata.size)) == 0) {) 					memset(tmp_val.data, 0, data->doff);*& 					memcpy((u_int8_t *)tmp_val.data +- 					    data->doff, data->data, data->size);D 					myval = &tmp_val; 				}c	 			} elseU 				myval = (DBT *)data;   			if (ret == 0)3 				ret = __ham_add_el(dbc, key, myval, H_KEYDATA);_
 			goto done;  		}c 		break; 	case DB_BEFORE: 	case DB_AFTER:a 	case DB_CURRENT:o' 		ret = __ham_item(dbc, DB_LOCK_WRITE);h 		break; 	}   	if (ret == 0) {8 		if ((flags == DB_CURRENT && !F_ISSET(hcp, H_ISDUP)) ||7 		    ((flags == DB_KEYFIRST || flags == DB_KEYLAST) &&>  		    !F_ISSET(dbp, DB_AM_DUP)))$ 			ret = __ham_overwrite(dbc, data); 		else) 			ret = __ham_add_dup(dbc, data, flags);E 	}  / done:	if (ret == 0 && F_ISSET(hcp, H_EXPAND)) {)  		ret = __ham_expand_table(dbc); 		F_CLR(hcp, H_EXPAND);u 	}  ? 	if ((t_ret = __ham_item_done(dbc, ret == 0)) != 0 && ret == 0)  		ret = t_ret;   out:	RELEASE_META(dbp, hcp);+ 	RESTORE_CURSOR(dbp, hcp, &save_curs, ret);B6 	if (F_ISSET(dbp, DB_AM_CDB) && F_ISSET(dbc, DBC_RMW)): 		(void)__lock_downgrade(dbp->dbenv->lk_info, dbc->mylock, 		    DB_LOCK_IWRITE, 0);	 	return (ret); }	  F /********************************* UTILITIES ************************/   /*  * __ham_expand_table --  */ 
 static int __ham_expand_table(dbc)p
 	DBC *dbc; {c	 	DB *dbp;= 	HASH_CURSOR *hcp; 	DB_LSN new_lsn;- 	u_int32_t old_bucket, new_bucket, spare_ndx;-	 	int ret;	   	dbp = dbc->dbp;$ 	hcp = (HASH_CURSOR *)dbc->internal;	 	ret = 0;F 	DIRTY_META(dbp, hcp, ret);)	 	if (ret)d 		return (ret);p   	/* > 	 * If the split point is about to increase, make sure that we< 	 * have enough extra pages.  The calculation here is weird.? 	 * We'd like to do this after we've upped max_bucket, but it'shA 	 * too late then because we've logged the meta-data split.  WhattB 	 * we'll do between then and now is increment max bucket and thenA 	 * see what the log of one greater than that is; here we have to=2 	 * look at the log of max + 2.  VERY NASTY STUFF. 	 */B 	if (__db_log2(hcp->hdr->max_bucket + 2) > hcp->hdr->ovfl_point) { 		/*; 		 * We are about to shift the split point.  Make sure thatI9 		 * if the next doubling is going to be big (more than 8o- 		 * pages), we have some extra pages around.  		 */B& 		if (hcp->hdr->max_bucket + 1 >= 8 &&. 		    hcp->hdr->spares[hcp->hdr->ovfl_point] <2 		    hcp->hdr->spares[hcp->hdr->ovfl_point - 1] + 		    hcp->hdr->ovfl_point + 1)S 			__ham_init_ovflpages(dbc);o 	}  * 	/* Now we can log the meta-data split. */ 	if (DB_LOGGING(dbc)) { 5 		if ((ret = __ham_splitmeta_log(dbp->dbenv->lg_info,A- 		    dbc->txn, &new_lsn, 0, dbp->log_fileid,=1 		    hcp->hdr->max_bucket, hcp->hdr->ovfl_point,D- 		    hcp->hdr->spares[hcp->hdr->ovfl_point],u 		    &hcp->hdr->lsn)) != 0) 			return (ret);   		hcp->hdr->lsn = new_lsn; 	}   	hcp->stats.hash_expansions++;% 	new_bucket = ++hcp->hdr->max_bucket;o: 	old_bucket = (hcp->hdr->max_bucket & hcp->hdr->low_mask);   	/*C? 	 * If the split point is increasing, copy the current contentsD1 	 * of the spare split bucket to the next bucket.	 	 */1 	spare_ndx = __db_log2(hcp->hdr->max_bucket + 1); ( 	if (spare_ndx > hcp->hdr->ovfl_point) { 		hcp->hdr->spares[spare_ndx] =f- 		    hcp->hdr->spares[hcp->hdr->ovfl_point];h# 		hcp->hdr->ovfl_point = spare_ndx;e 	}  ( 	if (new_bucket > hcp->hdr->high_mask) { 		/* Starting a new doubling */c+ 		hcp->hdr->low_mask = hcp->hdr->high_mask; 8 		hcp->hdr->high_mask = new_bucket | hcp->hdr->low_mask; 	}  8 	if (BUCKET_TO_PAGE(hcp, new_bucket) > MAX_PAGES(hcp)) { 		__db_err(dbp->dbenv,= 		    "hash: Cannot allocate new bucket.  Pages exhausted.");  		return (ENOSPC); 	}  ) 	/* Relocate records to the new bucket */p8 	return (__ham_split_page(dbc, old_bucket, new_bucket)); }r   /*O  * PUBLIC: u_int32_t __ham_call_hash __P((HASH_CURSOR *, u_int8_t *, int32_t));C  */U	 u_int32_tF __ham_call_hash(hcp, k, len) 	HASH_CURSOR *hcp;
 	u_int8_t *k;m
 	int32_t len;F {S 	u_int32_t n, bucket;	  0 	n = (u_int32_t)(hcp->dbc->dbp->h_hash(k, len));  " 	bucket = n & hcp->hdr->high_mask;# 	if (bucket > hcp->hdr->max_bucket)C' 		bucket = bucket & hcp->hdr->low_mask;{ 	return (bucket);P }*   /*B  * Check for duplicates, and call __db_ret appropriately.  Release!  * everything held by the cursor.s  */ 
 static int! __ham_dup_return(dbc, val, flags)/
 	DBC *dbc;
 	DBT *val; 	u_int32_t flags;= {&	 	DB *dbp;_ 	HASH_CURSOR *hcp;
 	PAGE *pp; 	DBT *myval, tmp_val;K 	db_indx_t ndx;h 	db_pgno_t pgno; 	u_int32_t off, tlen;_ 	u_int8_t *hk, type; 	int cmp, ret; 	db_indx_t len;,  4 	/* Check for duplicate and return the first one. */ 	dbp = dbc->dbp;$ 	hcp = (HASH_CURSOR *)dbc->internal; 	ndx = H_DATAINDEX(hcp->bndx);$ 	type = HPAGE_TYPE(hcp->pagep, ndx); 	pp = hcp->pagep; 
 	myval = val;n   	/*  	 * There are 4 cases:3 	 * 1. We are not in duplicate, simply call db_ret.L< 	 * 2. We are looking at keys and stumbled onto a duplicate.; 	 * 3. We are in the middle of a duplicate set. (ISDUP set)tA 	 * 4. This is a duplicate and we need to return a specific item.  	 */   	/*=< 	 * Here we check for the case where we just stumbled onto a; 	 * duplicate.  In this case, we do initialization and thend, 	 * let the normal duplicate code handle it. 	 */ 	if (!F_ISSET(hcp, H_ISDUP)) 		if (type == H_DUPLICATE) { 			F_SET(hcp, H_ISDUP);e( 			hcp->dup_tlen = LEN_HDATA(hcp->pagep,& 			    hcp->hdr->pagesize, hcp->bndx);* 			hk = H_PAIRDATA(hcp->pagep, hcp->bndx);. 			if (flags == DB_LAST || flags == DB_PREV) { 				hcp->dndx = 0; 				hcp->dup_off = 0;T 				do { 					memcpy(&len,	* 					    HKEYDATA_DATA(hk) + hcp->dup_off, 					    sizeof(db_indx_t));# 					hcp->dup_off += DUP_SIZE(len);c 					hcp->dndx++;=+ 				} while (hcp->dup_off < hcp->dup_tlen);h" 				hcp->dup_off -= DUP_SIZE(len); 				hcp->dndx--; 			} else {  				memcpy(&len,. 				    HKEYDATA_DATA(hk), sizeof(db_indx_t)); 				hcp->dup_off = 0;d 				hcp->dndx = 0; 			} 			hcp->dup_len = len;  		} else if (type == H_OFFDUP) { 			F_SET(hcp, H_ISDUP);e8 			memcpy(&pgno, HOFFDUP_PGNO(P_ENTRY(hcp->pagep, ndx)), 			    sizeof(db_pgno_t));. 			if (flags == DB_LAST || flags == DB_PREV) { 				if ((ret = __db_dend(dbc,:" 				    pgno, &hcp->dpagep)) != 0) 					return (ret);# 				hcp->dpgno = PGNO(hcp->dpagep);d) 				hcp->dndx = NUM_ENT(hcp->dpagep) - 1;B* 			} else if ((ret = __ham_next_cpage(dbc, 			    pgno, 0, H_ISDUP)) != 0)E 				return (ret);a 		}      	/*S: 	 * If we are retrieving a specific key/data pair, then we8 	 * may need to adjust the cursor before returning data. 	 */ 	if (flags == DB_GET_BOTH) { 		if (F_ISSET(hcp, H_ISDUP)) {$ 			if (hcp->dpgno != PGNO_INVALID) {( 				if ((ret = __db_dsearch(dbc, 0, val,4 				    hcp->dpgno, &hcp->dndx, &hcp->dpagep, &cmp))
 				    != 0)r 					return (ret); 				if (cmp == 0) $ 					hcp->dpgno = PGNO(hcp->dpagep); 			} else {(( 				__ham_dsearch(dbc, val, &off, &cmp); 				hcp->dup_off = off;o 			}
 		} else {* 			hk = H_PAIRDATA(hcp->pagep, hcp->bndx);- 			if (((HKEYDATA *)hk)->type == H_OFFPAGE) {) 				memcpy(&tlen,(. 				    HOFFPAGE_TLEN(hk), sizeof(u_int32_t)); 				memcpy(&pgno,h. 				    HOFFPAGE_PGNO(hk), sizeof(db_pgno_t));" 				if ((ret = __db_moff(dbp, val,2 				    pgno, tlen, dbp->dup_compare, &cmp)) != 0) 					return (ret); 			} else {Y 				/*2 				 * We do not zero tmp_val since the comparison/ 				 * routines may only look at data and size.; 				 */r% 				tmp_val.data = HKEYDATA_DATA(hk);e( 				tmp_val.size = LEN_HDATA(hcp->pagep,  				    dbp->pgsize, hcp->bndx);$ 				cmp = dbp->dup_compare == NULL ?% 				    __bam_defcmp(&tmp_val, val) :(( 				    dbp->dup_compare(&tmp_val, val); 			} 		};   		if (cmp != 0)c 			return (DB_NOTFOUND); 	}   	/* 7 	 * Now, everything is initialized, grab a duplicate if) 	 * necessary. 	 */ 	if (F_ISSET(hcp, H_ISDUP))t# 		if (hcp->dpgno != PGNO_INVALID) {a 			pp = hcp->dpagep; 			ndx = hcp->dndx;	
 		} else { 			/* 1 			 * Copy the DBT in case we are retrieving intot0 			 * user memory and we need the parameters for	 			 * it.f 			 */' 			memcpy(&tmp_val, val, sizeof(*val));># 			F_SET(&tmp_val, DB_DBT_PARTIAL);t 			tmp_val.dlen = hcp->dup_len;{3 			tmp_val.doff = hcp->dup_off + sizeof(db_indx_t);m 			myval = &tmp_val; 		}a     	/* @ 	 * Finally, if we had a duplicate, pp, ndx, and myval should be 	 * set appropriately. 	 */; 	if ((ret = __db_ret(dbp, pp, ndx, myval, &dbc->rdata.data,c 	    &dbc->rdata.size)) != 0)g 		return (ret);    	/*;; 	 * In case we sent a temporary off to db_ret, set the reale 	 * return values. 	 */ 	val->data = myval->data;  	val->size = myval->size;a   	return (0); }   
 static int __ham_overwrite(dbc, nval)
 	DBC *dbc; 	DBT *nval;= {_ 	HASH_CURSOR *hcp; 	DBT *myval, tmp_val;) 	u_int8_t *hk;  $ 	hcp = (HASH_CURSOR *)dbc->internal;" 	if (F_ISSET(dbc->dbp, DB_AM_DUP))0 		return (__ham_add_dup(dbc, nval, DB_KEYLAST));+ 	else if (!F_ISSET(nval, DB_DBT_PARTIAL)) {_ 		/* Put/overwrite */}( 		memcpy(&tmp_val, nval, sizeof(*nval));" 		F_SET(&tmp_val, DB_DBT_PARTIAL); 		tmp_val.doff = 0;E) 		hk = H_PAIRDATA(hcp->pagep, hcp->bndx); # 		if (HPAGE_PTYPE(hk) == H_OFFPAGE)  			memcpy(&tmp_val.dlen,- 			    HOFFPAGE_TLEN(hk), sizeof(u_int32_t));- 		else' 			tmp_val.dlen = LEN_HDATA(hcp->pagep,	% 			    hcp->hdr->pagesize,hcp->bndx);* 		myval = &tmp_val;I! 	} else /* Regular partial put */  		myval = nval;n  ( 	return (__ham_replpair(dbc, myval, 0)); }e   /*E  * Given a key and a cursor, sets the cursor to the page/ndx on whichiE  * the key resides.  If the key is found, the cursor H_OK flag is setbB  * and the pagep, bndx, pgno (dpagep, dndx, dpgno) fields are set.D  * If the key is not found, the H_OK flag is not set.  If the soughtE  * field is non-0, the pagep, bndx, pgno (dpagep, dndx, dpgno) fieldsaA  * are set indicating where an add might take place.  If it is 0,r-  * non of the cursor pointer field are valid.e  */ 
 static int$ __ham_lookup(dbc, key, sought, mode)
 	DBC *dbc; 	const DBT *key; 	u_int32_t sought; 	db_lockmode_t mode; { 	 	DB *dbp;g 	HASH_CURSOR *hcp; 	db_pgno_t pgno; 	u_int32_t tlen; 	int match, ret, t_ret;V 	u_int8_t *hk;   	dbp = dbc->dbp;$ 	hcp = (HASH_CURSOR *)dbc->internal; 	/*f@ 	 * Set up cursor so that we're looking for space to add an item6 	 * as we cycle through the pages looking for the key. 	 */( 	if ((ret = __ham_item_reset(dbc)) != 0) 		return (ret);  	hcp->seek_size = sought;_  F 	hcp->bucket = __ham_call_hash(hcp, (u_int8_t *)key->data, key->size); 	while (1) {. 		if ((ret = __ham_item_next(dbc, mode)) != 0) 			return (ret);   		if (F_ISSET(hcp, H_NOMORE))}	 			break;   ( 		hk = H_PAIRKEY(hcp->pagep, hcp->bndx); 		switch (HPAGE_PTYPE(hk)) { 		case H_OFFPAGE:g7 			memcpy(&tlen, HOFFPAGE_TLEN(hk), sizeof(u_int32_t));> 			if (tlen == key->size) {> 				memcpy(&pgno,r. 				    HOFFPAGE_PGNO(hk), sizeof(db_pgno_t)); 				if ((ret = __db_moff(dbp,-- 				    key, pgno, tlen, NULL, &match)) != 0)s 					return (ret); 				if (match == 0) {i 					F_SET(hcp, H_OK); 					return (0); 				}o 			}	 			break;> 		case H_KEYDATA:c( 			if (key->size == LEN_HKEY(hcp->pagep,( 			    hcp->hdr->pagesize, hcp->bndx) && 			    memcmp(key->data,, 			    HKEYDATA_DATA(hk), key->size) == 0) { 				F_SET(hcp, H_OK);> 				return (0);  			}	 			break;n 		case H_DUPLICATE:o 		case H_OFFDUP: 			/*s- 			 * These are errors because keys are never-& 			 * duplicated, only data items are. 			 */. 			return (__db_pgfmt(dbp, PGNO(hcp->pagep))); 		}  		hcp->stats.hash_collisions++;  	}   	/*>/ 	 * Item was not found, adjust cursor properly.h 	 */   	if (sought != 0)d 		return (ret);   8 	if ((t_ret = __ham_item_done(dbc, 0)) != 0 && ret == 0) 		ret = t_ret; 	return (ret); }:   /*A  * Initialize a dbt using some possibly already allocated storage}
  * for items.eL  * PUBLIC: int __ham_init_dbt __P((DBT *, u_int32_t, void **, u_int32_t *));  */e int & __ham_init_dbt(dbt, size, bufp, sizep)
 	DBT *dbt; 	u_int32_t size;
 	void **bufp;t 	u_int32_t *sizep; { 	 	int ret;h   	memset(dbt, 0, sizeof(*dbt)); 	if (*sizep < size) {t. 		if ((ret = __os_realloc(bufp, size)) != 0) { 			*sizep = 0; 			return (ret); 		}) 		*sizep = size; 	} 	dbt->data = *bufp;i 	dbt->size = size; 	return (0); }	   /*E  * Adjust the cursor after an insert or delete.  The cursor passed iskC  * the one that was operated upon; we just need to check any of theh
  * others.  *5  * len indicates the length of the item added/deletedfB  * add indicates if the item indicated by the cursor has just been*  * added (add == 1) or deleted (add == 0).?  * dup indicates if the addition occurred into a duplicate set.l  *  * PUBLIC: void __ham_c_updateC  * PUBLIC:    __P((HASH_CURSOR *, db_pgno_t, u_int32_t, int, int));r  */e void/ __ham_c_update(hcp, chg_pgno, len, add, is_dup)r 	HASH_CURSOR *hcp; 	db_pgno_t chg_pgno; 	u_int32_t len;p 	int add, is_dup;  {c	 	DB *dbp; 	 	DBC *cp;l 	HASH_CURSOR *lcp; 	int page_deleted;   	/*rC 	 * Regular adds are always at the end of a given page, so we nevery7 	 * have to adjust anyone's cursor after a regular add.d 	 */ 	if (!is_dup && add)	 		return;    	/*iC 	 * Determine if a page was deleted.    If this is a regular update=E 	 * (i.e., not is_dup) then the deleted page's number will be that inlD 	 * chg_pgno, and the pgno in the cursor will be different.  If thisE 	 * was an onpage-duplicate, then the same conditions apply.  If this(C 	 * was an off-page duplicate, then we need to verify if hcp->dpgnoL@ 	 * is the same (no delete) or different (delete) than chg_pgno. 	 */+ 	if (!is_dup || hcp->dpgno == PGNO_INVALID)s 		page_deleted =8 		    chg_pgno != PGNO_INVALID && chg_pgno != hcp->pgno; 	else	 		page_deleted =9 		    chg_pgno != PGNO_INVALID && chg_pgno != hcp->dpgno;    	dbp = hcp->dbc->dbp;	 	DB_THREAD_LOCK(dbp);Z  7 	for (cp = TAILQ_FIRST(&dbp->active_queue); cp != NULL;c" 	    cp = TAILQ_NEXT(cp, links)) { 		if (cp->internal == hcp) 			continue;  $ 		lcp = (HASH_CURSOR *)cp->internal;  ' 		if (!is_dup && lcp->pgno != chg_pgno)p 			continue;   		if (is_dup) {	8 			if (F_ISSET(hcp, H_DELETED) && lcp->pgno != chg_pgno)
 				continue;p: 			if (!F_ISSET(hcp, H_DELETED) && lcp->dpgno != chg_pgno)
 				continue;  		}z   		if (page_deleted) {f 			if (is_dup) { 				lcp->dpgno = hcp->dpgno; 				lcp->dndx = hcp->dndx; 			} else {p 				lcp->pgno = hcp->pgno; 				lcp->bndx = hcp->bndx; 				lcp->bucket = hcp->bucket; 			} 			F_CLR(lcp, H_ISDUP);  			continue; 		}=  ' 		if (!is_dup && lcp->bndx > hcp->bndx)S 			lcp->bndx--;	- 		else if (!is_dup && lcp->bndx == hcp->bndx)e 			F_SET(lcp, H_DELETED);a. 		else if (is_dup && lcp->bndx == hcp->bndx) {8 			/* Assign dpgno in case there was page conversion. */ 			lcp->dpgno = hcp->dpgno;P& 			if (add && lcp->dndx >= hcp->dndx ) 				lcp->dndx++;* 			else if (!add && lcp->dndx > hcp->dndx) 				lcp->dndx--;+ 			else if (!add && lcp->dndx == hcp->dndx)r 				F_SET(lcp, H_DELETED);  ( 			/* Now adjust on-page information. */" 			if (lcp->dpgno == PGNO_INVALID) 				if (add) { 					lcp->dup_tlen += len; 					if (lcp->dndx > hcp->dndx)A 						lcp->dup_off += len; 				} else { 					lcp->dup_tlen -= len; 					if (lcp->dndx > hcp->dndx)O 						lcp->dup_off -= len; 				}; 		}	 	} 	DB_THREAD_UNLOCK(dbp);A }P  