 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */  /*  * Copyright (c) 1995, 1996 '  *	Margo Seltzer.  All rights reserved.   */  /*  * Copyright (c) 1995, 1996 I  *	The President and Fellows of Harvard University.  All rights reserved.   *@  * This code is derived from software contributed to Berkeley by  * Margo Seltzer.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   */    #include "config.h"    #ifndef lintI static const char sccsid[] = "@(#)hash_rec.c	10.22 (Sleepycat) 10/21/98";  #endif /* not lint */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <string.h>  #endif   #include "db_int.h"  #include "shqueue.h" #include "db_page.h" #include "hash.h"  #include "btree.h" #include "log.h" #include "common_ext.h"    /*  * __ham_insdel_recover --  *#  * PUBLIC: int __ham_insdel_recover =  * PUBLIC:     __P((DB_LOG *, DBT *, DB_LSN *, int, void *));   */  int 2 __ham_insdel_recover(logp, dbtp, lsnp, redo, info) 	DB_LOG *logp; 	DBT *dbtp;  	DB_LSN *lsnp;
 	int redo; 	void *info; {  	__ham_insdel_args *argp;  	DB *file_dbp;
 	DBC *dbc; 	HASH_CURSOR *hcp; 	DB_MPOOLFILE *mpf; 
 	PAGE *pagep;  	u_int32_t op;  	int cmp_n, cmp_p, getmeta, ret;  
 	getmeta = 0;  	hcp = NULL; 	REC_PRINT(__ham_insdel_print);  	REC_INTRO(__ham_insdel_read);$ 	hcp = (HASH_CURSOR *)dbc->internal;  . 	ret = memp_fget(mpf, &argp->pgno, 0, &pagep); 	if (ret != 0) 		if (!redo) { 			/* 6 			 * We are undoing and the page doesn't exist.  That3 			 * is equivalent to having a pagelsn of 0, so we 5 			 * would not have to undo anything.  In this case, # 			 * don't bother creating a page.  			 */
 			goto done; / 		} else if ((ret = memp_fget(mpf, &argp->pgno, % 		    DB_MPOOL_CREATE, &pagep)) != 0)  			goto out;     	GET_META(file_dbp, hcp, ret); 	if (ret != 0) 		goto out; 
 	getmeta = 1;   ( 	cmp_n = log_compare(lsnp, &LSN(pagep));2 	cmp_p = log_compare(&LSN(pagep), &argp->pagelsn); 	/* ! 	 * Two possible things going on: < 	 * redo a delete/undo a put: delete the item from the page.7 	 * redo a put/undo a delete: add the item to the page. B 	 * If we are undoing a delete, then the information logged is the> 	 * entire entry off the page, not just the data of a dbt.  In> 	 * this case, we want to copy it back onto the page verbatim.C 	 * We do this by calling __putitem with the type H_OFFPAGE instead  	 * of H_KEYDATA.  	 */ 	op = OPCODE_OF(argp->opcode);  . 	if ((op == DELPAIR && cmp_n == 0 && !redo) ||- 	    (op == PUTPAIR && cmp_p == 0 && redo)) {  		/*> 		 * Need to redo a PUT or undo a delete.  If we are undoing a? 		 * delete, we've got to restore the item back to its original > 		 * position.  That's a royal pain in the butt (because we do@ 		 * not store item lengths on the page), but there's no choice. 		 */  		if (op != DELPAIR ||2 		    argp->ndx == (u_int32_t)H_NUMPAIRS(pagep)) {# 			__ham_putitem(pagep, &argp->key, - 			    !redo || PAIR_ISKEYBIG(argp->opcode) ?  			    H_OFFPAGE : H_KEYDATA);$ 			__ham_putitem(pagep, &argp->data,. 			    !redo || PAIR_ISDATABIG(argp->opcode) ? 			    H_OFFPAGE : H_KEYDATA); 		} else4 			(void) __ham_reputpair(pagep, hcp->hdr->pagesize,+ 			    argp->ndx, &argp->key, &argp->data);   , 		LSN(pagep) = redo ? *lsnp : argp->pagelsn;6 		if ((ret = __ham_put_page(file_dbp, pagep, 1)) != 0) 			goto out;  1 	} else if ((op == DELPAIR && cmp_p == 0 && redo) 1 	    || (op == PUTPAIR && cmp_n == 0 && !redo)) { , 		/* Need to undo a put or redo a delete. */* 		__ham_dpair(file_dbp, pagep, argp->ndx);, 		LSN(pagep) = redo ? *lsnp : argp->pagelsn;> 		if ((ret = __ham_put_page(file_dbp, (PAGE *)pagep, 1)) != 0) 			goto out; 	} else > 		if ((ret = __ham_put_page(file_dbp, (PAGE *)pagep, 0)) != 0) 			goto out;   	/* Return the previous LSN. */  done:	*lsnp = argp->prev_lsn; 	 	ret = 0;    out:	if (getmeta)  		RELEASE_META(file_dbp, hcp); 	REC_CLOSE;  }    /*  * __ham_newpage_recover -- D  *	This log message is used when we add/remove overflow pages.  ThisG  *	message takes care of the pointer chains, not the data on the pages.   *$  * PUBLIC: int __ham_newpage_recover=  * PUBLIC:     __P((DB_LOG *, DBT *, DB_LSN *, int, void *));   */  int 3 __ham_newpage_recover(logp, dbtp, lsnp, redo, info)  	DB_LOG *logp; 	DBT *dbtp;  	DB_LSN *lsnp;
 	int redo; 	void *info; {  	__ham_newpage_args *argp; 	DB *file_dbp;
 	DBC *dbc; 	HASH_CURSOR *hcp; 	DB_MPOOLFILE *mpf; 
 	PAGE *pagep; ( 	int cmp_n, cmp_p, change, getmeta, ret;  
 	getmeta = 0;  	hcp = NULL;  	REC_PRINT(__ham_newpage_print); 	REC_INTRO(__ham_newpage_read); $ 	hcp = (HASH_CURSOR *)dbc->internal;  2 	ret = memp_fget(mpf, &argp->new_pgno, 0, &pagep); 	if (ret != 0) 		if (!redo) { 			/* 6 			 * We are undoing and the page doesn't exist.  That3 			 * is equivalent to having a pagelsn of 0, so we 5 			 * would not have to undo anything.  In this case, # 			 * don't bother creating a page.  			 */ 			ret = 0;  			goto ppage;3 		} else if ((ret = memp_fget(mpf, &argp->new_pgno, % 		    DB_MPOOL_CREATE, &pagep)) != 0)  			goto out;  7 	GET_META(file_dbp, (HASH_CURSOR *)dbc->internal, ret);  	if (ret != 0) 		goto out; 
 	getmeta = 1;    	/* ? 	 * There are potentially three pages we need to check: the one @ 	 * that we created/deleted, the one before it and the one after 	 * it.  	 */  ( 	cmp_n = log_compare(lsnp, &LSN(pagep));2 	cmp_p = log_compare(&LSN(pagep), &argp->pagelsn); 	change = 0;  7 	if ((cmp_p == 0 && redo && argp->opcode == PUTOVFL) || 8 	    (cmp_n == 0 && !redo && argp->opcode == DELOVFL)) {9 		/* Redo a create new page or undo a delete new page. */ 1 		P_INIT(pagep, file_dbp->pgsize, argp->new_pgno, 3 		    argp->prev_pgno, argp->next_pgno, 0, P_HASH); 
 		change = 1; > 	} else if ((cmp_p == 0 && redo && argp->opcode == DELOVFL) ||8 	    (cmp_n == 0 && !redo && argp->opcode == PUTOVFL)) { 		/*5 		 * Redo a delete or undo a create new page.  All we ) 		 * really need to do is change the LSN.  		 */ 
 		change = 1;  	}   	if (!change) { > 		if ((ret = __ham_put_page(file_dbp, (PAGE *)pagep, 0)) != 0) 			goto out;	 	} else { , 		LSN(pagep) = redo ? *lsnp : argp->pagelsn;> 		if ((ret = __ham_put_page(file_dbp, (PAGE *)pagep, 1)) != 0) 			goto out; 	}   	/* Now do the prev page. */- ppage:	if (argp->prev_pgno != PGNO_INVALID) { 4 		ret = memp_fget(mpf, &argp->prev_pgno, 0, &pagep);   		if (ret != 0)i 			if (!redo) {n 				/*1 				 * We are undoing and the page doesn't exist.f3 				 * That is equivalent to having a pagelsn of 0,(1 				 * so we would not have to undo anything.  Inv/ 				 * this case, don't bother creating a page.T 				 */e 				ret = 0; 				goto npage;r 			} else if ((ret =' 			    memp_fget(mpf, &argp->prev_pgno,s& 			    DB_MPOOL_CREATE, &pagep)) != 0)
 				goto out;   ) 		cmp_n = log_compare(lsnp, &LSN(pagep));i3 		cmp_p = log_compare(&LSN(pagep), &argp->prevlsn);r
 		change = 0;   8 		if ((cmp_p == 0 && redo && argp->opcode == PUTOVFL) ||9 		    (cmp_n == 0 && !redo && argp->opcode == DELOVFL)) { : 			/* Redo a create new page or undo a delete new page. */% 			pagep->next_pgno = argp->new_pgno;o 			change = 1;? 		} else if ((cmp_p == 0 && redo && argp->opcode == DELOVFL) || 9 		    (cmp_n == 0 && !redo && argp->opcode == PUTOVFL)) {r1 			/* Redo a delete or undo a create new page. */*& 			pagep->next_pgno = argp->next_pgno; 			change = 1; 		}h   		if (!change) {
 			if ((ret =e8 			    __ham_put_page(file_dbp, (PAGE *)pagep, 0)) != 0)
 				goto out; 
 		} else {- 			LSN(pagep) = redo ? *lsnp : argp->prevlsn;i
 			if ((ret = 8 			    __ham_put_page(file_dbp, (PAGE *)pagep, 1)) != 0)
 				goto out;  		}  	}  # 	/* Now time to do the next page */v- npage:	if (argp->next_pgno != PGNO_INVALID) {p4 		ret = memp_fget(mpf, &argp->next_pgno, 0, &pagep);   		if (ret != 0)  			if (!redo) {` 				/*1 				 * We are undoing and the page doesn't exist.N3 				 * That is equivalent to having a pagelsn of 0,M1 				 * so we would not have to undo anything.  In / 				 * this case, don't bother creating a page.T 				 */R 				goto done; 			} else if ((ret =' 			    memp_fget(mpf, &argp->next_pgno,,& 			    DB_MPOOL_CREATE, &pagep)) != 0)
 				goto out;T  ) 		cmp_n = log_compare(lsnp, &LSN(pagep)); 3 		cmp_p = log_compare(&LSN(pagep), &argp->nextlsn);I
 		change = 0;*  8 		if ((cmp_p == 0 && redo && argp->opcode == PUTOVFL) ||9 		    (cmp_n == 0 && !redo && argp->opcode == DELOVFL)) {C: 			/* Redo a create new page or undo a delete new page. */% 			pagep->prev_pgno = argp->new_pgno;I 			change = 1;? 		} else if ((cmp_p == 0 && redo && argp->opcode == DELOVFL) ||c9 		    (cmp_n == 0 && !redo && argp->opcode == PUTOVFL)) {/1 			/* Redo a delete or undo a create new page. */E& 			pagep->prev_pgno = argp->prev_pgno; 			change = 1; 		}c   		if (!change) {
 			if ((ret =e8 			    __ham_put_page(file_dbp, (PAGE *)pagep, 0)) != 0)
 				goto out;h
 		} else {- 			LSN(pagep) = redo ? *lsnp : argp->nextlsn;e
 			if ((ret =*8 			    __ham_put_page(file_dbp, (PAGE *)pagep, 1)) != 0)
 				goto out;B 		}  	} done:	*lsnp = argp->prev_lsn;i	 	ret = 0;)   out:	if (getmeta)_ 		RELEASE_META(file_dbp, hcp); 	REC_CLOSE;  }_     /*  * __ham_replace_recover --nE  *	This log message refers to partial puts that are local to a single_D  *	page.  You can think of them as special cases of the more general  *	insdel log message.  *$  * PUBLIC: int __ham_replace_recover<  * PUBLIC:    __P((DB_LOG *, DBT *, DB_LSN *, int, void *));  */_ inti3 __ham_replace_recover(logp, dbtp, lsnp, redo, info)  	DB_LOG *logp; 	DBT *dbtp;p 	DB_LSN *lsnp;
 	int redo; 	void *info; {) 	__ham_replace_args *argp; 	DB *file_dbp;
 	DBC *dbc; 	HASH_CURSOR *hcp; 	DB_MPOOLFILE *mpf; 	 	DBT dbt;f
 	PAGE *pagep;  	int32_t grow;( 	int change, cmp_n, cmp_p, getmeta, ret; 	u_int8_t *hk;  
 	getmeta = 0;	 	hcp = NULL;  	REC_PRINT(__ham_replace_print); 	REC_INTRO(__ham_replace_read);M$ 	hcp = (HASH_CURSOR *)dbc->internal;  . 	ret = memp_fget(mpf, &argp->pgno, 0, &pagep); 	if (ret != 0) 		if (!redo) { 			/* 6 			 * We are undoing and the page doesn't exist.  That3 			 * is equivalent to having a pagelsn of 0, so weo5 			 * would not have to undo anything.  In this case, # 			 * don't bother creating a page.e 			 */
 			goto done; / 		} else if ((ret = memp_fget(mpf, &argp->pgno, % 		    DB_MPOOL_CREATE, &pagep)) != 0)s 			goto out;  7 	GET_META(file_dbp, (HASH_CURSOR *)dbc->internal, ret);  	if (ret != 0) 		goto out; 
 	getmeta = 1;a  ( 	cmp_n = log_compare(lsnp, &LSN(pagep));2 	cmp_p = log_compare(&LSN(pagep), &argp->pagelsn);   	if (cmp_p == 0 && redo) {
 		change = 1; ( 		/* Reapply the change as specified. */  		dbt.data = argp->newitem.data;  		dbt.size = argp->newitem.size;1 		grow = argp->newitem.size - argp->olditem.size;i 		LSN(pagep) = *lsnp;e" 	} else if (cmp_n == 0 && !redo) {
 		change = 1;*( 		/* Undo the already applied change. */  		dbt.data = argp->olditem.data;  		dbt.size = argp->olditem.size;1 		grow = argp->olditem.size - argp->newitem.size;  		LSN(pagep) = argp->pagelsn;P	 	} else {)
 		change = 0;t 		grow = 0;a 	}   	if (change) { 		__ham_onpage_replace(pagep,e: 		    file_dbp->pgsize, argp->ndx, argp->off, grow, &dbt); 		if (argp->makedup) {" 			hk = P_ENTRY(pagep, argp->ndx); 			if (redo)" 				HPAGE_PTYPE(hk) = H_DUPLICATE; 			elsea  				HPAGE_PTYPE(hk) = H_KEYDATA; 		}  	}  : 	if ((ret = __ham_put_page(file_dbp, pagep, change)) != 0) 		goto out;r   done:	*lsnp = argp->prev_lsn;p	 	ret = 0;e   out:	if (getmeta)) 		RELEASE_META(file_dbp, hcp); 	REC_CLOSE;& }m   /*  * __ham_newpgno_recover --PC  *	This log message is used when allocating or deleting an overflow 3  *	page.  It takes care of modifying the meta data.;  *$  * PUBLIC: int __ham_newpgno_recover<  * PUBLIC:    __P((DB_LOG *, DBT *, DB_LSN *, int, void *));  */) intg3 __ham_newpgno_recover(logp, dbtp, lsnp, redo, info)d 	DB_LOG *logp; 	DBT *dbtp;  	DB_LSN *lsnp;
 	int redo; 	void *info; {* 	__ham_newpgno_args *argp; 	DB *file_dbp;
 	DBC *dbc; 	HASH_CURSOR *hcp; 	DB_MPOOLFILE *mpf;p
 	PAGE *pagep; ( 	int change, cmp_n, cmp_p, getmeta, ret;  
 	getmeta = 0;g 	hcp = NULL;  	REC_PRINT(__ham_newpgno_print); 	REC_INTRO(__ham_newpgno_read);p$ 	hcp = (HASH_CURSOR *)dbc->internal;  7 	GET_META(file_dbp, (HASH_CURSOR *)dbc->internal, ret);  	if (ret != 0) 		goto out;S
 	getmeta = 1;*   	/**= 	 * There are two phases to the recovery here.  First we need = 	 * to update the meta data; then we need to update the page. ! 	 * We'll do the meta-data first.g 	 */+ 	cmp_n = log_compare(lsnp, &hcp->hdr->lsn); 5 	cmp_p = log_compare(&hcp->hdr->lsn, &argp->metalsn);,   	change = 0;9 	if ((cmp_p == 0 && redo && argp->opcode == ALLOCPGNO) ||w8 	    (cmp_n == 0 && !redo && argp->opcode == DELPGNO)) {6 		/* Need to redo an allocation or undo a deletion. */) 		hcp->hdr->last_freed = argp->free_pgno;	: 		if (redo && argp->old_pgno != 0) /* Must be ALLOCPGNO */, 			hcp->hdr->spares[hcp->hdr->ovfl_point]++;
 		change = 1;0< 	} else if (cmp_p == 0 && redo && argp->opcode == DELPGNO) { 		/* Need to redo a deletion */ $ 		hcp->hdr->last_freed = argp->pgno;
 		change = 1;e? 	} else if (cmp_n == 0 && !redo && argp->opcode == ALLOCPGNO) {T 		/* undo an allocation. */u 		if (argp->old_pgno == 0)% 			hcp->hdr->last_freed = argp->pgno;  		else {, 			hcp->hdr->spares[hcp->hdr->ovfl_point]--; 			hcp->hdr->last_freed = 0; 		}n
 		change = 1;h 	} 	if (change) {/ 		hcp->hdr->lsn = redo ? *lsnp : argp->metalsn;t 		F_SET(hcp, H_DIRTY); 	}    0 	/* Now check the newly allocated/freed page. */. 	ret = memp_fget(mpf, &argp->pgno, 0, &pagep);   	if (ret != 0) 		if (!redo) { 			/*e6 			 * We are undoing and the page doesn't exist.  That3 			 * is equivalent to having a pagelsn of 0, so wed5 			 * would not have to undo anything.  In this case,i# 			 * don't bother creating a page.v 			 */
 			goto done; / 		} else if ((ret = memp_fget(mpf, &argp->pgno,=% 		    DB_MPOOL_CREATE, &pagep)) != 0)  			goto out;  ( 	cmp_n = log_compare(lsnp, &LSN(pagep));2 	cmp_p = log_compare(&LSN(pagep), &argp->pagelsn);   	change = 0;7 	if (cmp_p == 0 && redo && argp->opcode == ALLOCPGNO) {e# 		/* Need to redo an allocation. */(; 		P_INIT(pagep, file_dbp->pgsize, argp->pgno, PGNO_INVALID,g' 		    PGNO_INVALID, 0, argp->new_type); 
 		change = 1;>= 	} else if (cmp_n == 0 && !redo && argp->opcode == DELPGNO) {1 		/* Undoing a delete. */ ; 		P_INIT(pagep, file_dbp->pgsize, argp->pgno, PGNO_INVALID, ) 		    argp->old_pgno, 0, argp->old_type);r
 		change = 1;0> 	} else if ((cmp_p == 0 && redo && argp->opcode == DELPGNO) ||: 	    (cmp_n == 0 && !redo && argp->opcode == ALLOCPGNO)) {6 		/* Need to redo a deletion or undo an allocation. */% 		NEXT_PGNO(pagep) = argp->free_pgno;	 		TYPE(pagep) = P_INVALID;
 		change = 1;T 	} 	if (change), 		LSN(pagep) = redo ? *lsnp : argp->pagelsn;  : 	if ((ret = __ham_put_page(file_dbp, pagep, change)) != 0) 		goto out;)   done:	*lsnp = argp->prev_lsn; 	 	ret = 0;r   out:	if (getmeta)i 		RELEASE_META(file_dbp, hcp); 	REC_CLOSE;r   })   /*  * __ham_splitmeta_recover -- D  *	This is the meta-data part of the split.  Records the new and old3  *	bucket numbers and the new/old mask information.e  *&  * PUBLIC: int __ham_splitmeta_recover<  * PUBLIC:    __P((DB_LOG *, DBT *, DB_LSN *, int, void *));  */_ int05 __ham_splitmeta_recover(logp, dbtp, lsnp, redo, info)= 	DB_LOG *logp; 	DBT *dbtp;= 	DB_LSN *lsnp;
 	int redo; 	void *info; {  	__ham_splitmeta_args *argp; 	DB *file_dbp;
 	DBC *dbc; 	HASH_CURSOR *hcp; 	DB_MPOOLFILE *mpf;)( 	int change, cmp_n, cmp_p, getmeta, ret; 	u_int32_t pow;)  
 	getmeta = 0;  	hcp = NULL;" 	REC_PRINT(__ham_splitmeta_print);! 	REC_INTRO(__ham_splitmeta_read);e$ 	hcp = (HASH_CURSOR *)dbc->internal;  7 	GET_META(file_dbp, (HASH_CURSOR *)dbc->internal, ret);o 	if (ret != 0) 		goto out;v
 	getmeta = 1;g   	/*_= 	 * There are two phases to the recovery here.  First we needn= 	 * to update the meta data; then we need to update the page.	! 	 * We'll do the meta-data first.e 	 */+ 	cmp_n = log_compare(lsnp, &hcp->hdr->lsn); 5 	cmp_p = log_compare(&hcp->hdr->lsn, &argp->metalsn);t   	change = 0; 	if (cmp_p == 0 && redo) {+ 		/* Need to redo the split information. */	* 		hcp->hdr->max_bucket = argp->bucket + 1;, 		pow = __db_log2(hcp->hdr->max_bucket + 1);# 		if (pow > hcp->hdr->ovfl_point) {  			hcp->hdr->spares[pow] =+ 				hcp->hdr->spares[hcp->hdr->ovfl_point];r 			hcp->hdr->ovfl_point = pow; 		}f3 		if (hcp->hdr->max_bucket > hcp->hdr->high_mask) { , 			hcp->hdr->low_mask = hcp->hdr->high_mask; 			hcp->hdr->high_mask =1 			    hcp->hdr->max_bucket | hcp->hdr->low_mask;p 		}>
 		change = 1;p" 	} else if (cmp_n == 0 && !redo) {+ 		/* Need to undo the split information. */ & 		hcp->hdr->max_bucket = argp->bucket;) 		hcp->hdr->ovfl_point = argp->ovflpoint;o8 		hcp->hdr->spares[hcp->hdr->ovfl_point] = argp->spares;1 		pow = 1 << __db_log2(hcp->hdr->max_bucket + 1);f  		hcp->hdr->high_mask = pow - 1;& 		hcp->hdr->low_mask = (pow >> 1) - 1;
 		change = 1;	 	} 	if (change) {/ 		hcp->hdr->lsn = redo ? *lsnp : argp->metalsn;n 		F_SET(hcp, H_DIRTY); 	}   done:	*lsnp = argp->prev_lsn;a	 	ret = 0;    out:	if (getmeta)	 		RELEASE_META(file_dbp, hcp); 	REC_CLOSE;= })   /*  * __ham_splitdata_recover --A  *&  * PUBLIC: int __ham_splitdata_recover<  * PUBLIC:    __P((DB_LOG *, DBT *, DB_LSN *, int, void *));  */  intt5 __ham_splitdata_recover(logp, dbtp, lsnp, redo, info)t 	DB_LOG *logp; 	DBT *dbtp;o 	DB_LSN *lsnp;
 	int redo; 	void *info; {B 	__ham_splitdata_args *argp; 	DB *file_dbp;
 	DBC *dbc; 	HASH_CURSOR *hcp; 	DB_MPOOLFILE *mpf; 
 	PAGE *pagep;l( 	int change, cmp_n, cmp_p, getmeta, ret;  
 	getmeta = 0;  	hcp = NULL;" 	REC_PRINT(__ham_splitdata_print);! 	REC_INTRO(__ham_splitdata_read);;$ 	hcp = (HASH_CURSOR *)dbc->internal;  . 	ret = memp_fget(mpf, &argp->pgno, 0, &pagep); 	if (ret != 0) 		if (!redo) { 			/*,6 			 * We are undoing and the page doesn't exist.  That3 			 * is equivalent to having a pagelsn of 0, so we;5 			 * would not have to undo anything.  In this case, # 			 * don't bother creating a page.m 			 */
 			goto done;g/ 		} else if ((ret = memp_fget(mpf, &argp->pgno, % 		    DB_MPOOL_CREATE, &pagep)) != 0)x 			goto out;  7 	GET_META(file_dbp, (HASH_CURSOR *)dbc->internal, ret);o 	if (ret != 0) 		goto out;.
 	getmeta = 1;   ( 	cmp_n = log_compare(lsnp, &LSN(pagep));2 	cmp_p = log_compare(&LSN(pagep), &argp->pagelsn);   	/*pB 	 * There are two types of log messages here, one for the old pageA 	 * and one for the new pages created.  The original image in the @ 	 * SPLITOLD record is used for undo.  The image in the SPLITNEWA 	 * is used for redo.  We should never have a case where there isi@ 	 * a redo operation and the SPLITOLD record is on disk, but notA 	 * the SPLITNEW record.  Therefore, we only have work to do whengB 	 * redo NEW messages and undo OLD messages, but we have to update 	 * LSNs in both cases.  	 */ 	change = 0; 	if (cmp_p == 0 && redo) { 		if (argp->opcode == SPLITNEW) * 			/* Need to redo the split described. */& 			memcpy(pagep, argp->pageimage.data, 			    argp->pageimage.size);> 		LSN(pagep) = *lsnp;a
 		change = 1;g" 	} else if (cmp_n == 0 && !redo) {! 		if (argp->opcode == SPLITOLD) {   			/* Put back the old image. */& 			memcpy(pagep, argp->pageimage.data, 			    argp->pageimage.size);a 		} else. 			P_INIT(pagep, file_dbp->pgsize, argp->pgno,. 			    PGNO_INVALID, PGNO_INVALID, 0, P_HASH); 		LSN(pagep) = argp->pagelsn;;
 		change = 1;i 	}: 	if ((ret = __ham_put_page(file_dbp, pagep, change)) != 0) 		goto out;e   done:	*lsnp = argp->prev_lsn;=	 	ret = 0;:   out:	if (getmeta)E 		RELEASE_META(file_dbp, hcp); 	REC_CLOSE;  }    /*  * __ham_ovfl_recover --H  *	This message is generated when we initialize a set of overflow pages.  *!  * PUBLIC: int __ham_ovfl_recover =  * PUBLIC:     __P((DB_LOG *, DBT *, DB_LSN *, int, void *));   */D int 0 __ham_ovfl_recover(logp, dbtp, lsnp, redo, info) 	DB_LOG *logp; 	DBT *dbtp;p 	DB_LSN *lsnp;
 	int redo; 	void *info; {b 	__ham_ovfl_args *argp;t 	DB *file_dbp;
 	DBC *dbc; 	HASH_CURSOR *hcp; 	DB_MPOOLFILE *mpf; 
 	PAGE *pagep;S 	db_pgno_t max_pgno, pgno;  	int cmp_n, cmp_p, getmeta, ret;  
 	getmeta = 0;, 	hcp = NULL; 	REC_PRINT(__ham_ovfl_print);; 	REC_INTRO(__ham_ovfl_read);$ 	hcp = (HASH_CURSOR *)dbc->internal;  7 	GET_META(file_dbp, (HASH_CURSOR *)dbc->internal, ret);p 	if (ret != 0) 		goto out;l
 	getmeta = 1;r  + 	cmp_n = log_compare(lsnp, &hcp->hdr->lsn); 5 	cmp_p = log_compare(&hcp->hdr->lsn, &argp->metalsn);e   	if (cmp_p == 0 && redo) { 		/* Redo the allocation. */* 		hcp->hdr->last_freed = argp->start_pgno;4 		hcp->hdr->spares[argp->ovflpoint] += argp->npages; 		hcp->hdr->lsn = *lsnp; 		F_SET(hcp, H_DIRTY);" 	} else if (cmp_n == 0 && !redo) {) 		hcp->hdr->last_freed = argp->free_pgno;|4 		hcp->hdr->spares[argp->ovflpoint] -= argp->npages;  		hcp->hdr->lsn = argp->metalsn; 		F_SET(hcp, H_DIRTY); 	}  0 	max_pgno = argp->start_pgno + argp->npages - 1;	 	ret = 0;p: 	for (pgno = argp->start_pgno; pgno <= max_pgno; pgno++) {6 		if ((ret = memp_fget(mpf, &pgno, 0, &pagep)) != 0) { 			if (!redo) {o 				ret = 0;
 				continue;{ 			} 			if ((ret = memp_fget(mpf,- 			    &pgno, DB_MPOOL_CREATE, &pagep)) != 0)=
 				goto out;f 		}_/ 		if (redo && log_compare((const DB_LSN *)lsnp, ) 		    (const DB_LSN *)&LSN(pagep)) > 0) {l6 			P_INIT(pagep, file_dbp->pgsize, pgno, PGNO_INVALID,5 			    pgno == max_pgno ? argp->free_pgno : pgno + 1,	 			    0, P_HASH); 			LSN(pagep) = *lsnp;, 			ret = __ham_put_page(file_dbp, pagep, 1); 		} else if (!redo) {l 			ZERO_LSN(pagep->lsn);, 			ret = __ham_put_page(file_dbp, pagep, 1); 		} else, 			ret = __ham_put_page(file_dbp, pagep, 0);
 		if (ret) 			goto out; 	}   done:	*lsnp = argp->prev_lsn;u	 	ret = 0;t   out:	if (getmeta). 		RELEASE_META(file_dbp, hcp); 	REC_CLOSE;s }f   /*  * __ham_copypage_recover --"  *	Recovery function for copypage.  *%  * PUBLIC: int __ham_copypage_recover	;  * PUBLIC:   __P((DB_LOG *, DBT *, DB_LSN *, int, void *));=  */  intM4 __ham_copypage_recover(logp, dbtp, lsnp, redo, info) 	DB_LOG *logp; 	DBT *dbtp;) 	DB_LSN *lsnp;
 	int redo; 	void *info; {p 	__ham_copypage_args *argp;  	DB *file_dbp;
 	DBC *dbc; 	HASH_CURSOR *hcp; 	DB_MPOOLFILE *mpf;d
 	PAGE *pagep;.* 	int cmp_n, cmp_p, getmeta, modified, ret;  
 	getmeta = 0;L 	hcp = NULL;! 	REC_PRINT(__ham_copypage_print);	  	REC_INTRO(__ham_copypage_read);$ 	hcp = (HASH_CURSOR *)dbc->internal;  7 	GET_META(file_dbp, (HASH_CURSOR *)dbc->internal, ret);> 	if (ret != 0) 		goto out;L
 	getmeta = 1;p 	modified = 0;   	/* This is the bucket page. */}. 	ret = memp_fget(mpf, &argp->pgno, 0, &pagep); 	if (ret != 0) 		if (!redo) { 			/* 6 			 * We are undoing and the page doesn't exist.  That3 			 * is equivalent to having a pagelsn of 0, so we=5 			 * would not have to undo anything.  In this case,e# 			 * don't bother creating a page.) 			 */ 			ret = 0;p 			goto donext; / 		} else if ((ret = memp_fget(mpf, &argp->pgno,!% 		    DB_MPOOL_CREATE, &pagep)) != 0)p 			goto out;  ( 	cmp_n = log_compare(lsnp, &LSN(pagep));2 	cmp_p = log_compare(&LSN(pagep), &argp->pagelsn);   	if (cmp_p == 0 && redo) {& 		/* Need to redo update described. */2 		memcpy(pagep, argp->page.data, argp->page.size); 		LSN(pagep) = *lsnp;i 		modified = 1;I" 	} else if (cmp_n == 0 && !redo) {& 		/* Need to undo update described. */= 		P_INIT(pagep, hcp->hdr->pagesize, argp->pgno, PGNO_INVALID,p" 		    argp->next_pgno, 0, P_HASH); 		LSN(pagep) = argp->pagelsn;  		modified = 1;  	}G 	if ((ret = memp_fput(mpf, pagep, modified ? DB_MPOOL_DIRTY : 0)) != 0)U 		goto out;D  " 	/* Now fix up the "next" page. */: donext:	ret = memp_fget(mpf, &argp->next_pgno, 0, &pagep); 	if (ret != 0) 		if (!redo) { 			/*a6 			 * We are undoing and the page doesn't exist.  That3 			 * is equivalent to having a pagelsn of 0, so weS5 			 * would not have to undo anything.  In this case,o# 			 * don't bother creating a page.h 			 */ 			ret = 0;  			goto do_nn;4 		} else if ((ret = memp_fget(mpf, &argp->next_pgno,% 		    DB_MPOOL_CREATE, &pagep)) != 0)  			goto out;  : 	/* There is nothing to do in the REDO case; only UNDO. */  ( 	cmp_n = log_compare(lsnp, &LSN(pagep)); 	if (cmp_n == 0 && !redo) { & 		/* Need to undo update described. */2 		memcpy(pagep, argp->page.data, argp->page.size); 		modified = 1;e 	}G 	if ((ret = memp_fput(mpf, pagep, modified ? DB_MPOOL_DIRTY : 0)) != 0)v 		goto out;   ' 	/* Now fix up the next's next page. */p, do_nn:	if (argp->nnext_pgno == PGNO_INVALID) 		goto done;  4 	ret = memp_fget(mpf, &argp->nnext_pgno, 0, &pagep); 	if (ret != 0) 		if (!redo) { 			/*>6 			 * We are undoing and the page doesn't exist.  That3 			 * is equivalent to having a pagelsn of 0, so wep5 			 * would not have to undo anything.  In this case, # 			 * don't bother creating a page.r 			 */
 			goto done;c5 		} else if ((ret = memp_fget(mpf, &argp->nnext_pgno,-% 		    DB_MPOOL_CREATE, &pagep)) != 0)g 			goto out;  ( 	cmp_n = log_compare(lsnp, &LSN(pagep));3 	cmp_p = log_compare(&LSN(pagep), &argp->nnextlsn);o   	if (cmp_p == 0 && redo) {& 		/* Need to redo update described. */  		PREV_PGNO(pagep) = argp->pgno; 		LSN(pagep) = *lsnp;D 		modified = 1;e" 	} else if (cmp_n == 0 && !redo) {& 		/* Need to undo update described. */% 		PREV_PGNO(pagep) = argp->next_pgno;* 		LSN(pagep) = argp->nnextlsn; 		modified = 1;i 	}G 	if ((ret = memp_fput(mpf, pagep, modified ? DB_MPOOL_DIRTY : 0)) != 0), 		goto out;*   done:	*lsnp = argp->prev_lsn;(	 	ret = 0;    out:	if (getmeta)D 		RELEASE_META(file_dbp, hcp); 	REC_CLOSE;i }ro; 	void *info; {B 	__ham_splitdata_args *argp; 	D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                