 /*- 7  * See the file LICENSE for redistribution information.   *  * Copyright (c) 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  **  *	@(#)db_cxx.h	10.30 (Sleepycat) 11/22/98  */    #ifndef _DB_CXX_H_ #define _DB_CXX_H_ // // C++ assumptions:  //E // To ensure portability to many platforms, both new and old, we make D // few assumptions about the C++ compiler and library.  For example,F // we do not expect STL, templates or namespaces to be available.  TheD // "newest" C++ feature used is exceptions, which are used liberallyD // to transmit error information.  Even the use of exceptions can be, // disabled at runtime, see setErrorModel(). // // C++ naming conventions: //. //  - All top level class names start with Db.5 //  - All class members start with lower case letter. < //  - All private data members are suffixed with underscore.: //  - Use underscores to divide names into multiple words.? //  - Simple data accessors are named with get_ or set_ prefix. A //  - All method names are taken from names of functions in the C < //    layer of db (usually by dropping a prefix like "db_").; //    These methods have the same argument types and order, ? //    other than dropping the explicit arg that acts as "this".  //H // As a rule, each DbFoo object has exactly one underlying DB_FOO structL // (defined in db.h) associated with it.  In many cases, we inherit directlyH // from the DB_FOO structure to make this relationship explicit.  Often,H // the underlying C layer allocates and deallocates these structures, soI // there is no easy way to add any data to the DbFoo class.  When you see F // a comment about whether data is permitted to be added, this is whatF // is going on.  Of course, if we need to add data to such C++ classesD // in the future, we will arrange to have an indirect pointer to the7 // DB_FOO struct (as some of the classes already have).  //    @ ////////////////////////////////////////////////////////////////@ //////////////////////////////////////////////////////////////// // // Forward declarations  //   #include <iostream.h>  #include <db.h>   ; class Db;                                        // forward ; class Dbc;                                       // forward ; class DbEnv;                                     // forward ; class DbException;                               // forward ; class DbInfo;                                    // forward ; class DbLock;                                    // forward ; class DbLockTab;                                 // forward ; class DbLog;                                     // forward ; class DbLsn;                                     // forward ; class DbMpool;                                   // forward ; class DbMpoolFile;                               // forward ; class Dbt;                                       // forward ; class DbTxn;                                     // forward ; class DbTxnMgr;                                  // forward   = // These classes are not defined here and should be invisible > // to the user, but some compilers require forward references.: // There is one for each use of the DEFINE_DB_CLASS macro.   class DbLockTabImp;  class DbLogImp;  class DbMpoolImp;  class DbMpoolFileImp;  class DbImp; class DbTxnImp;  class DbTxnMgrImp;    @ ////////////////////////////////////////////////////////////////@ //////////////////////////////////////////////////////////////// //# // Mechanisms for declaring classes  //   //L // Every class defined in this file has an _exported next to the class name.C // This is needed for WinTel machines so that the class methods can E // be exported or imported in a DLL as appropriate.  Users of the DLL C // use the define DB_USE_DLL.  When the DLL is built, DB_CREATE_DLL  // must be defined.  // #if defined(_MSC_VER)    #  if defined(DB_CREATE_DLL)B #    define _exported __declspec(dllexport)      // creator of dll #  elif defined(DB_USE_DLL) ? #    define _exported __declspec(dllimport)      // user of dll  #  else N #    define _exported                            // static lib creator or user #  endif   #else    #  define _exported    #endif  B // DEFINE_DB_CLASS defines an imp_ data member and imp() accessor.A // The underlying type is a pointer to an opaque *Imp class, that L // gets converted to the correct implementation class by the implementation. //H // Since these defines use "private/public" labels, and leave the accessE // being "private", we always use these by convention before any data B // members in the private section of a class.  Keeping them in theI // private section also emphasizes that they are off limits to user code.  // #define DEFINE_DB_CLASS(name) \ 5     public: class name##Imp* imp() { return imp_; } \ A     public: const class name##Imp* imp() const { return imp_; } \ "     private: class name##Imp* imp_    @ ////////////////////////////////////////////////////////////////@ //////////////////////////////////////////////////////////////// //+ // Turn off inappropriate compiler warnings  //   #ifdef _MSC_VER   ; // These are level 4 warnings that are explicitly disabled. B // With Visual C++, by default you do not see above level 3 unless> // you use /W4.  But we like to compile with the highest level" // warnings to catch other errors. // // 4201: nameless struct/union5 //       triggered by standard include file <winnt.h>  //6 // 4514: unreferenced inline function has been removedI //       certain include files in MSVC define methods that are not called  //# #pragma warning(disable: 4201 4514)    #endif  @ ////////////////////////////////////////////////////////////////@ //////////////////////////////////////////////////////////////// // // Exception classes //  ; // Almost any error in the DB library throws a DbException. 6 // Every exception should be considered an abnormality/ // (e.g. bug, misuse of DB, file system error).  //: // NOTE: We would like to inherit from class exception and, //       let it handle what(), but there are6 //       MSVC++ problems when <exception> is included. // class _exported DbException  {  public:      virtual ~DbException();      DbException(int err); )     DbException(const char *description); -     DbException(const char *prefix, int err); C     DbException(const char *prefix1, const char *prefix2, int err);      const int get_errno();%     virtual const char *what() const;   %     DbException(const DbException &); 2     DbException &operator = (const DbException &);   private:     char *what_;(     int err_;                   // errno };    @ ////////////////////////////////////////////////////////////////@ //////////////////////////////////////////////////////////////// // // Lock classes  //   class _exported DbLock {      friend class DbLockTab;    public: 
     DbLock();         int put(DbLockTab *locktab);       DbLock(const DbLock &); (     DbLock &operator = (const DbLock &);  
 protected:.     // We can add data to this class if needed8     // since its contained class is not allocated by db.     // (see comment at top)        DbLock(DB_LOCK);     DB_LOCK lock_; };   class _exported DbLockTab  {      friend class DbEnv;    public:      int close();+     int detect(u_int32_t flags, int atype); >     int get(u_int32_t locker, u_int32_t flags, const Dbt *obj,3             db_lockmode_t lock_mode, DbLock *lock);      int id(u_int32_t *idp); ?     int stat(DB_LOCK_STAT **statp, void *(*db_malloc)(size_t)); A     int vec(u_int32_t locker, u_int32_t flags, DB_LOCKREQ list[], % 	    int nlist, DB_LOCKREQ **elistp);   )     // Create or remove new locktab files      //?     static int open(const char *dir, u_int32_t flags, int mode, 7                     DbEnv* dbenv, DbLockTab **regionp); @     static int unlink(const char *dir, int force, DbEnv* dbenv);   private:.     // We can add data to this class if needed-     // since it is implemented via a pointer.      // (see comment at top)        // copying not allowed     //!     DbLockTab(const DbLockTab &); .     DbLockTab &operator = (const DbLockTab &);  :     // Note: use DbLockTab::open() or DbEnv::get_lk_info()&     // to get pointers to a DbLockTab,F     // and call DbLockTab::close() rather than delete to release them.     //     DbLockTab();     ~DbLockTab();        DEFINE_DB_CLASS(DbLockTab);  };    @ ////////////////////////////////////////////////////////////////@ //////////////////////////////////////////////////////////////// // // Log classes //  ( class _exported DbLsn : protected DB_LSN { K     friend class DbLog;          // friendship needed to cast to base class      friend class DbMpool;  };   class _exported DbLog  {      friend class DbEnv;    public: L     int archive(char **list[], u_int32_t flags, void *(*db_malloc)(size_t));     int close();=     static int compare(const DbLsn *lsn0, const DbLsn *lsn1); /     int file(DbLsn *lsn, char *namep, int len);       int flush(const DbLsn *lsn);4     int get(DbLsn *lsn, Dbt *data, u_int32_t flags);:     int put(DbLsn *lsn, const Dbt *data, u_int32_t flags);  @     // Normally these would be called register and unregister toC     // parallel the C interface, but "register" is a reserved word.      //M     int db_register(Db *dbp, const char *name, DBTYPE type, u_int32_t *fidp); %     int db_unregister(u_int32_t fid);   %     // Create or remove new log files      //?     static int open(const char *dir, u_int32_t flags, int mode, 3                     DbEnv* dbenv, DbLog **regionp); @     static int unlink(const char *dir, int force, DbEnv* dbenv);   private:.     // We can add data to this class if needed-     // since it is implemented via a pointer.      // (see comment at top)   6     // Note: use DbLog::open() or DbEnv::get_lg_info()"     // to get pointers to a DbLog,B     // and call DbLog::close() rather than delete to release them.     //     DbLog();
     ~DbLog();        // no copying      DbLog(const DbLog &); &     DbLog &operator = (const DbLog &);       DEFINE_DB_CLASS(DbLog);  };    @ ////////////////////////////////////////////////////////////////@ //////////////////////////////////////////////////////////////// // // Memory pool classes //   class _exported DbMpoolFile  {      friend class DbEnv;    public:      int close();?     int get(db_pgno_t *pgnoaddr, u_int32_t flags, void *pagep); +     int put(void *pgaddr, u_int32_t flags); +     int set(void *pgaddr, u_int32_t flags);      int sync();   2     static int open(DbMpool *mp, const char *file,?                     u_int32_t flags, int mode, size_t pagesize, ?                     DB_MPOOL_FINFO *finfop, DbMpoolFile **mpf);    private:.     // We can add data to this class if needed-     // since it is implemented via a pointer.      // (see comment at top)   $     // Note: use DbMpoolFile::open()(     // to get pointers to a DbMpoolFile,H     // and call DbMpoolFile::close() rather than delete to release them.     //     DbMpoolFile();       // Shut g++ up. 
 protected:     ~DbMpoolFile();    private:     // no copying %     DbMpoolFile(const DbMpoolFile &); 2     DbMpoolFile &operator = (const DbMpoolFile &);  !     DEFINE_DB_CLASS(DbMpoolFile);  };   class _exported DbMpool  {      friend class DbEnv;    public:      int close();  $     // access to low level interface9     // Normally this would be called register to parallel :     // the C interface, but "register" is a reserved word.     //     int db_register(int ftype,M                     int (*pgin)(db_pgno_t pgno, void *pgaddr, DBT *pgcookie), O                     int (*pgout)(db_pgno_t pgno, void *pgaddr, DBT *pgcookie));   8     int stat(DB_MPOOL_STAT **gsp, DB_MPOOL_FSTAT ***fsp,)              void *(*db_malloc)(size_t));      int sync(DbLsn *lsn); '     int trickle(int pct, int *nwrotep);   '     // Create or remove new mpool files      //?     static int open(const char *dir, u_int32_t flags, int mode, 5                     DbEnv* dbenv, DbMpool **regionp); @     static int unlink(const char *dir, int force, DbEnv* dbenv);   private:.     // We can add data to this class if needed-     // since it is implemented via a pointer.      // (see comment at top)   8     // Note: use DbMpool::open() or DbEnv::get_mp_info()$     // to get pointers to a DbMpool,D     // and call DbMpool::close() rather than delete to release them.     //     DbMpool();     ~DbMpool();        // no copying      DbMpool(const DbMpool &); *     DbMpool &operator = (const DbMpool &);       DEFINE_DB_CLASS(DbMpool);  };    @ ////////////////////////////////////////////////////////////////@ //////////////////////////////////////////////////////////////// // // Transaction classes //   class _exported DbTxnMgr {      friend class DbEnv;    public: '     int begin(DbTxn *pid, DbTxn **tid); 9     int checkpoint(u_int32_t kbyte, u_int32_t min) const;      int close();>     int stat(DB_TXN_STAT **statp, void *(*db_malloc)(size_t));  (     // Create or remove new txnmgr files     //?     static int open(const char *dir, u_int32_t flags, int mode, 6                     DbEnv* dbenv, DbTxnMgr **regionp);@     static int unlink(const char *dir, int force, DbEnv* dbenv);   private:.     // We can add data to this class if needed-     // since it is implemented via a pointer.      // (see comment at top)   9     // Note: use DbTxnMgr::open() or DbEnv::get_tx_info() %     // to get pointers to a DbTxnMgr, E     // and call DbTxnMgr::close() rather than delete to release them.      //     DbTxnMgr();      ~DbTxnMgr();       // no copying      DbTxnMgr(const DbTxnMgr &); ,     DbTxnMgr &operator = (const DbTxnMgr &);       DEFINE_DB_CLASS(DbTxnMgr); };   class _exported DbTxn  {      friend class DbTxnMgr;   public:      int abort();     int commit();      u_int32_t id();      int prepare();   private:.     // We can add data to this class if needed-     // since it is implemented via a pointer.      // (see comment at top)   >     // Note: use DbTxnMgr::begin() to get pointers to a DbTxn,;     // and call DbTxn::abort() or DbTxn::commit rather than      // delete to release them.     //     DbTxn();
     ~DbTxn();        // no copying      DbTxn(const DbTxn &); &     DbTxn &operator = (const DbTxn &);       DEFINE_DB_CLASS(DbTxn);  };    @ ////////////////////////////////////////////////////////////////@ //////////////////////////////////////////////////////////////// // // Application classes //   //B // A set of application options - define how this application uses // the db library. //* class _exported DbInfo : protected DB_INFO {      friend class DbEnv;      friend class Db;   public: 
     DbInfo();      ~DbInfo();       // Byte order.     void set_lorder(int);        // Underlying cache size.      void set_cachesize(size_t);        // Underlying page size.     void set_pagesize(size_t);       // Local heap allocation. +     typedef void *(*db_malloc_fcn)(size_t); #     void set_malloc(db_malloc_fcn);   "     // Duplicate compare function.=     typedef int (*dup_compare_fcn)(const DBT *, const DBT *); *     void set_dup_compare(dup_compare_fcn);  D     ////////////////////////////////////////////////////////////////     // Btree access method.        // Maximum keys per page.      void set_bt_maxkey(int);       // Minimum keys per page.      void set_bt_minkey(int);       // Comparison function. <     typedef int (*bt_compare_fcn)(const DBT *, const DBT *);(     void set_bt_compare(bt_compare_fcn);       // Prefix function. >     typedef size_t (*bt_prefix_fcn)(const DBT *, const DBT *);&     void set_bt_prefix(bt_prefix_fcn);  D     ////////////////////////////////////////////////////////////////     // Hash access method.       // Fill factor. "     void set_h_ffactor(u_int32_t);       // Number of elements.      void set_h_nelem(u_int32_t);       // Hash function. =     typedef u_int32_t (*h_hash_fcn)(const void *, u_int32_t);       void set_h_hash(h_hash_fcn);  D     ////////////////////////////////////////////////////////////////     // Recno access method.   !     // Fixed-length padding byte.      void set_re_pad(int);   '     // Variable-length delimiting byte.      void set_re_delim(int);   '     // Length for fixed-length records.*     void set_re_len(u_int32_t);e       // Source file name.     void set_re_source(char *);   :     // Note: some flags are set as side effects of calling     // above "set" methods.8     //     void set_flags(u_int32_t);    0     // (deep) copying of this object is allowed.     //     DbInfo(const DbInfo &);w(     DbInfo &operator = (const DbInfo &);   private:.     // We can add data to this class if needed1     // since parent class is not allocated by db.e     // (see comment at top)r };   //F // Base application class.  Provides functions for opening a database.B // User of this library can use this class as a starting point forD // developing a DB application - derive their application class from+ // this one, add application control logic.e //D // Note that if you use the default constructor, you must explicitlyC // call appinit() before any other db activity (e.g. opening files)m //( class _exported DbEnv : protected DB_ENV {a     friend class DbTxnMgr;     friend class DbLog;s     friend class DbLockTab;t     friend class DbMpool;      friend class Db;   public:i  
     ~DbEnv();/  A     // This constructor can be used to immediately initialize thee>     // application with these arguments.  Do not use it if you;     // need to set other parameters via the access methods.      //H     DbEnv(const char *homeDir, char *const *db_config, u_int32_t flags);  E     // Use this constructor if you wish to *delay* the initializatione<     // of the db library.  This is useful if you need to set>     // any particular parameters via the access methods below.:     // Then call appinit() to complete the initialization.     //     DbEnv();  :     // Used in conjunction with the default constructor to5     // complete the initialization of the db library.r     //N     int appinit(const char *homeDir, char *const *db_config, u_int32_t flags);  >     // Called automatically when DbEnv is destroyed, or can be*     // called at any time to shut down Db.     //     int appexit();  K     // Version information.  A static method so it can be obtained anytime.u     //=     static char *version(int *major, int *minor, int *patch);r  D     ////////////////////////////////////////////////////////////////$     // simple get/set access methods     //3     // If you are calling set_ methods, you need to 8     // use the default constructor along with appinit().       // Byte order.     void set_lorder(int);        // Panic callback.3     typedef void (*db_paniccall_fcn)(DbEnv *, int); )     void set_paniccall(db_paniccall_fcn);        // Error message callback.9     typedef void (*db_errcall_fcn)(const char *, char *); %     void set_errcall(db_errcall_fcn);   !     // Error message file stream.F     void set_errfile(FILE *);        // Error message prefix."     void set_errpfx(const char *);  #     // Generate debugging messages.      void set_verbose(int);  D     ////////////////////////////////////////////////////////////////     // Locking.n       // Return from lock_open().i#     DbLockTab *get_lk_info() const;e  '     // Two dimensional conflict matrix. &     void set_lk_conflicts(u_int8_t *);  %     // Number of lock modes in table.o     void set_lk_modes(int);l       // Maximum number of locks.      void set_lk_max(u_int32_t);m  )     // Deadlock detect on every conflict./"     void set_lk_detect(u_int32_t);    D     ////////////////////////////////////////////////////////////////     // Logging.l       // Return from log_open().     DbLog *get_lg_info() const;t       // Maximum file size./     void set_lg_max(u_int32_t);e    D     ////////////////////////////////////////////////////////////////     // Memory pool.        // Return from memp_open().D!     DbMpool *get_mp_info() const;T  "     // Maximum file size for mmap.!     void set_mp_mmapsize(size_t);(        // Bytes in the mpool cache.     void set_mp_size(size_t);     D     ////////////////////////////////////////////////////////////////     // Transactions.       // Return from txn_open()."     DbTxnMgr *get_tx_info() const;  &     // Maximum number of transactions.     void set_tx_max(u_int32_t);e  &     // Dispatch function for recovery.J     typedef int (*tx_recover_fcn)(DB_LOG *, DBT *, DB_LSN *, int, void *);(     void set_tx_recover(tx_recover_fcn);  
     // Flags.c     void set_flags(u_int32_t);  D     ////////////////////////////////////////////////////////////////@     // The default error model is to throw an exception whenever@     // an error occurs.  This generally allows for cleaner logic@     // for transaction processing, as a try block can surround aD     // single transaction.  Alternatively, since almost every methodC     // returns an error code (errno), the error model can be set to E     // not throw exceptions, and instead return the appropriate code.r     ///     enum ErrorModel { Exception, ErrorReturn };/%     void set_error_model(ErrorModel);/  :     // If an error is detected and the error call function<     // or stream is set, a message is dispatched or printed.4     // If a prefix is set, each message is prefixed.     //B     // You can use set_errcall() or set_errfile() above to controlC     // error functionality using a C model.  Alternatively, you canhC     // call set_error_stream() to force all errors to a C++ stream.s,     // It is unwise to mix these approaches.     //*     void set_error_stream(class ostream*);       // used internally9     static int runtime_error(const char *caller, int err,dI                              int in_destructor = 0, int force_throw = 0);    private:.     // We can add data to this class if needed1     // since parent class is not allocated by db./     // (see comment at top)E       // no copying      DbEnv(const DbEnv &);e&     DbEnv &operator = (const DbEnv &);       ErrorModel error_model_;<     static void stream_error_function(const char *, char *);"     static ostream *error_stream_; };  @ ////////////////////////////////////////////////////////////////@ //////////////////////////////////////////////////////////////// // // Table access classeso //   //F // Represents a database table = a set of keys with associated values. // class _exported Db {i     friend class DbEnv;(   public:*     int close(u_int32_t flags);o=     int cursor(DbTxn *txnid, Dbc **cursorp, u_int32_t flags);s5     int del(DbTxn *txnid, Dbt *key, u_int32_t flags);t     int fd(int *fdp);o@     int get(DbTxn *txnid, Dbt *key, Dbt *data, u_int32_t flags);:     int join(Dbc **curslist, u_int32_t flags, Dbc **dbcp);@     int put(DbTxn *txnid, Dbt *key, Dbt *data, u_int32_t flags);D     int stat(void *sp, void *(*db_malloc)(size_t), u_int32_t flags);     int sync(u_int32_t flags);        int get_byteswapped() const;     DBTYPE get_type() const;  D     static int open(const char *fname, DBTYPE type, u_int32_t flags,E                     int mode, DbEnv *dbenv, DbInfo *info, Db **dbpp);k   private:.     // We can add data to this class if needed-     // since it is implemented via a pointer.      // (see comment at top)   ?     // Note: use Db::open() to get initialize pointers to a Db, ?     // and call Db::close() rather than delete to release them.c	     Db(); 
     ~Db();       // no copyingt     Db(const Db &);       Db &operator = (const Db &);       DEFINE_DB_CLASS(Db); };   //) // A chunk of data, maybe a key or value.  //! class _exported Dbt : private DBT  {t     friend class Dbc;v     friend class Db;     friend class DbLog;3     friend class DbMpoolFile;_     friend class DbLockTab;i   public:R       // key/data      void *get_data() const;k     void set_data(void *);       // key/data length     u_int32_t get_size() const;      void set_size(u_int32_t);   !     // RO: length of user buffer.t     u_int32_t get_ulen() const;e     void set_ulen(u_int32_t);   !     // RO: get/put record length.      u_int32_t get_dlen() const;e     void set_dlen(u_int32_t);e  !     // RO: get/put record offset.n     u_int32_t get_doff() const;(     void set_doff(u_int32_t);k       // flags      u_int32_t get_flags() const;     void set_flags(u_int32_t);  !     Dbt(void *data, size_t size);e
     Dbt();     ~Dbt();/     Dbt(const Dbt &);o"     Dbt &operator = (const Dbt &);   private:.     // We can add data to this class if needed1     // since parent class is not allocated by db./     // (see comment at top)/ };  # class _exported Dbc : protected DBC/ {/     friend class Db;   public:/     int close();     int del(u_int32_t flags);s2     int get(Dbt* key, Dbt *data, u_int32_t flags);2     int put(Dbt* key, Dbt *data, u_int32_t flags);   private:>     // No data is permitted in this class (see comment at top)  7     // Note: use Db::cursor() to get pointers to a Dbc,t@     // and call Dbc::close() rather than delete to release them.     //
     Dbc();     ~Dbc();0       // no copying      Dbc(const Dbc &);s"     Dbc &operator = (const Dbc &); }; #endif /* !_DB_CXX_H_ */t get(DbLsn *lsn, Dbt *data, u_int32_t flags);:     int put(DbLsn *lsn, const Dbt *data, u_int32_t flags);  @     // Normally these would be called register and unregiste                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                