 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  **  *	@(#)db_page.h	10.18 (Sleepycat) 12/2/98  */    #ifndef _DB_PAGE_H_  #define	_DB_PAGE_H_    /*  * DB page formats.   *K  * This implementation requires that values within the following structures J  * NOT be padded -- note, ANSI C permits random padding within structures.K  * If your compiler pads randomly you can just forget ever making DB run on L  * your system.  In addition, no data type can require larger alignment thanN  * its own size, e.g., a 4-byte data element may not require 8-byte alignment.  *H  * Note that key/data lengths are often stored in db_indx_t's -- this isH  * not accidental, nor does it limit the key/data size.  If the key/dataH  * item fits on a page, it's guaranteed to be small enough to fit into a0  * db_indx_t, and storing it in one saves space.  */   3 #define	PGNO_METADATA	0	/* Metadata page number. */ E #define	PGNO_INVALID	0	/* Metadata page number, therefore illegal. */ * #define	PGNO_ROOT	1	/* Root is page #1. */   /*L  * When we create pages in mpool, we ask mpool to clear some number of bytesJ  * in the header.  This number must be at least as big as the regular pageO  * headers and cover enough of the btree and hash meta-data pages to obliterate !  * the magic and version numbers.   */  #define	DB_PAGE_CLEAR_LEN	32  I /************************************************************************   BTREE METADATA PAGE LAYOUT J  ************************************************************************/   /*  * Btree metadata page layout:  */  typedef struct _btmeta {! 	DB_LSN	  lsn;		/* 00-07: LSN. */ 3 	db_pgno_t pgno;		/* 08-11: Current page number. */ , 	u_int32_t magic;	/* 12-15: Magic number. */) 	u_int32_t version;	/* 16-19: Version. */ + 	u_int32_t pagesize;	/* 20-23: Pagesize. */ . 	u_int32_t maxkey;	/* 24-27: Btree: Maxkey. */. 	u_int32_t minkey;	/* 28-31: Btree: Minkey. */5 	u_int32_t free;		/* 32-35: Free list page number. */ + #define	BTM_DUP		0x001	/* 	  Duplicates. */ + #define	BTM_RECNO	0x002	/*	  Recno tree. */ > #define	BTM_RECNUM	0x004	/*	  Btree: maintain record count. */? #define	BTM_FIXEDLEN	0x008	/*	  Recno: fixed length records. */ D #define	BTM_RENUMBER	0x010	/*	  Recno: renumber on insert/delete. */ #define	BTM_MASK	0x01f% 	u_int32_t flags;	/* 36-39: Flags. */ B 	u_int32_t re_len;	/* 40-43: Recno: fixed-length record length. */? 	u_int32_t re_pad;	/* 44-47: Recno: fixed-length record pad. */   				/* 48-67: Unique file ID. */ 	u_int8_t  uid[DB_FILE_ID_LEN]; 	 } BTMETA;   I /************************************************************************   HASH METADATA PAGE LAYOUTJ  ************************************************************************/   /*  * Hash metadata page layout:   */  /* Hash Table Information */4 typedef struct hashhdr {	/* Disk resident portion */1 	DB_LSN	lsn;		/* 00-07: LSN of the header page */ A 	db_pgno_t pgno;		/* 08-11: Page number (btree compatibility). */ 7 	u_int32_t magic;	/* 12-15: Magic NO for hash tables */ + 	u_int32_t version;	/* 16-19: Version ID */ 2 	u_int32_t pagesize;	/* 20-23: Bucket/Page Size */E 	u_int32_t ovfl_point;	/* 24-27: Overflow page allocation location */ A 	u_int32_t last_freed;	/* 28-31: Last freed overflow page pgno */ ? 	u_int32_t max_bucket;	/* 32-35: ID of Maximum bucket in use */ 9 	u_int32_t high_mask;	/* 36-39: Modulo mask into table */ C 	u_int32_t low_mask;	/* 40-43: Modulo mask into table lower half */ , 	u_int32_t ffactor;	/* 44-47: Fill factor */; 	u_int32_t nelem;	/* 48-51: Number of keys in hash table */ 9 	u_int32_t h_charkey;	/* 52-55: Value of hash(CHARKEY) */  #define	DB_HASH_DUP	0x010 	u_int32_t flags;	/* 56-59: Allow duplicates. */0 #define NCACHED	32		/* number of spare points */* 				/* 60-187: Spare pages for overflow */ 	u_int32_t spares[NCACHED]; " 				/* 188-207: Unique file ID. */ 	u_int8_t  uid[DB_FILE_ID_LEN];    	/*  	 * Minimum page size is 256.  	 */
 } HASHHDR;  I /************************************************************************   MAIN PAGE LAYOUT J  ************************************************************************/   /*(  *	+-----------------------------------+(  *	|    lsn    |   pgno    | prev pgno |(  *	+-----------------------------------+(  *	| next pgno |  entries  | hf offset |(  *	+-----------------------------------+(  *	|   level   |   type    |   index   |(  *	+-----------------------------------+(  *	|   index   | free -->              |(  *	+-----------+-----------------------+%  *	|   	 F R E E A R E A            | (  *	+-----------------------------------+(  *	|              <-- free |   item    |(  *	+-----------------------------------+(  *	|   item    |   item    |   item    |(  *	+-----------------------------------+  *K  * sizeof(PAGE) == 26 bytes, and the following indices are guaranteed to be   * two-byte aligned.  *M  * For hash and btree leaf pages, index items are paired, e.g., inp[0] is the N  * key for inp[1]'s data.  All other types of pages only contain single items.  */  typedef struct _db_page { 1 	DB_LSN	  lsn;		/* 00-07: Log sequence number. */ 3 	db_pgno_t pgno;		/* 08-11: Current page number. */ 8 	db_pgno_t prev_pgno;	/* 12-15: Previous page number. */4 	db_pgno_t next_pgno;	/* 16-19: Next page number. */B 	db_indx_t entries;	/* 20-21: Number of item pairs on the page. */> 	db_indx_t hf_offset;	/* 22-23: High free byte page offset. */   	/* E 	 * The btree levels are numbered from the leaf to the root, starting E 	 * with 1, so the leaf is level 1, its parent is level 2, and so on. F 	 * We maintain this level on all btree pages, but the only place thatG 	 * we actually need it is on the root page.  It would not be difficult G 	 * to hide the byte on the root page once it becomes an internal page, F 	 * so we could get this byte back if we needed it for something else. 	 */ #define	LEAFLEVEL	  1  #define	MAXBTREELEVEL	255 0 	u_int8_t  level;	/*    24: Btree tree level. */  . #define	P_INVALID	0	/*	  Invalid page type. */- #define	P_DUPLICATE	1	/*        Duplicate. */ $ #define	P_HASH		2	/*        Hash. *// #define	P_IBTREE	3	/*        Btree internal. */ / #define	P_IRECNO	4	/*        Recno internal. */ + #define	P_LBTREE	5	/*        Btree leaf. */ + #define	P_LRECNO	6	/*        Recno leaf. */ + #define	P_OVERFLOW	7	/*        Overflow. */ ) 	u_int8_t  type;		/*    25: Page type. */ 8 	db_indx_t inp[1];	/* Variable length index of items. */ } PAGE;    /* Element macros. */ " #define	LSN(p)		(((PAGE *)p)->lsn)$ #define	PGNO(p)		(((PAGE *)p)->pgno)- #define	PREV_PGNO(p)	(((PAGE *)p)->prev_pgno) - #define	NEXT_PGNO(p)	(((PAGE *)p)->next_pgno) ) #define	NUM_ENT(p)	(((PAGE *)p)->entries) + #define	HOFFSET(p)	(((PAGE *)p)->hf_offset) % #define	LEVEL(p)	(((PAGE *)p)->level) $ #define	TYPE(p)		(((PAGE *)p)->type)   /*  * !!!L  * The next_pgno and prev_pgno fields are not maintained for btree and recnoH  * internal pages.  It's a minor performance improvement, and more, it'sJ  * hard to do when deleting internal pages, and it decreases the chance of&  * deadlock during deletes and splits.  *  * !!!L  * The btree/recno access method needs db_recno_t bytes of space on the rootM  * page to specify how many records are stored in the tree.  (The alternative M  * is to store the number of records in the meta-data page, which will create M  * a second hot spot in trees being actively modified, or recalculate it from G  * the BINTERNAL fields on each access.)  Overload the prev_pgno field.   */  #define	RE_NREC(p)							\- 	(TYPE(p) == P_LBTREE ? NUM_ENT(p) / 2 :				\ 5 	    TYPE(p) == P_LRECNO ? NUM_ENT(p) : PREV_PGNO(p)) " #define	RE_NREC_ADJ(p, adj)						\ 	PREV_PGNO(p) += adj; " #define	RE_NREC_SET(p, num)						\ 	PREV_PGNO(p) = num;   /*  * Initialize a page.   *  * !!!J  * Don't modify the page's LSN, code depends on it being unchanged after a  * P_INIT call.   */ E #define	P_INIT(pg, pg_size, n, pg_prev, pg_next, btl, pg_type) do {	\  	PGNO(pg) = n;							\ 	PREV_PGNO(pg) = pg_prev;					\  	NEXT_PGNO(pg) = pg_next;					\  	NUM_ENT(pg) = 0;						\ 	HOFFSET(pg) = pg_size;						\ 	LEVEL(pg) = btl;						\ 	TYPE(pg) = pg_type;						\, } while (0)   1 /* Page header length (offset to first index). */@% #define P_OVERHEAD		(SSZA(PAGE, inp))    /* First free byte. */C #define	LOFFSET(pg)		(P_OVERHEAD + NUM_ENT(pg) * sizeof(db_indx_t))l   /* Free space on the page. */i4 #define	P_FREESPACE(pg)		(HOFFSET(pg) - LOFFSET(pg))  5 /* Get a pointer to the bytes at a specific index. */ID #define	P_ENTRY(pg, indx)	((u_int8_t *)pg + ((PAGE *)pg)->inp[indx])  I /************************************************************************h  OVERFLOW PAGE LAYOUTgJ  ************************************************************************/   /*L  * Overflow items are referenced by HOFFPAGE and BOVERFLOW structures, whichI  * store a page number (the first page of the overflow item) and a length J  * (the total length of the overflow item).  The overflow item consists ofL  * some number of overflow pages, linked by the next_pgno field of the page.H  * A next_pgno field of PGNO_INVALID flags the end of the overflow item.  *  * Overflow page overloads: C  *	The amount of overflow data stored on each page is stored in thet  *	hf_offset field.f  *F  *	The implementation reference counts overflow items as it's possibleD  *	for them to be promoted onto btree internal pages.  The reference(  *	count is stored in the entries field.  */m* #define	OV_LEN(p)	(((PAGE *)p)->hf_offset)( #define	OV_REF(p)	(((PAGE *)p)->entries)  C /* Maximum number of bytes that you can put on an overflow page. */*0 #define	P_MAXSPACE(psize)	((psize) - P_OVERHEAD)  I /************************************************************************t  HASH PAGE LAYOUT	J  ************************************************************************/  9 /* Each index references a group of bytes on the page. */t( #define	H_KEYDATA	1	/* Key/data item. */4 #define	H_DUPLICATE	2	/* Duplicate key/data item. */1 #define	H_OFFPAGE	3	/* Overflow key/data item. *//5 #define	H_OFFDUP	4	/* Overflow page of duplicates. */    /*  * !!!L  * Items on hash pages are (potentially) unaligned, so we can never cast theL  * (page + offset) pointer to an HKEYDATA, HOFFPAGE or HOFFDUP structure, asM  * we do with B+tree on-page structures.  Because we frequently want the type N  * field, it requires no alignment, and it's in the same location in all three(  * structures, there's a pair of macros.  */.( #define	HPAGE_PTYPE(p)		(*(u_int8_t *)p)1 #define	HPAGE_TYPE(pg, indx)	(*P_ENTRY(pg, indx))/   /*H  * The first and second types are H_KEYDATA and H_DUPLICATE, represented  * by the HKEYDATA structure:   *(  *	+-----------------------------------+(  *	|    type   | key/data ...          |(  *	+-----------------------------------+  *H  * For duplicates, the data field encodes duplicate elements in the data	  * field:p  *D  *	+---------------------------------------------------------------+D  *	|    type   | len1 | element1 | len1 | len2 | element2 | len2   |D  *	+---------------------------------------------------------------+  *F  * Thus, by keeping track of the offset in the element, we can do both"  * backward and forward traversal.  */i typedef struct _hkeydata {) 	u_int8_t  type;		/*    00: Page type. *//8 	u_int8_t  data[1];	/* Variable length key/data item. */ } HKEYDATA;/A #define	HKEYDATA_DATA(p)	(((u_int8_t *)p) + SSZA(HKEYDATA, data))/   /*G  * The length of any HKEYDATA item. Note that indx is an element index,o  * not a PAIR index.  */t) #define	LEN_HITEM(pg, pgsize, indx)					\a= 	(((indx) == 0 ? pgsize : pg->inp[indx - 1]) - pg->inp[indx])/  + #define	LEN_HKEYDATA(pg, psize, indx)					\ 1 	(((indx) == 0 ? psize : pg->inp[indx - 1]) -			\u" 	pg->inp[indx] - HKEYDATA_SIZE(0))   /*G  * Page space required to add a new HKEYDATA item to the page, with and	  * without the index value.   */	! #define	HKEYDATA_SIZE(len)						\o 	((len) + SSZA(HKEYDATA, data)) " #define	HKEYDATA_PSIZE(len)						\) 	(HKEYDATA_SIZE(len) + sizeof(db_indx_t))   E /* Put a HKEYDATA item at the location referenced by a page entry. */*. #define	PUT_HKEYDATA(pe, kd, len, type) {				\% 	((HKEYDATA *)pe)->type = type;					\*7 	memcpy((u_int8_t *)pe + sizeof(u_int8_t), kd, len);		\* }    /*B  * Macros the describe the page layout in terms of key-data pairs.?  * The use of "pindex" indicates that the argument is the indexx5  * expressed in pairs instead of individual elements.-  */-* #define H_NUMPAIRS(pg)			(NUM_ENT(pg) / 2)( #define	H_KEYINDEX(pindx)		(2 * (pindx))/ #define	H_DATAINDEX(pindx)		((2 * (pindx)) + 1) < #define	H_PAIRKEY(pg, pindx)		P_ENTRY(pg, H_KEYINDEX(pindx))> #define	H_PAIRDATA(pg, pindx)		P_ENTRY(pg, H_DATAINDEX(pindx))* #define H_PAIRSIZE(pg, psize, pindx)					\/ 	(LEN_HITEM(pg, psize, H_KEYINDEX(pindx)) +			\i* 	LEN_HITEM(pg, psize, H_DATAINDEX(pindx)))M #define LEN_HDATA(p, psize, pindx) LEN_HKEYDATA(p, psize, H_DATAINDEX(pindx))iK #define LEN_HKEY(p, psize, pindx) LEN_HKEYDATA(p, psize, H_KEYINDEX(pindx))t   /*J  * The third type is the H_OFFPAGE, represented by the HOFFPAGE structure:  */  typedef struct _hoffpage {9 	u_int8_t  type;		/*    00: Page type and delete flag. */ 3 	u_int8_t  unused[3];	/* 01-03: Padding, unused. */d3 	db_pgno_t pgno;		/* 04-07: Offpage page number. */d4 	u_int32_t tlen;		/* 08-11: Total length of item. */ } HOFFPAGE;n  @ #define	HOFFPAGE_PGNO(p)	(((u_int8_t *)p) + SSZ(HOFFPAGE, pgno))@ #define	HOFFPAGE_TLEN(p)	(((u_int8_t *)p) + SSZ(HOFFPAGE, tlen))   /*G  * Page space required to add a new HOFFPAGE item to the page, with ande  * without the index value.s  */n) #define	HOFFPAGE_SIZE		(sizeof(HOFFPAGE)) ; #define	HOFFPAGE_PSIZE		(HOFFPAGE_SIZE + sizeof(db_indx_t))    /*D  * The fourth type is H_OFFDUP represented by the HOFFDUP structure:  */p typedef struct _hoffdup {c9 	u_int8_t  type;		/*    00: Page type and delete flag. */ 3 	u_int8_t  unused[3];	/* 01-03: Padding, unused. */k3 	db_pgno_t pgno;		/* 04-07: Offpage page number. */E
 } HOFFDUP;? #define	HOFFDUP_PGNO(p)		(((u_int8_t *)p) + SSZ(HOFFDUP, pgno))r   /*F  * Page space required to add a new HOFFDUP item to the page, with and  * without the index value.*  */d' #define	HOFFDUP_SIZE		(sizeof(HOFFDUP))n9 #define	HOFFDUP_PSIZE		(HOFFDUP_SIZE + sizeof(db_indx_t))O  I /************************************************************************   BTREE PAGE LAYOUTJ  ************************************************************************/  9 /* Each index references a group of bytes on the page. *//( #define	B_KEYDATA	1	/* Key/data item. */4 #define	B_DUPLICATE	2	/* Duplicate key/data item. */2 #define	B_OVERFLOW	3	/* Overflow key/data item. */   /*N  * We have to store a deleted entry flag in the page.   The reason is complex,M  * but the simple version is that we can't delete on-page items referenced byEM  * a cursor -- the return order of subsequent insertions might be wrong.  The(>  * delete flag is an overload of the top bit of the type byte.  */  #define	B_DELETE	(0x80)r" #define	B_DCLR(t)	(t) &= ~B_DELETE! #define	B_DSET(t)	(t) |= B_DELETE $ #define	B_DISSET(t)	((t) & B_DELETE)  # #define	B_TYPE(t)	((t) & ~B_DELETE)t( #define	B_TSET(t, type, deleted) {					\ 	(t) = (type);							\ 	if (deleted)							\s 		B_DSET(t);						\n }    /*F  * The first type is B_KEYDATA, represented by the BKEYDATA structure:  */r typedef struct _bkeydata {3 	db_indx_t len;		/* 00-01: Key/data item length. */e9 	u_int8_t  type;		/*    02: Page type AND DELETE FLAG. */c8 	u_int8_t  data[1];	/* Variable length key/data item. */ } BKEYDATA;c  / /* Get a BKEYDATA item for a specific index. */d% #define	GET_BKEYDATA(pg, indx)						\P  	((BKEYDATA *)P_ENTRY(pg, indx))   /*G  * Page space required to add a new BKEYDATA item to the page, with anda  * without the index value.a  */ ! #define	BKEYDATA_SIZE(len)						\ ' 	ALIGN((len) + SSZA(BKEYDATA, data), 4) " #define	BKEYDATA_PSIZE(len)						\) 	(BKEYDATA_SIZE(len) + sizeof(db_indx_t))u   /*I  * The second and third types are B_DUPLICATE and B_OVERFLOW, represented   * by the BOVERFLOW structure.  */( typedef struct _boverflow {p1 	db_indx_t unused1;	/* 00-01: Padding, unused. */	9 	u_int8_t  type;		/*    02: Page type AND DELETE FLAG. */\1 	u_int8_t  unused2;	/*    03: Padding, unused. */	0 	db_pgno_t pgno;		/* 04-07: Next page number. */4 	u_int32_t tlen;		/* 08-11: Total length of item. */ } BOVERFLOW;  0 /* Get a BOVERFLOW item for a specific index. */& #define	GET_BOVERFLOW(pg, indx)						\! 	((BOVERFLOW *)P_ENTRY(pg, indx))d   /*H  * Page space required to add a new BOVERFLOW item to the page, with and  * without the index value.   */n #define	BOVERFLOW_SIZE							\ 	ALIGN(sizeof(BOVERFLOW), 4) #define	BOVERFLOW_PSIZE							\*% 	(BOVERFLOW_SIZE + sizeof(db_indx_t))*   /*E  * Btree leaf and hash page layouts group indices in sets of two, one*E  * for the key and one for the data.  Everything else does it in setsOF  * of one to save space.  I use the following macros so that it's real  * obvious what's going on...d  */n #define	O_INDX	1 #define	P_INDX	2  I /************************************************************************s  BTREE INTERNAL PAGE LAYOUTlJ  ************************************************************************/   /*  * Btree internal entry.  */e typedef struct _binternal {e4 	db_indx_t  len;		/* 00-01: Key/data item length. */9 	u_int8_t   type;	/*    02: Page type AND DELETE FLAG. */s1 	u_int8_t   unused;	/*    03: Padding, unused. */ > 	db_pgno_t  pgno;	/* 04-07: Page number of referenced page. */5 	db_recno_t nrecs;	/* 08-11: Subtree record count. */(4 	u_int8_t   data[1];	/* Variable length key item. */ } BINTERNAL;  0 /* Get a BINTERNAL item for a specific index. */& #define	GET_BINTERNAL(pg, indx)						\! 	((BINTERNAL *)P_ENTRY(pg, indx))*   /*H  * Page space required to add a new BINTERNAL item to the page, with and  * without the index value.*  */*" #define	BINTERNAL_SIZE(len)						\( 	ALIGN((len) + SSZA(BINTERNAL, data), 4)# #define	BINTERNAL_PSIZE(len)						\f* 	(BINTERNAL_SIZE(len) + sizeof(db_indx_t))  I /************************************************************************o  RECNO INTERNAL PAGE LAYOUT	J  ************************************************************************/   /*  * The recno internal entry.  *  * XXXE  * Why not fold this into the db_indx_t structure, it's fixed length?H  */P typedef struct _rinternal { > 	db_pgno_t  pgno;	/* 00-03: Page number of referenced page. */5 	db_recno_t nrecs;	/* 04-07: Subtree record count. */a } RINTERNAL;  0 /* Get a RINTERNAL item for a specific index. */& #define	GET_RINTERNAL(pg, indx)						\! 	((RINTERNAL *)P_ENTRY(pg, indx))d   /*H  * Page space required to add a new RINTERNAL item to the page, with and  * without the index value.b  */  #define	RINTERNAL_SIZE							\ 	ALIGN(sizeof(RINTERNAL), 4) #define	RINTERNAL_PSIZE							\.% 	(RINTERNAL_SIZE + sizeof(db_indx_t))- #endif /* _DB_PAGE_H_ */uplicates, the data field encodes duplicate elements in the data	  * field:p  *D  *	+---------------------------------------------------------------+D  *	|    type   | len1 | element1 | len1 | len2 | element2 | len2   |D  *	+---------------------------------------------------------------+  *F  *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                