 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  **  *	@(#)db_shash.h	10.3 (Sleepycat) 4/10/98  */    /* Hash Headers */, typedef	SH_TAILQ_HEAD(hash_head) DB_HASHTAB;   /*  * HASHLOOKUP --  *G  * Look up something in a shared memory hash table.  The "elt" argument K  * should be a key, and cmp_func must know how to compare a key to whatever K  * structure it is that appears in the hash table.  The comparison function :  * cmp_func is called as: cmp_func(lookup_elt, table_elt);5  * begin: address of the beginning of the hash table. K  * type: the structure type of the elements that are linked in each bucket. J  * field: the name of the field by which the "type" structures are linked.>  * elt: the item for which we are searching in the hash table.I  * result: the variable into which we'll store the element if we find it. 3  * nelems: the number of buckets in the hash table. L  * hash_func: the hash function that operates on elements of the type of eltL  * cmp_func: compare elements of the type of elt with those in the table (of  *	type "type").  *H  * If the element is not in the hash table, this macro exits with result  * set to NULL.   */ C #define	HASHLOOKUP(begin, type, field, elt, r, n, hash, cmp) do {	\  	DB_HASHTAB *__bucket;						\  	u_int32_t __ndx;						\
 									\ 	__ndx = hash(elt) % (n);					\   	__bucket = &begin[__ndx];					\- 	for (r = SH_TAILQ_FIRST(__bucket, type);			\ 5 	    r != NULL; r = SH_TAILQ_NEXT(r, field, type))		\  		if (cmp(elt, r))					\ 			break;						\
 } while(0)   /*  * HASHINSERT --  *H  * Insert a new entry into the hash table.  This assumes that lookup hasB  * failed; don't call it if you haven't already called HASHLOOKUP.2  * begin: the beginning address of the hash table.K  * type: the structure type of the elements that are linked in each bucket. J  * field: the name of the field by which the "type" structures are linked.   * elt: the item to be inserted.3  * nelems: the number of buckets in the hash table. L  * hash_func: the hash function that operates on elements of the type of elt  */ < #define	HASHINSERT(begin, type, field, elt, n, hash) do {		\ 	u_int32_t __ndx;						\ 	DB_HASHTAB *__bucket;						\ 
 									\ 	__ndx = hash(elt) % (n);					\   	__bucket = &begin[__ndx];					\5 	SH_TAILQ_INSERT_HEAD(__bucket, elt, field, type);		\ 
 } while(0)   /*  * HASHREMOVE --&  *	Remove the entry with a key == elt.5  * begin: address of the beginning of the hash table. K  * type: the structure type of the elements that are linked in each bucket. J  * field: the name of the field by which the "type" structures are linked.  * elt: the item to be deleted. 3  * nelems: the number of buckets in the hash table. L  * hash_func: the hash function that operates on elements of the type of eltL  * cmp_func: compare elements of the type of elt with those in the table (of  *	type "type").  */ > #define	HASHREMOVE(begin, type, field, elt, n, hash, cmp) {		\ 	u_int32_t __ndx;						\ 	DB_HASHTAB *__bucket;						\  	SH_TAILQ_ENTRY *__entp;						\ 
 									\ 	__ndx = hash(elt) % (n);					\   	__bucket = &begin[__ndx];					\= 	HASHLOOKUP(begin, type, field, elt, __entp, n, hash, cmp);	\ 4 	SH_TAILQ_REMOVE(__bucket, __entp, field, type);			\ }    /*  * HASHREMOVE_EL -- 2  *	Given the object "obj" in the table, remove it.5  * begin: address of the beginning of the hash table. K  * type: the structure type of the elements that are linked in each bucket. J  * field: the name of the field by which the "type" structures are linked.7  * obj: the object in the table that we with to delete. 3  * nelems: the number of buckets in the hash table. L  * hash_func: the hash function that operates on elements of the type of elt  */ < #define	HASHREMOVE_EL(begin, type, field, obj, n, hash) {		\ 	u_int32_t __ndx;						\ 	DB_HASHTAB *__bucket;						\ 
 									\ 	__ndx = hash(obj) % (n);					\   	__bucket = &begin[__ndx];					\1 	SH_TAILQ_REMOVE(__bucket, obj, field, type);			\  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 