 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  *'  *	@(#)log.h	10.30 (Sleepycat) 10/11/98   */    #ifndef _LOG_H_  #define	_LOG_H_   . struct __fname;		typedef struct __fname FNAME;( struct __hdr;		typedef struct __hdr HDR;( struct __log;		typedef struct __log LOG;8 struct __log_persist;	typedef struct __log_persist LOGP;   #ifndef MAXLFNAME 4 #define	LFPREFIX	"log."		/* Log file name prefix. */9 #define	LFNAME		"log.%010d"	/* Log file name template. */ A #define	LFNAME_V1	"log.%05d"	/* Log file name template, rev 1. */ 9 #define	MAXLFNAME	2000000000	/* Maximum log file name. */  #endif 					/* Default log name. */, #define DB_DEFAULT_LOG_FILE	"__db_log.share"  0 #define	DEFAULT_MAX	(10 * MEGABYTE)	/* 10 Mb. */  3 /* Macros to lock/unlock the region and threads. */ # #define	LOCK_LOGTHREAD(dblp)						\ & 	if (F_ISSET(dblp, DB_AM_THREAD))				\+ 		(void)__db_mutex_lock((dblp)->mutexp, -1) % #define	UNLOCK_LOGTHREAD(dblp)						\ & 	if (F_ISSET(dblp, DB_AM_THREAD))				\. 		(void)__db_mutex_unlock((dblp)->mutexp, -1);# #define	LOCK_LOGREGION(dblp)						\ 9 	(void)__db_mutex_lock(&((RLAYOUT *)(dblp)->lp)->lock,		\  	    (dblp)->reginfo.fd)% #define	UNLOCK_LOGREGION(dblp)						\ ; 	(void)__db_mutex_unlock(&((RLAYOUT *)(dblp)->lp)->lock,		\  	    (dblp)->reginfo.fd)  - /* Check for region catastrophic shutdown. */ & #define	LOG_PANIC_CHECK(dblp) {						\% 	if ((dblp)->lp->rlayout.panic)					\  		return (DB_RUNRECOVERY);				\  }    /*B  * The per-process table that maps log file-id's to DB structures.  */  typedef	struct __db_entry { + 	DB	 *dbp;			/* Associated DB structure. */ . 	u_int32_t refcount;		/* Reference counted. */6 	int	  deleted;		/* File was not found during open. */ } DB_ENTRY;    /*	  * DB_LOG   *	Per-process log structure.   */  struct __db_log { C /* These fields need to be protected for multi-threaded support. */ 7 	db_mutex_t	*mutexp;	/* Mutex for thread protection. */   4 	DB_ENTRY *dbentry;		/* Recovery file-id mapping. */ #define	DB_GROW_SIZE	64 ? 	u_int32_t dbentry_cnt;		/* Entries.  Grows by DB_GROW_SIZE. */    /*M  * These fields are always accessed while the region lock is held, so they do M  * not have to be protected by the thread lock as well OR, they are only used N  * when threads are not being used, i.e. most cursor operations are disallowed  * on threaded logs.  */ * 	u_int32_t lfname;		/* Log file "name". */( 	int	  lfd;			/* Log file descriptor. */  , 	DB_LSN	  c_lsn;		/* Cursor: current LSN. */2 	DBT	  c_dbt;		/* Cursor: return DBT structure. */- 	int	  c_fd;			/* Cursor: file descriptor. */ 8 	u_int32_t c_off;		/* Cursor: previous record offset. */7 	u_int32_t c_len;		/* Cursor: current record length. */   % /* These fields are not protected. */ - 	LOG	 *lp;			/* Address of the shared LOG. */   7 	DB_ENV	 *dbenv;		/* Reference to error information. */ . 	REGINFO	  reginfo;		/* Region information. */  5 	void     *addr;			/* Address of shalloc() region. */   ( 	char	 *dir;			/* Directory argument. */   /*J  * These fields are used by XA; since XA forbids threaded execution, these  * do not have to be protected.   */ 4 	void 	*xa_info;		/* Committed transaction list that' 					 * has to be carried between calls  					 * to xa_recover. */ 8 	DB_LSN	xa_lsn;			/* Position of an XA recovery scan. */7 	DB_LSN	xa_first;		/* LSN to which we need to roll back % 					   for this XA recovery scan. */    	/*  	 * !!!  	 * Currently used to hold:  	 *	DB_AM_THREAD	(a DB flag) 	 *	DBC_RECOVER	(a DBC flag)= 	 * If they are ever the same bits, we're in serious trouble.  	 */ #if DB_AM_THREAD == DBC_RECOVER ) 	DB_AM_THREAD, DBC_RECOVER, FLAG MISMATCH  #endif 	u_int32_t flags;  };   /*	  * HDR --   *	Log record header.   */  struct __hdr {) 	u_int32_t prev;			/* Previous offset. */ * 	u_int32_t cksum;		/* Current checksum. */' 	u_int32_t len;			/* Current length. */  };   struct __log_persist {$ 	u_int32_t magic;		/* DB_LOGMAGIC */( 	u_int32_t version;		/* DB_LOGVERSION */  , 	u_int32_t lg_max;		/* Maximum file size. */# 	int	  mode;			/* Log file mode. */  };   /*	  * LOG -- B  *	Shared log region.  One of these is allocated in shared memory,  *	and describes the log.   */  struct __log {6 	RLAYOUT	  rlayout;		/* General region information. */  / 	LOGP	  persist;		/* Persistent information. */   3 	SH_TAILQ_HEAD(__fq) fq;		/* List of file names. */    	/* F 	 * The lsn LSN is the file offset that we're about to write and which 	 * we will return to the user.  	 */2 	DB_LSN	  lsn;			/* LSN at current file offset. */   	/* C 	 * The s_lsn LSN is the last LSN that we know is on disk, not just  	 * written, but synced. 	 */- 	DB_LSN	  s_lsn;		/* LSN of the last sync. */   2 	u_int32_t len;			/* Length of the last record. */  : 	u_int32_t w_off;		/* Current write offset in the file. */  7 	DB_LSN	  chkpt_lsn;		/* LSN of the last checkpoint. */ 4 	time_t	  chkpt;		/* Time of the last checkpoint. */  ) 	DB_LOG_STAT stat;		/* Log statistics. */    	/* C 	 * The f_lsn LSN is the LSN (returned to the user) that "owns" the D 	 * first byte of the buffer.  If the record associated with the LSNC 	 * spans buffers, it may not reflect the physical file location of ! 	 * the first byte of the buffer.  	 */8 	DB_LSN	  f_lsn;		/* LSN of first byte in the buffer. */5 	size_t	  b_off;		/* Current offset in the buffer. */ + 	u_int8_t buf[4 * 1024];		/* Log buffer. */  };   /*  * FNAME --   *	File name and id.  */  struct __fname {* 	SH_TAILQ_ENTRY q;		/* File name queue. */  ( 	u_int16_t ref;			/* Reference count. */  ' 	u_int32_t id;			/* Logging file id. */ ' 	DBTYPE	  s_type;		/* Saved DB type. */   ' 	size_t	  name_off;		/* Name offset. */ 6 	u_int8_t  ufid[DB_FILE_ID_LEN];	/* Unique file id. */ };  2 /* File open/close register log record opcodes. */> #define	LOG_CHECKPOINT	1		/* Checkpoint: file name/id dump. */& #define	LOG_CLOSE	2		/* File close. */$ #define	LOG_OPEN	3		/* File open. */   #include "log_auto.h"  #include "log_ext.h" #endif /* _LOG_H_ */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        