D /*	BSDI $Id: queue.h,v 1.1.1.1 1998/11/27 19:09:33 ghutchis Exp $	*/   /*  * Copyright (c) 1991, 1993 E  *	The Regents of the University of California.  All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *%  *	@(#)queue.h	8.5 (Berkeley) 8/20/94   */    #ifndef	_SYS_QUEUE_H_  #define	_SYS_QUEUE_H_    /*H  * This file defines three types of data structures: lists, tail queues,  * and circular queues.   *G  * A list is headed by a single forward pointer (or an array of forward D  * pointers for a hash table header). The elements are doubly linked@  * so that an arbitrary element can be removed without a need toB  * traverse the list. New elements can be added to the list beforeB  * or after an existing element or at the head of the list. A list2  * may only be traversed in the forward direction.  *G  * A tail queue is headed by a pair of pointers, one to the head of the F  * list and the other to the tail of the list. The elements are doublyG  * linked so that an arbitrary element can be removed without a need to E  * traverse the list. New elements can be added to the list before or G  * after an existing element, at the head of the list, or at the end of I  * the list. A tail queue may only be traversed in the forward direction.   *I  * A circle queue is headed by a pair of pointers, one to the head of the F  * list and the other to the tail of the list. The elements are doublyG  * linked so that an arbitrary element can be removed without a need to K  * traverse the list. New elements can be added to the list before or after K  * an existing element, at the head of the list, or at the end of the list. F  * A circle queue may be traversed in either direction, but has a more!  * complex end of list detection.   *H  * For details on the use of these macros, see the queue(3) manual page.  */    /*  * List definitions.  */ $ #define LIST_HEAD(name, type)						\ struct name {								\/ 	struct type *lh_first;	/* first element */			\  }    #define LIST_ENTRY(type)						\  struct {								\ - 	struct type *le_next;	/* next element */			\ @ 	struct type **le_prev;	/* address of previous next element */	\ }   , #define	LIST_FIRST(head)		((head)->lh_first)5 #define	LIST_NEXT(elm, field)		((elm)->field.le_next)  #define	LIST_END(head)			NULL    /*  * List functions.  */   #define	LIST_INIT(head) {						\ 	(head)->lh_first = NULL;					\  }   7 #define LIST_INSERT_AFTER(listelm, elm, field) do {			\ A 	if (((elm)->field.le_next = (listelm)->field.le_next) != NULL)	\ . 		(listelm)->field.le_next->field.le_prev =		\! 		    &(elm)->field.le_next;				\ ' 	(listelm)->field.le_next = (elm);				\ 5 	(elm)->field.le_prev = &(listelm)->field.le_next;		\  } while (0)   8 #define	LIST_INSERT_BEFORE(listelm, elm, field) do {			\4 	(elm)->field.le_prev = (listelm)->field.le_prev;		\' 	(elm)->field.le_next = (listelm);				\ ( 	*(listelm)->field.le_prev = (elm);				\5 	(listelm)->field.le_prev = &(elm)->field.le_next;		\  } while (0)   4 #define LIST_INSERT_HEAD(head, elm, field) do {				\: 	if (((elm)->field.le_next = (head)->lh_first) != NULL)		\; 		(head)->lh_first->field.le_prev = &(elm)->field.le_next;\   	(head)->lh_first = (elm);					\. 	(elm)->field.le_prev = &(head)->lh_first;			\ } while (0)   * #define LIST_REMOVE(elm, field) do {					\' 	if ((elm)->field.le_next != NULL)				\ , 		(elm)->field.le_next->field.le_prev = 			\  		    (elm)->field.le_prev;				\2 	*(elm)->field.le_prev = (elm)->field.le_next;			\ } while (0)    /*  * Tail queue definitions.  */ % #define TAILQ_HEAD(name, type)						\  struct name {								\0 	struct type *tqh_first;	/* first element */			\; 	struct type **tqh_last;	/* addr of last next element */		\  }     #define TAILQ_ENTRY(type)						\ struct {								\ . 	struct type *tqe_next;	/* next element */			\A 	struct type **tqe_prev;	/* address of previous next element */	\  }   . #define	TAILQ_FIRST(head)		((head)->tqh_first)7 #define	TAILQ_NEXT(elm, field)		((elm)->field.tqe_next)  #define	TAILQ_END(head)			NULL   /*  * Tail queue functions.  */ $ #define	TAILQ_INIT(head) do {						\  	(head)->tqh_first = NULL;					\, 	(head)->tqh_last = &(head)->tqh_first;				\ } while (0)   4 #define TAILQ_INSERT_HEAD(head, elm, field) do {			\; 	if (((elm)->field.tqe_next = (head)->tqh_first) != NULL)	\ ) 		(head)->tqh_first->field.tqe_prev =			\ " 		    &(elm)->field.tqe_next;				\ 	else								\/ 		(head)->tqh_last = &(elm)->field.tqe_next;		\ ! 	(head)->tqh_first = (elm);					\ 0 	(elm)->field.tqe_prev = &(head)->tqh_first;			\ } while (0)   4 #define TAILQ_INSERT_TAIL(head, elm, field) do {			\$ 	(elm)->field.tqe_next = NULL;					\. 	(elm)->field.tqe_prev = (head)->tqh_last;			\! 	*(head)->tqh_last = (elm);					\ / 	(head)->tqh_last = &(elm)->field.tqe_next;			\  } while (0)   = #define TAILQ_INSERT_AFTER(head, listelm, elm, field) do {		\ B 	if (((elm)->field.tqe_next = (listelm)->field.tqe_next) != NULL)\- 		(elm)->field.tqe_next->field.tqe_prev = 		\ " 		    &(elm)->field.tqe_next;				\ 	else								\/ 		(head)->tqh_last = &(elm)->field.tqe_next;		\ ( 	(listelm)->field.tqe_next = (elm);				\7 	(elm)->field.tqe_prev = &(listelm)->field.tqe_next;		\  } while (0)   9 #define	TAILQ_INSERT_BEFORE(listelm, elm, field) do {			\ 6 	(elm)->field.tqe_prev = (listelm)->field.tqe_prev;		\( 	(elm)->field.tqe_next = (listelm);				\) 	*(listelm)->field.tqe_prev = (elm);				\ 7 	(listelm)->field.tqe_prev = &(elm)->field.tqe_next;		\  } while (0)   0 #define TAILQ_REMOVE(head, elm, field) do {				\* 	if (((elm)->field.tqe_next) != NULL)				\- 		(elm)->field.tqe_next->field.tqe_prev = 		\ ! 		    (elm)->field.tqe_prev;				\  	else								\. 		(head)->tqh_last = (elm)->field.tqe_prev;		\4 	*(elm)->field.tqe_prev = (elm)->field.tqe_next;			\ } while (0)    /*  * Circular queue definitions.  */ & #define CIRCLEQ_HEAD(name, type)					\ struct name {								\0 	struct type *cqh_first;		/* first element */		\. 	struct type *cqh_last;		/* last element */		\ }   " #define CIRCLEQ_ENTRY(type)						\ struct {								\ . 	struct type *cqe_next;		/* next element */		\2 	struct type *cqe_prev;		/* previous element */		\ }   0 #define	CIRCLEQ_FIRST(head)		((head)->cqh_first). #define	CIRCLEQ_LAST(head)		((head)->cqh_last)+ #define	CIRCLEQ_END(head)		((void *)(head)) 8 #define	CIRCLEQ_NEXT(elm, field)	((elm)->field.cqe_next)8 #define	CIRCLEQ_PREV(elm, field)	((elm)->field.cqe_prev)   /*  * Circular queue functions.  */h& #define	CIRCLEQ_INIT(head) do {						\) 	(head)->cqh_first = (void *)(head);				\ ( 	(head)->cqh_last = (void *)(head);				\ } while (0)r  ? #define CIRCLEQ_INSERT_AFTER(head, listelm, elm, field) do {		\y6 	(elm)->field.cqe_next = (listelm)->field.cqe_next;		\( 	(elm)->field.cqe_prev = (listelm);				\4 	if ((listelm)->field.cqe_next == (void *)(head))		\  		(head)->cqh_last = (elm);				\ 	else								\6 		(listelm)->field.cqe_next->field.cqe_prev = (elm);	\( 	(listelm)->field.cqe_next = (elm);				\ } while (0)   @ #define CIRCLEQ_INSERT_BEFORE(head, listelm, elm, field) do {		\( 	(elm)->field.cqe_next = (listelm);				\6 	(elm)->field.cqe_prev = (listelm)->field.cqe_prev;		\4 	if ((listelm)->field.cqe_prev == (void *)(head))		\! 		(head)->cqh_first = (elm);				\s 	else								\6 		(listelm)->field.cqe_prev->field.cqe_next = (elm);	\( 	(listelm)->field.cqe_prev = (elm);				\ } while (0)   6 #define CIRCLEQ_INSERT_HEAD(head, elm, field) do {			\/ 	(elm)->field.cqe_next = (head)->cqh_first;			\a- 	(elm)->field.cqe_prev = (void *)(head);				\d- 	if ((head)->cqh_last == (void *)(head))				\i  		(head)->cqh_last = (elm);				\ 	else								\/ 		(head)->cqh_first->field.cqe_prev = (elm);		\A! 	(head)->cqh_first = (elm);					\N } while (0)N  6 #define CIRCLEQ_INSERT_TAIL(head, elm, field) do {			\- 	(elm)->field.cqe_next = (void *)(head);				\ . 	(elm)->field.cqe_prev = (head)->cqh_last;			\- 	if ((head)->cqh_first == (void *)(head))			\C! 		(head)->cqh_first = (elm);				\X 	else								\. 		(head)->cqh_last->field.cqe_next = (elm);		\  	(head)->cqh_last = (elm);					\ } while (0)E  2 #define	CIRCLEQ_REMOVE(head, elm, field) do {				\1 	if ((elm)->field.cqe_next == (void *)(head))			\L. 		(head)->cqh_last = (elm)->field.cqe_prev;		\ 	else								\- 		(elm)->field.cqe_next->field.cqe_prev =			\Y! 		    (elm)->field.cqe_prev;				\T1 	if ((elm)->field.cqe_prev == (void *)(head))			\C/ 		(head)->cqh_first = (elm)->field.cqe_next;		\0 	else								\- 		(elm)->field.cqe_prev->field.cqe_next =			\ ! 		    (elm)->field.cqe_next;				\s } while (0)c #endif	/* !_SYS_QUEUE_H_ */*nd circular queues.   *G  * A list is headed by a single forward pointer (or an array of forward D  * pointers for a hash table header). The elements are doubly linked@  * so that an arbitrary element can be removed without a need toB  * traverse the list. New elements can be added to the list beforeB  * or after an existing element or at the head of the list. A list2  * may only be traversed in the forward direction.  *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                