 /*- 7  * See the file LICENSE for redistribution information.   *  * Copyright (c) 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  *(  *	@(#)Db.java	10.15 (Sleepycat) 12/8/98  */    package com.sleepycat.db;    /**   *  * @author Donald D. Anderson   */  public class Db  { K     // All constant and flag values used with Db* classes are defined here.   :     // Collectively, these constants are known by the name%     // "DBTYPE" in the documentation.      //3     public static final int DB_BTREE = 1; // B+tree E     public static final int DB_HASH  = 2; // Extended Linear Hashing. O     public static final int DB_RECNO = 3; // Fixed and variable-length records. E     public static final int DB_UNKNOWN = 4; // Figure it out on open.   E     // Flags understood by Db.open(), DbEnv.appinit(), DbEnv.DbEnv().      //L     public static final int DB_CREATE; // O_CREAT: create file as necessary.E     public static final int DB_NOMMAP; // Don't mmap underlying file. I     public static final int DB_THREAD; // Free-thread DB package handles.        //&     // Flags understood by db_open(3).     //?     public static final int DB_EXCL; // O_EXCL: exclusive open. >     public static final int DB_RDONLY; // O_RDONLY: read-only.I     public static final int DB_SEQUENTIAL; // Indicate sequential access. B     public static final int DB_TEMPORARY; // Remove on last close.L     public static final int DB_TRUNCATE; // O_TRUNCATE: replace existing DB.         //,     // DB (user visible) error return codes.     //F     public static final int DB_INCOMPLETE = -1; // Sync didn't finish.S     public static final int DB_KEYEMPTY = -2;   // The key/data pair was deleted or Q                                                 // was never created by the user. T     public static final int DB_KEYEXIST = -3;   // The key/data pair already exists.X     public static final int DB_LOCK_DEADLOCK = -4; // Locker killed to resolve deadlock.V     public static final int DB_LOCK_NOTGRANTED = -5; // Lock unavailable, no-wait set.M     public static final int DB_LOCK_NOTHELD = -6; // Lock not held by locker. Q     public static final int DB_NOTFOUND = -7;   // Key/data pair not found (EOF).        //$     // Flags used by DbEnv.appinit()     //N     public static final int DB_INIT_CDB;         // Concurrent Access Methods.G     public static final int DB_INIT_LOCK;        // Initialize locking. G     public static final int DB_INIT_LOG;         // Initialize logging. E     public static final int DB_INIT_MPOOL;       // Initialize mpool. L     public static final int DB_INIT_TXN;         // Initialize transactions.O     public static final int DB_MPOOL_PRIVATE;    // Mpool: private memory pool. H     public static final int DB_RECOVER;          // Run normal recovery.N     public static final int DB_RECOVER_FATAL;    // Run catastrophic recovery.N     public static final int DB_TXN_NOSYNC;       // Do not sync log on commit.H     public static final int DB_USE_ENVIRON;      // Use the environment.P     public static final int DB_USE_ENVIRON_ROOT; // Use the environment if root.       //L     // Deadlock detector modes; used in the DBENV structure to configure the     // locking subsystem.      //*     public static final int DB_LOCK_NORUN;,     public static final int DB_LOCK_DEFAULT;+     public static final int DB_LOCK_OLDEST; +     public static final int DB_LOCK_RANDOM; -     public static final int DB_LOCK_YOUNGEST;        //     // Values for DbInfo flags     //A     public static final int DB_DELIMITER; // Recno: re_delim set. I     public static final int DB_DUP;       // Btree, Hash: duplicate keys. I     public static final int DB_DUPSORT;   // Btree, Hash: duplicate keys. I     public static final int DB_FIXEDLEN;  // Recno: fixed-length records. ?     public static final int DB_PAD;       // Recno: re_pad set. C     public static final int DB_RECNUM;    // Btree: record numbers. N     public static final int DB_RENUMBER;  // Recno: renumber on insert/delete.G     public static final int DB_SNAPSHOT;  // Recno: snapshot the input.   :     // Collectively, these constants are known by the name,     // "db_lockmode_t" in the documentation.     //;     public static final int DB_LOCK_NG = 0;	// Not granted. =     public static final int DB_LOCK_READ = 1;	// Shared/read. B     public static final int DB_LOCK_WRITE = 2;	// Exclusive/write.J     public static final int DB_LOCK_IWRITE = 3;	// Intent exclusive/write.G     public static final int DB_LOCK_IREAD = 4;	// Intent to share/read. I     public static final int DB_LOCK_IWR = 5;	// Intent to read and write.   :     // Collectively, these constants are known by the name*     // "db_lockop_t" in the documentation.     //D     public static final int DB_LOCK_DUMP = 0;	// Display held locks.=     public static final int DB_LOCK_GET = 1;	// Get the lock. A     public static final int DB_LOCK_PUT = 2;	// Release the lock. J     public static final int DB_LOCK_PUT_ALL = 3;// Release locker's locks.Q     public static final int DB_LOCK_PUT_OBJ = 4;// Release locker's locks on obj.   #     // Flag values for DbLock.vec() N     public static final int DB_LOCK_NOWAIT; // Don't wait on unavailable lock.O     public static final int DB_LOCK_UPGRADE;// Upgrade an existing lock instead E                                             // of granting a new one.   &     // Flag values for DbLock.detect()E     public static final int DB_LOCK_CONFLICT; // Run on any conflict.   /     // Size of commonly used conflict matrices.      //     //O     public static final int DB_LOCK_RW_N; // standard R/W (or exclusive/shared)        //&     // Flag values for DbLog.archive()     //D     public static final int DB_ARCH_ABS;      // Absolute pathnames.<     public static final int DB_ARCH_DATA;     // Data files.;     public static final int DB_ARCH_LOG;      // Log files.        //4     // DB access method and cursor operation values./     // Each value is an operation code to which &     // additional bit flags are added.     //7     public static final int DB_AFTER;      // Dbc.put() 6     public static final int DB_APPEND;     // Db.put()7     public static final int DB_BEFORE;     // Dbc.put() F     public static final int DB_CHECKPOINT; // DbLog.put(), DbLog.get()9     public static final int DB_CURLSN;     // DbLog.put() O     public static final int DB_CURRENT;    // Dbc.get(), Dbc.put(), DbLog.get() D     public static final int DB_FIRST;      // Dbc.get(), DbLog.get()9     public static final int DB_FLUSH;      // DbLog.put() A     public static final int DB_GET_BOTH;   // Db.get(), Dbc.get() 7     public static final int DB_GET_RECNO;  // Dbc.get() 7     public static final int DB_JOIN_ITEM;  // Dbc.get() 7     public static final int DB_KEYFIRST;   // Dbc.put() 7     public static final int DB_KEYLAST;    // Dbc.put() D     public static final int DB_LAST;       // Dbc.get(), DbLog.get()D     public static final int DB_NEXT;       // Dbc.get(), DbLog.get()7     public static final int DB_NEXT_DUP;   // Dbc.get() 6     public static final int DB_NOOVERWRITE;// Db.put()8     public static final int DB_NOSYNC;     // Db.close()D     public static final int DB_PREV;       // Dbc.get(), DbLog.get()7     public static final int DB_RECORDCOUNT;// Db.stat() D     public static final int DB_SET;        // Dbc.get(), DbLog.get()7     public static final int DB_SET_RANGE;  // Dbc.get() 7     public static final int DB_SET_RECNO;  // Dbc.get()   C     // Another flag that must be added to an operation codes above.      //M     public static final int DB_RMW;        // Acquire write flag immediately.   8     // Collectively, these values are used for Dbt flags     //G     // Perform any mallocs using regular malloc, not the user's malloc. ,     public static final int DB_DBT_INTERNAL;  "     // Return in allocated memory.*     public static final int DB_DBT_MALLOC;       // Partial put/get. +     public static final int DB_DBT_PARTIAL;        // Return in user's memory. +     public static final int DB_DBT_USERMEM;            // methods     //  '     public native void close(int flags)           throws DbException;  4     public native Dbc cursor(DbTxn txnid, int flags)          throws DbException;  ;     public native void del(DbTxn txnid, Dbt key, int flags)5          throws DbException;       public native int fd()          throws DbException;  /     // returns: 0, DB_NOTFOUND, or throws errorcD     public native int get(DbTxn txnid, Dbt key, Dbt data, int flags)          throws DbException;  5     public native Dbc join(Dbc curslist[], int flags)n          throws DbException;  /     // returns: 0, DB_KEYEXIST, or throws errorcD     public native int put(DbTxn txnid, Dbt key, Dbt data, int flags)          throws DbException;  *     // returns a DbBtreeStat or DbHashStat(     public native Object stat(int flags)          throws DbException;  &     public native void sync(int flags)          throws DbException;  ,     public native boolean get_byteswapped();  ,     public native /*DBTYPE*/ int get_type();  N     public native static Db open(String fname, /*DBTYPE*/ int type, int flags,D                                  int mode, DbEnv dbenv, DbInfo info)          throws DbException;  $     protected native void finalize()          throws Throwable;       // get/set methods     //       // private dataD     //#     private long private_info_ = 0;   3     private static boolean already_loaded_ = false;l        public static void load_db()     {          if (already_loaded_)             return;C  2         String os = System.getProperty("os.name");5         if (os != null && os.startsWith("Windows")) { 8             // called libdb.dll, libdb_java.dll on Win/*(             System.loadLibrary("libdb");-             System.loadLibrary("libdb_java");t	         }          else {5             // called libdb.so, libdb_java.so on UNIX %             System.loadLibrary("db");K*             System.loadLibrary("db_java");	         }            already_loaded_ = true;E     }=  6     static private void check_constant(int c1, int c2)     {a         if (c1 != c2) {=8             System.err.println("Db: constant mismatch");             System.exit(1);6	         }o     }b       static {         Db.load_db();   A         // Note: constant values are stored in DbConstants, which A         // is automatically generated.  Initializing constants inn>         // static code insulates users from the possibility of         // changing constants.
         //*         DB_CREATE = DbConstants.DB_CREATE;*         DB_NOMMAP = DbConstants.DB_NOMMAP;*         DB_THREAD = DbConstants.DB_THREAD;  &         DB_EXCL = DbConstants.DB_EXCL;*         DB_RDONLY = DbConstants.DB_RDONLY;2         DB_SEQUENTIAL = DbConstants.DB_SEQUENTIAL;0         DB_TEMPORARY = DbConstants.DB_TEMPORARY;.         DB_TRUNCATE = DbConstants.DB_TRUNCATE;  @         // These constants are not assigned, but rather checked.?         // Having initialized constants for these values allowsa?         // them to be used as case values in switch statements.l
         //A         check_constant(DB_INCOMPLETE, DbConstants.DB_INCOMPLETE);a=         check_constant(DB_KEYEMPTY, DbConstants.DB_KEYEMPTY);o=         check_constant(DB_KEYEXIST, DbConstants.DB_KEYEXIST); G         check_constant(DB_LOCK_DEADLOCK, DbConstants.DB_LOCK_DEADLOCK);cK         check_constant(DB_LOCK_NOTGRANTED, DbConstants.DB_LOCK_NOTGRANTED);;E         check_constant(DB_LOCK_NOTHELD, DbConstants.DB_LOCK_NOTHELD); =         check_constant(DB_NOTFOUND, DbConstants.DB_NOTFOUND);E  .         DB_INIT_CDB = DbConstants.DB_INIT_CDB;0         DB_INIT_LOCK = DbConstants.DB_INIT_LOCK;.         DB_INIT_LOG = DbConstants.DB_INIT_LOG;2         DB_INIT_MPOOL = DbConstants.DB_INIT_MPOOL;.         DB_INIT_TXN = DbConstants.DB_INIT_TXN;8         DB_MPOOL_PRIVATE = DbConstants.DB_MPOOL_PRIVATE;,         DB_RECOVER = DbConstants.DB_RECOVER;8         DB_RECOVER_FATAL = DbConstants.DB_RECOVER_FATAL;2         DB_TXN_NOSYNC = DbConstants.DB_TXN_NOSYNC;4         DB_USE_ENVIRON = DbConstants.DB_USE_ENVIRON;>         DB_USE_ENVIRON_ROOT = DbConstants.DB_USE_ENVIRON_ROOT;  2         DB_LOCK_NORUN = DbConstants.DB_LOCK_NORUN;6         DB_LOCK_DEFAULT = DbConstants.DB_LOCK_DEFAULT;4         DB_LOCK_OLDEST = DbConstants.DB_LOCK_OLDEST;4         DB_LOCK_RANDOM = DbConstants.DB_LOCK_RANDOM;8         DB_LOCK_YOUNGEST = DbConstants.DB_LOCK_YOUNGEST;  0         DB_DELIMITER = DbConstants.DB_DELIMITER;$         DB_DUP = DbConstants.DB_DUP;,         DB_DUPSORT = DbConstants.DB_DUPSORT;.         DB_FIXEDLEN = DbConstants.DB_FIXEDLEN;$         DB_PAD = DbConstants.DB_PAD;*         DB_RECNUM = DbConstants.DB_RECNUM;.         DB_RENUMBER = DbConstants.DB_RENUMBER;.         DB_SNAPSHOT = DbConstants.DB_SNAPSHOT;  4         DB_LOCK_NOWAIT = DbConstants.DB_LOCK_NOWAIT;6         DB_LOCK_UPGRADE = DbConstants.DB_LOCK_UPGRADE;8         DB_LOCK_CONFLICT = DbConstants.DB_LOCK_CONFLICT;  0         DB_LOCK_RW_N = DbConstants.DB_LOCK_RW_N;  .         DB_ARCH_ABS = DbConstants.DB_ARCH_ABS;0         DB_ARCH_DATA = DbConstants.DB_ARCH_DATA;.         DB_ARCH_LOG = DbConstants.DB_ARCH_LOG;  (         DB_AFTER = DbConstants.DB_AFTER;*         DB_APPEND = DbConstants.DB_APPEND;*         DB_BEFORE = DbConstants.DB_BEFORE;2         DB_CHECKPOINT = DbConstants.DB_CHECKPOINT;*         DB_CURLSN = DbConstants.DB_CURLSN;,         DB_CURRENT = DbConstants.DB_CURRENT;(         DB_FIRST = DbConstants.DB_FIRST;(         DB_FLUSH = DbConstants.DB_FLUSH;.         DB_GET_BOTH = DbConstants.DB_GET_BOTH;0         DB_GET_RECNO = DbConstants.DB_GET_RECNO;0         DB_JOIN_ITEM = DbConstants.DB_JOIN_ITEM;.         DB_KEYFIRST = DbConstants.DB_KEYFIRST;,         DB_KEYLAST = DbConstants.DB_KEYLAST;&         DB_LAST = DbConstants.DB_LAST;&         DB_NEXT = DbConstants.DB_NEXT;.         DB_NEXT_DUP = DbConstants.DB_NEXT_DUP;4         DB_NOOVERWRITE = DbConstants.DB_NOOVERWRITE;*         DB_NOSYNC = DbConstants.DB_NOSYNC;&         DB_PREV = DbConstants.DB_PREV;4         DB_RECORDCOUNT = DbConstants.DB_RECORDCOUNT;$         DB_SET = DbConstants.DB_SET;0         DB_SET_RANGE = DbConstants.DB_SET_RANGE;0         DB_SET_RECNO = DbConstants.DB_SET_RECNO;$         DB_RMW = DbConstants.DB_RMW;  6         DB_DBT_INTERNAL = DbConstants.DB_DBT_INTERNAL;2         DB_DBT_MALLOC = DbConstants.DB_DBT_MALLOC;4         DB_DBT_PARTIAL = DbConstants.DB_DBT_PARTIAL;4         DB_DBT_USERMEM = DbConstants.DB_DBT_USERMEM;     }  }    // end of Db.javanDB_CURRENT;    // Dbc.get(), Dbc.put(), DbLog.get() D     public static final int DB_FIRST;      // Dbc.get(), DbLog.get()9     public static final int DB_FLUSH;      // DbLog.put() A     public static final int DB_GET_BOTH;   // Db.get(), Db                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                