 /*- 7  * See the file LICENSE for redistribution information.   *  * Copyright (c) 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  *1  *	@(#)LockExample.java	10.4 (Sleepycat) 10/18/98   */    package com.sleepycat.examples;    import com.sleepycat.db.*; import java.io.InputStream; ! import java.io.InputStreamReader;  import java.io.IOException;  import java.io.PrintStream;  import java.util.Vector;   //< // An example of a program using DbLock and related classes. // class LockExample extends DbEnv  { 9     private static final String progname = "LockExample"; <     private static final String LOCK_HOME = "/var/tmp/lock";  #     public LockExample(String home)           throws DbException      { 8         super(home, null, Db.DB_CREATE|Db.DB_INIT_LOCK);%         set_error_stream(System.err); "         set_errpfx("LockExample");     }   @     // Prompts for a line, and keeps prompting until a non blank0     // line is returned.  Returns null on error.     //=     static public String askForLine(InputStreamReader reader, C                                     PrintStream out, String prompt)      {          String result = ""; 8         while (result != null && result.length() == 0) {             out.print(prompt);             out.flush();%             result = getLine(reader); 	         }          return result;     }   0     // Not terribly efficient, but does the job.5     // Works for reading a line from stdin or a file. 9     // Returns null on EOF.  If EOF appears in the middle <     // of a line, returns that line, then null on next call.     //:     static public String getLine(InputStreamReader reader)     { ,         StringBuffer b = new StringBuffer();         int c;
         try { <             while ((c = reader.read()) != -1 && c != '\n') {                 if (c != '\r')&                     b.append((char)c);
             } 	         } !         catch (IOException ioe) {              c = -1; 	         }   '         if (c == -1 && b.length() == 0)              return null;         else              return b.toString();     }        public void run()           throws DbException      {          long held;         int len = 0, locker;         int ret;          boolean did_get = false;         int lockid = 0; @         InputStreamReader in = new InputStreamReader(System.in);$         Vector locks = new Vector();  ,         DbLockTab lockTable = get_lk_info();          if (lockTable == null) {J             System.err.println("LockExample: lock table not initialized");             return; 	         }   
         //          // Accept lock requests.
         //          locker = lockTable.id();         for (held = 0;;) {5             String opbuf = askForLine(in, System.out, G                                       "Operation get/release [get]> ");              if (opbuf == null)                 break;               try { *                 if (opbuf.equals("get")) {&                     // Acquire a lock.>                     String objbuf = askForLine(in, System.out,K                                    "input object (text string) to lock> "); '                     if (objbuf == null)                          break;  #                     String lockbuf;                      do {<                         lockbuf = askForLine(in, System.out,N                                              "lock type read/write [read]> ");,                         if (lockbuf == null)"                             break;/                         len = lockbuf.length(); (                     } while (len >= 1 &&7                              !lockbuf.equals("read") && 7                              !lockbuf.equals("write"));   "                     int lock_type;;                     if (len <= 1 || lockbuf.equals("read")) 4                         lock_type = Db.DB_LOCK_READ;                     else5                         lock_type = Db.DB_LOCK_WRITE;   9                     Dbt dbt = new Dbt(objbuf.getBytes());                         DbLock lock;#                     did_get = true; C                     lock = lockTable.get(locker, Db.DB_LOCK_NOWAIT, 9                                          dbt, lock_type); *                     lockid = locks.size();+                     locks.addElement(lock);                  } else {&                     // Release a lock."                     String objbuf;7                     objbuf = askForLine(in, System.out, C                                         "input lock to release> "); '                     if (objbuf == null)                          break;  :                     lockid = Integer.parseInt(objbuf, 16);?                     if (lockid < 0 || lockid >= locks.size()) { P                         System.out.println("Lock #" + lockid + " out of range");!                         continue;                      } $                     did_get = false;B                     DbLock lock = (DbLock)locks.elementAt(lockid);(                     lock.put(lockTable);                 } <                 System.out.println("Lock #" + lockid + " " +G                                    (did_get ? "granted" : "released")); )                 held += did_get ? 1 : -1; 
             } %             catch (DbException dbe) { *                 switch (dbe.get_errno()) {(                 case Db.DB_LOCK_NOTHELD:D                     System.out.println("You do not hold the lock " +?                                        String.valueOf(lockid));                      break;+                 case Db.DB_LOCK_NOTGRANTED: ;                     System.out.println("Lock not granted");                      break;)                 case Db.DB_LOCK_DEADLOCK: =                     System.err.println("LockExample: lock_" + B                                        (did_get ? "get" : "put") +>                                        ": returned DEADLOCK");                     break;                 default:S                     System.err.println("LockExample: lock_get: " + dbe.toString());                  } 
             } 	         }          System.out.println(); J         System.out.println("Closing lock region " + String.valueOf(held) +*                            " locks held");     }        private static void usage()      { @         System.err.println("usage: LockExample [-u] [-h home]");         System.exit(1);      }   *     public static void main(String argv[])     {           String home = LOCK_HOME;"         boolean do_unlink = false;  /         for (int i = 0; i < argv.length; ++i) { '             if (argv[i].equals("-h")) { !                 home = argv[++i]; 
             } ,             else if (argv[i].equals("-u")) {!                 do_unlink = true; 
             }              else {                 usage();
             } 	         }   
         try {              if (do_unlink) {9                 LockExample temp = new LockExample(home); 0                 DbLockTab.unlink(home, 1, temp);
             }   4             LockExample app = new LockExample(home);             app.run();             app.appexit();	         } !         catch (DbException dbe) { C             System.err.println("AccessExample: " + dbe.toString()); 	         }          catch (Throwable t) { A             System.err.println("AccessExample: " + t.toString()); 	         } 4         System.out.println("LockExample completed");     }  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   