 /*- 7  * See the file LICENSE for redistribution information.   *  * Copyright (c) 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */  #include "config.h"    #ifndef lintL static const char sccsid[] = "@(#)java_DbEnv.cpp	10.7 (Sleepycat) 10/27/98"; #endif /* not lint */    #include <jni.h> #include <errno.h> #include <stdlib.h>  #include <string.h>    #include "db.h"  #include "java_util.h"# #include "com_sleepycat_db_DbEnv.h"    // XXX TODO:@ // A prefix_info is allocated and stuffed into the db_errpfx for> // every DB_ENV created.  It holds a little extra info that is: // needed to resurrect the environment to make a callback.? // Strictly speaking, we only need this stuffed in if db_errfcn C // is set, but it's easier to always allocate it in the constructor  // and know it's always there. //! // Note: We assume the following: B // We are the only one fiddling with the contents of db_errpfx and? // db_errcall.  In particular, db_errpfx and db_errcall are not 0 // initialized by appinit to some default value. // struct prefix_info {      JNIEnv *jnienv;      char *orig_prefix;     jobject dberrcall; };  D static void java_errcall_callback(const char *prefix, char *message) { ,     prefix_info *pi = (prefix_info *)prefix;  :     // Note: these error cases are "impossible", and would7     // normally warrant an exception.  However, without 0     // a jnienv, we cannot throw an exception...8     // We don't want to trap or exit, since the point of:     // this facility is for the user to completely control     // error situations.     //5     // TODO: find another way to indicate this error.      //     if (!pi)A         return;                 // These are really fatal asserts        if (!pi->dberrcall) A         return;                 // These are really fatal asserts        if (!pi->jnienv)A         return;                 // These are really fatal asserts   ?     jstring pre = get_java_string(pi->jnienv, pi->orig_prefix); 7     jstring msg = get_java_string(pi->jnienv, message); A     jclass errcall_class = get_class(pi->jnienv, name_DbErrcall); 9     jmethodID id = pi->jnienv->GetMethodID(errcall_class, %                            "errcall", F                            "(Ljava/lang/String;Ljava/lang/String;)V");     if (!id)         return;   <     pi->jnienv->CallVoidMethod(pi->dberrcall, id, pre, msg); }   G JAVADB_WO_ACCESS_BEFORE_APPINIT(DbEnv, jint, lorder, DB_ENV, db_lorder) I JAVADB_WO_ACCESS_BEFORE_APPINIT(DbEnv, jint, verbose, DB_ENV, db_verbose) I JAVADB_WO_ACCESS_BEFORE_APPINIT(DbEnv, jint, lk_1modes, DB_ENV, lk_modes) E JAVADB_WO_ACCESS_BEFORE_APPINIT(DbEnv, jint, lk_1max, DB_ENV, lk_max) K JAVADB_WO_ACCESS_BEFORE_APPINIT(DbEnv, jint, lk_1detect, DB_ENV, lk_detect) E JAVADB_WO_ACCESS_BEFORE_APPINIT(DbEnv, jint, lg_1max, DB_ENV, lg_max) P JAVADB_WO_ACCESS_BEFORE_APPINIT(DbEnv, jlong, mp_1mmapsize, DB_ENV, mp_mmapsize)H JAVADB_WO_ACCESS_BEFORE_APPINIT(DbEnv, jlong, mp_1size, DB_ENV, mp_size)E JAVADB_WO_ACCESS_BEFORE_APPINIT(DbEnv, jint, tx_1max, DB_ENV, tx_max)   7 JNIEXPORT void JNICALL Java_com_sleepycat_db_DbEnv_init !   (JNIEnv *jnienv, jobject jthis)  {       DB_ENV *dbenv = NEW(DB_ENV);%     memset(dbenv, 0, sizeof(DB_ENV)); '     prefix_info *pi = NEW(prefix_info);      pi->jnienv = 0;      pi->orig_prefix = 0;     pi->dberrcall = 0;'     dbenv->db_errpfx = (const char*)pi; 8     set_private_info(jnienv, name_DB_ENV, jthis, dbenv); }   : JNIEXPORT void JNICALL Java_com_sleepycat_db_DbEnv_appinit<   (JNIEnv *jnienv, /*DbEnv*/ jobject jthis, jstring homeDir,3    jobjectArray /*String[]*/ db_config, jint flags)  {      int err;.     DB_ENV *dbenv = get_DB_ENV(jnienv, jthis);,     LockedString dbhomeDir(jnienv, homeDir);6     LockedStringArray db_db_config(jnienv, db_config);  8     // Always turn on the thread flag for use with java.     flags |= DB_THREAD;   &     err = db_appinit(dbhomeDir.string,>                      (char *const *)db_db_config.string_array,#                      dbenv, flags); %     if (verify_return(jnienv, err)) { ;         jclass dbenvClass = get_class(jnienv, name_DB_ENV);          jobject obj;         if (dbenv->lk_info) { 8             obj = get_DbLockTab(jnienv, dbenv->lk_info);H             set_object_field(jnienv, dbenvClass, jthis, name_DB_LOCKTAB,.                              "lk_info_", obj);	         }          if (dbenv->lg_info) { 4             obj = get_DbLog(jnienv, dbenv->lg_info);D             set_object_field(jnienv, dbenvClass, jthis, name_DB_LOG,.                              "lg_info_", obj);	         }          if (dbenv->mp_info) { 6             obj = get_DbMpool(jnienv, dbenv->mp_info);F             set_object_field(jnienv, dbenvClass, jthis, name_DB_MPOOL,.                              "mp_info_", obj);	         }          if (dbenv->tx_info) { 7             obj = get_DbTxnMgr(jnienv, dbenv->tx_info); G             set_object_field(jnienv, dbenvClass, jthis, name_DB_TXNMGR, .                              "tx_info_", obj);	         }      }  }   : JNIEXPORT void JNICALL Java_com_sleepycat_db_DbEnv_appexit+   (JNIEnv *jnienv, /*DbEnv*/ jobject jthis)  {      int err;.     DB_ENV *dbenv = get_DB_ENV(jnienv, jthis);       if (dbenv) {          err = db_appexit(dbenv);8         set_private_info(jnienv, name_DB_ENV, jthis, 0);#         verify_return(jnienv, err);      }  }     E JNIEXPORT void JNICALL Java_com_sleepycat_db_DbEnv_set_1lk_1conflicts 5   (JNIEnv *jnienv, jobject jthis, jobjectArray array)  { .     DB_ENV *dbenv = get_DB_ENV(jnienv, jthis);0     static const char * const array_length_msg =/         "array length does not match lk_modes";   (     if (!verify_non_null(jnienv, dbenv))         return;        int len = dbenv->lk_modes;/     jsize jlen = jnienv->GetArrayLength(array);      if (jlen != len) {6         report_exception(jnienv, array_length_msg, 0);         return;      }   @     // TODO: possibly delete old contents, and delete this array?     // in destructor.  How to distinguish from "default" value?      //>     dbenv->lk_conflicts = NEW_ARRAY(unsigned char, len * len);       for (int i=0; i<len; i++) { C         jobject subArray = jnienv->GetObjectArrayElement(array, i); @         jnienv->GetByteArrayRegion((jbyteArray)subArray, 0, len,I                                    (jbyte *)&dbenv->lk_conflicts[i*len]);      }  }   F JNIEXPORT jint JNICALL Java_com_sleepycat_db_DbEnv_get_1version_1major)   (JNIEnv *jnienv, jclass /*this_class*/)  {      return DB_VERSION_MAJOR; }   F JNIEXPORT jint JNICALL Java_com_sleepycat_db_DbEnv_get_1version_1minor)   (JNIEnv *jnienv, jclass /*this_class*/)  {      return DB_VERSION_MINOR; }   F JNIEXPORT jint JNICALL Java_com_sleepycat_db_DbEnv_get_1version_1patch)   (JNIEnv *jnienv, jclass /*this_class*/)  {      return DB_VERSION_PATCH; }   J JNIEXPORT jstring JNICALL Java_com_sleepycat_db_DbEnv_get_1version_1string)   (JNIEnv *jnienv, jclass /*this_class*/)  { 3     return jnienv->NewStringUTF(DB_VERSION_STRING);  }   ! // See discussion on errpfx above ? JNIEXPORT void JNICALL Java_com_sleepycat_db_DbEnv_set_1errcall 2   (JNIEnv *jnienv, jobject jthis, jobject errcall) { .     DB_ENV *dbenv = get_DB_ENV(jnienv, jthis);  )     if (verify_non_null(jnienv, dbenv)) { ;         prefix_info *pi = (prefix_info*)(dbenv->db_errpfx);          if (pi->dberrcall) {3             jnienv->DeleteGlobalRef(pi->dberrcall); 	         }          if (errcall) {:             pi->dberrcall = jnienv->NewGlobalRef(errcall);6             dbenv->db_errcall = java_errcall_callback;              pi->jnienv = jnienv;	         }          else {             pi->dberrcall = 0;"             dbenv->db_errcall = 0;             pi->jnienv = 0; 	         }      }  }   > JNIEXPORT void JNICALL Java_com_sleepycat_db_DbEnv_set_1errpfx.   (JNIEnv *jnienv, jobject jthis, jstring str) { .     DB_ENV *dbenv = get_DB_ENV(jnienv, jthis);  )     if (verify_non_null(jnienv, dbenv)) { ;         prefix_info *pi = (prefix_info*)(dbenv->db_errpfx);          if (pi->orig_prefix)$             DELETE(pi->orig_prefix);         if (str)             pi->orig_prefix = A                 dup_string(jnienv->GetStringUTFChars(str, NULL));i         else              pi->orig_prefix = 0;     }f }r  ; JNIEXPORT void JNICALL Java_com_sleepycat_db_DbEnv_finalize !   (JNIEnv *jnienv, jobject jthis)" {).     DB_ENV *dbenv = get_DB_ENV(jnienv, jthis);     if (dbenv) {/         // Free any data related to DB_ENV heree9         prefix_info *pi = (prefix_info*)dbenv->db_errpfx;c         if (pi)"             DELETE(pi);_         DELETE(dbenv);     }/  8     // Shouldn't see this object again, but just in case4     set_private_info(jnienv, name_DB_ENV, jthis, 0); }ohat is: // needed to resurrect the environment to make a callback.? // Strictly speaking, we only need this stuffed in if db_errfcn C // is set, but it's easier to always allocate it in the constructor  // and know it's always there. //! // Note: We assume the following: B // We are the only one fiddling with the contents of db_errpfx and? // db_errcall.  In particular, db_errpfx and db_errcall are not 0 // initialized by                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 