 /*- 7  * See the file LICENSE for redistribution information.   *  * Copyright (c) 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */  #include "config.h"    #ifndef lintL static const char sccsid[] = "@(#)java_util.cpp	10.13 (Sleepycat) 10/28/98"; #endif /* not lint */    #include "java_util.h" #include <errno.h> #include <stdlib.h>  #include <string.h>    #ifdef WIN32  #define sys_errlist _sys_errlist #define sys_nerr _sys_nerr #endif  A /****************************************************************   *.  * Utility functions used by "glue" functions.  *  */   B /* Use our own malloc for any objects allocated via DB_DBT_MALLOC,=  * since we must free them in the same library address space.   */ 
 extern "C"" void * java_db_malloc(size_t size) {      return malloc(size); }   B /* Get the private data from a Db* object as a (64 bit) java long.  */ B jlong get_private_long_info(JNIEnv *jnienv, const char *classname,(                             jobject obj) { 
     if (!obj)          return 0;   2     jclass dbClass = get_class(jnienv, classname);D     jfieldID id = jnienv->GetFieldID(dbClass, "private_info_", "J");)     return jnienv->GetLongField(obj, id);  }   * /* Get the private data from a Db* object.E  * The private data is stored in the object as a Java long (64 bits), D  * which is long enough to store a pointer on current architectures.  */ = void *get_private_info(JNIEnv *jnienv, const char *classname, #                        jobject obj)  {      long_to_ptr lp; 
     if (!obj)          return 0; A     lp.java_long = get_private_long_info(jnienv, classname, obj);      return lp.ptr; }   @ /* Set the private data in a Db* object as a (64 bit) java long.  */ A void set_private_long_info(JNIEnv *jnienv, const char *classname, 4                            jobject obj, jlong value) { 2     jclass dbClass = get_class(jnienv, classname);D     jfieldID id = jnienv->GetFieldID(dbClass, "private_info_", "J");)     jnienv->SetLongField(obj, id, value);  }   ( /* Set the private data in a Db* object.E  * The private data is stored in the object as a Java long (64 bits), D  * which is long enough to store a pointer on current architectures.  */ < void set_private_info(JNIEnv *jnienv, const char *classname,/                       jobject obj, void *value)  {      long_to_ptr lp;      lp.java_long = 0;      lp.ptr = value; @     set_private_long_info(jnienv, classname, obj, lp.java_long); }    /*?  * Given a non-qualified name (e.g. "foo"), get the class handl =  * for the fully qualified name (e.g. "com.sleepycat.db.foo")   */ 7 jclass get_class(JNIEnv *jnienv, const char *classname)  { 7     // TODO: cache these (remember to use NewGlobalRef) )     char fullname[128] = DB_PACKAGE_NAME;       strcat(fullname, classname);'     return jnienv->FindClass(fullname);  }   + /* Set an individual field in a Db* object. &  * The field must be a DB object type.  */ ; void set_object_field(JNIEnv *jnienv, jclass class_of_this, B                       jobject jthis, const char *object_classname,=                       const char *name_of_field, jobject obj)  {      char signature[512];       strcpy(signature, "L"); '     strcat(signature, DB_PACKAGE_NAME); (     strcat(signature, object_classname);     strcat(signature, ";");   O     jfieldID id  = jnienv->GetFieldID(class_of_this, name_of_field, signature); +     jnienv->SetObjectField(jthis, id, obj);  }   + /* Set an individual field in a Db* object. %  * The field must be an integer type.   */ 8 void set_int_field(JNIEnv *jnienv, jclass class_of_this,H                    jobject jthis, const char *name_of_field, jint value) { I     jfieldID id  = jnienv->GetFieldID(class_of_this, name_of_field, "I"); *     jnienv->SetIntField(jthis, id, value); }   + /* Set an individual field in a Db* object. %  * The field must be an integer type.   */ 9 void set_long_field(JNIEnv *jnienv, jclass class_of_this, I                    jobject jthis, const char *name_of_field, jlong value)  { I     jfieldID id  = jnienv->GetFieldID(class_of_this, name_of_field, "J"); +     jnienv->SetLongField(jthis, id, value);  }   + /* Set an individual field in a Db* object. %  * The field must be an integer type.   */ 8 void set_lsn_field(JNIEnv *jnienv, jclass class_of_this,J                    jobject jthis, const char *name_of_field, DB_LSN value) { ?     set_object_field(jnienv, class_of_this, jthis, name_DB_LSN, >                      name_of_field, get_DbLsn(jnienv, value)); }   - /* Report an exception back to the java side.   */ @ void report_exception(JNIEnv *jnienv, const char *text, int err) { 7     jstring textString = get_java_string(jnienv, text);      jclass dbexcept;      if (err == DB_RUNRECOVERY) {:         dbexcept = get_class(jnienv, name_DB_RUNRECOVERY);     } 
     else {8         dbexcept = get_class(jnienv, name_DB_EXCEPTION);     } C     jmethodID constructId = jnienv->GetMethodID(dbexcept, "<init>", G                                              "(Ljava/lang/String;I)V"); ?     jthrowable obj = (jthrowable)jnienv->AllocObject(dbexcept); >     jnienv->CallVoidMethod(obj, constructId, textString, err);     jnienv->Throw(obj);  }   C /* If the object is null, report an exception and return false (0),   * otherwise return true (1).   */ . int verify_non_null(JNIEnv *jnienv, void *obj) {      if (obj == NULL) {8         report_exception(jnienv, "null object", EINVAL);         return 0;      } 
     return 1;  }   H /* If the DB_ENV* is null or has already been initialized (via appinit),G  * report an exception and return false (0), otherwise return true (1). C  * Setting a field in the environment after appinit has been called A  * will never have any effect, so we raise the error to alert the )  * user to a potential configuration bug.   */ - int verify_dbenv(JNIEnv *jnienv, DB_ENV *env)  { '     if (verify_non_null(jnienv, env)) { 1         if ((env->flags & DB_ENV_APPINIT) != 0) { M             report_exception(jnienv, "DbEnv.appinit already called", EINVAL);              return 0; 	         }      } 
     return 1;  }   K /* If the error code is non-zero, report an exception and return false (0),   * otherwise return true (1).   */ * int verify_return(JNIEnv *jnienv, int err) {      char *errstring;       if (err != 0) { =         if (err > 0 && (errstring = strerror(err)) != NULL) { 5             report_exception(jnienv, errstring, err); 	         }          else {             char buffer[64];-             sprintf(buffer, "error %d", err); 2             report_exception(jnienv, buffer, err);	         }          return 0;      } 
     return 1;  }   H /* Create an object of the given class, calling its default constructor.  */ E jobject create_default_object(JNIEnv *jnienv, const char *class_name)  { 3     jclass dbclass = get_class(jnienv, class_name); A     jmethodID id = jnienv->GetMethodID(dbclass, "<init>", "()V"); 4     jobject object = jnienv->NewObject(dbclass, id);     return object; }   ? /* Convert an DB object to a Java encapsulation of that object. D  * Note: This implementation creates a new Java object on each call,H  * so it is generally useful when a new DB object has just been created.  */ K jobject convert_object(JNIEnv *jnienv, const char *class_name, void *dbobj)  {      if (!dbobj)          return 0;   ;     jobject jo = create_default_object(jnienv, class_name); 4     set_private_info(jnienv, class_name, jo, dbobj);     return jo; }    /* Create a copy of the string  */ ! char *dup_string(const char *str)  { 2     char *retval = NEW_ARRAY(char, strlen(str)+1);     strcpy(retval, str);     return retval; }   - /* Create a java string from the given string   */ ; jstring get_java_string(JNIEnv *jnienv, const char* string)  {      if (string == 0)         return 0; (     return jnienv->NewStringUTF(string); }    /* Storage allocator  */  void *allocMemory(size_t n)  {      return malloc(n);  }    void freeMemory(void *p) {      free(p); }   B /* Convert a java object to the various C pointers they represent.  */ ' DB *get_DB(JNIEnv *jnienv, jobject obj)  { 8     return (DB *)get_private_info(jnienv, name_DB, obj); }*  = DB_BTREE_STAT *get_DB_BTREE_STAT(JNIEnv *jnienv, jobject obj)s {sN     return (DB_BTREE_STAT *)get_private_info(jnienv, name_DB_BTREE_STAT, obj); }(  ) DBC *get_DBC(JNIEnv *jnienv, jobject obj)  {d:     return (DBC *)get_private_info(jnienv, name_DBC, obj); }>  / DB_ENV *get_DB_ENV(JNIEnv *jnienv, jobject obj)d {W@     return (DB_ENV *)get_private_info(jnienv, name_DB_ENV, obj); }e  1 DB_INFO *get_DB_INFO(JNIEnv *jnienv, jobject obj)* {*B     return (DB_INFO *)get_private_info(jnienv, name_DB_INFO, obj); }*  : // A DB_LOCK is just a size_t, so no need for indirection.0 DB_LOCK get_DB_LOCK(JNIEnv *jnienv, jobject obj) {eE     return (DB_LOCK)get_private_long_info(jnienv, name_DB_LOCK, obj);t }z  7 DB_LOCKTAB *get_DB_LOCKTAB(JNIEnv *jnienv, jobject obj)d { H     return (DB_LOCKTAB *)get_private_info(jnienv, name_DB_LOCKTAB, obj); }(  / DB_LOG *get_DB_LOG(JNIEnv *jnienv, jobject obj)  { @     return (DB_LOG *)get_private_info(jnienv, name_DB_LOG, obj); }   9 DB_LOG_STAT *get_DB_LOG_STAT(JNIEnv *jnienv, jobject obj)D { J     return (DB_LOG_STAT *)get_private_info(jnienv, name_DB_LOG_STAT, obj); }g  / DB_LSN *get_DB_LSN(JNIEnv *jnienv, jobject obj)m {D@     return (DB_LSN *)get_private_info(jnienv, name_DB_LSN, obj); }g  3 DB_MPOOL *get_DB_MPOOL(JNIEnv *jnienv, jobject obj)r { D     return (DB_MPOOL *)get_private_info(jnienv, name_DB_MPOOL, obj); }t  ? DB_MPOOL_FSTAT *get_DB_MPOOL_FSTAT(JNIEnv *jnienv, jobject obj)o {tP     return (DB_MPOOL_FSTAT *)get_private_info(jnienv, name_DB_MPOOL_FSTAT, obj); }n  = DB_MPOOL_STAT *get_DB_MPOOL_STAT(JNIEnv *jnienv, jobject obj)e {iN     return (DB_MPOOL_STAT *)get_private_info(jnienv, name_DB_MPOOL_STAT, obj); }o  / DB_TXN *get_DB_TXN(JNIEnv *jnienv, jobject obj)  { @     return (DB_TXN *)get_private_info(jnienv, name_DB_TXN, obj); }c  5 DB_TXNMGR *get_DB_TXNMGR(JNIEnv *jnienv, jobject obj)e {DF     return (DB_TXNMGR *)get_private_info(jnienv, name_DB_TXNMGR, obj); }   9 DB_TXN_STAT *get_DB_TXN_STAT(JNIEnv *jnienv, jobject obj)a {dJ     return (DB_TXN_STAT *)get_private_info(jnienv, name_DB_TXN_STAT, obj); }   . DBT_info *get_DBT(JNIEnv *jnienv, jobject obj) {o?     return (DBT_info *)get_private_info(jnienv, name_DBT, obj);  }     B /* Convert a C pointer to the various Java objects they represent.  */_= jobject get_DbBtreeStat(JNIEnv *jnienv, DB_BTREE_STAT *dbobj)e { =     return convert_object(jnienv, name_DB_BTREE_STAT, dbobj);i }n  + jobject get_Dbc(JNIEnv *jnienv, DBC *dbobj)t {f3     return convert_object(jnienv, name_DBC, dbobj);* }   8 jobject get_DbLockTab(JNIEnv *jnienv, DB_LOCKTAB *dbobj) { :     return convert_object(jnienv, name_DB_LOCKTAB, dbobj); }r  0 jobject get_DbLog(JNIEnv *jnienv, DB_LOG *dbobj) {,6     return convert_object(jnienv, name_DB_LOG, dbobj); }   9 jobject get_DbLogStat(JNIEnv *jnienv, DB_LOG_STAT *dbobj)m { ;     return convert_object(jnienv, name_DB_LOG_STAT, dbobj);e }   4 // LSNs are different since they are really normally3 // treated as by-value objects.  We actually create 3 // a pointer to the LSN and store that, deleting it  // when the LSN is GC'd. /// jobject get_DbLsn(JNIEnv *jnienv, DB_LSN dbobj)P {A     DB_LSN *lsnp = NEW(DB_LSN);      *lsnp = dbobj;5     return convert_object(jnienv, name_DB_LSN, lsnp);n }G  4 jobject get_DbMpool(JNIEnv *jnienv, DB_MPOOL *dbobj) {n8     return convert_object(jnienv, name_DB_MPOOL, dbobj); }i  ? jobject get_DbMpoolFStat(JNIEnv *jnienv, DB_MPOOL_FSTAT *dbobj)  {*>     return convert_object(jnienv, name_DB_MPOOL_FSTAT, dbobj); }   = jobject get_DbMpoolStat(JNIEnv *jnienv, DB_MPOOL_STAT *dbobj)) { =     return convert_object(jnienv, name_DB_MPOOL_STAT, dbobj);f }d  0 jobject get_DbTxn(JNIEnv *jnienv, DB_TXN *dbobj) { 6     return convert_object(jnienv, name_DB_TXN, dbobj); }e  6 jobject get_DbTxnMgr(JNIEnv *jnienv, DB_TXNMGR *dbobj) {v9     return convert_object(jnienv, name_DB_TXNMGR, dbobj);t }h  9 jobject get_DbTxnStat(JNIEnv *jnienv, DB_TXN_STAT *dbobj)D { ;     return convert_object(jnienv, name_DB_TXN_STAT, dbobj);  }n  A /****************************************************************e  *#  * Implementation of class DBT_infoe  *  */e DBT_info::DBT_info()
 :   array_(0)I ,   offset_(0) { '     memset((DBT*)this, 0, sizeof(DBT));t }h  & void DBT_info::release(JNIEnv *jnienv) {      if (array_ != 0) {(         jnienv->DeleteGlobalRef(array_);     }  }    DBT_info::~DBT_info()d {e }b  A /****************************************************************i  *$  * Implementation of class LockedDBT  *  */o> LockedDBT::LockedDBT(JNIEnv *jnienv, jobject obj, OpKind kind)     : env_(jnienv)     , obj_(obj)e     , has_error_(0)=     , kind_(kind)      , java_array_len_(0)     , java_data_(0)N     /* dbt initialized below */  { >     dbt = (DBT_info *)get_private_info(jnienv, name_DBT, obj);(     if (!verify_non_null(jnienv, dbt)) {         has_error_ = 1;          return;      }        if (kind == outOp &&?         (dbt->flags & (DB_DBT_USERMEM | DB_DBT_MALLOC)) == 0) {b          report_exception(jnienv,N                          "Dbt.flags must set DB_DBT_USERMEM or DB_DBT_MALLOC",                          0);         has_error_ = 1;n         return;o     }e  9     if ((dbt->flags & DB_DBT_USERMEM) || kind != outOp) {   D         // If writing with DB_DBT_USERMEM or it's a set (or get/set)A         // operation, then the data should point to a java array. C         // Note that outOp means data is coming out of the databaseaD         // (it's a get).  inOp means data is going into the database*         // (either a put, or a key input).
         //         if (!dbt->array_) { <             report_exception(jnienv, "Dbt.data is null", 0);             has_error_ = 1;c             return;*	         }i  "         // Verify other parameters
         //>         java_array_len_ = jnienv->GetArrayLength(dbt->array_);          if (dbt->offset_ < 0 ) {>             report_exception(jnienv, "Dbt.offset illegal", 0);             has_error_ = 1;              return; 	         } 9         if (dbt->ulen + dbt->offset_ > java_array_len_) {o$             report_exception(jnienv,Q                            "Dbt.ulen + Dbt.offset greater than array length", 0);*             has_error_ = 1;0             return; 	         }s  E         java_data_ = jnienv->GetByteArrayElements(dbt->array_, NULL);e.         dbt->data = java_data_ + dbt->offset_;     } 
     else {  :         // If writing with DB_DBT_MALLOC, then the data is         // allocated by DB.,
         //         dbt->data = 0;     }0 }   C // The LockedDBT destructor is called when the java handler returnsaH // to the user, since that's when the LockedDBT objects go out of scope.E // Since it is thus called after any call to the underlying database,jC // it copies any information from temporary structures back to user K // accessible arrays, and of course must free memory and remove references.  // LockedDBT::~LockedDBT()e {a0     // If there was an error in the constructor,(     // everything is already cleaned up.     //     if (has_error_),         return;e  9     if ((dbt->flags & DB_DBT_USERMEM) || kind_ == inOp) {   D         // If writing with DB_DBT_USERMEM or it's a set (or get/set)E         // operation, then the data may be already in the java array,e5         // in which case, we just need to release it.t=         // If DB didn't put it in the array (indicated by the*2         // dbt->data changing), we need to do that
         //)         jbyte *data = (jbyte *)dbt->data;a         data -= dbt->offset_;r!         if (data != java_data_) { Q             env_->SetByteArrayRegion(dbt->array_, dbt->offset_, dbt->ulen, data);N	         }vC         env_->ReleaseByteArrayElements(dbt->array_, java_data_, 0);          dbt->data = 0;     }(8     if ((dbt->flags & DB_DBT_MALLOC) && kind_ != inOp) {  E         // If writing with DB_DBT_MALLOC, then the data was allocated)C         // by DB.  If dbt->data is zero, it means an error occurredo3         // (and should have been already reported).n
         //         if (dbt->data) {  *             // Release any old references.             //             dbt->release(env_);,  &             dbt->array_ = (jbyteArray)B                 env_->NewGlobalRef(env_->NewByteArray(dbt->size));             dbt->offset_ = 0;tT             env_->SetByteArrayRegion(dbt->array_, 0, dbt->size, (jbyte *)dbt->data);             free(dbt->data);             dbt->data = 0;	         }t     }e }f  A /****************************************************************n  *'  * Implementation of class LockedStringe  *  */_8 LockedString::LockedString(JNIEnv *jnienv, jstring jstr)     : env_(jnienv)     , jstr_(jstr). {B     if (jstr == 0)         string = 0;      else7         string = jnienv->GetStringUTFChars(jstr, NULL);_ }K   LockedString::~LockedString()B {C     if (jstr_)3         env_->ReleaseStringUTFChars(jstr_, string);p }a    A /****************************************************************   *,  * Implementation of class LockedStringArray  *  */eF LockedStringArray::LockedStringArray(JNIEnv *jnienv, jobjectArray arr)     : env_(jnienv)     , arr_(arr)e     , string_array(0)_ {v!     typedef const char *conststr;o       if (arr != 0) {_0         int count = jnienv->GetArrayLength(arr);4         string_array = NEW_ARRAY(conststr, count+1);%         for (int i=0; i<count; i++) { J             jstring jstr = (jstring)jnienv->GetObjectArrayElement(arr, i);             if (jstr == 0) {                 //B                 // An embedded null in the string array is treated"                 // as an endpoint.                 //$                 string_array[i] = 0;                 break;
             }i             else {H                 string_array[i] = jnienv->GetStringUTFChars(jstr, NULL);
             }I	         },          string_array[count] = 0;     }g }p  ' LockedStringArray::~LockedStringArray()  {B     if (arr_) {X/         int count = env_->GetArrayLength(arr_);n%         for (int i=0; i<count; i++) {n%             if (string_array[i] == 0)                  break;I             jstring jstr = (jstring)env_->GetObjectArrayElement(arr_, i);n?             env_->ReleaseStringUTFChars(jstr, string_array[i]);v	         }b         DELETE(string_array);g     }a }io(jnienv, name_DBT, obj);  }     B /* Convert a C pointer to the various Java objects they represent.  */_= jobject get_DbBtreeStat(JNIEnv *jnienv, DB_BTREE_STAT *dbobj)e { =     return convert_object(jnienv, name_DB_BTREE_STAT, dbobj);i }n  + jobject get_Dbc(JNIEnv *jnienv, DBC *d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                