 /*- 7  * See the file LICENSE for redistribution information.   *  * Copyright (c) 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  *-  *	@(#)java_util.h	10.12 (Sleepycat) 12/16/98   */    #ifndef _JAVA_UTIL_H_  #define _JAVA_UTIL_H_    #include "db.h"  #include <jni.h>4 #include <string.h>             // needed for memset   #ifdef _MSC_VER   ; // These are level 4 warnings that are explicitly disabled. B // With Visual C++, by default you do not see above level 3 unless> // you use /W4.  But we like to compile with the highest level" // warnings to catch other errors. // // 4201: nameless struct/union5 //       triggered by standard include file <winnt.h>  //N // 4244: '=' : convert from '__int64' to 'unsigned int', possible loss of dataE //       results from making size_t data members correspond to jlongs  //6 // 4514: unreferenced inline function has been removed2 //       jni.h defines methods that are not called //+ // 4127: conditional expression is constant ? //       occurs because of arg in JAVADB_RW_ACCESS_STRING macro  //L // 4100: unreferenced formal parameters: TODO: remove after everythings done //2 #pragma warning(disable: 4100 4244 4201 4514 4127)   #endif  + #define DB_PACKAGE_NAME "com/sleepycat/db/"   C /* Union to convert longs to pointers (see {get,set}_private_info).   */  typedef union {      jlong java_long;     void *ptr; } long_to_ptr;  A /****************************************************************   *!  * DBT_info and LockedDBT classes   *A  * A DBT_info is created whenever a Dbt (java) object is created, =  * and a pointer to it is stored in its private info storage. ?  * It is subclassed from DBT, because we must retain some extra =  * information in it while it is in use.  In particular, when A  * a java array is associated with it, we need to keep a Globally ?  * Locked reference to it so it is not GC'd.  This reference is !  * released when the Dbt is GC'd.   *?  * In contrast, a LockedDBT class is only in existence during a >  * single native call to the DB API.  Its constructor's job is>  * to temporarily convert any java array found in the DBT_info@  * to actual bytes in memory that remain locked in place.  These?  * bytes are used during the call to the underlying DB C layer, 9  * and are released and/or copied back by the destructor. :  * Thus, a LockedDBT must be declared as a stack object to  * function properly.   */    /*  *   * Declaration of class DBT_info  *  * See description above.   */  class DBT_info : public DBT  {  public:      DBT_info();      ~DBT_info();!     void release(JNIEnv *jnienv);        jbyteArray array_;     int offset_; };   /*,  * Used internally by LockedDBT constructor.  */ E enum OpKind { inOp,     // setting data in database (passing data in) D               outOp,    // getting data from database to user memory4               inOutOp   // both getting/setting data };   /*  *!  * Declaration of class LockedDBT   *  * See description above.   */  class LockedDBT  {  public: >     // After the constructor returns, if has_error() is false,$     // then dbt must be initialized.     //8     LockedDBT(JNIEnv *jnienv, jobject obj, OpKind kind);     ~LockedDBT(); .     int has_error()     { return has_error_; }   public:      DBT_info *dbt;     int java_array_len_;   private:     JNIEnv *env_;      jobject obj_;      jbyte *java_data_;     int has_error_;      OpKind kind_;  };  A /****************************************************************   *$  * Declaration of class LockedString  *9  * Given a java jstring object, this gets an encapsulated @  * const char *.  When the LockedString object is destroyed, the  * char * array is released.  */  class LockedString {  public: /     LockedString(JNIEnv *jnienv, jstring jstr);      ~LockedString();   public:      const char *string;  private:     JNIEnv *env_;      jstring jstr_; };  A /****************************************************************   *)  * Declaration of class LockedStringArray   *>  * Given a java jobjectArray object (that must be a String[]),>  * we extract the individual strings and build a const char **A  * When the LockedStringArray object is destroyed, the individual   * strings are released.  */  class LockedStringArray  {  public: 8     LockedStringArray(JNIEnv *jnienv, jobjectArray arr);     ~LockedStringArray();    public:      const char **string_array; private:     JNIEnv *env_;      jobjectArray arr_; };  A /****************************************************************   *>  * Utility functions and definitions used by "glue" functions.  *  */    #define NOT_IMPLEMENTED(str) \E 	report_exception(jnienv, str /*concatenate*/ ": not implemented", 0)   B /* Use our own malloc for any objects allocated via DB_DBT_MALLOC,=  * since we must free them in the same library address space.   */ 
 extern "C"# void * java_db_malloc(size_t size);   B /* Get the private data from a Db* object as a (64 bit) java long.  */ B jlong get_private_long_info(JNIEnv *jnienv, const char *classname,)                             jobject obj);   * /* Get the private data from a Db* object.E  * The private data is stored in the object as a Java long (64 bits), D  * which is long enough to store a pointer on current architectures.  */ = void *get_private_info(JNIEnv *jnienv, const char *classname, $                        jobject obj);  @ /* Set the private data in a Db* object as a (64 bit) java long.  */ A void set_private_long_info(JNIEnv *jnienv, const char *classname, 5                            jobject obj, jlong value);   ( /* Set the private data in a Db* object.E  * The private data is stored in the object as a Java long (64 bits), D  * which is long enough to store a pointer on current architectures.  */ < void set_private_info(JNIEnv *jnienv, const char *classname,0                       jobject obj, void *value);   /*?  * Given a non-qualified name (e.g. "foo"), get the class handl =  * for the fully qualified name (e.g. "com.sleepycat.db.foo")   */ 8 jclass get_class(JNIEnv *jnienv, const char *classname);  + /* Set an individual field in a Db* object. &  * The field must be a DB object type.  */ ; void set_object_field(JNIEnv *jnienv, jclass class_of_this, B                       jobject jthis, const char *object_classname,>                       const char *name_of_field, jobject obj);  + /* Set an individual field in a Db* object. %  * The field must be an integer type.   */ 8 void set_int_field(JNIEnv *jnienv, jclass class_of_this,I                    jobject jthis, const char *name_of_field, jint value);   + /* Set an individual field in a Db* object. %  * The field must be an integer type.   */ 9 void set_long_field(JNIEnv *jnienv, jclass class_of_this, K                     jobject jthis, const char *name_of_field, jlong value);   + /* Set an individual field in a Db* object. #  * The field must be an DbLsn type.   */ 8 void set_lsn_field(JNIEnv *jnienv, jclass class_of_this,K                    jobject jthis, const char *name_of_field, DB_LSN value);   - /* Report an exception back to the java side.   */ A void report_exception(JNIEnv *jnienv, const char *text, int err);   C /* If the object is null, report an exception and return false (0),   * otherwise return true (1).   */ / int verify_non_null(JNIEnv *jnienv, void *obj);   H /* If the DB_ENV* is null or has already been initialized (via appinit),G  * report an exception and return false (0), otherwise return true (1). C  * Setting a field in the environment after appinit has been called A  * will never have any effect, so we raise the error to alert the )  * user to a potential configuration bug.   */ . int verify_dbenv(JNIEnv *jnienv, DB_ENV *env);  K /* If the error code is non-zero, report an exception and return false (0),   * otherwise return true (1).   */ + int verify_return(JNIEnv *jnienv, int err);   H /* Create an object of the given class, calling its default constructor.  */ F jobject create_default_object(JNIEnv *jnienv, const char *class_name);  ? /* Convert an DB object to a Java encapsulation of that object.*D  * Note: This implementation creates a new Java object on each call,H  * so it is generally useful when a new DB object has just been created.  */@L jobject convert_object(JNIEnv *jnienv, const char *class_name, void *dbobj);   /* Create a copy of the string  */ " char *dup_string(const char *str);  - /* Create a java string from the given stringS  */ < jstring get_java_string(JNIEnv *jnienv, const char* string);   /* Storage allocator  */f void *allocMemory(size_t n); void freeMemory(void *p);     B /* Convert a java object to the various C pointers they represent.  */r@ DB             *get_DB            (JNIEnv *jnienv, jobject obj);@ DB_BTREE_STAT  *get_DB_BTREE_STAT (JNIEnv *jnienv, jobject obj);@ DBC            *get_DBC           (JNIEnv *jnienv, jobject obj);@ DB_ENV         *get_DB_ENV        (JNIEnv *jnienv, jobject obj);@ DB_INFO        *get_DB_INFO       (JNIEnv *jnienv, jobject obj);M DB_LOCK         get_DB_LOCK       (JNIEnv *jnienv, jobject obj); // not a ptrt@ DB_LOCKTAB     *get_DB_LOCKTAB    (JNIEnv *jnienv, jobject obj);@ DB_LOG         *get_DB_LOG        (JNIEnv *jnienv, jobject obj);@ DB_LOG_STAT    *get_DB_LOG_STAT   (JNIEnv *jnienv, jobject obj);@ DB_LSN         *get_DB_LSN        (JNIEnv *jnienv, jobject obj);@ DB_MPOOL       *get_DB_MPOOL      (JNIEnv *jnienv, jobject obj);@ DB_MPOOL_FSTAT *get_DB_MPOOL_FSTAT(JNIEnv *jnienv, jobject obj);@ DB_MPOOL_STAT  *get_DB_MPOOL_STAT (JNIEnv *jnienv, jobject obj);@ DB_TXN         *get_DB_TXN        (JNIEnv *jnienv, jobject obj);@ DB_TXNMGR      *get_DB_TXNMGR     (JNIEnv *jnienv, jobject obj);@ DB_TXN_STAT    *get_DB_TXN_STAT   (JNIEnv *jnienv, jobject obj);@ DBT_info       *get_DBT           (JNIEnv *jnienv, jobject obj);  B /* Convert a C object to the various java pointers they represent.  */v@ jobject get_DbBtreeStat  (JNIEnv *jnienv, DB_BTREE_STAT *dbobj);6 jobject get_Dbc          (JNIEnv *jnienv, DBC *dbobj);= jobject get_DbLockTab    (JNIEnv *jnienv, DB_LOCKTAB *dbobj);o9 jobject get_DbLog        (JNIEnv *jnienv, DB_LOG *dbobj);i> jobject get_DbLogStat    (JNIEnv *jnienv, DB_LOG_STAT *dbobj);8 jobject get_DbLsn        (JNIEnv *jnienv, DB_LSN dbobj);; jobject get_DbMpool      (JNIEnv *jnienv, DB_MPOOL *dbobj);b@ jobject get_DbMpoolStat  (JNIEnv *jnienv, DB_MPOOL_STAT *dbobj);A jobject get_DbMpoolFStat (JNIEnv *jnienv, DB_MPOOL_FSTAT *dbobj);L9 jobject get_DbTxn        (JNIEnv *jnienv, DB_TXN *dbobj); < jobject get_DbTxnMgr     (JNIEnv *jnienv, DB_TXNMGR *dbobj);> jobject get_DbTxnStat    (JNIEnv *jnienv, DB_TXN_STAT *dbobj);   // The java names of DB classes . const char * const name_DB             = "Db";7 const char * const name_DB_BTREE_STAT  = "DbBtreeStat";*/ const char * const name_DBC            = "Dbc";*1 const char * const name_DB_ENV         = "DbEnv";b7 const char * const name_DB_EXCEPTION   = "DbException";g2 const char * const name_DB_INFO        = "DbInfo";2 const char * const name_DB_LOCK        = "DbLock";5 const char * const name_DB_LOCKTAB     = "DbLockTab";i6 const char * const name_DB_LOCK_STAT   = "DbLockStat";1 const char * const name_DB_LOG         = "DbLog";a5 const char * const name_DB_LOG_STAT    = "DbLogStat"; 1 const char * const name_DB_LSN         = "DbLsn";;3 const char * const name_DB_MPOOL       = "DbMpool";n8 const char * const name_DB_MPOOL_FSTAT = "DbMpoolFStat";7 const char * const name_DB_MPOOL_STAT  = "DbMpoolStat";cB const char * const name_DB_RUNRECOVERY = "DbRunRecoveryException";/ const char * const name_DBT            = "Dbt";*1 const char * const name_DB_TXN         = "DbTxn";o4 const char * const name_DB_TXNMGR      = "DbTxnMgr";5 const char * const name_DB_TXN_STAT    = "DbTxnStat";t@ const char * const name_DB_TXN_STAT_ACTIVE = "DbTxnStat$Active";5 const char * const name_DbErrcall      = "DbErrcall";d  > const char * const string_signature    = "Ljava/lang/String;";    M #define JAVADB_RO_ACCESS(j_class, j_fieldtype, j_field, c_type, c_field)    \ M extern "C" JNIEXPORT j_fieldtype JNICALL                                    \*M   Java_com_sleepycat_db_##j_class##_get_1##j_field                          \cM   (JNIEnv *jnienv, jobject jthis)                                           \cM {                                                                           \ M     c_type *db_this = get_##c_type(jnienv, jthis);                          \oM                                                                             \ M     if (verify_non_null(jnienv, db_this)) {                                 \oM         return db_this->c_field;                                            \*M     }                                                                       \ M     return 0;                                                               \c }n  M #define JAVADB_WO_ACCESS(j_class, j_fieldtype, j_field, c_type, c_field)    \ M extern "C" JNIEXPORT void JNICALL                                           \eM   Java_com_sleepycat_db_##j_class##_set_1##j_field                          \eM   (JNIEnv *jnienv, jobject jthis, j_fieldtype value)                        \iM {                                                                           \ M     c_type *db_this = get_##c_type(jnienv, jthis);                          \oM                                                                             \aM     if (verify_non_null(jnienv, db_this)) {                                 \,M         db_this->c_field = value;                                           \iM     }                                                                       \_ }o  J // This is a variant of the JAVADB_WO_ACCESS macro to define a simple set_I // method, but it raises an exception if the environment has already beenaC // initialized.  This is considered a configuration error (and thusiF // serious enough for an unconditional exception) because user changesB // to the environment structure after appinit will have no effect. //M #define JAVADB_WO_ACCESS_BEFORE_APPINIT(j_class, j_fieldtype,               \oM                                         j_field, c_type, c_field)           \dM extern "C" JNIEXPORT void JNICALL                                           \SM   Java_com_sleepycat_db_##j_class##_set_1##j_field                          \.M   (JNIEnv *jnienv, jobject jthis, j_fieldtype value)                        \ M {                                                                           \ M     c_type *db_this = get_##c_type(jnienv, jthis);                          \ M                                                                             \nM     if (verify_dbenv(jnienv, db_this)) {                                    \*M         db_this->c_field = value;                                           \*M     }                                                                       \  }a  M #define JAVADB_RW_ACCESS(j_class, j_fieldtype, j_field, c_type, c_field)    \ M         JAVADB_RO_ACCESS(j_class, j_fieldtype, j_field, c_type, c_field)    \sH         JAVADB_WO_ACCESS(j_class, j_fieldtype, j_field, c_type, c_field)  M #define JAVADB_RO_ACCESS_STRING(j_class, j_field, c_type, c_field, dealloc) \aM extern "C" JNIEXPORT jstring JNICALL                                        \eM   Java_com_sleepycat_db_##j_class##_get_1##j_field                          \ M   (JNIEnv *jnienv, jobject jthis)                                           \ M {                                                                           \ M     c_type *db_this = get_##c_type(jnienv, jthis);                          \rM                                                                             \ M     if (verify_non_null(jnienv, db_this)) {                                 \eM         return get_java_string(jnienv, db_this->c_field);                   \yM     }                                                                       \tM     return 0;                                                               \  }i  M #define JAVADB_WO_ACCESS_STRING(j_class, j_field, c_type, c_field, dealloc) \aM extern "C" JNIEXPORT void JNICALL                                           \eM   Java_com_sleepycat_db_##j_class##_set_1##j_field                          \ M   (JNIEnv *jnienv, jobject jthis, jstring value)                            \hM {                                                                           \.M     c_type *db_this = get_##c_type(jnienv, jthis);                          \oM                                                                             \;M     if (verify_non_null(jnienv, db_this)) {                                 \nM         if (dealloc && db_this->c_field)                                    \oM             delete (char*)db_this->c_field;                                 \ M         if (value)                                                          \ M             db_this->c_field =                                              \nM                 dup_string(jnienv->GetStringUTFChars(value, NULL));         \jM         else                                                                \ M             db_this->c_field = 0;                                           \LM     }                                                                       \L }T  M #define JAVADB_RW_ACCESS_STRING(j_class, j_field, c_type, c_field, dealloc) \jM         JAVADB_RO_ACCESS_STRING(j_class, j_field, c_type, c_field, dealloc) \tK         JAVADB_WO_ACCESS_STRING(j_class, j_field, c_type, c_field, dealloc)M    ' // Replacements for C++ new and delete.,D // Our experience with Sparc/gcc shared libraries is that new/delete- // does not work correctly, so we use malloc.J> // Obviously, these macros are quite limited and do not accept= // constructor args.  But our use of new/delete is also quite  // limited in this library.j //
 #undef NEW #undef NEW_ARRAY
 #undef DELETEi #undef DELETE_ARRAYB   #ifdef unixe //D // currently NEW zeros (to prevent common bugs), NEW_ARRAY does not,6 // since it is almost always used for string creation. //I #define NEW(type)		((type*)memset(malloc(sizeof(type)), 0, sizeof(type))) 9 #define NEW_ARRAY(type,n)	((type*)malloc(sizeof(type)*n))  #define DELETE(p)		(free(p))" #define DELETE_ARRAY(p)		(free(p)) #else* #define NEW(type)		new typej% #define NEW_ARRAY(type,n)	new type[n]B #define DELETE(p)		delete pe$ #define DELETE_ARRAY(p)		delete [] p #endif   #endif /* !_JAVA_UTIL_H_ */E *jnienv, DB_MPOOL *dbobj);b@ jobject get_DbMpoolStat  (JNIEnv *jnienv, DB_MPOOL_STAT *dbobj);A jobject get_DbMpoolFStat (JNIEnv *jnienv, DB_MPOOL_FSTAT *dbobj);L9 jobject get_DbTxn        (JNIEnv *jnienv, DB_TXN *dbobj); < jobject get_DbTxnMgr     (JNIEnv *jnienv, DB_TXNMGR *dbobj);> jobject get_DbTxnStat    (JNIEnv *jnienv, DB_TXN_STAT *dbobj);   //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                