 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */    #include "config.h"    #ifndef lintE static const char sccsid[] = "@(#)lock.c	10.60 (Sleepycat) 12/16/98";  #endif /* not lint */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <string.h>  #endif   #include "db_int.h"  #include "shqueue.h" #include "db_page.h" #include "db_shash.h"  #include "lock.h"  #include "common_ext.h"  #include "db_am.h"  L static void __lock_checklocker __P((DB_LOCKTAB *, struct __db_lock *, int));= static void __lock_freeobj __P((DB_LOCKTAB *, DB_LOCKOBJ *)); H static int  __lock_get_internal __P((DB_LOCKTAB *, u_int32_t, u_int32_t,6     const DBT *, db_lockmode_t, struct __db_lock **));= static int  __lock_promote __P((DB_LOCKTAB *, DB_LOCKOBJ *)); M static int  __lock_put_internal __P((DB_LOCKTAB *, struct __db_lock *, int));   static void __lock_remove_waiterG     __P((DB_LOCKTAB *, DB_LOCKOBJ *, struct __db_lock *, db_status_t));    int  lock_id(lt, idp) 	DB_LOCKTAB *lt; 	u_int32_t *idp; {  	u_int32_t id;   	LOCK_PANIC_CHECK(lt);   	LOCK_LOCKREGION(lt); % 	if (lt->region->id >= DB_LOCK_MAXID)  		lt->region->id = 0;  	id = ++lt->region->id;  	UNLOCK_LOCKREGION(lt);    	*idp = id;  	return (0); }    int 0 lock_vec(lt, locker, flags, list, nlist, elistp) 	DB_LOCKTAB *lt; 	u_int32_t locker, flags;  	int nlist;  	DB_LOCKREQ *list, **elistp; {  	struct __db_lock *lp;  	DB_LOCKOBJ *sh_obj, *sh_locker; 	int i, ret, run_dd;   	LOCK_PANIC_CHECK(lt);   	/* Validate arguments. */ 	if ((ret = C 	    __db_fchk(lt->dbenv, "lock_vec", flags, DB_LOCK_NOWAIT)) != 0)  		return (ret);    	LOCK_LOCKREGION(lt);   / 	if ((ret = __lock_validate_region(lt)) != 0) {  		UNLOCK_LOCKREGION(lt); 		return (ret);  	}  	 	ret = 0; * 	for (i = 0; i < nlist && ret == 0; i++) { 		switch (list[i].op) {  		case DB_LOCK_GET: / 			ret = __lock_get_internal(lt, locker, flags, ' 			    list[i].obj, list[i].mode, &lp);  			if (ret == 0) {* 				list[i].lock = LOCK_TO_OFFSET(lt, lp); 				lt->region->nrequests++; 			}	 			break;  		case DB_LOCK_PUT: ) 			lp = OFFSET_TO_LOCK(lt, list[i].lock);  			if (lp->holder != locker) { 				ret = DB_LOCK_NOTHELD;
 				break; 			} 			list[i].mode = lp->mode;   ( 			ret = __lock_put_internal(lt, lp, 0);	 			break;  		case DB_LOCK_PUT_ALL:  			/* Find the locker. */ ' 			if ((ret = __lock_getobj(lt, locker, / 			    NULL, DB_LOCK_LOCKER, &sh_locker)) != 0) 
 				break;  : 			for (lp = SH_LIST_FIRST(&sh_locker->heldby, __db_lock); 			    lp != NULL;; 			    lp = SH_LIST_FIRST(&sh_locker->heldby, __db_lock)) { 4 				if ((ret = __lock_put_internal(lt, lp, 1)) != 0) 					break;  			}! 			__lock_freeobj(lt, sh_locker);  			lt->region->nlockers--;	 			break;  		case DB_LOCK_PUT_OBJ:   . 			/* Look up the object in the hash table. *// 			HASHLOOKUP(lt->hashtab, __db_lockobj, links, 3 			    list[i].obj, sh_obj, lt->region->table_size, ! 			    __lock_ohash, __lock_cmp);  			if (sh_obj == NULL) { 				ret = EINVAL; 
 				break; 			} 			/* 5 			 * Release waiters first, because they won't cause 4 			 * anyone else to be awakened.  If we release the1 			 * lockers first, all the waiters get awakened  			 * needlessly.  			 */9 			for (lp = SH_TAILQ_FIRST(&sh_obj->waiters, __db_lock);  			    lp != NULL;: 			    lp = SH_TAILQ_FIRST(&sh_obj->waiters, __db_lock)) {* 				lt->region->nreleases += lp->refcount;( 				__lock_remove_waiter(lt, sh_obj, lp, 				    DB_LSTAT_NOGRANT);" 				__lock_checklocker(lt, lp, 1); 			}  9 			for (lp = SH_TAILQ_FIRST(&sh_obj->holders, __db_lock);  			    lp != NULL;: 			    lp = SH_TAILQ_FIRST(&sh_obj->holders, __db_lock)) {  * 				lt->region->nreleases += lp->refcount;0 				SH_LIST_REMOVE(lp, locker_links, __db_lock);0 				SH_TAILQ_REMOVE(&sh_obj->holders, lp, links, 				    __db_lock);  				lp->status = DB_LSTAT_FREE; 1 				SH_TAILQ_INSERT_HEAD(&lt->region->free_locks,  				    lp, links, __db_lock); 			}   			/* Now free the object. */  			__lock_freeobj(lt, sh_obj);	 			break;  #ifdef DEBUG 		case DB_LOCK_DUMP: 			/* Find the locker. */ ' 			if ((ret = __lock_getobj(lt, locker, / 			    NULL, DB_LOCK_LOCKER, &sh_locker)) != 0) 
 				break;  : 			for (lp = SH_LIST_FIRST(&sh_locker->heldby, __db_lock); 			    lp != NULL;8 			    lp = SH_LIST_NEXT(lp, locker_links, __db_lock)) {  				__lock_printlock(lt, lp, 1); 				ret = EINVAL;  			} 			if (ret == 0) {" 				__lock_freeobj(lt, sh_locker); 				lt->region->nlockers--;  			}	 			break;  #endif
 		default: 			ret = EINVAL;	 			break;  		}  	}  B 	if (lt->region->need_dd && lt->region->detect != DB_LOCK_NORUN) {
 		run_dd = 1;  		lt->region->need_dd = 0; 	} else 
 		run_dd = 0;    	UNLOCK_LOCKREGION(lt);    	if (ret == 0 && run_dd)) 		lock_detect(lt, 0, lt->region->detect);    	if (elistp && ret != 0) 		*elistp = &list[i - 1];  	return (ret); }    int 1 lock_get(lt, locker, flags, obj, lock_mode, lock)  	DB_LOCKTAB *lt; 	u_int32_t locker, flags;  	const DBT *obj; 	db_lockmode_t lock_mode;  	DB_LOCK *lock;  {  	struct __db_lock *lockp; 	 	int ret;    	LOCK_PANIC_CHECK(lt);   	/* Validate arguments. */  	if ((ret = __db_fchk(lt->dbenv,@ 	    "lock_get", flags, DB_LOCK_NOWAIT | DB_LOCK_UPGRADE)) != 0) 		return (ret);    	LOCK_LOCKREGION(lt);   / 	if ((ret = __lock_validate_region(lt)) == 0) {   		if (LF_ISSET(DB_LOCK_UPGRADE))% 			lockp = OFFSET_TO_LOCK(lt, *lock);   $ 		if ((ret = __lock_get_internal(lt,5 		    locker, flags, obj, lock_mode, &lockp)) == 0) { " 			if (!LF_ISSET(DB_LOCK_UPGRADE))& 				*lock = LOCK_TO_OFFSET(lt, lockp); 			lt->region->nrequests++;  		}  	}   	UNLOCK_LOCKREGION(lt);  	return (ret); }    int  lock_put(lt, lock) 	DB_LOCKTAB *lt; 	DB_LOCK lock; {  	struct __db_lock *lockp;  	int ret, run_dd;    	LOCK_PANIC_CHECK(lt);   	LOCK_LOCKREGION(lt);   - 	if ((ret = __lock_validate_region(lt)) != 0)  		return (ret);  	else { # 		lockp = OFFSET_TO_LOCK(lt, lock); * 		ret = __lock_put_internal(lt, lockp, 0); 	}  " 	__lock_checklocker(lt, lockp, 0);  B 	if (lt->region->need_dd && lt->region->detect != DB_LOCK_NORUN) {
 		run_dd = 1;  		lt->region->need_dd = 0; 	} else 
 		run_dd = 0;    	UNLOCK_LOCKREGION(lt);    	if (ret == 0 && run_dd)) 		lock_detect(lt, 0, lt->region->detect);    	return (ret); }   
 static int& __lock_put_internal(lt, lockp, do_all) 	DB_LOCKTAB *lt; 	struct __db_lock *lockp;  	int do_all; {  	DB_LOCKOBJ *sh_obj; 	int state_changed;   ? 	if (lockp->refcount == 0 || (lockp->status != DB_LSTAT_HELD && = 	    lockp->status != DB_LSTAT_WAITING) || lockp->obj == 0) { 3 		__db_err(lt->dbenv, "lock_put: invalid lock %lu", < 		    (u_long)((u_int8_t *)lockp - (u_int8_t *)lt->region)); 		return (EINVAL); 	}   	if (do_all)+ 		lt->region->nreleases += lockp->refcount;  	else  		lt->region->nreleases++;* 	if (do_all == 0 && lockp->refcount > 1) { 		lockp->refcount--;
 		return (0);  	}  0 	/* Get the object associated with this lock. */9 	sh_obj = (DB_LOCKOBJ *)((u_int8_t *)lockp + lockp->obj);   $ 	/* Remove lock from locker list. */0 	SH_LIST_REMOVE(lockp, locker_links, __db_lock);  2 	/* Remove this lock from its holders/waitlist. */$ 	if (lockp->status != DB_LSTAT_HELD)9 		__lock_remove_waiter(lt, sh_obj, lockp, DB_LSTAT_FREE);  	else = 		SH_TAILQ_REMOVE(&sh_obj->holders, lockp, links, __db_lock);   , 	state_changed = __lock_promote(lt, sh_obj);  + 	/* Check if object should be reclaimed. */ ; 	if (SH_TAILQ_FIRST(&sh_obj->holders, __db_lock) == NULL) { * 		HASHREMOVE_EL(lt->hashtab, __db_lockobj,; 		    links, sh_obj, lt->region->table_size, __lock_lhash); 5 		if (sh_obj->lockobj.size > sizeof(sh_obj->objdata))  			__db_shalloc_free(lt->mem, % 			    SH_DBT_PTR(&sh_obj->lockobj)); = 		SH_TAILQ_INSERT_HEAD(&lt->region->free_objs, sh_obj, links,  		    __db_lockobj); 		state_changed = 1; 	}   	/* Free lock. */  	lockp->status = DB_LSTAT_FREE; H 	SH_TAILQ_INSERT_HEAD(&lt->region->free_locks, lockp, links, __db_lock);   	/* = 	 * If we did not promote anyone; we need to run the deadlock  	 * detector again.e 	 */ 	if (state_changed == 0) 		lt->region->need_dd = 1;   	return (0); },  
 static int= __lock_get_internal(lt, locker, flags, obj, lock_mode, lockp)g 	DB_LOCKTAB *lt; 	u_int32_t locker, flags;d 	const DBT *obj; 	db_lockmode_t lock_mode;  	struct __db_lock **lockp; {n 	struct __db_lock *newl, *lp;e  	DB_LOCKOBJ *sh_obj, *sh_locker; 	DB_LOCKREGION *lrp; 	size_t newl_off;u 	int ihold, no_dd, ret;"   	no_dd = ret = 0;"   	/*." 	 * Check that lock mode is valid. 	 */ 	lrp = lt->region;+ 	if ((u_int32_t)lock_mode >= lrp->nmodes) {  		__db_err(lt->dbenv,(> 		    "lock_get: invalid lock mode %lu\n", (u_long)lock_mode); 		return (EINVAL); 	}  E 	/* Allocate a new lock.  Optimize for the common case of a grant. */tD 	if ((newl = SH_TAILQ_FIRST(&lrp->free_locks, __db_lock)) == NULL) {; 		if ((ret = __lock_grow_region(lt, DB_LOCK_LOCK, 0)) != 0)* 			return (ret); 		lrp = lt->region;_5 		newl = SH_TAILQ_FIRST(&lrp->free_locks, __db_lock);i 	}% 	newl_off = LOCK_TO_OFFSET(lt, newl);   3 	/* Optimize for common case of granting a lock. */ ; 	SH_TAILQ_REMOVE(&lrp->free_locks, newl, links, __db_lock);    	newl->mode = lock_mode; 	newl->status = DB_LSTAT_HELD; 	newl->holder = locker;- 	newl->refcount = 1;  F 	if ((ret = __lock_getobj(lt, 0, obj, DB_LOCK_OBJTYPE, &sh_obj)) != 0) 		return (ret);   2 	lrp = lt->region;			/* getobj might have grown */% 	newl = OFFSET_TO_LOCK(lt, newl_off);;  ( 	/* Now make new lock point to object */) 	newl->obj = SH_PTR_TO_OFF(newl, sh_obj);_   	/* D 	 * Now we have a lock and an object and we need to see if we shouldB 	 * grant the lock.  We use a FIFO ordering so we can only grant aD 	 * new lock if it does not conflict with anyone on the holders listE 	 * OR anyone on the waiters list.  The reason that we don't grant ifiD 	 * there's a conflict is that this can lead to starvation (a writerA 	 * waiting on a popularly read item will never be granted).  ThetD 	 * downside of this is that a waiting reader can prevent an upgrade1 	 * from reader to writer, which is not uncommon.) 	 *	F 	 * There is one exception to the no-conflict rule.  If a lock is heldD 	 * by the requesting locker AND the new lock does not conflict withE 	 * any other holders, then we grant the lock.  The most common placeeD 	 * this happens is when the holder has a WRITE lock and a READ lockF 	 * request comes in for the same locker.  If we do not grant the read% 	 * lock, then we guarantee deadlock.	 	 *(F 	 * In case of conflict, we put the new lock on the end of the waitersF 	 * list, unless we are upgrading in which case the locker goes on the 	 * front of the list. 	 */ 	ihold = 0; 7 	for (lp = SH_TAILQ_FIRST(&sh_obj->holders, __db_lock);f 	    lp != NULL;0 	    lp = SH_TAILQ_NEXT(lp, links, __db_lock)) { 		if (locker == lp->holder) {) 			if (lp->mode == lock_mode &&	% 			    lp->status == DB_LSTAT_HELD) {	" 				if (LF_ISSET(DB_LOCK_UPGRADE)) 					goto upgrade;   				/*, 				 * Lock is held, so we can increment the, 				 * reference count and return this lock. 				 */s 				lp->refcount++;i 				*lockp = lp;* 				SH_TAILQ_INSERT_HEAD(&lrp->free_locks,  				    newl, links, __db_lock); 				return (0);'	 			} else	 				ihold = 1;0 		} else if (CONFLICTS(lt, lp->mode, lock_mode))	 			break;t     	}   	/*a> 	 * If we are upgrading, then there are two scenarios.  Either= 	 * we had no conflicts, so we can do the upgrade.  Or, there ? 	 * is a conflict and we should wait at the HEAD of the waiters>	 	 * list.= 	 */! 	if (LF_ISSET(DB_LOCK_UPGRADE)) {l 		if (lp == NULL)	 			goto upgrade;  # 		/* There was a conflict, wait. */;A 		SH_TAILQ_INSERT_HEAD(&sh_obj->waiters, newl, links, __db_lock);  		goto wait; 	}   	if (lp == NULL && !ihold)8 		for (lp = SH_TAILQ_FIRST(&sh_obj->waiters, __db_lock); 		    lp != NULL;;1 		    lp = SH_TAILQ_NEXT(lp, links, __db_lock)) { , 			if (CONFLICTS(lt, lp->mode, lock_mode) && 			    locker != lp->holder)
 				break; 		}S 	if (lp == NULL)6 		SH_TAILQ_INSERT_TAIL(&sh_obj->holders, newl, links);$ 	else if (!(flags & DB_LOCK_NOWAIT))6 		SH_TAILQ_INSERT_TAIL(&sh_obj->waiters, newl, links); 	else { * 		/* Free the lock and return an error. */ 		newl->status = DB_LSTAT_FREE; A 		SH_TAILQ_INSERT_HEAD(&lrp->free_locks, newl, links, __db_lock);e 		return (DB_LOCK_NOTGRANTED); 	}   	/*ID 	 * Now, insert the lock onto its locker's list.  If the locker doesE 	 * not currently hold any locks, there's no reason to run a deadlockl$ 	 * detector, save that information. 	 */ 	if ((ret = G 	    __lock_getobj(lt, locker, NULL, DB_LOCK_LOCKER, &sh_locker)) != 0)	 		return (ret); > 	no_dd = SH_LIST_FIRST(&sh_locker->heldby, __db_lock) == NULL;   	lrp = lt->region;H 	SH_LIST_INSERT_HEAD(&sh_locker->heldby, newl, locker_links, __db_lock);   	if (lp != NULL) { 		/*? 		 * This is really a blocker for the process, so initialize itk@ 		 * set.  That way the current process will block when it tries6 		 * to get it and the waking process will release it. 		 */t* wait:		(void)__db_mutex_init(&newl->mutex,3 		    MUTEX_LOCK_OFFSET(lt->region, &newl->mutex));D6 		(void)__db_mutex_lock(&newl->mutex, lt->reginfo.fd);  " 		newl->status = DB_LSTAT_WAITING; 		lrp->nconflicts++;   		/*@ 		 * We are about to wait; must release the region mutex.  Then,A 		 * when we wakeup, we need to reacquire the region mutex before	 		 * continuing. 		 */O# 		if (lrp->detect == DB_LOCK_NORUN)v 			lt->region->need_dd = 1;  		UNLOCK_LOCKREGION(lt);   		/*> 		 * We are about to wait; before waiting, see if the deadlock 		 * detector should be run. 		 */o- 		if (lrp->detect != DB_LOCK_NORUN && !no_dd)S) 			(void)lock_detect(lt, 0, lrp->detect);F  6 		(void)__db_mutex_lock(&newl->mutex, lt->reginfo.fd);   		LOCK_LOCKREGION(lt);) 		if (newl->status != DB_LSTAT_PENDING) {l 			/* Return to free list. */K# 			__lock_checklocker(lt, newl, 0); 6 			SH_TAILQ_INSERT_HEAD(&lrp->free_locks, newl, links, 			    __db_lock); 			switch (newl->status) { 				case DB_LSTAT_ABORTED: 					ret = DB_LOCK_DEADLOCK; 					break;K 				case DB_LSTAT_NOGRANT: 					ret = DB_LOCK_NOTGRANTED; 					break;h 				default: 					ret = EINVAL; 					break;e 			}  			newl->status = DB_LSTAT_FREE; 			newl = NULL;=) 		} else if (LF_ISSET(DB_LOCK_UPGRADE)) {  			/*d3 			 * The lock that was just granted got put on the&5 			 * holders list.  Since we're upgrading some other ( 			 * lock, we've got to remove it here. 			 */$ 			SH_TAILQ_REMOVE(&sh_obj->holders, 			    newl, links, __db_lock);i 			goto upgrade; 		} else  			newl->status = DB_LSTAT_HELD; 	}   	*lockp = newl;  	return (ret);   upgrade: 	/*ED 	 * This was an upgrade, so return the new lock to the free list and 	 * upgrade the mode.  	 */ 	(*lockp)->mode = lock_mode; 	newl->status = DB_LSTAT_FREE;@ 	SH_TAILQ_INSERT_HEAD(&lrp->free_locks, newl, links, __db_lock); 	return (0); }l   /*  * __lock_is_locked --  *  * PUBLIC: int __lock_is_locked C  * PUBLIC:    __P((DB_LOCKTAB *, u_int32_t, DBT *, db_lockmode_t));n  */  int ' __lock_is_locked(lt, locker, dbt, mode)  	DB_LOCKTAB *lt; 	u_int32_t locker;
 	DBT *dbt; 	db_lockmode_t mode; {  	struct __db_lock *lp; 	DB_LOCKOBJ *sh_obj; 	DB_LOCKREGION *lrp;   	lrp = lt->region;  , 	/* Look up the object in the hash table. */- 	HASHLOOKUP(lt->hashtab, __db_lockobj, links,r= 	    dbt, sh_obj, lrp->table_size, __lock_ohash, __lock_cmp);T 	if (sh_obj == NULL)
 		return (0);l  7 	for (lp = SH_TAILQ_FIRST(&sh_obj->holders, __db_lock);h 	    lp != NULL;8 	    lp = SH_TAILQ_FIRST(&sh_obj->holders, __db_lock)) {/ 		if (lp->holder == locker && lp->mode == mode)E 			return (1); 	}   	return (0); }    /*  * __lock_printlock --  *N  * PUBLIC: void __lock_printlock __P((DB_LOCKTAB *, struct __db_lock *, int));  */d void  __lock_printlock(lt, lp, ispgno) 	DB_LOCKTAB *lt; 	struct __db_lock *lp; 	int ispgno; {n 	DB_LOCKOBJ *lockobj;n 	db_pgno_t pgno; 	size_t obj; 	u_int8_t *ptr;  	const char *mode, *status;c   	switch (lp->mode) { 	case DB_LOCK_IREAD: 		mode = "IREAD";f 		break; 	case DB_LOCK_IWR: 		mode = "IWR";  		break; 	case DB_LOCK_IWRITE:e 		mode = "IWRITE"; 		break; 	case DB_LOCK_NG:  		mode = "NG"; 		break; 	case DB_LOCK_READ:e 		mode = "READ"; 		break; 	case DB_LOCK_WRITE: 		mode = "WRITE";  		break;	 	default:o 		mode = "UNKNOWN";_ 		break; 	} 	switch (lp->status) { 	case DB_LSTAT_ABORTED:_ 		status = "ABORT";  		break; 	case DB_LSTAT_ERR:n 		status = "ERROR";n 		break; 	case DB_LSTAT_FREE: 		status = "FREE"; 		break; 	case DB_LSTAT_HELD: 		status = "HELD"; 		break; 	case DB_LSTAT_NOGRANT:/ 		status = "NONE"; 		break; 	case DB_LSTAT_WAITING:- 		status = "WAIT"; 		break; 	case DB_LSTAT_PENDING:  		status = "PENDING";  		break;	 	default:l 		status = "UNKNOWN";_ 		break; 	} 	printf("\t%lx\t%s\t%lu\t%s\t", = 	    (u_long)lp->holder, mode, (u_long)lp->refcount, status);*  4 	lockobj = (DB_LOCKOBJ *)((u_int8_t *)lp + lp->obj);% 	ptr = SH_DBT_PTR(&lockobj->lockobj);r 	if (ispgno) {" 		/* Assume this is a DBT lock. */( 		memcpy(&pgno, ptr, sizeof(db_pgno_t));% 		printf("page %lu\n", (u_long)pgno);i	 	} else {_: 		obj = (u_int8_t *)lp + lp->obj - (u_int8_t *)lt->region;  		printf("0x%lx ", (u_long)obj);& 		__db_pr(ptr, lockobj->lockobj.size); 		printf("\n");  	} }-   /*0  * PUBLIC: int __lock_getobj  __P((DB_LOCKTAB *,G  * PUBLIC:     u_int32_t, const DBT *, u_int32_t type, DB_LOCKOBJ **));t  */o intB* __lock_getobj(lt, locker, dbt, type, objp) 	DB_LOCKTAB *lt; 	u_int32_t locker, type; 	const DBT *dbt; 	DB_LOCKOBJ **objp;l {n 	DB_LOCKREGION *lrp; 	DB_LOCKOBJ *sh_obj; 	u_int32_t obj_size;	 	int ret;O 	void *p, *src;)   	lrp = lt->region;  , 	/* Look up the object in the hash table. */ 	if (type == DB_LOCK_OBJTYPE) {W; 		HASHLOOKUP(lt->hashtab, __db_lockobj, links, dbt, sh_obj, 1 		    lrp->table_size, __lock_ohash, __lock_cmp);t 		obj_size = dbt->size;i	 	} else { 6 		HASHLOOKUP(lt->hashtab, __db_lockobj, links, locker,2 		    sh_obj, lrp->table_size, __lock_locker_hash, 		    __lock_locker_cmp);a 		obj_size = sizeof(locker); 	}   	/* ; 	 * If we found the object, then we can just return it.  Ifa9 	 * we didn't find the object, then we need to create it.	 	 */ 	if (sh_obj == NULL) {= 		/* Create new object and then insert it into hash table. */n 		if ((sh_obj =n? 		    SH_TAILQ_FIRST(&lrp->free_objs, __db_lockobj)) == NULL) {a; 			if ((ret = __lock_grow_region(lt, DB_LOCK_OBJ, 0)) != 0)n 				return (ret);R 			lrp = lt->region;: 			sh_obj = SH_TAILQ_FIRST(&lrp->free_objs, __db_lockobj); 		}    		/*> 		 * If we can fit this object in the structure, do so instead! 		 * of shalloc-ing space for it.  		 */t* 		if (obj_size <= sizeof(sh_obj->objdata)) 			p = sh_obj->objdata;r 		else
 			if ((ret = 6 			    __db_shalloc(lt->mem, obj_size, 0, &p)) != 0) {% 				if ((ret = __lock_grow_region(lt, % 				    DB_LOCK_MEM, obj_size)) != 0)p 					return (ret); 				lrp = lt->region;>) 				/* Reacquire the head of the list. */	, 				sh_obj = SH_TAILQ_FIRST(&lrp->free_objs, 				    __db_lockobj);1 				(void)__db_shalloc(lt->mem, obj_size, 0, &p);s 			}  > 		src = type == DB_LOCK_OBJTYPE ? dbt->data : (void *)&locker; 		memcpy(p, src, obj_size);u   		sh_obj->type = type;@ 		SH_TAILQ_REMOVE(&lrp->free_objs, sh_obj, links, __db_lockobj);  " 		SH_TAILQ_INIT(&sh_obj->waiters); 		if (type == DB_LOCK_LOCKER) ! 			SH_LIST_INIT(&sh_obj->heldby);) 		else# 			SH_TAILQ_INIT(&sh_obj->holders);p" 		sh_obj->lockobj.size = obj_size;; 		sh_obj->lockobj.off = SH_PTR_TO_OFF(&sh_obj->lockobj, p);.   		HASHINSERT(lt->hashtab,cB 		    __db_lockobj, links, sh_obj, lrp->table_size, __lock_lhash);   		if (type == DB_LOCK_LOCKER)l 			lrp->nlockers++;  	}   	*objp = sh_obj; 	return (0); }l   /*H  * Any lock on the waitlist has a process waiting for it.  Therefore, weF  * can't return the lock to the freelist immediately.  Instead, we canH  * remove the lock from the list of waiters, set the status field of theB  * lock, and then let the process waking up return the lock to the
  * free list.	  */l static voidh/ __lock_remove_waiter(lt, sh_obj, lockp, status)T 	DB_LOCKTAB *lt; 	DB_LOCKOBJ *sh_obj; 	struct __db_lock *lockp;  	db_status_t status; {T< 	SH_TAILQ_REMOVE(&sh_obj->waiters, lockp, links, __db_lock); 	lockp->status = status;  , 	/* Wake whoever is waiting on this lock. */8 	(void)__db_mutex_unlock(&lockp->mutex, lt->reginfo.fd); }l   static voidn( __lock_checklocker(lt, lockp, do_remove) 	DB_LOCKTAB *lt; 	struct __db_lock *lockp;f 	int do_remove;  {  	DB_LOCKOBJ *sh_locker;c   	if (do_remove)o1 		SH_LIST_REMOVE(lockp, locker_links, __db_lock);m  6 	/* if the locker list is NULL, free up the object. */G 	if (__lock_getobj(lt, lockp->holder, NULL, DB_LOCK_LOCKER, &sh_locker)_D 	    == 0 && SH_LIST_FIRST(&sh_locker->heldby, __db_lock) == NULL) {  		__lock_freeobj(lt, sh_locker); 		    lt->region->nlockers--;_ 	} }k   static void= __lock_freeobj(lt, obj)  	DB_LOCKTAB *lt; 	DB_LOCKOBJ *obj;s {n 	HASHREMOVE_EL(lt->hashtab, E 	    __db_lockobj, links, obj, lt->region->table_size, __lock_lhash);e. 	if (obj->lockobj.size > sizeof(obj->objdata))8 		__db_shalloc_free(lt->mem, SH_DBT_PTR(&obj->lockobj));H 	SH_TAILQ_INSERT_HEAD(&lt->region->free_objs, obj, links, __db_lockobj); }e   /*  * __lock_downgrade --A  *	Used by the concurrent access product to downgrade write locks   * back to iwrite locks.  *2  * PUBLIC: int __lock_downgrade __P((DB_LOCKTAB *,3  * PUBLIC:     DB_LOCK, db_lockmode_t, u_int32_t));	  */  int(+ __lock_downgrade(lt, lock, new_mode, flags)- 	DB_LOCKTAB *lt; 	DB_LOCK lock; 	db_lockmode_t new_mode; 	u_int32_t flags;f {  	struct __db_lock *lockp;k 	DB_LOCKOBJ *obj;u	 	int ret;    	COMPQUIET(flags, 0);  	LOCK_PANIC_CHECK(lt); 	LOCK_LOCKREGION(lt);e  / 	if ((ret = __lock_validate_region(lt)) == 0) {(# 		lockp = OFFSET_TO_LOCK(lt, lock);O 		lockp->mode = new_mode;e  1 		/* Get the object associated with this lock. */r7 		obj = (DB_LOCKOBJ *)((u_int8_t *)lockp + lockp->obj);_  		(void)__lock_promote(lt, obj); 		++lt->region->nreleases; 	}   	UNLOCK_LOCKREGION(lt);)   	return (ret); }_   /*  * __lock_promote --  *G  * Look through the waiters and holders lists and decide which (if any)R:  * locks can be promoted.   Promote any that are eligible.  */k
 static int __lock_promote(lt, obj)F 	DB_LOCKTAB *lt; 	DB_LOCKOBJ *obj;L {S- 	struct __db_lock *lp_w, *lp_h, *next_waiter;k 	int state_changed;d   	/*t? 	 * We need to do lock promotion.  We also need to determine if ? 	 * we're going to need to run the deadlock detector again.  IfOF 	 * we release locks, and there are waiters, but no one gets promoted,? 	 * then we haven't fundamentally changed the lockmgr state, solD 	 * we may still have a deadlock and we have to run again.  However,C 	 * if there were no waiters, or we actually promoted someone, then(6 	 * we are OK and we don't have to run it immediately. 	 *S@ 	 * During promotion, we look for state changes so we can return# 	 * this information to the caller.c 	 */6 	for (lp_w = SH_TAILQ_FIRST(&obj->waiters, __db_lock)," 	    state_changed = lp_w == NULL; 	    lp_w != NULL; 	    lp_w = next_waiter) {6 		next_waiter = SH_TAILQ_NEXT(lp_w, links, __db_lock);7 		for (lp_h = SH_TAILQ_FIRST(&obj->holders, __db_lock);l 		    lp_h != NULL; 5 		    lp_h = SH_TAILQ_NEXT(lp_h, links, __db_lock)) { / 			if (CONFLICTS(lt, lp_h->mode, lp_w->mode) &&S$ 			    lp_h->holder != lp_w->holder)
 				break; 		}h+ 		if (lp_h != NULL)	/* Found a conflict. */m	 			break;s  . 		/* No conflict, promote the waiting lock. */9 		SH_TAILQ_REMOVE(&obj->waiters, lp_w, links, __db_lock); " 		lp_w->status = DB_LSTAT_PENDING;3 		SH_TAILQ_INSERT_TAIL(&obj->holders, lp_w, links);p   		/* Wake up waiter. */ 8 		(void)__db_mutex_unlock(&lp_w->mutex, lt->reginfo.fd); 		state_changed = 1; 	}   	return (state_changed); } ruct __db_lock *, int));  */d void  __lock_printlock(lt, lp, ispgno) 	DB_LOCKTAB *lt; 	struct __db_lock *lp; 	int ispgno; {n 	DB_LOCKOBJ *lockobj;n 	db_pgno_t pgno; 	size_t obj; 	u_int8_t *ptr;  	const char *mode, *status;c   	switch (lp->mode) { 	case DB_LOCK_IREAD: 		mode = "IREAD";f 		break; 	case DB_LOCK_IWR: 		mode = "IWR";  		break; 	case DB_LOCK_IWRITE:e 		mode = "IWRITE"; 		break;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                