 /*- 7  * See the file LICENSE for redistribution information.   *  * Copyright (c) 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */    #include "config.h"    #ifndef lintK static const char sccsid[] = "@(#)log_archive.c	10.44 (Sleepycat) 10/9/98";  #endif /* not lint */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <stdlib.h>  #include <string.h>  #include <unistd.h>  #endif   #include "db_int.h"  #include "db_dispatch.h" #include "shqueue.h" #include "log.h" #include "common_ext.h" 5 #include "clib_ext.h"			/* XXX: needed for getcwd. */   4 static int __absname __P((char *, char *, char **));M static int __build_data __P((DB_LOG *, char *, char ***, void *(*)(size_t))); 7 static int __cmpfunc __P((const void *, const void *)); 8 static int __usermem __P((char ***, void *(*)(size_t)));   /*  * log_archive -- )  *	Supporting function for db_archive(1).   */  int * log_archive(dblp, listp, flags, db_malloc) 	DB_LOG *dblp; 	char ***listp;  	u_int32_t flags; " 	void *(*db_malloc) __P((size_t)); { 	 	DBT rec;  	DB_LSN stable_lsn;  	u_int32_t fnum; 	int array_size, n, ret;; 	char **array, **arrayp, *name, *p, *pref, buf[MAXPATHLEN];   
 	name = NULL;  	COMPQUIET(fnum, 0);   	LOG_PANIC_CHECK(dblp);   : #define	OKFLAGS	(DB_ARCH_ABS | DB_ARCH_DATA | DB_ARCH_LOG) 	if (flags != 0) { 		if ((ret =B 		    __db_fchk(dblp->dbenv, "log_archive", flags, OKFLAGS)) != 0) 			return (ret); 		if ((ret = 		    __db_fcchk(dblp->dbenv, A 		        "log_archive", flags, DB_ARCH_DATA, DB_ARCH_LOG)) != 0)  			return (ret); 	}   	/* A 	 * Get the absolute pathname of the current directory.  It would C 	 * be nice to get the shortest pathname of the database directory, ! 	 * but that's just not possible.  	 */ 	if (LF_ISSET(DB_ARCH_ABS)) {  		errno = 0;0 		if ((pref = getcwd(buf, sizeof(buf))) == NULL)( 			return (errno == 0 ? ENOMEM : errno); 	} else  		pref = NULL;  " 	switch (LF_ISSET(~DB_ARCH_ABS)) { 	case DB_ARCH_DATA: 6 		return (__build_data(dblp, pref, listp, db_malloc)); 	case DB_ARCH_LOG: 		memset(&rec, 0, sizeof(rec)); " 		if (F_ISSET(dblp, DB_AM_THREAD)) 			F_SET(&rec, DB_DBT_MALLOC);= 		if ((ret = log_get(dblp, &stable_lsn, &rec, DB_LAST)) != 0)  			return (ret);" 		if (F_ISSET(dblp, DB_AM_THREAD))! 			__os_free(rec.data, rec.size);  		fnum = stable_lsn.file;  		break; 	case 0:6 		if ((ret = __log_findckp(dblp, &stable_lsn)) != 0) { 			/* 7 			 * A return of DB_NOTFOUND means that we didn't find 7 			 * any records in the log (so we are not going to be  			 * deleting any log files). 			 */ 			if (ret != DB_NOTFOUND) 				return (ret);  			*listp = NULL;  			return (0); 		} 8 		/* Remove any log files before the last stable LSN. */ 		fnum = stable_lsn.file - 1;  		break; 	}   #define	LIST_INCREMENT	64  	/* Get some initial space. */ 	array_size = 10; I 	if ((ret = __os_malloc(sizeof(char *) * array_size, NULL, &array)) != 0)  		return (ret);  	array[0] = NULL;   ( 	/* Build an array of the file names. */  	for (n = 0; fnum > 0; --fnum) {: 		if ((ret = __log_name(dblp, fnum, &name, NULL, 0)) != 0) 			goto err;% 		if (__os_exists(name, NULL) != 0) {  			__os_freestr(name); 			name = NULL; 	 			break;  		}    		if (n >= array_size - 1) {  			array_size += LIST_INCREMENT;" 			if ((ret = __os_realloc(&array,* 			    sizeof(char *) * array_size)) != 0)
 				goto err;  		}    		if (LF_ISSET(DB_ARCH_ABS)) {5 			if ((ret = __absname(pref, name, &array[n])) != 0) 
 				goto err;  			__os_freestr(name);. 		} else if ((p = __db_rpath(name)) != NULL) {2 			if ((ret = __os_strdup(p + 1, &array[n])) != 0)
 				goto err;  			__os_freestr(name); 		} else 			array[n] = name;    		name = NULL; 		array[++n] = NULL; 	}  0 	/* If there's nothing to return, we're done. */ 	if (n == 0) { 		*listp = NULL;
 		ret = 0; 		goto err;  	}   	/* Sort the list. */ 4 	qsort(array, (size_t)n, sizeof(char *), __cmpfunc);   	/* Rework the memory. */ / 	if ((ret = __usermem(&array, db_malloc)) != 0)  		goto err;    	*listp = array; 	return (0);   err:	if (array != NULL) { 1 		for (arrayp = array; *arrayp != NULL; ++arrayp)  			__os_freestr(*arrayp); 0 		__os_free(array, sizeof(char *) * array_size); 	} 	if (name != NULL) 		__os_freestr(name);  	return (ret); }    /*  * __build_data --(  *	Build a list of datafiles for return.  */ 
 static int* __build_data(dblp, pref, listp, db_malloc) 	DB_LOG *dblp; 	char *pref, ***listp;" 	void *(*db_malloc) __P((size_t)); { 	 	DBT rec;  	DB_LSN lsn; 	__log_register_args *argp;  	u_int32_t rectype; # 	int array_size, last, n, nxt, ret; ( 	char **array, **arrayp, *p, *real_name;   	/* Get some initial space. */ 	array_size = 10; I 	if ((ret = __os_malloc(sizeof(char *) * array_size, NULL, &array)) != 0)  		return (ret);  	array[0] = NULL;    	memset(&rec, 0, sizeof(rec));! 	if (F_ISSET(dblp, DB_AM_THREAD))  		F_SET(&rec, DB_DBT_MALLOC); 7 	for (n = 0, ret = log_get(dblp, &lsn, &rec, DB_FIRST); : 	    ret == 0; ret = log_get(dblp, &lsn, &rec, DB_NEXT)) {# 		if (rec.size < sizeof(rectype)) {  			ret = EINVAL;8 			__db_err(dblp->dbenv, "log_archive: bad log record"); 			goto lg_free; 		}   . 		memcpy(&rectype, rec.data, sizeof(rectype));# 		if (rectype != DB_log_register) { % 			if (F_ISSET(dblp, DB_AM_THREAD)) { " 				__os_free(rec.data, rec.size); 				rec.data = NULL; 			} 			continue; 		} : 		if ((ret = __log_register_read(rec.data, &argp)) != 0) { 			ret = EINVAL; 			__db_err(dblp->dbenv,1 			    "log_archive: unable to read log record");  			goto lg_free; 		}    		if (n >= array_size - 1) {  			array_size += LIST_INCREMENT;" 			if ((ret = __os_realloc(&array,* 			    sizeof(char *) * array_size)) != 0) 				goto lg_free;  		}   = 		if ((ret = __os_strdup(argp->name.data, &array[n])) != 0) { ? lg_free:		if (F_ISSET(&rec, DB_DBT_MALLOC) && rec.data != NULL) " 				__os_free(rec.data, rec.size);
 			goto err1;  		}    		array[++n] = NULL; 		__os_free(argp, 0);   $ 		if (F_ISSET(dblp, DB_AM_THREAD)) {! 			__os_free(rec.data, rec.size);  			rec.data = NULL;  		}  	}  0 	/* If there's nothing to return, we're done. */ 	if (n == 0) {
 		ret = 0; 		*listp = NULL; 		goto err1; 	}   	/* Sort the list. */ 4 	qsort(array, (size_t)n, sizeof(char *), __cmpfunc);   	/* > 	 * Build the real pathnames, discarding nonexistent files and 	 * duplicates.  	 */! 	for (last = nxt = 0; nxt < n;) {  		/*; 		 * Discard duplicates.  Last is the next slot we're going ; 		 * to return to the user, nxt is the next slot that we're  		 * going to consider.  		 */  		if (last != nxt) { 			array[last] = array[nxt]; 			array[nxt] = NULL;  		}  		for (++nxt; nxt < n &&4 		    strcmp(array[last], array[nxt]) == 0; ++nxt) { 			__os_freestr(array[nxt]); 			array[nxt] = NULL;  		}    		/* Get the real name. */& 		if ((ret = __db_appname(dblp->dbenv,A 		    DB_APP_DATA, NULL, array[last], 0, NULL, &real_name)) != 0) 
 			goto err2;   - 		/* If the file doesn't exist, ignore it. */ * 		if (__os_exists(real_name, NULL) != 0) { 			__os_freestr(real_name);  			__os_freestr(array[last]);  			array[last] = NULL; 			continue; 		}   1 		/* Rework the name as requested by the user. */  		__os_freestr(array[last]); 		array[last] = NULL;  		if (pref != NULL) { 2 			ret = __absname(pref, real_name, &array[last]); 			__os_freestr(real_name);  			if (ret != 0) 				goto err2;3 		} else if ((p = __db_rpath(real_name)) != NULL) { * 			ret = __os_strdup(p + 1, &array[last]); 			__os_freestr(real_name);  			if (ret != 0) 				goto err2; 		} else 			array[last] = real_name; 	 		++last;  	}   	/* NULL-terminate the list. */  	array[last] = NULL;   	/* Rework the memory. */ / 	if ((ret = __usermem(&array, db_malloc)) != 0)  		goto err1;   	*listp = array; 	return (0);   err2:	/* 	 * XXX D 	 * We've possibly inserted NULLs into the array list, so clean up a1 	 * bit so that the other error processing works.  	 */ 	if (array != NULL)  		for (; nxt < n; ++nxt) 			__os_freestr(array[nxt]); 	/* FALLTHROUGH */   err1:	if (array != NULL) {1 		for (arrayp = array; *arrayp != NULL; ++arrayp)  			__os_freestr(*arrayp);l0 		__os_free(array, array_size * sizeof(char *)); 	} 	return (ret); }9   /*  * __absname --r-  *	Return an absolute path name for the file.f  */ 
 static int __absname(pref, name, newnamep)= 	char *pref, *name, **newnamep;c {  	size_t l_pref, l_name;  	int isabspath, ret; 	char *newname;    	l_name = strlen(name);i  	isabspath = __os_abspath(name);' 	l_pref = isabspath ? 0 : strlen(pref);s  . 	/* Malloc space for concatenating the two. */C 	if ((ret = __os_malloc(l_pref + l_name + 2, NULL, &newname)) != 0)m 		return (ret);u 	*newnamep = newname;X  I 	/* Build the name.  If `name' is an absolute path, ignore any prefix. */) 	if (!isabspath) {  		memcpy(newname, pref, l_pref);: 		if (strchr(PATH_SEPARATOR, newname[l_pref - 1]) == NULL)) 			newname[l_pref++] = PATH_SEPARATOR[0];e 	}, 	memcpy(newname + l_pref, name, l_name + 1);   	return (0); }*   /*  * __usermem --rG  *	Create a single chunk of memory that holds the returned information. 4  *	If the user has their own malloc routine, use it.  */ 
 static int __usermem(listp, db_malloc)c 	char ***listp;e" 	void *(*db_malloc) __P((size_t)); {z 	size_t len;	 	int ret;,' 	char **array, **arrayp, **orig, *strp;E  ' 	/* Find out how much space we need. */;4 	for (len = 0, orig = *listp; *orig != NULL; ++orig), 		len += sizeof(char *) + strlen(*orig) + 1; 	len += sizeof(char *);   + 	/* Allocate it and set up the pointers. */g6 	if ((ret = __os_malloc(len, db_malloc, &array)) != 0) 		return (ret);-  . 	strp = (char *)(array + (orig - *listp) + 1);  9 	/* Copy the original information into the new memory. */ G 	for (orig = *listp, arrayp = array; *orig != NULL; ++orig, ++arrayp) {c 		len = strlen(*orig); 		memcpy(strp, *orig, len + 1);  		*arrayp = strp;s 		strp += len + 1;   		__os_freestr(*orig); 	}   	/* NULL-terminate the list. */e 	*arrayp = NULL;   	__os_free(*listp, 0); 	*listp = array;   	return (0); }s  
 static int __cmpfunc(p1, p2)_ 	const void *p1, *p2;  {s? 	return (strcmp(*((char * const *)p1), *((char * const *)p2)));l }) 	case DB_ARCH_LOG: 		memset(&rec, 0, sizeof(rec)); " 		if (F_ISSET(dblp, DB_AM_THREAD)) 			F_SET(&rec, DB_DBT_MALLOC);= 		if ((ret = log_get(dblp, &stable_lsn, &rec, DB_LAST)) != 0)  			return (ret);" 		if (F_ISSET(dblp, DB_AM_THREAD))! 			__os_free(rec.data, rec.size);  		fnum = stable_lsn.file;  		break; 	case 0:6 		if ((ret = __log_findckp(dblp, &stable_lsn)) != 0) { 			/* 7 			 * A return of DB_NOTFOUND means that we didn't find 7 			 * any records in the log (so                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                