 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */    #include "config.h"    #ifndef lintK static const char sccsid[] = "@(#)log_findckp.c	10.17 (Sleepycat) 9/17/98";  #endif /* not lint */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <string.h>  #endif   #include "db_int.h"  #include "shqueue.h" #include "log.h" #include "txn.h" #include "common_ext.h"    /*  * __log_findckp --   *J  * Looks for the most recent checkpoint that occurs before the most recentK  * checkpoint LSN.  This is the point from which recovery can start and the H  * point up to which archival/truncation can take place.  Checkpoints in  * the log look like:   *F  * -------------------------------------------------------------------E  *  | ckp A, ckplsn 100 |  .... record .... | ckp B, ckplsn 600 | ... F  * -------------------------------------------------------------------;  *         LSN 500                                 LSN 1000   *I  * If we read what log returns from using the DB_CKP parameter to logput, F  * we'll get the record at LSN 1000.  The checkpoint LSN there is 600.I  * Now we have to scan backwards looking for a checkpoint before LSN 600. F  * We find one at 500.  This means that we can truncate the log before(  * 500 or run recovery beginning at 500.  *A  * Returns 0 if we find a suitable checkpoint or we retrieved the /  * first record in the log from which to start. 3  * Returns DB_NOTFOUND if there are no log records.   * Returns errno on error.  *7  * PUBLIC: int __log_findckp __P((DB_LOG *, DB_LSN *));   */  int  __log_findckp(lp, lsnp)  	DB_LOG *lp; 	DB_LSN *lsnp; { 
 	DBT data;$ 	DB_LSN ckp_lsn, last_ckp, next_lsn; 	__txn_ckp_args *ckp_args; 	int ret, verbose;  ; 	verbose = lp->dbenv != NULL && lp->dbenv->db_verbose != 0;    	/* : 	 * Need to find the appropriate point from which to begin
 	 * recovery.  	 */  	memset(&data, 0, sizeof(data)); 	if (F_ISSET(lp, DB_AM_THREAD))  		F_SET(&data, DB_DBT_MALLOC); 	ZERO_LSN(ckp_lsn); ? 	if ((ret = log_get(lp, &last_ckp, &data, DB_CHECKPOINT)) != 0)  		if (ret == ENOENT) 			goto get_first; 		else 			return (ret);   	next_lsn = last_ckp;  	do {   		if (F_ISSET(lp, DB_AM_THREAD))# 			__os_free(data.data, data.size);   9 		if ((ret = log_get(lp, &next_lsn, &data, DB_SET)) != 0)  			return (ret);: 		if ((ret = __txn_ckp_read(data.data, &ckp_args)) != 0) {! 			if (F_ISSET(lp, DB_AM_THREAD)) $ 				__os_free(data.data, data.size); 			return (ret); 		}  		if (IS_ZERO_LSN(ckp_lsn))  			ckp_lsn = ckp_args->ckp_lsn;  		if (verbose) {3 			__db_err(lp->dbenv, "Checkpoint at: [%lu][%lu]", 7 			    (u_long)last_ckp.file, (u_long)last_ckp.offset); 4 			__db_err(lp->dbenv, "Checkpoint LSN: [%lu][%lu]",& 			    (u_long)ckp_args->ckp_lsn.file,) 			    (u_long)ckp_args->ckp_lsn.offset); 9 			__db_err(lp->dbenv, "Previous checkpoint: [%lu][%lu]", ' 			    (u_long)ckp_args->last_ckp.file, * 			    (u_long)ckp_args->last_ckp.offset); 		}  		last_ckp = next_lsn;  		next_lsn = ckp_args->last_ckp;) 		__os_free(ckp_args, sizeof(*ckp_args)); # 	} while (!IS_ZERO_LSN(next_lsn) && + 	    log_compare(&last_ckp, &ckp_lsn) > 0);    	if (F_ISSET(lp, DB_AM_THREAD)) " 		__os_free(data.data, data.size);   	/* = 	 * At this point, either, next_lsn is ZERO or ckp_lsn is the A 	 * checkpoint lsn and last_ckp is the LSN of the last checkpoint C 	 * before ckp_lsn.  If the compare in the loop is still true, then ; 	 * next_lsn must be 0 and we need to roll forward from the  	 * beginning of the log.  	 */, 	if (log_compare(&last_ckp, &ckp_lsn) > 0) {D get_first:	if ((ret = log_get(lp, &last_ckp, &data, DB_FIRST)) != 0) 			return (ret);  		if (F_ISSET(lp, DB_AM_THREAD))# 			__os_free(data.data, data.size);  	} 	*lsnp = last_ckp;  2 	return (IS_ZERO_LSN(last_ckp) ? DB_NOTFOUND : 0); }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     