 /*- 7  * See the file LICENSE for redistribution information.   *  * Copyright (c) 1998 ,  *	Sleepycat Software.  All rights reserved.  *J  * This code is derived from software contributed to Sleepycat Software by9  * Frederick G.M. Roeber of Netscape Communications Corp.   */    #include "config.h"    #ifndef lintE static const char sccsid[] = "@(#)os_map.c	10.9 (Sleepycat) 9/17/98";  #endif /* not lint */    #include "db_int.h"  #include "common_ext.h"    /*L  * DB version 2 uses memory-mapped files for two things: 1) faster access ofL  * read-only databases, and 2) shared memory for process synchronization andJ  * locking.  The code carefully does not mix the two uses.  The first-caseK  * uses are actually written such that memory-mapping isn't really required K  * -- it's merely a convenience -- so we don't have to worry much about it. O  * In the second case, it's solely used as a shared memory mechanism, so that's   * all we have to replace.  *L  * The mechanism I use for shared memory on Win16 is actually fairly simple.O  * All memory in Win16 is shared, and a DLL can allocate memory and keep notes. K  * This implementation of Win16, at least, is entirely done as a DLL.  So I K  * merely have to allocate memory, remember the "filename" for that memory, J  * and issue small-integer segment IDs which index the DLL's list of theseL  * shared-memory segments.  Subsequent opens are checked against the list of  * already open segments.   */    typedef struct {( 	void *segment;			/* Segment address. */& 	u_int32_t size;			/* Segment size. */" 	char *name;			/* Segment name. */ } os_segdata_t;   7 static os_segdata_t *__os_segdata;	/* Segment table. */ 8 static int __os_segdata_size;		/* Segment table size. */  # #define	OS_SEGDATA_STARTING_SIZE 16   #define	OS_SEGDATA_INCREMENT	 16  - static int __os_map __P((char *, REGINFO *)); @ static int __os_segdata_allocate __P((const char *, REGINFO *));C static int __os_segdata_find_byname __P((const char *, REGINFO *)); ) static int __os_segdata_new __P((int *)); + static int __os_segdata_release __P((int));    /*  * __db_mapanon_ok -- :  *	Return if this OS can support anonymous memory regions.  **  * PUBLIC: int __db_mapanon_ok __P((int));  */  int  __db_mapanon_ok(need_names)  	int need_names; {  	COMPQUIET(need_names, 0);   	/* ; 	 * All Win16 regions are in named anonymous shared memory,   	 * so the answer is always yes. 	 */ 	return (0); }    /*  * __db_mapinit --3  *	Return if shared regions need to be initialized.   *(  * PUBLIC: int __db_mapinit __P((void));  */  int  __db_mapinit() { 5 	/* Win16 regions do not need to be fully written. */  	return (0); }    /*  * __db_mapregion --$  *	Attach to a shared memory region.  *7  * PUBLIC: int __db_mapregion __P((char *, REGINFO *));   */  int  __db_mapregion(path, infop)  	char *path; 	REGINFO *infop; { G 	/* If the user replaces the map call, call through their interface. */  	if (__db_jump.j_map != NULL) 7 		return (__db_jump.j_map(path, infop->fd, infop->size, = 		    1, F_ISSET(infop, REGION_ANONYMOUS), 0, &infop->addr));    	/*  	 * XXX C 	 * We could actually grow regions without a lot of difficulty, but B 	 * since the maximum region is 64K, it's unclear to me it's worth 	 * the effort.  	 */  	return (__os_map(path, infop)); }    /*  * __db_unmapregion --(  *	Detach from the shared memory region.  *1  * PUBLIC: int __db_unmapregion __P((REGINFO *));   */  int  __db_unmapregion(infop)  	REGINFO *infop; {  	if (__db_jump.j_unmap != NULL) 7 		return (__db_jump.j_unmap(infop->addr, infop->size));   1 	/* There's no mapping to discard, we're done. */  	return (0); }    /*  * __db_unlinkregion -- #  *	Remove the shared memory region.   *:  * PUBLIC: int __db_unlinkregion __P((char *, REGINFO *));  */  int  __db_unlinkregion(name, infop) 	char *name; 	REGINFO *infop; {  	COMPQUIET(infop, NULL);  ! 	if (__db_jump.j_runlink != NULL) % 		return (__db_jump.j_runlink(name));   - 	return (__os_segdata_release(infop->segid));  }    /*  * __db_mapfile --  *	Map in a shared memory file.   *E  * PUBLIC: int __db_mapfile __P((char *, int, size_t, int, void **));   */  int , __db_mapfile(path, fd, len, is_rdonly, addr) 	char *path; 	int fd, is_rdonly;  	size_t len;
 	void **addr;  {  	if (__db_jump.j_map != NULL) A 		return (__db_jump.j_map(path, fd, len, 0, 0, is_rdonly, addr));   / 	/* We cannot map in regular files in Win16. */  	return (EINVAL);  }    /*  * __db_unmapfile --   *	Unmap the shared memory file.  *4  * PUBLIC: int __db_unmapfile __P((void *, size_t));  */  int  __db_unmapfile(addr, len)  	void *addr; 	size_t len; {  	if (__db_jump.j_unmap != NULL) ( 		return (__db_jump.j_unmap(addr, len));  / 	/* We cannot map in regular files in Win16. */  	return (EINVAL);  }    /*  * __os_map --  *	Create/find a shared region.   */ 
 static int __os_map(path, infop)  	char *path; 	REGINFO *infop; { 	 	int ret;   / 	/* Try to find an already existing segment. */ 0 	if (__os_segdata_find_byname(path, infop) == 0)
 		return (0);    	/* : 	 * If we're trying to join the region and failing, assume< 	 * that there was a reboot and the region no longer exists. 	 */% 	if (!F_ISSET(infop, REGION_CREATED))  		return (EAGAIN);   	/* Create a new segment. */5 	if ((ret = __os_segdata_allocate(path, infop)) != 0)  		return (ret);    	return (0); }    /*  * __os_segdata_init -- E  *	Initialises the library's table of shared memory segments.  Called %  *	(once!) from the DLL main routine.   *-  * PUBLIC: int __os_segdata_init __P((void));   */  int  __os_segdata_init()  { 	 	int ret;    	if (__os_segdata != NULL) 		return (EEXIST);  . 	__os_segdata_size = OS_SEGDATA_STARTING_SIZE;* 	if ((ret = __os_calloc(__os_segdata_size,0 	    sizeof(os_segdata_t), &__os_segdata)) != 0) 		return (ret);    	return (0); }    /*  * __os_segdata_destroy --C  *	Destroys the library's table of shared memory segments.  It also C  *	frees all linked data: the segments themselves, and their names. 0  *	Called (once!) from the DLL shutdown routine.  *0  * PUBLIC: int __os_segdata_destroy __P((void));  */  int  __os_segdata_destroy() {  	os_segdata_t *p;  	int i;    	if (__os_segdata == NULL)
 		return (0);   * 	for (i = 0; i < __os_segdata_size; i++) { 		p = &__os_segdata[i];  		if (p->name != NULL) { 			__os_freestr(p->name);  			p->name = NULL; 		}  		if (p->segment != NULL) { " 			__os_free(p->segment, p->size); 			p->segment = NULL;  		}  		p->size = 0; 	}  C 	__os_free(__os_segdata, __os_segdata_size * sizeof(os_segdata_t));  	__os_segdata = NULL;  	__os_segdata_size = 0;    	return (0); }    /*  * __os_segdata_allocate -- C  *	Creates a new segment of the specified size, optionally with the   *	specified name.  */ 
 static int" __os_segdata_allocate(name, infop) 	const char *name; 	REGINFO *infop; {  	os_segdata_t *p;  	int segid, ret;  + 	if ((ret = __os_segdata_new(&segid)) != 0)  		return (ret);    	p = &__os_segdata[segid];; 	if ((ret = __os_calloc(infop->size, 1, &p->segment)) != 0)  		return (ret); 0 	if ((ret = __os_strdup(name, &p->name)) != 0) {% 		__os_free(p->segment, infop->size);  		p->segment = NULL; 		return (ret);  	} 	p->size = infop->size;    	infop->addr = p->segment; 	infop->segid = segid;   	return (0); }    /*  * __os_segdata_new --H  *	Finds a new segdata slot.  Does not initialise it, so the fd returned+  *	is only valid until you call this again.   */ 
 static int __os_segdata_new(segidp)
 	int *segidp;  {  	os_segdata_t *p;  	int i, newsize, ret;    	if (__os_segdata == NULL) 		return (EAGAIN);  * 	for (i = 0; i < __os_segdata_size; i++) { 		p = &__os_segdata[i];  		if (p->segment == NULL) {  			*segidp = i;  			return (0); 		}  	}   	/* G 	 * This test is actually pedantic, since I can't malloc more than 64K, D 	 * and the structure is more than two bytes big.  But I'm a pedant. 	 */  	if ((u_int)__os_segdata_size >=; 	    (32768 / sizeof(os_segdata_t) - OS_SEGDATA_INCREMENT))  		return (ENOMEM);  4 	newsize = __os_segdata_size + OS_SEGDATA_INCREMENT; 	if ((ret = G 	    __os_realloc(&__os_segdata, newsize * sizeof(os_segdata_t))) != 0)C 		return (ret); ' 	memset(&os_segdata[__os_segdata_size],r5 	    0, OS_SEGDATA_INCREMENT * sizeof(os_segdata_t));u 	__os_segdata_size = newsize;*   	*segidp = __os_segdata_size;e   	return (0); }p   /*  * __os_segdata_find_byname --  *	Finds a segment by its name.s  *C  * PUBLIC: __os_segdata_find_byname __P((const char *, REGINFO *));   */c
 static int% __os_segdata_find_byname(name, infop)* 	const char *name; 	REGINFO *infop; {r 	os_segdata_t *p;t 	int i;    	if (__os_segdata == NULL) 		return (EAGAIN);   	if (name == NULL) 		return (ENOENT);  * 	for (i = 0; i < __os_segdata_size; i++) { 		p = &__os_segdata[i];e6 		if (p->name != NULL && strcmp(name, p->name) == 0) { 			infop->addr = p->segment; 			infop->segid = i; 			return (0); 		}r 	} 	return (ENOENT);I }h   /*  * __os_segdata_release --  *	Free a segdata entry.  */t
 static int __os_segdata_release(segid)* 	int segid;m {u 	os_segdata_t *p;y   	if (__os_segdata == NULL) 		return (EAGAIN);  - 	if (segid < 0 || segid >= __os_segdata_size)r 		return (EINVAL);   	p = &__os_segdata[segid]; 	if (p->name != NULL) {d 		__os_freestr(p->name); 		p->name = NULL;a 	} 	if (p->segment != NULL) {! 		__os_free(p->segment, p->size);s 		p->segment = NULL; 	}
 	p->size = 0;D  + 	/* Any shrink-table logic could go here */    	return (0); }ehecked against the list of  * already open segments.   */    typedef struct {( 	void *segment;			/* Segment add                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                