 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */    #include "config.h"    #ifndef lintH static const char sccsid[] = "@(#)tcl_log.c	10.18 (Sleepycat) 12/14/98"; #endif /* not lint */    /*4  * This file is divided up into 5 sets of functions:0  * 1. The log command and its support functions.  * 2. The logunlink command.&  * 3. The log manager widget commands.  */  #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <stdlib.h>  #include <string.h>  #include <errno.h> #endif #include <tcl.h>   #include "db_int.h"  #include "dbtest.h"  #include "test_ext.h"    /* Internal functions */9 static int get_lsn __P((Tcl_Interp *, char *, DB_LSN *)); H static int log_compare_cmd __P((Tcl_Interp *interp, int, char *argv[]));O static int log_file_cmd __P((DB_LOG *, Tcl_Interp *interp, int, char *argv[])); P static int log_flush_cmd __P((DB_LOG *, Tcl_Interp *interp, int, char *argv[]));N static int log_get_cmd __P((DB_LOG *, Tcl_Interp *interp, int, char *argv[]));N static int log_put_cmd __P((DB_LOG *, Tcl_Interp *interp, int, char *argv[]));N static int log_reg_cmd __P((DB_LOG *, Tcl_Interp *interp, int, char *argv[]));   /*
  * log_cmd -- B  *	Implements log_open for dbtest.  Log_open creates a log managerC  * and all the necessary files in the file system.  It then creates 5  * a command that implements the other log functions.   */   ? #define LOG_USAGE "log path flags mode [options]\n\toptions:\n"    typedef struct _log_data { 	DB_LOG *logp;
 	DB_ENV *env;  } log_data;    int $ log_cmd(notused, interp, argc, argv) 	ClientData notused; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {  	static int log_number = 0;  	DB_LOG *lp;
 	DB_ENV *env;  	log_data *ld; 	u_int32_t flags;  	int mode, tclint; 	char logname[50]; 	u_int8_t *conflicts;    	notused = NULL;   	debug_check();   ! 	/* Check number of arguments. */ & 	USAGE_GE(argc, 4, LOG_USAGE, DO_ENV);4 	if (Tcl_GetInt(interp, argv[2], &tclint) != TCL_OK) 		return (TCL_ERROR);  	flags = (u_int32_t)tclint;   2 	if (Tcl_GetInt(interp, argv[3], &mode) != TCL_OK) 		return (TCL_ERROR);   3 	if (process_env_options(interp, argc, argv, &env))  		return (TCL_ERROR);   % 	if (F_ISSET(env, DB_ENV_STANDALONE))  		lp = env->lg_info;: 	else if (log_open(argv[1], flags, mode, env, &lp) != 0) { 		db_appexit(env);, 		Tcl_SetResult(interp, "NULL", TCL_STATIC); 		return (TCL_OK); 	} else  		env->lg_info = lp;  ; 	if ((ld = (log_data *)malloc(sizeof(log_data))) == NULL) { ) 		if (!F_ISSET(env, DB_ENV_STANDALONE)) {  			(void)db_appexit(env); - 			conflicts = (u_int8_t *)env->lk_conflicts;  			if (conflicts != NULL)  				free(conflicts);
 			free(env);  		} 3 		Tcl_SetResult(interp, "lock_open: ", TCL_STATIC);  		errno = ENOMEM; 6 		Tcl_AppendResult(interp, Tcl_PosixError(interp), 0); 		return (TCL_ERROR);  	} 	ld->logp = lp;  	ld->env = env;    	/* Create new command name. */ 9 	snprintf(logname, sizeof(logname), "log%d", log_number);  	log_number++;   	/* Create widget command. */ D 	Tcl_CreateCommand(interp, logname, logwidget_cmd, (int *)ld, NULL);. 	Tcl_SetResult(interp, logname, TCL_VOLATILE); 	return (TCL_OK);  }    /*  * logunlink_cmd -- $  *	Implements txn_unlink for dbtest.  */   / #define LOGUNLINK_USAGE "log_unlink path force"    int * logunlink_cmd(notused, interp, argc, argv) 	ClientData notused; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {  	int force;    	notused = NULL;   	debug_check();   ' 	USAGE_GE(argc, 3, LOGUNLINK_USAGE, 0);   3 	if (Tcl_GetInt(interp, argv[2], &force) != TCL_OK)  		return (TCL_ERROR);   + 	if (log_unlink(argv[1], force, NULL) != 0) * 		Tcl_SetResult(interp, "-1", TCL_STATIC); 	else ) 		Tcl_SetResult(interp, "0", TCL_STATIC);    	return (TCL_OK);  }    /*  * logwidget -- >  * This is that command that implements the log widget.  If we:  * ever add new "methods" we add new widget commands here.  */ 3 #define LOGWIDGET_USAGE "logN option ?arg arg ...?" # #define LOGCLOSE_USAGE "logN close" ' #define LOGFLUSH_USAGE "logN flush lsn" ) #define LOGGET_USAGE "logN get lsn flags" - #define LOGCMP_USAGE "logN compare lsn1 lsn2" % #define LOGFILE_USAGE "logN file lsn" ! #define LOGLAST_USAGE "logN last" , #define LOGPUT_USAGE "logN put record flags"1 #define LOGREG_USAGE "logN register db name type" & #define LOG_UNREG "logN unregister id"   int ( logwidget_cmd(cd_lp, interp, argc, argv) 	ClientData cd_lp; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {  	DB_LOG *lp;
 	DB_ENV *env;  	DB_LSN lsn;	 	DBT rec; 
 	int id, ret;  	char fstr[16], dstr[16];  	u_int8_t *conflicts;    	debug_check();     	lp = ((log_data *)cd_lp)->logp;  ' 	USAGE_GE(argc, 2, LOGWIDGET_USAGE, 0);   % 	if (strcmp(argv[1], "close") == 0) { $ 		USAGE(argc, 2, LOGCLOSE_USAGE, 0);! 		env = ((log_data *)cd_lp)->env; ) 		if (!F_ISSET(env, DB_ENV_STANDALONE)) {  			(void)db_appexit(env); - 			conflicts = (u_int8_t *)env->lk_conflicts;  			if (conflicts != NULL)  				free(conflicts);
 			free(env);  		}  		free(cd_lp);+ 		ret = Tcl_DeleteCommand(interp, argv[0]); , 	} else if (strcmp(argv[1], "flush") == 0) {/ 		ret =  log_flush_cmd(lp, interp, argc, argv); * 	} else if (strcmp(argv[1], "get") == 0) {/ 		return (log_get_cmd(lp, interp, argc, argv)); + 	} else if (strcmp(argv[1], "last") == 0) {  		memset(&rec, 0, sizeof(rec)); ) 		ret = log_get(lp, &lsn, &rec, DB_LAST);  		if (ret == 0) { 9 			snprintf(fstr, sizeof(fstr), "%lu", (u_long)lsn.file); ; 			snprintf(dstr, sizeof(dstr), "%lu", (u_long)lsn.offset);  			Tcl_ResetResult(interp); 0 			Tcl_AppendResult(interp, fstr, " ", dstr, 0); 			return (TCL_OK);  		} . 	} else if (strcmp(argv[1], "compare") == 0) {/ 		return (log_compare_cmd(interp, argc, argv)); + 	} else if (strcmp(argv[1], "file") == 0) { 0 		return (log_file_cmd(lp, interp, argc, argv));* 	} else if (strcmp(argv[1], "put") == 0) {/ 		return (log_put_cmd(lp, interp, argc, argv)); / 	} else if (strcmp(argv[1], "register") == 0) { / 		return (log_reg_cmd(lp, interp, argc, argv)); 1 	} else if (strcmp(argv[1], "unregister") == 0) { 1 		if (Tcl_GetInt(interp, argv[2], &id) != TCL_OK)  			return (TCL_ERROR); 		ret = log_unregister(lp, id); 	 	} else { 5 		Tcl_SetResult(interp, LOGWIDGET_USAGE, TCL_STATIC);  		return (TCL_ERROR);  	}   	if (ret != 0) {1 		Tcl_SetResult(interp, "log_cmd: ", TCL_STATIC);  		errno = ret;( 		Tcl_AppendResult(interp, argv[2], " ",! 		    Tcl_PosixError(interp), 0);  	} else ) 		Tcl_SetResult(interp, "0", TCL_STATIC);  	return (TCL_OK);  }    /*8  * Implementation of all the individual widget commands.  */ 
 static int# log_compare_cmd(interp, argc, argv)  	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {  	DB_LSN lsn1, lsn2;  	char resbuf[32]; 	 	int cmp;   ! 	USAGE(argc, 4, LOGCMP_USAGE, 0); 1 	if (get_lsn(interp, argv[2], &lsn1) != TCL_OK || / 	    get_lsn(interp, argv[3], &lsn2) != TCL_OK)  		return (TCL_ERROR);   ! 	cmp = log_compare(&lsn1, &lsn2); - 	snprintf(resbuf, sizeof(resbuf), "%d", cmp); - 	Tcl_SetResult(interp, resbuf, TCL_VOLATILE);  	return (TCL_OK);  }   
 static int% log_flush_cmd(lp, interp, argc, argv)  	DB_LOG *lp; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {  	DB_LSN lsn;	 	int ret;   # 	USAGE(argc, 3, LOGFLUSH_USAGE, 0); . 	if (get_lsn(interp, argv[2], &lsn) != TCL_OK) 		return (TCL_ERROR); & 	if (lsn.file == 0 && lsn.offset == 0) 		ret = log_flush(lp, NULL); 	else  		ret = log_flush(lp, &lsn); 	if (ret != 0) 		return (TCL_ERROR);   ( 	Tcl_SetResult(interp, "0", TCL_STATIC); 	return (TCL_OK);  }   
 static int$ log_file_cmd(lp, interp, argc, argv) 	DB_LOG *lp; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {  	DB_LSN lsn;	 	int ret;  	char name[1024];   " 	USAGE(argc, 3, LOGFILE_USAGE, 0);. 	if (get_lsn(interp, argv[2], &lsn) != TCL_OK) 		return (TCL_ERROR); ; 	if ((ret = log_file(lp, &lsn, name, sizeof(name))) != 0) { 2 		Tcl_SetResult(interp, "log_file: ", TCL_STATIC); 		errno = ret;6 		Tcl_AppendResult(interp, Tcl_PosixError(interp), 0); 		return (TCL_OK); 	}+ 	Tcl_SetResult(interp, name, TCL_VOLATILE);* 	return (TCL_OK);  }E  
 static int# log_get_cmd(lp, interp, argc, argv)g 	DB_LOG *lp; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {e 	DB_LSN lsn;
 	DBT data; 	u_int32_t flags;i 	int ret, tclint;a  ! 	USAGE(argc, 4, LOGGET_USAGE, 0);e. 	if (get_lsn(interp, argv[2], &lsn) != TCL_OK) 		return (TCL_ERROR);e4 	if (Tcl_GetInt(interp, argv[3], &tclint) != TCL_OK) 		return (TCL_ERROR);n 	flags = (u_int32_t)tclint;n    	memset(&data, 0, sizeof(data));1 	switch (ret = log_get(lp, &lsn, &data, flags)) {<8 	case 0:	Tcl_SetResult(interp, data.data, TCL_VOLATILE); 		break;+ 	case DB_NOTFOUND: Tcl_ResetResult(interp);u 		break;	 	default:u1 		Tcl_SetResult(interp, "log get: ", TCL_STATIC);a 		errno = ret;6 		Tcl_AppendResult(interp, Tcl_PosixError(interp), 0); 		break; 	} 	return (TCL_OK);P }c  
 static int# log_put_cmd(lp, interp, argc, argv)l 	DB_LOG *lp; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {  	DB_LSN lsn;
 	DBT data; 	u_int32_t flags;_ 	int ret, tclint;, 	char resbuf[64];t  ! 	USAGE(argc, 4, LOGPUT_USAGE, 0);c  4 	if (Tcl_GetInt(interp, argv[3], &tclint) != TCL_OK) 		return (TCL_ERROR);c 	flags = (u_int32_t)tclint;a    	memset(&data, 0, sizeof(data)); 	data.data = argv[2];*! 	data.size = strlen(argv[2]) + 1; 4 	if ((ret = log_put(lp, &lsn, &data, flags)) != 0) { 		errno = ret;/ 		Tcl_SetResult(interp, "ERROR: ", TCL_STATIC);h9 		Tcl_AppendResult(interp, Tcl_PosixError(interp), NULL);n 		return (TCL_ERROR);o 	}  G 	snprintf(resbuf, sizeof(resbuf), "%lu %lu", (unsigned long)lsn.offset,  	    (unsigned long)lsn.file);- 	Tcl_SetResult(interp, resbuf, TCL_VOLATILE);n 	return (TCL_OK);, }t  
 static int# log_reg_cmd(lp, interp, argc, argv)  	DB_LOG *lp; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {0	 	DB *dbp; 
 	DBTYPE type;e 	Tcl_CmdInfo cmd_info; 	u_int32_t regid;i 	int ret, tclint;c  ! 	USAGE(argc, 5, LOGREG_USAGE, 0);s4 	if (Tcl_GetInt(interp, argv[4], &tclint) != TCL_OK) 		return (TCL_ERROR);* 	type = (DBTYPE)tclint;G  > 	if (Tcl_GetCommandInfo(interp, argv[2], &cmd_info) != TCL_OK)
 		dbp = NULL;( 	elseO" 		dbp = (DB *)cmd_info.clientData;4 	ret = log_register(lp, dbp, argv[3], type, &regid); 	if (ret != 0) { 		errno = ret;/ 		Tcl_SetResult(interp, "ERROR: ", TCL_STATIC);e9 		Tcl_AppendResult(interp, Tcl_PosixError(interp), NULL);  		return (TCL_ERROR);  	}   	/*o 	 * !!!g@ 	 * Safe: interp->result is guaranteed to be at least 200 bytes. 	 */6 	sprintf(interp->result, "%lu", (unsigned long)regid); 	return (TCL_OK);o }l  
 static int get_lsn(interp, str, lsnp) 	Tcl_Interp *interp; 	char *str;I 	DB_LSN *lsnp; {A 	int largc, ret, tclint; 	char **largv;  H 	if (Tcl_SplitList(interp, str, &largc, &largv) != TCL_OK || largc != 2) 		return (TCL_ERROR);	5 	if (Tcl_GetInt(interp, largv[0], &tclint) != TCL_OK)  		goto err;)" 	lsnp->offset = (u_int32_t)tclint;5 	if (Tcl_GetInt(interp, largv[1], &tclint) != TCL_OK)C 		goto err;}  	lsnp->file = (u_int32_t)tclint; 	ret = TCL_OK;  	 	if (0) {n err:		ret = TCL_ERROR; 	}
 	free(largv);) 	return (ret); }e;  	log_number++;   	/* Create widget command. */ D 	Tcl_CreateCommand(interp, logname, logwidget_cmd, (int *)ld, NULL);. 	Tcl_SetResult(interp, logname, TCL_VOLATILE); 	return (TCL_OK);  }    /*  * logunlink_cmd -- $  *	Implements txn_unlink for dbtest.  */   / #define LOGUNLINK_USAGE "log_unlink path force"    int * logunlink_cmd(notused, interp, argc, argv) 	ClientData notused; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {  	int force;    	notused = NULL;   	debug_check();   ' 	U                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                