6 # See the file LICENSE for redistribution information. #   # Copyright (c) 1996, 1997, 1998+ #	Sleepycat Software.  All rights reserved.  # + #	@(#)test044.tcl	10.12 (Sleepycat) 10/3/98  #  # DB Test 40 {access method}H # System integration DB test: verify that locking, recovery, checkpoint,- # and all the other utilities basically work.  # G # The test consists of $nprocs processes operating on $nfiles files.  A F # transaction consists of adding the same key/data pair to some randomC # number of these files.  We generate a bimodal distribution in key A # size with 70% of the keys being small (1-10 characters) and the C # remaining 30% of the keys being large (uniform distribution about D # mean $key_avg).  If we generate a key, we first check to make sureH # that the key is not already in the dataset.  If it is, we do a lookup. # / # XXX This test uses grow-only files currently!   > proc test044 { method {nprocs 5} {nfiles 10} {cont 0} args } { source ./include.tcl   	set omethod $method 	if { $method != "all" } {% 		set method [convert_method $method]  	}& 	set args [convert_args $method $args]# 	if { [is_rbtree $omethod] == 1 } { - 		puts "Test044 skipping for method $omethod"  		return 	}  F 	puts "Test044: system integration test db $method $nprocs processes \ 	    on $nfiles files"   	# Parse options 	set otherargs "" 
 	set seeds {}  	set key_avg 10  	set data_avg 20 	set do_exit 04 	for { set i 0 } { $i < [llength $args] } {incr i} {' 		switch -regexp -- [lindex $args $i] { 5 			-key_avg { incr i; set key_avg [lindex $args $i] } 7 			-data_avg { incr i; set data_avg [lindex $args $i] } / 			-s.* { incr i; set seeds [lindex $args $i] } 5 			-testdir { incr i; set testdir [lindex $args $i] }  			-x.* { set do_exit 1 }  			default {' 				lappend otherargs [lindex $args $i]  			} 		}  	}   	if { $cont == 0 } {  & 		if { [file exists $testdir] != 1 } { 			exec $MKDIR $testdir 2 		} elseif { [file isdirectory $testdir ] != 1 } {, 			error "FAIL: $testdir is not a directory" 		}   / 		# Create the database and open the dictionary  		cleanup $testdir   		# Create an environment < 		puts "\tTest044.a: creating environment and $nfiles files"2 		set flags [expr $DB_INIT_MPOOL | $DB_INIT_LOCK \$ 		    | $DB_INIT_LOG | $DB_INIT_TXN] 		set dbenv  \> 		    [eval dbenv -dbflags $flags -dbhome $testdir $otherargs]   		# Create a bunch of files  		set m $method / 		for { set i 0 } { $i < $nfiles } { incr i } {  			if { $method == "all" } { 				switch [random_int 1 2] {  				1 { set m DB_BTREE } 				2 { set m DB_HASH }  				}  			}1 			set otherargs [add_to_args $DB_DUP $otherargs]   			set db [eval [concat dbopen \) 			    test044.$i.db $DB_CREATE 0644 $m \ ! 			    -dbenv $dbenv $otherargs]] 1 			error_check_good dbopen [is_valid_db $db] TRUE * 			error_check_good db_close [$db close] 0 		}  	} 	# Close the environment 	rename $dbenv {}    	if { $do_exit == 1 } {  		return 	}  . 	# Database is created, now fork off the kids.@ 	puts "\tTest044.b: forking off $nprocs processes and utilities" 	set cycle 1 	while { 1 } {/ 		# Fire off deadlock detector and checkpointer  		puts "Beginning cycle $cycle" 3 		set ddpid [exec ./db_deadlock -h $testdir -t 5 &] 5 		set cppid [exec ./db_checkpoint -h $testdir -p 2 &] ; 		puts "Deadlock detector: $ddpid Checkpoint daemon $cppid"    		set pidlist {}+ 		for { set i 0 } {$i < $nprocs} {incr i} {  			set s -1 ' 			if { [llength $seeds] == $nprocs } {  				set s [lindex $seeds $i] 			}8 			set p [exec ./dbtest ../test/sysscript.tcl $testdir \( 			    $nfiles $key_avg $data_avg $s > \" 			    $testdir/test044.$i.log & ] 			lappend pidlist $p  		} 7 		puts "[timestamp] $nprocs processes running $pidlist" " 		exec $SLEEP [random_int 300 600]   		# Now simulate a crash 		puts "[timestamp] Crashing"  		exec $KILL -9 $ddpid 		exec $KILL -9 $cppid 		foreach p $pidlist { 			exec $KILL -9 $p  		}    		# Now run recovery! 		test044_verify $testdir $nfiles  		incr cycle 	} }    proc test044_usage { } {I 	puts -nonewline "test044 method nentries [-d directory] [-i iterations]" $ 	puts " [-p procs] [-s {seeds} ] -x" }   $ proc test044_verify { dir nfiles } { source ./include.tcl global recd_prefix0 	# Save everything away in case something breaks- #	for { set f 0 } { $f < $nfiles } {incr f} { 4 #		exec $CP $dir/test044.$f.db $dir/test044.$f.save1 #	}  #	foreach f [glob $dir/log.*] { $ #		if { [is_substr $f save] == 0 } { #			exec $CP $f $f.save1 #		} #	}   D 	# Run recovery and then read through all the database files to make  	# sure that they all look good.  F 	puts "\tTest044.verify: Running recovery and verifying file contents"7 	set stat [catch {exec ./db_recover -v -h $dir} result]  	if { $stat == 1 && . 	    [is_substr $result $recd_prefix] == 0 } {( 		error "FAIL: Recovery error: $result." 	}  0 	# Save everything away in case something breaks- #	for { set f 0 } { $f < $nfiles } {incr f} { 4 #		exec $CP $dir/test044.$f.db $dir/test044.$f.save2 #	}  #	foreach f [glob $dir/log.*] { $ #		if { [is_substr $f save] == 0 } { #			exec $CP $f $f.save2 #		} #	}   . 	for { set f 0 } { $f < $nfiles } { incr f } { 		set db($f) \> 		    [eval dbopen test044.$f.db 0 0 DB_UNKNOWN  -dbhome $dir]7 		error_check_good $f:dbopen [is_valid_db $db($f)] TRUE   $ 		set cursors($f) [$db($f) cursor 0]2 		error_check_bad $f:cursor_open $cursors($f) NULLD 		error_check_good $f:cursor_open [is_substr $cursors($f) $db($f)] 1 	}  . 	for { set f 0 } { $f < $nfiles } { incr f } {/ 		for {set d [$cursors($f) get 0 $DB_FIRST] } \ # 		    { [string length $d] != 0 } \ / 		    { set d [$cursors($f) get 0 $DB_NEXT] } {    			set k [lindex $d 0] 			set d [lindex $d 1]    			set flist [zero_list $nfiles] 			set r $d 2 			while { [set ndx [string first : $r]] != -1 } {0 				set fnum [string range $r 0 [expr $ndx - 1]]' 				if { [lindex $flist $fnum] == 0 } {  					set fl $DB_SET  				} else { 					set fl $DB_NEXT 				}   * 				if { $fl != $DB_SET || $fnum != $f } {* 					set full [$cursors($fnum) get $k $fl] 					set key [lindex $full 0]  					set rec [lindex $full 1] * 					error_check_good $f:dbget_$fnum:key \ 					    $key $k+ 					error_check_good $f:dbget_$fnum:data \  					    $rec $d 				}   - 				set flist [lreplace $flist $fnum $fnum 1]  				incr ndx$ 				set r [string range $r $ndx end] 			} 		}  	}  . 	for { set f 0 } { $f < $nfiles } { incr f } {6 		error_check_good $cursors($f) [$cursors($f) close] 00 		error_check_good db_close:$f [$db($f) close] 0 	} }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     