 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */    #include "config.h"    #ifndef lintF static const char sccsid[] = "@(#)utils.c	10.69 (Sleepycat) 12/16/98"; #endif /* not lint */    /*4  * This file is divided up into 4 sets of functions:3  * 1. The dbopen command and its support functions. )  * 2. The dbwidget and dbcursor commands. 3  * 3. The db support functions (e.g. get, put, del) 6  * 4. The cursor support functions (e.g. get put, del)  */    #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <stdlib.h>  #include <string.h>  #include <time.h>  #include <unistd.h>  #endif #include <tcl.h>   #include "db_int.h"  #include "db_page.h" #include "hash.h"  #include "dbtest.h"  #include "test_ext.h"    /* Internal functions */J int db_del_cmd __P((Tcl_Interp *interp, int argc, char *argv[], DB *dbp));J int db_get_cmd __P((Tcl_Interp *interp, int argc, char *argv[], DB *dbp));M int db_getbin_cmd __P((Tcl_Interp *interp, int argc, char *argv[], DB *dbp)); K int db_join_cmd __P((Tcl_Interp *interp, int argc, char *argv[], DB *dbp)); J int db_put_cmd __P((Tcl_Interp *interp, int argc, char *argv[], DB *dbp));M int db_putbin_cmd __P((Tcl_Interp *interp, int argc, char *argv[], DB *dbp)); L int dbc_del_cmd __P((Tcl_Interp *interp, int argc, char *argv[], DBC *dbc));L int dbc_get_cmd __P((Tcl_Interp *interp, int argc, char *argv[], DBC *dbc));O int dbc_getbin_cmd __P((Tcl_Interp *interp, int argc, char *argv[], DBC *dbc)); L int dbc_put_cmd __P((Tcl_Interp *interp, int argc, char *argv[], DBC *dbc));B int dbt_from_file __P((Tcl_Interp *interp, char *file, DBT *dbt));@ int dbt_to_file __P((Tcl_Interp *interp, char *file, DBT *dbt));7 u_int8_t *list_to_numarray __P((Tcl_Interp *, char *)); 8 void set_get_result __P((Tcl_Interp *interp, DBT *dbt));   /*  * XXXG  * Freeing memory allocated by the TCL library currently fails on Win*, D  * probably due to a mismatch of malloc/free implementations betweenF  * the TCL library and this module.  Sidestep the issue for now by not  * freeing on Win* platforms.   */ 
 #ifdef _WIN32  #define	FREE_TCL(x)  #else  #define	FREE_TCL(x)	free(x)  #endif   /*  * dbopen_cmd -->  *	Implements dbopen for dbtest.  Dbopen creates a widget that:  * implements all the commands found off the DB structure.  */   L #define DBOPEN_USAGE "dbopen file flags mode type [options]\n\toptions:\n\t"   int ' dbopen_cmd(notused, interp, argc, argv)  	ClientData notused; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {  	static int db_number = 0; 	static const struct { 		char *str; 		DBTYPE type;
 	} list[] = {  		{"DB_UNKNOWN",	DB_UNKNOWN},  		{"db_unknown",	DB_UNKNOWN},  		{"UNKNOWN",	DB_UNKNOWN}, 		{"unknown",	DB_UNKNOWN}, 		{"DB_BTREE",	DB_BTREE},  		{"db_btree",	DB_BTREE},  		{"BTREE",	DB_BTREE}, 		{"btree",	DB_BTREE}, 		{"DB_HASH",	DB_HASH},  		{"db_hash",	DB_HASH},  		{"HASH",	DB_HASH}, 		{"hash",	DB_HASH}, 		{"DB_RECNO",	DB_RECNO},  		{"db_recno",	DB_RECNO},  		{"RECNO",	DB_RECNO}, 		{"recno",	DB_RECNO}, 		{ 0 }  	}, *lp;	 	DB *dbp; 
 	DBTYPE type; 
 	DB_ENV *env;  	DB_INFO *openinfo;  	u_int32_t flags;  	int mode, ret, tclint;  	char dbname[50], *name;   	notused = NULL;  ! 	/* Check number of arguments. */ * 	USAGE_GE(argc, 5, DBOPEN_USAGE, DO_INFO);   	/* Check flags and mode. */4 	if (Tcl_GetInt(interp, argv[2], &tclint) != TCL_OK)
 		goto usage;  	flags = (u_int32_t)tclint; 4 	if (Tcl_GetInt(interp, argv[3], &mode) != TCL_OK) {  usage:		Tcl_AppendResult(interp,6 		    "\nUsage: ", DBOPEN_USAGE, DB_INFO_FLAGS, NULL); 		return (TCL_OK); 	}  6 	name = strcmp(argv[1], "NULL") == 0 ? NULL : argv[1];  ; 	process_am_options(interp, argc - 5, &argv[5], &openinfo); 7 	process_env_options(interp, argc - 5, &argv[5], &env);    	/* Figure out type. */  	COMPQUIET(type, DB_HASH);' 	for (lp = list; lp->str != NULL; ++lp) & 		if (strcmp(argv[4], lp->str) == 0) { 			type = lp->type; 	 			break;  		}  	if (lp->str == NULL) { 4 		Tcl_SetResult(interp, "Invalid type", TCL_STATIC); 		return (TCL_ERROR);  	}  . 	if (openinfo == NULL && type != DB_UNKNOWN) {3 		Tcl_AppendResult(interp, "Usage: ", DBOPEN_USAGE,  		    DB_INFO_FLAGS, NULL);  		return (TCL_ERROR);  	}   	debug_check();    	/* Call dbopen. */ = 	ret = db_open(name, type, flags, mode, env, openinfo, &dbp); % 	if (openinfo && openinfo->re_source)  		free(openinfo->re_source); 	if (openinfo) 		free(openinfo);  	if (ret != 0) {0 		Tcl_SetResult(interp, "dbopen: ", TCL_STATIC); 		errno = ret;9 		Tcl_AppendResult(interp, Tcl_PosixError(interp), NULL);  		return (TCL_OK); 	}   	/* Create widget command. */  	/* Create new command name. */ 5 	snprintf(dbname, sizeof(dbname), "db%d", db_number); 
 	db_number++;   H 	Tcl_CreateCommand(interp, dbname, dbwidget_cmd, (ClientData)dbp, NULL);- 	Tcl_SetResult(interp, dbname, TCL_VOLATILE);  	return (TCL_OK);  }    /*  * process_am_options --F  *	Read the options in the command line and create a DB_INFO structure  *	to pass to db_open.  */  int 0 process_am_options(interp, argc, argv, openinfo) 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; 	DB_INFO **openinfo; { 
 	DB_INFO *oi;  	int err, tclint;  	char *option;   	COMPQUIET(option, NULL);    	err = TCL_OK;, 	oi = (DB_INFO *)calloc(sizeof(DB_INFO), 1);   	while (argc >= 1) {6 		if (**argv != '-') {		/* Make sure it's an option */
 			argc--;
 			argv++; 			continue; 		} / 		/* Set option to first character after "-" */  		option = argv[0];  		option++;    		if (argc == 1)	 			break;   % 		if (strcmp(option, "flags") == 0) { , 	/* Contains flags for all access methods */ 	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break;! 			oi->flags = (u_int32_t)tclint; , 		} else if (strcmp(option, "psize") == 0) { 	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break;$ 			oi->db_pagesize = (size_t)tclint;, 		} else if (strcmp(option, "order") == 0) { 	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break; 			oi->db_lorder = (int)tclint; 0 		} else if (strcmp(option, "cachesize") == 0) { 	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break;% 			oi->db_cachesize = (size_t)tclint; - 		} else if (strcmp(option, "minkey") == 0) {  	/* Btree flags */ 	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break;% 			oi->bt_minkey = (u_int32_t)tclint; . 		} else if (strcmp(option, "compare") == 0) {% 			/* Not sure how to handle this. */  			err = TCL_ERROR; - 		} else if (strcmp(option, "prefix") == 0) { % 			/* Not sure how to handle this. */  			err = TCL_ERROR; . 		} else if (strcmp(option, "ffactor") == 0) { 	/* Hash flags */  	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break;% 			oi->h_ffactor = (u_int32_t)tclint; , 		} else if (strcmp(option, "nelem") == 0) { 	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break;# 			oi->h_nelem = (u_int32_t)tclint; + 		} else if (strcmp(option, "hash") == 0) {  	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break; 			switch (tclint) {, 				case 2: oi->h_hash = __ham_func2; break;, 				case 3: oi->h_hash = __ham_func3; break;, 				case 4: oi->h_hash = __ham_func4; break;, 				case 5: oi->h_hash = __ham_func5; break; 			} 			if (oi->h_hash == NULL) { 				err = TCL_ERROR;
 				break; 			}/ 		} else if (strcmp(option, "recdelim") == 0) {  	/* Recno flags */ 	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break; 			oi->re_delim = (int)tclint;- 		} else if (strcmp(option, "recpad") == 0) {  	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break; 			oi->re_pad = (int)tclint;- 		} else if (strcmp(option, "reclen") == 0) {  	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break;" 			oi->re_len = (u_int32_t)tclint;+ 		} else if (strcmp(option, "recsrc") == 0)n/ 			 (void)__os_strdup(argv[1], &oi->re_source);1   		argc -= 2; 		argv += 2; 	} 	if (err != TCL_OK) {  		Tcl_AppendResult(interp,= 		    "\nInvalid ", option, " value: ", argv[1], "\n", NULL);e 		free(oi);/ 		oi = NULL; 	} 	*openinfo = oi; 	return (oi ? 0 : 1);  }i   /*  * process_env_options --hE  *	Read the options in the command line and create a DB_ENV structurec  *	to pass to db_open.  */b into0 process_env_options(interp, argc, argv, envinfo) 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; 	DB_ENV **envinfo; {D
 	DB_ENV *env;y 	Tcl_CmdInfo info; 	u_int32_t flags;u 	int err, nconf, tclint;" 	char *option, *db_home, **config; 	u_int8_t *conflicts;f   	COMPQUIET(option, NULL);e 	err = TCL_OK; 	flags = 0;g, 	db_home = Tcl_GetVar(interp, "testdir", 0); 	config = NULL;e 	conflicts = NULL;  + 	env = (DB_ENV *)calloc(sizeof(DB_ENV), 1);* 	while (argc > 1) {r6 		if (**argv != '-') {		/* Make sure it's an option */
 			argc--;
 			argv++; 			continue; 		}n/ 		/* Set option to first character after "-" */, 		option = argv[0];p 		option++;j  - 		if (argv[1] == NULL || argv[1][0] == '-') {a- 			Tcl_SetResult(interp, "Invalid options: ",e 			    TCL_STATIC); $ 			Tcl_AppendResult(interp, argv[0], 			   "requires parameter", 0);t 			return (TCL_ERROR); 		})  % 		if (strcmp(option, "dbenv") == 0) {r" 	/* environment already set up. */9 			if (Tcl_GetCommandInfo(interp, argv[1], &info) == 0) {  				Tcl_SetResult(interp,b- 				    "Invalid environment: ", TCL_STATIC); ) 				Tcl_AppendResult(interp, argv[1], 0);  				return (TCL_ERROR);i 			}
 			free(env);,( 			*envinfo = (DB_ENV *)info.clientData; 			return (TCL_OK);f. 		} else if (strcmp(option, "dbflags") == 0) { 	/* db_appinit parameters */ 	    		if ((err =t; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK)l
 				break; 			flags = (u_int32_t)tclint;* 			/*X7 			 * Don't specify DB_THREAD if the architecture can'ty 			 * do spinlocks.p 			 */ #ifndef HAVE_SPINLOCKS 			LF_CLR(DB_THREAD);s #endif- 		} else if (strcmp(option, "dbhome") == 0) {  			db_home = argv[1];t/ 		} else if (strcmp(option, "dbconfig") == 0) {I9 			err = Tcl_SplitList(interp, argv[1], &nconf, &config);e 			if (err) 
 				break;/ 		} else if (strcmp(option, "maxlocks") == 0) {p 	/* Lock flags */  	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK) 
 				break;# 			env->lk_max = (u_int32_t)tclint;s- 		} else if (strcmp(option, "nmodes") == 0) {  	    		if ((err = ; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK)a
 				break;% 			env->lk_modes = (u_int32_t)tclint; - 		} else if (strcmp(option, "detect") == 0) {} 	    		if ((err =B; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK)"
 				break;& 			env->lk_detect = (u_int32_t)tclint;0 		} else if (strcmp(option, "conflicts") == 0) {1 			conflicts = list_to_numarray(interp, argv[1]);, 			if (conflicts == NULL) 
 				break;! 			env->lk_conflicts = conflicts; . 		} else if (strcmp(option, "maxsize") == 0) { 	/* Log flags */ 	    		if ((err =N; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK)D
 				break;# 			env->lg_max = (u_int32_t)tclint;O0 		} else if (strcmp(option, "cachesize") == 0) { 	/* Mpool flags */ 	    		if ((err =n; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK)G
 				break;! 			env->mp_size = (size_t)tclint; . 		} else if (strcmp(option, "maxtxns") == 0) { 	/* Txn flags */ 	    		if ((err =e; 	    		    Tcl_GetInt(interp, argv[1], &tclint)) != TCL_OK)v
 				break;# 			env->tx_max = (u_int32_t)tclint;t, 		} else if (strcmp(option, "rinit") == 0) { 	/* Region init */6 			if ((err = db_value_set(1, DB_REGION_INIT)) != 0) { 				if (err == EINVAL) { 					Tcl_SetResult(interp, 					    "EINVAL", TCL_STATIC);  					return (TCL_ERROR); 				}g 				Tcl_SetResult(interp, " 				    "env/rinit:", TCL_STATIC); 				errno = err; 				Tcl_AppendResult(interp,# 				    Tcl_PosixError(interp), 0);> 				return (TCL_ERROR);p 			}, 		} else if (strcmp(option, "shmem") == 0) {" 	/* Shared memory specification */& 			if (strcmp(argv[1], "anon") == 0) { 				if ((err =0 				    db_value_set(1, DB_REGION_ANON)) != 0) { 					if (err == EINVAL) {" 						Tcl_SetResult(interp,F  						    "EINVAL", TCL_STATIC); 						return (TCL_ERROR);) 					} 					Tcl_SetResult(interp,# 					    "env/shmem:", TCL_STATIC);o 					errno = err;i 					Tcl_AppendResult(interp,r$ 					    Tcl_PosixError(interp), 0); 					return (TCL_ERROR); 				} . 			} else if (strcmp(argv[1], "named") == 0) { 				if ((err =0 				    db_value_set(1, DB_REGION_NAME)) != 0) { 					if (err == EINVAL) {  						Tcl_SetResult(interp,/  						    "EINVAL", TCL_STATIC); 						return (TCL_ERROR);  					} 					Tcl_SetResult(interp,# 					    "env/shmem:", TCL_STATIC);  					errno = err;d 					Tcl_AppendResult(interp,($ 					    Tcl_PosixError(interp), 0); 					return (TCL_ERROR); 				}  			} else {O 				Tcl_SetResult(interp,a, 				    "Invalid shmem option", TCL_STATIC);, 				Tcl_AppendResult(interp, argv[1], NULL); 				return (TCL_OK); 			} 		}c   		argc -= 2; 		argv += 2; 	} 	if (err != TCL_OK) { < 		Tcl_AppendResult(interp, "\nInvalid ", option, " value: ", 		    argv[1], "\n", NULL);c 		if (conflicts != NULL) 			free(conflicts);L 		free(env);
 		env = NULL;  	}   	/*c 	 * Set up error stuff.; 	 */ 	if (env) {  		env->db_errfile = stderr;	 		env->db_errpfx = "dbtest"; 		env->db_errcall = NULL;	 		env->db_verbose = 0;  ? 		if ((errno = db_appinit(db_home, config, env, flags)) != 0) {	
 			free(env);	 			env = NULL; 		}e 	}   	if (config) 		FREE_TCL(config);0   	*envinfo = env; 	return (env ? 0 : 1); }    /*  * dbwidget --=  *	Since dbopen creates a widget, we need a command that then A  * handles all the widget commands.  This is that command.  If we(:  * ever add new "methods" we add new widget commands here.  */n1 #define DBWIDGET_USAGE "dbN option ?arg arg ...?";! #define DBCLOSE_USAGE "dbN close"n- #define DBCURS_USAGE "dbN cursor txn [flags]"{ #define DBFD_USAGE "dbN fd" % #define DBSYNC_USAGE "dbN sync flags")# #define	DBLOCKER_USAGE "dbN locker"o   int(( dbwidget_cmd(cd_dbp, interp, argc, argv) 	ClientData cd_dbp;  	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {v 	static int curs_id = 0;	 	DB *dbp;;
 	DBC *cursor;h
 	DB_ENV *env;) 	DB_TXN *txnid;e 	Tcl_CmdInfo info; 	u_int32_t flags;  	int fd, ret, tclint;  	char cursname[128]; 	u_int8_t *conflicts;    	dbp = (DB *)cd_dbp;  & 	USAGE_GE(argc, 2, DBWIDGET_USAGE, 0);  ( 	Tcl_SetResult(interp, "0", TCL_STATIC);  % 	if (strcmp(argv[1], "close") == 0) {t# 		USAGE(argc, 2, DBCLOSE_USAGE, 0);R 		env = dbp->dbenv;m 		debug_check(); #ifdef STATISTICSo 		if (dbp->stat != NULL)  			(void)dbp->stat(dbp, stdout); #endif 		ret = dbp->close(dbp, 0);)0 		if (env && !F_ISSET(env, DB_ENV_STANDALONE)) { 			(void)db_appexit(env);v- 			conflicts = (u_int8_t *)env->lk_conflicts;h 			if (conflicts != NULL)t 				free(conflicts);
 			free(env);m 		} + 		(void)Tcl_DeleteCommand(interp, argv[0]);n 		if (ret < 0)* 			Tcl_SetResult(interp, "1", TCL_STATIC); 		else if (ret > 0) {c2 			Tcl_SetResult(interp, "db_close:", TCL_STATIC); 			errno = ret; 7 			Tcl_AppendResult(interp, Tcl_PosixError(interp), 0);C 		} else* 			Tcl_SetResult(interp, "0", TCL_STATIC); 		return (TCL_OK);- 	} else if (strcmp(argv[1], "cursor") == 0) {n% 		USAGE_GE(argc, 3, DBCURS_USAGE, 0);h 		snprintf(cursname,9 		    sizeof(cursname), "%s.cursor%d", argv[0], curs_id);h 		curs_id++;. 		if (argv[2][0] == '0' && argv[2][1] == '\0') 			txnid = NULL; 		else {9 			if (Tcl_GetCommandInfo(interp, argv[2], &info) == 0) {  				Tcl_SetResult(interp, 1 				    "db_del: Invalid argument ", TCL_STATIC);r% 				Tcl_AppendResult(interp, argv[2],r" 				    " not a transaction.", 0); 				return (TCL_ERROR);  			}% 			txnid = (DB_TXN *)info.clientData;_ 		}  		debug_check(); 		if (argc == 4) {6 			if (Tcl_GetInt(interp, argv[3], &tclint) != TCL_OK) 				return (TCL_ERROR);  			flags = (u_int32_t)tclint;c 		} else
 			flags = 0;r= 		if ((ret = dbp->cursor(dbp, txnid, &cursor, flags)) == 0) {p4 			Tcl_CreateCommand(interp, cursname, dbcursor_cmd,! 			    (ClientData)cursor, NULL); 1 			Tcl_SetResult(interp, cursname, TCL_VOLATILE);e
 		} else {3 			Tcl_SetResult(interp, "db_cursor:", TCL_STATIC);, 			errno = ret;	7 			Tcl_AppendResult(interp, Tcl_PosixError(interp), 0);o 		}  		return (TCL_OK);* 	} else if (strcmp(argv[1], "del") == 0) {/ 		return (db_del_cmd(interp, argc, argv, dbp));r) 	} else if (strcmp(argv[1], "fd") == 0) {c  		USAGE(argc, 2, DBFD_USAGE, 0); 		Tcl_ResetResult(interp); 		debug_check(); 		(void)dbp->fd(dbp, &fd); 		/* 		 * !!!A 		 * Safe: interp->result is guaranteed to be at least 200 bytes., 		 */;$ 		sprintf(interp->result, "%d", fd); 		return (TCL_OK);* 	} else if (strcmp(argv[1], "get") == 0) {/ 		return (db_get_cmd(interp, argc, argv, dbp)); + 	} else if (strcmp(argv[1], "bget") == 0) {=/ 		return (db_get_cmd(interp, argc, argv, dbp)); + 	} else if (strcmp(argv[1], "getn") == 0) {-/ 		return (db_get_cmd(interp, argc, argv, dbp)); - 	} else if (strcmp(argv[1], "getbin") == 0) { 2 		return (db_getbin_cmd(interp, argc, argv, dbp));0 	} else if (strcmp(argv[1], "getbinkey") == 0) {2 		return (db_getbin_cmd(interp, argc, argv, dbp));+ 	} else if (strcmp(argv[1], "join") == 0) {p0 		return (db_join_cmd(interp, argc, argv, dbp));* 	} else if (strcmp(argv[1], "put") == 0) {/ 		return (db_put_cmd(interp, argc, argv, dbp));o+ 	} else if (strcmp(argv[1], "putn") == 0) {n/ 		return (db_put_cmd(interp, argc, argv, dbp));e- 	} else if (strcmp(argv[1], "putbin") == 0) { 2 		return (db_putbin_cmd(interp, argc, argv, dbp));0 	} else if (strcmp(argv[1], "putbinkey") == 0) {2 		return (db_putbin_cmd(interp, argc, argv, dbp));+ 	} else if (strcmp(argv[1], "put0") == 0) {n/ 		return (db_put_cmd(interp, argc, argv, dbp));/+ 	} else if (strcmp(argv[1], "sync") == 0) {n" 		USAGE(argc, 3, DBSYNC_USAGE, 0);5 		if (Tcl_GetInt(interp, argv[2], &tclint) != TCL_OK)	 			return (TCL_ERROR); 		flags = (u_int32_t)tclint; 		debug_check();( 		if ((ret = dbp->sync(dbp, flags)) < 0)* 			Tcl_SetResult(interp, "1", TCL_STATIC); 		else if (ret > 0) {=1 			Tcl_SetResult(interp, "db_sync:", TCL_STATIC);( 			errno = ret;"7 			Tcl_AppendResult(interp, Tcl_PosixError(interp), 0);f 		} else* 			Tcl_SetResult(interp, "0", TCL_STATIC); 		return (TCL_OK);	 	} else { 4 		Tcl_SetResult(interp, DBWIDGET_USAGE, TCL_STATIC); 		return (TCL_ERROR);v 	} }c  2 #define DBCURSOR_USAGE "dbN.cursorM ?arg arg ...?"* #define DBCCLOSE_USAGE "dbN.cursorM close" inte( dbcursor_cmd(cd_dbc, interp, argc, argv) 	ClientData cd_dbc;  	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {k
 	DBC *dbc;   	dbc = (DBC *)cd_dbc;e( 	Tcl_SetResult(interp, "0", TCL_STATIC);  % 	if (strcmp(argv[1], "close") == 0) {n$ 		USAGE(argc, 2, DBCCLOSE_USAGE, 0); 		debug_check(); 		(void)dbc->c_close(dbc);. 		return (Tcl_DeleteCommand(interp, argv[0]));* 	} else if (strcmp(argv[1], "del") == 0) {0 		return (dbc_del_cmd(interp, argc, argv, dbc));* 	} else if (strcmp(argv[1], "get") == 0) {0 		return (dbc_get_cmd(interp, argc, argv, dbc));+ 	} else if (strcmp(argv[1], "bget") == 0) {T0 		return (dbc_get_cmd(interp, argc, argv, dbc));+ 	} else if (strcmp(argv[1], "getn") == 0) {t0 		return (dbc_get_cmd(interp, argc, argv, dbc));- 	} else if (strcmp(argv[1], "getbin") == 0) { 3 		return (dbc_getbin_cmd(interp, argc, argv, dbc));K0 	} else if (strcmp(argv[1], "getbinkey") == 0) {3 		return (dbc_getbin_cmd(interp, argc, argv, dbc)); * 	} else if (strcmp(argv[1], "put") == 0) {0 		return (dbc_put_cmd(interp, argc, argv, dbc));+ 	} else if (strcmp(argv[1], "putn") == 0) {i0 		return (dbc_put_cmd(interp, argc, argv, dbc));	 	} else {n4 		Tcl_SetResult(interp, DBCURSOR_USAGE, TCL_STATIC); 		return (TCL_ERROR);  	} 	/* NOTREACHED */S }e   /* Widget support commands. */  + #define DBDEL_USAGE "dbN del txn key flags"  intc# db_del_cmd(interp, argc, argv, dbp)n 	Tcl_Interp *interp;
 	int argc; 	char *argv[];	 	DB *dbp;t {,	 	DBT key;c 	DB_TXN *txnid;r 	Tcl_CmdInfo info; 	db_recno_t rkey;} 	u_int32_t flags;m 	int ret, tclint;=    	USAGE(argc, 5, DBDEL_USAGE, 0);  6 	if (Tcl_GetInt(interp, argv[4], &tclint) != TCL_OK) {4 		Tcl_AppendResult(interp, "\n", DBDEL_USAGE, NULL); 		return (TCL_ERROR);L 	} 	flags = (u_int32_t)tclint;F   	memset(&key, 0, sizeof(key)); 	if (dbp->type == DB_RECNO) {	5 		if (Tcl_GetInt(interp, argv[3], &tclint) != TCL_OK), 			return (TCL_ERROR); 		rkey = (db_recno_t)tclint; 		key.data = &rkey;   		key.size = sizeof(db_recno_t);	 	} else {L 		key.data = argv[3];e9 		key.size = strlen(argv[3]) + 1;		/* Add NULL on end. */	 	}  - 	if (argv[2][0] == '0' && argv[2][1] == '\0')i 		txnid = NULL;  	else {	8 		if (Tcl_GetCommandInfo(interp, argv[2], &info) == 0) { 			Tcl_SetResult(interp,0 			    "db_del: Invalid argument ", TCL_STATIC);$ 			Tcl_AppendResult(interp, argv[2],! 			    " not a transaction.", 0);p 			return (TCL_ERROR); 		}n$ 		txnid = (DB_TXN *)info.clientData; 	}   	debug_check();	  4 	if ((ret = dbp->del(dbp, txnid, &key, flags)) == 0) 		return (TCL_OK); 	else if (ret == DB_NOTFOUND) {  		Tcl_ResetResult(interp);A 		Tcl_AppendResult(interp, "Key ", argv[3], " not found.", NULL);  		return (TCL_OK);	 	} else {"* 		Tcl_SetResult(interp, "-1", TCL_STATIC); 		return (TCL_OK); 	} }o  5 #define DBGET_USAGE "dbN get txn key flags [beg len]"n; #define DBBGET_USAGE "dbN get txn key data flags [beg len]"e int # db_get_cmd(interp, argc, argv, dbp)- 	Tcl_Interp *interp;
 	int argc; 	char *argv[];	 	DB *dbp;_ {b 	DBT data, key;( 	DB_TXN *txnid;i 	Tcl_CmdInfo info; 	db_recno_t ikey;	 	u_int32_t flags;	 	int arg_off, ret, tclint;  $ 	if (strcmp(argv[1], "bget") == 0) {" 		USAGE(argc, 6, DBBGET_USAGE, 0); 		arg_off = 5;	 	} else { $ 		USAGE_GE(argc, 5, DBGET_USAGE, 0); 		arg_off = 4; 	}  < 	if (Tcl_GetInt(interp, argv[arg_off], &tclint) != TCL_OK) {4 		Tcl_AppendResult(interp, "\n", DBGET_USAGE, NULL); 		return (TCL_ERROR);d 	} 	flags = (u_int32_t)tclint;?   	memset(&key, 0, sizeof(key));= 	if (dbp->type == DB_RECNO || strcmp(argv[1], "getn") == 0) {{5 		if (Tcl_GetInt(interp, argv[3], &tclint) != TCL_OK)b 			return (TCL_ERROR); 		ikey = (db_recno_t)tclint; 		key.data = &ikey;c  		key.size = sizeof(db_recno_t);	 	} else {p 		key.data = argv[3];;7 		key.size = strlen(argv[3]) + 1;	/* Add Null on end */; 	}    	memset(&data, 0, sizeof(data));   	/*DC 	 * If we have "too many" arguments, check for a partial retrieval.  	 */ 	if (argc > arg_off + 3 &&8 	    strcmp(argv[arg_off + 1], "DB_DBT_PARTIAL") == 0) { 		/* We have a partial */;+ 		USAGE(argc, arg_off + 4, DBGET_USAGE, 0); ? 		if (Tcl_GetInt(interp, argv[arg_off + 2], &tclint) != TCL_OK)E 			return (TCL_ERROR); 		data.doff = (size_t)tclint;i? 		if (Tcl_GetInt(interp, argv[arg_off + 3], &tclint) != TCL_OK)p 			return (TCL_ERROR); 		data.dlen = (size_t)tclint;( 		data.flags = DB_DBT_PARTIAL; 		flags = 0; 	} 	if (flags == DB_GET_BOTH) { 		data.data = argv[4];" 		data.size = strlen(argv[4]) + 1; 	}  - 	if (argv[2][0] == '0' && argv[2][1] == '\0')	 		txnid = NULL;o 	else {e8 		if (Tcl_GetCommandInfo(interp, argv[2], &info) == 0) { 			Tcl_SetResult(interp,0 			    "db_get: Invalid argument ", TCL_STATIC);$ 			Tcl_AppendResult(interp, argv[2],! 			    " not a transaction.", 0);E 			return (TCL_ERROR); 		} $ 		txnid = (DB_TXN *)info.clientData; 	}   	debug_check();;    	if (F_ISSET(dbp, DB_AM_THREAD)) 		F_SET(&data, DB_DBT_MALLOC);= 	if ((ret = dbp->get(dbp, txnid, &key, &data, flags)) == 0) {m 		Tcl_ResetResult(interp);  		set_get_result(interp, &data);$ 		if (F_ISSET(&data, DB_DBT_MALLOC)) 			free(data.data);	 		return (TCL_OK);! 	} else if (ret == DB_NOTFOUND) {o 		Tcl_ResetResult(interp);A 		Tcl_AppendResult(interp, "Key ", argv[3], " not found.", NULL);	 		return (TCL_OK);	 	} else {]* 		Tcl_SetResult(interp, "-1", TCL_STATIC); 		return (TCL_OK); 	} }    /*C  * Used for getting and verifying the data associated with a binary=D  * data field in the database.  These are big and tend to crash tcl.B  * We do the handling of the big stuff in C.  The path is the file2  * into which to write the large key/data element.  */l6 #define DBGETBIN_USAGE "dbN getbin path txn key flags" into& db_getbin_cmd(interp, argc, argv, dbp) 	Tcl_Interp *interp;
 	int argc; 	char *argv[];	 	DB *dbp;l {{ 	DBT data, key;t 	DB_TXN *txnid;o 	Tcl_CmdInfo info; 	db_recno_t rkey;	 	u_int32_t flags;n 	int ret, tclint;r  # 	USAGE(argc, 6, DBGETBIN_USAGE, 0);;  6 	if (Tcl_GetInt(interp, argv[5], &tclint) != TCL_OK) {4 		Tcl_AppendResult(interp, "\n", DBGET_USAGE, NULL); 		return (TCL_ERROR);  	} 	flags = (u_int32_t)tclint;0   	memset(&key, 0, sizeof(key));) 	if (strcmp(argv[1], "getbinkey") == 0) { 5 		if (dbt_from_file(interp, argv[4], &key) != TCL_OK)  			return (TCL_ERROR);$ 	} else if (dbp->type == DB_RECNO) {5 		if (Tcl_GetInt(interp, argv[4], &tclint) != TCL_OK)[ 			return (TCL_ERROR); 		rkey = (db_recno_t)tclint; 		key.data = &rkey;s  		key.size = sizeof(db_recno_t);	 	} else {u 		key.data = argv[4];a7 		key.size = strlen(argv[4]) + 1;	/* Add Null on end */= 	}    	memset(&data, 0, sizeof(data));' 	if (strcmp(argv[1], "getbinkey") != 0)[ 		F_SET(&data, DB_DBT_MALLOC);  - 	if (argv[3][0] == '0' && argv[3][1] == '\0')s 		txnid = NULL;[ 	else {i8 		if (Tcl_GetCommandInfo(interp, argv[3], &info) == 0) { 			Tcl_SetResult(interp,3 			    "db_getbin: Invalid argument ", TCL_STATIC);n$ 			Tcl_AppendResult(interp, argv[3],! 			    " not a transaction.", 0);e 			return (TCL_ERROR); 		},$ 		txnid = (DB_TXN *)info.clientData; 	}   	debug_check();   G 	if ((ret = dbp->get(dbp, txnid, &key, &data, flags)) == DB_NOTFOUND) {] 		Tcl_ResetResult(interp);A 		Tcl_AppendResult(interp, "Key ", argv[3], " not found.", NULL);g 		return (TCL_OK); 	} else if (ret != 0) {i* 		Tcl_SetResult(interp, "-1", TCL_STATIC); 		return (TCL_OK); 	}  " 	/* Got item; write it to file. */) 	if (strcmp(argv[1], "getbinkey") == 0) {a 		free(key.data);01 		Tcl_SetResult(interp, data.data, TCL_VOLATILE);_	 	} else {r4 		if (dbt_to_file(interp, argv[2], &data) != TCL_OK) 			return (TCL_ERROR);/ 		Tcl_SetResult(interp, argv[2], TCL_VOLATILE);c 	}   	return (TCL_OK);l }t  0 #define DBPUT_USAGE "dbN put txn key data flags"; #define DBPPUT_USAGE "dbN put txn key data flags doff dlen"e int=# db_put_cmd(interp, argc, argv, dbp)c 	Tcl_Interp *interp;
 	int argc; 	char *argv[];	 	DB *dbp;, {" 	DBT data, key;	 	DB_TXN *txnid;  	Tcl_CmdInfo info; 	db_recno_t ikey;I 	u_int32_t flags;T 	int ret, tclint;_ 	char numbuf[16];   # 	USAGE_GE(argc, 6, DBPUT_USAGE, 0);g  6 	if (Tcl_GetInt(interp, argv[5], &tclint) != TCL_OK) {4 		Tcl_AppendResult(interp, "\n", DBPUT_USAGE, NULL); 		return (TCL_ERROR);r 	} 	flags = (u_int32_t)tclint;g   	memset(&key, 0, sizeof(key));= 	if (strcmp(argv[1], "putn") == 0 || dbp->type == DB_RECNO) {s5 		if (Tcl_GetInt(interp, argv[3], &tclint) != TCL_OK)L 			return (TCL_ERROR); 		ikey = (db_recno_t)tclint; 		key.data = &ikey;_  		key.size = sizeof(db_recno_t);	 	} else {( 		key.data = argv[3];=7 		key.size = strlen(argv[3]) + 1;	/* Add Null on end */  	}    	memset(&data, 0, sizeof(data)); 	data.data = argv[4];mF 	data.size = strlen(argv[4]) + (strcmp(argv[1], "put0") == 0 ? 0 : 1);   	/*e> 	 * If the partial flag is set, then arguments 6 and 7 are the# 	 * offset and length respectively.( 	 */: 	if (argc > 6 && strcmp(argv[6], "DB_DBT_PARTIAL") == 0) {% 		USAGE_GE(argc, 9, DBPPUT_USAGE, 0);b5 		if (Tcl_GetInt(interp, argv[7], &tclint) != TCL_OK)a 			return (TCL_ERROR); 		data.doff = (size_t)tclint;i5 		if (Tcl_GetInt(interp, argv[8], &tclint) != TCL_OK)  			return (TCL_ERROR); 		data.dlen = (size_t)tclint;v 		data.flags = DB_DBT_PARTIAL;& 		data.size--;			/* Remove the NULL */ 		flags = 0; 	}  - 	if (argv[2][0] == '0' && argv[2][1] == '\0')p 		txnid = NULL;  	else {C8 		if (Tcl_GetCommandInfo(interp, argv[2], &info) == 0) { 			Tcl_SetResult(interp,0 			    "db_put: Invalid argument ", TCL_STATIC);$ 			Tcl_AppendResult(interp, argv[2],! 			    " not a transaction.", 0);t 			return (TCL_ERROR); 		}d$ 		txnid = (DB_TXN *)info.clientData; 	} 	debug_check();   = 	if ((ret = dbp->put(dbp, txnid, &key, &data, flags)) == 0) {A 		if (LF_ISSET(DB_APPEND)) {( 			if (key.size != sizeof(db_recno_t)) { 				Tcl_SetResult(interp,d. 				    "Error: key not integer", TCL_STATIC); 				return (TCL_ERROR);a 			}/ 			memcpy(&ikey, key.data, sizeof(db_recno_t));)7 			snprintf(numbuf, sizeof(numbuf), "%ld", (long)ikey);r/ 			Tcl_SetResult(interp, numbuf, TCL_VOLATILE);E
 		} else {* 			Tcl_SetResult(interp, "0", TCL_STATIC); 		}	 	} else if (ret < 0) { 		Tcl_ResetResult(interp);2 		Tcl_AppendResult(interp, "Error on put of key ",> 		    argv[3], " either not found or bad flag values.", NULL);	 	} else {i* 		Tcl_SetResult(interp, "-1", TCL_STATIC); 	} 	return (TCL_OK);[ }    /*E  * Used for putting very large data items into a db file.  Instead of E  * passing the data in a DB, we'll pass a file name and read the datasE  * from the file and put it in the db.  This can be checked using thec  * getbin command.  */c3 #define DBPUTBIN_USAGE "dbN put txn key data flags"a int=& db_putbin_cmd(interp, argc, argv, dbp) 	Tcl_Interp *interp;
 	int argc; 	char *argv[];	 	DB *dbp;e {t 	DBT data, key;a 	DB_TXN *txnid;n 	Tcl_CmdInfo info; 	db_recno_t rkey;s 	u_int32_t flags;l 	int ret, tclint;_	 	void *p;	  # 	USAGE(argc, 6, DBPUTBIN_USAGE, 0);E  6 	if (Tcl_GetInt(interp, argv[5], &tclint) != TCL_OK) {4 		Tcl_AppendResult(interp, "\n", DBPUT_USAGE, NULL); 		return (TCL_ERROR);, 	} 	flags = (u_int32_t)tclint;;   	memset(&key, 0, sizeof(key));  	memset(&data, 0, sizeof(data));) 	if (strcmp(argv[1], "putbinkey") == 0) {_ 		/* Get data from file. */ 5 		if (dbt_from_file(interp, argv[3], &key) != TCL_OK)t 			return (TCL_ERROR); 		data.data = argv[4];8 		data.size = strlen(argv[4]) + 1;	/* Add Null on end */ 		p = key.data; 	 	} else { 6 		if (dbt_from_file(interp, argv[4], &data) != TCL_OK) 			return (TCL_ERROR); 		p = data.data;   		if (dbp->type == DB_RECNO) {6 			if (Tcl_GetInt(interp, argv[3], &tclint) != TCL_OK) 				return (TCL_ERROR);d 			rkey = (db_recno_t)tclint;a 			key.data = &rkey;! 			key.size = sizeof(db_recno_t);]
 		} else { 			key.data = argv[3];8 			key.size = strlen(argv[3]) + 1;	/* Add Null on end */ 		}  	}  - 	if (argv[2][0] == '0' && argv[2][1] == '\0')a 		txnid = NULL;	 	else {=8 		if (Tcl_GetCommandInfo(interp, argv[2], &info) == 0) { 			Tcl_SetResult(interp,3 			    "db_putbin: Invalid argument ", TCL_STATIC);f$ 			Tcl_AppendResult(interp, argv[2],! 			    " not a transaction.", 0);r 			return (TCL_ERROR); 		}I$ 		txnid = (DB_TXN *)info.clientData; 	} 	debug_check();_  0 	ret = dbp->put(dbp, txnid, &key, &data, flags);	 	free(p);f   	if (ret == 0) 		return (TCL_OK); 	else if (ret < 0) { 		Tcl_ResetResult(interp);A 		Tcl_AppendResult(interp, "Key ", argv[3], " not found.", NULL);r 		return (TCL_OK);	 	} else { * 		Tcl_SetResult(interp, "-1", TCL_STATIC); 		return (TCL_OK); 	} }i   /* Cursor support commands. */  ( #define DBCDEL_USAGE "cursorN del flags" int $ dbc_del_cmd(interp, argc, argv, dbc) 	Tcl_Interp *interp;
 	int argc; 	char *argv[];
 	DBC *dbc; {a 	u_int32_t flags;[ 	int ret, tclint;   ! 	USAGE(argc, 3, DBCDEL_USAGE, 0);g  6 	if (Tcl_GetInt(interp, argv[2], &tclint) != TCL_OK) {5 		Tcl_AppendResult(interp, "\n", DBCDEL_USAGE, NULL);	 		return (TCL_ERROR);	 	} 	flags = (u_int32_t)tclint;n   	debug_check();g  ) 	if ((ret = dbc->c_del(dbc, flags)) == 0)) 		return (TCL_OK); 	else if (ret < 0) {< 		Tcl_SetResult(interp, "Uninitialized Cursor", TCL_STATIC); 		return (TCL_OK);	 	} else {_* 		Tcl_SetResult(interp, "-1", TCL_STATIC); 		return (TCL_OK); 	} }a  6 #define DBCGET_USAGE "cursorN get key flags [beg len]"< #define DBCBGET_USAGE "cursorN get key data flags [beg len]" inte$ dbc_get_cmd(interp, argc, argv, dbc) 	Tcl_Interp *interp;
 	int argc; 	char *argv[];
 	DBC *dbc; {_ 	DBT data, key;n 	db_recno_t rkey;  	u_int32_t flags;e 	int arg_off, ret, tclint; 	char numbuf[16];b  $ 	if (strcmp(argv[1], "bget") == 0) {# 		USAGE(argc, 5, DBCBGET_USAGE, 0);  		arg_off = 4;	 	} else {e% 		USAGE_GE(argc, 4, DBCGET_USAGE, 0);  		arg_off = 3; 	}  < 	if (Tcl_GetInt(interp, argv[arg_off], &tclint) != TCL_OK) {5 		Tcl_AppendResult(interp, "\n", DBCGET_USAGE, NULL);p 		return (TCL_ERROR);l 	} 	flags = (u_int32_t)tclint;a   	memset(&key, 0, sizeof(key));B 	if (dbc->dbp->type == DB_RECNO || strcmp(argv[1], "getn") == 0) {5 		if (Tcl_GetInt(interp, argv[2], &tclint) != TCL_OK), 			return (TCL_ERROR); 		rkey = (db_recno_t)tclint; 		key.data = &rkey;L  		key.size = sizeof(db_recno_t);	 	} else {T 		key.data = argv[2];n7 		key.size = strlen(argv[2]) + 1;	/* Add Null on end */e 	}    	memset(&data, 0, sizeof(data)); 	if (argc > arg_off + 3 &&8 	    strcmp(argv[arg_off + 1], "DB_DBT_PARTIAL") == 0) { 		/* We have a partial */e+ 		USAGE(argc, arg_off + 4, DBGET_USAGE, 0);e? 		if (Tcl_GetInt(interp, argv[arg_off + 2], &tclint) != TCL_OK); 			return (TCL_ERROR); 		data.doff = (size_t)tclint;	? 		if (Tcl_GetInt(interp, argv[arg_off + 3], &tclint) != TCL_OK)a 			return (TCL_ERROR); 		data.dlen = (size_t)tclint;* 		data.flags = DB_DBT_PARTIAL; 		flags = 0; 	}   	if (flags == DB_GET_BOTH) { 		data.data = argv[3];" 		data.size = strlen(argv[3]) + 1; 	}   	debug_check();s  ' 	if (F_ISSET(dbc->dbp, DB_AM_THREAD)) {C 		F_SET(&data, DB_DBT_MALLOC); 		switch(flags) {S 		case DB_FIRST: 		case DB_LAST:: 		case DB_NEXT:  		case DB_PREV:  		case DB_CURRENT: 		case DB_SET_RANGE: 		case DB_SET_RECNO: 		case DB_GET_RECNO: 			F_SET(&key, DB_DBT_MALLOC);	 			break;c 		/* case DB_SET: Do nothing */ $ 		/* case DB_GET_BOTH: Do nothing */ 		}& 	}8 	if ((ret = dbc->c_get(dbc, &key, &data, flags)) == 0) {# 		if (dbc->dbp->type == DB_RECNO) {g( 			if (key.size != sizeof(db_recno_t)) { 				Tcl_SetResult(interp,0. 				    "Error: key not integer", TCL_STATIC);& 				if (F_ISSET(&data, DB_DBT_MALLOC)) 					free(&data.data);% 				if (F_ISSET(&key, DB_DBT_MALLOC))  					free(&key.data);  				return (TCL_ERROR);a 			}/ 			memcpy(&rkey, key.data, sizeof(db_recno_t));(7 			snprintf(numbuf, sizeof(numbuf), "%ld", (long)rkey);;/ 			Tcl_SetResult(interp, numbuf, TCL_VOLATILE);c 		} else1 			Tcl_SetResult(interp, key.data, TCL_VOLATILE);t  2 		if ((flags & DB_OPFLAGS_MASK) != DB_JOIN_ITEM) {( 			Tcl_AppendResult(interp, " {", NULL);! 			set_get_result(interp, &data);l( 			Tcl_AppendResult(interp, "} ", NULL); 		}D$ 		if (F_ISSET(&data, DB_DBT_MALLOC)) 			free(&data.data);# 		if (F_ISSET(&key, DB_DBT_MALLOC))2 			free(&key.data);  		return (TCL_OK);3 	} else if (ret < 0) {	/* End/Beginning of file. */i 		Tcl_ResetResult(interp); 		return (TCL_OK);	 	} else {_* 		Tcl_SetResult(interp, "-1", TCL_STATIC); 		return (TCL_OK); 	} }   7 #define DBCGETBIN_USAGE "cursorN getbin file key flags"( int;' dbc_getbin_cmd(interp, argc, argv, dbc)p 	Tcl_Interp *interp;
 	int argc; 	char *argv[];
 	DBC *dbc; {) 	DBT data, key, *dbt;  	db_recno_t rkey;y 	u_int32_t flags;n 	int ret, tclint;k 	char nbuf[32];=  ! 	USAGE(argc, 5, DBCGET_USAGE, 0);e  6 	if (Tcl_GetInt(interp, argv[4], &tclint) != TCL_OK) {5 		Tcl_AppendResult(interp, "\n", DBCGET_USAGE, NULL);) 		return (TCL_ERROR);] 	} 	flags = (u_int32_t)tclint;+   	memset(&key, 0, sizeof(key));D 	if (flags == DB_SET || flags == DB_KEYFIRST || flags == DB_KEYLAST)* 		if (strcmp(argv[1], "getbinkey") == 0) {6 			if (dbt_from_file(interp, argv[3], &key) != TCL_OK) 				return (TCL_ERROR);a* 		} else if (dbc->dbp->type == DB_RECNO) {6 			if (Tcl_GetInt(interp, argv[3], &tclint) != TCL_OK) 				return (TCL_ERROR);z 			rkey = (db_recno_t)tclint;i 			key.data = &rkey;! 			key.size = sizeof(db_recno_t);R
 		} else { 			key.data = argv[3];8 			key.size = strlen(argv[3]) + 1;	/* Add Null on end */ 		}N    	memset(&data, 0, sizeof(data));E 	if (strcmp(argv[1], "getbinkey") != 0 && dbc->dbp->type != DB_RECNO)f 		F_SET(&data, DB_DBT_MALLOC);   	debug_check();{  + 	ret = dbc->c_get(dbc, &key, &data, flags);a, 	if (ret < 0) {	/* End/Beginning of file. */ 		Tcl_ResetResult(interp); 		return (TCL_OK); 	} else if (ret != 0) {E* 		Tcl_SetResult(interp, "-1", TCL_STATIC); 		return (TCL_OK); 	}  / 	/* Got key; write it or its data to a file. */a) 	if (strcmp(argv[1], "getbinkey") == 0) {D
 		dbt = &key;y1 		Tcl_SetResult(interp, data.data, TCL_VOLATILE);n) 	} else if (dbc->dbp->type == DB_RECNO) {C 		dbt = &data;. 		memcpy(&rkey, key.data, sizeof(db_recno_t));2 		snprintf(nbuf, sizeof(nbuf), "%ld", (long)rkey);, 		Tcl_SetResult(interp, nbuf, TCL_VOLATILE);	 	} else {r 		dbt = &data;0 		Tcl_SetResult(interp, key.data, TCL_VOLATILE); 	}  1 	if (dbt_to_file(interp, argv[2], dbt) != TCL_OK)e 		return (TCL_ERROR);_  $ 	Tcl_AppendElement(interp, argv[2]); 	return (TCL_OK);, }e  1 #define DBCPUT_USAGE "cursorN put key data flags"  int	$ dbc_put_cmd(interp, argc, argv, dbc) 	Tcl_Interp *interp;
 	int argc; 	char *argv[];
 	DBC *dbc; {r 	DBT data, key;o 	db_recno_t ikey;d 	u_int32_t flags;e 	int ret, tclint;l  ! 	USAGE(argc, 5, DBCPUT_USAGE, 0);   6 	if (Tcl_GetInt(interp, argv[4], &tclint) != TCL_OK) {5 		Tcl_AppendResult(interp, "\n", DBCPUT_USAGE, NULL);N 		return (TCL_ERROR);  	} 	flags = (u_int32_t)tclint;(   	/* @ 	 * If this is a DB_CURRENT, we should never look at the key, so 	 * send it a NULL.T 	 */ 	memset(&key, 0, sizeof(key)); 	if (flags != DB_CURRENT)k% 		if (strcmp(argv[1], "putn") == 0 ||i# 		    dbc->dbp->type == DB_RECNO) {B6 			if (Tcl_GetInt(interp, argv[2], &tclint) != TCL_OK) 				return (TCL_ERROR);c 			ikey = (db_recno_t)tclint;P 			key.data = &ikey;! 			key.size = sizeof(db_recno_t);_
 		} else { 			key.data = argv[2];8 			key.size = strlen(argv[2]) + 1;	/* Add Null on end */ 		}r    	memset(&data, 0, sizeof(data)); 	data.data = argv[3]; ! 	data.size = strlen(argv[3]) + 1;,   	debug_check();   6 	if ((ret = dbc->c_put(dbc, &key, &data, flags)) == 0) 		return (TCL_OK); 	else if (ret < 0) { 		Tcl_ResetResult(interp);A 		Tcl_AppendResult(interp, "Key ", argv[2], " not found.", NULL);r 		return (TCL_OK);	 	} else {d* 		Tcl_SetResult(interp, "-1", TCL_STATIC); 		return (TCL_OK); 	} }3  
 u_int8_t * list_to_numarray(interp, str)) 	Tcl_Interp *interp; 	char *str;  {k 	int argc, i, tmp; 	u_int8_t *nums, *np;e 	char **argv, **ap;   8 	if (Tcl_SplitList(interp, str, &argc, &argv) != TCL_OK) 		return (NULL);C 	if ((nums = (u_int8_t *)calloc(argc, sizeof(u_int8_t))) == NULL) {i< 		Tcl_SetResult(interp, Tcl_PosixError(interp), TCL_STATIC); 		return (NULL); 	}  ? 	for (np = nums, ap = argv, i = 0; i < argc; i++, ap++, np++) {A0 		if (Tcl_GetInt(interp, *ap, &tmp) != TCL_OK) { 			free (nums);c 			return (NULL);t 		}T5 		*np = (u_int8_t)tmp;		/* XXX: Possible overflow. */  	} 	FREE_TCL(argv); 	return (nums);( },  $ #define STAMP_USAGE "timestamp [-r]" inti& stamp_cmd(notused, interp, argc, argv) 	ClientData notused; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {  	static time_t start;. 	struct tm *tp;u 	time_t elapsed, now;  	static char buf[25];p   	notused = NULL;  # 	USAGE_GE(argc, 1, STAMP_USAGE, 0);o 	(void)time(&now); 	if (now == (time_t)-1)E 		goto err; . 	if (argc > 1 && strcmp(argv[1], "-r") == 0) {1 		snprintf(buf, sizeof(buf), "%lu", (u_long)now);;) 		Tcl_SetResult(interp, buf, TCL_STATIC);r 		return (TCL_OK); 	}$ 	if ((tp = localtime(&now)) == NULL) 		goto err;p   	if (start == 0) 		start = now; 	elapsed = now - start;"> 	snprintf(buf, sizeof(buf), "%02d:%02d:%02d (%02d:%02d:%02d)",@ 	    tp->tm_hour, tp->tm_min, tp->tm_sec, (int)(elapsed / 3600),C 	    (int)((elapsed % 3600) / 60), (int)(((elapsed % 3600) % 60)));_
 	start = now;p  ( 	Tcl_SetResult(interp, buf, TCL_STATIC); 	return (TCL_OK);e  ? err:	Tcl_SetResult(interp, Tcl_PosixError(interp), TCL_STATIC);K 	return (TCL_ERROR); }G  0 int debug_stop;				/* Stop on each iteration. */   void
 debug_check()g {k 	if (debug_on == 0)n	 		return;b   	if (debug_print != 0) { 		printf("\r%6d:", debug_on);i 		fflush(stdout);g 	}  , 	if (debug_on++ == debug_test || debug_stop) 		__db_loadme(); }a   inti  dbt_from_file(interp, file, dbt) 	Tcl_Interp *interp; 	char *file;
 	DBT *dbt; {  	size_t len, size; 	ssize_t nr; 	u_int32_t mbytes, bytes;  	int fd;   	/* Get data from file. */	 	fd = -1;f 	len = strlen(file) + 1;B 	if ((errno = __db_open(file, DB_RDONLY, DB_RDONLY, 0, &fd)) != 0) 		goto err;,A 	if ((errno = __os_ioinfo(file, fd, &mbytes, &bytes, NULL)) != 0)3 		goto err; " 	size = mbytes * MEGABYTE + bytes;6 	if ((dbt->data = (void *)malloc(size + len)) == NULL) 		goto err;f
 	if ((errno =tC 	    __os_read(fd, ((u_int8_t *)dbt->data) + len, size, &nr)) != 0)( 		goto err;l 	if (nr != (ssize_t)size) {	 		errno = EIO; 		goto err;; 	}$ 	if ((errno =__os_close(fd)) != 0) { err:		if (fd != -1)2
 			close(fd);N< 		Tcl_SetResult(interp, Tcl_PosixError(interp), TCL_STATIC); 		return (TCL_ERROR);  	}# 	strcpy((char *)(dbt->data), file);I# 	dbt->size = size + (u_int32_t)len;* 	dbt->flags = 0; 	return (TCL_OK);U }E   /*@  * file is the file we are creating.  ofile is the original file;  * name so we know how many characters to drop off the end.f  */_ intt dbt_to_file(interp, file, dbt) 	Tcl_Interp *interp; 	char *file;
 	DBT *dbt; {e 	size_t len; 	ssize_t nw; 	int fd;	 	char *p;A  ! 	/* Got key; write it to file. */ ? 	for (len = 1, p = (char *)(dbt->data); *p != '\0'; len++, p++)[ 		;  	p++;   	 	fd = -1;k6 	if ((errno = __db_open(file, DB_CREATE | DB_TRUNCATE,1 	    DB_CREATE | DB_TRUNCATE, 0644, &fd)) != 0 ||e> 	    (errno = __os_write(fd, p, dbt->size - len, &nw) != 0) ||( 	    nw != (ssize_t)(dbt->size - len) ||% 	    (errno = __os_close(fd)) != 0) {E 		if (errno == 0), 			errno = EIO;  		if (fd == -1)c 			(void)__os_close(fd);< 		Tcl_SetResult(interp, Tcl_PosixError(interp), TCL_STATIC); 		return (TCL_ERROR);d 	}! 	if (F_ISSET(dbt, DB_DBT_MALLOC))y 		free(dbt->data); 	return (TCL_OK);s }o   void set_get_result(interp, dbt)n 	Tcl_Interp *interp;
 	DBT *dbt; {e 	size_t i, len; 
 	u_int8_t *p;(' 	char numbuf[32], sprbuf[128], *outbuf;a  B 	for (i = 0, p = dbt->data; i < dbt->size && *p == '\0'; i++, p++) 		;e 	/*(@ 	 * If this is a partial get, we need to make sure that the last1 	 * character is a NUL so that tcl can handle it.g 	 */$ 	if (F_ISSET(dbt, DB_DBT_PARTIAL)) { 		if (dbt->size == 0)e! 			((char *)dbt->data)[0] = '\0';, 		else- 			((char *)dbt->data)[dbt->size - 1] = '\0';D 	}   	if (i == 0) {7 		if (((u_int8_t *)dbt->data)[dbt->size - 1] != '\0') {e* 			outbuf = (char *)malloc(dbt->size + 1);( 			memcpy(outbuf, dbt->data, dbt->size); 			outbuf[dbt->size] = '\0'; 		} else 			outbuf = dbt->data;) 		Tcl_AppendResult(interp, outbuf, NULL);C 		if (outbuf != dbt->data) 			free(outbuf);	 	} else {*5 		snprintf(numbuf, sizeof(numbuf), "%lu", (u_long)i);e= 		snprintf(sprbuf, sizeof(sprbuf), " %%.%ds", dbt->size - i);C 		len = dbt->size - i + 5;/ 		if ((outbuf = (char *)malloc(len)) != NULL) {n$ 			snprintf(outbuf, len, sprbuf, p);2 			Tcl_AppendResult(interp, numbuf, outbuf, NULL); 			free(outbuf); 		}D 	} },    #define SRAND_USAGE "srand seed" int2& srand_cmd(notused, interp, argc, argv) 	ClientData notused; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {r
 	int ival;   	notused = NULL;  	USAGE(argc, 2, SRAND_USAGE, 0);2 	if (Tcl_GetInt(interp, argv[1], &ival) != TCL_OK) 		return (TCL_ERROR);+   	srand((u_int)ival);( 	Tcl_SetResult(interp, "0", TCL_STATIC); 	return (TCL_OK);l }    #define RAND_USAGE "rand"a int]% rand_cmd(notused, interp, argc, argv)_ 	ClientData notused; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {i 	char retbuf[50];=   	notused = NULL;
 	argv = NULL;e 	USAGE(argc, 1, RAND_USAGE, 0);   7 	snprintf(retbuf, sizeof(retbuf), "%ld", (long)rand());	- 	Tcl_SetResult(interp, retbuf, TCL_VOLATILE);n 	return (TCL_OK);  }k  * #define RANDOMINT_USAGE "random_int lo hi" int * randomint_cmd(notused, interp, argc, argv) 	ClientData notused; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {> 	long t; 	int lo, hi, ret;d 	char retbuf[50];;   	notused = NULL;$ 	USAGE(argc, 3, RANDOMINT_USAGE, 0);2 	if (Tcl_GetInt(interp, argv[1], &lo) != TCL_OK ||0 	    Tcl_GetInt(interp, argv[2], &hi) != TCL_OK) 		return (TCL_ERROR);0   #ifndef	RAND_MAX #define	RAND_MAX	0x7fffffff  #endif 	t = rand(); 	if (t > RAND_MAX)< 		printf("Max random is higher than %ld\n", (long)RAND_MAX);E 	ret = (int)(((double)t / ((double)(RAND_MAX) + 1)) * (hi - lo + 1));V 	ret += lo;}- 	snprintf(retbuf, sizeof(retbuf), "%d", ret); - 	Tcl_SetResult(interp, retbuf, TCL_VOLATILE);e 	return (TCL_OK);f }u  " #define VERSION_USAGE "db_version" int_. dbversion_cmd(notused, interp, argc, notused2) 	ClientData notused; 	Tcl_Interp *interp;
 	int argc; 	char *notused2[]; {  	char *str;i   	notused = NULL; 	notused2 = NULL;u" 	USAGE(argc, 1, VERSION_USAGE, 0);$ 	str = db_version(NULL, NULL, NULL); 	if (str == NULL) {P4 		Tcl_SetResult(interp, "db_version: ", TCL_STATIC);6 		Tcl_AppendResult(interp, Tcl_PosixError(interp), 0); 		return (TCL_ERROR);  	}) 	Tcl_SetResult(interp, str, TCL_DYNAMIC);k 	return (TCL_OK);a }e   /*B  * Create an environment that we can pass around between different	  * calls.   */4 #define DBENV_USAGE "dbenv " inte& dbenv_cmd(notused, interp, argc, argv) 	ClientData notused; 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {  	static int env_number = 0;h
 	DB_ENV *env;  	char envname[50];   	debug_check();  	notused = NULL;  ! 	/* Check number of arguments. */R( 	USAGE_GE(argc, 1, DBENV_USAGE, DO_ENV);  7 	process_env_options(interp, argc - 1, &argv[1], &env);n 	if (env == NULL) {c, 		Tcl_SetResult(interp, "NULL", TCL_STATIC); 		return (TCL_OK); 	}   	F_SET(env, DB_ENV_STANDALONE);s   	/* Create new command name. */e9 	snprintf(envname, sizeof(envname), "env%d", env_number);  	env_number++;  C 	Tcl_CreateCommand(interp, envname, envwidget_cmd, (ClientData)env,] 	    envwidget_delcmd);r. 	Tcl_SetResult(interp, envname, TCL_VOLATILE); 	return (TCL_OK);y }d   void envwidget_delcmd(cd) 	ClientData cd;f {e
 	DB_ENV *env;_ 	u_int8_t *conflicts;	   	debug_check();t 	env = (DB_ENV *)cd;  > 	if (!F_ISSET(env, DB_ENV_CDB) && env->lk_conflicts != NULL) {, 		conflicts = (u_int8_t *)env->lk_conflicts; 		free(conflicts); 	} 	(void)db_appexit(env);t 	free(env);T }I   #define	ENVWIDGET_USAGE "envN", #define	ENVWIDGET_SIMPLEDUP "envN simpledup" int*% envwidget_cmd(cd, interp, argc, argv)r 	ClientData cd;r 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {8 	static int nenv_number = 0; 	DB_ENV *env, *newenv; 	char **p, nenvname[50];  
 	argv = argv;  	env = (DB_ENV *)cd;   	if (argc == 1) {(% 		USAGE(argc, 1, ENVWIDGET_USAGE, 0);i   		Tcl_ResetResult(interp); 		if (env->db_home != NULL)T8 			Tcl_AppendResult(interp, " Home: ", env->db_home, 0);% 		if ((p = env->db_data_dir) != NULL)e 			for (; *p != NULL; ++p)/ 				Tcl_AppendResult(interp, " Data: ", *p, 0);  		if (env->db_log_dir != NULL): 			Tcl_AppendResult(interp, " Log: ", env->db_log_dir, 0); 		if (env->db_tmp_dir != NULL): 			Tcl_AppendResult(interp, " Tmp: ", env->db_tmp_dir, 0);0 	} else if (strcmp(argv[1], "simpledup") == 0) {) 		USAGE(argc, 2, ENVWIDGET_SIMPLEDUP, 0);U 		/*5 		 * Copy the env and then NULL out the log, lock ando7 		 * transaction info pointers so that we only share an  		 * mpool.f 		 */f- 		newenv = (DB_ENV *)malloc(sizeof(*newenv));n 		*newenv = *env;I 		newenv->lg_info = NULL;} 		newenv->lk_info = NULL;) 		newenv->tx_info = NULL;     		/* Create new command name. */> 		snprintf(nenvname, sizeof(nenvname), "nenv%d", nenv_number); 		nenv_number++;  4 		Tcl_CreateCommand(interp, nenvname, envwidget_cmd,  		    (ClientData)newenv, NULL);0 		Tcl_SetResult(interp, nenvname, TCL_VOLATILE);	 	} else {n7 		Tcl_SetResult(interp, "Invalid command", TCL_STATIC);  		return (TCL_ERROR);S 	}   	return (TCL_OK);x }o   #define ARGS_USAGE "args"t intT  args_cmd(cd, interp, argc, argv) 	ClientData cd;h 	Tcl_Interp *interp;
 	int argc; 	char *argv[]; {g	 	cd = cd; 
 	argv = argv;i   	USAGE(argc, 1, ARGS_USAGE, 0);r= 	printf("Legal environment options are: %s\n", DB_ENV_FLAGS);=@ 	printf("Legal access method options are: %s\n", DB_INFO_FLAGS); 	Tcl_ResetResult(interp);T 	return (TCL_OK);  }a  ' #define DEBUG_CHECK_USAGE "debug_check"; inti0 debugcheck_cmd(notused1, interp, argc, notused2) 	ClientData notused1;  	Tcl_Interp *interp;
 	int argc; 	char *notused2[]; {_& 	USAGE(argc, 1, DEBUG_CHECK_USAGE, 0); 	notused1 = notused1;, 	notused2 = notused2;i 	debug_check();y 	Tcl_ResetResult(interp);  	return (TCL_OK);  }b  4 #define DB_JOIN_USAGE "dbN join {DBC ... DBC} flags" intz$ db_join_cmd(interp, argc, argv, dbp) 	Tcl_Interp *interp;
 	int argc; 	char *argv[];	 	DB *dbp;  {e 	static int jcurs_id = 0;l 	int i, tclint, ncurs, ret;	 	u_int32_t flags;	 	char **cursnames; 	char cursname[128]; 	Tcl_CmdInfo info; 	DBC *dbc, **curs_array;  " 	USAGE(argc, 4, DB_JOIN_USAGE, 0);  6 	if (Tcl_GetInt(interp, argv[3], &tclint) != TCL_OK) {1 		Tcl_SetResult(interp, "\nUsage: ", TCL_STATIC);z0 		Tcl_AppendResult(interp, DB_JOIN_USAGE, NULL); 		return (TCL_OK); 	}   	flags = (u_int32_t)tclint;.  0 	/* Now, split the cursor list into an array. */D 	if (Tcl_SplitList(interp, argv[2], &ncurs, &cursnames) != TCL_OK) {= 		Tcl_SetResult(interp, "dbjoin: Invalid list ", TCL_STATIC);e* 		Tcl_AppendResult(interp, argv[2], NULL); 		return (TCL_OK); 	}  ( 	/* Malloc the array to pass to join. */: 	curs_array = (DBC **)malloc(sizeof(DBC *) * (ncurs + 1)); 	if (curs_array == NULL) {0 		Tcl_SetResult(interp, "dbjoin: ", TCL_STATIC);9 		Tcl_AppendResult(interp, Tcl_PosixError(interp), NULL);s 		goto end1; 	} 	for (i = 0; i < ncurs; i++) {= 		if (Tcl_GetCommandInfo(interp, cursnames[i], &info) == 0) {f 			Tcl_SetResult(interp,. 			    "dbjoin: Invalid cursor ", TCL_STATIC);0 			Tcl_AppendResult(interp, cursnames[i], NULL);
 			goto end2;r 		}C) 		curs_array[i] = (DBC *)info.clientData;  	} 	curs_array[i] = NULL;  8 	if ((ret = dbp->join(dbp, curs_array, 0, &dbc)) == 0) {B 		snprintf(cursname, sizeof(cursname), "join.cursor%d", jcurs_id);
 		jcurs_id++;u3 		Tcl_CreateCommand(interp, cursname, dbcursor_cmd,a 		    (ClientData)dbc, NULL); 0 		Tcl_SetResult(interp, cursname, TCL_VOLATILE);	 	} else {i2 		Tcl_SetResult(interp, "db_cursor:", TCL_STATIC); 		errno = ret;6 		Tcl_AppendResult(interp, Tcl_PosixError(interp), 0); 	}   end2:	free(curs_array);f end1:	FREE_TCL(cursnames); 	return (TCL_OK);  }' 		else- 			((char *)dbt->data)[dbt->size - 1] = '\0';D 	}   	if (i == 0) {7 		if (((u_int8_t *)dbt->data)[dbt->size - 1] != '\0') {e* 			outbuf = (char *)malloc(dbt->size + 1);( 			memcpy(outbuf, dbt->data, dbt->size); 			outbuf[dbt->size] = '\0'; 		} else 			outbuf = dbt->data;) 		Tcl_AppendResult(interp, outbuf, NULL);C 		if (outbuf != dbt->data) 			free(outbuf);	 	} else {*5 		snprintf(numbuf, sizeof(numbuf), "%lu", (u_long)i);e= 		snprintf(sprbuf, sizeof(sp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                