 /*- 7  * See the file LICENSE for redistribution information.   *!  * Copyright (c) 1996, 1997, 1998 ,  *	Sleepycat Software.  All rights reserved.  */  /*  * Copyright (c) 1995, 1996 I  *	The President and Fellows of Harvard University.  All rights reserved.   *@  * This code is derived from software contributed to Berkeley by  * Margo Seltzer.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   */    #include "config.h"    #ifndef lintD static const char sccsid[] = "@(#)txn.c	10.65 (Sleepycat) 10/17/98"; #endif /* not lint */      #ifndef NO_SYSTEM_INCLUDES #include <sys/types.h>   #include <errno.h> #include <string.h>  #include <time.h>  #endif   #include "db_int.h"  #include "shqueue.h" #include "db_page.h" #include "db_shash.h"  #include "txn.h" #include "db_dispatch.h" #include "lock.h"  #include "log.h" #include "db_am.h" #include "common_ext.h"   ' static int __txn_begin __P((DB_TXN *)); D static int __txn_check_running __P((const DB_TXN *, TXN_DETAIL **));* static int __txn_end __P((DB_TXN *, int));0 static int __txn_grow_region __P((DB_TXNMGR *));, static int __txn_init __P((DB_TXNREGION *));& static int __txn_undo __P((DB_TXN *));4 static int __txn_validate_region __P((DB_TXNMGR *));   /*H  * This file contains the top level routines of the transaction library.O  * It assumes that a lock manager and log manager that conform to the db_log(3) #  * and db_lock(3) interfaces exist.   *4  * Initialize a transaction region in shared memory.)  * Return 0 on success, errno on failure.   */ 
 static int __txn_init(txn_region) 	DB_TXNREGION *txn_region; {  	time_t now;   	(void)time(&now);  & 	/* maxtxns is already initialized. */! 	txn_region->magic = DB_TXNMAGIC; % 	txn_region->version = DB_TXNVERSION; & 	txn_region->last_txnid = TXN_MINIMUM; 	/*  	 * XXX B 	 * If we ever do more types of locking and logging, this changes. 	 */ 	txn_region->logtype = 0;  	txn_region->locktype = 0; 	txn_region->time_ckp = now;  	ZERO_LSN(txn_region->last_ckp);# 	ZERO_LSN(txn_region->pending_ckp); ( 	SH_TAILQ_INIT(&txn_region->active_txn);* 	__db_shalloc_init((void *)&txn_region[1],B 	    TXN_REGION_SIZE(txn_region->maxtxns) - sizeof(DB_TXNREGION));   	return (0); }    int ) txn_open(path, flags, mode, dbenv, mgrpp)  	const char *path; 	u_int32_t flags; 
 	int mode; 	DB_ENV *dbenv;  	DB_TXNMGR **mgrpp;  {  	DB_TXNMGR *tmgrp; 	u_int32_t maxtxns; 	 	int ret;    	/* Validate arguments. */ 	if (dbenv == NULL)  		return (EINVAL); #ifdef HAVE_SPINLOCKS 7 #define	OKFLAGS	(DB_CREATE | DB_THREAD | DB_TXN_NOSYNC)  #else + #define	OKFLAGS	(DB_CREATE | DB_TXN_NOSYNC)  #endif? 	if ((ret = __db_fchk(dbenv, "txn_open", flags, OKFLAGS)) != 0)  		return (ret);   3 	maxtxns = dbenv->tx_max != 0 ? dbenv->tx_max : 20;   H 	/* Now, create the transaction manager structure and set its fields. */< 	if ((ret = __os_calloc(1, sizeof(DB_TXNMGR), &tmgrp)) != 0) 		return (ret);   4 	/* Initialize the transaction manager structure. */ 	tmgrp->mutexp = NULL; 	tmgrp->dbenv = dbenv; 	tmgrp->recover = C 	    dbenv->tx_recover == NULL ? __db_dispatch : dbenv->tx_recover; 4 	tmgrp->flags = LF_ISSET(DB_TXN_NOSYNC | DB_THREAD); 	TAILQ_INIT(&tmgrp->txn_chain);   " 	/* Join/create the txn region. */ 	tmgrp->reginfo.dbenv = dbenv;& 	tmgrp->reginfo.appname = DB_APP_NONE; 	if (path == NULL) 		tmgrp->reginfo.path = NULL;  	else ; 		if ((ret = __os_strdup(path, &tmgrp->reginfo.path)) != 0)  			goto err;( 	tmgrp->reginfo.file = DEFAULT_TXN_FILE; 	tmgrp->reginfo.mode = mode;0 	tmgrp->reginfo.size = TXN_REGION_SIZE(maxtxns);  	tmgrp->reginfo.dbflags = flags; 	tmgrp->reginfo.addr = NULL; 	tmgrp->reginfo.fd = -1;@ 	tmgrp->reginfo.flags = dbenv->tx_max == 0 ? REGION_SIZEDEF : 0;0 	if ((ret = __db_rattach(&tmgrp->reginfo)) != 0) 		goto err;   % 	/* Fill in region-related fields. */ % 	tmgrp->region = tmgrp->reginfo.addr;   	tmgrp->mem = &tmgrp->region[1];  0 	if (F_ISSET(&tmgrp->reginfo, REGION_CREATED)) {# 		tmgrp->region->maxtxns = maxtxns; - 		if ((ret = __txn_init(tmgrp->region)) != 0)  			goto err;  2 	} else if (tmgrp->region->magic != DB_TXNMAGIC) { 		/* Check if valid region. */0 		__db_err(dbenv, "txn_open: Bad magic number"); 		ret = EINVAL;  		goto err;  	}   	if (LF_ISSET(DB_THREAD)) { 9 		if ((ret = __db_shalloc(tmgrp->mem, sizeof(db_mutex_t), - 		    MUTEX_ALIGNMENT, &tmgrp->mutexp)) == 0)  			/* : 			 * Since we only get here if threading is turned on, we9 			 * know that we have spinlocks, so the offset is going ; 			 * to be ignored.  We put 0 here as a valid placeholder.  			 */% 			__db_mutex_init(tmgrp->mutexp, 0);  		if (ret != 0)  			goto err; 	}   	UNLOCK_TXNREGION(tmgrp);  	*mgrpp = tmgrp; 	return (0);  ' err:	if (tmgrp->reginfo.addr != NULL) {  		if (tmgrp->mutexp != NULL)0 			__db_shalloc_free(tmgrp->mem, tmgrp->mutexp);   		UNLOCK_TXNREGION(tmgrp);& 		(void)__db_rdetach(&tmgrp->reginfo);/ 		if (F_ISSET(&tmgrp->reginfo, REGION_CREATED)) $ 			(void)txn_unlink(path, 1, dbenv); 	}  ! 	if (tmgrp->reginfo.path != NULL) $ 		__os_freestr(tmgrp->reginfo.path);" 	__os_free(tmgrp, sizeof(*tmgrp)); 	return (ret); }    /*  * __txn_panic --   *	Panic a transaction region.  *,  * PUBLIC: void __txn_panic __P((DB_ENV *));  */  void __txn_panic(dbenv) 	DB_ENV *dbenv;  {  	if (dbenv->tx_info != NULL)( 		dbenv->tx_info->region->hdr.panic = 1; }    /*  * txn_begin -- E  *	This is a wrapper to the actual begin process.  Normal txn_begin() I  * allocates a DB_TXN structure for the caller, while txn_xa_begin() does G  * not.  Other than that, both call into the common __txn_begin code().   *E  * Internally, we use TXN_DETAIL structures, but the DB_TXN structure J  * provides access to the transaction ID and the offset in the transaction&  * region of the TXN_DETAIL structure.  */  int  txn_begin(tmgrp, parent, txnpp)  	DB_TXNMGR *tmgrp; 	DB_TXN *parent, **txnpp;  { 
 	DB_TXN *txn; 	 	int ret;    	TXN_PANIC_CHECK(tmgrp);  7 	if ((ret = __os_calloc(1, sizeof(DB_TXN), &txn)) != 0)  		return (ret);    	txn->parent = parent; 	txn->mgrp = tmgrp;  	txn->flags = TXN_MALLOC; % 	if ((ret = __txn_begin(txn)) != 0) { ! 		__os_free(txn, sizeof(DB_TXN)); 
 		txn = NULL;  	} 	*txnpp = txn; 	return (ret); }    /*  * __txn_xa_begin --  *	XA version of txn_begin.   *8  * PUBLIC: int __txn_xa_begin __P((DB_ENV *, DB_TXN *));  */  int  __txn_xa_begin(dbenv, txn) 	DB_ENV *dbenv; 
 	DB_TXN *txn;  { ! 	TXN_PANIC_CHECK(dbenv->tx_info);S    	memset(txn, 0, sizeof(DB_TXN));   	txn->mgrp = dbenv->tx_info;   	return (__txn_begin(txn));  }    /*  * __txn_begin --*"  *	Normal DB version of txn_begin.  */e
 static int __txn_begin(txn)
 	DB_TXN *txn;l {g 	DB_LSN begin_lsn; 	DB_TXNMGR *mgr; 	TXN_DETAIL *td; 	size_t off; 	u_int32_t id;	 	int ret;l   	/* D 	 * We do not have to write begin records (and if we do not, then weC 	 * need never write records for read-only transactions).  However,iE 	 * we do need to find the current LSN so that we can store it in thetD 	 * transaction structure, so we can know where to take checkpoints. 	 */ 	mgr = txn->mgrp; * 	if (mgr->dbenv->lg_info != NULL && (ret =E 	    log_put(mgr->dbenv->lg_info, &begin_lsn, NULL, DB_CURLSN)) != 0)o 		goto err2;   	LOCK_TXNREGION(mgr);e  = 	/* Make sure that last_txnid is not going to wrap around. */*. 	if (mgr->region->last_txnid == TXN_INVALID) {+ 		__db_err(mgr->dbenv, "txn_begin: %s  %s",y! 		    "Transaction ID wrapping.",*5 		    "Snapshot your database and start a new log.");s 		ret = EINVAL;r 		goto err1; 	}  - 	if ((ret = __txn_validate_region(mgr)) != 0)  		goto err1;  3 	/* Allocate a new transaction detail structure. */dD 	if ((ret = __db_shalloc(mgr->mem, sizeof(TXN_DETAIL), 0, &td)) != 0= 	    && ret == ENOMEM && (ret = __txn_grow_region(mgr)) == 0)D? 	    	ret = __db_shalloc(mgr->mem, sizeof(TXN_DETAIL), 0, &td);O 	if (ret != 0) 		goto err1;  4 	/* Place transaction on active transaction list. */I 	SH_TAILQ_INSERT_HEAD(&mgr->region->active_txn, td, links, __txn_detail);N    	id = ++mgr->region->last_txnid; 	++mgr->region->nbegins;   	td->txnid = id; 	td->begin_lsn = begin_lsn;R 	ZERO_LSN(td->last_lsn); 	td->last_lock = 0;T 	td->status = TXN_RUNNING;0 	off = (u_int8_t *)td - (u_int8_t *)mgr->region; 	UNLOCK_TXNREGION(mgr);I   	ZERO_LSN(txn->last_lsn);R 	txn->txnid = id;T 	txn->off = off;    	if (F_ISSET(txn, TXN_MALLOC)) { 		LOCK_TXNTHREAD(mgr);1 		TAILQ_INSERT_TAIL(&mgr->txn_chain, txn, links);* 		UNLOCK_TXNTHREAD(mgr); 	}   	return (0);   err1:	UNLOCK_TXNREGION(mgr);   err2:	return (ret);i }u /*  * txn_commit --  *	Commit a transaction.  */s int= txn_commit(txnp) 	DB_TXN *txnp; {8 	DB_LOG *logp;	 	int ret;    	TXN_PANIC_CHECK(txnp->mgrp);i2 	if ((ret = __txn_check_running(txnp, NULL)) != 0) 		return (ret);c   	/*i= 	 * If there are any log records, write a log record and synci# 	 * the log, else do no log writes.h 	 */3 	if ((logp = txnp->mgrp->dbenv->lg_info) != NULL &&"$ 	    !IS_ZERO_LSN(txnp->last_lsn) &&8 	    (ret = __txn_regop_log(logp, txnp, &txnp->last_lsn,7 	    F_ISSET(txnp->mgrp, DB_TXN_NOSYNC) ? 0 : DB_FLUSH,( 	    TXN_COMMIT)) != 0)L 		return (ret);t   	return (__txn_end(txnp, 1));  }t   /*  * txn_abort --n  *	Abort a transcation.t  */t intn txn_abort(txnp)R 	DB_TXN *txnp; {i	 	int ret;d   	TXN_PANIC_CHECK(txnp->mgrp);t2 	if ((ret = __txn_check_running(txnp, NULL)) != 0) 		return (ret);h  % 	if ((ret = __txn_undo(txnp)) != 0) {i 		__db_err(txnp->mgrp->dbenv,c6 		    "txn_abort: Log undo failed %s", strerror(ret)); 		return (ret);3 	} 	return (__txn_end(txnp, 0));l }    /*  * txn_prepare --h=  *	Flush the log so a future commit is guaranteed to succeed.   */c int  txn_prepare(txnp)o 	DB_TXN *txnp; {t	 	DBT xid;  	DB_ENV *dbenv;  	TXN_DETAIL *td;	 	int ret;a  1 	if ((ret = __txn_check_running(txnp, &td)) != 0)= 		return (ret);t   	dbenv = txnp->mgrp->dbenv;I 	memset(&xid, 0, sizeof(xid)); 	xid.data = td->xid; 	xid.size = sizeof(td->xid); 	if (dbenv->lg_info != NULL &&E 	    (ret = __txn_xa_regop_log(dbenv->lg_info, txnp, &txnp->last_lsn, D 	    F_ISSET(txnp->mgrp, DB_TXN_NOSYNC) ? 0 : DB_FLUSH, TXN_PREPARE,5 	    &xid, td->format, td->gtrid, td->bqual)) != 0) {_ 		__db_err(dbenv,;; 		    "txn_prepare: log_write failed %s\n", strerror(ret));_ 		return (ret);m 	}   	LOCK_TXNTHREAD(txnp->mgrp); 	td->status = TXN_PREPARED;_ 	UNLOCK_TXNTHREAD(txnp->mgrp); 	return (ret); }    /*E  * Return the transaction ID associated with a particular transaction   */ 	 u_int32_t* txn_id(txnp) 	DB_TXN *txnp; {t 	return (txnp->txnid); }m   /*  * txn_close -- =  *	Close the transaction region, does not imply a checkpoint.L  */D intA txn_close(tmgrp) 	DB_TXNMGR *tmgrp; {  	DB_TXN *txnp; 	int ret, t_ret;   	TXN_PANIC_CHECK(tmgrp);  	 	ret = 0;(   	/*"< 	 * This function had better only be called once per processA 	 * (i.e., not per thread), so there should be no synchronizationh
 	 * required.a 	 */ 	while ((txnp = E 	    TAILQ_FIRST(&tmgrp->txn_chain)) != TAILQ_END(&tmgrp->txn_chain))!' 		if ((t_ret = txn_abort(txnp)) != 0) {t 			__txn_end(txnp, 0); 			if (ret == 0) 				ret = t_ret; 		}g   	if (tmgrp->dbenv->lg_info &&eG 	    (t_ret = log_flush(tmgrp->dbenv->lg_info, NULL)) != 0 && ret == 0)  		ret = t_ret;   	if (tmgrp->mutexp != NULL) {E 		LOCK_TXNREGION(tmgrp);/ 		__db_shalloc_free(tmgrp->mem, tmgrp->mutexp);/ 		UNLOCK_TXNREGION(tmgrp); 	}  > 	if ((t_ret = __db_rdetach(&tmgrp->reginfo)) != 0 && ret == 0) 		ret = t_ret;  ! 	if (tmgrp->reginfo.path != NULL)_$ 		__os_freestr(tmgrp->reginfo.path);" 	__os_free(tmgrp, sizeof(*tmgrp));   	return (ret); }L   /*  * txn_unlink --!  *	Remove the transaction region.N  */O intE txn_unlink(path, force, dbenv) 	const char *path; 	int force;r 	DB_ENV *dbenv;> {i 	REGINFO reginfo;p	 	int ret;l  & 	memset(&reginfo, 0, sizeof(reginfo)); 	reginfo.dbenv = dbenv;t 	reginfo.appname = DB_APP_NONE;oC 	if (path != NULL && (ret = __os_strdup(path, &reginfo.path)) != 0)t 		return (ret);r! 	reginfo.file = DEFAULT_TXN_FILE;;% 	ret = __db_runlink(&reginfo, force);N 	if (reginfo.path != NULL) 		__os_freestr(reginfo.path);r 	return (ret); }r   /* Internal routines. */   /*@  * Return 0 if the txnp is reasonable, otherwise returns EINVAL.  */i
 static int __txn_check_running(txnp, tdp) 	const DB_TXN *txnp; 	TXN_DETAIL **tdp; {e 	TXN_DETAIL *tp;   	tp = NULL;AH 	if (txnp != NULL && txnp->mgrp != NULL && txnp->mgrp->region != NULL) {B 		tp = (TXN_DETAIL *)((u_int8_t *)txnp->mgrp->region + txnp->off);> 		if (tp->status != TXN_RUNNING && tp->status != TXN_PREPARED)
 			tp = NULL;  		if (tdp != NULL)
 			*tdp = tp;g 	}  " 	return (tp == NULL ? EINVAL : 0); }   
 static int __txn_end(txnp, is_commit) 	DB_TXN *txnp; 	int is_commit;  {; 	DB_LOCKREQ request; 	DB_TXNMGR *mgr; 	TXN_DETAIL *tp; 	u_int32_t locker;	 	int ret;i   	mgr = txnp->mgrp;   	/* Release the locks. */  	locker = txnp->txnid; 	request.op = DB_LOCK_PUT_ALL;   	if (mgr->dbenv->lk_info) {)0 		ret = lock_vec(mgr->dbenv->lk_info, locker, 0, 		    &request, 1, NULL);); 		if (ret != 0 && (ret != DB_LOCK_DEADLOCK || is_commit)) {e6 			__db_err(mgr->dbenv, "%s: release locks failed %s",. 			    is_commit ? "txn_commit" : "txn_abort", 			    strerror(ret)); 			return (ret); 		}a 	}   	/* End the transaction. */: 	LOCK_TXNREGION(mgr);D  : 	tp = (TXN_DETAIL *)((u_int8_t *)mgr->region + txnp->off);D 	SH_TAILQ_REMOVE(&mgr->region->active_txn, tp, links, __txn_detail);  ! 	__db_shalloc_free(mgr->mem, tp);T   	if (is_commit)  		mgr->region->ncommits++; 	elsex 		mgr->region->naborts++;D   	UNLOCK_TXNREGION(mgr);l   	/* Free the space. */! 	if (F_ISSET(txnp, TXN_MALLOC)) {h 		LOCK_TXNTHREAD(mgr);- 		TAILQ_REMOVE(&mgr->txn_chain, txnp, links);X 		UNLOCK_TXNTHREAD(mgr);  ! 		__os_free(txnp, sizeof(*txnp));e 	}   	return (0); }D     /*  * __txn_undo --@  *	Undo the transaction with id txnid.  Returns 0 on success and  *	errno on failure.  */ 
 static int __txn_undo(txnp) 	DB_TXN *txnp; { 
 	DBT rdbt; 	DB_LOG *logp; 	DB_LSN key_lsn; 	DB_TXNMGR *mgr;	 	int ret;_   	mgr = txnp->mgrp; 	logp = mgr->dbenv->lg_info; 	if (logp == NULL)
 		return (0);    	/*gD 	 * This is the simplest way to code this, but if the mallocs during> 	 * recovery turn out to be a performance issue, we can do the+ 	 * allocation here and use DB_DBT_USERMEM.  	 */  	memset(&rdbt, 0, sizeof(rdbt));! 	if (F_ISSET(logp, DB_AM_THREAD))n 		F_SET(&rdbt, DB_DBT_MALLOC);  6 	key_lsn = txnp->last_lsn;		/* structure assignment */4 	for (ret = 0; ret == 0 && !IS_ZERO_LSN(key_lsn);) { 		/*7 		 * The dispatch routine returns the lsn of the recordv4 		 * before the current one in the key_lsn argument. 		 */n< 		if ((ret = log_get(logp, &key_lsn, &rdbt, DB_SET)) == 0) { 			ret =; 			    mgr->recover(logp, &rdbt, &key_lsn, TXN_UNDO, NULL);R: 			if (F_ISSET(logp, DB_AM_THREAD) && rdbt.data != NULL) {$ 				__os_free(rdbt.data, rdbt.size); 				rdbt.data = NULL;d 			} 		}o 		if (ret != 0)e 			return (ret); 	}   	return (ret); }c   /*  * Transaction checkpoint.L  * If either kbytes or minutes is non-zero, then we only take the checkpointJ  * more than "minutes" minutes have passed since the last checkpoint or ifN  * more than "kbytes" of log data have been written since the last checkpoint.N  * When taking a checkpoint, find the oldest active transaction and figure outM  * its first LSN.  This is the lowest LSN we can checkpoint, since any record>J  * written after since that point may be involved in a transaction and may7  * therefore need to be undone in the case of an abort.d  */s int $ txn_checkpoint(mgr, kbytes, minutes) 	const DB_TXNMGR *mgr; 	u_int32_t kbytes, minutes;o {g 	DB_LOG *dblp; 	DB_LSN ckp_lsn, last_ckp; 	TXN_DETAIL *txnp; 	time_t last_ckp_time, now;  	u_int32_t kbytes_written;	 	int ret;L   	TXN_PANIC_CHECK(mgr);   	/*E% 	 * Check if we need to run recovery.  	 */ 	ZERO_LSN(ckp_lsn);a 	if (minutes != 0) { 		(void)time(&now);O   		LOCK_TXNREGION(mgr);( 		last_ckp_time = mgr->region->time_ckp; 		UNLOCK_TXNREGION(mgr);  4 		if (now - last_ckp_time >= (time_t)(minutes * 60)) 			goto do_ckp;i 	}   	if (kbytes != 0) {i 		dblp = mgr->dbenv->lg_info;  		LOCK_LOGREGION(dblp);g 		kbytes_written =* 		    dblp->lp->stat.st_wc_mbytes * 1024 +( 		    dblp->lp->stat.st_wc_bytes / 1024; 		ckp_lsn = dblp->lp->lsn; 		UNLOCK_LOGREGION(dblp);G* 		if (kbytes_written >= (u_int32_t)kbytes) 			goto do_ckp;  	}   	/* < 	 * If we checked time and data and didn't go to checkpoint, 	 * we're done.T 	 */! 	if (minutes != 0 || kbytes != 0)N
 		return (0);m   do_ckp:  	if (IS_ZERO_LSN(ckp_lsn)) { 		dblp = mgr->dbenv->lg_info;( 		LOCK_LOGREGION(dblp);m 		ckp_lsn = dblp->lp->lsn; 		UNLOCK_LOGREGION(dblp);t 	}   	/*_; 	 * We have to find an LSN such that all transactions begunK! 	 * before that LSN are complete.h 	 */ 	LOCK_TXNREGION(mgr);)  , 	if (!IS_ZERO_LSN(mgr->region->pending_ckp))% 		ckp_lsn = mgr->region->pending_ckp;n 	else 
 		for (txnp =o= 		    SH_TAILQ_FIRST(&mgr->region->active_txn, __txn_detail);) 		    txnp != NULL;S8 		    txnp = SH_TAILQ_NEXT(txnp, links, __txn_detail)) {   			/*p2 			 * Look through the active transactions for the 			 * lowest begin lsn.  			 */' 			if (!IS_ZERO_LSN(txnp->begin_lsn) &&t3 			    log_compare(&txnp->begin_lsn, &ckp_lsn) < 0)n 				ckp_lsn = txnp->begin_lsn; 		}n  $ 	mgr->region->pending_ckp = ckp_lsn; 	UNLOCK_TXNREGION(mgr);C  # 	if (mgr->dbenv->mp_info != NULL &&h= 	    (ret = memp_sync(mgr->dbenv->mp_info, &ckp_lsn)) != 0) {  		/*? 		 * ret == DB_INCOMPLETE means that there are still buffers toa@ 		 * flush, the checkpoint is not complete.  Wait and try again. 		 */  		if (ret > 0) 			__db_err(mgr->dbenv,p: 			    "txn_checkpoint: system failure in memp_sync %s\n", 			    strerror(ret)); 		return (ret);x 	}# 	if (mgr->dbenv->lg_info != NULL) {_ 		LOCK_TXNREGION(mgr);# 		last_ckp = mgr->region->last_ckp;x% 		ZERO_LSN(mgr->region->pending_ckp);e 		UNLOCK_TXNREGION(mgr);  / 		if ((ret = __txn_ckp_log(mgr->dbenv->lg_info, A 		   NULL, &ckp_lsn, DB_CHECKPOINT, &ckp_lsn, &last_ckp)) != 0) {i 			__db_err(mgr->dbenv, : 			    "txn_checkpoint: log failed at LSN [%ld %ld] %s\n",0 			    (long)ckp_lsn.file, (long)ckp_lsn.offset, 			    strerror(ret)); 			return (ret); 		}-   		LOCK_TXNREGION(mgr);" 		mgr->region->last_ckp = ckp_lsn;% 		(void)time(&mgr->region->time_ckp);r 		UNLOCK_TXNREGION(mgr); 	} 	return (0); }A   /*  * __txn_validate_region --RF  *	Called at every interface to verify if the region has changed size,E  *	and if so, to remap the region in and reset the process' pointers.   */n
 static int __txn_validate_region(tp)t 	DB_TXNMGR *tp;t {d	 	int ret;*  . 	if (tp->reginfo.size == tp->region->hdr.size)
 		return (0);l  " 	/* Detach/reattach the region. */E 	if ((ret = __db_rreattach(&tp->reginfo, tp->region->hdr.size)) != 0)T 		return (ret);g    	/* Reset region information. */ 	tp->region = tp->reginfo.addr;e 	tp->mem = &tp->region[1];   	return (0); }   
 static int __txn_grow_region(tp)h 	DB_TXNMGR *tp;  {/ 	size_t incr, oldsize;  	u_int32_t mutex_offset, oldmax; 	u_int8_t *curaddr;x	 	int ret;    	oldmax = tp->region->maxtxns;  	incr = oldmax * sizeof(DB_TXN);$ 	mutex_offset = tp->mutexp != NULL ?9 	    (u_int8_t *)tp->mutexp - (u_int8_t *)tp->region : 0;(   	oldsize = tp->reginfo.size;; 	if ((ret = __db_rgrow(&tp->reginfo, oldsize + incr)) != 0)L 		return (ret);E 	tp->region = tp->reginfo.addr;(  , 	/* Throw the new space on the free list. */, 	curaddr = (u_int8_t *)tp->region + oldsize; 	tp->mem = &tp->region[1];! 	tp->mutexp = mutex_offset != 0 ?>B 	    (db_mutex_t *)((u_int8_t *)tp->region + mutex_offset) : NULL;  . 	*((size_t *)curaddr) = incr - sizeof(size_t); 	curaddr += sizeof(size_t);R% 	__db_shalloc_free(tp->mem, curaddr);n  " 	tp->region->maxtxns = 2 * oldmax;   	return (0); }i   inte txn_stat(mgr, statp, db_malloc)O 	DB_TXNMGR *mgr; 	DB_TXN_STAT **statp;o" 	void *(*db_malloc) __P((size_t)); {= 	DB_TXN_STAT *stats; 	TXN_DETAIL *txnp; 	size_t nbytes;L 	u_int32_t nactive, ndx;	 	int ret;o   	TXN_PANIC_CHECK(mgr);   	LOCK_TXNREGION(mgr);E! 	nactive = mgr->region->nbegins -n2 	    mgr->region->naborts - mgr->region->ncommits; 	UNLOCK_TXNREGION(mgr);)   	/*t= 	 * Allocate a bunch of extra active structures to handle anyf8 	 * that have been created since we unlocked the region. 	 */H 	nbytes = sizeof(DB_TXN_STAT) + sizeof(DB_TXN_ACTIVE) * (nactive + 200);9 	if ((ret = __os_malloc(nbytes, db_malloc, &stats)) != 0)L 		return (ret);=   	LOCK_TXNREGION(mgr);o0 	stats->st_last_txnid = mgr->region->last_txnid;, 	stats->st_last_ckp = mgr->region->last_ckp;* 	stats->st_maxtxns = mgr->region->maxtxns;* 	stats->st_naborts = mgr->region->naborts;* 	stats->st_nbegins = mgr->region->nbegins;, 	stats->st_ncommits = mgr->region->ncommits;2 	stats->st_pending_ckp = mgr->region->pending_ckp;, 	stats->st_time_ckp = mgr->region->time_ckp;( 	stats->st_nactive = stats->st_nbegins -, 	    stats->st_naborts - stats->st_ncommits;' 	if (stats->st_nactive > nactive + 200) $ 		stats->st_nactive = nactive + 200;1 	stats->st_txnarray = (DB_TXN_ACTIVE *)&stats[1];   	 	ndx = 0;	D 	for (txnp = SH_TAILQ_FIRST(&mgr->region->active_txn, __txn_detail); 	    txnp != NULL;7 	    txnp = SH_TAILQ_NEXT(txnp, links, __txn_detail)) { . 		stats->st_txnarray[ndx].txnid = txnp->txnid;0 		stats->st_txnarray[ndx].lsn = txnp->begin_lsn; 		ndx++;   		if (ndx >= stats->st_nactive)(	 			break;t 	}  > 	stats->st_region_wait = mgr->region->hdr.lock.mutex_set_wait;B 	stats->st_region_nowait = mgr->region->hdr.lock.mutex_set_nowait;, 	stats->st_refcnt = mgr->region->hdr.refcnt;+ 	stats->st_regsize = mgr->region->hdr.size;r   	UNLOCK_TXNREGION(mgr);C 	*statp = stats; 	return (0); }sce. */! 	if (F_ISSET(txnp, TXN_MALLOC)) {h 		LOCK_TXNTHREAD(mgr);- 		TAILQ_REMOVE(&mgr->txn_chain, txnp, links);X 		UNLOCK_TXNTHREAD(mgr);  ! 		__os_free(txnp, sizeof(*txnp));e 	}   	return (0); }D     /*  * __txn_undo --@  *	Undo the transaction with id txnid.  Returns 0 on success and  *	errno on failure.  */ 
 static int __txn_undo(txnp) 	DB_TXN *txnp; { 
 	DBT rdbt; 	DB_LOG *logp; 	DB_LS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                