 // // Dictionary.cc //) // Implementation of the Dictionary class  //A // $Id: Dictionary.cc,v 1.5.2.1 1999/03/23 00:46:45 grdetil Exp $  //   #include "Dictionary.h"  #include <stdlib.h>    class DictionaryEntry  {  public:      unsigned int	hash;     char		*key;      Object		*value;      DictionaryEntry	*next;       ~DictionaryEntry();      void		release(); };  # DictionaryEntry::~DictionaryEntry()  {      delete [] key;     delete value; 
     if (next)          delete next; }    void DictionaryEntry::release() { :     value = NULL;		// Prevent the value from being deleted
     if (next)          next->release(); }     G //*********************************************************************  // Dictionary::Dictionary() {      init(101, 10.0f);  }   = Dictionary::Dictionary(int initialCapacity, float loadFactor)  { &     init(initialCapacity, loadFactor); }   + Dictionary::Dictionary(int initialCapacity)  { !     init(initialCapacity, 0.75f);  }     G //*********************************************************************  // Dictionary::~Dictionary()  { )     for (int i = 0; i < tableLength; i++)      {  	delete table[i];      }      delete [] table; }     G //*********************************************************************  // void Dictionary::Destroy()  { )     for (int i = 0; i < tableLength; i++)      {  	if (table[i] != NULL) 	{ 	    delete table[i];  	    table[i] = NULL;  	}     }      count = 0; }   G //*********************************************************************  // void Dictionary::Release()  { )     for (int i = 0; i < tableLength; i++)      {  	if (table[i] != NULL) 	{ 	    table[i]->release();  	    delete table[i];  	    table[i] = NULL;  	}     }      count = 0; }     G //*********************************************************************  // void7 Dictionary::init(int initialCapacity, float loadFactor)  {      if (initialCapacity <= 0)  	initialCapacity = 101;      if (loadFactor <= 0.0) 	loadFactor = 0.75f;(     Dictionary::loadFactor = loadFactor;2     table = new DictionaryEntry*[initialCapacity];-     for (int i = 0; i < initialCapacity; i++)      {  	table[i] = NULL;      } 4     threshold = (int)(initialCapacity * loadFactor);"     tableLength = initialCapacity;     count = 0; }   G //*********************************************************************  // unsigned int Dictionary::hashCode(char *key)  {      char *test; -     long  conv_key = strtol(key,  &test, 10); 6     if (key && *key && !*test) // Conversion succeeded       return conv_key;     unsigned int	h = 0;      int			length = strlen(key);        if (length < 16)     { ! 	for (int i = length; i > 0; i--)  	{ 	    h = (h * 37) + *key++;  	}     }      else     {  	int	skip = length / 8; 4 	for (int i = length; i > 0; i -= skip, key += skip) 	{ 	    h = (h * 39) + *key;  	}     } 
     return h;  }     G //********************************************************************* @ //   Add an entry to the hash table.  This will *not* delete theC //   data associated with an already existing key.  Use the Replace  //   method for that function. // void( Dictionary::Add(char *name, Object *obj) { '     unsigned int	hash = hashCode(name); %     int			index = hash % tableLength;      DictionaryEntry	*e;      2     for (e = table[index]; e != NULL; e = e->next)     { 2 	if (e->hash == hash && strcmp(e->key, name) == 0) 	{ 	    delete e->value;  	    e->value = obj; 	    return; 	}     }        if (count >= threshold)      { 
 	rehash(); 	Add(name, obj); 	return;     }        e = new DictionaryEntry();     e->hash = hash;      e->key = strdup(name);     e->value = obj;      e->next = table[index];      table[index] = e;      count++; }     G //********************************************************************* ) //   Remove an entry from the hash table.  // int  Dictionary::Remove(char *name) {      if (!count)        return 0;   '     unsigned int	hash = hashCode(name); %     int			index = hash % tableLength;      DictionaryEntry	*e, *prev;  I     for (e = table[index], prev = NULL; e != NULL; prev = e, e = e->next)      { 2 	if (hash == e->hash && strcmp(e->key, name) == 0) 	{ 	    if (prev != NULL) 	    { 		prev->next = e->next;  	    }	 	    else  	    { 		table[index] = e->next;  	    }
 	    count--;              delete e;  	    return 1; 	}     } 
     return 0;  }     G //*********************************************************************  //$ Object *Dictionary::Find(char *name) {      if (!count) 
 	return NULL;   '     unsigned int	hash = hashCode(name); %     int			index = hash % tableLength;      DictionaryEntry	*e;   2     for (e = table[index]; e != NULL; e = e->next)     { 2 	if (e->hash == hash && strcmp(e->key, name) == 0) 	{ 	    return e->value;  	}     }      return NULL; }     G //*********************************************************************  //* Object *Dictionary::operator[](char *name) {      return Find(name); }     G //*********************************************************************  //" int Dictionary::Exists(char *name) {      if (!count)        return 0;   '     unsigned int	hash = hashCode(name); %     int			index = hash % tableLength;      DictionaryEntry	*e;   2     for (e = table[index]; e != NULL; e = e->next)     { 2 	if (e->hash == hash && strcmp(e->key, name) == 0) 	{ 	    return 1; 	}     } 
     return 0;  }     G //*********************************************************************  // void Dictionary::rehash() { '     DictionaryEntry	**oldTable = table; $     int			oldCapacity = tableLength;       int			newCapacity;     DictionaryEntry	*e;      int			i, index;      L     newCapacity = count > oldCapacity ? count * 2 + 1 : oldCapacity * 2 + 1;  C     DictionaryEntry	**newTable = new DictionaryEntry*[newCapacity];   %     for (i = 0; i < newCapacity; i++)      {  	newTable[i] = NULL;     }   1     threshold = (int) (newCapacity * loadFactor);      table = newTable;      tableLength = newCapacity;     #     for (i = oldCapacity; i-- > 0;)      { 7 	for (DictionaryEntry *old = oldTable[i]; old != NULL;)  	{
 	    e = old;  	    old = old->next; # 	    index = e->hash % newCapacity;  	    e->next = newTable[index];  	    newTable[index] = e;  	}     }      delete [] oldTable;  }     G //*********************************************************************  // void Dictionary::Start_Get()  {      currentTableIndex = -1; "     currentDictionaryEntry = NULL; }     G //*********************************************************************  // char * Dictionary::Get_Next() { ,     while (currentDictionaryEntry == NULL ||) 	   currentDictionaryEntry->next == NULL)      {  	currentTableIndex++;   & 	if (currentTableIndex >= tableLength) 	{ 	    currentTableIndex--;  	    return NULL;  	}  3 	currentDictionaryEntry = table[currentTableIndex];   $ 	if (currentDictionaryEntry != NULL) 	{( 	    return currentDictionaryEntry->key; 	}     }   :     currentDictionaryEntry = currentDictionaryEntry->next;'     return currentDictionaryEntry->key;  }   G //*********************************************************************  // Object * Dictionary::Get_NextElement()  { ,     while (currentDictionaryEntry == NULL ||) 	   currentDictionaryEntry->next == NULL)      {  	currentTableIndex++;   & 	if (currentTableIndex >= tableLength) 	{ 	    currentTableIndex--;  	    return NULL;  	}  3 	currentDictionaryEntry = table[currentTableIndex];   $ 	if (currentDictionaryEntry != NULL) 	{* 	    return currentDictionaryEntry->value; 	}     }   :     currentDictionaryEntry = currentDictionaryEntry->next;)     return currentDictionaryEntry->value;  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         