2 /* mktime: convert a `struct tm' to a time_t value?    Copyright (C) 1993-1997, 1998 Free Software Foundation, Inc. 3    Contributed by Paul Eggert (eggert@twinsun.com).   P    NOTE: The canonical source of this file is maintained with the GNU C Library.5    Bugs can be reported to bug-glibc@prep.ai.mit.edu.   J    This program is free software; you can redistribute it and/or modify itH    under the terms of the GNU General Public License as published by theF    Free Software Foundation; either version 2, or (at your option) any    later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free SoftwareH    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,    USA.  */   J /* Define this to have a standalone program to test this implementation of    mktime.  */ /* #define DEBUG 1 */    #ifdef HAVE_CONFIG_H # include <config.h> #endif   #ifdef _LIBC # define HAVE_LIMITS_H 1 # define STDC_HEADERS 1  #endif  @ /* Assume that leap seconds are possible, unless told otherwise.I    If the host has a `zic' command with a `-L leapsecondfilename' option, D    then it supports leap seconds; otherwise it probably doesn't.  */ #ifndef LEAP_SECONDS_POSSIBLE   # define LEAP_SECONDS_POSSIBLE 1 #endif  A #include <sys/types.h>		/* Some systems define `time_t' here.  */  #include <time.h>    #if HAVE_LIMITS_H  # include <limits.h> #endif  	 #if DEBUG  # include <stdio.h>  # if STDC_HEADERS  #  include <stdlib.h>  # endif I /* Make it work even if the system's libc has its own mktime routine.  */  # define mktime my_mktime  #endif /* DEBUG */   #ifndef __P ; # if defined (__GNUC__) || (defined (__STDC__) && __STDC__)  #  define __P(args) args # else #  define __P(args) () # endif  /* GCC.  */ #endif  /* Not __P.  */    #ifndef CHAR_BIT # define CHAR_BIT 8  #endif  8 /* The extra casts work around common compiler bugs.  */+ #define TYPE_SIGNED(t) (! ((t) 0 < (t) -1)) C /* The outer cast is needed to work around a bug in Cray C 5.0.3.0. 1    It is necessary at least when t == time_t.  */ / #define TYPE_MINIMUM(t) ((t) (TYPE_SIGNED (t) \ ; 			      ? ~ (t) 0 << (sizeof (t) * CHAR_BIT - 1) : (t) 0)) : #define TYPE_MAXIMUM(t) ((t) (~ (t) 0 - TYPE_MINIMUM (t)))   #ifndef INT_MIN # # define INT_MIN TYPE_MINIMUM (int)  #endif #ifndef INT_MAX # # define INT_MAX TYPE_MAXIMUM (int)  #endif   #ifndef TIME_T_MIN) # define TIME_T_MIN TYPE_MINIMUM (time_t)  #endif #ifndef TIME_T_MAX) # define TIME_T_MAX TYPE_MAXIMUM (time_t)  #endif   #define TM_YEAR_BASE 1900  #define EPOCH_YEAR 1970    #ifndef __isleap1 /* Nonzero if YEAR is a leap year (every 4 years, 5    except every 100th isn't, and every 400th is).  */  # define __isleap(year)	\ ?   ((year) % 4 == 0 && ((year) % 100 != 0 || (year) % 400 == 0))  #endif  3 /* How many days come before each month (0-12).  */ , const unsigned short int __mon_yday[2][13] =   {      /* Normal years.  */C     { 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365 },      /* Leap years.  */B     { 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366 }   };  K static struct tm *ranged_convert __P ((struct tm *(*) __P ((const time_t *,  							    struct tm *)), # 				       time_t *, struct tm *)); O static time_t ydhms_tm_diff __P ((int, int, int, int, int, const struct tm *)); + time_t __mktime_internal __P ((struct tm *, 7 			       struct tm *(*) (const time_t *, struct tm *),  			       time_t *));      #ifdef _LIBC, # define my_mktime_localtime_r __localtime_r #else = /* If we're a mktime substitute in a GNU program, then prefer C    localtime to localtime_r, since many localtime_r implementations     are buggy.  */ L static struct tm *my_mktime_localtime_r __P ((const time_t *, struct tm *)); static struct tm * my_mktime_localtime_r (t, tp)       const time_t *t;       struct tm *tp;  {    struct tm *l = localtime (t); 
   if (! l)
     return 0;    *tp = *l;    return tp; }  #endif /* ! _LIBC */    C /* Yield the difference between (YEAR-YDAY HOUR:MIN:SEC) and (*TP), .    measured in seconds, ignoring leap seconds./    YEAR uses the same numbering as TM->tm_year. 1    All values are in range, except possibly YEAR. )    If TP is null, return a nonzero value. J    If overflow occurs, yield the low order bits of the correct answer.  */
 static time_t . ydhms_tm_diff (year, yday, hour, min, sec, tp)$      int year, yday, hour, min, sec;      const struct tm *tp;  { 
   if (!tp)
     return 1;    else     { J       /* Compute intervening leap days correctly even if year is negative.@ 	 Take care to avoid int overflow.  time_t overflow is OK, sinceB 	 only the low order bits of the correct time_t answer are needed.C 	 Don't convert to time_t until after all divisions are done, since  	 time_t might be unsigned.  */ @       int a4 = (year >> 2) + (TM_YEAR_BASE >> 2) - ! (year & 3);N       int b4 = (tp->tm_year >> 2) + (TM_YEAR_BASE >> 2) - ! (tp->tm_year & 3);)       int a100 = a4 / 25 - (a4 % 25 < 0); )       int b100 = b4 / 25 - (b4 % 25 < 0);        int a400 = a100 >> 2;        int b400 = b100 >> 2; L       int intervening_leap_days = (a4 - b4) - (a100 - b100) + (a400 - b400);1       time_t years = year - (time_t) tp->tm_year; 8       time_t days = (365 * years + intervening_leap_days 		     + (yday - tp->tm_yday)); ;       return (60 * (60 * (24 * days + (hour - tp->tm_hour))  		    + (min - tp->tm_min))  	      + (sec - tp->tm_sec));      }  }      static time_t localtime_offset;   % /* Convert *TP to a time_t value.  */  time_t mktime (tp)       struct tm *tp;  {  #ifdef _LIBCA   /* POSIX.1 8.1.1 requires that whenever mktime() is called, the F      time zone names contained in the external variable `tzname' shall;      be set as if the tzset() function had been called.  */ 
   __tzset ();  #endif  J   return __mktime_internal (tp, my_mktime_localtime_r, &localtime_offset); }   : /* Use CONVERT to convert *T to a broken down time in *TP.:    If *T is out of range for conversion, adjust it so that>    it is the nearest in-range value and then convert that.  */ static struct tm * ranged_convert (convert, t, tp) ?      struct tm *(*convert) __P ((const time_t *, struct tm *));       time_t *t;       struct tm *tp;  {    struct tm *r;   '   if (! (r = (*convert) (t, tp)) && *t)      {        time_t bad = *t;       time_t ok = 0;       struct tm tm;   I       /* BAD is a known unconvertible time_t, and OK is a known good one. @ 	 Use binary search to narrow the range between BAD and OK until 	 they differ by 1.  */ ,       while (bad != ok + (bad < 0 ? -1 : 1)) 	{ 	  time_t mid = *t = (bad < 0 ! 			     ? bad + ((ok - bad) >> 1) " 			     : ok + ((bad - ok) >> 1));  	  if ((r = (*convert) (t, tp))) 	    { 	      tm = *r;  	      ok = mid; 	    } 	  else  	    bad = mid;  	}         if (!r && ok)  	{) 	  /* The last conversion attempt failed; 7 	     revert to the most recent successful attempt.  */  	  *t = ok;  	  *tp = tm;
 	  r = tp; 	}     }      return r;  }     + /* Convert *TP to a time_t value, inverting D    the monotonic and mostly-unit-linear conversion function CONVERT.D    Use *OFFSET to keep track of a guess at the offset of the result,E    compared to what the result would be for UTC without leap seconds. F    If *OFFSET's guess is correct, only one CONVERT call is needed.  */ time_t' __mktime_internal (tp, convert, offset)       struct tm *tp; ?      struct tm *(*convert) __P ((const time_t *, struct tm *));       time_t *offset; {    time_t t, dt, t0, t1, t2;    struct tm tm;   E   /* The maximum number of probes (calls to CONVERT) should be enough F      to handle any combinations of time zone rule changes, solar time,@      leap seconds, and oscillations around a spring-forward gap.I      POSIX.1 prohibits leap seconds, but some hosts have them anyway.  */c   int remaining_probes = 6;e  D   /* Time requested.  Copy it in case CONVERT modifies *TP; this canL      occur if TP is localtime's returned value and CONVERT is localtime.  */   int sec = tp->tm_sec;i   int min = tp->tm_min;    int hour = tp->tm_hour;r   int mday = tp->tm_mday;i   int mon = tp->tm_mon;g#   int year_requested = tp->tm_year;i   int isdst = tp->tm_isdst;u  ?   /* Ensure that mon is in range, and set year accordingly.  */e   int mon_remainder = mon % 12;t1   int negative_mon_remainder = mon_remainder < 0;r4   int mon_years = mon / 12 - negative_mon_remainder;(   int year = year_requested + mon_years;  +   /* The other values need not be in range: :      the remaining code handles minor overflows correctly,5      assuming int and time_t arithmetic wraps around. /      Major overflows are caught at the end.  */   >   /* Calculate day of year from year, month, and day of month.)      The result need not be in range.  */59   int yday = ((__mon_yday[__isleap (year + TM_YEAR_BASE)] 6 	       [mon_remainder + 12 * negative_mon_remainder]) 	      + mday - 1);o     int sec_requested = sec; #if LEAP_SECONDS_POSSIBLEV+   /* Handle out-of-range seconds specially,iA      since ydhms_tm_diff assumes every minute has 60 seconds.  */d   if (sec < 0)     sec = 0;   if (59 < sec) 
     sec = 59;e #endif  K   /* Invert CONVERT by probing.  First assume the same offset as last time.t<      Then repeatedly use the error to improve the guess.  */  )   tm.tm_year = EPOCH_YEAR - TM_YEAR_BASE;L6   tm.tm_yday = tm.tm_hour = tm.tm_min = tm.tm_sec = 0;7   t0 = ydhms_tm_diff (year, yday, hour, min, sec, &tm);i  "   for (t = t1 = t2 = t0 + *offset;7        (dt = ydhms_tm_diff (year, yday, hour, min, sec, + 			    ranged_convert (convert, &t, &tm)));          t1 = t2, t2 = t, t += dt)     if (t == t1 && t != t2! 	&& (isdst < 0 || tm.tm_isdst < 0m, 	    || (isdst != 0) != (tm.tm_isdst != 0)))>       /* We can't possibly find a match, as we are oscillating8 	 between two values.  The requested time probably falls< 	 within a spring-forward gap of size DT.  Follow the common= 	 practice in this case, which is to return a time that is DT 7 	 away from the requested time, preferring a time whose(: 	 tm_isdst differs from the requested value.  In practice,, 	 this is more useful than returning -1.  */       break;%     else if (--remaining_probes == 0)N       return -1;  D   /* If we have a match, check whether tm.tm_isdst has the requested      value, if any.  */M0   if (dt == 0 && 0 <= isdst && 0 <= tm.tm_isdst)     { 7       int dst_diff = (isdst != 0) - (tm.tm_isdst != 0);N       if (dst_diff)M 	{D 	  /* Move two hours in the direction indicated by the disagreement,9 	     probe some more, and switch to a new time if found.eF 	     The largest known fallback due to daylight savings is two hours:; 	     once, in Newfoundland, 1988-10-30 02:00 -> 00:00.  */ * 	  time_t ot = t - 2 * 60 * 60 * dst_diff;" 	  while (--remaining_probes != 0) 	    { 	      struct tm otm;(= 	      if (! (dt = ydhms_tm_diff (year, yday, hour, min, sec,4, 					 ranged_convert (convert, &ot, &otm)))) 		{e 		  t = ot;1
 		  tm = otm; 
 		  break; 		}t 	      if ((ot += dt) == t) ) 		break;  /* Avoid a redundant probe.  */, 	    } 	}     },     *offset = t - t0;5   #if LEAP_SECONDS_POSSIBLE !   if (sec_requested != tm.tm_sec)      {4O       /* Adjust time to reflect the tm_sec requested, not the normalized value.*F 	 Also, repair any damage from a false match due to a leap second.  */?       t += sec_requested - sec + (sec == 0 && tm.tm_sec == 60); !       if (! (*convert) (&t, &tm))  	return -1;t     }e #endif  4   if (TIME_T_MAX / INT_MAX / 366 / 24 / 60 / 60 < 3)     {uJ       /* time_t isn't large enough to rule out overflows in ydhms_tm_diff,8 	 so check for major overflows.  A gross check suffices,7 	 since if t has overflowed, it is off by a multiple ofa: 	 TIME_T_MAX - TIME_T_MIN + 1.  So ignore any component of6 	 the difference that is bounded by a small value.  */  F       double dyear = (double) year_requested + mon_years - tm.tm_year;'       double dday = 366 * dyear + mday;rI       double dsec = 60 * (60 * (24 * dday + hour) + min) + sec_requested;0  C       /* On Irix4.0.5 cc, dividing TIME_T_MIN by 3 does not producet= 	 correct results, ie., it erroneously gives a positive valuem? 	 of 715827882.  Setting a variable first then doing math on it - 	 seems to work.  (ghazi@caip.rutgers.edu) */n  +       const time_t time_t_max = TIME_T_MAX;l+       const time_t time_t_min = TIME_T_MIN;c  G       if (time_t_max / 3 - time_t_min / 3 < (dsec < 0 ? - dsec : dsec))d 	return -1;y     }a     *tp = tm;e   return t;i }y   #ifdef weak_alias  weak_alias (mktime, timelocal) #endif (	 #if DEBUGe  
 static int not_equal_tm (a, b)C      struct tm *a;      struct tm *b; { !   return ((a->tm_sec ^ b->tm_sec)o 	  | (a->tm_min ^ b->tm_min) 	  | (a->tm_hour ^ b->tm_hour) 	  | (a->tm_mday ^ b->tm_mday) 	  | (a->tm_mon ^ b->tm_mon) 	  | (a->tm_year ^ b->tm_year) 	  | (a->tm_mday ^ b->tm_mday) 	  | (a->tm_yday ^ b->tm_yday)" 	  | (a->tm_isdst ^ b->tm_isdst)); }A   static void!
 print_tm (tp)       struct tm *tp;y { 	   if (tp)_G     printf ("%04d-%02d-%02d %02d:%02d:%02d yday %03d wday %d isdst %d",2= 	    tp->tm_year + TM_YEAR_BASE, tp->tm_mon + 1, tp->tm_mday, ) 	    tp->tm_hour, tp->tm_min, tp->tm_sec,>- 	    tp->tm_yday, tp->tm_wday, tp->tm_isdst);4   else     printf ("0");  }0  
 static int check_result (tk, tmk, tl, lt)      time_t tk;i      struct tm tmk;a      time_t tl;l      struct tm *lt;d {-1   if (tk != tl || !lt || not_equal_tm (&tmk, lt))y     {u       printf ("mktime (");       print_tm (&tmk);       printf (")\nyields (");        print_tm (lt);A       printf (") == %ld, should be %ld\n", (long) tl, (long) tk);        return 1;p     }      return 0;  }    intf main (argc, argv)1      int argc;      char **argv;e {i   int status = 0;    struct tm tm, tmk, tml;i   struct tm *lt;   time_t tk, tl;   char trailer;s     if ((argc == 3 || argc == 4)(       && (sscanf (argv[1], "%d-%d-%d%c",3 		  &tm.tm_year, &tm.tm_mon, &tm.tm_mday, &trailer)& 	  == 3)(       && (sscanf (argv[2], "%d:%d:%d%c",2 		  &tm.tm_hour, &tm.tm_min, &tm.tm_sec, &trailer)	 	  == 3))c     {o!       tm.tm_year -= TM_YEAR_BASE;n       tm.tm_mon--;4       tm.tm_isdst = argc == 3 ? -1 : atoi (argv[3]);       tmk = tm;r       tl = mktime (&tmk);*       lt = localtime (&tl); 
       if (lt)) 	{
 	  tml = *lt; 
 	  lt = &tml;m 	}3       printf ("mktime returns %ld == ", (long) tl);t       print_tm (&tmk);       printf ("\n");.       status = check_result (tl, tmk, tl, lt);     }*B   else if (argc == 4 || (argc == 5 && strcmp (argv[4], "-") == 0))     {i#       time_t from = atol (argv[1]);e!       time_t by = atol (argv[2]);y!       time_t to = atol (argv[3]);(         if (argc == 4)$ 	for (tl = from; tl <= to; tl += by) 	  { 	    lt = localtime (&tl); 	    if (lt) 	      { 		tmk = tml = *lt; 		tk = mktime (&tmk); , 		status |= check_result (tk, tmk, tl, tml); 	      }	 	    elsed 	      {3 		printf ("localtime (%ld) yields 0\n", (long) tl);s
 		status = 1;l 	      } 	  }
       else$ 	for (tl = from; tl <= to; tl += by) 	  { 	    /* Null benchmark.  */; 	    lt = localtime (&tl); 	    if (lt) 	      { 		tmk = tml = *lt;
 		tk = tl;, 		status |= check_result (tk, tmk, tl, tml); 	      }	 	    else. 	      {3 		printf ("localtime (%ld) yields 0\n", (long) tl);r
 		status = 1;a 	      } 	  }     }w   else     printf ("Usage:\6 \t%s YYYY-MM-DD HH:MM:SS [ISDST] # Test given time.\n\8 \t%s FROM BY TO # Test values FROM, FROM+BY, ..., TO.\n\A \t%s FROM BY TO - # Do not test those values (for benchmark).\n",_  	    argv[0], argv[0], argv[0]);     return status; };   #endif /* DEBUG */   /* Local Variables:_ compile-command: "gcc -DDEBUG -DHAVE_LIMITS_H -DSTDC_HEADERS -Wall -W -O -g mktime.c -o mktime"y End: */s of time zone rule changes, solar time,@      leap seconds, and oscillations around a spring-forward gap.I      POSIX.1 prohibits leap seconds, but some hosts have the