; /* Extended regular expression matching and search library,     version 0.12.@    (Implements POSIX draft P1003.2/D11.2, except for some of the"    internationalization features.)L    Copyright (C) 1993, 94, 95, 96, 97, 98, 99 Free Software Foundation, Inc.  E    The GNU C Library is free software; you can redistribute it and/or I    modify it under the terms of the GNU Library General Public License as E    published by the Free Software Foundation; either version 2 of the 2    License, or (at your option) any later version.  G    The GNU C Library is distributed in the hope that it will be useful, A    but WITHOUT ANY WARRANTY; without even the implied warranty of D    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU3    Library General Public License for more details.   D    You should have received a copy of the GNU Library General PublicK    License along with the GNU C Library; see the file COPYING.LIB.  If not, L    write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,"    Boston, MA 02111-1307, USA.  */  : /* AIX requires this to be the first thing in the file. */) #if defined _AIX && !defined REGEX_MALLOC    #pragma alloca #endif   #undef	_GNU_SOURCE #define _GNU_SOURCE    #include <htconfig.h>  #ifdef HAVE_CONFIG_H # include <config.h> #endif   #ifndef PARAMS7 # if defined __GNUC__ || (defined __STDC__ && __STDC__)  #  define PARAMS(args) args  # else #  define PARAMS(args) ()  # endif  /* GCC.  */ #endif  /* Not PARAMS.  */  * #if defined STDC_HEADERS && !defined emacs # include <stddef.h> #else K /* We need this for `regex.h', and perhaps for the Emacs include files.  */  # include <sys/types.h>  #endif  G #define WIDE_CHAR_SUPPORT (HAVE_WCTYPE_H && HAVE_WCHAR_H && HAVE_BTOWC)   E /* For platform which support the ISO C amendement 1 functionality we .    support user defined character classes.  */& #if defined _LIBC || WIDE_CHAR_SUPPORTK /* Solaris 2.5 has a bug: <wchar.h> must be included before <wctype.h>.  */  # include <wchar.h>  # include <wctype.h> #endif   #ifdef _LIBC+ /* We have to keep the namespace clean.  */ ' # define regfree(preg) __regfree (preg) C # define regexec(pr, st, nm, pm, ef) __regexec (pr, st, nm, pm, ef) I # define regcomp(preg, pattern, cflags) __regcomp (preg, pattern, cflags) 7 # define regerror(errcode, preg, errbuf, errbuf_size) \ / 	__regerror(errcode, preg, errbuf, errbuf_size) / # define re_set_registers(bu, re, nu, st, en) \ ( 	__re_set_registers (bu, re, nu, st, en)L # define re_match_2(bufp, string1, size1, string2, size2, pos, regs, stop) \E 	__re_match_2 (bufp, string1, size1, string2, size2, pos, regs, stop) 2 # define re_match(bufp, string, size, pos, regs) \+ 	__re_match (bufp, string, size, pos, regs) ? # define re_search(bufp, string, size, startpos, range, regs) \ 8 	__re_search (bufp, string, size, startpos, range, regs)4 # define re_compile_pattern(pattern, length, bufp) \- 	__re_compile_pattern (pattern, length, bufp) 7 # define re_set_syntax(syntax) __re_set_syntax (syntax) K # define re_search_2(bufp, st1, s1, st2, s2, startpos, range, regs, stop) \ D 	__re_search_2 (bufp, st1, s1, st2, s2, startpos, range, regs, stop)= # define re_compile_fastmap(bufp) __re_compile_fastmap (bufp)    #define btowc __btowc  #endif  K /* This is for other GNU distributions with internationalized messages.  */ # #if HAVE_LIBINTL_H || defined _LIBC  # include <libintl.h>  #else  # define gettext(msgid) (msgid)  #endif   #ifndef gettext_noop> /* This define is so xgettext can find the internationalizable    strings.  */ $ # define gettext_noop(String) String #endif  8 /* The `emacs' switch turns on certain matching commands$    that make sense only in Emacs. */ #ifdef emacs   # include "lisp.h" # include "buffer.h" # include "syntax.h"   #else  /* not emacs */  + /* If we are not linking with Emacs proper, (    we can't use the relocating allocator)    even if config.h says that we can.  */  # undef REL_ALLOC   * # if defined STDC_HEADERS || defined _LIBC #  include <stdlib.h>  # else char *malloc (); char *realloc ();  # endif   H /* When used in Emacs's lib-src, we need to get bzero and bcopy somehow.;    If nothing else has been done, use the method below.  */  # ifdef INHIBIT_STRING_HEADER 1 #  if !(defined HAVE_BZERO && defined HAVE_BCOPY) ' #   if !defined bzero && !defined bcopy   #    undef INHIBIT_STRING_HEADER	 #   endif  #  endif # endif   E /* This is the normal way of making sure we have a bcopy and a bzero. A    This is used in most programs--a few other programs avoid this )    by defining INHIBIT_STRING_HEADER.  */  # ifndef INHIBIT_STRING_HEADERD #  if defined HAVE_STRING_H || defined STDC_HEADERS || defined _LIBC #   include <string.h> #   ifndef bzero #    ifndef _LIBC 3 #     define bzero(s, n)	(memset (s, '\0', n), (s)) 	 #    else ' #     define bzero(s, n)	__bzero (s, n) 
 #    endif	 #   endif  #  else  #   include <strings.h>  #   ifndef memcmp . #    define memcmp(s1, s2, n)	bcmp (s1, s2, n)	 #   endif  #   ifndef memcpy 2 #    define memcpy(d, s, n)	(bcopy (s, d, n), (d))	 #   endif  #  endif # endif   / /* Define the syntax stuff for \<, \>, etc.  */   @ /* This must be nonzero for the wordchar and notwordchar pattern    commands in re_match_2.  */ # ifndef Sword #  define Sword 1  # endif    # ifdef SWITCH_ENUM_BUG ( #  define SWITCH_ENUM_CAST(x) ((int)(x)) # else! #  define SWITCH_ENUM_CAST(x) (x)  # endif   0 /* How many characters in the character set.  */ # define CHAR_SET_SIZE 256   # ifdef SYNTAX_TABLE   extern char *re_syntax_table;    # else /* not SYNTAX_TABLE */   + static char re_syntax_table[CHAR_SET_SIZE];    static void  init_syntax_once ()  {     register int c;    static int done = 0;       if (done)      return;  3    bzero (re_syntax_table, sizeof re_syntax_table);       for (c = 'a'; c <= 'z'; c++)        re_syntax_table[c] = Sword;      for (c = 'A'; c <= 'Z'; c++)        re_syntax_table[c] = Sword;      for (c = '0'; c <= '9'; c++)        re_syntax_table[c] = Sword;       re_syntax_table['_'] = Sword;      done = 1; }    # endif /* not SYNTAX_TABLE */  % # define SYNTAX(c) re_syntax_table[c]    #endif /* not emacs */  4 /* Get the interface, including the syntax bits.  */ #include <regex.h>  7 /* isalpha etc. are used for the character classes.  */  #include <ctype.h>   /* Jim Meyering writes:   A    "... Some ctype macros are valid only for character codes that E    isascii says are ASCII (SGI's IRIX-4.0.5 is one such system --when D    using /bin/cc or gcc but without giving an ansi option).  So, all:    ctype uses should be through macros like ISPRINT...  IfE    STDC_HEADERS is defined, then autoconf has verified that the ctype B    macros don't need to be guarded with references to isascii. ...?    Defining isascii to 1 should let any compiler worth its salt .    eliminate the && through constant folding."L    Solaris defines some of these symbols so we must undefine them first.  */   #undef ISASCIIG #if defined STDC_HEADERS || (!defined isascii && !defined HAVE_ISASCII)  # define ISASCII(c) 1  #else  # define ISASCII(c) isascii(c) #endif   #ifdef isblank0 # define ISBLANK(c) (ISASCII (c) && isblank (c)) #else / # define ISBLANK(c) ((c) == ' ' || (c) == '\t')  #endif #ifdef isgraph0 # define ISGRAPH(c) (ISASCII (c) && isgraph (c)) #else @ # define ISGRAPH(c) (ISASCII (c) && isprint (c) && !isspace (c)) #endif   #undef ISPRINT/ #define ISPRINT(c) (ISASCII (c) && isprint (c)) / #define ISDIGIT(c) (ISASCII (c) && isdigit (c)) / #define ISALNUM(c) (ISASCII (c) && isalnum (c)) / #define ISALPHA(c) (ISASCII (c) && isalpha (c)) / #define ISCNTRL(c) (ISASCII (c) && iscntrl (c)) / #define ISLOWER(c) (ISASCII (c) && islower (c)) / #define ISPUNCT(c) (ISASCII (c) && ispunct (c)) / #define ISSPACE(c) (ISASCII (c) && isspace (c)) / #define ISUPPER(c) (ISASCII (c) && isupper (c)) 1 #define ISXDIGIT(c) (ISASCII (c) && isxdigit (c))    #ifdef _tolower  # define TOLOWER(c) _tolower(c)  #else  # define TOLOWER(c) tolower(c) #endif   #ifndef NULL # define NULL (void *)0  #endif  ; /* We remove any previous definition of `SIGN_EXTEND_CHAR', ?    since ours (we hope) works properly with all combinations of B    machines, compilers, `char' and `unsigned char' argument types.2    (Per Bothner suggested the basic approach.)  */ #undef SIGN_EXTEND_CHAR  #if __STDC__0 # define SIGN_EXTEND_CHAR(c) ((signed char) (c)) #else  /* not __STDC__ */ ! /* As in Harbison and Steele.  */ B # define SIGN_EXTEND_CHAR(c) ((((unsigned char) (c)) ^ 128) - 128) #endif  F /* Should we use malloc or alloca?  If REGEX_MALLOC is not defined, weE    use `alloca' instead of `malloc'.  This is because using malloc in G    re_search* or re_match* could cause memory leaks when C-g is used in F    Emacs; also, malloc is slower and causes storage fragmentation.  On@    the other hand, malloc is more portable, and easier to debug.  D    Because we sometimes use alloca, some routines have to be macros,I    not functions -- `alloca'-allocated space disappears at the end of the      function it is called in.  */   #ifndef HAVE_ALLOCA_H  # define REGEX_MALLOC  #endif   #ifdef REGEX_MALLOC    # define REGEX_ALLOCATE mallocG # define REGEX_REALLOCATE(source, osize, nsize) realloc (source, nsize)  # define REGEX_FREE free   #else /* not REGEX_MALLOC  */   / /* Emacs already defines alloca, sometimes.  */  # ifndef alloca   . /* Make alloca work the best possible way.  */ #  ifdef __GNUC__ " #   define alloca __builtin_alloca #  else /* not __GNUC__ */ #   if HAVE_ALLOCA_H #    include <alloca.h>  #   endif /* HAVE_ALLOCA_H */  #  endif /* not __GNUC__ */    # endif /* not alloca */   # define REGEX_ALLOCATE alloca  . /* Assumes a `char *destination' variable.  */4 # define REGEX_REALLOCATE(source, osize, nsize)				\.   (destination = (char *) alloca (nsize),				\'    memcpy (destination, source, osize))   4 /* No need to do anything to free, after alloca.  */O # define REGEX_FREE(arg) ((void)0) /* Do nothing!  But inhibit gcc warning.  */    #endif /* not REGEX_MALLOC */   0 /* Define how to allocate the failure stack.  */  - #if defined REL_ALLOC && defined REGEX_MALLOC   ( # define REGEX_ALLOCATE_STACK(size)				\&   r_alloc (&failure_stack_ptr, (size))8 # define REGEX_REALLOCATE_STACK(source, osize, nsize)		\*   r_re_alloc (&failure_stack_ptr, (nsize))$ # define REGEX_FREE_STACK(ptr)					\#   r_alloc_free (&failure_stack_ptr)   * #else /* not using relocating allocator */   # ifdef REGEX_MALLOC  % #  define REGEX_ALLOCATE_STACK malloc N #  define REGEX_REALLOCATE_STACK(source, osize, nsize) realloc (source, nsize) #  define REGEX_FREE_STACK free    # else /* not REGEX_MALLOC */   % #  define REGEX_ALLOCATE_STACK alloca   : #  define REGEX_REALLOCATE_STACK(source, osize, nsize)			\*    REGEX_REALLOCATE (source, osize, nsize)+ /* No need to explicitly free anything.  */  #  define REGEX_FREE_STACK(arg)    # endif /* not REGEX_MALLOC */+ #endif /* not using relocating allocator */     B /* True if `size1' is non-NULL and PTR is pointing anywhere insideG    `string1' or just past its end.  This works if PTR is NULL, which is     a good thing.  */" #define FIRST_STRING_P(ptr) 					\9   (size1 && string1 <= (ptr) && (ptr) <= string1 + size1)   < /* (Re)Allocate N items of type T using malloc, or fail.  */6 #define TALLOC(n, t) ((t *) malloc ((n) * sizeof (t)))N #define RETALLOC(addr, n, t) ((addr) = (t *) realloc (addr, (n) * sizeof (t)))! #define RETALLOC_IF(addr, n, t) \ C   if (addr) RETALLOC((addr), (n), t); else (addr) = TALLOC ((n), t) D #define REGEX_TALLOC(n, t) ((t *) REGEX_ALLOCATE ((n) * sizeof (t)))  # #define BYTEWIDTH 8 /* In bits.  */   . #define STREQ(s1, s2) ((strcmp (s1, s2) == 0))  
 #undef MAX
 #undef MIN) #define MAX(a, b) ((a) > (b) ? (a) : (b)) ) #define MIN(a, b) ((a) < (b) ? (a) : (b))    typedef char boolean;  #define false 0  #define true 1  G static int re_match_2_internal PARAMS ((struct re_pattern_buffer *bufp, $ 					const char *string1, int size1,$ 					const char *string2, int size2,
 					int pos,  					struct re_registers *regs,  					int stop));  > /* These are the command codes that appear in compiled regular@    expressions.  Some opcodes are followed by argument bytes.  AA    command code can specify any interpretation whatsoever for its L    arguments.  Zero bytes may appear in the compiled regular expression.  */   typedef enum {    no_op = 0,  2   /* Succeed right away--no more backtracking.  */
   succeed,  F         /* Followed by one byte giving n, then by n literal bytes.  */	   exactn,   4         /* Matches any (more or less) character.  */
   anychar,  B         /* Matches any one char belonging to specified set.  FirstE            following byte is number of bitmap bytes.  Then come bytes E            for a bitmap saying which chars are in.  Bits in each byte G            are ordered low-bit-first.  A character is in the set if its G            bit is 1.  A character too large to have a bit in the map is ,            automatically not in the set.  */
   charset,  F         /* Same parameters as charset, but match any character that is*            not one of those specified.  */   charset_not,  G         /* Start remembering the text that is matched, for storing in a G            register.  Followed by one byte with the register number, in D            the range 0 to one less than the pattern buffer's re_nsubF            field.  Then followed by one byte with the number of groups?            inner to this one.  (This last has to be part of the F            start_memory only because we need it in the on_failure_jump            of re_match_2.)  */   start_memory,   F         /* Stop remembering the text that is matched and store it in aC            memory register.  Followed by one byte with the register C            number, in the range 0 to one less than `re_nsub' in the H            pattern buffer, and one byte with the number of inner groups,B            just like `start_memory'.  (We need the number of innerH            groups here because we don't have any easy way of finding theG            corresponding start_memory when we're at a stop_memory.)  */    stop_memory,  E         /* Match a duplicate of something remembered. Followed by one 3            byte containing the register number.  */    duplicate,  0         /* Fail unless at beginning of line.  */
   begline,  *         /* Fail unless at end of line.  */
   endline,  H         /* Succeeds if at beginning of buffer (if emacs) or at beginning0            of string to be matched (if not).  */	   begbuf,   5         /* Analogously, for end of buffer/string.  */ 	   endbuf,   F         /* Followed by two byte relative address to which to jump.  */   jump,   : 	/* Same as jump, but marks the end of an alternative.  */   jump_past_alt,  F         /* Followed by two-byte relative address of place to resume at"            in case of failure.  */   on_failure_jump,  H         /* Like on_failure_jump, but pushes a placeholder instead of the5            current string position when executed.  */    on_failure_keep_string_jump,  E         /* Throw away latest failure point and then jump to following )            two-byte relative address.  */    pop_failure_jump,   H         /* Change to pop_failure_jump if know won't have to backtrack toA            match; otherwise change to jump.  This is used to jump H            back to the beginning of a repeat.  If what follows this jumpH            clearly won't match what the repeat does, such that we can beD            sure that there is no use backtracking out of repetitionsD            already matched, then we change it to a pop_failure_jump.,            Followed by two-byte address.  */   maybe_pop_jump,   G         /* Jump to following two-byte address, and push a dummy failure F            point. This failure point will be thrown away if an attemptG            is made to use it for a failure.  A `+' construct makes this F            before the first repeat.  Also used as an intermediary kind5            of jump when compiling an alternative.  */    dummy_failure_jump,   @ 	/* Push a dummy failure point and continue.  Used at the end of 	   alternatives.  */    push_dummy_failure,   G         /* Followed by two-byte relative address and two-byte number n.bH            After matching N times, jump to the address upon failure.  */   succeed_n,  H         /* Followed by two-byte relative address, and two-byte number n.6            Jump to the address N times, then fail.  */	   jump_n,   =         /* Set the following two-byte relative address to therF            subsequent two-byte number.  The address *includes* the two            bytes of number.  */i   set_number_at,  :   wordchar,	/* Matches any word-constituent character.  */F   notwordchar,	/* Matches any char that is not a word-constituent.  */  0   wordbeg,	/* Succeeds if at word beginning.  */*   wordend,	/* Succeeds if at word end.  */  3   wordbound,	/* Succeeds if at a word boundary.  */n9   notwordbound	/* Succeeds if not at a word boundary.  */e   #ifdef emacs/   ,before_dot,	/* Succeeds if before point.  */o&   at_dot,	/* Succeeds if at point.  */,   after_dot,	/* Succeeds if after point.  */  A 	/* Matches any character whose syntax is specified.  Followed by @            a byte which contains a syntax code, e.g., Sword.  */
   syntaxspec,/  A 	/* Matches any character whose syntax is not that specified.  */f   notsyntaxspecO #endif /* emacs */ } re_opcode_t; <1 /* Common operations on the compiled pattern.  */i  D /* Store NUMBER in two contiguous bytes starting at DESTINATION.  */  . #define STORE_NUMBER(destination, number)				\   do {									\-     (destination)[0] = (number) & 0377;					\*+     (destination)[1] = (number) >> 8;					\&
   } while (0)s  8 /* Same as STORE_NUMBER, except increment DESTINATION toE    the byte after where the number is stored.  Therefore, DESTINATIONh    must be an lvalue.  */C  6 #define STORE_NUMBER_AND_INCR(destination, number)			\   do {									\-     STORE_NUMBER (destination, number);					\a     (destination) += 2;							\ 
   } while (0)e  H /* Put into DESTINATION a number stored in two contiguous bytes starting    at SOURCE.  */l  0 #define EXTRACT_NUMBER(destination, source)				\   do {									\+     (destination) = *(source) & 0377;					\p@     (destination) += SIGN_EXTEND_CHAR (*((source) + 1)) << 8;		\
   } while (0)g   #ifdef DEBUGI static void extract_number _RE_ARGS ((int *dest, unsigned char *source));f static voidm extract_number (dest, source)e     int *dest;     unsigned char *source; {e.   int temp = SIGN_EXTEND_CHAR (*(source + 1));   *dest = *source & 0377;i   *dest += temp << 8;n }   3 # ifndef EXTRACT_MACROS /* To debug the macros.  */_ #  undef EXTRACT_NUMBERz? #  define EXTRACT_NUMBER(dest, src) extract_number (&dest, src)n  # endif /* not EXTRACT_MACROS */   #endif /* DEBUG */  G /* Same as EXTRACT_NUMBER, except increment SOURCE to after the number.p     SOURCE must be an lvalue.  */  8 #define EXTRACT_NUMBER_AND_INCR(destination, source)			\   do {									\.     EXTRACT_NUMBER (destination, source);				\     (source) += 2; 							\ 
   } while (0)a   #ifdef DEBUG@ static void extract_number_and_incr _RE_ARGS ((int *destination,% 					       unsigned char **source));  static voids- extract_number_and_incr (destination, source)(     int *destination;      unsigned char **source;  {e(   extract_number (destination, *source);   *source += 2;  }d   # ifndef EXTRACT_MACROSf  #  undef EXTRACT_NUMBER_AND_INCR. #  define EXTRACT_NUMBER_AND_INCR(dest, src) \'   extract_number_and_incr (&dest, &src)n  # endif /* not EXTRACT_MACROS */   #endif /* DEBUG */  H /* If DEBUG is defined, Regex prints many voluminous messages about whatH    it is doing (if the variable `debug' is nonzero).  If linked with theA    main program in `iregex.c', you can enter patterns and stringsmF    interactively.  And if linked with the main program in `main.c' andC    the other test files, you can run the already-written tests.  */m   #ifdef DEBUG  ) /* We use standard I/O for debugging.  */  # include <stdio.h>i  H /* It is useful to test things that ``must'' be true when debugging.  */ # include <assert.h>   static int debug = 0;    # define DEBUG_STATEMENT(e) eh. # define DEBUG_PRINT1(x) if (debug) printf (x)8 # define DEBUG_PRINT2(x1, x2) if (debug) printf (x1, x2)@ # define DEBUG_PRINT3(x1, x2, x3) if (debug) printf (x1, x2, x3)H # define DEBUG_PRINT4(x1, x2, x3, x4) if (debug) printf (x1, x2, x3, x4)4 # define DEBUG_PRINT_COMPILED_PATTERN(p, s, e) 				\2   if (debug) print_partial_compiled_pattern (s, e); # define DEBUG_PRINT_DOUBLE_STRING(w, s1, sz1, s2, sz2)			\ 6   if (debug) print_double_string (w, s1, sz1, s2, sz2)    0 /* Print the fastmap in human-readable form.  */   void print_fastmap (fastmap)*     char *fastmap; {R   unsigned was_a_range = 0;E   unsigned i = 0;d     while (i < (1 << BYTEWIDTH))     {d       if (fastmap[i++])b 	{ 	  was_a_range = 0;            putchar (i - 1);6           while (i < (1 << BYTEWIDTH)  &&  fastmap[i])
             {(               was_a_range = 1;               i++;
             }  	  if (was_a_range) 
             {p               printf ("-");                putchar (i - 1);
             }c	         }	     }(   putchar ('\n');  }i    F /* Print a compiled pattern string in human-readable form, starting atH    the START pointer into it and ending just before the pointer END.  */   void+ print_partial_compiled_pattern (start, end)w     unsigned char *start;      unsigned char *end;n {W   int mcnt, mcnt2;   unsigned char *p1;   unsigned char *p = start;    unsigned char *pend = end;     if (start == NULL)     {/       printf ("(null)\n");
       return;T     }E  $   /* Loop over pattern commands.  */   while (p < pend)     { "       printf ("%d:\t", p - start);  !       switch ((re_opcode_t) *p++)n 	{         case no_op:s           printf ("/no_op");           break;  
 	case exactn:; 	  mcnt = *p++;s&           printf ("/exactn/%d", mcnt);           do 	    {               putchar ('/'); 	      putchar (*p++);
             }<           while (--mcnt);x           break;   	case start_memory:<           mcnt = *p++;5           printf ("/start_memory/%d/%d", mcnt, *p++);r           break;   	case stop_memory:           mcnt = *p++;- 	  printf ("/stop_memory/%d/%d", mcnt, *p++);            break;   	case duplicate:" 	  printf ("/duplicate/%d", *p++);	 	  break;e   	case anychar: 	  printf ("/anychar");a	 	  break;s   	case charset:         case charset_not:n           { (             register int c, last = -100; 	    register int in_range = 0;c   	    printf ("/charset [%s",? 	            (re_opcode_t) *(p - 1) == charset_not ? "^" : "");u  #             assert (p + *p < pend);c  %             for (c = 0; c < 256; c++)S 	      if (c / 8 < *pE' 		  && (p[1 + (c/8)] & (1 << (c % 8))))i 		{a# 		  /* Are we starting a range?  */ $ 		  if (last + 1 == c && ! in_range) 		    {D 		      putchar ('-'); 		      in_range = 1;r 		    }l" 		  /* Have we broken a range?  */' 		  else if (last + 1 != c && in_range)f               {  		      putchar (last);s 		      in_range = 0;I 		    }i   		  if (! in_range)e 		    putchar (c);  
 		  last = c;I               }C   	    if (in_range) 	      putchar (last);   	    putchar (']');b   	    p += 1 + *p;K 	  }	 	  break;&   	case begline: 	  printf ("/begline");            break;   	case endline:           printf ("/endline");           break;   	case on_failure_jump:.           extract_number_and_incr (&mcnt, &p);9   	  printf ("/on_failure_jump to %d", p + mcnt - start);(           break;  " 	case on_failure_keep_string_jump:.           extract_number_and_incr (&mcnt, &p);E   	  printf ("/on_failure_keep_string_jump to %d", p + mcnt - start);a           break;   	case dummy_failure_jump:t.           extract_number_and_incr (&mcnt, &p);<   	  printf ("/dummy_failure_jump to %d", p + mcnt - start);           break;   	case push_dummy_failure: )           printf ("/push_dummy_failure");r           break;           case maybe_pop_jump:.           extract_number_and_incr (&mcnt, &p);8   	  printf ("/maybe_pop_jump to %d", p + mcnt - start);	 	  break;n           case pop_failure_jump:' 	  extract_number_and_incr (&mcnt, &p);i:   	  printf ("/pop_failure_jump to %d", p + mcnt - start);	 	  break;w           case jump_past_alt:c' 	  extract_number_and_incr (&mcnt, &p);a7   	  printf ("/jump_past_alt to %d", p + mcnt - start);p	 	  break;/           case jump:' 	  extract_number_and_incr (&mcnt, &p);C.   	  printf ("/jump to %d", p + mcnt - start);	 	  break;A           case succeed_n:*.           extract_number_and_incr (&mcnt, &p); 	  p1 = p + mcnt;2/           extract_number_and_incr (&mcnt2, &p);?< 	  printf ("/succeed_n to %d, %d times", p1 - start, mcnt2);           break;           case jump_n:.           extract_number_and_incr (&mcnt, &p); 	  p1 = p + mcnt;i/           extract_number_and_incr (&mcnt2, &p);c9 	  printf ("/jump_n to %d, %d times", p1 - start, mcnt2);            break;           case set_number_at:u.           extract_number_and_incr (&mcnt, &p); 	  p1 = p + mcnt;t/           extract_number_and_incr (&mcnt2, &p); B 	  printf ("/set_number_at location %d to %d", p1 - start, mcnt2);           break;           case wordbound:  	  printf ("/wordbound");e	 	  break;A   	case notwordbound:e 	  printf ("/notwordbound");           break;   	case wordbeg: 	  printf ("/wordbeg"); 	 	  break;n   	case wordend: 	  printf ("/wordend");f  
 # ifdef emacst 	case before_dot:f 	  printf ("/before_dot");           break;  
 	case at_dot:i 	  printf ("/at_dot");           break;   	case after_dot: 	  printf ("/after_dot");V           break;   	case syntaxspec: !           printf ("/syntaxspec");d 	  mcnt = *p++;_ 	  printf ("/%d", mcnt);           break;   	case notsyntaxspec:$           printf ("/notsyntaxspec"); 	  mcnt = *p++;i 	  printf ("/%d", mcnt);	 	  break;i # endif /* emacs */i   	case wordchar:a 	  printf ("/wordchar");           break;   	case notwordchar: 	  printf ("/notwordchar");a           break;  
 	case begbuf:E 	  printf ("/begbuf");           break;  
 	case endbuf:* 	  printf ("/endbuf");           break;           default:!           printf ("?%d", *(p-1));e 	}         putchar ('\n');G     }O  /   printf ("%d:\tend of pattern.\n", p - start);_ }o     void print_compiled_pattern (bufp)R#     struct re_pattern_buffer *bufp;n {e'   unsigned char *buffer = bufp->buffer;n  ?   print_partial_compiled_pattern (buffer, buffer + bufp->used);u2   printf ("%ld bytes used/%ld bytes allocated.\n",  	  bufp->used, bufp->allocated);  .   if (bufp->fastmap_accurate && bufp->fastmap)     {_       printf ("fastmap: ");e$       print_fastmap (bufp->fastmap);     }E  *   printf ("re_nsub: %d\t", bufp->re_nsub);4   printf ("regs_alloc: %d\t", bufp->regs_allocated);2   printf ("can_be_null: %d\t", bufp->can_be_null);8   printf ("newline_anchor: %d\n", bufp->newline_anchor);(   printf ("no_sub: %d\t", bufp->no_sub);*   printf ("not_bol: %d\t", bufp->not_bol);*   printf ("not_eol: %d\t", bufp->not_eol);)   printf ("syntax: %lx\n", bufp->syntax);e5   /* Perhaps we should print the translate table?  */` }i     void; print_double_string (where, string1, size1, string2, size2)g     const char *where;     const char *string1;     const char *string2;     int size1;     int size2; {    int this_char;     if (where == NULL)     printf ("(null)");   else     { !       if (FIRST_STRING_P (where)))	         {EK           for (this_char = where - string1; this_char < size1; this_char++) )             putchar (string1[this_char]);A             where = string2;	         }C  G       for (this_char = where - string2; this_char < size2; this_char++)(%         putchar (string2[this_char]);      }  }f   void
 printchar (c)c      int c;= {)   putc (c, stderr);f }N   #else /* not DEBUG */>   # undef assert # define assert(e)   # define DEBUG_STATEMENT(e)e # define DEBUG_PRINT1(x) # define DEBUG_PRINT2(x1, x2)t! # define DEBUG_PRINT3(x1, x2, x3) % # define DEBUG_PRINT4(x1, x2, x3, x4)	. # define DEBUG_PRINT_COMPILED_PATTERN(p, s, e)7 # define DEBUG_PRINT_DOUBLE_STRING(w, s1, sz1, s2, sz2)g   #endif /* not DEBUG */ )I /* Set by `re_set_syntax' to the current regexp syntax to recognize.  CaneF    also be assigned to arbitrarily: each pattern buffer stores its own?    syntax, so it can be changed between regex compilations.  */mA /* This has no initializer because initialized variables in Emacs/&    become read-only after dumping.  */ reg_syntax_t re_syntax_options;c    H /* Specify the precise syntax of regexps for compilation.  This providesB    for compatibility for various utilities which historically have$    different, incompatible syntaxes.  B    The argument SYNTAX is a bit mask comprised of the various bits5    defined in regex.h.  We return the old syntax.  */n   reg_syntax_t re_set_syntax (syntax)     reg_syntax_t syntax; {s'   reg_syntax_t ret = re_syntax_options;w     re_syntax_options = syntax;e #ifdef DEBUG   if (syntax & RE_DEBUG)     debug = 1;-   else if (debug) /* was on but now is not */m     debug = 0; #endif /* DEBUG */
   return ret;  }S #ifdef _LIBC+ weak_alias (__re_set_syntax, re_set_syntax)  #endif nG /* This table gives an error message for each of the error codes listedeA    in regex.h.  Obviously the order here has to be same as there.e=    POSIX doesn't require that we do anything for REG_NOERROR,     but why not be nice?  */a  % static const char *re_error_msgid[] =    {d/     gettext_noop ("Success"),	/* REG_NOERROR */r0     gettext_noop ("No match"),	/* REG_NOMATCH */A     gettext_noop ("Invalid regular expression"), /* REG_BADPAT */iD     gettext_noop ("Invalid collation character"), /* REG_ECOLLATE */C     gettext_noop ("Invalid character class name"), /* REG_ECTYPE */e:     gettext_noop ("Trailing backslash"), /* REG_EESCAPE */>     gettext_noop ("Invalid back reference"), /* REG_ESUBREG */8     gettext_noop ("Unmatched [ or [^"),	/* REG_EBRACK */9     gettext_noop ("Unmatched ( or \\("), /* REG_EPAREN */i4     gettext_noop ("Unmatched \\{"), /* REG_EBRACE */?     gettext_noop ("Invalid content of \\{\\}"), /* REG_BADBR */t8     gettext_noop ("Invalid range end"),	/* REG_ERANGE */7     gettext_noop ("Memory exhausted"), /* REG_ESPACE */dK     gettext_noop ("Invalid preceding regular expression"), /* REG_BADRPT */gH     gettext_noop ("Premature end of regular expression"), /* REG_EEND */@     gettext_noop ("Regular expression too big"), /* REG_ESIZE */:     gettext_noop ("Unmatched ) or \\)"), /* REG_ERPAREN */   }; e; /* Avoiding alloca during matching, to placate r_alloc.  */h  A /* Define MATCH_MAY_ALLOCATE unless we need to make sure that thefD    searching and matching functions should not call alloca.  On someB    systems, alloca is implemented in terms of malloc, and if we'reE    using the relocating allocator routines, then malloc could cause alD    relocation, which might (if the strings being searched are in the=    ralloc heap) shift the data out from underneath the regexpn    routines.  3    Here's another reason to avoid allocation: EmacsrE    processes input from X in a signal handler; processing X input may,D    call malloc; if input arrives while a matching routine is callingD    malloc, then we're scrod.  But Emacs can't just block input whileB    calling matching routines; then we don't notice interrupts when@    they come in.  So, Emacs blocks input around all regexp callsA    except the matching calls, which it leaves unprotected, in thef'    faith that they will not malloc.  */t   /* Normally, this is fine.  */ #define MATCH_MAY_ALLOCATE  D /* When using GNU C, we are not REALLY using the C alloca, no matter@    what config.h may say.  So don't take precautions for it.  */ #ifdef __GNUC__b # undef C_ALLOCA #endif  J /* The match routines may not allocate if (1) they would do it with malloc0    and (2) it's not safe for them to use malloc.K    Note that if REL_ALLOC is defined, matching would not use malloc for theAE    failure stack, but we would still use it for the register vectors;s+    so REL_ALLOC should not affect this.  */p? #if (defined C_ALLOCA || defined REGEX_MALLOC) && defined emacs/ # undef MATCH_MAY_ALLOCATE #endif   .E /* Failure stack declarations and macros; both re_compile_fastmap and F    re_match_2 use a failure stack.  These have to be macros because of    REGEX_ALLOCATE_STACK.  */    A /* Number of failure points for which to initially allocate space*?    when matching.  If this number is exceeded, we allocate more (    space, so it is not a hard limit.  */ #ifndef INIT_FAILURE_ALLOC # define INIT_FAILURE_ALLOC 5b #endif  G /* Roughly the maximum number of failure points on the stack.  Would beiK    exactly that if always used MAX_FAILURE_ITEMS items each time we failed.dG    This is a variable only so users of regex can assign to it; we nevera    change it ourselves.  */w   #ifdef INT_IS_16BIT    # if defined MATCH_MAY_ALLOCATEe3 /* 4400 was enough to cause a crash on Alpha OSF/1, (    whose default stack limit is 2mb.  */  long int re_max_failures = 4000; # else  long int re_max_failures = 2000; # endiff   union fail_stack_elt {u   unsigned char *pointer;o   long int integer;d };  . typedef union fail_stack_elt fail_stack_elt_t;   typedef struct {c   fail_stack_elt_t *stack;   unsigned long int size;b@   unsigned long int avail;		/* Offset of next open position.  */ } fail_stack_type;   #else /* not INT_IS_16BIT */   # if defined MATCH_MAY_ALLOCATEf3 /* 4400 was enough to cause a crash on Alpha OSF/1,;(    whose default stack limit is 2mb.  */ int re_max_failures = 20000; # else int re_max_failures = 2000;a # endifT   union fail_stack_elt {U   unsigned char *pointer;	   int integer; };  . typedef union fail_stack_elt fail_stack_elt_t;   typedef struct {=   fail_stack_elt_t *stack;   unsigned size;8   unsigned avail;			/* Offset of next open position.  */ } fail_stack_type;   #endif /* INT_IS_16BIT */o  6 #define FAIL_STACK_EMPTY()     (fail_stack.avail == 0); #define FAIL_STACK_PTR_EMPTY() (fail_stack_ptr->avail == 0)\D #define FAIL_STACK_FULL()      (fail_stack.avail == fail_stack.size)    : /* Define macros to initialize and free the failure stack.)    Do `return -2' if the alloc fails.  */    #ifdef MATCH_MAY_ALLOCATEX! # define INIT_FAIL_STACK()						\	   do {									\0     fail_stack.stack = (fail_stack_elt_t *)				\N       REGEX_ALLOCATE_STACK (INIT_FAILURE_ALLOC * sizeof (fail_stack_elt_t)); \
 									\'     if (fail_stack.stack == NULL)					\        return -2;							\
 									\.     fail_stack.size = INIT_FAILURE_ALLOC;				\      fail_stack.avail = 0;						\
   } while (0)   @ # define RESET_FAIL_STACK()  REGEX_FREE_STACK (fail_stack.stack) #else ! # define INIT_FAIL_STACK()						\f   do {									\      fail_stack.avail = 0;						\
   } while (0)E   # define RESET_FAIL_STACK()s #endif    N /* Double the size of FAIL_STACK, up to approximately `re_max_failures' items.  :    Return 1 if succeeds, and 0 if either ran out of memory7    allocating space for it or it was already too large.n  B    REGEX_REALLOCATE_STACK requires `destination' be declared.   */  + #define DOUBLE_FAIL_STACK(fail_stack)					\ I   ((fail_stack).size > (unsigned) (re_max_failures * MAX_FAILURE_ITEMS)	\x    ? 0									\4    : ((fail_stack).stack = (fail_stack_elt_t *)				\8         REGEX_REALLOCATE_STACK ((fail_stack).stack, 			\;           (fail_stack).size * sizeof (fail_stack_elt_t),		\cB           ((fail_stack).size << 1) * sizeof (fail_stack_elt_t)),	\
 									\&       (fail_stack).stack == NULL					\       ? 0								\(       : ((fail_stack).size <<= 1, 					\
          1)))x    & /* Push pointer POINTER on FAIL_STACK.F    Return 1 if was able to do so and 0 if ran out of memory allocating    space to do so.  */1 #define PUSH_PATTERN_OP(POINTER, FAIL_STACK)				\t   ((FAIL_STACK_FULL ()							\-     && !DOUBLE_FAIL_STACK (FAIL_STACK))					\x    ? 0									\C    : ((FAIL_STACK).stack[(FAIL_STACK).avail++].pointer = POINTER,	\n	       1))   / /* Push a pointer value onto the failure stack.t;    Assumes the variable `fail_stack'.  Probably should onlyt2    be called from within `PUSH_FAILURE_POINT'.  */( #define PUSH_FAILURE_POINTER(item)					\I   fail_stack.stack[fail_stack.avail++].pointer = (unsigned char *) (item)g  = /* This pushes an integer-valued item onto the failure stack.);    Assumes the variable `fail_stack'.  Probably should onlyu2    be called from within `PUSH_FAILURE_POINT'.  */$ #define PUSH_FAILURE_INT(item)					\7   fail_stack.stack[fail_stack.avail++].integer = (item)x  8 /* Push a fail_stack_elt_t value onto the failure stack.;    Assumes the variable `fail_stack'.  Probably should onlye2    be called from within `PUSH_FAILURE_POINT'.  */$ #define PUSH_FAILURE_ELT(item)					\0   fail_stack.stack[fail_stack.avail++] =  (item)  I /* These three POP... operations complement the three PUSH... operations.a0    All assume that `fail_stack' is nonempty.  */J #define POP_FAILURE_POINTER() fail_stack.stack[--fail_stack.avail].pointerF #define POP_FAILURE_INT() fail_stack.stack[--fail_stack.avail].integer> #define POP_FAILURE_ELT() fail_stack.stack[--fail_stack.avail]  H /* Used to omit pushing failure point id's when we're not debugging.  */ #ifdef DEBUG$ # define DEBUG_PUSH PUSH_FAILURE_INT? # define DEBUG_POP(item_addr) *(item_addr) = POP_FAILURE_INT ()  #elsea # define DEBUG_PUSH(item)t # define DEBUG_POP(item_addr)u #endif    4 /* Push the information about the state we will need    if we ever fail back to it.  A    Requires variables fail_stack, regstart, regend, reg_info, andiI    num_regs_pushed be declared.  DOUBLE_FAIL_STACK requires `destination'i    be declared.   8    Does `return FAILURE_CODE' if runs out of memory.  */  G #define PUSH_FAILURE_POINT(pattern_place, string_place, failure_code)	\    do {									\     char *destination;							\I     /* Must be int, so when we don't save any registers, the arithmetic	\(1        of 0 + -1 isn't done as unsigned.  */				\ I     /* Can't be int, since there is not a shred of a guarantee that int	\+I        is wide enough to hold a value of something to which pointer can	\         be assigned */							\h!     active_reg_t this_reg;						\      									\)     DEBUG_STATEMENT (failure_id++);					\<4     DEBUG_STATEMENT (nfailure_points_pushed++);				\@     DEBUG_PRINT2 ("\nPUSH_FAILURE_POINT #%u:\n", failure_id);		\J     DEBUG_PRINT2 ("  Before push, next avail: %d\n", (fail_stack).avail);\I     DEBUG_PRINT2 ("                     size: %d\n", (fail_stack).size);\b
 									\A     DEBUG_PRINT2 ("  slots needed: %ld\n", NUM_FAILURE_ITEMS);		\:C     DEBUG_PRINT2 ("     available: %d\n", REMAINING_AVAIL_SLOTS);	\c
 									\I     /* Ensure we have enough space allocated for what we will push.  */	\ 9     while (REMAINING_AVAIL_SLOTS < NUM_FAILURE_ITEMS)			\        {									\t1         if (!DOUBLE_FAIL_STACK (fail_stack))				\5%           return failure_code;						\&
 									\=         DEBUG_PRINT2 ("\n  Doubled stack; size now: %d\n",		\*! 		       (fail_stack).size);				\aI         DEBUG_PRINT2 ("  slots available: %d\n", REMAINING_AVAIL_SLOTS);\	       }									\ 
 									\:     /* Push the info, starting with the registers.  */			\     DEBUG_PRINT1 ("\n");						\ 
 									\     if (1)								\ J       for (this_reg = lowest_active_reg; this_reg <= highest_active_reg; \ 	   this_reg++)							\  	{								\t6 	  DEBUG_PRINT2 ("  Pushing reg: %lu\n", this_reg);		\, 	  DEBUG_STATEMENT (num_regs_pushed++);				\
 									\; 	  DEBUG_PRINT2 ("    start: %p\n", regstart[this_reg]);		\"1 	  PUSH_FAILURE_POINTER (regstart[this_reg]);			\ 
 									\7 	  DEBUG_PRINT2 ("    end: %p\n", regend[this_reg]);		\_/ 	  PUSH_FAILURE_POINTER (regend[this_reg]);			\;
 									\- 	  DEBUG_PRINT2 ("    info: %p\n      ",				\u' 			reg_info[this_reg].word.pointer);		\"' 	  DEBUG_PRINT2 (" match_null=%d",				\m3 			REG_MATCH_NULL_STRING_P (reg_info[this_reg]));	\rA 	  DEBUG_PRINT2 (" active=%d", IS_ACTIVE (reg_info[this_reg]));	\t- 	  DEBUG_PRINT2 (" matched_something=%d",			\t- 			MATCHED_SOMETHING (reg_info[this_reg]));	\e) 	  DEBUG_PRINT2 (" ever_matched=%d",				\)2 			EVER_MATCHED_SOMETHING (reg_info[this_reg]));	\ 	  DEBUG_PRINT1 ("\n");						\2 	  PUSH_FAILURE_ELT (reg_info[this_reg].word);			\ 	}								\-
 									\J     DEBUG_PRINT2 ("  Pushing  low active reg: %ld\n", lowest_active_reg);\.     PUSH_FAILURE_INT (lowest_active_reg);				\
 									\K     DEBUG_PRINT2 ("  Pushing high active reg: %ld\n", highest_active_reg);\n/     PUSH_FAILURE_INT (highest_active_reg);				\ 
 									\?     DEBUG_PRINT2 ("  Pushing pattern %p:\n", pattern_place);		\_@     DEBUG_PRINT_COMPILED_PATTERN (bufp, pattern_place, pend);		\.     PUSH_FAILURE_POINTER (pattern_place);				\
 									\=     DEBUG_PRINT2 ("  Pushing string %p: `", string_place);		\ I     DEBUG_PRINT_DOUBLE_STRING (string_place, string1, size1, string2,   \m 				 size2);				\n      DEBUG_PRINT1 ("'\n");						\-     PUSH_FAILURE_POINTER (string_place);				\ 
 									\?     DEBUG_PRINT2 ("  Pushing failure id: %u\n", failure_id);		\&#     DEBUG_PUSH (failure_id);						\i
   } while (0)t  F /* This is the number of items that are pushed and popped on the stack    for each register.  */t #define NUM_REG_ITEMS  3  1 /* Individual items aside from the registers.  */  #ifdef DEBUG= # define NUM_NONREG_ITEMS 5 /* Includes failure point id.  */r #else  # define NUM_NONREG_ITEMS 4p #endif  4 /* We push at most this many items on the stack.  */B /* We used to use (num_regs - 1), which is the number of registers3    this regexp will save; but that was changed to 5p@    to avoid stack overflow for a regexp with lots of parens.  */@ #define MAX_FAILURE_ITEMS (5 * NUM_REG_ITEMS + NUM_NONREG_ITEMS)  ( /* We actually push this many items.  */ #define NUM_FAILURE_ITEMS				\   (((0							\8      ? 0 : highest_active_reg - lowest_active_reg + 1)	\     * NUM_REG_ITEMS)					\    + NUM_NONREG_ITEMS)  M /* How many items can still be added to the stack without overflowing it.  */ F #define REMAINING_AVAIL_SLOTS ((fail_stack).size - (fail_stack).avail)    $ /* Pops what PUSH_FAIL_STACK pushes.  B    We restore into the parameters, all of which should be lvalues:$      STR -- the saved data position.'      PAT -- the saved pattern position.rB      LOW_REG, HIGH_REG -- the highest and lowest active registers.4      REGSTART, REGEND -- arrays of string positions.?      REG_INFO -- array of information about each subexpression.t  F    Also assumes the variables `fail_stack' and (if debugging), `bufp',:    `pend', `string1', `size1', `string2', and `size2'.  */  S #define POP_FAILURE_POINT(str, pat, low_reg, high_reg, regstart, regend, reg_info)\  {									\d-   DEBUG_STATEMENT (unsigned failure_id;)				\u   active_reg_t this_reg;						\u)   const unsigned char *string_temp;					\ 
 									\&   assert (!FAIL_STACK_EMPTY ());					\
 									\C   /* Remove failure points and point to how many regs pushed.  */	\f-   DEBUG_PRINT1 ("POP_FAILURE_POINT:\n");				\ F   DEBUG_PRINT2 ("  Before pop, next avail: %d\n", fail_stack.avail);	\E   DEBUG_PRINT2 ("                    size: %d\n", fail_stack.size);	\s
 									\4   assert (fail_stack.avail >= NUM_NONREG_ITEMS);			\
 									\!   DEBUG_POP (&failure_id);						\%=   DEBUG_PRINT2 ("  Popping failure id: %u\n", failure_id);		\a
 									\=   /* If the saved string location is NULL, it came from an		\tH      on_failure_keep_string_jump opcode, and we want to throw away the	\I      saved NULL, thus retaining our current position in the string.  */	\ -   string_temp = POP_FAILURE_POINTER ();					\l!   if (string_temp != NULL)						\P+     str = (const char *) string_temp;					\h
 									\4   DEBUG_PRINT2 ("  Popping string %p: `", str);				\D   DEBUG_PRINT_DOUBLE_STRING (str, string1, size1, string2, size2);	\   DEBUG_PRINT1 ("'\n");							\e
 									\5   pat = (unsigned char *) POP_FAILURE_POINTER ();			\r4   DEBUG_PRINT2 ("  Popping pattern %p:\n", pat);			\5   DEBUG_PRINT_COMPILED_PATTERN (bufp, pat, pend);			\*
 									\&   /* Restore register info.  */						\4   high_reg = (active_reg_t) POP_FAILURE_INT ();				\A   DEBUG_PRINT2 ("  Popping high active reg: %ld\n", high_reg);		\ 
 									\3   low_reg = (active_reg_t) POP_FAILURE_INT ();				\T@   DEBUG_PRINT2 ("  Popping  low active reg: %ld\n", low_reg);		\
 									\   if (1)								\ A     for (this_reg = high_reg; this_reg >= low_reg; this_reg--)		\y       {									\ 6 	DEBUG_PRINT2 ("    Popping reg: %ld\n", this_reg);		\
 									\2 	reg_info[this_reg].word = POP_FAILURE_ELT ();			\' 	DEBUG_PRINT2 ("      info: %p\n",				\i- 		      reg_info[this_reg].word.pointer);			\/
 									\< 	regend[this_reg] = (const char *) POP_FAILURE_POINTER ();	\7 	DEBUG_PRINT2 ("      end: %p\n", regend[this_reg]);		\a
 									\> 	regstart[this_reg] = (const char *) POP_FAILURE_POINTER ();	\; 	DEBUG_PRINT2 ("      start: %p\n", regstart[this_reg]);		\a       }									\    else									\     {									\iL       for (this_reg = highest_active_reg; this_reg > high_reg; this_reg--) \ 	{								\s, 	  reg_info[this_reg].word.integer = 0;				\ 	  regend[this_reg] = 0;						\   	  regstart[this_reg] = 0;					\ 	}								\ *       highest_active_reg = high_reg;					\     }									\*
 									\#   set_regs_matched_done = 0;						\f2   DEBUG_STATEMENT (nfailure_points_popped++);				\ } /* POP_FAILURE_POINT */_     t= /* Structure for per-register (a.k.a. per-group) information. *    Other register information, such as theG    starting and ending positions (which are addresses), and the list ofiA    inner groups (which is a bits list) are maintained in separate*
    variables.n  H    We are making a (strictly speaking) nonportable assumption here: thatF    the compiler will pack our bit fields into something that fits intoH    the type of `word', i.e., is something that fits into one item on the    failure stack.  */a    . /* Declarations and macros for re_match_2.  */  
 typedef unions {m   fail_stack_elt_t word;   struct   {(D       /* This field is one if this group can match the empty string,L          zero if not.  If not yet determined,  `MATCH_NULL_UNSET_VALUE'.  */  #define MATCH_NULL_UNSET_VALUE 3%     unsigned match_null_string_p : 2;i     unsigned is_active : 1;d#     unsigned matched_something : 1;_(     unsigned ever_matched_something : 1;	   } bits;  } register_info_type;l  B #define REG_MATCH_NULL_STRING_P(R)  ((R).bits.match_null_string_p)* #define IS_ACTIVE(R)  ((R).bits.is_active): #define MATCHED_SOMETHING(R)  ((R).bits.matched_something)D #define EVER_MATCHED_SOMETHING(R)  ((R).bits.ever_matched_something)    H /* Call this when have matched a real character; it sets `matched' flagsF    for the subexpressions which we are currently inside.  Also records(    that those subexprs have matched.  */! #define SET_REGS_MATCHED()						\E   do									\     {									\ '       if (!set_regs_matched_done)					\  	{								\l 	  active_reg_t r;						\e# 	  set_regs_matched_done = 1;					\ > 	  for (r = lowest_active_reg; r <= highest_active_reg; r++)	\ 	    {								\l+ 	      MATCHED_SOMETHING (reg_info[r])				\e, 		= EVER_MATCHED_SOMETHING (reg_info[r])			\ 		= 1;							\ 	    }								\e 	}								\g     }									\.   while (0)   E /* Registers are set to a sentinel when they haven't yet matched.  */a static char reg_unset_dummy;* #define REG_UNSET_VALUE (&reg_unset_dummy)- #define REG_UNSET(e) ((e) == REG_UNSET_VALUE), e< /* Subroutine declarations and macros for regex_compile.  */  O static reg_errcode_t regex_compile _RE_ARGS ((const char *pattern, size_t size,  					      reg_syntax_t syntax,e, 					      struct re_pattern_buffer *bufp));O static void store_op1 _RE_ARGS ((re_opcode_t op, unsigned char *loc, int arg));rD static void store_op2 _RE_ARGS ((re_opcode_t op, unsigned char *loc, 				 int arg1, int arg2));E static void insert_op1 _RE_ARGS ((re_opcode_t op, unsigned char *loc,e$ 				  int arg, unsigned char *end));E static void insert_op2 _RE_ARGS ((re_opcode_t op, unsigned char *loc, / 				  int arg1, int arg2, unsigned char *end)); N static boolean at_begline_loc_p _RE_ARGS ((const char *pattern, const char *p, 					   reg_syntax_t syntax));K static boolean at_endline_loc_p _RE_ARGS ((const char *p, const char *pend,  					   reg_syntax_t syntax));A static reg_errcode_t compile_range _RE_ARGS ((const char **p_ptr,m 					      const char *pend, 					      char *translate,s 					      reg_syntax_t syntax,h 					      unsigned char *b));  F /* Fetch the next character in the uncompiled pattern---translating itC    if necessary.  Also cast from a signed character in the constantiF    string passed to us by the user to an unsigned char that we can use1    as an array index (in, e.g., `translate').  */i #ifndef PATFETCH # define PATFETCH(c)							\+   do {if (p == pend) return REG_EEND;					\m$     c = (unsigned char) *p++;						\8     if (translate) c = (unsigned char) translate[c];			\
   } while (0)s #endif  > /* Fetch the next character in the uncompiled pattern, with no    translation.  */a #define PATFETCH_RAW(c)							\ +   do {if (p == pend) return REG_EEND;					\Y%     c = (unsigned char) *p++; 						\ 
   } while (0)a  1 /* Go backwards one character in the pattern.  */o #define PATUNFETCH p--    D /* If `translate' is non-null, return translate[D], else just D.  WeC    cast the subscript to translate because some data is declared as E    `char *', to avoid warnings when a string constant is passed.  But G    when we use a character as a subscript we must make it unsigned.  */  #ifndef TRANSLATEf # define TRANSLATE(d) \ ;   (translate ? (char) translate[(unsigned char) (d)] : (d))f #endif    @ /* Macros for outputting the compiled pattern into `buffer'.  */  @ /* If the buffer isn't allocated when it comes in, use this.  */ #define INIT_BUF_SIZE  32i  B /* Make sure we have at least N more bytes of space in buffer.  */" #define GET_BUFFER_SPACE(n)						\H     while ((unsigned long) (b - bufp->buffer + (n)) > bufp->allocated)	\       EXTEND_BUFFER ()  L /* Make sure we have one more byte of buffer space and then add C to it.  */ #define BUF_PUSH(c)							\_   do {									\      GET_BUFFER_SPACE (1);						\&     *b++ = (unsigned char) (c);						\
   } while (0)l    O /* Ensure we have two more bytes of buffer space and then append C1 and C2.  */a! #define BUF_PUSH_2(c1, c2)						\n   do {									\      GET_BUFFER_SPACE (2);						\&     *b++ = (unsigned char) (c1);					\&     *b++ = (unsigned char) (c2);					\
   } while (0)     2 /* As with BUF_PUSH_2, except for three bytes.  */% #define BUF_PUSH_3(c1, c2, c3)						\(   do {									\      GET_BUFFER_SPACE (3);						\&     *b++ = (unsigned char) (c1);					\&     *b++ = (unsigned char) (c2);					\&     *b++ = (unsigned char) (c3);					\
   } while (0)	    A /* Store a jump with opcode OP at LOC to location TO.  We store aFK    relative address offset by the three bytes the jump itself occupies.  */S! #define STORE_JUMP(op, loc, to) \ /   store_op1 (op, loc, (int) ((to) - (loc) - 3))   ) /* Likewise, for a two-argument jump.  */D' #define STORE_JUMP2(op, loc, to, arg) \x4   store_op2 (op, loc, (int) ((to) - (loc) - 3), arg)  K /* Like `STORE_JUMP', but for inserting.  Assume `b' is the buffer end.  */a" #define INSERT_JUMP(op, loc, to) \3   insert_op1 (op, loc, (int) ((to) - (loc) - 3), b)   L /* Like `STORE_JUMP2', but for inserting.  Assume `b' is the buffer end.  */( #define INSERT_JUMP2(op, loc, to, arg) \8   insert_op2 (op, loc, (int) ((to) - (loc) - 3), arg, b)    H /* This is not an arbitrary limit: the arguments which represent offsetsF    into the pattern are two bytes long.  So if 2^16 bytes turns out to6    be too small, many things would have to change.  */F /* Any other compiler which, like MSC, has allocation limit below 2^16E    bytes will have to use approach similar to what was done below forn=    MSC and drop MAX_BUF_SIZE a bit.  Otherwise you may end updF    reallocating to 0 bytes.  Such thing is not going to work too well.    You have been warned!!  */)' #if defined _MSC_VER  && !defined WIN32 B /* Microsoft C 16-bit versions limit malloc to approx 65512 bytes.A    The REALLOC define eliminates a flurry of conversion warnings,     but is not required. */ # define MAX_BUF_SIZE  65500Lt1 # define REALLOC(p,s) realloc ((p), (size_t) (s))h #elsel  # define MAX_BUF_SIZE (1L << 16)( # define REALLOC(p,s) realloc ((p), (s)) #endif  > /* Extend the buffer by twice its current size via realloc andE    reset the pointers that pointed into the old block to point to theeH    correct places in the new one.  If extending the buffer results in itB    being larger than MAX_BUF_SIZE, then flag memory exhausted.  */ #define EXTEND_BUFFER()							\l   do { 									\t2     unsigned char *old_buffer = bufp->buffer;				\.     if (bufp->allocated == MAX_BUF_SIZE) 				\       return REG_ESIZE;							\o!     bufp->allocated <<= 1;						\o-     if (bufp->allocated > MAX_BUF_SIZE)					\H,       bufp->allocated = MAX_BUF_SIZE; 					\N     bufp->buffer = (unsigned char *) REALLOC (bufp->buffer, bufp->allocated);\$     if (bufp->buffer == NULL)						\       return REG_ESPACE;						\.A     /* If the buffer moved, move all the pointers into it.  */		\v)     if (old_buffer != bufp->buffer)					\l       {									\_1         b = (b - old_buffer) + bufp->buffer;				\l:         begalt = (begalt - old_buffer) + bufp->buffer;			\"         if (fixup_alt_jump)						\I           fixup_alt_jump = (fixup_alt_jump - old_buffer) + bufp->buffer;\D         if (laststart)							\A           laststart = (laststart - old_buffer) + bufp->buffer;		\e!         if (pending_exact)						\ H           pending_exact = (pending_exact - old_buffer) + bufp->buffer;	\       }									\q
   } while (0)     F /* Since we have one byte reserved for the register number argument toB    {start,stop}_memory, the maximum number of groups we can report.    things about is what fits in that byte.  */ #define MAX_REGNUM 255  C /* But patterns can have more than `MAX_REGNUM' registers.  We just	    ignore the excess.  */; typedef unsigned regnum_t;    $ /* Macros for the compile stack.  */  H /* Since offsets can go either forwards or backwards, this type needs toK    be able to hold values from -(MAX_BUF_SIZE - 1) to MAX_BUF_SIZE - 1.  */ 3 /* int may be not enough when sizeof(int) == 2.  */n typedef long pattern_offset_t;   typedef struct {e!   pattern_offset_t begalt_offset;	"   pattern_offset_t fixup_alt_jump;&   pattern_offset_t inner_group_offset;$   pattern_offset_t laststart_offset;   regnum_t regnum; } compile_stack_elt_t;     typedef struct {R   compile_stack_elt_t *stack;l   unsigned size;8   unsigned avail;			/* Offset of next open position.  */ } compile_stack_type;i    " #define INIT_COMPILE_STACK_SIZE 32  7 #define COMPILE_STACK_EMPTY  (compile_stack.avail == 0)RG #define COMPILE_STACK_FULL  (compile_stack.avail == compile_stack.size)   " /* The next available element.  */D #define COMPILE_STACK_TOP (compile_stack.stack[compile_stack.avail])    - /* Set the bit for character C in a list.  */ 7 #define SET_LIST_BIT(c)                               \u7   (b[((unsigned char) (c)) / BYTEWIDTH]               \2-    |= 1 << (((unsigned char) c) % BYTEWIDTH))     > /* Get the next unsigned number in the uncompiled pattern.  */' #define GET_UNSIGNED_NUMBER(num) 					\    { if (p != pend)							\      {									\        PATFETCH (c); 							\r"        while (ISDIGIT (c)) 						\          { 								\            if (num < 0)							\t               num = 0;							\+            num = num * 10 + c - '0'; 					\+!            if (p == pend) 						\P               break; 							\t            PATFETCH (c);						\(          } 								\        } 								\     }I  & #if defined _LIBC || WIDE_CHAR_SUPPORTH /* The GNU C library provides support for user-defined character classes1    and the functions from ISO C amendement 1.  */	 # ifdef CHARCLASS_NAME_MAX2 #  define CHAR_CLASS_MAX_LENGTH CHARCLASS_NAME_MAX # elseF /* This shouldn't happen but some implementation might still have this0    problem.  Use a reasonable default value.  */# #  define CHAR_CLASS_MAX_LENGTH 256	 # endifB  
 # ifdef _LIBCv1 #  define IS_CHAR_CLASS(string) __wctype (string)G # else/ #  define IS_CHAR_CLASS(string) wctype (string)I # endifn #else_: # define CHAR_CLASS_MAX_LENGTH  6 /* Namely, `xdigit'.  */  % # define IS_CHAR_CLASS(string)						\):    (STREQ (string, "alpha") || STREQ (string, "upper")			\<     || STREQ (string, "lower") || STREQ (string, "digit")		\=     || STREQ (string, "alnum") || STREQ (string, "xdigit")		\e<     || STREQ (string, "space") || STREQ (string, "print")		\<     || STREQ (string, "punct") || STREQ (string, "graph")		\:     || STREQ (string, "cntrl") || STREQ (string, "blank")) #endif 	 #ifndef MATCH_MAY_ALLOCATE  B /* If we cannot allocate large objects within re_match_2_internal,6    we make the fail stack and register vectors global.<    The fail stack, we grow to the maximum size when a regexp    is compiled.r7    The register vectors, we adjust in size each time weRG    compile a regexp, according to the number of registers it needs.  */   " static fail_stack_type fail_stack;  A /* Size with which the following vectors are currently allocated.(0    That is so we can make them bigger as needed,#    but never make them smaller.  */  static int regs_allocated_size;m  1 static const char **     regstart, **     regend; 1 static const char ** old_regstart, ** old_regend;31 static const char **best_regstart, **best_regend;*$ static register_info_type *reg_info; static const char **reg_dummy;* static register_info_type *reg_info_dummy;  ? /* Make the register vectors big enough for NUM_REGS registers,/#    but don't make them smaller.  */h   static regex_grow_registers (num_regs)e      int num_regs; {w%   if (num_regs > regs_allocated_size)r     {r6       RETALLOC_IF (regstart,	 num_regs, const char *);4       RETALLOC_IF (regend,	 num_regs, const char *);9       RETALLOC_IF (old_regstart, num_regs, const char *);M8       RETALLOC_IF (old_regend,	 num_regs, const char *);:       RETALLOC_IF (best_regstart, num_regs, const char *);9       RETALLOC_IF (best_regend,	 num_regs, const char *);h<       RETALLOC_IF (reg_info,	 num_regs, register_info_type);7       RETALLOC_IF (reg_dummy,	 num_regs, const char *);pA       RETALLOC_IF (reg_info_dummy, num_regs, register_info_type);,  %       regs_allocated_size = num_regs;R     }  }e  # #endif /* not MATCH_MAY_ALLOCATE */  tC static boolean group_in_compile_stack _RE_ARGS ((compile_stack_typev 						 compile_stack,T 						 regnum_t regnum));r  I /* `regex_compile' compiles PATTERN (of length SIZE) according to SYNTAX.nH    Returns one of error codes defined in `regex.h', or zero for success.  A    Assumes the `allocated' (and perhaps `buffer') and `translate'f#    fields are set in BUFP on entry.e  G    If it succeeds, results are put in BUFP (if it returns an error, the #    contents of BUFP are undefined):e&      `buffer' is the compiled pattern;      `syntax' is set to SYNTAX;	9      `used' is set to the length of the compiled pattern;        `fastmap_accurate' is zero;:      `re_nsub' is the number of subexpressions in PATTERN;&      `not_bol' and `not_eol' are zero;  8    The `fastmap' and `newline_anchor' fields are neither    examined nor set.  */  , /* Return, freeing storage we allocated.  */# #define FREE_STACK_RETURN(value)		\U,   return (free (compile_stack.stack), value)   static reg_errcode_t+ regex_compile (pattern, size, syntax, bufp)       const char *pattern;\      size_t size;       reg_syntax_t syntax; $      struct re_pattern_buffer *bufp; {rC   /* We fetch characters from PATTERN here.  Even though PATTERN isuH      `char *' (i.e., signed), we declare these variables as unsigned, so4      they can be reliably used as array indices.  */   register unsigned char c, c1;   ,   /* A random temporary spot in PATTERN.  */   const char *p1;n  A   /* Points to the end of the buffer, where we should append.  */1   register unsigned char *b;  (   /* Keeps track of unclosed groups.  */#   compile_stack_type compile_stack;E  @   /* Points to the current (ending) position in the pattern.  */   const char *p = pattern;$   const char *pend = pattern + size;  8   /* How to translate the characters in the pattern.  */0   RE_TRANSLATE_TYPE translate = bufp->translate;  E   /* Address of the count-byte of the most recently inserted `exactn' B      command.  This makes it possible to tell if a new exact-matchH      character can be added to that command or if the character requires       a new `exactn' command.  */#   unsigned char *pending_exact = 0;   ?   /* Address of start of the most recently finished expression.	?      This tells, e.g., postfix * where to find the start of its\E      operand.  Reset at the beginning of groups and alternatives.  */w   unsigned char *laststart = 0;r  A   /* Address of beginning of regexp, or inside of last group.  */I   unsigned char *begalt;  5   /* Place in the uncompiled pattern (i.e., the {) toc5      which to go back if the interval is invalid.  */"   const char *beg_interval;t  F   /* Address of the place where a forward jump should go to the end ofJ      the containing expression.  Each alternative of an `or' -- except the7      last -- ends with a forward jump of this sort.  */\$   unsigned char *fixup_alt_jump = 0;  D   /* Counts open-groups as they are encountered.  Remembered for theD      matching close-group on the compile stack, so the same register>      number is put in the stop_memory as the start_memory.  */   regnum_t regnum = 0;   #ifdef DEBUG)   DEBUG_PRINT1 ("\nCompiling pattern: ");r   if (debug)     {        unsigned debug_count;s  >       for (debug_count = 0; debug_count < size; debug_count++)'         putchar (pattern[debug_count]);h       putchar ('\n');i     }  #endif /* DEBUG */  &   /* Initialize the compile stack.  */N   compile_stack.stack = TALLOC (INIT_COMPILE_STACK_SIZE, compile_stack_elt_t);"   if (compile_stack.stack == NULL)     return REG_ESPACE;  /   compile_stack.size = INIT_COMPILE_STACK_SIZE;    compile_stack.avail = 0;  '   /* Initialize the pattern buffer.  *//   bufp->syntax = syntax;   bufp->fastmap_accurate = 0;t$   bufp->not_bol = bufp->not_eol = 0;  C   /* Set `used' to zero, so that if we return an error, the patterneH      printer (for debugging) will think there's no pattern.  We reset it      at the end.  */   bufp->used = 0;2  A   /* Always count groups, whether or not bufp->no_sub is set.  */_   bufp->re_nsub = 0;  + #if !defined emacs && !defined SYNTAX_TABLEf%   /* Initialize the syntax table.  */N    init_syntax_once ();u #endif     if (bufp->allocated == 0))     {s       if (bufp->buffer)_? 	{ /* If zero allocated, but buffer is non-null, try to reallocSH              enough space.  This loses if buffer's address is bogus, but3              that is the user's responsibility.  */ @           RETALLOC (bufp->buffer, INIT_BUF_SIZE, unsigned char);	         } 
       elseC         { /* Caller did not allocate a buffer.  Do it for them.  */	?           bufp->buffer = TALLOC (INIT_BUF_SIZE, unsigned char);{	         } 8       if (!bufp->buffer) FREE_STACK_RETURN (REG_ESPACE);  &       bufp->allocated = INIT_BUF_SIZE;     }s     begalt = b = bufp->buffer;  D   /* Loop through the uncompiled pattern until we're at the end.  */   while (p != pend))     {	       PATFETCH (c);	         switch (c)	         {	         case '^':0           {sC             if (   /* If at start of pattern, it's an operator.  */c#                    p == pattern + 1NC                    /* If context independent, it's an operator.  */V4                 || syntax & RE_CONTEXT_INDEP_ANCHORSC                    /* Otherwise, depends on what's come before.  */o9                 || at_begline_loc_p (pattern, p, syntax))y!               BUF_PUSH (begline);n             else               goto normal_char;r           },           break;             case '$':v           { A             if (   /* If at end of pattern, it's an operator.  */a                    p == pendC                    /* If context independent, it's an operator.  */g4                 || syntax & RE_CONTEXT_INDEP_ANCHORS<                    /* Otherwise, depends on what's next.  */6                 || at_endline_loc_p (p, pend, syntax))"                BUF_PUSH (endline);              else                  goto normal_char;            }            break;c    
 	case '+':         case '?':	&           if ((syntax & RE_BK_PLUS_QM)+               || (syntax & RE_LIMITED_OPS))r             goto normal_char;a         handle_plus:         case '*':	2           /* If there is no previous pattern... */           if (!laststart)n
             {n2               if (syntax & RE_CONTEXT_INVALID_OPS)/                 FREE_STACK_RETURN (REG_BADRPT);c8               else if (!(syntax & RE_CONTEXT_INDEP_OPS))!                 goto normal_char;r
             }.             {)/             /* Are we optimizing this jump?  */	*             boolean keep_string_p = false;  :             /* 1 means zero (many) matches is allowed.  */6             char zero_times_ok = 0, many_times_ok = 0;  F             /* If there is a sequence of repetition chars, collapse itB                down to just one (the right one).  We can't combineG                interval operators with these because of, e.g., `a{2}*', B                which should only match an even number of `a's.  */               for (;;)               {a*                 zero_times_ok |= c != '+';*                 many_times_ok |= c != '?';                   if (p == pend)                   break;                   PATFETCH (c);n                   if (c == '*'M                     || (!(syntax & RE_BK_PLUS_QM) && (c == '+' || c == '?')))f                   ;d  ?                 else if (syntax & RE_BK_PLUS_QM  &&  c == '\\')                    { C                     if (p == pend) FREE_STACK_RETURN (REG_EESCAPE);u  "                     PATFETCH (c1);2                     if (!(c1 == '+' || c1 == '?'))                       { #                         PATUNFETCH;d#                         PATUNFETCH;                          break;                       }l                       c = c1;                    }                  else                   {                      PATUNFETCH;H                     break;                   }A  I                 /* If we get here, we found another repeat character.  */*                }  C             /* Star, etc. applied to an empty pattern is equivalentU'                to an empty pattern.  */\             if (!laststart)	               break;  A             /* Now we know whether or not zero matches is allowedhJ                and also whether or not two or more matches is allowed.  */             if (many_times_ok)H               { /* More than one repetition is allowed, so put in at theK                    end a backward relative jump from `b' to before the nextcE                    jump we're going to put in below (which jumps from 1                    laststart to after this jump).s  I                    But if we are at the `*' in the exact sequence `.*\n',PC                    insert an unconditional jump backwards to the ., J                    instead of the beginning of the loop.  This way we onlyC                    push a failure point once, instead of every timeL(                    through the loop.  */)                 assert (p - 1 > pattern);E  7                 /* Allocate the space for the jump.  */-%                 GET_BUFFER_SPACE (3);2  L                 /* We know we are not at the first character of the pattern,D                    because laststart was nonzero.  And we've alreadyI                    incremented `p', by the way, to be the character aftertF                    the `*'.  Do we have to do something analogous hereB                    for null bytes, because of RE_DOT_NOT_NULL?  */;                 if (TRANSLATE (*(p - 2)) == TRANSLATE ('.')o 		    && zero_times_okE                     && p < pend && TRANSLATE (*p) == TRANSLATE ('\n') 2                     && !(syntax & RE_DOT_NEWLINE))(                   { /* We have .*\n.  */4                     STORE_JUMP (jump, b, laststart);)                     keep_string_p = true;                    }i                 else'                   /* Anything else.  */d@                   STORE_JUMP (maybe_pop_jump, b, laststart - 3);  <                 /* We've added more stuff to the buffer.  */                 b += 3;)               }   J             /* On failure, jump from laststart to b + 3, which will be theA                end of the buffer after this jump is inserted.  */d!             GET_BUFFER_SPACE (3);dD             INSERT_JUMP (keep_string_p ? on_failure_keep_string_jump9                                        : on_failure_jump,h+                          laststart, b + 3);              pending_exact = 0;             b += 3;	               if (!zero_times_ok)                {\C                 /* At least one repetition is required, so insert aI:                    `dummy_failure_jump' before the initialB                    `on_failure_jump' instruction of the loop. ThisF                    effects a skip over that instruction the first time(                    we hit that loop.  */%                 GET_BUFFER_SPACE (3);PK                 INSERT_JUMP (dummy_failure_jump, laststart, laststart + 6);	                 b += 3;                }	
             }		 	  break;     
 	case '.':           laststart = b;           BUF_PUSH (anychar);-           break;             case '[':            {_+             boolean had_char_class = false;u  :             if (p == pend) FREE_STACK_RETURN (REG_EBRACK);  F             /* Ensure that we have enough space to push a charset: theM                opcode, the length count, and the bitset; 34 bytes in all.  */e 	    GET_BUFFER_SPACE (34);f               laststart = b;  ?             /* We test `*p == '^' twice, instead of using an ife;                statement, so we only need one BUF_PUSH.  */b9             BUF_PUSH (*p == '^' ? charset_not : charset);              if (*p == '^')               p++;  I             /* Remember the first position in the bracket expression.  */              p1 = p;   :             /* Push the number of bytes in the bitmap.  */4             BUF_PUSH ((1 << BYTEWIDTH) / BYTEWIDTH);  '             /* Clear the whole map.  */l4             bzero (b, (1 << BYTEWIDTH) / BYTEWIDTH);  I             /* charset_not matches newline according to a syntax bit.  */o2             if ((re_opcode_t) b[-2] == charset_not7                 && (syntax & RE_HAT_LISTS_NOT_NEWLINE))t"               SET_LIST_BIT ('\n');  C             /* Read in characters and ranges, setting map bits.  */_             for (;;)               {l>                 if (p == pend) FREE_STACK_RETURN (REG_EBRACK);                   PATFETCH (c);/  I                 /* \ might escape characters inside [...] and [^...].  */OI                 if ((syntax & RE_BACKSLASH_ESCAPE_IN_LISTS) && c == '\\')                    {=C                     if (p == pend) FREE_STACK_RETURN (REG_EESCAPE);   "                     PATFETCH (c1);&                     SET_LIST_BIT (c1);                     continue;*                   }B  G                 /* Could be the end of the bracket expression.  If it'sDD                    not (i.e., when the bracket expression is `[]' soF                    far), the ']' character bit gets set way below.  */,                 if (c == ']' && p != p1 + 1)                   break;  H                 /* Look ahead to see if it's a range when the last thing-                    was a character class.  */0<                 if (had_char_class && c == '-' && *p != ']')1                   FREE_STACK_RETURN (REG_ERANGE);d  H                 /* Look ahead to see if it's a range when the last thingB                    was a character: if this is a hyphen not at theF                    beginning or the end of a list, then it's the range                     operator.  */                 if (c == '-':                     && !(p - 2 >= pattern && p[-2] == '[')J                     && !(p - 3 >= pattern && p[-3] == '[' && p[-2] == '^')!                     && *p != ']')h                   {a%                     reg_errcode_t retnG                       = compile_range (&p, pend, translate, syntax, b);AD                     if (ret != REG_NOERROR) FREE_STACK_RETURN (ret);                   }I  4                 else if (p[0] == '-' && p[1] != ']')J                   { /* This handles ranges made up of characters only.  */&                     reg_errcode_t ret;   		    /* Move past the `-'.  */w"                     PATFETCH (c1);  I                     ret = compile_range (&p, pend, translate, syntax, b);(D                     if (ret != REG_NOERROR) FREE_STACK_RETURN (ret);                   }r  H                 /* See if we're at the beginning of a possible character                    class.  */_  K                 else if (syntax & RE_CHAR_CLASSES && c == '[' && *p == ':') 3                   { /* Leave room for the null.  */.8                     char str[CHAR_CLASS_MAX_LENGTH + 1];  !                     PATFETCH (c);e                     c1 = 0;e  /                     /* If pattern is `[[:'.  */ B                     if (p == pend) FREE_STACK_RETURN (REG_EBRACK);                       for (;;)                       {e%                         PATFETCH (c);mA                         if ((c == ':' && *p == ']') || p == pend)t                            break;" 			if (c1 < CHAR_CLASS_MAX_LENGTH) 			  str[c1++] = c;c 			elsea6 			  /* This is in any case an invalid class name.  */ 			  str[0] = '\0';_                       }_#                     str[c1] = '\0';a  B                     /* If isn't a word bracketed by `[:' and `:]':H                        undo the ending character, the letters, and leaveK                        the leading `:' and `[' (but set bits for them).  */m.                     if (c == ':' && *p == ']')                       {C& #if defined _LIBC || WIDE_CHAR_SUPPORT@                         boolean is_lower = STREQ (str, "lower");@                         boolean is_upper = STREQ (str, "upper"); 			wctype_t wt;u                         int ch;A   			wt = IS_CHAR_CLASS (str); 			if (wt == 0) $ 			  FREE_STACK_RETURN (REG_ECTYPE);  G                         /* Throw away the ] at the end of the character_%                            class.  */n%                         PATFETCH (c);C  F                         if (p == pend) FREE_STACK_RETURN (REG_EBRACK);  ?                         for (ch = 0; ch < 1 << BYTEWIDTH; ++ch)E 			  {
 # ifdef _LIBCn) 			    if (__iswctype (__btowc (ch), wt))s 			      SET_LIST_BIT (ch);a # else% 			    if (iswctype (btowc (ch), wt))o 			      SET_LIST_BIT (ch);e # endif)  . 			    if (translate && (is_upper || is_lower)& 				&& (ISUPPER (ch) || ISLOWER (ch))) 			      SET_LIST_BIT (ch);o 			  }  .                         had_char_class = true; #else                          int ch;c@                         boolean is_alnum = STREQ (str, "alnum");@                         boolean is_alpha = STREQ (str, "alpha");@                         boolean is_blank = STREQ (str, "blank");@                         boolean is_cntrl = STREQ (str, "cntrl");@                         boolean is_digit = STREQ (str, "digit");@                         boolean is_graph = STREQ (str, "graph");@                         boolean is_lower = STREQ (str, "lower");@                         boolean is_print = STREQ (str, "print");@                         boolean is_punct = STREQ (str, "punct");@                         boolean is_space = STREQ (str, "space");@                         boolean is_upper = STREQ (str, "upper");B                         boolean is_xdigit = STREQ (str, "xdigit");  1                         if (!IS_CHAR_CLASS (str)) $ 			  FREE_STACK_RETURN (REG_ECTYPE);  G                         /* Throw away the ] at the end of the characteri%                            class.  */1%                         PATFETCH (c);A  F                         if (p == pend) FREE_STACK_RETURN (REG_EBRACK);  ?                         for (ch = 0; ch < 1 << BYTEWIDTH; ch++)e                           { ' 			    /* This was split into 3 if's to 8 			       avoid an arbitrary limit in some compiler.  */>                             if (   (is_alnum  && ISALNUM (ch))>                                 || (is_alpha  && ISALPHA (ch))>                                 || (is_blank  && ISBLANK (ch))?                                 || (is_cntrl  && ISCNTRL (ch)))  			      SET_LIST_BIT (ch);t) 			    if (   (is_digit  && ISDIGIT (ch)) >                                 || (is_graph  && ISGRAPH (ch))>                                 || (is_lower  && ISLOWER (ch))?                                 || (is_print  && ISPRINT (ch)))e 			      SET_LIST_BIT (ch);l) 			    if (   (is_punct  && ISPUNCT (ch))o>                                 || (is_space  && ISSPACE (ch))>                                 || (is_upper  && ISUPPER (ch))@                                 || (is_xdigit && ISXDIGIT (ch))) 			      SET_LIST_BIT (ch);i1 			    if (   translate && (is_upper || is_lower)i& 				&& (ISUPPER (ch) || ISLOWER (ch))) 			      SET_LIST_BIT (ch);e                           } .                         had_char_class = true; #endif	/* libc || wctype.h */i                       }a                     else                       {a                         c1++;n$                         while (c1--)%                           PATUNFETCH;n+                         SET_LIST_BIT ('[');s+                         SET_LIST_BIT (':');i/                         had_char_class = false;e                       }n                   }i                 else                   {t+                     had_char_class = false;n%                     SET_LIST_BIT (c);u                   }                }+  I             /* Discard any (non)matching list bytes that are all 0 at the E                end of the map.  Decrease the map-length byte too.  */_8             while ((int) b[-1] > 0 && b[b[-1] - 1] == 0)               b[-1]--;             b += b[-1];            }E           break;    
 	case '(':'           if (syntax & RE_NO_BK_PARENS).             goto handle_open;h           else             goto normal_char;;             case ')':a'           if (syntax & RE_NO_BK_PARENS)              goto handle_close;           else             goto normal_char;              case '\n':&           if (syntax & RE_NEWLINE_ALT)             goto handle_alt;           else             goto normal_char;     
 	case '|':%           if (syntax & RE_NO_BK_VBAR)u             goto handle_alt;           else             goto normal_char;y             case '{':iA            if (syntax & RE_INTERVALS && syntax & RE_NO_BK_BRACES) "              goto handle_interval;            elset              goto normal_char;             case '\\':9           if (p == pend) FREE_STACK_RETURN (REG_EESCAPE);   G           /* Do not translate the character after the \, so that we can>E              distinguish, e.g., \B from \b, even if we normally would )              translate, e.g., B to b.  */i           PATFETCH_RAW (c);u             switch (c)
             {i             case '(': +               if (syntax & RE_NO_BK_PARENS)(&                 goto normal_backslash;               handle_open:               bufp->re_nsub++;               regnum++;p  %               if (COMPILE_STACK_FULL)                  {)I                   RETALLOC (compile_stack.stack, compile_stack.size << 1,e1                             compile_stack_elt_t);tE                   if (compile_stack.stack == NULL) return REG_ESPACE;   +                   compile_stack.size <<= 1;e                 }r  H               /* These are the values to restore when we hit end of thisF                  group.  They are all relative offsets, so that if theH                  whole pattern moves because of realloc, they will still                  be valid.  */F               COMPILE_STACK_TOP.begalt_offset = begalt - bufp->buffer;.               COMPILE_STACK_TOP.fixup_alt_jumpI                 = fixup_alt_jump ? fixup_alt_jump - bufp->buffer + 1 : 0; D               COMPILE_STACK_TOP.laststart_offset = b - bufp->buffer;0               COMPILE_STACK_TOP.regnum = regnum;  D               /* We will eventually replace the 0 with the number of=                  groups inner to this one.  But do not push aBC                  start_memory for groups beyond the last one we cana7                  represent in the compiled pattern.  */ '               if (regnum <= MAX_REGNUM)E                 { N                   COMPILE_STACK_TOP.inner_group_offset = b - bufp->buffer + 2;7                   BUF_PUSH_3 (start_memory, regnum, 0);s                 }n  $               compile_stack.avail++;  !               fixup_alt_jump = 0;&               laststart = 0;               begalt = b;R< 	      /* If we've reached MAX_REGNUM groups, then this open5 		 won't actually generate any code, so we'll have to & 		 clear pending_exact explicitly.  */ 	      pending_exact = 0;p               break;                 case ')':;B               if (syntax & RE_NO_BK_PARENS) goto normal_backslash;  &               if (COMPILE_STACK_EMPTY) 		{ . 		  if (syntax & RE_UNMATCHED_RIGHT_PAREN_ORD) 		    goto normal_backslash; 		  else& 		    FREE_STACK_RETURN (REG_ERPAREN); 		}n               handle_close:t!               if (fixup_alt_jump)oA                 { /* Push a dummy failure point at the end of then6                      alternative for a possible future@                      `pop_failure_jump' to pop.  See comments at>                      `push_dummy_failure' in `re_match_2'.  */0                   BUF_PUSH (push_dummy_failure);  F                   /* We allocated space for this jump when we assignedM                      to `fixup_alt_jump', in the `handle_alt' case below.  */ D                   STORE_JUMP (jump_past_alt, fixup_alt_jump, b - 1);                 }   G               /* See similar code for backslashed left paren above.  */ &               if (COMPILE_STACK_EMPTY) 		{(. 		  if (syntax & RE_UNMATCHED_RIGHT_PAREN_ORD) 		    goto normal_char;  		  else& 		    FREE_STACK_RETURN (REG_ERPAREN); 		}   E               /* Since we just checked for an empty stack above, this &                  ``can't happen''.  */0               assert (compile_stack.avail != 0);               {TG                 /* We don't just want to restore into `regnum', because F                    later groups should continue to be numbered higher,C                    as in `(ab)c(de)' -- the second group is #2.  */v+                 regnum_t this_group_regnum;*  &                 compile_stack.avail--;H                 begalt = bufp->buffer + COMPILE_STACK_TOP.begalt_offset;                 fixup_alt_jump4                   = COMPILE_STACK_TOP.fixup_alt_jumpI                     ? bufp->buffer + COMPILE_STACK_TOP.fixup_alt_jump - 1                      : 0;N                 laststart = bufp->buffer + COMPILE_STACK_TOP.laststart_offset;=                 this_group_regnum = COMPILE_STACK_TOP.regnum;m7 		/* If we've reached MAX_REGNUM groups, then this open)7 		   won't actually generate any code, so we'll have toe( 		   clear pending_exact explicitly.  */ 		pending_exact = 0;  I                 /* We're at the end of the group, so now we know how manyt3                    groups were inside this one.  */ 4                 if (this_group_regnum <= MAX_REGNUM)                   {l2                     unsigned char *inner_group_locL                       = bufp->buffer + COMPILE_STACK_TOP.inner_group_offset;  B                     *inner_group_loc = regnum - this_group_regnum;?                     BUF_PUSH_3 (stop_memory, this_group_regnum,s<                                 regnum - this_group_regnum);                   }y               }c               break;    &             case '|':					/* `\|'.  */D               if (syntax & RE_LIMITED_OPS || syntax & RE_NO_BK_VBAR)&                 goto normal_backslash;             handle_alt:L*               if (syntax & RE_LIMITED_OPS)!                 goto normal_char;E  D               /* Insert before the previous alternative a jump whichC                  jumps to this alternative if the former fails.  */ #               GET_BUFFER_SPACE (3); ;               INSERT_JUMP (on_failure_jump, begalt, b + 6);                 pending_exact = 0;               b += 3;   D               /* The alternative before this one has a jump after itE                  which gets executed if it gets matched.  Adjust that E                  jump so it will jump to this alternative's analogousrH                  jump (put in below, which in turn will jump to the nextH                  (if any) alternative's such jump, etc.).  The last suchI                  jump jumps to the correct final destination.  A picture: %                           _____ _____l%                           |   | |   |s%                           |   v |   vx$                          a | b   | c  L                  If we are at `b', then fixup_alt_jump right now points to aH                  three-byte space after `a'.  We'll put in the jump, setJ                  fixup_alt_jump to right after `b', and leave behind threeH                  bytes which we'll fill in when we get to after `c'.  */  !               if (fixup_alt_jump)i>                 STORE_JUMP (jump_past_alt, fixup_alt_jump, b);  H               /* Mark and leave space for a jump after this alternative,D                  to be filled in later either by next alternative orL                  when know we're at the end of a series of alternatives.  */!               fixup_alt_jump = b; #               GET_BUFFER_SPACE (3);_               b += 3;                  laststart = 0;               begalt = b;                break;                 case '{': (               /* If \{ is a literal.  */*               if (!(syntax & RE_INTERVALS)G                      /* If we're at `\{' and it's not the open-interval %                         operator.  */ L                   || ((syntax & RE_INTERVALS) && (syntax & RE_NO_BK_BRACES))7                   || (p - 2 == pattern  &&  p == pend))_&                 goto normal_backslash;               handle_interval:               {eE                 /* If got here, then the syntax allows intervals.  */p  F                 /* At least (most) this many matches must be made.  */7                 int lower_bound = -1, upper_bound = -1;   %                 beg_interval = p - 1;                    if (p == pend)                   { 1                     if (syntax & RE_NO_BK_BRACES)t,                       goto unfetch_interval;                     else5                       FREE_STACK_RETURN (REG_EBRACE);                    }T  2                 GET_UNSIGNED_NUMBER (lower_bound);                   if (c == ',')                    { 6                     GET_UNSIGNED_NUMBER (upper_bound);B                     if (upper_bound < 0) upper_bound = RE_DUP_MAX;                   }                  elseE                   /* Interval such as `{1}' => match exactly once. */N,                   upper_bound = lower_bound;  ?                 if (lower_bound < 0 || upper_bound > RE_DUP_MAX 1                     || lower_bound > upper_bound)                    {(1                     if (syntax & RE_NO_BK_BRACES) ,                       goto unfetch_interval;                     else4                       FREE_STACK_RETURN (REG_BADBR);                   }]  0                 if (!(syntax & RE_NO_BK_BRACES))                   { B                     if (c != '\\') FREE_STACK_RETURN (REG_EBRACE);  !                     PATFETCH (c);a                   }n                   if (c != '}')                    {t1                     if (syntax & RE_NO_BK_BRACES)&,                       goto unfetch_interval;                     else4                       FREE_STACK_RETURN (REG_BADBR);                   }t  7                 /* We just parsed a valid interval.  */e  ?                 /* If it's invalid to have no preceding re.  */e                 if (!laststart)                    { 8                     if (syntax & RE_CONTEXT_INVALID_OPS)5                       FREE_STACK_RETURN (REG_BADRPT);-;                     else if (syntax & RE_CONTEXT_INDEP_OPS) $                       laststart = b;                     else,                       goto unfetch_interval;                   },  G                 /* If the upper bound is zero, don't want to succeed atSG                    all; jump from `laststart' to `b + 3', which will be F                    the end of the buffer after we insert the jump.  */&                  if (upper_bound == 0)                    {*                      GET_BUFFER_SPACE (3);:                      INSERT_JUMP (jump, laststart, b + 3);                      b += 3;                    }  C                  /* Otherwise, we have a nontrivial interval.  When ?                     we're all done, the pattern will look like:n>                       set_number_at <jump count> <upper bound>C                       set_number_at <succeed_n count> <lower bound>=C                       succeed_n <after jump addr> <succeed_n count> $                       <body of loop>:                       jump_n <succeed_n addr> <jump count>@                     (The upper bound and `jump_n' are omitted if4                     `upper_bound' is 1, though.)  */                  else D                    { /* If the upper bound is > 1, we need to insert8                         more at the end of the loop.  */C                      unsigned nbytes = 10 + (upper_bound > 1) * 10;	  /                      GET_BUFFER_SPACE (nbytes);c  G                      /* Initialize lower bound of the `succeed_n', evensD                         though it will be set during matching by itsB                         attendant `set_number_at' (inserted next),C                         because `re_compile_fastmap' needs to know.tG                         Jump to the `jump_n' we might insert below.  */i8                      INSERT_JUMP2 (succeed_n, laststart,A                                    b + 5 + (upper_bound > 1) * 5,S0                                    lower_bound);                      b += 5;  C                      /* Code to initialize the lower bound.  Insert H                         before the `succeed_n'.  The `5' is the last twoF                         bytes of this `set_number_at', plus 3 bytes of6                         the following `succeed_n'.  */N                      insert_op2 (set_number_at, laststart, 5, lower_bound, b);                      b += 5;  )                      if (upper_bound > 1) C                        { /* More than one repetition is allowed, so	E                             append a backward jump to the `succeed_n' 6                             that starts this interval.  D                             When we've reached this during matching,D                             we'll have matched the interval once, soG                             jump back only `upper_bound - 1' times.  */h?                          STORE_JUMP2 (jump_n, b, laststart + 5, 7                                       upper_bound - 1);;                           b += 5;  E                          /* The location we want to set is the secondkG                             parameter of the `jump_n'; that is `b-2' asQE                             an absolute address.  `laststart' will be,F                             the `set_number_at' we're about to insert;G                             `laststart+3' the number to set, the source A                             for the relative address.  But we are G                             inserting into the middle of the pattern -- C                             so everything is getting moved up by 5. F                             Conclusion: (b - 2) - (laststart + 3) + 5,0                             i.e., b - laststart.  G                             We insert this at the beginning of the loopEE                             so that if we fail during matching, we'll 8                             reinitialize the bounds.  */M                          insert_op2 (set_number_at, laststart, b - laststart,F9                                      upper_bound - 1, b);o                           b += 5;                        }                    }"                 pending_exact = 0;$                 beg_interval = NULL;               }                break;               unfetch_interval:hN               /* If an invalid interval, match the characters as literals.  */%                assert (beg_interval);B                 p = beg_interval;#                beg_interval = NULL;h  @                /* normal_char and normal_backslash need `c'.  */                PATFETCH (c);  /                if (!(syntax & RE_NO_BK_BRACES))                   {6                    if (p > pattern  &&  p[-1] == '\\')+                      goto normal_backslash;e                  }                 goto normal_char;   #ifdef emacsF             /* There is no way to specify the before_dot and after_dot;                operators.  rms says this is ok.  --karl  */              case '=':                 BUF_PUSH (at_dot);               break;               case 's':                laststart = b;               PATFETCH (c);c;               BUF_PUSH_2 (syntaxspec, syntax_spec_code[c]);                break;               case 'S':_               laststart = b;               PATFETCH (c); >               BUF_PUSH_2 (notsyntaxspec, syntax_spec_code[c]);               break; #endif /* emacs */                 case 'w':c" 	      if (syntax & RE_NO_GNU_OPS) 		goto normal_char;                laststart = b;"               BUF_PUSH (wordchar);               break;                 case 'W':a" 	      if (syntax & RE_NO_GNU_OPS) 		goto normal_char;                laststart = b;%               BUF_PUSH (notwordchar);a               break;                 case '<':I" 	      if (syntax & RE_NO_GNU_OPS) 		goto normal_char; !               BUF_PUSH (wordbeg);i               break;               case '>': " 	      if (syntax & RE_NO_GNU_OPS) 		goto normal_char;*!               BUF_PUSH (wordend);>               break;               case 'b':;" 	      if (syntax & RE_NO_GNU_OPS) 		goto normal_char;;#               BUF_PUSH (wordbound);x               break;               case 'B':p" 	      if (syntax & RE_NO_GNU_OPS) 		goto normal_char; &               BUF_PUSH (notwordbound);               break;               case '`':l" 	      if (syntax & RE_NO_GNU_OPS) 		goto normal_char;                 BUF_PUSH (begbuf);               break;               case '\'':" 	      if (syntax & RE_NO_GNU_OPS) 		goto normal_char;                 BUF_PUSH (endbuf);               break;  =             case '1': case '2': case '3': case '4': case '5':a3             case '6': case '7': case '8': case '9':a)               if (syntax & RE_NO_BK_REFS)S!                 goto normal_char;a                 c1 = c - '0';                  if (c1 > regnum)0                 FREE_STACK_RETURN (REG_ESUBREG);  M               /* Can't back reference to a subexpression if inside of it.  */sH               if (group_in_compile_stack (compile_stack, (regnum_t) c1))!                 goto normal_char;e                 laststart = b;)               BUF_PUSH_2 (duplicate, c1);                break;                 case '+':              case '?':B)               if (syntax & RE_BK_PLUS_QM)k!                 goto handle_plus;                else&                 goto normal_backslash;               default:             normal_backslash: A               /* You might think it would be useful for \ to means?                  not to translate; but if we don't translate it 2                  it will never match anything.  */                c = TRANSLATE (c);               goto normal_char; 
             }r           break;    	 	default:e,         /* Expects the character in `c'.  */
 	normal_char:g1 	      /* If no exactn currently being built.  */e           if (!pending_exact  <               /* If last exactn not at current position.  */8               || pending_exact + *pending_exact + 1 != b  N               /* We have only one byte following the exactn for the count.  */0 	      || *pending_exact == (1 << BYTEWIDTH) - 1  :               /* If followed by a repetition operator.  */'               || *p == '*' || *p == '^' # 	      || ((syntax & RE_BK_PLUS_QM) 0 		  ? *p == '\\' && (p[1] == '+' || p[1] == '?') 		  : (*p == '+' || *p == '?')) " 	      || ((syntax & RE_INTERVALS)0                   && ((syntax & RE_NO_BK_BRACES) 		      ? *p == '{'o8                       : (p[0] == '\\' && p[1] == '{')))) 	    {* 	      /* Start building a new exactn.  */                 laststart = b;   	      BUF_PUSH_2 (exactn, 0); 	      pending_exact = b - 1; 
             }    	  BUF_PUSH (c);           (*pending_exact)++; 	 	  break;n         } /* switch (c) */     } /* while p != pend */     !   /* Through the pattern now.  */t     if (fixup_alt_jump) 2     STORE_JUMP (jump_past_alt, fixup_alt_jump, b);     if (!COMPILE_STACK_EMPTY)t#     FREE_STACK_RETURN (REG_EPAREN);   1   /* If we don't want backtracking, force success A      the first time we reach the end of the compiled pattern.  */'(   if (syntax & RE_NO_POSIX_BACKTRACKING)     BUF_PUSH (succeed);l     free (compile_stack.stack);_  9   /* We have succeeded; set the length of the buffer.  */_    bufp->used = b - bufp->buffer;   #ifdef DEBUG   if (debug)     {R.       DEBUG_PRINT1 ("\nCompiled pattern: \n");$       print_compiled_pattern (bufp);     }  #endif /* DEBUG */   #ifndef MATCH_MAY_ALLOCATEF   /* Initialize the failure stack to the largest possible stack.  ThisC      isn't necessary unless we're trying to avoid calling alloca in '      the search and match routines.  */t   {.%     int num_regs = bufp->re_nsub + 1;d  I     /* Since DOUBLE_FAIL_STACK refuses to double only if the current sizewK        is strictly greater than re_max_failures, the largest possible stacke1        is 2 * re_max_failures failure points.  */sD     if (fail_stack.size < (2 * re_max_failures * MAX_FAILURE_ITEMS))       {l= 	fail_stack.size = (2 * re_max_failures * MAX_FAILURE_ITEMS);f  
 # ifdef emacsM 	if (! fail_stack.stack) 	  fail_stack.stack_4 	    = (fail_stack_elt_t *) xmalloc (fail_stack.size& 					    * sizeof (fail_stack_elt_t)); 	else  	  fail_stack.stacku7 	    = (fail_stack_elt_t *) xrealloc (fail_stack.stack,  					     (fail_stack.size) 					      * sizeof (fail_stack_elt_t)));0 # else /* not emacs */ 	if (! fail_stack.stack) 	  fail_stack.stacki3 	    = (fail_stack_elt_t *) malloc (fail_stack.sizep% 					   * sizeof (fail_stack_elt_t));, 	else  	  fail_stack.stacka6 	    = (fail_stack_elt_t *) realloc (fail_stack.stack, 					    (fail_stack.sizem( 					     * sizeof (fail_stack_elt_t))); # endif /* not emacs */t       }b  $     regex_grow_registers (num_regs);   } # #endif /* not MATCH_MAY_ALLOCATE */      return REG_NOERROR;O } /* regex_compile */   ' /* Subroutines for `regex_compile'.  */T  B /* Store OP at LOC followed by two-byte integer parameter ARG.  */   static voidu store_op1 (op, loc, arg)     re_opcode_t op;      unsigned char *loc;g     int arg; {C   *loc = (unsigned char) op;   STORE_NUMBER (loc + 1, arg); }s    G /* Like `store_op1', but for two two-byte parameters ARG1 and ARG2.  */p   static voidp store_op2 (op, loc, arg1, arg2);     re_opcode_t op;*     unsigned char *loc;g     int arg1, arg2;h {m   *loc = (unsigned char) op;   STORE_NUMBER (loc + 1, arg1);    STORE_NUMBER (loc + 3, arg2);  }M    H /* Copy the bytes from LOC to END to open up three bytes of space at LOC9    for OP followed by two-byte integer parameter ARG.  */K   static voidp insert_op1 (op, loc, arg, end)     re_opcode_t op;g     unsigned char *loc;      int arg;     unsigned char *end;m {,&   register unsigned char *pfrom = end;(   register unsigned char *pto = end + 3;     while (pfrom != loc)     *--pto = *--pfrom;     store_op1 (op, loc, arg);a }'    H /* Like `insert_op1', but for two two-byte parameters ARG1 and ARG2.  */   static void % insert_op2 (op, loc, arg1, arg2, end)      re_opcode_t op;L     unsigned char *loc;x     int arg1, arg2;      unsigned char *end;_ {r&   register unsigned char *pfrom = end;(   register unsigned char *pto = end + 5;     while (pfrom != loc)     *--pto = *--pfrom;  "   store_op2 (op, loc, arg1, arg2); }A    F /* P points to just after a ^ in PATTERN.  Return true if that ^ comesH    after an alternative or a begin-subexpression.  We assume there is at(    least one character before the ^.  */   static boolean% at_begline_loc_p (pattern, p, syntax)      const char *pattern, *p;     reg_syntax_t syntax; {m   const char *prev = p - 2;gC   boolean prev_prev_backslash = prev > pattern && prev[-1] == '\\';      return$        /* After a subexpression?  */J        (*prev == '(' && (syntax & RE_NO_BK_PARENS || prev_prev_backslash))#        /* After an alternative?  */ I     || (*prev == '|' && (syntax & RE_NO_BK_VBAR || prev_prev_backslash));  }     H /* The dual of at_begline_loc_p.  This one is for $.  We assume there is<    at least one character after the $, i.e., `P < PEND'.  */   static boolean" at_endline_loc_p (p, pend, syntax)     const char *p, *pend;,     reg_syntax_t syntax; {a   const char *next = p;')   boolean next_backslash = *next == '\\';b3   const char *next_next = p + 1 < pend ? p + 1 : 0;/     return%        /* Before a subexpression?  */ /        (syntax & RE_NO_BK_PARENS ? *next == ')';;         : next_backslash && next_next && *next_next == ')')i$        /* Before an alternative?  */-     || (syntax & RE_NO_BK_VBAR ? *next == '|' <         : next_backslash && next_next && *next_next == '|'); }a    C /* Returns true if REGNUM is in one of COMPILE_STACK's elements andS    false if it's not.  */    static boolean. group_in_compile_stack (compile_stack, regnum)%     compile_stack_type compile_stack;      regnum_t regnum; {    int this_element;.  .   for (this_element = compile_stack.avail - 1;        this_element >= 0;w        this_element--);     if (compile_stack.stack[this_element].regnum == regnum)        return true;     return false;R }S    J /* Read the ending character of a range (in a bracket expression) from theA    uncompiled pattern *P_PTR (which ends at PEND).  We assume theaE    starting character is in `P[-2]'.  (`P[-1]' is the character `-'.)tC    Then we set the translation of all bits between the starting and);    ending characters (inclusive) in the compiled pattern B.e      Return an error code.  E    We use these short variable names so we can use the same macros as=    `regex_compile' itself.  */   static reg_errcode_t1 compile_range (p_ptr, pend, translate, syntax, b)o     const char **p_ptr, *pend;      RE_TRANSLATE_TYPE translate;     reg_syntax_t syntax;     unsigned char *b;  {    unsigned this_char;E     const char *p = *p_ptr;d&   unsigned int range_start, range_end;     if (p == pend)     return REG_ERANGE;  C   /* Even though the pattern is a signed `char *', we need to fetch)E      with unsigned char *'s; if the high bit of the pattern character E      is set, the range endpoints will be negative if we fetch using a       signed char *.e  F      We also want to fetch the endpoints without translating them; theG      appropriate translation is done in the bit-setting loop below.  */ M   /* The SVR4 compiler on the 3B2 had trouble with unsigned const char *.  */ 0   range_start = ((const unsigned char *) p)[-2];/   range_end   = ((const unsigned char *) p)[0];R  B   /* Have to increment the pointer into the pattern string, so the4      caller isn't still at the ending character.  */
   (*p_ptr)++;=  ;   /* If the start is after the end, the range is empty.  */A   if (range_start > range_end)B     return syntax & RE_NO_EMPTY_RANGES ? REG_ERANGE : REG_NOERROR;  C   /* Here we see why `this_char' has to be larger than an `unsignedu?      char' -- the range is inclusive, so if `range_end' == 0xff H      (assuming 8-bit characters), we would otherwise go into an infinite,      loop, since all characters <= 0xff.  */D   for (this_char = range_start; this_char <= range_end; this_char++)     { +       SET_LIST_BIT (TRANSLATE (this_char));      }      return REG_NOERROR;T }_ AH /* re_compile_fastmap computes a ``fastmap'' for the compiled pattern inB    BUFP.  A fastmap records which of the (1 << BYTEWIDTH) possibleH    characters can start a string that matches the pattern.  This fastmapH    is used by re_search to skip quickly over impossible starting points.  E    The caller must supply the address of a (1 << BYTEWIDTH)-byte datap    area as BUFP->fastmap.'  H    We set the `fastmap', `fastmap_accurate', and `can_be_null' fields in    the pattern buffer.  9    Returns 0 if we succeed, -2 if an internal error.   */    int  re_compile_fastmap (bufp) $      struct re_pattern_buffer *bufp; {t   int j, k;; #ifdef MATCH_MAY_ALLOCATE    fail_stack_type fail_stack;  #endif #ifndef REGEX_MALLOC   char *destination; #endif  )   register char *fastmap = bufp->fastmap; (   unsigned char *pattern = bufp->buffer;   unsigned char *p = pattern;>6   register unsigned char *pend = pattern + bufp->used;   #ifdef REL_ALLOC6   /* This holds the pointer to the failure stack, when%      it is allocated relocatably.  */ &   fail_stack_elt_t *failure_stack_ptr; #endif  @   /* Assume that each path through the pattern can be null untilA      proven otherwise.  We set this false at the bottom of switchsA      statement, to which we get only if a particular path doesn'tf       match the empty string.  */"   boolean path_can_be_null = true;  5   /* We aren't doing a `succeed_n' to begin with.  */g   boolean succeed_n_p = false;  (   assert (fastmap != NULL && p != NULL);     INIT_FAIL_STACK (); B   bzero (fastmap, 1 << BYTEWIDTH);  /* Assume nothing's valid.  */D   bufp->fastmap_accurate = 1;	    /* It will be when we're done.  */   bufp->can_be_null = 0;     while (1)n     {t%       if (p == pend || *p == succeed)  	{9 	  /* We have reached the (effective) end of pattern.  */  	  if (!FAIL_STACK_EMPTY ()) 	    {- 	      bufp->can_be_null |= path_can_be_null;R  " 	      /* Reset for next path.  */ 	      path_can_be_null = true;5  8 	      p = fail_stack.stack[--fail_stack.avail].pointer;   	      continue; 	    } 	  else  	    break;  	}  J       /* We should never be about to go beyond the end of the pattern.  */       assert (p < pend);  4       switch (SWITCH_ENUM_CAST ((re_opcode_t) *p++)) 	{  G         /* I guess the idea here is to simply not bother with a fastmapoH            if a backreference is used, since it's too hard to figure out<            the fastmap for the corresponding group.  SettingG            `can_be_null' stops `re_search_2' from using the fastmap, so !            that is all we do.  */, 	case duplicate: 	  bufp->can_be_null = 1;c           goto done;    D       /* Following are the cases which match a character.  These end          with `break'.  */  
 	case exactn:            fastmap[p[1]] = 1;	 	  break;              case charset:i5           for (j = *p++ * BYTEWIDTH - 1; j >= 0; j--) 3 	    if (p[j / BYTEWIDTH] & (1 << (j % BYTEWIDTH)))                fastmap[j] = 1;l	 	  break;5     	case charset_not:2 	  /* Chars beyond end of map must be allowed.  */6 	  for (j = *p * BYTEWIDTH; j < (1 << BYTEWIDTH); j++)             fastmap[j] = 1;s  . 	  for (j = *p++ * BYTEWIDTH - 1; j >= 0; j--)6 	    if (!(p[j / BYTEWIDTH] & (1 << (j % BYTEWIDTH))))               fastmap[j] = 1;s           break;     	case wordchar: ) 	  for (j = 0; j < (1 << BYTEWIDTH); j++)r 	    if (SYNTAX (j) == Sword)  	      fastmap[j] = 1;	 	  break;e     	case notwordchar:) 	  for (j = 0; j < (1 << BYTEWIDTH); j++)t 	    if (SYNTAX (j) != Sword)  	      fastmap[j] = 1;	 	  break;t             case anychar:  	  {) 	    int fastmap_newline = fastmap['\n'];   $ 	    /* `.' matches anything ...  */+ 	    for (j = 0; j < (1 << BYTEWIDTH); j++)  	      fastmap[j] = 1;  ' 	    /* ... except perhaps newline.  */ * 	    if (!(bufp->syntax & RE_DOT_NEWLINE))' 	      fastmap['\n'] = fastmap_newline;a  @ 	    /* Return if we have already set `can_be_null'; if we have,D 	       then the fastmap is irrelevant.  Something's wrong here.  */  	    else if (bufp->can_be_null) 	      goto done;   7 	    /* Otherwise, have to check alternative paths.  */  	    break;  	  }   #ifdef emacs         case syntaxspec: 	  k = *p++;) 	  for (j = 0; j < (1 << BYTEWIDTH); j++)e+ 	    if (SYNTAX (j) == (enum syntaxcode) k)  	      fastmap[j] = 1;	 	  break;_     	case notsyntaxspec: 	  k = *p++;) 	  for (j = 0; j < (1 << BYTEWIDTH); j++)l+ 	    if (SYNTAX (j) != (enum syntaxcode) k)B 	      fastmap[j] = 1;	 	  break;     E       /* All cases after this match the empty string.  These end witho          `continue'.  */     	case before_dot:E
 	case at_dot:  	case after_dot:           continue;E #endif /* emacs */             case no_op:i         case begline:1         case endline: 
 	case begbuf:o
 	case endbuf:e 	case wordbound: 	case notwordbound:t 	case wordbeg: 	case wordend:          case push_dummy_failure:           continue;t    
 	case jump_n:          case pop_failure_jump: 	case maybe_pop_jump:  	case jump:          case jump_past_alt:_ 	case dummy_failure_jump: )           EXTRACT_NUMBER_AND_INCR (j, p); 
 	  p += j;
 	  if (j > 0)  	    continue;  E           /* Jump backward implies we just went through the body of a B              loop and matched nothing.  Opcode jumped to should beE              `on_failure_jump' or `succeed_n'.  Just treat it like ansD              ordinary jump.  For a * loop, it has pushed its failureA              point already; if so, discard that as redundant.  */o1           if ((re_opcode_t) *p != on_failure_jump ( 	      && (re_opcode_t) *p != succeed_n) 	    continue;             p++;)           EXTRACT_NUMBER_AND_INCR (j, p);	           p += j;   D           /* If what's on the stack is where we are now, pop it.  */"           if (!FAIL_STACK_EMPTY ()> 	      && fail_stack.stack[fail_stack.avail - 1].pointer == p)             fail_stack.avail--;d             continue;r             case on_failure_jump: )         case on_failure_keep_string_jump:a 	handle_on_failure_jump:)           EXTRACT_NUMBER_AND_INCR (j, p);   G           /* For some patterns, e.g., `(a?)?', `p+j' here points to thehE              end of the pattern.  We don't want to push such a point, E              since when we restore it above, entering the switch willhF              increment `p' past the end of the pattern.  We don't needH              to push such a point since we obviously won't find any moreE              fastmap entries beyond `pend'.  Such a pattern can match )              the null string, though.  */N           if (p + j < pend) 
             {U7               if (!PUSH_PATTERN_OP (p + j, fail_stack))e 		{  		  RESET_FAIL_STACK (); 		  return -2; 		} 
             }            else"             bufp->can_be_null = 1;             if (succeed_n_p)
             {n@               EXTRACT_NUMBER_AND_INCR (k, p);	/* Skip the n.  */"               succeed_n_p = false; 	    }             continue;      	case succeed_n:7           /* Get to the number of times to succeed.  */            p += 2;u  8           /* Increment p past the n for when k != 0.  */)           EXTRACT_NUMBER_AND_INCR (k, p);            if (k == 0)  	    {               p -= 4;):   	      succeed_n_p = true;  /* Spaghetti code alert.  */*               goto handle_on_failure_jump;
             }k           continue;o     	case set_number_at:           p += 4;            continue;k     	case start_memory:a         case stop_memory:c
 	  p += 2; 	  continue;    	 	default:k8           abort (); /* We have listed all the cases.  */         } /* switch *p++ */t  ?       /* Getting here means we have found the possible starting E          characters for one path of the pattern -- and that the empty F          string does not match.  We need not follow this path further.A          Instead, look at the next alternative (remembered on thebE          stack), or quit if no more.  The test at the top of the loopa          does these things.  */.       path_can_be_null = false;a       p = pend;c     } /* while p */   E   /* Set `can_be_null' for the last path (also the first path, if the       pattern is empty).  */<(   bufp->can_be_null |= path_can_be_null;    done:   RESET_FAIL_STACK ();   return 0;  } /* re_compile_fastmap */ #ifdef _LIBC5 weak_alias (__re_compile_fastmap, re_compile_fastmap)= #endif ]B /* Set REGS to hold NUM_REGS registers, storing them in STARTS andC    ENDS.  Subsequent matches using PATTERN_BUFFER and REGS will use C    this memory for recording register information.  STARTS and ENDS)D    must be allocated using the malloc library routine, and must each7    be at least NUM_REGS * sizeof (regoff_t) bytes long.p  F    If NUM_REGS == 0, then subsequent matches should allocate their own    register data.   B    Unless this function is called, the first search or match using>    PATTERN_BUFFER will allocate its own register data, without    freeing the old data.  */   void5 re_set_registers (bufp, regs, num_regs, starts, ends)S#     struct re_pattern_buffer *bufp;      struct re_registers *regs;     unsigned num_regs;     regoff_t *starts, *ends; {o   if (num_regs)*     {f-       bufp->regs_allocated = REGS_REALLOCATE;U        regs->num_regs = num_regs;       regs->start = starts;e       regs->end = ends;h     }    else     { .       bufp->regs_allocated = REGS_UNALLOCATED;       regs->num_regs = 0; /       regs->start = regs->end = (regoff_t *) 0;r     }p }d #ifdef _LIBC1 weak_alias (__re_set_registers, re_set_registers)_ #endif   /* Searching routines.  */  A /* Like re_search_2, below, but only one string is specified, and 1    doesn't let you say where to stop matching. */s   intn5 re_search (bufp, string, size, startpos, range, regs)r$      struct re_pattern_buffer *bufp;      const char *string;      int size, startpos, range;       struct re_registers *regs;f {uC   return re_search_2 (bufp, NULL, 0, string, size, startpos, range,r 		      regs, size); }a #ifdef _LIBC# weak_alias (__re_search, re_search)I #endif    G /* Using the compiled pattern in BUFP->buffer, first tries to match the H    virtual concatenation of STRING1 and STRING2, starting first at index-    STARTPOS, then at STARTPOS + 1, and so on.   A    STRING1 and STRING2 have length SIZE1 and SIZE2, respectively.=  G    RANGE is how far to scan while trying to match.  RANGE = 0 means tryiC    only at STARTPOS; in general, the last start tried is STARTPOS +/	    RANGE.i  F    In REGS, return the indices of the virtual concatenation of STRING1E    and STRING2 that matched the entire BUFP->buffer and its containedi    subexpressions.  B    Do not consider matching one past the index STOP in the virtual(    concatenation of STRING1 and STRING2.  F    We return either the position in the strings at which the match was9    found, -1 if no match, or -2 if error (such as failure     stack overflow).  */*   intcO re_search_2 (bufp, string1, size1, string2, size2, startpos, range, regs, stop)l$      struct re_pattern_buffer *bufp;#      const char *string1, *string2;,      int size1, size2;      int startpos;      int range;       struct re_registers *regs;d      int stop; {_
   int val;)   register char *fastmap = bufp->fastmap;t9   register RE_TRANSLATE_TYPE translate = bufp->translate;v!   int total_size = size1 + size2;2    int endpos = startpos + range;  )   /* Check for out-of-range STARTPOS.  */ ,   if (startpos < 0 || startpos > total_size)     return -1;  8   /* Fix up RANGE if it might eventually take us outside6      the virtual concatenation of STRING1 and STRING2.F      Make sure we won't move STARTPOS below 0 or above TOTAL_SIZE.  */   if (endpos < 0)      range = 0 - startpos;d   else if (endpos > total_size) "     range = total_size - startpos;  E   /* If the search isn't to be a backwards one, don't waste time in ar4      search for a pattern that must be anchored.  */!   if (bufp->used > 0 && range > 0c1       && ((re_opcode_t) bufp->buffer[0] == begbuf D 	  /* `begline' is like `begbuf' if it cannot match at newlines.  *// 	  || ((re_opcode_t) bufp->buffer[0] == begline " 	      && !bufp->newline_anchor)))     {        if (startpos > 0)_ 	return -1;t
       else 	range = 1;      }    #ifdef emacs;   /* In a forward search for something that starts with \=.=)      don't keep searching past point.  */rM   if (bufp->used > 0 && (re_opcode_t) bufp->buffer[0] == at_dot && range > 0)c     {        range = PT - startpos;       if (range <= 0)s 	return -1;      }l #endif /* emacs */  7   /* Update the fastmap now if not correct already.  */r)   if (fastmap && !bufp->fastmap_accurate);(     if (re_compile_fastmap (bufp) == -2)       return -2;  H   /* Loop through the string, looking for a place to start matching.  */
   for (;;)     {fD       /* If a fastmap is supplied, skip quickly over characters thatF          cannot be the start of a match.  If the pattern can match theH          null string, however, we don't need to skip characters; we want#          the first null string.  */_A       if (fastmap && startpos < total_size && !bufp->can_be_null)e 	{, 	  if (range > 0)	/* Searching forwards.  */ 	    { 	      register const char *d; 	      register int lim = 0; 	      int irange = range;  @               if (startpos < size1 && startpos + range >= size1)1                 lim = range - (size1 - startpos);:  F 	      d = (startpos >= size1 ? string2 - size1 : string1) + startpos;  G               /* Written out as an if-else to avoid testing `translate'*%                  inside the loop.  */  	      if (translate)|"                 while (range > lim2                        && !fastmap[(unsigned char)( 				   translate[(unsigned char) *d++]])                   range--; 	      elseeE                 while (range > lim && !fastmap[(unsigned char) *d++])e                   range--;  " 	      startpos += irange - range; 	    }& 	  else				/* Searching backwards.  */ 	    {9 	      register char c = (size1 == 0 || startpos >= size1_<                                  ? string2[startpos - size1]6                                  : string1[startpos]);  3 	      if (!fastmap[(unsigned char) TRANSLATE (c)])a 		goto advance;i 	    } 	}  O       /* If can't match the null string, and that's all we have left, fail.  */ 9       if (range >= 0 && startpos == total_size && fastmap             && !bufp->can_be_null) 	return -1;n  F       val = re_match_2_internal (bufp, string1, size1, string2, size2, 				 startpos, regs, stop);  #ifndef REGEX_MALLOC # ifdef C_ALLOCA       alloca (0);n # endife #endif         if (val >= 0)  	return startpos;s         if (val == -2) 	return -2;p       advance:       if (!range)s         break;       else if (range > 0) 	         {S           range--;           startpos++;a	         }i
       else	         {n           range++;           startpos--;p	         }i     }t   return -1; } /* re_search_2 */  #ifdef _LIBC' weak_alias (__re_search_2, re_search_2)e #endif  H /* This converts PTR, a pointer into one of the search strings `string1'F    and `string2' into an offset from the beginning of that string.  */" #define POINTER_TO_OFFSET(ptr)			\   (FIRST_STRING_P (ptr)				\&    ? ((regoff_t) ((ptr) - string1))		\,    : ((regoff_t) ((ptr) - string2 + size1)))  ? /* Macros for dealing with the split strings in re_match_2.  */   7 #define MATCHING_IN_FIRST_STRING  (dend == end_match_1)   C /* Call before fetching a character with *d.  This switches over to     string2 if necessary.  */ #define PREFETCH()							\   while (d == dend)						    	\i     {									\c*       /* End of string2 => fail.  */					\&       if (dend == end_match_2) 						\         goto fail;							\7       /* End of string1 => advance to string2.  */ 			\n!       d = string2;						        \E        dend = end_match_2;						\     }w    H /* Test if at very beginning or at very end of the virtual concatenationG    of `string1' and `string2'.  If only one string, it's `string2'.  */ H #define AT_STRINGS_BEG(d) ((d) == (size1 ? string1 : string2) || !size2)' #define AT_STRINGS_END(d) ((d) == end2)t    F /* Test if D points to a character which is word-constituent.  We haveF    two special cases to check for: if past the end of string1, look atA    the first character in string2; and if before the beginning ofF6    string2, look at the last character in string1.  */ #define WORDCHAR_P(d)							\ '   (SYNTAX ((d) == end1 ? *string2					\s9            : (d) == string2 - 1 ? *(end1 - 1) : *(d))			\l    == Sword)  E /* Disabled due to a compiler bug -- see comment at case wordbound */d #if 0 F /* Test if the character before D and the one at D differ with respect!    to being word-constituent.  */e" #define AT_WORD_BOUNDARY(d)						\0   (AT_STRINGS_BEG (d) || AT_STRINGS_END (d)				\+    || WORDCHAR_P (d - 1) != WORDCHAR_P (d))p #endif  ! /* Free everything we malloc.  */f #ifdef MATCH_MAY_ALLOCATEl< # define FREE_VAR(var) if (var) REGEX_FREE (var); var = NULL  # define FREE_VARIABLES()						\   do {									\-     REGEX_FREE_STACK (fail_stack.stack);				\f     FREE_VAR (regstart);						\p     FREE_VAR (regend);							\#     FREE_VAR (old_regstart);						\i!     FREE_VAR (old_regend);						\ $     FREE_VAR (best_regstart);						\"     FREE_VAR (best_regend);						\     FREE_VAR (reg_info);						\c      FREE_VAR (reg_dummy);						\%     FREE_VAR (reg_info_dummy);						\u
   } while (0)p #elsetO # define FREE_VARIABLES() ((void)0) /* Do nothing!  But inhibit gcc warning. */ # #endif /* not MATCH_MAY_ALLOCATE */f  F /* These values must meet several constraints.  They must not be validC    register values; since we have a limit of 255 registers (becausecG    we use only one byte in the pattern for the register number), we canIB    use numbers larger than 255.  They must differ by 1, because ofG    NUM_FAILURE_ITEMS above.  And the value for the lowest register mustdF    be larger than the value for the highest register, so we do not try;    to actually save any registers when none are active.  */f. #define NO_HIGHEST_ACTIVE_REG (1 << BYTEWIDTH)8 #define NO_LOWEST_ACTIVE_REG (NO_HIGHEST_ACTIVE_REG + 1) u /* Matching routines.  */   - #ifndef emacs   /* Emacs never uses this.  */ H /* re_match is like re_match_2 except it takes only a single string.  */   int ( re_match (bufp, string, size, pos, regs)$      struct re_pattern_buffer *bufp;      const char *string;      int size, pos;       struct re_registers *regs;E {_@   int result = re_match_2_internal (bufp, NULL, 0, string, size, 				    pos, regs, size);t # ifndef REGEX_MALLOC  #  ifdef C_ALLOCA 
   alloca (0);i #  endif # endifu   return result; }e
 # ifdef _LIBCe! weak_alias (__re_match, re_match)  # endifa #endif /* not emacs */  F static boolean group_match_null_string_p _RE_ARGS ((unsigned char **p, 						    unsigned char *end,_% 						register_info_type *reg_info)); C static boolean alt_match_null_string_p _RE_ARGS ((unsigned char *p,  						  unsigned char *end,c% 						register_info_type *reg_info)); J static boolean common_op_match_null_string_p _RE_ARGS ((unsigned char **p, 							unsigned char *end,% 						register_info_type *reg_info));WD static int bcmp_translate _RE_ARGS ((const char *s1, const char *s2,$ 				     int len, char *translate));  > /* re_match_2 matches the compiled pattern in BUFP against theF    the (virtual) concatenation of STRING1 and STRING2 (of length SIZE1@    and SIZE2, respectively).  We start matching at POS, and stop    matching at STOP.  D    If REGS is non-null and the `no_sub' field of BUFP is nonzero, weG    store offsets for the substring each group matched in REGS.  See thes5    documentation for exactly how many groups we fill.r  A    We return -1 if no match, -2 if an internal error (such as the F    failure stack overflowing).  Otherwise, we return the length of the    matched substring.  */s   intnB re_match_2 (bufp, string1, size1, string2, size2, pos, regs, stop)$      struct re_pattern_buffer *bufp;#      const char *string1, *string2;s      int size1, size2;
      int pos;       struct re_registers *regs;p      int stop; {wI   int result = re_match_2_internal (bufp, string1, size1, string2, size2,  				    pos, regs, stop);  #ifndef REGEX_MALLOC # ifdef C_ALLOCA
   alloca (0);( # endif_ #endif   return result; }  #ifdef _LIBC% weak_alias (__re_match_2, re_match_2)  #endif  E /* This is a separate function so that we can force an alloca cleanup     afterwards.  */
 static intK re_match_2_internal (bufp, string1, size1, string2, size2, pos, regs, stop) $      struct re_pattern_buffer *bufp;#      const char *string1, *string2;(      int size1, size2;
      int pos;       struct re_registers *regs;       int stop; {    /* General temporaries.  */s   int mcnt;    unsigned char *p1;  7   /* Just past the end of the corresponding string.  */o   const char *end1, *end2;  H   /* Pointers into string1 and string2, just past the last characters in#      each to consider matching.  */ (   const char *end_match_1, *end_match_2;  E   /* Where we are in the data, and the end of the current string.  */d   const char *d, *dend;u  A   /* Where we are in the pattern, and the end of the pattern.  */p"   unsigned char *p = bufp->buffer;0   register unsigned char *pend = p + bufp->used;  E   /* Mark the opcode just after a start_memory, so we can test for an 9      empty subpattern when we get to the stop_memory.  */m)   unsigned char *just_past_start_mem = 0;   :   /* We use this to map every character in the string.  */0   RE_TRANSLATE_TYPE translate = bufp->translate;  G   /* Failure point stack.  Each place that can handle a failure further*H      down the line pushes a failure point on this stack.  It consists ofE      restart, regend, and reg_info for all registers corresponding toeG      the subexpressions we're currently inside, plus the number of such F      registers, and, finally, two char *'s.  The first char * is whereF      to resume scanning the pattern; the second one is where to resumeG      scanning the strings.  If the latter is zero, the failure point iscH      a ``dummy''; if a failure happens and the failure point is a dummy,:      it gets discarded and the next next one is tried.  */; #ifdef MATCH_MAY_ALLOCATE /* otherwise, this is global.  */    fail_stack_type fail_stack;j #endif #ifdef DEBUG!   static unsigned failure_id = 0;`B   unsigned nfailure_points_pushed = 0, nfailure_points_popped = 0; #endif   #ifdef REL_ALLOC6   /* This holds the pointer to the failure stack, when%      it is allocated relocatably.  */t&   fail_stack_elt_t *failure_stack_ptr; #endif  A   /* We fill all the registers internally, independent of what we A      return, for use in backreferences.  The number here includesa&      an element for register zero.  */&   size_t num_regs = bufp->re_nsub + 1;  (   /* The currently active registers.  */8   active_reg_t lowest_active_reg = NO_LOWEST_ACTIVE_REG;:   active_reg_t highest_active_reg = NO_HIGHEST_ACTIVE_REG;  F   /* Information on the contents of registers. These are pointers intoB      the input strings; they record just what was matched (on thisB      attempt) by a subexpression part of the pattern, that is, theG      regnum-th regstart pointer points to where in the pattern we begansE      matching and the regnum-th regend points to right after where we H      stopped matching the regnum-th subexpression.  (The zeroth register8      keeps track of what the whole pattern matches.)  */= #ifdef MATCH_MAY_ALLOCATE /* otherwise, these are global.  */ "   const char **regstart, **regend; #endif  F   /* If a group that's operated upon by a repetition operator fails toD      match anything, then the register for its start will need to beH      restored because it will have been set to wherever in the string weC      are when we last see its open-group operator.  Similarly for aG      register's end.  */= #ifdef MATCH_MAY_ALLOCATE /* otherwise, these are global.  */o*   const char **old_regstart, **old_regend; #endif  K   /* The is_active field of reg_info helps us keep track of which (possiblykF      nested) subexpressions we are currently in. The matched_somethingD      field of reg_info[reg_num] helps us tell whether or not we haveG      matched any of the pattern so far this time through the reg_num-thiE      subexpression.  These two fields get reset each time through anyt#      loop their register is in.  */*; #ifdef MATCH_MAY_ALLOCATE /* otherwise, this is global.  */E   register_info_type *reg_info;  #endif  A   /* The following record the register info as found in the abovecF      variables when we find a match better than any we've seen before.F      This happens as we backtrack through the failure points, which inG      turn happens only if we have not yet matched the entire string. */.!   unsigned best_regs_set = false;c= #ifdef MATCH_MAY_ALLOCATE /* otherwise, these are global.  */l,   const char **best_regstart, **best_regend; #endif  G   /* Logically, this is `best_regend[0]'.  But we don't want to have tosG      allocate space for that if we're not allocating space for anythinghE      else (see below).  Also, we never need info about register 0 for G      any of the other register vectors, and it seems rather a kludge toeH      treat `best_regend' differently than the rest.  So we keep track ofA      the end of the best match so far in a separate variable.  We;E      initialize this to NULL so that when we backtrack the first timeO/      and need to test it, it's not garbage.  */e   const char *match_end = NULL;>  @   /* This helps SET_REGS_MATCHED avoid doing redundant work.  */    int set_regs_matched_done = 0;  5   /* Used when we pop values we don't care about.  */0= #ifdef MATCH_MAY_ALLOCATE /* otherwise, these are global.  */e   const char **reg_dummy; %   register_info_type *reg_info_dummy;  #endif   #ifdef DEBUG5   /* Counts the total number of registers pushed.  */s   unsigned num_regs_pushed = 0;  #endif  .   DEBUG_PRINT1 ("\n\nEntering re_match_2.\n");     INIT_FAIL_STACK ();n   #ifdef MATCH_MAY_ALLOCATEaH   /* Do not bother to initialize all the register variables if there areE      no groups in the pattern, as it takes a fair amount of time.  IfrA      there are groups, we include space for register 0 (the wholeaC      pattern), even though we never use it, since it simplifies theb-      array indexing.  We should fix this.  */n   if (bufp->re_nsub)     {I7       regstart = REGEX_TALLOC (num_regs, const char *);O5       regend = REGEX_TALLOC (num_regs, const char *);h;       old_regstart = REGEX_TALLOC (num_regs, const char *);a9       old_regend = REGEX_TALLOC (num_regs, const char *);S<       best_regstart = REGEX_TALLOC (num_regs, const char *);:       best_regend = REGEX_TALLOC (num_regs, const char *);=       reg_info = REGEX_TALLOC (num_regs, register_info_type);F8       reg_dummy = REGEX_TALLOC (num_regs, const char *);C       reg_info_dummy = REGEX_TALLOC (num_regs, register_info_type);a  H       if (!(regstart && regend && old_regstart && old_regend && reg_infoL             && best_regstart && best_regend && reg_dummy && reg_info_dummy))	         {            FREE_VARIABLES ();           return -2;	         }      }s   else     {s>       /* We must initialize all our variables to NULL, so that7          `FREE_VARIABLES' doesn't try to free them.  */ C       regstart = regend = old_regstart = old_regend = best_regstarts)         = best_regend = reg_dummy = NULL; >       reg_info = reg_info_dummy = (register_info_type *) NULL;     }t #endif /* MATCH_MAY_ALLOCATE */n  (   /* The starting position is bogus.  */%   if (pos < 0 || pos > size1 + size2)o     {a       FREE_VARIABLES ();       return -1;     }>  G   /* Initialize subexpression text positions to -1 to mark ones that nokD      start_memory/stop_memory has been seen for. Also initialize the%      register information struct.  */e4   for (mcnt = 1; (unsigned) mcnt < num_regs; mcnt++)     { #       regstart[mcnt] = regend[mcnt] B         = old_regstart[mcnt] = old_regend[mcnt] = REG_UNSET_VALUE;  H       REG_MATCH_NULL_STRING_P (reg_info[mcnt]) = MATCH_NULL_UNSET_VALUE;%       IS_ACTIVE (reg_info[mcnt]) = 0;(-       MATCHED_SOMETHING (reg_info[mcnt]) = 0;o2       EVER_MATCHED_SOMETHING (reg_info[mcnt]) = 0;     }b  I   /* We move `string1' into `string2' if the latter's empty -- but not if[      `string1' is null.  */f$   if (size2 == 0 && string1 != NULL)     {p       string2 = string1;       size2 = size1;       string1 = 0;       size1 = 0;     }e   end1 = string1 + size1;r   end2 = string2 + size2;e  @   /* Compute where to stop matching, within the two strings.  */   if (stop <= size1)     {r#       end_match_1 = string1 + stop;-       end_match_2 = string2;     }r   else     {        end_match_1 = end1; +       end_match_2 = string2 + stop - size1;a     }r  A   /* `p' scans through the pattern as `d' scans through the data.mG      `dend' is the end of the input string that `d' points within.  `d'nH      is advanced into the following input string whenever necessary, butE      this happens before fetching; therefore, at the beginning of theeD      loop, `d' can be pointing at the end of a string, but it cannot      equal `string2'.  */d    if (size1 > 0 && pos <= size1)     {e       d = string1 + pos;       dend = end_match_1;o     }a   else     {-        d = string2 + pos - size1;       dend = end_match_2;      }   .   DEBUG_PRINT1 ("The compiled pattern is:\n");/   DEBUG_PRINT_COMPILED_PATTERN (bufp, p, pend); -   DEBUG_PRINT1 ("The string to match is: `");n@   DEBUG_PRINT_DOUBLE_STRING (d, string1, size1, string2, size2);   DEBUG_PRINT1 ("'\n");   F   /* This loops over pattern commands.  It exits by returning from theH      function if the match is complete, or it drops through if the match8      fails at this starting point in the input data.  */
   for (;;)     {  #ifdef _LIBC!       DEBUG_PRINT2 ("\n%p: ", p);  #elset#       DEBUG_PRINT2 ("\n0x%x: ", p);  #endif         if (p == pend)7 	{ /* End of pattern means we might have succeeded.  */i/           DEBUG_PRINT1 ("end of pattern ... ");   > 	  /* If we haven't matched the entire string, and we want the1              longest match, try backtracking.  */(           if (d != end_match_2)  	    {F 	      /* 1 if this match ends in the same string (string1 or string2)" 		 as the best previous match.  */7 	      boolean same_str_p = (FIRST_STRING_P (match_end) % 				    == MATCHING_IN_FIRST_STRING);*6 	      /* 1 if this match is the best seen so far.  */ 	      boolean best_match_p;  : 	      /* AIX compiler got confused when this was combined% 		 with the previous declaration.  */  	      if (same_str_p) 		best_match_p = d > match_end;2 	      else	+ 		best_match_p = !MATCHING_IN_FIRST_STRING;C  /               DEBUG_PRINT1 ("backtracking.\n");e  '               if (!FAIL_STACK_EMPTY ())p4                 { /* More failure points to try.  */  ?                   /* If exceeds best match so far, save it.  */ 5                   if (!best_regs_set || best_match_p)a                     {e+                       best_regs_set = true;t$                       match_end = d;  H                       DEBUG_PRINT1 ("\nSAVING match as best so far.\n");  H                       for (mcnt = 1; (unsigned) mcnt < num_regs; mcnt++)                         {`?                           best_regstart[mcnt] = regstart[mcnt];d;                           best_regend[mcnt] = regend[mcnt];\                         }                      }g                   goto fail;                 }o  E               /* If no failure points, don't restore garbage.  And ifID                  last match is real best match, don't restore second                  best one. */ 6               else if (best_regs_set && !best_match_p)                 {    	        restore_best_regs:	E                   /* Restore best match.  It may happen that `dend ===E                      end_match_1' while the restored d is in string2.iC                      For example, the pattern `x.*y.*z' against the D                      strings `x-' and `y-z-', if the two strings are3                      not consecutive in memory.  */ ?                   DEBUG_PRINT1 ("Restoring best registers.\n");'                      d = match_end;5                   dend = ((d >= string1 && d <= end1)T* 		           ? end_match_1 : end_match_2);  6 		  for (mcnt = 1; (unsigned) mcnt < num_regs; mcnt++) 		    {t- 		      regstart[mcnt] = best_regstart[mcnt];o) 		      regend[mcnt] = best_regend[mcnt];i 		    };                 }b$             } /* d != end_match_2 */   	succeed_label:t.           DEBUG_PRINT1 ("Accepting match.\n");  D           /* If caller wants register contents data back, do it.  */$           if (regs && !bufp->no_sub) 	    {B               /* Have the register data arrays been allocated?  */;               if (bufp->regs_allocated == REGS_UNALLOCATED)fD                 { /* No.  So allocate them with malloc.  We need oneH                      extra element beyond `num_regs' for the `-1' marker'                      GNU code uses.  */ @                   regs->num_regs = MAX (RE_NREGS, num_regs + 1);B                   regs->start = TALLOC (regs->num_regs, regoff_t);@                   regs->end = TALLOC (regs->num_regs, regoff_t);?                   if (regs->start == NULL || regs->end == NULL)	 		    {R 		      FREE_VARIABLES (); 		      return -2; 		    }	9                   bufp->regs_allocated = REGS_REALLOCATE;t                 } ?               else if (bufp->regs_allocated == REGS_REALLOCATE)	E                 { /* Yes.  If we need more elements than were already	H                      allocated, reallocate them.  If we need fewer, just(                      leave it alone.  */4                   if (regs->num_regs < num_regs + 1)                     {i4                       regs->num_regs = num_regs + 1;G                       RETALLOC (regs->start, regs->num_regs, regoff_t);tE                       RETALLOC (regs->end, regs->num_regs, regoff_t);nC                       if (regs->start == NULL || regs->end == NULL)  			{ 			  FREE_VARIABLES ();e 			  return -2;b 			}                     }h                 }                else 		{c@ 		  /* These braces fend off a "empty body in an else-statement"< 		     warning under GCC when assert expands to nothing.  */0 		  assert (bufp->regs_allocated == REGS_FIXED); 		}s  G               /* Convert the pointer data in `regstart' and `regend' tokC                  indices.  Register zero has to be set differently,tD                  since we haven't kept track of any info for it.  */%               if (regs->num_regs > 0)s                 {r'                   regs->start[0] = pos;t:                   regs->end[0] = (MATCHING_IN_FIRST_STRING" 				  ? ((regoff_t) (d - string1))3 			          : ((regoff_t) (d - string2 + size1)));f                 }n  F               /* Go through the first `min (num_regs, regs->num_regs)'A                  registers, since that is all we initialized.  */pG 	      for (mcnt = 1; (unsigned) mcnt < MIN (num_regs, regs->num_regs);i 		   mcnt++) 		{_M                   if (REG_UNSET (regstart[mcnt]) || REG_UNSET (regend[mcnt])) =                     regs->start[mcnt] = regs->end[mcnt] = -1;o                   else                     {g 		      regs->start[mcnt] 3 			= (regoff_t) POINTER_TO_OFFSET (regstart[mcnt]);_%                       regs->end[mcnt]n1 			= (regoff_t) POINTER_TO_OFFSET (regend[mcnt]);	                     }r 		}t  G               /* If the regs structure we return has more elements thantG                  were in the pattern, set the extra elements to -1.  IfdB                  we (re)allocated the registers, this is the case,G                  because we always allocate enough to have at least onen#                  -1 at the end.  */sM               for (mcnt = num_regs; (unsigned) mcnt < regs->num_regs; mcnt++)w9                 regs->start[mcnt] = regs->end[mcnt] = -1;f" 	    } /* regs && !bufp->no_sub */  M           DEBUG_PRINT4 ("%u failure points pushed, %u popped (%u remain).\n",sG                         nfailure_points_pushed, nfailure_points_popped, I                         nfailure_points_pushed - nfailure_points_popped);rC           DEBUG_PRINT2 ("%u registers pushed.\n", num_regs_pushed);   4           mcnt = d - pos - (MATCHING_IN_FIRST_STRING 			    ? string1 			    : string2 - size1);  A           DEBUG_PRINT2 ("Returning %d from re_match_2.\n", mcnt);f             FREE_VARIABLES ();           return mcnt;	         }   2       /* Otherwise match next pattern command.  */4       switch (SWITCH_ENUM_CAST ((re_opcode_t) *p++)) 	{C         /* Ignore these.  Used to ignore the n of succeed_n's whichi%            currently have n == 0.  */          case no_op:p.           DEBUG_PRINT1 ("EXECUTING no_op.\n");           break;   	case succeed:0           DEBUG_PRINT1 ("EXECUTING succeed.\n"); 	  goto succeed_label;  F         /* Match the next n pattern characters exactly.  The followingD            byte in the pattern defines n, and the n bytes after that+            are the characters to match.  */n
 	case exactn:s 	  mcnt = *p++; 8           DEBUG_PRINT2 ("EXECUTING exactn %d.\n", mcnt);  E           /* This is written out as an if-else so we don't waste timed5              testing `translate' inside the loop.  */h           if (translate) 	    {	 	      dot 		{  		  PREFETCH ();7 		  if ((unsigned char) translate[(unsigned char) *d++]i  		      != (unsigned char) *p++)                     goto fail; 		}  	      while (--mcnt); 	    } 	  elsea 	    {	 	      doa 		{  		  PREFETCH ();' 		  if (*d++ != (char) *p++) goto fail;_ 		}s 	      while (--mcnt); 	    } 	  SET_REGS_MATCHED ();            break;    G         /* Match any character except possibly a newline or a null.  */k 	case anychar:0           DEBUG_PRINT1 ("EXECUTING anychar.\n");             PREFETCH ();  J           if ((!(bufp->syntax & RE_DOT_NEWLINE) && TRANSLATE (*d) == '\n')N               || (bufp->syntax & RE_DOT_NOT_NULL && TRANSLATE (*d) == '\000')) 	    goto fail;              SET_REGS_MATCHED ();1           DEBUG_PRINT2 ("  Matched `%d'.\n", *d);u           d++;	 	  break;e     	case charset: 	case charset_not: 	  { 	    register unsigned char c;9 	    boolean not = (re_opcode_t) *(p - 1) == charset_not;h  G             DEBUG_PRINT2 ("EXECUTING charset%s.\n", not ? "_not" : "");x   	    PREFETCH (); 7 	    c = TRANSLATE (*d); /* The character to match.  */l  H             /* Cast to `unsigned' instead of `unsigned char' in case the4                bit list is a full 32 bytes long.  */( 	    if (c < (unsigned) (*p * BYTEWIDTH)3 		&& p[1 + c / BYTEWIDTH] & (1 << (c % BYTEWIDTH)))t 	      not = !not;   	    p += 1 + *p;t   	    if (!not) goto fail;s   	    SET_REGS_MATCHED ();;             d++; 	    break;e 	  }    C         /* The beginning of a group is represented by start_memory.eJ            The arguments are the register number in the next byte, and theD            number of groups inner to this one in the next.  The text@            matched within the group is recorded (in the internalC            registers data structure) under the register number.  */          case start_memory:@ 	  DEBUG_PRINT3 ("EXECUTING start_memory %d (%d):\n", *p, p[1]);  C           /* Find out if this group can match the empty string.  */s8 	  p1 = p;		/* To send to group_match_null_string_p.  */  O           if (REG_MATCH_NULL_STRING_P (reg_info[*p]) == MATCH_NULL_UNSET_VALUE)m2             REG_MATCH_NULL_STRING_P (reg_info[*p])@               = group_match_null_string_p (&p1, pend, reg_info);  H           /* Save the position in the string where we were the last timeE              we were at this open-group operator in case the group is*H              operated upon by a repetition operator, e.g., with `(a*)*b'E              against `ab'; then we want to ignore where we are now inw@              the string in case this attempt to match fails.  */C           old_regstart[*p] = REG_MATCH_NULL_STRING_P (reg_info[*p])aJ                              ? REG_UNSET (regstart[*p]) ? d : regstart[*p],                              : regstart[*p];( 	  DEBUG_PRINT2 ("  old_regstart: %d\n",* 			 POINTER_TO_OFFSET (old_regstart[*p]));             regstart[*p] = d;iG 	  DEBUG_PRINT2 ("  regstart: %d\n", POINTER_TO_OFFSET (regstart[*p]));i  '           IS_ACTIVE (reg_info[*p]) = 1;s/           MATCHED_SOMETHING (reg_info[*p]) = 0;   E 	  /* Clear this whenever we change the register activity status.  */  	  set_regs_matched_done = 0;h  9           /* This is the new highest active register.  */d"           highest_active_reg = *p;  H           /* If nothing was active before, this is the new lowest active              register.  */8           if (lowest_active_reg == NO_LOWEST_ACTIVE_REG)#             lowest_active_reg = *p;f  E           /* Move past the register number and inner group count.  */            p += 2;n 	  just_past_start_mem = p;c             break;    E         /* The stop_memory opcode represents the end of a group.  ItshA            arguments are the same as start_memory's: the registert6            number, and the number of inner groups.  */ 	case stop_memory:? 	  DEBUG_PRINT3 ("EXECUTING stop_memory %d (%d):\n", *p, p[1]);a  I           /* We need to save the string position the last time we were atoD              this close-group operator in case the group is operatedF              upon by a repetition operator, e.g., with `((a*)*(b*)*)*'F              against `aba'; then we want to ignore where we are now in@              the string in case this attempt to match fails.  */A           old_regend[*p] = REG_MATCH_NULL_STRING_P (reg_info[*p])aD                            ? REG_UNSET (regend[*p]) ? d : regend[*p] 			   : regend[*p];r* 	  DEBUG_PRINT2 ("      old_regend: %d\n",( 			 POINTER_TO_OFFSET (old_regend[*p]));             regend[*p] = d;dG 	  DEBUG_PRINT2 ("      regend: %d\n", POINTER_TO_OFFSET (regend[*p]));*  4           /* This register isn't active anymore.  */'           IS_ACTIVE (reg_info[*p]) = 0;a  E 	  /* Clear this whenever we change the register activity status.  */d 	  set_regs_matched_done = 0;r  D           /* If this was the only register active, nothing is active              anymore.  */ 6           if (lowest_active_reg == highest_active_reg)
             {h7               lowest_active_reg = NO_LOWEST_ACTIVE_REG;t9               highest_active_reg = NO_HIGHEST_ACTIVE_REG;a
             },           elseH             { /* We must scan for the new highest active register, sinceA                  it isn't necessarily one less than now: considerTG                  (a(b)c(d(e)f)g).  When group 3 ends, after the f), thec6                  new highest active register is 1.  */'               unsigned char r = *p - 1;R7               while (r > 0 && !IS_ACTIVE (reg_info[r]))r                 r--;  H               /* If we end up at register zero, that means that we savedI                  the registers as the result of an `on_failure_jump', not F                  a `start_memory', and we jumped to past the innermost?                  `stop_memory'.  For example, in ((.)*) we saveeH                  registers 1 and 2 as a result of the *, but when we popC                  back to the second ), we are at the stop_memory 1. -                  Thus, nothing is active.  */e 	      if (r == 0)                 { ;                   lowest_active_reg = NO_LOWEST_ACTIVE_REG;s=                   highest_active_reg = NO_HIGHEST_ACTIVE_REG;                  }r               else'                 highest_active_reg = r; 
             }e  F           /* If just failed to match something this time around with aF              group that's operated on by a repetition operator, try toC              force exit from the ``loop'', and restore the register F              information for this group that we had before trying this              last match.  */0           if ((!MATCHED_SOMETHING (reg_info[*p])/                || just_past_start_mem == p - 1)  	      && (p + 2) < pend)t
             {m*               boolean is_a_jump_n = false;                 p1 = p + 2;]               mcnt = 0; *               switch ((re_opcode_t) *p1++)                 {                    case jump_n: 		    is_a_jump_n = true;N(                   case pop_failure_jump: 		  case maybe_pop_jump: 		  case jump: 		  case dummy_failure_jump:7                     EXTRACT_NUMBER_AND_INCR (mcnt, p1);o 		    if (is_a_jump_n) 		      p1 += 2;                     break;                     default:&                     /* do nothing */ ;                 }t 	      p1 += mcnt;  I               /* If the next operation is a jump backwards in the patternz= 	         to an on_failure_jump right before the start_memorymF                  corresponding to this stop_memory, exit from the loopD                  by forcing a failure after pushing on the stack theB                  on_failure_jump's jump in the pattern, and d.  */B               if (mcnt < 0 && (re_opcode_t) *p1 == on_failure_jumpH                   && (re_opcode_t) p1[3] == start_memory && p1[4] == *p) 		{aF                   /* If this group ever matched anything, then restoreD                      what its registers were before trying this lastG                      failed match, e.g., with `(a*)*b' against `ab' for A                      regstart[1], and, e.g., with `((a*)*(b*)*)*' 1                      against `aba' for regend[3].o  E                      Also restore the registers for inner groups for, H                      e.g., `((a*)(b*))*' against `aba' (register 3 would0                      otherwise get trashed).  */  <                   if (EVER_MATCHED_SOMETHING (reg_info[*p])) 		    {n 		      unsigned r;E  @                       EVER_MATCHED_SOMETHING (reg_info[*p]) = 0;  A 		      /* Restore this and inner groups' (if any) registers.  */rK                       for (r = *p; r < (unsigned) *p + (unsigned) *(p + 1);t
 			   r++)                         {n8                           regstart[r] = old_regstart[r];  2                           /* xx why this test?  */;                           if (old_regend[r] >= regstart[r])/6                             regend[r] = old_regend[r];                         }o                     } 	 		  p1++;a5                   EXTRACT_NUMBER_AND_INCR (mcnt, p1); 8                   PUSH_FAILURE_POINT (p1 + mcnt, d, -2);                     goto fail;                 }a
             }   I           /* Move past the register number and the inner group count.  */b           p += 2;            break;    @ 	/* \<digit> has been turned into a `duplicate' command which isO            followed by the numeric value of <digit> as the register number.  */I         case duplicate:h 	  {% 	    register const char *d2, *dend2;cD 	    int regno = *p++;   /* Get which register to match against.  */7 	    DEBUG_PRINT2 ("EXECUTING duplicate %d.\n", regno);I  C 	    /* Can't back reference a group which we've never matched.  */ I             if (REG_UNSET (regstart[regno]) || REG_UNSET (regend[regno]))r               goto fail;  ;             /* Where in input to try to start matching.  */ !             d2 = regstart[regno];h  E             /* Where to stop matching; if both the place to start andtF                the place to stop matching are in the same string, thenG                set to the place to stop, otherwise, for now have to usem/                the end of the first string.  */   6             dend2 = ((FIRST_STRING_P (regstart[regno])* 		      == FIRST_STRING_P (regend[regno]))& 		     ? regend[regno] : end_match_1);
 	    for (;;)  	      {6 		/* If necessary, advance to next segment in register                     contents.  */ 		while (d2 == dend2)i 		  {i& 		    if (dend2 == end_match_2) break;( 		    if (dend2 == regend[regno]) break;  ?                     /* End of string1 => advance to string2. */ !                     d2 = string2;_*                     dend2 = regend[regno]; 		  }s. 		/* At end of register contents => success */ 		if (d2 == dend2) break;d  7 		/* If necessary, advance to next segment in data.  */d 		PREFETCH ();  ; 		/* How many characters left in this segment to match.  */s 		mcnt = dend - d;  9 		/* Want how many consecutive characters we can match in D                    one shot, so, if necessary, adjust the count.  */&                 if (mcnt > dend2 - d2) 		  mcnt = dend2 - d2;  6 		/* Compare that many; failure if mismatch, else move!                    past them.  */m 		if (translateh=                     ? bcmp_translate (d, d2, mcnt, translate) +                     : memcmp (d, d2, mcnt))a 		  goto fail; 		d += mcnt, d2 += mcnt;  5 		/* Do this because we've match some characters.  */  		SET_REGS_MATCHED (); 	      } 	  }	 	  break;     J         /* begline matches the empty string at the beginning of the string7            (unless `not_bol' is set in `bufp'), and, iff7            `newline_anchor' is set, after newlines.  */t 	case begline:0           DEBUG_PRINT1 ("EXECUTING begline.\n");  !           if (AT_STRINGS_BEG (d)) 
             {o(               if (!bufp->not_bol) break;
             } 9           else if (d[-1] == '\n' && bufp->newline_anchor) 
             {                break;
             } -           /* In all other cases, we fail.  */1           goto fail;    .         /* endline is the dual of begline.  */ 	case endline:0           DEBUG_PRINT1 ("EXECUTING endline.\n");  !           if (AT_STRINGS_END (d))L
             {=(               if (!bufp->not_eol) break;
             }e  <           /* We have to ``prefetch'' the next character.  */6           else if ((d == end1 ? *string2 : *d) == '\n'+                    && bufp->newline_anchor) 
             {                break;
             }h           goto fail;    0 	/* Match at the very beginning of the data.  */         case begbuf:/           DEBUG_PRINT1 ("EXECUTING begbuf.\n"); !           if (AT_STRINGS_BEG (d))              break;           goto fail;    * 	/* Match at the very end of the data.  */         case endbuf:/           DEBUG_PRINT1 ("EXECUTING endbuf.\n");  	  if (AT_STRINGS_END (d)) 	    break;-           goto fail;    F         /* on_failure_keep_string_jump is used to optimize `.*\n'.  ItF            pushes NULL as the value for the string on the stack.  ThenB            `pop_failure_point' will keep the current value for theA            string, instead of restoring it.  To see why, considerrG            matching `foo\nbar' against `.*\n'.  The .* matches the foo;dG            then the . fails against the \n.  But the next thing we wanteC            to do is match the \n against the \n; if we restored thes5            string value, we would be back at the foo.e  H            Because this is used only in specific cases, we don't need toD            check all the things that `on_failure_jump' does, to makeH            sure the right things get saved on the stack.  Hence we don'tC            share its code.  The only reason to push anything on thefA            stack at all is that otherwise we would have to change(D            `anychar's code to do something besides goto fail in this0            case; that seems worse than this.  */)         case on_failure_keep_string_jump:gA           DEBUG_PRINT1 ("EXECUTING on_failure_keep_string_jump");[  ,           EXTRACT_NUMBER_AND_INCR (mcnt, p); #ifdef _LIBC:           DEBUG_PRINT3 (" %d (to %p):\n", mcnt, p + mcnt); #else <           DEBUG_PRINT3 (" %d (to 0x%x):\n", mcnt, p + mcnt); #endif  2           PUSH_FAILURE_POINT (p + mcnt, NULL, -2);           break;     	/* Uses of on_failure_jump:  F            Each alternative starts with an on_failure_jump that pointsF            to the beginning of the next alternative.  Each alternativeE            except the last ends with a jump that in effect jumps past B            the rest of the alternatives.  (They really jump to theG            ending jump of the following alternative, because tensioning $            these jumps is a hassle.)  F            Repeats start with an on_failure_jump that points past both?            the repetition text and either the following jump orb=            pop_failure_jump back to this on_failure_jump.  */s 	case on_failure_jump:         on_failure: 5           DEBUG_PRINT1 ("EXECUTING on_failure_jump");p  ,           EXTRACT_NUMBER_AND_INCR (mcnt, p); #ifdef _LIBC7           DEBUG_PRINT3 (" %d (to %p)", mcnt, p + mcnt);  #else\9           DEBUG_PRINT3 (" %d (to 0x%x)", mcnt, p + mcnt);I #endif  F           /* If this on_failure_jump comes right before a group (i.e.,E              the original * applied to a group), save the informationVG              for that group and all inner ones, so that if we fail backtD              to this point, the group's information will be correct.D              For example, in \(a*\)*\1, we need the preceding group,B              and in \(zz\(a*\)b*\)\2, we need the inner group.  */  <           /* We can't use `p' to check ahead because we push@              a failure point to `p + mcnt' after we do this.  */           p1 = p;g  ;           /* We need to skip no_op's before we look for thecF              start_memory in case this on_failure_jump is happening asG              the result of a completed succeed_n, as in \(a\)\{1,3\}b\1               against aba.  */ 9           while (p1 < pend && (re_opcode_t) *p1 == no_op)              p1++;   =           if (p1 < pend && (re_opcode_t) *p1 == start_memory) 
             {lF               /* We have a new highest active register now.  This willF                  get reset at the start_memory we are about to get to,E                  but we will have saved all the registers relevant tof<                  this repetition op, as described above.  */9               highest_active_reg = *(p1 + 1) + *(p1 + 2);*<               if (lowest_active_reg == NO_LOWEST_ACTIVE_REG).                 lowest_active_reg = *(p1 + 1);
             }c             DEBUG_PRINT1 (":\n");o/           PUSH_FAILURE_POINT (p + mcnt, d, -2);R           break;    5         /* A smart repeat ends with `maybe_pop_jump'.b< 	   We change it to either `pop_failure_jump' or `jump'.  */         case maybe_pop_jump:,           EXTRACT_NUMBER_AND_INCR (mcnt, p);@           DEBUG_PRINT2 ("EXECUTING maybe_pop_jump %d.\n", mcnt);           {M$ 	    register unsigned char *p2 = p;  C             /* Compare the beginning of the repeat with what in theeF                pattern follows its end. If we can establish that thereC                is nothing that they would both match, i.e., that we_F                would have to backtrack because of (as in, e.g., `a*a')D                then we can change to pop_failure_jump, because we'll'                never have to backtrack.   ?                This is not true in the case of alternatives: in H                `(a|ab)*' we do need to backtrack to the `ab' alternativeH                (e.g., if the string was `ab').  But instead of trying toC                detect that here, the alternative has put on a dummy F                failure point which is what we will end up popping.  */  , 	    /* Skip over open/close-group commands.6 	       If what follows this loop is a ...+ construct,; 	       look at what begins its body, since we will have toh' 	       match at least one of that.  */  	    while (1) 	      { 		if (p2 + 2 < pends* 		    && ((re_opcode_t) *p2 == stop_memory) 			|| (re_opcode_t) *p2 == start_memory))% 		  p2 += 3; 		else if (p2 + 6 < pend/ 			 && (re_opcode_t) *p2 == dummy_failure_jump)  		  p2 += 6; 		else
 		  break; 	      }   	    p1 = p + mcnt; ? 	    /* p1[0] ... p1[2] are the `on_failure_jump' correspondingU@ 	       to the `maybe_finalize_jump' of this case.  Examine what 	       follows.  */  E             /* If we're at the end of the pattern, we can change.  */i             if (p2 == pend)e 	      {2 		/* Consider what happens when matching ":\(.*\)"7 		   against ":/".  I don't really understand this code 
 		   yet.  */a4   	        p[-3] = (unsigned char) pop_failure_jump;                 DEBUG_PRINT1H                   ("  End of pattern: change to `pop_failure_jump'.\n");               }l  0             else if ((re_opcode_t) *p2 == exactnA 		     || (bufp->newline_anchor && (re_opcode_t) *p2 == endline))  	      { 		register unsigned char cB                   = *p2 == (unsigned char) endline ? '\n' : p2[2];  @                 if ((re_opcode_t) p1[3] == exactn && p1[5] != c)                   {"1   		    p[-3] = (unsigned char) pop_failure_jump;)F                     DEBUG_PRINT3 ("  %c != %c => pop_failure_jump.\n",,                                   c, p1[5]);                   }   ) 		else if ((re_opcode_t) p1[3] == charseta* 			 || (re_opcode_t) p1[3] == charset_not) 		  {g3 		    int not = (re_opcode_t) p1[3] == charset_not;r  1 		    if (c < (unsigned char) (p1[4] * BYTEWIDTH),5 			&& p1[5 + c / BYTEWIDTH] & (1 << (c % BYTEWIDTH)))  		      not = !not;e  H                     /* `not' is equal to 1 if c would match, which meansE                         that we can't change to pop_failure_jump.  */* 		    if (!not)=                       {m5   		        p[-3] = (unsigned char) pop_failure_jump;eK                         DEBUG_PRINT1 ("  No match => pop_failure_jump.\n");e                       }t 		  }s 	      }2             else if ((re_opcode_t) *p2 == charset) 	      { #ifdef DEBUG 		register unsigned char cB                   = *p2 == (unsigned char) endline ? '\n' : p2[2]; #endif   #if 0t1                 if ((re_opcode_t) p1[3] == exactnr1 		    && ! ((int) p2[1] * BYTEWIDTH > (int) p1[5] " 			  && (p2[2 + p1[5] / BYTEWIDTH]( 			      & (1 << (p1[5] % BYTEWIDTH))))) #else`1                 if ((re_opcode_t) p1[3] == exactn 1 		    && ! ((int) p2[1] * BYTEWIDTH > (int) p1[4] " 			  && (p2[2 + p1[4] / BYTEWIDTH]( 			      & (1 << (p1[4] % BYTEWIDTH))))) #endif                   {?1   		    p[-3] = (unsigned char) pop_failure_jump;eF                     DEBUG_PRINT3 ("  %c != %c => pop_failure_jump.\n",,                                   c, p1[5]);                   }I  . 		else if ((re_opcode_t) p1[3] == charset_not) 		  {) 		    int idx;2 		    /* We win if the charset_not inside the loop? 		       lists every character listed in the charset after.  */c- 		    for (idx = 0; idx < (int) p2[1]; idx++)t 		      if (! (p2[2 + idx] == 0  			     || (idx < (int) p1[4]i/ 				 && ((p2[2 + idx] & ~ p1[5 + idx]) == 0))))o	 			break;    		    if (idx == p2[1])e                       { 5   		        p[-3] = (unsigned char) pop_failure_jump;WK                         DEBUG_PRINT1 ("  No match => pop_failure_jump.\n");                        }  		  } * 		else if ((re_opcode_t) p1[3] == charset) 		  {i 		    int idx;. 		    /* We win if the charset inside the loop8 		       has no overlap with the one after the loop.  */ 		    for (idx = 0;f+ 			 idx < (int) p2[1] && idx < (int) p1[4];t
 			 idx++)- 		      if ((p2[2 + idx] & p1[5 + idx]) != 0) 	 			break;   ' 		    if (idx == p2[1] || idx == p1[4])_                       { 5   		        p[-3] = (unsigned char) pop_failure_jump;oK                         DEBUG_PRINT1 ("  No match => pop_failure_jump.\n");n                       }  		  }  	      } 	  }3 	  p -= 2;		/* Point at relative address again.  */ / 	  if ((re_opcode_t) p[-1] != pop_failure_jump)  	    {$ 	      p[-1] = (unsigned char) jump;2               DEBUG_PRINT1 ("  Match => jump.\n"); 	      goto unconditional_jump;t 	    }!         /* Note fall through.  */,    = 	/* The end of a simple repeat has a pop_failure_jump back to E            its matching on_failure_jump, where the latter will push a A            failure point.  The pop_failure_jump takes off failure <            points put on by this pop_failure_jump's matchingG            on_failure_jump; we got through the pattern to here from the 8            matching on_failure_jump, so didn't fail.  */         case pop_failure_jump:           { B             /* We need to pass separate storage for the lowest andE                highest registers, even though we don't care about the B                actual values.  Otherwise, we will restore only oneG                register from the stack, since lowest will == highest ine'                `pop_failure_point'.  */a7             active_reg_t dummy_low_reg, dummy_high_reg; "             unsigned char *pdummy;             const char *sdummy;   ;             DEBUG_PRINT1 ("EXECUTING pop_failure_jump.\n");_.             POP_FAILURE_POINT (sdummy, pdummy,=                                dummy_low_reg, dummy_high_reg,fE                                reg_dummy, reg_dummy, reg_info_dummy);            }a 	  /* Note fall through.  */   	unconditional_jump: #ifdef _LIBC 	  DEBUG_PRINT2 ("\n%p: ", p); #else*  	  DEBUG_PRINT2 ("\n0x%x: ", p); #endif#           /* Note fall through.  */   I         /* Unconditionally jump (without popping any failure points).  */i         case jump:D 	  EXTRACT_NUMBER_AND_INCR (mcnt, p);	/* Get the amount to jump.  */4           DEBUG_PRINT2 ("EXECUTING jump %d ", mcnt);$ 	  p += mcnt;				/* Do the jump.  */ #ifdef _LIBC)           DEBUG_PRINT2 ("(to %p).\n", p);  #else +           DEBUG_PRINT2 ("(to 0x%x).\n", p);t #endif	 	  break;_    F         /* We need this opcode so we can detect where alternatives end4            in `group_match_null_string_p' et al.  */         case jump_past_alt: 6           DEBUG_PRINT1 ("EXECUTING jump_past_alt.\n");"           goto unconditional_jump;    F         /* Normally, the on_failure_jump pushes a failure point, whichC            then gets popped at pop_failure_jump.  We will end up attG            pop_failure_jump, also, and with a pattern of, say, `a+', we D            are skipping over the on_failure_jump, so we have to pushA            something meaningless for pop_failure_jump to pop.  */h          case dummy_failure_jump:;           DEBUG_PRINT1 ("EXECUTING dummy_failure_jump.\n");iF           /* It doesn't matter what we push for the string here.  WhatG              the code at `fail' tests is the value for the pattern.  */r.           PUSH_FAILURE_POINT (NULL, NULL, -2);"           goto unconditional_jump;    H         /* At the end of an alternative, we need to push a dummy failureI            point in case we are followed by a `pop_failure_jump', because D            we don't want the failure point for the alternative to beA            popped.  For example, matching `(a|ab)*' against `aab'o;            requires that we match the `ab' alternative.  */C          case push_dummy_failure:;           DEBUG_PRINT1 ("EXECUTING push_dummy_failure.\n"); F           /* See comments just above at `dummy_failure_jump' about the              two zeroes.  */.           PUSH_FAILURE_POINT (NULL, NULL, -2);           break;  B         /* Have to succeed matching what follows at least n times.9            After that, handle like `on_failure_jump'.  */t         case succeed_n: '           EXTRACT_NUMBER (mcnt, p + 2); ;           DEBUG_PRINT2 ("EXECUTING succeed_n %d.\n", mcnt);/             assert (mcnt >= 0);iG           /* Originally, this is how many times we HAVE to succeed.  */            if (mcnt > 0)a
             {'                mcnt--; 	       p += 2;E/                STORE_NUMBER_AND_INCR (p, mcnt);g #ifdef _LIBCC                DEBUG_PRINT3 ("  Setting %p to %d.\n", p - 2, mcnt);a #else E                DEBUG_PRINT3 ("  Setting 0x%x to %d.\n", p - 2, mcnt);p #endif
             }p 	  else if (mcnt == 0)
             {p #ifdef _LIBCL               DEBUG_PRINT2 ("  Setting two bytes from %p to no_op.\n", p+2); #elseiN               DEBUG_PRINT2 ("  Setting two bytes from 0x%x to no_op.\n", p+2); #endif$ 	      p[2] = (unsigned char) no_op;+               p[3] = (unsigned char) no_op;n               goto on_failure;
             }            break;           case jump_n:'           EXTRACT_NUMBER (mcnt, p + 2); 8           DEBUG_PRINT2 ("EXECUTING jump_n %d.\n", mcnt);  @           /* Originally, this is how many times we CAN jump.  */           if (mcnt) 
             {                 mcnt--;*                STORE_NUMBER (p + 2, mcnt); #ifdef _LIBCC                DEBUG_PRINT3 ("  Setting %p to %d.\n", p + 2, mcnt);r #else E                DEBUG_PRINT3 ("  Setting 0x%x to %d.\n", p + 2, mcnt);, #endif  	       goto unconditional_jump;
             } O           /* If don't have to jump any more, skip over the rest of command.  */  	  elsen 	    p += 4;           break;   	case set_number_at: 	  {8             DEBUG_PRINT1 ("EXECUTING set_number_at.\n");  .             EXTRACT_NUMBER_AND_INCR (mcnt, p);             p1 = p + mcnt;.             EXTRACT_NUMBER_AND_INCR (mcnt, p); #ifdef _LIBC=             DEBUG_PRINT3 ("  Setting %p to %d.\n", p1, mcnt);p #elsea?             DEBUG_PRINT3 ("  Setting 0x%x to %d.\n", p1, mcnt);, #endif 	    STORE_NUMBER (p1, mcnt);d             break;           }e   #if 0tA 	/* The DEC Alpha C compiler 3.x generates incorrect code for the C 	   test  WORDCHAR_P (d - 1) != WORDCHAR_P (d)  in the expansion ofn> 	   AT_WORD_BOUNDARY, so this code is disabled.  Expanding theG 	   macro and introducing temporary variables works around the bug.  */c   	case wordbound:+ 	  DEBUG_PRINT1 ("EXECUTING wordbound.\n");  	  if (AT_WORD_BOUNDARY (d)) 	    break; 
 	  goto fail;    	case notwordbound:l. 	  DEBUG_PRINT1 ("EXECUTING notwordbound.\n"); 	  if (AT_WORD_BOUNDARY (d)) 	    goto fail; 	 	  break;  #else  	case wordbound: 	{ 	  boolean prevchar, thischar;  + 	  DEBUG_PRINT1 ("EXECUTING wordbound.\n"); 0 	  if (AT_STRINGS_BEG (d) || AT_STRINGS_END (d)) 	    break;   ! 	  prevchar = WORDCHAR_P (d - 1);e 	  thischar = WORDCHAR_P (d);N 	  if (prevchar != thischar) 	    break; 
 	  goto fail;e 	}         case notwordbound: 	{ 	  boolean prevchar, thischar;  . 	  DEBUG_PRINT1 ("EXECUTING notwordbound.\n");0 	  if (AT_STRINGS_BEG (d) || AT_STRINGS_END (d)) 	    goto fail;n  ! 	  prevchar = WORDCHAR_P (d - 1);  	  thischar = WORDCHAR_P (d);  	  if (prevchar != thischar) 	    goto fail;n	 	  break;t 	} #endif   	case wordbeg:0           DEBUG_PRINT1 ("EXECUTING wordbeg.\n");E 	  if (WORDCHAR_P (d) && (AT_STRINGS_BEG (d) || !WORDCHAR_P (d - 1)))f 	    break;            goto fail;   	case wordend:0           DEBUG_PRINT1 ("EXECUTING wordend.\n");0 	  if (!AT_STRINGS_BEG (d) && WORDCHAR_P (d - 1)9               && (!WORDCHAR_P (d) || AT_STRINGS_END (d)))r 	    break;_           goto fail;   #ifdef emacs   	case before_dot:L3           DEBUG_PRINT1 ("EXECUTING before_dot.\n"); 4  	  if (PTR_CHAR_POS ((unsigned char *) d) >= point)   	    goto fail;    	  break;e     	case at_dot: /           DEBUG_PRINT1 ("EXECUTING at_dot.\n");n4  	  if (PTR_CHAR_POS ((unsigned char *) d) != point)   	    goto fail;l   	  break;      	case after_dot:2           DEBUG_PRINT1 ("EXECUTING after_dot.\n");:           if (PTR_CHAR_POS ((unsigned char *) d) <= point)   	    goto fail;f   	  break;    	case syntaxspec:u<           DEBUG_PRINT2 ("EXECUTING syntaxspec %d.\n", mcnt); 	  mcnt = *p++;h 	  goto matchsyntax;           case wordchar:7           DEBUG_PRINT1 ("EXECUTING Emacs wordchar.\n");n 	  mcnt = (int) Sword;         matchsyntax: 	  PREFETCH ();g= 	  /* Can't use *d++ here; SYNTAX may be an unsafe macro.  */v 	  d++;g0 	  if (SYNTAX (d[-1]) != (enum syntaxcode) mcnt) 	    goto fail;            SET_REGS_MATCHED ();	 	  break;n   	case notsyntaxspec:?           DEBUG_PRINT2 ("EXECUTING notsyntaxspec %d.\n", mcnt);G 	  mcnt = *p++;s 	  goto matchnotsyntax;            case notwordchar:n:           DEBUG_PRINT1 ("EXECUTING Emacs notwordchar.\n"); 	  mcnt = (int) Sword;         matchnotsyntax:N 	  PREFETCH ();)= 	  /* Can't use *d++ here; SYNTAX may be an unsafe macro.  */( 	  d++; 0 	  if (SYNTAX (d[-1]) == (enum syntaxcode) mcnt) 	    goto fail;  	  SET_REGS_MATCHED ();            break;   #else /* not emacs */  	case wordchar: ;           DEBUG_PRINT1 ("EXECUTING non-Emacs wordchar.\n");  	  PREFETCH ();t           if (!WORDCHAR_P (d))             goto fail; 	  SET_REGS_MATCHED ();i           d++;	 	  break;t   	case notwordchar:>           DEBUG_PRINT1 ("EXECUTING non-Emacs notwordchar.\n"); 	  PREFETCH ();  	  if (WORDCHAR_P (d))             goto fail;           SET_REGS_MATCHED ();           d++;	 	  break;t #endif /* not emacs */           default:           abort ();e 	}N       continue;  /* Successfully executed one pattern command; keep going.  */    5     /* We goto here if a matching operation fails. */ 	     fail:        if (!FAIL_STACK_EMPTY ());; 	{ /* A restart point is known.  Restore to that state.  */p%           DEBUG_PRINT1 ("\nFAIL:\n");N"           POP_FAILURE_POINT (d, p,C                              lowest_active_reg, highest_active_reg, 9                              regstart, regend, reg_info);o  D           /* If this failure point is a dummy, try the next one.  */           if (!p)a 	    goto fail;   J           /* If we failed to the end of the pattern, don't examine *p.  */ 	  assert (p <= pend);           if (p < pend)u
             { *               boolean is_a_jump_n = false;  J               /* If failed to a backwards jump that's part of a repetitionO                  loop, need to pop this failure point and use the next one.  */g'               switch ((re_opcode_t) *p)b                 {h                 case jump_n:%                   is_a_jump_n = true;n$                 case maybe_pop_jump:&                 case pop_failure_jump:                 case jump:                   p1 = p + 1;d5                   EXTRACT_NUMBER_AND_INCR (mcnt, p1);                    p1 += mcnt;o  E                   if ((is_a_jump_n && (re_opcode_t) *p1 == succeed_n)a&                       || (!is_a_jump_nC                           && (re_opcode_t) *p1 == on_failure_jump))g                     goto fail;                   break;                 default:$                   /* do nothing */ ;                 } 
             }i  (           if (d >= string1 && d <= end1) 	    dend = end_match_1;	         }=
       elseE         break;   /* Matching at this starting point really fails.  */      } /* for (;;) */     if (best_regs_set)     goto restore_best_regs;c     FREE_VARIABLES ();  0   return -1;         			/* Failure to match.  */ } /* re_match_2 */ c- /* Subroutine definitions for re_match_2.  */.    F /* We are passed P pointing to a register number after a start_memory.  E    Return true if the pattern up to the corresponding stop_memory can /    match the empty string, and false otherwise.   O    If we find the matching stop_memory, sets P to point to one past its number. D    Otherwise, sets P to an undefined byte less than or equal to END.  1    We don't handle duplicates properly (yet).  */t   static boolean, group_match_null_string_p (p, end, reg_info)     unsigned char **p, *end;!     register_info_type *reg_info;m {b   int mcnt; 5   /* Point to after the args to the start_memory.  */    unsigned char *p1 = *p + 2;      while (p1 < end)     { E       /* Skip over opcodes that can match nothing, and return true or A 	 false, as appropriate, when we get to one that can't, or to the "          matching stop_memory.  */          switch ((re_opcode_t) *p1)	         { B         /* Could be either a loop or a series of alternatives.  */         case on_failure_jump:a           p1++;w-           EXTRACT_NUMBER_AND_INCR (mcnt, p1);   A           /* If the next operation is not a jump backwards in thec 	     pattern.  */   	  if (mcnt >= 0)( 	    {E               /* Go through the on_failure_jumps of the alternatives, H                  seeing if any of the alternatives cannot match nothing.>                  The last alternative starts with only a jump,D                  whereas the rest start with on_failure_jump and endD                  with a jump, e.g., here is the pattern for `a|b|c':  B                  /on_failure_jump/0/6/exactn/1/a/jump_past_alt/0/6B                  /on_failure_jump/0/6/exactn/1/b/jump_past_alt/0/3                  /exactn/1/c  @                  So, we have to first go through the first (n-1)M                  alternatives and then deal with the last one separately.  */a    D               /* Deal with the first (n-1) alternatives, which startH                  with an on_failure_jump (see above) that jumps to right*                  past a jump_past_alt.  */  ?               while ((re_opcode_t) p1[mcnt-3] == jump_past_alt)o                 {*E                   /* `mcnt' holds how many bytes long the alternative A                      is, including the ending `jump_past_alt' and $                      its number.  */  B                   if (!alt_match_null_string_p (p1, p1 + mcnt - 3,$ 				                      reg_info))!                     return false;i  H                   /* Move to right after this alternative, including the 		     jump_past_alt.  */c                   p1 += mcnt;|  G                   /* Break if it's the beginning of an n-th alternative D                      that doesn't begin with an on_failure_jump.  */;                   if ((re_opcode_t) *p1 != on_failure_jump)                      break;  0 		  /* Still have to check that it's not an n-th; 		     alternative that starts with an on_failure_jump.  */n	 		  p1++;a5                   EXTRACT_NUMBER_AND_INCR (mcnt, p1); @                   if ((re_opcode_t) p1[mcnt-3] != jump_past_alt)                     {U< 		      /* Get to the beginning of the n-th alternative.  */                       p1 -= 3;                       break;                     }                  }G  G               /* Deal with the last alternative: go back and get numberdH                  of the `jump_past_alt' just before it.  `mcnt' contains3                  the length of the alternative.  */ ,               EXTRACT_NUMBER (mcnt, p1 - 2);  E               if (!alt_match_null_string_p (p1, p1 + mcnt, reg_info))f                 return false;   ?               p1 += mcnt;	/* Get past the n-th alternative.  */              } /* if mcnt > 0 */(           break;             case stop_memory:  	  assert (p1[1] == **p);u           *p = p1 + 2;           return true;             default:B           if (!common_op_match_null_string_p (&p1, end, reg_info))             return false; 	         }	     } /* while p1 < end */     return false;	! } /* group_match_null_string_p */i    L /* Similar to group_match_null_string_p, but doesn't deal with alternatives:H    It expects P to be the first byte of a single alternative and END one>    byte past the last. The alternative can contain groups.  */   static boolean* alt_match_null_string_p (p, end, reg_info)     unsigned char *p, *end; !     register_info_type *reg_info;[ {    int mcnt;h   unsigned char *p1 = p;     while (p1 < end)     {RH       /* Skip over opcodes that can match nothing, and break when we get          to one that can't.  */[          switch ((re_opcode_t) *p1)	         {* 	/* It's a loop.  */         case on_failure_jump:n           p1++;e-           EXTRACT_NUMBER_AND_INCR (mcnt, p1);            p1 += mcnt;&           break;  	 	default:)B           if (!common_op_match_null_string_p (&p1, end, reg_info))             return false;=	         }      }  /* while p1 < end */      return true; } /* alt_match_null_string_p */     = /* Deals with the ops common to group_match_null_string_p and.    alt_match_null_string_p.   <    Sets P to one after the op and its arguments, if any.  */   static boolean0 common_op_match_null_string_p (p, end, reg_info)     unsigned char **p, *end;!     register_info_type *reg_info;_ {N   int mcnt;=   boolean ret;
   int reg_no;d   unsigned char *p1 = *p;      switch ((re_opcode_t) *p1++)     {h     case no_op:      case begline:i     case endline:      case begbuf:     case endbuf:     case wordbeg:e     case wordend:      case wordbound:      case notwordbound: #ifdef emacs     case before_dot:     case at_dot:     case after_dot:i #endif       break;       case start_memory:       reg_no = *p1;o2       assert (reg_no > 0 && reg_no <= MAX_REGNUM);;       ret = group_match_null_string_p (&p1, end, reg_info);   C       /* Have to set this here in case we're checking a group which 9          contains a group and a back reference to it.  */   O       if (REG_MATCH_NULL_STRING_P (reg_info[reg_no]) == MATCH_NULL_UNSET_VALUE) 9         REG_MATCH_NULL_STRING_P (reg_info[reg_no]) = ret;i         if (!ret)`         return false;a       break;  K     /* If this is an optimized succeed_n for zero times, make the jump.  */;     case jump:)       EXTRACT_NUMBER_AND_INCR (mcnt, p1);N       if (mcnt >= 0)         p1 += mcnt; 
       else         return false;p       break;       case succeed_n: 3       /* Get to the number of times to succeed.  */        p1 += 2;)       EXTRACT_NUMBER_AND_INCR (mcnt, p1);          if (mcnt == 0)	         {            p1 -= 4;-           EXTRACT_NUMBER_AND_INCR (mcnt, p1);;           p1 += mcnt;T	         } 
       else         return false;a       break;       case duplicate:i3       if (!REG_MATCH_NULL_STRING_P (reg_info[*p1]))*         return false;        break;       case set_number_at:G       p1 += 4;       default:E       /* All other opcodes mean we cannot match the empty string.  */o       return false;f   }C  
   *p = p1;   return true;% } /* common_op_match_null_string_p */_    G /* Return zero if TRANSLATE[S1] and TRANSLATE[S2] are identical for LEN      bytes; nonzero otherwise.  */  
 static int' bcmp_translate (s1, s2, len, translate)       const char *s1, *s2;m      register int len;!      RE_TRANSLATE_TYPE translate;a {\@   register const unsigned char *p1 = (const unsigned char *) s1;@   register const unsigned char *p2 = (const unsigned char *) s2;
   while (len)t     {i9       if (translate[*p1++] != translate[*p2++]) return 1;,       len--;     }t   return 0;` },  ! /* Entry points for GNU code.  */o  @ /* re_compile_pattern is the GNU regular expression compiler: itA    compiles PATTERN (of length SIZE) and puts the result in BUFP.:A    Returns 0 if the pattern was valid, otherwise an error string.   H    Assumes the `allocated' (and perhaps `buffer') and `translate' fields    are set in BUFP on entry.  :    We call regex_compile to do the actual compilation.  */   const char ** re_compile_pattern (pattern, length, bufp)      const char *pattern;a      size_t length;d$      struct re_pattern_buffer *bufp; {t   reg_errcode_t ret;  J   /* GNU code is written to assume at least RE_NREGS registers will be set-      (and at least one extra will be -1).  */.*   bufp->regs_allocated = REGS_UNALLOCATED;  G   /* And GNU code determines whether or not to get register information D      by passing null for the REGS argument to re_match, etc., not by      setting no_sub.  */   bufp->no_sub = 0;t  "   /* Match anchors at newline.  */   bufp->newline_anchor = 1;   A   ret = regex_compile (pattern, length, re_syntax_options, bufp);      if (!ret)v     return NULL;-   return gettext (re_error_msgid[(int) ret]);A }r #ifdef _LIBC5 weak_alias (__re_compile_pattern, re_compile_pattern)  #endif XG /* Entry points compatible with 4.2 BSD regex library.  We don't definen*    them unless specifically requested.  */  + #if defined _REGEX_RE_COMP || defined _LIBCn  / /* BSD has one and only one pattern buffer.  */t, static struct re_pattern_buffer re_comp_buf;   char * #ifdef _LIBCF /* Make these definitions weak in libc, so POSIX programs can redefine=    these names if they don't use our functions, and still use 1    regcomp/regexec below without link errors.  */d
 weak_functionn #endif re_comp (s)      const char *s; {t   reg_errcode_t ret;  	   if (!s)C     {        if (!re_comp_buf.buffer)3 	return gettext ("No previous regular expression");        return 0;N     }S     if (!re_comp_buf.buffer)     {n:       re_comp_buf.buffer = (unsigned char *) malloc (200);%       if (re_comp_buf.buffer == NULL)nC         return (char *) gettext (re_error_msgid[(int) REG_ESPACE]); "       re_comp_buf.allocated = 200;  =       re_comp_buf.fastmap = (char *) malloc (1 << BYTEWIDTH);m&       if (re_comp_buf.fastmap == NULL)< 	return (char *) gettext (re_error_msgid[(int) REG_ESPACE]);     }   C   /* Since `re_exec' always passes NULL for the `regs' argument, we+L      don't need to initialize the pattern buffer fields which affect it.  */  #   /* Match anchors at newlines.  */ !   re_comp_buf.newline_anchor = 1;d  G   ret = regex_compile (s, strlen (s), re_syntax_options, &re_comp_buf);      if (!ret)*     return NULL;  =   /* Yes, we're discarding `const' here if !HAVE_LIBINTL.  */ 6   return (char *) gettext (re_error_msgid[(int) ret]); }      int  #ifdef _LIBC
 weak_functionn #endif re_exec (s)      const char *s; {A   const int len = strlen (s);    returnM     0 <= re_search (&re_comp_buf, s, len, 0, len, (struct re_registers *) 0);  }U   #endif /* _REGEX_RE_COMP */n p8 /* POSIX.2 functions.  Don't define these for Emacs.  */  
 #ifndef emacs,  B /* regcomp takes a regular expression as a string and compiles it.  G    PREG is a regex_t *.  We do not expect any fields to be initialized,t/    since POSIX says we shouldn't.  Thus, we setO  &      `buffer' to the compiled pattern;2      `used' to the length of the compiled pattern;0      `syntax' to RE_SYNTAX_POSIX_EXTENDED if the7        REG_EXTENDED bit in CFLAGS is set; otherwise, toG        RE_SYNTAX_POSIX_BASIC;n9      `newline_anchor' to REG_NEWLINE being set in CFLAGS;a5      `fastmap' to an allocated space for the fastmap;N       `fastmap_accurate' to zero;:      `re_nsub' to the number of subexpressions in PATTERN.  0    PATTERN is the address of the pattern string.  7    CFLAGS is a series of bits which affect compilation.I  H      If REG_EXTENDED is set, we use POSIX extended syntax; otherwise, we      use POSIX basic syntax.  B      If REG_NEWLINE is set, then . and [^...] don't match newline.B      Also, regexec will try a match beginning after every newline.  @      If REG_ICASE is set, then we considers upper- and lowercase8      versions of letters to be equivalent when matching.  C      If REG_NOSUB is set, then when PREG is passed to regexec, that G      routine will report only success or failure, and nothing about the       registers.   H    It returns 0 if it succeeds, nonzero if it doesn't.  (See regex.h for,    the return codes and their meanings.)  */   int  regcomp (preg, pattern, cflags)n     regex_t *preg;     const char *pattern;     int cflags;T {R   reg_errcode_t ret;   reg_syntax_t syntax      = (cflags & REG_EXTENDED) ?I7       RE_SYNTAX_POSIX_EXTENDED : RE_SYNTAX_POSIX_BASIC;d  H   /* regex_compile will allocate the space for the compiled pattern.  */   preg->buffer = 0;_   preg->allocated = 0;   preg->used = 0;   /   /* Try to allocate space for the fastmap.  */ 3   preg->fastmap = (char *) malloc (1 << BYTEWIDTH);      if (cflags & REG_ICASE)h     {)       unsigned i;g         preg->translate , 	= (RE_TRANSLATE_TYPE) malloc (CHAR_SET_SIZE, 				      * sizeof (*(RE_TRANSLATE_TYPE)0));"       if (preg->translate == NULL)          return (int) REG_ESPACE;  F       /* Map uppercase characters to corresponding lowercase ones.  */)       for (i = 0; i < CHAR_SET_SIZE; i++)a;         preg->translate[i] = ISUPPER (i) ? TOLOWER (i) : i;(     }I   else     preg->translate = NULL;i  A   /* If REG_NEWLINE is set, newlines are treated differently.  */d   if (cflags & REG_NEWLINE)aD     { /* REG_NEWLINE implies neither . nor [^...] match newline.  */        syntax &= ~RE_DOT_NEWLINE;)       syntax |= RE_HAT_LISTS_NOT_NEWLINE;o3       /* It also changes the matching behavior.  */y       preg->newline_anchor = 1;      }s   else     preg->newline_anchor = 0;a  (   preg->no_sub = !!(cflags & REG_NOSUB);  D   /* POSIX says a null character in the pattern terminates it, so we6      can use strlen here in compiling the pattern.  */@   ret = regex_compile (pattern, strlen (pattern), syntax, preg);  E   /* POSIX doesn't distinguish between an unmatched open-group and an 4      unmatched close-group: both are REG_EPAREN.  */+   if (ret == REG_ERPAREN) ret = REG_EPAREN;n  *   if (ret == REG_NOERROR && preg->fastmap)     { I       /* Compute the fastmap now, since regexec cannot modify the pattern 
 	 buffer.  */b*       if (re_compile_fastmap (preg) == -2) 	{A 	  /* Some error occured while computing the fastmap, just forgeti 	     about it.  */  	  free (preg->fastmap); 	  preg->fastmap = NULL; 	}     }      return (int) ret;f }  #ifdef _LIBC weak_alias (__regcomp, regcomp)r #endif    B /* regexec searches for a given pattern, specified by PREG, in the    string STRING.   C    If NMATCH is zero or REG_NOSUB was set in the cflags argument tofC    `regcomp', we ignore PMATCH.  Otherwise, we assume PMATCH has at ?    least NMATCH elements, and we set them to the offsets of the $    corresponding matched substrings.  ?    EFLAGS specifies `execution flags' which affect matching: if C    REG_NOTBOL is set, then ^ does not match at the beginning of the B    string; if REG_NOTEOL is set, then $ does not match at the end.  =    We return 0 if we find a match and REG_NOMATCH if not.  */    intt. regexec (preg, string, nmatch, pmatch, eflags)     const regex_t *preg;     const char *string;      size_t nmatch;     regmatch_t pmatch[];     int eflags;l {t
   int ret;   struct re_registers regs;i   regex_t private_preg;o   int len = strlen (string);6   boolean want_reg_info = !preg->no_sub && nmatch > 0;     private_preg = *preg;   1   private_preg.not_bol = !!(eflags & REG_NOTBOL); 1   private_preg.not_eol = !!(eflags & REG_NOTEOL);e  >   /* The user has told us exactly how many registers to returnE      information about, via `nmatch'.  We have to pass that on to the_      matching routines.  */ +   private_preg.regs_allocated = REGS_FIXED;      if (want_reg_info)     {p       regs.num_regs = nmatch; 1       regs.start = TALLOC (nmatch * 2, regoff_t);        if (regs.start == NULL)=!         return (int) REG_NOMATCH; %       regs.end = regs.start + nmatch;a     }   )   /* Perform the searching operation.  */ .   ret = re_search (&private_preg, string, len,4                    /* start: */ 0, /* range: */ len,F                    want_reg_info ? &regs : (struct re_registers *) 0);  >   /* Copy the register information to the POSIX structure.  */   if (want_reg_info)     {o       if (ret >= 0) 	         {R           unsigned r;-  &           for (r = 0; r < nmatch; r++)
             {/.               pmatch[r].rm_so = regs.start[r];,               pmatch[r].rm_eo = regs.end[r];
             }t	         }m  J       /* If we needed the temporary register info, free the space now.  */       free (regs.start);     }d  A   /* We want zero return to mean success, unlike `re_search'.  */t:   return ret >= 0 ? (int) REG_NOERROR : (int) REG_NOMATCH; }d #ifdef _LIBC weak_alias (__regexec, regexec)  #endif    F /* Returns a message corresponding to an error code, ERRCODE, returned@    from either regcomp or regexec.   We don't use PREG here.  */   size_t- regerror (errcode, preg, errbuf, errbuf_size)      int errcode;     const regex_t *preg;     char *errbuf;      size_t errbuf_size;  {)   const char *msg;   size_t msg_size;     if (errcode < 0a2       || errcode >= (int) (sizeof (re_error_msgid)$ 			   / sizeof (re_error_msgid[0])))I     /* Only error codes returned by the rest of the code should be passed I        to this routine.  If we are given anything else, or if other regex H        code generates an invalid error code, then the program has a bug.&        Dump core so we can fix it.  */
     abort ();i  *   msg = gettext (re_error_msgid[errcode]);  8   msg_size = strlen (msg) + 1; /* Includes the null.  */     if (errbuf_size != 0)s     { !       if (msg_size > errbuf_size)e	         {o) #if defined HAVE_MEMPCPY || defined _LIBC ? 	  *((char *) __mempcpy (errbuf, msg, errbuf_size - 1)) = '\0';  #else 0           memcpy (errbuf, msg, errbuf_size - 1);&           errbuf[errbuf_size - 1] = 0; #endif	         }t
       else'         memcpy (errbuf, msg, msg_size);/     }c     return msg_size; }  #ifdef _LIBC! weak_alias (__regerror, regerror)j #endif    5 /* Free dynamically allocated space used by PREG.  */S   void regfree (preg)     regex_t *preg; {    if (preg->buffer != NULL)      free (preg->buffer);   preg->buffer = NULL;     preg->allocated = 0;   preg->used = 0;)     if (preg->fastmap != NULL)     free (preg->fastmap);l   preg->fastmap = NULL;    preg->fastmap_accurate = 0;      if (preg->translate != NULL)     free (preg->translate);)   preg->translate = NULL;t }  #ifdef _LIBC weak_alias (__regfree, regfree)  #endif   #endif /* not emacs  */nive A                      is, including the ending `jump_past_alt' and $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     