? /* Definitions for data structures and routines for the regular $    expression library, version 0.12.O    Copyright (C) 1985,89,90,91,92,93,95,96,97,98 Free Software Foundation, Inc.   L    This file is part of the GNU C Library.  Its master source is NOT part ofC    the C library, however.  The master source lives in /gd/gnu/lib.   E    The GNU C Library is free software; you can redistribute it and/or I    modify it under the terms of the GNU Library General Public License as E    published by the Free Software Foundation; either version 2 of the 2    License, or (at your option) any later version.  G    The GNU C Library is distributed in the hope that it will be useful, A    but WITHOUT ANY WARRANTY; without even the implied warranty of D    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU3    Library General Public License for more details.   D    You should have received a copy of the GNU Library General PublicK    License along with the GNU C Library; see the file COPYING.LIB.  If not, L    write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,"    Boston, MA 02111-1307, USA.  */   #ifndef _REGEX_H #define _REGEX_H 1  ! /* Allow the use in C++ code.  */  #ifdef __cplusplus extern "C" { #endif  H /* POSIX says that <sys/types.h> must be included (by the caller) before    <regex.h>.  */   E #if !defined _POSIX_C_SOURCE && !defined _POSIX_SOURCE && defined VMS H /* VMS doesn't have `size_t' in <sys/types.h>, even though POSIX says it    should be there.  */  # include <stddef.h> #endif  F /* The following two types have to be signed and unsigned integer typeE    wide enough to hold a value of a pointer.  For most ANSI compilers E    ptrdiff_t and size_t should be likely OK.  Still size of these two )    types is 2 for Microsoft C.  Ugh... */  typedef long int s_reg_t; ' typedef unsigned long int active_reg_t;   @ /* The following bits are used to determine the regexp syntax weG    recognize.  The set/not-set meanings are chosen so that Emacs syntax F    remains the value 0.  The bits are given in alphabetical order, andF    the definitions shifted by one from the previous bit; thus, when weB    add or remove a bit, only one other definition need change.  */' typedef unsigned long int reg_syntax_t;   I /* If this bit is not set, then \ inside a bracket expression is literal. <    If set, then such a \ quotes the following character.  */< #define RE_BACKSLASH_ESCAPE_IN_LISTS ((unsigned long int) 1)  H /* If this bit is not set, then + and ? are operators, and \+ and \? are      literals.E    If set, then \+ and \? are operators and + and ? are literals.  */ 9 #define RE_BK_PLUS_QM (RE_BACKSLASH_ESCAPE_IN_LISTS << 1)   G /* If this bit is set, then character classes are supported.  They are: H      [:alpha:], [:upper:], [:lower:],  [:digit:], [:alnum:], [:xdigit:],?      [:space:], [:print:], [:punct:], [:graph:], and [:cntrl:]. <    If not set, then character classes are not supported.  */, #define RE_CHAR_CLASSES (RE_BK_PLUS_QM << 1)  G /* If this bit is set, then ^ and $ are always anchors (outside bracket       expressions, of course). +    If this bit is not set, then it depends: >         ^  is an anchor if it is at the beginning of a regularH            expression or after an open-group or an alternation operator;G         $  is an anchor if it is at the end of a regular expression, or ;            before a close-group or an alternation operator.   D    This bit could be (re)combined with RE_CONTEXT_INDEP_OPS, becauseG    POSIX draft 11.2 says that * etc. in leading positions is undefined. F    We already implemented a previous draft which made those constructs<    invalid, though, so we haven't changed the code back.  */7 #define RE_CONTEXT_INDEP_ANCHORS (RE_CHAR_CLASSES << 1)   A /* If this bit is set, then special characters are always special 1      regardless of where they are in the pattern. F    If this bit is not set, then special characters are special only in?      some contexts; otherwise they are ordinary.  Specifically, G      * + ? and intervals are only special when not after the beginning, -      open-group, or alternation operator.  */ < #define RE_CONTEXT_INDEP_OPS (RE_CONTEXT_INDEP_ANCHORS << 1)  F /* If this bit is set, then *, +, ?, and { cannot be first in an re orB      immediately after an alternation or begin-group operator.  */: #define RE_CONTEXT_INVALID_OPS (RE_CONTEXT_INDEP_OPS << 1)  . /* If this bit is set, then . matches newline.#    If not set, then it doesn't.  */ 4 #define RE_DOT_NEWLINE (RE_CONTEXT_INVALID_OPS << 1)  0 /* If this bit is set, then . doesn't match NUL.     If not set, then it does.  */- #define RE_DOT_NOT_NULL (RE_DOT_NEWLINE << 1)   E /* If this bit is set, nonmatching lists [^...] do not match newline.     If not set, they do.  */ 7 #define RE_HAT_LISTS_NOT_NEWLINE (RE_DOT_NOT_NULL << 1)   9 /* If this bit is set, either \{...\} or {...} defines an ,      interval, depending on RE_NO_BK_BRACES.1    If not set, \{, \}, {, and } are literals.  */ 4 #define RE_INTERVALS (RE_HAT_LISTS_NOT_NEWLINE << 1)  A /* If this bit is set, +, ? and | aren't recognized as operators.     If not set, they are.  */* #define RE_LIMITED_OPS (RE_INTERVALS << 1)  : /* If this bit is set, newline is an alternation operator.&    If not set, newline is literal.  */, #define RE_NEWLINE_ALT (RE_LIMITED_OPS << 1)  F /* If this bit is set, then `{...}' defines an interval, and \{ and \}      are literals.5   If not set, then `\{...\}' defines an interval.  */ - #define RE_NO_BK_BRACES (RE_NEWLINE_ALT << 1)   I /* If this bit is set, (...) defines a group, and \( and \) are literals. E    If not set, \(...\) defines a group, and ( and ) are literals.  */ . #define RE_NO_BK_PARENS (RE_NO_BK_BRACES << 1)  5 /* If this bit is set, then \<digit> matches <digit>. 5    If not set, then \<digit> is a back-reference.  */ , #define RE_NO_BK_REFS (RE_NO_BK_PARENS << 1)  L /* If this bit is set, then | is an alternation operator, and \| is literal.H    If not set, then \| is an alternation operator, and | is literal.  */* #define RE_NO_BK_VBAR (RE_NO_BK_REFS << 1)  B /* If this bit is set, then an ending range point collating higher<      than the starting range point, as in [z-a], is invalid.D    If not set, then when ending range point collates higher than the4      starting range point, the range is ignored.  *// #define RE_NO_EMPTY_RANGES (RE_NO_BK_VBAR << 1)   7 /* If this bit is set, then an unmatched ) is ordinary. 2    If not set, then an unmatched ) is invalid.  */> #define RE_UNMATCHED_RIGHT_PAREN_ORD (RE_NO_EMPTY_RANGES << 1)  E /* If this bit is set, succeed as soon as we match the whole pattern, $    without further backtracking.  */D #define RE_NO_POSIX_BACKTRACKING (RE_UNMATCHED_RIGHT_PAREN_ORD << 1)  > /* If this bit is set, do not process the GNU regex operators.>    If not set, then the GNU regex operators are recognized. */5 #define RE_NO_GNU_OPS (RE_NO_POSIX_BACKTRACKING << 1)   8 /* If this bit is set, turn on internal regex debugging.1    If not set, and debugging was on, turn it off. 2    This only works if regex.c is compiled -DDEBUG.B    We define this bit always, so that all that's needed to turn onF    debugging is to recompile regex.c; the calling code can always haveD    this bit set, and it won't affect anything in the normal case. */% #define RE_DEBUG (RE_NO_GNU_OPS << 1)   H /* This global variable defines the particular regexp syntax to use (forC    some interfaces).  When a regexp is compiled, the syntax used is A    stored in the pattern buffer, so changing this does not affect      already-compiled regexps.  */& extern reg_syntax_t re_syntax_options;  H /* Define combinations of the above bits for the standard possibilities.D    (The [[[ comments delimit what gets put into the Texinfo file, so    don't delete them!)  */ /* [[[begin syntaxes]]] */ #define RE_SYNTAX_EMACS 0    #define RE_SYNTAX_AWK							\ 7   (RE_BACKSLASH_ESCAPE_IN_LISTS   | RE_DOT_NOT_NULL			\ 5    | RE_NO_BK_PARENS              | RE_NO_BK_REFS			\ :    | RE_NO_BK_VBAR                | RE_NO_EMPTY_RANGES			\4    | RE_DOT_NEWLINE		  | RE_CONTEXT_INDEP_ANCHORS		\2    | RE_UNMATCHED_RIGHT_PAREN_ORD | RE_NO_GNU_OPS)    #define RE_SYNTAX_GNU_AWK						\I   ((RE_SYNTAX_POSIX_EXTENDED | RE_BACKSLASH_ESCAPE_IN_LISTS | RE_DEBUG)	\ >    & ~(RE_DOT_NOT_NULL | RE_INTERVALS | RE_CONTEXT_INDEP_OPS))  # #define RE_SYNTAX_POSIX_AWK 						\ =   (RE_SYNTAX_POSIX_EXTENDED | RE_BACKSLASH_ESCAPE_IN_LISTS		\ &    | RE_INTERVALS	    | RE_NO_GNU_OPS)   #define RE_SYNTAX_GREP							\4   (RE_BK_PLUS_QM              | RE_CHAR_CLASSES				\1    | RE_HAT_LISTS_NOT_NEWLINE | RE_INTERVALS				\     | RE_NEWLINE_ALT)   #define RE_SYNTAX_EGREP							\ 8   (RE_CHAR_CLASSES        | RE_CONTEXT_INDEP_ANCHORS			\8    | RE_CONTEXT_INDEP_OPS | RE_HAT_LISTS_NOT_NEWLINE			\0    | RE_NEWLINE_ALT       | RE_NO_BK_PARENS				\    | RE_NO_BK_VBAR)   $ #define RE_SYNTAX_POSIX_EGREP						\4   (RE_SYNTAX_EGREP | RE_INTERVALS | RE_NO_BK_BRACES)  5 /* P1003.2/D11.2, section 4.20.7.1, lines 5078ff.  */ * #define RE_SYNTAX_ED RE_SYNTAX_POSIX_BASIC  + #define RE_SYNTAX_SED RE_SYNTAX_POSIX_BASIC   H /* Syntax bits common to both basic and extended POSIX regex syntax.  */& #define _RE_SYNTAX_POSIX_COMMON						\=   (RE_CHAR_CLASSES | RE_DOT_NEWLINE      | RE_DOT_NOT_NULL		\ (    | RE_INTERVALS  | RE_NO_EMPTY_RANGES)  $ #define RE_SYNTAX_POSIX_BASIC						\+   (_RE_SYNTAX_POSIX_COMMON | RE_BK_PLUS_QM)   B /* Differs from ..._POSIX_BASIC only in that RE_BK_PLUS_QM becomesE    RE_LIMITED_OPS, i.e., \? \+ \| are not recognized.  Actually, this I    isn't minimal, since other operators, such as \`, aren't disabled.  */ + #define RE_SYNTAX_POSIX_MINIMAL_BASIC					\ ,   (_RE_SYNTAX_POSIX_COMMON | RE_LIMITED_OPS)  & #define RE_SYNTAX_POSIX_EXTENDED					\9   (_RE_SYNTAX_POSIX_COMMON | RE_CONTEXT_INDEP_ANCHORS			\ 1    | RE_CONTEXT_INDEP_OPS  | RE_NO_BK_BRACES				\ /    | RE_NO_BK_PARENS       | RE_NO_BK_VBAR				\ "    | RE_UNMATCHED_RIGHT_PAREN_ORD)  A /* Differs from ..._POSIX_EXTENDED in that RE_CONTEXT_INVALID_OPS @    replaces RE_CONTEXT_INDEP_OPS and RE_NO_BK_REFS is added.  */- #define RE_SYNTAX_POSIX_MINIMAL_EXTENDED				\ :   (_RE_SYNTAX_POSIX_COMMON  | RE_CONTEXT_INDEP_ANCHORS			\2    | RE_CONTEXT_INVALID_OPS | RE_NO_BK_BRACES				\0    | RE_NO_BK_PARENS        | RE_NO_BK_REFS				\6    | RE_NO_BK_VBAR	    | RE_UNMATCHED_RIGHT_PAREN_ORD) /* [[[end syntaxes]]] */  D /* Maximum number of duplicates an interval can allow.  Some systemsC    (erroneously) define this in other header files, but we want our ,    value, so remove any previous define.  */ #ifdef RE_DUP_MAX  # undef RE_DUP_MAX #endif; /* If sizeof(int) == 2, then ((1 << 15) - 1) overflows.  */  #define RE_DUP_MAX (0x7fff)     = /* POSIX `cflags' bits (i.e., information for `regcomp').  */   C /* If this bit is set, then use extended regular expression syntax. <    If not set, then use basic regular expression syntax.  */ #define REG_EXTENDED 1  6 /* If this bit is set, then ignore case when matching.,    If not set, then case is significant.  */% #define REG_ICASE (REG_EXTENDED << 1)   ; /* If this bit is set, then anchors do not match at newline       characters in the string.5    If not set, then anchors do match at newlines.  */ $ #define REG_NEWLINE (REG_ICASE << 1)  C /* If this bit is set, then report only success or fail in regexec. G    If not set, then returns differ between not matching and errors.  */ $ #define REG_NOSUB (REG_NEWLINE << 1)    ; /* POSIX `eflags' bits (i.e., information for regexec).  */   H /* If this bit is set, then the beginning-of-line operator doesn't matchA      the beginning of the string (presumably because it's not the       beginning of a line).A    If not set, then the beginning-of-line operator does match the !      beginning of the string.  */  #define REG_NOTBOL 1  3 /* Like REG_NOTBOL, except for the end-of-line.  */  #define REG_NOTEOL (1 << 1)     @ /* If any error codes are removed, changed, or added, update the'    `re_error_msg' table in regex.c.  */  typedef enum {  #ifdef _XOPEN_SOURCEI   REG_ENOSYS = -1,	/* This will never happen for this implementation.  */  #endif  "   REG_NOERROR = 0,	/* Success.  */9   REG_NOMATCH,		/* Didn't find a match (for regexec).  */   C   /* POSIX regcomp return error codes.  (In the order listed in the       standard.)  */ &   REG_BADPAT,		/* Invalid pattern.  */(   REG_ECOLLATE,		/* Not implemented.  */3   REG_ECTYPE,		/* Invalid character class name.  */ *   REG_EESCAPE,		/* Trailing backslash.  */.   REG_ESUBREG,		/* Invalid back reference.  */-   REG_EBRACK,		/* Unmatched left bracket.  */ ,   REG_EPAREN,		/* Parenthesis imbalance.  */#   REG_EBRACE,		/* Unmatched \{.  */ .   REG_BADBR,		/* Invalid contents of \{\}.  */(   REG_ERANGE,		/* Invalid range end.  */(   REG_ESPACE,		/* Ran out of memory.  */8   REG_BADRPT,		/* No preceding re for repetition op.  */  !   /* Error codes we've added.  */ "   REG_EEND,		/* Premature end.  */=   REG_ESIZE,		/* Compiled pattern bigger than 2^16 bytes.  */ C   REG_ERPAREN		/* Unmatched ) or \); not returned from regcomp.  */  } reg_errcode_t;  E /* This data structure represents a compiled pattern.  Before calling E    the pattern compiler, the fields `buffer', `allocated', `fastmap', D    `translate', and `no_sub' can be set.  After the pattern has beenD    compiled, the `re_nsub' field is available.  All other fields are%    private to the regex routines.  */    #ifndef RE_TRANSLATE_TYPE ! # define RE_TRANSLATE_TYPE char *  #endif   struct re_pattern_buffer {   /* [[[begin pattern_buffer]]] */= 	/* Space that holds the compiled pattern.  It is declared as 4           `unsigned char *' because its elements are/            sometimes used as array indexes.  */    unsigned char *buffer;  1 	/* Number of bytes to which `buffer' points.  */    unsigned long int allocated;  2 	/* Number of bytes actually used in `buffer'.  */   unsigned long int used;   B         /* Syntax setting with which the pattern was compiled.  */   reg_syntax_t syntax;  H         /* Pointer to a fastmap, if any, otherwise zero.  re_search uses@            the fastmap, if there is one, to skip over impossible+            starting points for matches.  */    char *fastmap;  E         /* Either a translate table to apply to all characters before G            comparing them, or zero for no translation.  The translation F            is applied to a pattern when it is compiled and to a string"            when it is matched.  */   RE_TRANSLATE_TYPE translate;  7 	/* Number of subexpressions found by the compiler.  */    size_t re_nsub;   H         /* Zero if this pattern cannot match the empty string, one else.A            Well, in truth it's used only in `re_search_2', to see D            whether or not we should use the fastmap, so we don't setC            this absolutely perfectly; see `re_compile_fastmap' (the !            `duplicate' case).  */    unsigned can_be_null : 1;   F         /* If REGS_UNALLOCATED, allocate space in the `regs' structure6              for `max (RE_NREGS, re_nsub + 1)' groups.=            If REGS_REALLOCATE, reallocate space if necessary. /            If REGS_FIXED, use what's there.  */  #define REGS_UNALLOCATED 0 #define REGS_REALLOCATE 1  #define REGS_FIXED 2   unsigned regs_allocated : 2;  J         /* Set to zero when `regex_compile' compiles a pattern; set to oneA            by `re_compile_fastmap' if it updates the fastmap.  */     unsigned fastmap_accurate : 1;  A         /* If set, `re_match_2' does not return information about             subexpressions.  */   unsigned no_sub : 1;  B         /* If set, a beginning-of-line anchor doesn't match at the'            beginning of the string.  */    unsigned not_bol : 1;   3         /* Similarly for an end-of-line anchor.  */    unsigned not_eol : 1;   7         /* If true, an anchor at a newline matches.  */    unsigned newline_anchor : 1;   /* [[[end pattern_buffer]]] */ };  ) typedef struct re_pattern_buffer regex_t;   E /* Type for byte offsets within the string.  POSIX mandates this.  */  typedef int regoff_t;     > /* This is the structure we store register match data in.  SeeD    regex.texinfo for a full description of what registers match.  */ struct re_registers  {    unsigned num_regs;   regoff_t *start;   regoff_t *end; };    A /* If `regs_allocated' is REGS_UNALLOCATED in the pattern buffer,9F    `re_match_2' returns information about at least this many registers3    the first time a `regs' structure is passed.  */T #ifndef RE_NREGS # define RE_NREGS 30 #endif    J /* POSIX specification for registers.  Aside from the different names thanB    `re_registers', POSIX uses an array of structures, instead of a    structure of arrays.  */a typedef struct { O   regoff_t rm_so;  /* Byte offset from string's start to substring's start.  */pM   regoff_t rm_eo;  /* Byte offset from string's start to substring's end.  */t
 } regmatch_t;f  ! /* Declarations for routines.  */o  @ /* To avoid duplicating every routine declaration -- once with aD    prototype (if we are ANSI), and once without (if we aren't) -- we;    use the following macro to declare argument types.  ThishE    unfortunately clutters up the declarations a bit, but I think it'ss    worth it.  */  - #if defined(__STDC__) || defined(__cplusplus)o   # define _RE_ARGS(args) args   #else /* not __STDC__ */   # define _RE_ARGS(args) ()   #endif /* not __STDC__ */1  H /* Sets the current default syntax to SYNTAX, and return the old syntax.F    You can also simply assign to the `re_syntax_options' variable.  */C extern reg_syntax_t re_set_syntax _RE_ARGS ((reg_syntax_t syntax));n  = /* Compile the regular expression PATTERN, with length LENGTH F    and syntax given by the global `re_syntax_options', into the bufferF    BUFFER.  Return NULL if successful, and an error string if not.  */% extern const char *re_compile_patternu0   _RE_ARGS ((const char *pattern, size_t length,0              struct re_pattern_buffer *buffer));    @ /* Compile a fastmap for the compiled pattern in BUFFER; used to@    accelerate searches.  Return 0 if successful and -2 if was an    internal error.  */L extern int re_compile_fastmap _RE_ARGS ((struct re_pattern_buffer *buffer));    C /* Search in the string STRING (with length LENGTH) for the pattern F    compiled into BUFFER.  Start searching at position START, for RANGED    characters.  Return the starting position of the match, -1 for no<    match, or -2 for an internal error.  Also return registerD    information in REGS (if REGS and BUFFER->no_sub are nonzero).  */ extern int re_searchB   _RE_ARGS ((struct re_pattern_buffer *buffer, const char *string,J             int length, int start, int range, struct re_registers *regs));    C /* Like `re_search', but search in the concatenation of STRING1 andl<    STRING2.  Also, stop searching at index START + STOP.  */ extern int re_search_2C   _RE_ARGS ((struct re_pattern_buffer *buffer, const char *string1,b;              int length1, const char *string2, int length2, I              int start, int range, struct re_registers *regs, int stop));     H /* Like `re_search', but return how many characters in STRING the regexp5    in BUFFER matched, starting at position START.  */  extern int re_matchKB   _RE_ARGS ((struct re_pattern_buffer *buffer, const char *string,@              int length, int start, struct re_registers *regs));    E /* Relates to `re_match' as `re_search_2' relates to `re_search'.  */  extern int re_match_2 C   _RE_ARGS ((struct re_pattern_buffer *buffer, const char *string1,o;              int length1, const char *string2, int length2,e>              int start, struct re_registers *regs, int stop));    B /* Set REGS to hold NUM_REGS registers, storing them in STARTS andG    ENDS.  Subsequent matches using BUFFER and REGS will use this memorys?    for recording register information.  STARTS and ENDS must bedF    allocated with malloc, and must each be at least `NUM_REGS * sizeof    (regoff_t)' bytes long.  F    If NUM_REGS == 0, then subsequent matches should allocate their own    register data.a  B    Unless this function is called, the first search or match using>    PATTERN_BUFFER will allocate its own register data, without    freeing the old data.  */ extern void re_set_registersI   _RE_ARGS ((struct re_pattern_buffer *buffer, struct re_registers *regs,gC              unsigned num_regs, regoff_t *starts, regoff_t *ends));C  + #if defined _REGEX_RE_COMP || defined _LIBC) # ifndef _CRAY /* 4.2 bsd compatibility.  */c/ extern char *re_comp _RE_ARGS ((const char *));r- extern int re_exec _RE_ARGS ((const char *));d # endifC #endif   /* POSIX compatibility.  */SE extern int regcomp _RE_ARGS ((regex_t *__preg, const char *__pattern,, 			      int __cflags));  4 extern int regexec _RE_ARGS ((const regex_t *__preg,/ 			      const char *__string, size_t __nmatch, / 			      regmatch_t __pmatch[], int __eflags));T  G extern size_t regerror _RE_ARGS ((int __errcode, const regex_t *__preg,.- 				  char *__errbuf, size_t __errbuf_size));   1 extern void regfree _RE_ARGS ((regex_t *__preg));T     #ifdef __cplusplus }b #endif	/* C++ */   #endif /* regex.h */   /* Local variables: make-backup-files: t version-control: t! trim-versions-without-asking: nil  End: */NTERVALS (RE_HAT_LISTS_NOT_NEWLINE << 1)  A /* If this b                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                