 // // StringMatch.h /// // (c) 1995 Andrew Scherpbier <andrew@sdsu.edu>  //B // This class provides an interface to a fairly specialized stringC // lookup facility.  It is intended to be used as a replace for any F // regualr expression matching when the pattern string is in the form: //' //    <string1>|<string2>|<string3>|...  //A // Just like regular expression routines, the pattern needs to be D // compiled before it can be used.  This is done using the Pattern()C // member function.  Once the pattern has been compiled, the member E // function Find() can be used to search for the pattern in a string. B // If a string has been found, the "which" and "length" parametersB // will be set to the string index and string length respectively.D // (The string index is counted starting from 0) The return value ofC // Find() is the position at which the string was found or -1 if no C // strings could be found.  If a case insensitive match needs to be B // performed, call the IgnoreCase() member function before callingE // Pattern().  This function will setup a character translation table E // which will convert all uppercase characters to lowercase.  If some ? // other translation is required, the TranslationTable() member F // function can be called to provide a custom table.  This table needs // to be 256 characters. //  A // $Id: StringMatch.h,v 1.2.2.1 1999/09/01 21:00:19 grdetil Exp $  // // $Log: StringMatch.h,v $1 // Revision 1.2.2.1  1999/09/01 21:00:19  grdetil M // Add a StringMatch::IgnorePunct() method, which allows matches to skip over O // valid punctuation. Use it to highlight matching words in excerpts regardless F // of punctuation, and don't add short or bad words to logicalPattern. //. // Revision 1.2  1999/01/21 03:41:09  ghutchis# // Add default parameter sep = '|'.  //0 // Revision 1.1.1.1  1997/02/03 17:11:04  turtle // Initial CVS // // #ifndef _StringMatch_h_  #define _StringMatch_h_    #include <Object.h>     ! class StringMatch : public Object  {  public:      //     // Construction/Destruction      //     StringMatch();     ~StringMatch();        //D     // Set the pattern to search for.  If given as a string needs toB     // be in the form <string1>|<string2>|...  If in the form of a3     // List, it should be a list of String objects.      //1     void		Pattern(char *pattern, char sep = '|');        //@     // Search for any of the strings in the pattern in the givenD     // string The return value is the offset in the source a patternF     // was found.  In this case, the which variable will be set to the@     // index of the pattern string and length will be set to theE     // length of that pattern string.  If none of the pattern strings 2     // could be found, the return value will be -1     //;     int			FindFirst(char *string, int &which, int &length); "     int			FindFirst(char *string); 	 ?     int			FindFirstWord(char *string, int &which, int &length); &     int			FindFirstWord(char *string); 	      //B     // If you are interested in matching instead of searching, useH     // the following.  Same parameters except that the return value will5     // be 1 if there was a match, 0 if there was not.      //9     int			Compare(char *string, int &which, int &length);       int			Compare(char *string);  =     int			CompareWord(char *string, int &which, int &length); $     int			CompareWord(char *string);          //E     // Provide a character translation table which will be applied to F     // both the pattern and the input string.  This table should be anE     // array of 256 characters.  If is the caller's responsibility to E     // manage this table's allocation.  The table should remain valid ,     // until this object has been destroyed.     //(     void		TranslationTable(char *table); 	      //?     // Build a local translation table which maps all uppercase      // characters to lowercase     //     void		IgnoreCase();        //J     // Build a local translation table which ignores all given punctuation     // characters      //*     void		IgnorePunct(char *punct = NULL);       //I     // Determine if there is a pattern associated with this Match object.      ///     int			hasPattern()		{return table[0] != 0;}  	 
 protected:     int			*table[256];     unsigned char	*trans;      int			local_alloc; };   #endif                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      