 /* **++ **  FACILITY:  VMS_ACCESS  ** **  MODULE DESCRIPTION:  **A **      The routine vms_access() in this module provides the same A **	functionality as the C RTL function access(), but honors ACLs.  ** **  AUTHORS: **4 **      Martin Vorlaender <martin@radiogaga.harz.de> ** **  CREATION DATE:  7-OCT-2001 ** **  DESIGN ISSUES: ** **      {@tbs@}  ** **  VERSION: **     **  	1.0 **     **  INCLUDED FILES:  **     **  	VMSUTIL.H **     **  [@optional module tags@]...  ** **  MODIFICATION HISTORY:  ** **      7-OCT-2001  MV	created
 **	[@tbs@]...  **-- */   #ifdef __VMS     /* ** **  INCLUDE FILES  ** */   #include stdlib  #include string  #include unistd  #include unixlib   #define __NEW_STARLET 1  #include descrip #include acldef  #include armdef  #include chpdef  #include jpidef  #include libfildef #include namdef  #include rmsdef  #include ssdef   #include starlet #include lib$routines    #include "vms_access.h"      typedef struct itmlst  { " 	unsigned short int	buffer_length; 	unsigned short int	item_code; 	void			*buffer_address;# 	unsigned short int	*return_length; 	 } ITMLST;        /* **++ **  FUNCTIONAL DESCRIPTION:  **6 **      static int GetVMSName(char *VMSName, int type) **" **	Action routine to decc$to_vms() ** **  FORMAL PARAMETERS: ** **      char *VMSName:O **          UNIX style file name to be translated to a valid OpenVMS file name  	 **         **      int type:  **          0 (DECC$K_FOREIGN)  @ **		A file on a remote system that is not running the OpenVMS or **		VAXELN operating system.   **	    2 (DECC$K_DIRECTORY) < **		The OpenVMS translation of the UNIX style file name is a **		directory.   **	    1 (DECC$K_FILE)   **		The translation is a file.   ** **  RETURN VALUE:  **J **      If action_routine returns a nonzero value (TRUE), file translation> **	continues. If it returns a 0 value (FALSE), no further file **	translation takes place.  ** **  SIDE EFFECTS:  **F **      static char *tmp_str is used to return the OpenVMS translation **	to the calling routine. ** **  DESIGN:  ** **      None ** **  [@logical properties@]...  **! **  [@optional function tags@]...  ** **-- */ static char *tmp_str;   . static int GetVMSName(char *VMSName, int type) { ;     if (type == DECC$K_DIRECTORY || type == DECC$K_FOREIGN) #         return 1; /* try another */ A     /* Hopefully the contents of VMSName is available globally */      tmp_str = VMSName;
     return 0;  }      /* **++ **  FUNCTIONAL DESCRIPTION:  **8 **      int vms_access (const char *file_spec, int mode) **< **	vms_access() provides the same functionality as the C RTL+ **	access() function, but also honors ACLs.  ** **  FORMAL PARAMETERS:, **	Straight from the Compaq C documentation: ** **      const char *file_spec:B **          A character string that gives an OpenVMS or UNIX style> **	    file specification. The usual defaults and logical name; **	    translations are applied to the file specification.  	 **         **      int mode: # **	    Mode Argument   Access Mode  9 **	      F_OK            Tests to see if the file exists  ! **	      X_OK            Execute  7 **	      W_OK            Write (implies delete access)   **	      R_OK            Read F **	    Combinations of access modes are indicated by ORing the values. ** **  RETURN VALUE:  **0 **      0:  indicates that the access is allowed/ **	-1: indicates that the access is not allowed 3 **	<-1: (extension) negative OpenVMS condition code  ** **  SIDE EFFECTS:  ** **      None ** **  DESIGN:  ** **      {@description or none@}  ** **  [@logical properties@]...  **! **  [@optional function tags@]...  ** **-- */0 int vms_access (const char *file_spec, int mode) { %     char vms_file_spec[NAM$C_MAXRSS];      int sts;     unsigned int context; "     /* Parameters to lib$getjpi */!     int itemcode = JPI$_USERNAME;      char usrnam[20];%     $DESCRIPTOR (usrnam_dsc, usrnam); %     /* Parameters to $check_access */ %     unsigned int objtyp = ACL$C_FILE; /     $DESCRIPTOR (file_spec_dsc, vms_file_spec); !     unsigned int access_mask = 0; A     unsigned int access_flag = CHP$M_NOFAILAUD | CHP$M_NOSUCCAUD;      ITMLST access_itmlst[] = {8 	{sizeof(access_mask), CHP$_ACCESS, &access_mask, NULL},8 	{sizeof(access_flag), CHP$_FLAGS , &access_flag, NULL}, 	{0,0,NULL,NULL}     };       if (strchr(file_spec, '/'))      { . 	/* it's a Unix filespec - translate to VMS */7     	if (decc$to_vms(file_spec, GetVMSName, 0, 0) == 0)  	    return SS$_BADFILENAME;1 	strncpy(vms_file_spec, tmp_str, NAM$C_MAXRSS-1);      }      else     {       	/* Assume a VMS filespec */7     	strncpy(vms_file_spec, file_spec, NAM$C_MAXRSS-1);      }        if (mode == F_OK)      { < 	/* Test whether file exists - not really an access check */' 	char resultant_filespec[NAM$C_MAXRSS]; 0 	$DESCRIPTOR (resultant_fs, resultant_filespec);5 	int flags = LIB$M_FIL_NOWILD | LIB$M_FIL_LONG_NAMES; 
 	context = 0;  	sts = lib$find_file(  	    &file_spec_dsc, 	    &resultant_fs,  	    &context,! 	    NULL, /* default filespec */ ! 	    NULL, /* related filespec */ % 	    NULL, /* RMS secondary status */  	    &flags  	);  	lib$find_file_end(&context); " 	if (sts == RMS$_NORMAL) return 0;# 	if (sts == RMS$_NMF)    return -1; 
 	return -sts;      }   !     /* Get process information */      sts = lib$getjpi(  	&itemcode,      	NULL,  /* process id */     	NULL,  /* process name */!     	NULL,  /* resultant value */      	&usrnam_dsc, !     	NULL  /* resultant length */      );     if (sts != SS$_NORMAL)
 	return -sts;   3     /* Transform mode parameter into access mask */ 2     if (mode & X_OK) access_mask |= ARM$M_EXECUTE;?     if (mode & W_OK) access_mask |= ARM$M_WRITE | ARM$M_DELETE; /     if (mode & R_OK) access_mask |= ARM$M_READ;         /* Get access information */     context = -1;      sts = sys$check_access (	 	&objtyp,  	&file_spec_dsc,
 	&usrnam_dsc,  	&access_itmlst,
 	&context,: 	NULL,  /* class name - not permitted when using objtyp */6 	NULL,  /* objpro - not permitted when using objnam */6 	NULL   /* usrpro - not permitted when using usrnam */     );  $     if (sts == SS$_NORMAL) return 0;>     if (sts == SS$_NOPRIV || sts == SS$_NOCALLPRIV) return -1;     return -sts; }    #endif /* def __VMS */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            