 // // htnotify.cc //? // Check through databases and look for notify META information = // Send e-mail to addresses mentioned in documents if the doc  // has "expired" // // #if RELEASE V static char RCSid[] = "$Id: htnotify.cc,v 1.19.2.2 1999/11/24 01:40:24 grdetil Exp $"; #endif   #include "Configuration.h" #include "DocumentDB.h"  #include "DocumentRef.h" #include "defaults.h"  #include <stdlib.h>  #include <unistd.h>  #include <errno.h> #include <fstream.h> #include <time.h>  #include <stdio.h> #include <ctype.h> #include "HtURLCodec.h"   ( // If we have this, we probably want it. #ifdef HAVE_GETOPT_H #include <getopt.h>  #endif   #ifdef __VMS #include <descrip.h> #include <ssdef.h> #include <maildef.h> #include <nam.h> #include <mail$routines.h>   typedef struct itmlst  { !     unsigned short buffer_length;      unsigned short item_code;      char *buffer_address; (     unsigned int *return_length_address;	 } itmlst; 2 #define NOSIGNAL_ITEM {0,MAIL$_NOSIGNAL,NULL,NULL}2 #define END_ITEM      {0,0             ,NULL,NULL}  E /* Handy way to vet calls to VMS system services and RTL routines. */  #define _chkvmssts(call) { \,   register unsigned long int __chkvms_sts; \%   if (!((__chkvms_sts=(call))&1)) { \      errno = EVMSERR; \      vaxc$errno = __chkvms_sts; \C     fprintf(stderr, "Fatal VMS error (status=%d) at %s, line %d", \ .             __chkvms_sts,__FILE__,__LINE__); \     exit(1); \   } \  }  #endif   void htnotify(DocumentRef &); 
 void usage(); J void send_notification(char *date, char *email, char *url, char *subject);< int parse_date(char *date, int &year, int &month, int &day);     int	verbose = 0;   //@ // This variable is used to hold today's date.  It is global forB // efficiency reasons since computing it is a relatively expensive // operation // struct tm	*today;     O //*****************************************************************************  // int main(int ac, char **av) // int main(int ac, char **av)  {      int			c;     extern char		*optarg;      String		base; -     String		configFile = DEFAULT_CONFIG_FILE;   /     while ((c = getopt(ac, av, "vb:c:")) != -1)      {  	switch (c)  	{
 	case 'b': 	    base = optarg;  	    break; 
 	case 'c': 	    configFile = optarg;  	    break; 
 	case 'v': 	    verbose++;  	    break; 
 	case '?':
 	    usage();  	    break;  	}     }   "     config.Defaults(&defaults[0]);     config.Read(configFile);       //6     // Check url_part_aliases and common_url_parts for     // errors.>     String url_part_errors = HtURLCodec::instance()->ErrMsg();  &     if (url_part_errors.length() != 0)     { P       cerr << form("htnotify: Invalid url_part_aliases or common_url_parts: %s",2                    url_part_errors.get()) << endl;       exit (1);      }        if (base.length())     { # 	config.Add("database_base", base);      }   %     String	doc_db = config["doc_db"];      DocumentDB	docdb;   ?     // Check "uncompressed"/"uncoded" urls at the price of time      // (extra DB probes). G     docdb.SetCompatibility(config.Boolean("uncoded_db_compatible", 1));        docdb.Read(doc_db);      List	*docs = docdb.URLs();       //     // Compute today's date      //     time_t	now = time(0);      today = localtime(&now);       //N     // Traverse all the known documents to check for notification requirements     //     DocumentRef	*ref;      String		*str;      docs->Start_Get();/     while ((str = (String *) docs->Get_Next()))      {  	ref = docdb[str->get()]; 	 	if (ref)  	    htnotify(*ref); 	delete ref;     }      delete docs;     docdb.Close();
     return 0;  }     O //***************************************************************************** " // void htnotify(DocumentRef &ref) // void htnotify(DocumentRef &ref)  { '     char	*date = ref.DocNotification(); !     char	*email = ref.DocEmail();   )     if (date && *date && email && *email)      {  	if (verbose > 1)  	{# 	    cout << "Saw a date:" << endl; ) 	    cout << "Date:    " << date << endl; 1 	    cout << "URL:     " << ref.DocURL() << endl; 5 	    cout << "Subject: " << ref.DocSubject() << endl; * 	    cout << "Email:   " << email << endl; 	    cout << endl; 	}   	int		month, day, year; ) 	if (!parse_date(date, year, month, day))  	{ 	    // Parsing Failed 	    if (verbose > 1)  	    {- 		cout << "Malformed date: " << date << endl;  	    }  D 	    send_notification(date, email, ref.DocURL(), "Malformed Date");   	    if (verbose)  	    {" 		cout << "Message sent." << endl;& 		cout << "Date:    " << date << endl;. 		cout << "URL:     " << ref.DocURL() << endl;, 		cout << "Subject: Malformed Date" << endl;' 		cout << "Email:   " << email << endl;  		cout << endl;  	    } 	    return; 	}   	year -= 1900;	 	month--;    	// ' 	// Compare this date with today's date  	//  	if (year < today->tm_year || 9 	    (year == today->tm_year && month < today->tm_mon) || 9 	    (year == today->tm_year && month == today->tm_mon &&  	     day < today->tm_mday)) 	{ 	    // 9 	    // It seems that this date is either today or before # 	    // today.  Send a notification  	    // D 	    send_notification(date, email, ref.DocURL(), ref.DocSubject()); 	    if (verbose)  	    {" 		cout << "Message sent." << endl;& 		cout << "Date:    " << date << endl;. 		cout << "URL:     " << ref.DocURL() << endl;2 		cout << "Subject: " << ref.DocSubject() << endl;' 		cout << "Email:   " << email << endl;  		cout << endl;  	    } 	} 	else  	{ 	    // Page not yet expired 	    if (verbose)  	    {* 		cout << "htnotify: URL " << ref.DocURL()- 		     << " (" << year+1900 << "-" << month+1 $ 		     << "-" << day << ")" << endl; 	    } 	}     }  }     O //***************************************************************************** L // void send_notification(char *date, char *email, char *url, char *subject) //I void send_notification(char *date, char *email, char *url, char *subject)  {  #ifdef __VMS     char4       pers_from[] = "ht://Dig Notification Service",       to_user[NAM$C_MAXRSS],!       subject_line[NAM$C_MAXRSS],        tmpfile[NAM$C_MAXRSS];
     itmlst       begin_itmlst[] = {9           {0, MAIL$_SEND_PERS_NAME , pers_from   , NULL},            NOSIGNAL_ITEM,           END_ITEM       },       address_itmlst[] = {9           {0, MAIL$_SEND_USERNAME  , to_user     , NULL},            NOSIGNAL_ITEM,           END_ITEM       },       attribute_itmlst[] = {9           {0, MAIL$_SEND_TO_LINE   , to_user     , NULL}, 9           {0, MAIL$_SEND_SUBJECT   , subject_line, NULL},            NOSIGNAL_ITEM,           END_ITEM       },       bodypart_itmlst[] = { 9           {0, MAIL$_SEND_FILENAME  , tmpfile     , NULL},            NOSIGNAL_ITEM,           END_ITEM       },        nulllist[] = { END_ITEM };     unsigned int context = 0;   6     begin_itmlst[0].buffer_length = strlen(pers_from);D     _chkvmssts( mail$send_begin(&context, begin_itmlst, nulllist) );  :     /* Get the destination(s) and add it to the message */     String	em = email;     String	to = ""; /     char	*token = strtok(em.get(), " ,\t\r\n");      while (token) {        if (*token) { 2         strncpy(to_user, token, NAM$C_MAXRSS - 1);:         address_itmlst[0].buffer_length = strlen(to_user);P         _chkvmssts( mail$send_add_address(&context, address_itmlst, nulllist) );         if (to.length())           to << ", ";          to << token;       } $       token = strtok(0, " ,\t\r\n");     }        /* Displayed TO: line */+     strncpy(to_user, to, NAM$C_MAXRSS - 1); 8     attribute_itmlst[0].buffer_length = strlen(to_user);  ?     /* Get the subject line and add it to the message header */      if (!subject || !*subject)       subject = "page expired"; 3     sprintf(subject_line, "WWW notification: %.*s", B             NAM$C_MAXRSS-strlen("WWW notification: ")-1, subject);>     attribute_itmlst[1].buffer_length  = strlen(subject_line);P     _chkvmssts( mail$send_add_attribute(&context, attribute_itmlst, nulllist) );  *     /* Write the message to send to a file3        and add it to the bodypart of the message */ $     char *tmpdir = getenv("TMPDIR");     if (!tmpdir || !*tmpdir)       tmpdir = "SYS$SCRATCH:";*     char *file = tempnam(tmpdir, "htntf");%     sprintf(tmpfile, "%s.TMP", file);      free(file);      FILE *fileptr;2     if ( (fileptr = fopen(tmpfile, "w")) == NULL )     {        perror("fopen");
       return;      }        String	out; ,     out << "From: \"" << pers_from << "\" <") 	  << config["htnotify_sender"] << ">\n"; <     out << "Subject: WWW notification: " << subject << '\n';&     out << "To: " << to.get() << '\n';=     out << "Reply-To: " << config["htnotify_sender"] << "\n";      out << "\n";G     out << "The following page was tagged to notify you after " << date  	  << '\n';      out << "\n";&     out << "URL:     " << url << '\n';'     out << "Date:    " << date << '\n'; *     out << "Subject: " << subject << '\n';(     out << "Email:   " << email << '\n';     out << "\n";M     out << "Note: This message will be sent again if you do not change or\n"; L     out << "take away the notification of the above mentioned HTML page.\n";     out << "\n";A     out << "Find out more about the notification service at\n\n"; 4     out << "    http://www.htdig.org/meta.html\n\n";8     out << "Cheers!\n\nht://Dig Notification Service\n";        fputs( out.get(), fileptr );     fclose( fileptr );  7     bodypart_itmlst[0].buffer_length = strlen(tmpfile); N     _chkvmssts( mail$send_add_bodypart(&context, bodypart_itmlst, nulllist) );       /* Send the message */B     _chkvmssts( mail$send_message(&context, nulllist, nulllist) );  /     /* Done processing with the SEND context */ >     _chkvmssts( mail$send_end(&context, nulllist, nulllist) );       remove(tmpfile); #else      String	command = SENDMAIL;B     command << " -t -F '\"ht://Dig Notification Service\"' -f \"";0     command << config["htnotify_sender"] << '"';       String	em = email;     String	to = ""; /     char	*token = strtok(em.get(), " ,\t\r\n");      while (token)      {  	if (*token) 	{ 	    if (to.length()) 
 		to << ", ";  	    to << token;  	} 	token = strtok(0, " ,\t\r\n");      }   F // Before we use the email address string, we may want to sanitize it.: //    static char ok_chars[] = "abcdefghijklmnopqrstuvwxyz  //    ABCDEFGHIJKLMNOPQRSTUVWXYZ //    1234567890_-.@/=+:%!, ";: //    char *cursor;          // cursor into email address E //    for (cursor = to.get(); *(cursor += strspn(cursor, ok_chars));) 6 //      *cursor = '_'; // Set it to something harmless          FILE *fileptr;:     if ( (fileptr = popen(command.get(), "w")) != NULL ) {          if (!subject || !*subject) 	subject = "page expired";       String	out; 8       out << "From: \"ht://Dig Notification Service\" <") 	  << config["htnotify_sender"] << ">\n"; >       out << "Subject: WWW notification: " << subject << '\n';(       out << "To: " << to.get() << '\n';?       out << "Reply-To: " << config["htnotify_sender"] << "\n";        out << "\n";I       out << "The following page was tagged to notify you after " << date  	  << '\n';        out << "\n";(       out << "URL:     " << url << '\n';)       out << "Date:    " << date << '\n'; ,       out << "Subject: " << subject << '\n';*       out << "Email:   " << email << '\n';       out << "\n";O       out << "Note: This message will be sent again if you do not change or\n"; N       out << "take away the notification of the above mentioned HTML page.\n";       out << "\n";C       out << "Find out more about the notification service at\n\n"; 6       out << "    http://www.htdig.org/meta.html\n\n";:       out << "Cheers!\n\nht://Dig Notification Service\n";  "       fputs( out.get(), fileptr );       pclose( fileptr );     } else {       perror( "popen" );     }  #endif }     O //***************************************************************************** 5 // Display usage information for the htnotify program  // void usage() { <     cout << "usage: htnotify [-c configfile][-b db_base]\n";E     cout << "This program is part of ht://Dig " << VERSION << "\n\n"; 2     cout << "There can be any number or words.\n";     cout << "Options:\n";       cout << "\t-c configfile\n";S     cout << "\t\tUse the specified configuration file instead of the default.\n\n";      cout << "\t-b db_base\n"; @     cout << "\t\tSet the base path of the document database.\n";     cout << "\t-v\n"; 7     cout << "\t\tIncrease the verbose level by one.\n";      exit(0); }     O //***************************************************************************** > // Parse the notification date string from the user's document //; int parse_date(char *date, int &year, int &month, int &day)  { &     int		mm = -1, dd = -1, yy = -1, t;     String	scandate = date;   +     for (char *s = scandate.get(); *s; s++)  	if (ispunct(*s))  	    *s = ' ';  #     if (config.Boolean("iso_8601"))      { = 	// conf file specified ISO standard, so expect [yy]yy mm dd. 1 	sscanf(scandate.get(), "%d%d%d", &yy, &mm, &dd);      }      else     { < 	// Default to American standard when not specified in conf, 	// so expect mm dd [yy]yy. 1 	sscanf(scandate.get(), "%d%d%d", &mm, &dd, &yy); % 	if (mm > 31 && dd <= 12 && yy <= 31)  	{3 	    // probably got yyyy-mm-dd instead of mm/dd/yy & 	    t = mm; mm = dd; dd = yy; yy = t; 	}     }   F     // OK, we took our best guess at the order the y, m & d should be.F     // Now let's see if we guessed wrong, and fix it.  This won't workF     // for ambiguous dates (e.g. 01/02/03), which must be given in the     // expected format.      if (dd > 31 && yy <= 31)     {  	t = yy; yy = dd; dd = t;      }      if (mm > 31 && yy <= 31)     {  	t = yy; yy = mm; mm = t;      }      if (mm > 12 && dd <= 12)     {  	t = dd; dd = mm; mm = t;      } 9     if (yy < 0 || mm < 1 || mm > 12 || dd < 1 || dd > 31)  	return 0;		// Invalid date   &     if (yy < 70)		// before UNIX Epoch 	yy += 2000;/     else if (yy < 1900)		// before computer age  	yy += 1900;     if (verbose > 1)G 	cout << "Date used (y-m-d): " << yy << '-' << mm << '-' << dd << endl;        year = yy;     month = mm; 
     day = dd;   
     return 1;  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       