/************************************************************************
 *   IRC - Internet Relay Chat, contrib/m_nickinfo.c
 *   Copyright (C) 1990 Jarkko Oikarinen and
 *                      University of Oulu, Computing Center
 *
 *   See file AUTHORS in IRC package for additional names of
 *   the programmers. 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Id: m_nickinfo.c,v 1.5 2001/05/16 08:50:56 toot Exp $
 */
#include "handlers.h"
#include "client.h"
#include "fdlist.h"
#include "irc_string.h"
#include "ircd.h"
#include "numeric.h"
#include "s_conf.h"
#include "s_stats.h"
#include "s_user.h"
#include "hash.h"
#include "whowas.h"
#include "s_serv.h"
#include "send.h"
#include "list.h"
#include "channel.h"
#include "s_log.h"
#include "msg.h"
#include "parse.h"
#include "modules.h"

#include <stdlib.h>
#include <string.h>
#include <assert.h>

static void mo_nickinfo(struct Client*, struct Client*, int, char**);


struct Message nickinfo_msgtab = {
  "NICKINFO", 0, 1, 0, MFLG_SLOW, 0,
  {m_unregistered, m_ignore, m_ignore, mo_nickinfo}
};

void
_modinit(void)
{
  mod_add_cmd(&nickinfo_msgtab);
}

void
_moddeinit(void)
{
  mod_del_cmd(&nickinfo_msgtab);
}

char *_version = "20000105";


/*
 * mo_nickinfo
 *      parv[0] = sender prefix
 *      parv[1] = nickname
 *
 */

static void mo_nickinfo(struct Client *client_p, struct Client *source_p,
                        int parc, char *parv[])
{
  char     nick[NICKLEN + 2];
  struct   Client *target_p;

  if (parc < 2)
    {
      sendto_one(source_p, form_str(ERR_NONICKNAMEGIVEN),
                 me.name, parv[0]);
      return;
    }

  /*
   * nick is an auto, need to terminate the string
   */
  strncpy_irc(nick, parv[1], NICKLEN);
  nick[NICKLEN] = '\0';

  /*
   * if clean_nick_name() its bad.
   */
  if (clean_nick_name(nick) == 0)
    {
      sendto_one(source_p, form_str(ERR_ERRONEUSNICKNAME),
                 me.name, parv[0], nick);
      return;
    }

  if ((target_p = find_client(nick, NULL)))
    {
      if(HasID(target_p))
	{
	  sendto_one(source_p,":%s NOTICE %s :%s ID [%s]",
		     me.name,source_p->name, target_p->name, target_p->user->id);
	}
      sendto_one(source_p,":%s NOTICE %s :%s TimeStamp %lu",
		 me.name, source_p->name, target_p->name, target_p->tsinfo);
    }
}
