/*
** cmd.c - Getting and decoding commands
*/

#include stdio
#include stdlib
#include string

#define __NEW_STARLET 1
#include ssdef
#include stsdef
#include descrip
#include climsgdef

#if __CRTL_VER >= 60000000
#include cli$routines
#else
unsigned int cli$dcl_parse();
unsigned int cli$dispatch();
unsigned int cli$get_value();
unsigned int cli$present();
#endif

#include "loa.h"


#ifdef __DECC
#  pragma message disable (NEEDCONSTEXT,ADDRCONSTEXT)
#endif


#define chkvmssts(sts)                                     \
  {                                                        \
    ULONG local_sts = (sts);                               \
    if (! $VMS_STATUS_SUCCESS(local_sts))                  \
    {                                                      \
      fprintf( stderr, "Fatal VMS error at %s, line %d\n", \
               __FILE__, __LINE__ );                       \
      exit( local_sts );                                   \
    }                                                      \
  }


typedef struct dsc$descriptor_vs VS_DSC;

#define VS_STRING(name,maxlen) \
  struct                       \
  {                            \
    UWORD  length;             \
    char   body[maxlen];       \
    VS_DSC dsc;                \
  } name = { 0, "", { maxlen, DSC$K_DTYPE_VT, DSC$K_CLASS_VS, (char*)&name.length } }

#ifdef __ALPHA
#  define f_edit dbasic$edit
#else
#  define f_edit bas$edit
#endif

extern ULONG f_edit( VS_DSC *target, VS_DSC *source, ULONG flags );

#define EDIT_DISCARD_PARITY (1<<0) /* Discards bit 7 */
#define EDIT_COLLAPSE       (1<<1) /* Discards spaces and tabs */
#define EDIT_DISCARD_FORMS  (1<<2) /* Discards cr, lf, ff, del, esc and nul */
#define EDIT_TRIM           (1<<3) /* Discards leading and trailing spaces and tabs */
#define EDIT_COMPRESS       (1<<4) /* Compresses multiple spaces and tabs to single spaces */
#define EDIT_UPCASE         (1<<5) /* Converts lowercase to uppercase */
#define EDIT_UNBRACKET      (1<<6) /* Converts [ and ] to ( and ) */
#define EDIT_TRAIL          (1<<7) /* Discards trailing spaces and tabs */
#define EDIT_QUOTE          (1<<8) /* Preserves characters within quotes */


int is_position( char *str, POSITION *pos )
{
	if (strlen(str) >= 2 &&
	    (str[0] >= 'A' && str[0] <= 'H') &&
	    (str[1] >= '1' && str[1] <= '8'))
	{
		pos->col = str[0] - 'A';
		pos->row = '8' - str[1];
		return 1;
	}

	return 0;
}


ULONG cmd_move( COMMAND *command )
{
	$DESCRIPTOR( from_dsc, "FROM" );
	$DESCRIPTOR( to_dsc, "TO" );
	char place[10];
	$DESCRIPTOR( place_dsc, place );
	UWORD retlen;
	ULONG sts;

	if (cli$present( &from_dsc ) == CLI$_ABSENT)
		return CLI$_VALREQ;
	sts = cli$get_value( &from_dsc, &place_dsc, &retlen );
	if (sts != SS$_NORMAL)
		return sts;
	if (retlen >= 10)
		return CLI$_STRTOOLNG;
	place[retlen] = '\0';
	if (!is_position( place, &command->param.move.from ))
		return SS$_BADPARAM;

	if (cli$present( &to_dsc ) == CLI$_ABSENT)
		return CLI$_VALREQ;
	sts = cli$get_value( &to_dsc, &place_dsc, &retlen );
	if (sts != SS$_NORMAL)
		return sts;
	if (retlen >= 10)
		return CLI$_STRTOOLNG;
	place[retlen] = '\0';
	if (!is_position( place, &command->param.move.to ))
		return SS$_BADPARAM;

	command->cmd = CMD_MOVE;
	return CLI$_NORMAL;
}

ULONG cmd_takeback( COMMAND *command )
{
	command->cmd = CMD_TAKEBACK;
	return CLI$_NORMAL;
}

ULONG cmd_savegame( COMMAND *command )
{
	$DESCRIPTOR( file_dsc, "FILE" );
	$DESCRIPTOR( value_dsc, command->param.savegame.filename );
	UWORD retlen;
	ULONG sts;

	sts = cli$get_value( &file_dsc, &value_dsc, &retlen );
	if (sts != SS$_NORMAL)
		return sts;
	if (retlen >= PATH_MAX)
		return CLI$_STRTOOLNG;
	command->param.savegame.filename[retlen] = '\0';

	/* check for wildcards, and in that case return error */

	command->cmd = CMD_SAVEGAME;
	return CLI$_NORMAL;
}

ULONG cmd_replay( COMMAND *command )
{
	$DESCRIPTOR( file_dsc, "FILE" );
	$DESCRIPTOR( value_dsc, command->param.replay.filename );
	UWORD retlen;
	ULONG sts;

	sts = cli$get_value( &file_dsc, &value_dsc, &retlen );
	if (sts != SS$_NORMAL)
		return sts;
	if (retlen >= PATH_MAX)
		return CLI$_STRTOOLNG;
	command->param.replay.filename[retlen] = '\0';

	/* check for wildcards, and in that case find file */

	command->cmd = CMD_REPLAY;
	return CLI$_NORMAL;
}

ULONG cmd_redraw( COMMAND *command )
{
	command->cmd = CMD_REDRAW;
	return CLI$_NORMAL;
}

ULONG cmd_newgame( COMMAND *command )
{
	command->cmd = CMD_NEWGAME;
	return CLI$_NORMAL;
}

ULONG cmd_set( COMMAND *command )
{
	return CLI$_IVKEYW;
}

ULONG cmd_setcomp( COMMAND *command )
{
	$DESCRIPTOR( side_dsc, "SIDE" );
	$DESCRIPTOR( level_dsc, "LEVEL" );
	$DESCRIPTOR( show_dsc, "SHOW_COMPUTATION" );
	char value[MAX_INPUT_LEN];
	$DESCRIPTOR( value_dsc, value );
	UWORD retlen;
	ULONG sts;

	command->param.setcomp.side  = (COLOR)-1;
	command->param.setcomp.level = -1;
	command->param.setcomp.show  = -1;

	if (cli$present( &side_dsc ) != CLI$_ABSENT)
	{
		sts = cli$get_value( &side_dsc, &value_dsc, &retlen );
		if (sts != SS$_NORMAL)
			return sts;
		/*
		if (retlen >= MAX_INPUT_LEN)
			return CLI$_STRTOOLNG;
		value[retlen] = '\0';
		*/

		     if (strncmp( value, "WH", 2 ) == 0) command->param.setcomp.side = WHITE;
		else if (strncmp( value, "BL", 2 ) == 0) command->param.setcomp.side = BLACK;
		else if (strncmp( value, "NO", 2 ) == 0) command->param.setcomp.side = NONE;
		else if (strncmp( value, "BO", 2 ) == 0) command->param.setcomp.side = BOTH;
		else return CLI$_IVKEYW;
	}

	if (cli$present( &level_dsc ) != CLI$_ABSENT)
	{
		sts = cli$get_value( &level_dsc, &value_dsc, &retlen );
		if (sts != SS$_NORMAL)
			return sts;
		/*
		if (retlen >= MAX_INPUT_LEN)
			return CLI$_STRTOOLNG;
		value[retlen] = '\0';
		*/

		     if (value[0] == 'L') command->param.setcomp.level = 1;
		else if (value[0] == 'M') command->param.setcomp.level = 2;
		else if (value[0] == 'H') command->param.setcomp.level = 3;
		else if (value[0] == 'V') command->param.setcomp.level = 5;
		else return CLI$_IVKEYW;
	}

	switch( sts = cli$present( &show_dsc ) )
	{
		case CLI$_ABSENT :
		case CLI$_NEGATED :
		case CLI$_LOCNEG :
			command->param.setcomp.show = FALSE;
			break;

		case CLI$_PRESENT :
		case CLI$_LOCPRES :
			command->param.setcomp.show = TRUE;
			break;

		default :
			return sts;
	}

	command->cmd = CMD_SETCOMP;
	return CLI$_NORMAL;
}

ULONG cmd_exit( COMMAND *command )
{
	command->cmd = CMD_EXIT;
	return CLI$_NORMAL;
}

ULONG cmd_help( COMMAND *command )
{
	$DESCRIPTOR( topic_dsc, "TOPIC" );
	$DESCRIPTOR( value_dsc, command->param.help.topic );
	UWORD retlen;
	ULONG sts;

	if (cli$present( &topic_dsc ) == CLI$_ABSENT)
	{
		command->param.help.topic[0] = '\0';
	}
	else
	{
		sts = cli$get_value( &topic_dsc, &value_dsc, &retlen );
		if (sts != SS$_NORMAL)
			return sts;
		if (retlen >= MAX_INPUT_LEN-sizeof("LOA "))
			return CLI$_STRTOOLNG;
		command->param.help.topic[retlen] = '\0';
	}

	command->cmd = CMD_HELP;
	return CLI$_NORMAL;
}

ULONG cmd_nop( COMMAND *command )
{
	command->cmd = CMD_NOP;
	return CLI$_NORMAL;
}


static ULONG parse_cmd( char *cmdstr, COMMAND *command )
{
	extern void *command_table; /* from COMMAND_TABLE.OBJ */
	$DESCRIPTOR( cmd_dsc, cmdstr );
	ULONG sts;

	command->cmd = CMD_ERROR;

	cmd_dsc.dsc$w_length = strlen( cmdstr );

	sts = cli$dcl_parse( &cmd_dsc, &command_table, NULL, NULL, NULL );
	if ($VMS_STATUS_SUCCESS( sts ))
		sts = cli$dispatch( command );
	return sts;
}


void decode_command( char *cmdstr, COMMAND *command )
{
	VS_STRING( line, MAX_INPUT_LEN-1 );
	VS_STRING( line2, MAX_INPUT_LEN-1 );

	if (cmdstr == NULL || *cmdstr == '\0')
	{
		command->cmd = CMD_NOP;
		return;
	}

	strcpy( line.body, cmdstr );
	line.length = strlen( line.body );
	chkvmssts( f_edit( &line2.dsc, &line.dsc, EDIT_UPCASE|EDIT_TRIM|EDIT_COMPRESS ) );

	/* Special treatment for MOVE without MOVE command */
	if (is_position( line2.body, &command->param.move.from ) && strlen( line2.body ) >= 4)
	{
		int offset = (strchr(" -:X", line2.body[2]) != NULL) ? 1 : 0;
		if (is_position( &line2.body[2+offset], &command->param.move.to ))
			command->cmd = CMD_MOVE;
		else
			command->cmd = CMD_ERROR;
	}
	else
	{
		parse_cmd( line2.body, command );
	}
}
