#
# descrip.mms for LOA
#
# This should be called with the appropriate value for the PLATFORM
# macro, e.g. MMS /MACRO=(PLATFORM=AXP). With the default setting
# for the bindir macro, a sub-directory named [.bin$(PLATFORM)]
# must be created.
#

.ifdef PLATFORM
.else
PLATFORM =
.endif

VERSION = v0.83
VERSION_US = 0_83

srcdir = []
bindir = [.bin$(PLATFORM)]
lisdir = []

CC = CC/DECC

.ifdef DEBUG
CDEB = /DEBUG/NOOPTIMIZE/LIST=$(lisdir)
LDEB = /DEBUG/MAP=$(lisdir)/CROSS_REFERENCE
CDEF = /DEFINE=(DEBUG)
.else
CDEB = 
LDEB = 
CDEF = 
.endif

CFLAGS    = /OBJECT=$(MMS$TARGET) /INCLUDE=($(srcdir)) $(CDEF) $(CDEB)
LINKFLAGS = /EXECUTABLE=$(MMS$TARGET) $(LDEB)

src = $(srcdir)main.c, $(srcdir)game.c, $(srcdir)comp.c, -
      $(srcdir)sio_smg.c, $(srcdir)cmd.c, $(srcdir)command_table.cld

obj = $(bindir)main.obj, $(bindir)game.obj, $(bindir)comp.obj, -
      $(bindir)sio_smg.obj, $(bindir)cmd.obj, $(bindir)command_table.obj

.c.obj :
	$(CC) $(CFLAGS) $(MMS$SOURCE)

.cld.obj :
	SET COMMAND /OBJECT=$(MMS$TARGET) $(MMS$SOURCE)

.hlp.hlb :
	IF F$SEARCH("$(MMS$TARGET)").EQS."" THEN LIBRARY/CREATE/HELP $(MMS$TARGET)
	LIBRARY/REPLACE $(MMS$TARGET) $(MMS$SOURCE)

all : $(bindir)loa.exe, $(bindir)loa_help.hlb
	@ WRITE SYS$OUTPUT "All made."

$(bindir)loa.exe : $(obj)
	$(LINK) $(LINKFLAGS) $(obj)

$(bindir)loa_help.hlb : $(srcdir)loa_help.hlp

$(bindir)main.obj : $(srcdir)main.c, $(srcdir)loa.h
$(bindir)game.obj : $(srcdir)game.c, $(srcdir)loa.h
$(bindir)comp.obj : $(srcdir)comp.c, $(srcdir)loa.h
$(bindir)sio_smg.obj : $(srcdir)sio_smg.c, $(srcdir)loa.h, $(srcdir)version.h
$(bindir)cmd.obj : $(srcdir)cmd.c, $(srcdir)loa.h
$(bindir)command_table.obj : $(srcdir)command_table.cld

$(srcdir)version.h : descrip.mms
	OPEN/WRITE version_h $(MMS$TARGET)
	WRITE version_h "#define VERSION ""$(VERSION)"""
	CLOSE version_h

purge :
	- PURGE [...]
	- RENAME [...]*.*;/EXCLUDE=*.DIR ;1

clean :
	IF F$SEARCH("$(bindir)*.obj").NES."" THEN DELETE $(bindir)*.obj;*
	IF F$SEARCH("$(lisdir)*.lis").NES."" THEN DELETE $(lisdir)*.lis;*
	IF F$SEARCH("$(lisdir)*.map").NES."" THEN DELETE $(lisdir)*.map;*

distclean : clean, purge
	IF F$SEARCH("$(srcdir)version.h").NES."" THEN DELETE $(srcdir)version.h;*

realclean : distclean
	IF F$SEARCH("$(bindir)loa.exe").NES."" THEN DELETE $(bindir)loa.exe;*
	IF F$SEARCH("$(bindir)loa_help.hlb").NES."" THEN DELETE $(bindir)loa_help.hlb;*

bindist : all
	- ZIP "-Vj9" sys$login:loa-$(VERSION_US)-bin$(PLATFORM).zip -
	  $(bindir)loa.exe $(bindir)loa_help.hlb

srcdist :
	- ZIP -j9 sys$login:loa-$(VERSION_US)-src.zip -
	  $(srcdir)*.c $(srcdir)*.h -
	  $(srcdir)*.cld $(srcdir)*.hlp -
	  $(srcdir)descrip.mms

dist : realclean, bindist, srcdist
	@ !
