#!/usr/bin/perl
#
#  A simple program to list the installed DBD drivers and their
#  data sources. For ODBC drivers all the supported functions
#  and data types are listed.
#
#
#  Cannot use strict or we cannot use the ODBC extended fucntions.
#  use strict;
#
use DBI;
use DBI qw(:sql_types);

my @drivers;			# list of drivers
my $drv;			# current driver
my $name, $type, $size, $localname, $sqltype; # vars for formatting

#
# Get a list of drivers
#
@drivers = DBI->available_drivers;
print DBI::neat_list(\@drivers), "\n\n";

#
# Loop through each driver getting a list of DSNs and for ODBC driver
# used odbcd() to ferret out more information.
#
foreach $drv (@drivers)
{
    my @dsns;			# list of DSNs for this driver
    my $dsn;			# current dsn

    print "Driver = ", $drv, "\n";
    if ($drv eq "Proxy")
    {
        print "Not listing DSNs for ", $drv, " as it may not be installed\n";
    }
    else
    {
        @dsns = DBI->data_sources($drv);
	foreach $dsn (@dsns)
        {
	    print "\t", $dsn, "\n";
            if ($drv eq "ODBC") 
            {
                &odbcd($dsn);
            }
        }
        print "\n\n";
    }
}

#
# Called once per ODBC driver to display a list of the ODBC functions
# (only ODBC 2.0 function as DBD::ODBC does not support 
# SQL_API_ODBC3_ALL_FUNCTIONS yet) and a list of the data types supported 
# by this driver.
#
sub odbcd
{
    my $this_dsn;		# DSN to use
    my @functions;		# ODBC functions supported
    my $dbh;			# database handle
    my $sth;			# statement handle
    my %fncodes = (		# Function ID -> name mapping
		1, "SQLAllocConnect",
		2, "SQLAllocEnv", 
		3, "SQLAllocStmt",
		4, "SQLBindCol",
		5, "SQLCancel", 
		6, "SQLColAttributes",
		7, "SQLConnect",
		8, "SQLDescribeCol",
		9, "SQLDisconnect",
		10, "SQLError",
		11, "SQLExecDirect",
		12, "SQLExecute",
		13, "SQLFetch",
		14, "SQLFreeConnect",
		15, "SQLFreeEnv",
		16, "SQLFreeStmt",
		17, "SQLGetCursorName",
		18, "SQLNumResultCols",
		19, "SQLPrePare",
		20, "SQLRowCount",
		21, "SQLSetCursorName",
		22, "SQLSetParam",
		23, "SQLTransact",
		40, "SQLColumns",
		42, "SQLGetConnectOption",
		43, "SQLGetData",
		44, "SQLGetFunctions",
		45, "SQLGetInfo",
		46, "SQLGetStmtOption",
		47, "SQLGetTypeInfo",
		48, "SQLParamData",
		49, "SQLPutData",
		50, "SQLSetConnectOption",
		51, "SQLSetStmtOption",
		52, "SQLSpecialColumns",
		53, "SQLStatistics",
		54, "SQLTables",
		55, "SQLBrowseConnect",
		56, "SQLColumnPrivileges",
		57, "SQLDataSources",
		58, "SQLDescribeParam",
		59, "SQLExtendedFetch",
		60, "SQLForeignKeys",
		61, "SQLMoreResults",
		62, "SQLNativeSql",
		63, "SQLNumParams",
		64, "SQLParamOptions",
		65, "SQLPrimaryKeys",
		66, "SQLProcedureColumns",
		67, "SQLProcedures",
		68, "SQLSetPos",
		69, "SQLSetScrollOptions",
		70, "SQLTablePrivileges");

    $this_dsn = shift;

    $dbh = DBI->connect($this_dsn);
    if ($dbh)
    {
        @functions = $dbh->func(SQL_API_ALL_FUNCTIONS, GetFunctions);
        #print "\t", DBI::neat_list(\@functions), "\n\n";

        foreach $key (sort numerically keys %fncodes)
        {
	    if (@functions[$key])
	    {
		print $fncodes{$key}, " ";
            }
        }
	print "\n";

	$sth = $dbh->func(SQL_ALL_TYPES, GetTypeInfo);
	if ($sth)
	{
	    my @row;

	    $~ = TYPEINFO;
	    while(@row = $sth->fetchrow_array)
	    {
		#print DBI::neat_list(\@row), "\n";
		($name,$type,$size,$localname,$sqltype) =
		    (@row[0], @row[1], @row[2], @row[12], @row[15]);
		write;
	    }
	    $~ = STDOUT;
	}
    } 
}

#
# Sort numerically rather than alphabetically
#
sub numerically { $a <=> $b;}

#
# Various formats
#
format TYPEINFO_TOP =

Name                 type       size       LocalName                SQLType
---------------------------------------------------------------------------
.
format TYPEINFO =
@<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<@<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<@<<<<<<
$name,               $type,     $size,     $localname,          $sqltype
.




